/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Busy;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchccPathDefModel;
import cerent.cms.model.OchncPathDefModel;
import cerent.cms.model.PathInUse;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.topo.INetElement;
import cerent.util.SDebug;

public class OchccCircuitEnd
extends NetCircuitEnd {
    private static SDebug db = new SDebug("OchccCircuitEnd");

    public OchccCircuitEnd() {
    }

    public OchccCircuitEnd(INodeModel iNodeModel, ICircuitEnd iCircuitEnd) {
        super(iNodeModel, iCircuitEnd);
    }

    public OchccCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        super(iNetCircuitEnd);
    }

    public OchccCircuitEnd(INetElement iNetElement, Object object) {
        int n = 0;
        INodeModel iNodeModel = iNetElement.getNodeModel();
        int n2 = 0;
        if (object instanceof IOchccPathDefModel) {
            IOchccPathDefModel iOchccPathDefModel = (IOchccPathDefModel)object;
            n = iOchccPathDefModel.getPortEntityIdx();
            if (this.dbgOn()) {
                db.println("OchccCircuitEnd ctor with path: port = " + Integer.toHexString(n));
            }
            n2 = 4;
        } else if (this.dbgOn()) {
            db.println("Warning! OchccCircuitEnd constructor unknown object type");
        }
        this.setCircuitEnd(new CircuitEnd(iNodeModel.getNodeId(), n, null, null, false, 0));
        this.setStage(n2);
    }

    public Object getPathDef(short s) throws ObjNotFound, PathInUse, InvalidPath {
        if (this.dbgOn()) {
            db.println("getPathDef: EntIdx " + Integer.toHexString(this.getEntityIndex()) + " on " + this.getNodeModel().getName());
        }
        CircuitId circuitId = new CircuitId(this.getNodeModel().getNodeId(), 0);
        IOchTrailAditModel iOchTrailAditModel = this.getOchTrailAdit();
        if (iOchTrailAditModel == null) {
            block9: {
                try {
                    iOchTrailAditModel = this.createOchTrailAdit(circuitId, s);
                    if (this.dbgOn()) {
                        this.debug("OchccCircuitEnd: auto-created OchTrailAdit on " + this.getNodeModel().getName() + " EntIdx " + Integer.toHexString(this.getEntityIndex()));
                    }
                }
                catch (InvalidState invalidState) {
                    if (!this.dbgOn()) break block9;
                    this.debug("OchccCircuitEnd: unable to create OchTrailAdit, InvalidState");
                }
            }
            if (iOchTrailAditModel == null) {
                if (this.dbgOn()) {
                    this.debug("OchccCircuitEnd: unable to create OchTrailAdit");
                }
                throw new ObjNotFound("unable to find OchTrailAdit model");
            }
        } else if (this.dbgOn()) {
            this.debug("OchccCircuitEnd: found an auto-created OchTrail idx: " + iOchTrailAditModel.getObjIndex());
        }
        OchccPathDefModel ochccPathDefModel = new OchccPathDefModel(this.getNodeModel(), iOchTrailAditModel, this.getEntityIndex(), s);
        return ochccPathDefModel;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof OchccCircuitEnd) {
            OchccCircuitEnd ochccCircuitEnd = (OchccCircuitEnd)object;
            bl = ochccCircuitEnd.getCircuitEnd().getNodeId() == this.getCircuitEnd().getNodeId() && ochccCircuitEnd.getCircuitEnd().getPortNum() == this.getCircuitEnd().getPortNum();
        }
        return bl;
    }

    private IOchTrailAditModel createOchTrailAdit(ICircuitId iCircuitId, int n) throws PathInUse, InvalidPath, InvalidState {
        IOchncPathDefModel[] iOchncPathDefModelArray;
        IConnectionModels iConnectionModels = this.getNodeModel().getConnectionModels();
        iOchncPathDefModelArray = new IOchncPathDefModel[]{new OchncPathDefModel(this.getNodeModel(), 0, this.getEntityIndex(), (short)n), iOchncPathDefModelArray[0]};
        return iConnectionModels.createOchTrailAdit(iCircuitId, iOchncPathDefModelArray, 3);
    }

    private IOchTrailAditModel getOchTrailAdit() {
        IOchTrailAditModel iOchTrailAditModel = null;
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel == null) {
            return null;
        }
        IOchTrailAditModel[] iOchTrailAditModelArray = iNodeModel.getConnectionModels().getOchTrailAditModels();
        if (iOchTrailAditModelArray != null) {
            for (int i = 0; i < iOchTrailAditModelArray.length; ++i) {
                try {
                    iOchTrailAditModel = iOchTrailAditModelArray[i];
                    if (iOchTrailAditModel != null && iOchTrailAditModel.getPaths()[0].getPortEntityIdx() == this.getEntityIndex()) {
                        return iOchTrailAditModel;
                    }
                    continue;
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public void cleanupOchTrailAdit() {
        block8: {
            IOchTrailAditModel iOchTrailAditModel = this.getOchTrailAdit();
            if (iOchTrailAditModel == null) {
                if (this.dbgOn()) {
                    this.debug("cleanupOchTrailAdit: OchTrailAdit on " + this.getNodeModel().getName() + " EntIdx " + Integer.toHexString(this.getEntityIndex()) + " NOT found - assume deleted");
                }
                return;
            }
            try {
                ICircuitId iCircuitId = iOchTrailAditModel.getCircuitId();
                if (iCircuitId.getUniquePart().getUniqueId() != 0) {
                    return;
                }
                if (this.dbgOn()) {
                    this.debug("cleanupOchTrailAdit: destroying OchTrailAdit on " + this.getNodeModel().getName() + " EntIdx " + Integer.toHexString(this.getEntityIndex()));
                }
                iOchTrailAditModel.localDestroy();
            }
            catch (Busy busy) {
                if (this.dbgOn()) {
                    this.debug("cleanupOchTrailAdit: OchTrailAdit in use");
                }
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (!this.dbgOn()) break block8;
                this.debug("cleanupOchTrailAdit: OchTrailAdit object does not exist; Assume deleted");
            }
        }
    }

    public boolean isNodeDrop() {
        return this.getCircuitEnd().getPortNum() == 0;
    }

    public String prettyString() {
        if (this.getNodeModel() == null) {
            return "Unknown::";
        }
        String string = this.getNodeModel().getName() + "::";
        string = string + Integer.toHexString(this.getCircuitEnd().getPortNum()) + "c";
        string = string + " (" + this.getClass().getName() + ")";
        return string;
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    protected void debug(String string) {
        db.println(string);
    }
}

