/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CktInfo;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.ICircuitDirection;
import cerent.cms.model.ICircuitDropInfo;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IPathProtection;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.OchncHelper;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.INetCircuitCreatStage;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitState;
import cerent.cms.ncp.IOchCircuit;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.InternalNetLink;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCcatCircuitRepairer;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.OchTrailTunnelCircuitEnd;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchncCircuitEnd;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.ncp.OchncCircuitSpan;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.TrkAttribOperator;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.NetLinkFactory;
import cerent.cms.topo.Network;
import cerent.cms.ui.Wavelength;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.AnnotatedException;
import cerent.util.EnumStrings;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OchncCircuit
extends NetCcatCircuit
implements IOchCircuit {
    private static final SDebug db = new SDebug("OchncCircuit");
    private NetLink OTTLink;
    private NetLink revOTTLink;
    private INetCircuitEnd[] srcInternalSpliceLinkEnds = null;
    private INetCircuitEnd[] dstInternalSpliceLinkEnds = null;
    private CircuitCreatInfo cktCreatInfo = null;
    private TrkAttribOperator trkAttribOperator = new TrkAttribOperator(db);
    private SplitterInfo splitter;

    protected OchncCircuit(CircuitCreatInfo circuitCreatInfo) {
        super(circuitCreatInfo);
        this.cktCreatInfo = circuitCreatInfo;
    }

    protected OchncCircuit(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        super(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
        this.cktCreatInfo = circuitCreatInfo;
    }

    protected OchncCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement, Object object) {
        super(circuitCreatInfo, iNetElement, object);
        this.cktCreatInfo = circuitCreatInfo;
        this.clearChanged();
    }

    protected OchncCircuit(CircuitCreatInfo circuitCreatInfo, INodeModel iNodeModel, ICircuitModel iCircuitModel) throws AbstractCmsObjectNotExistException {
        this(circuitCreatInfo);
        this.initState(4);
        this.addDiscoveredCircuitInfo(iNodeModel, iCircuitModel);
        this.clearChanged();
    }

    protected OchncCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement) {
        this(circuitCreatInfo);
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(circuitCreatInfo.type(), iNetElement);
        this.circuitInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
        this.insertSource(netCircuitEnd);
        NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd, 2);
        if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            this.srcInternalSpliceLinkEnds = this.fillInternalSpliceLinks(iNetElement, circuitCreatInfo.getSrcTrkPort(), circuitCreatInfo.cktOptChannel());
        }
        if (this.srcInternalSpliceLinkEnds != null) {
            NetCircuitNode netCircuitNode;
            NetCircuitNode netCircuitNode2 = NetCircuitNodeFactory.createOchTrailTunnelCircuitNode(iNetElement, this);
            this.srcCircuitNode = netCircuitNode = NetCircuitNodeFactory.createOchncCircuitNode(iNetElement, this);
            this.insertCktNode(netCircuitNode2);
            this.insertCktNode(netCircuitNode);
            netCircuitNode2.addDropInfo(netCircuitDropInfo);
            netCircuitNode.addDropInfo(netCircuitDropInfo);
            InternalNetLink internalNetLink = new InternalNetLink(netCircuitNode2.getNetElement(), netCircuitNode.getNetElement(), this.srcInternalSpliceLinkEnds[0].getEntityIndex(), this.srcInternalSpliceLinkEnds[1].getEntityIndex(), null, null);
            NetLinkSpan netLinkSpan = new NetLinkSpan(internalNetLink, null, null, null, null);
            NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this, netLinkSpan, netCircuitNode2, netCircuitNode);
            if (this.dbgOn()) {
                this.debug("Created the internal splicing span: OchTrailTunnelNode->OchncNode");
            }
            netCircuitSpan.setSrcState(4);
            netCircuitSpan.setDstState(4);
            netCircuitNode2.addActiveSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
            netCircuitNode.addActiveSpan(netCircuitSpan, eSpanDirection.TERMINATING);
            this.insertCktSpan(netCircuitSpan);
            InternalNetLink internalNetLink2 = new InternalNetLink(netCircuitNode.getNetElement(), netCircuitNode2.getNetElement(), this.srcInternalSpliceLinkEnds[2].getEntityIndex(), this.srcInternalSpliceLinkEnds[0].getEntityIndex(), null, null);
            netLinkSpan = new NetLinkSpan(internalNetLink2, null, null, null, null);
            netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this, netLinkSpan, netCircuitNode, netCircuitNode2);
            if (this.dbgOn()) {
                this.debug("Created the internal splicing span: OchncNode->OchTrailTunnelNode");
            }
            netCircuitSpan.setSrcState(4);
            netCircuitSpan.setDstState(4);
            netCircuitNode.addActiveSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
            netCircuitNode2.addActiveSpan(netCircuitSpan, eSpanDirection.TERMINATING);
            this.insertCktSpan(netCircuitSpan);
        } else {
            this.srcCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement, this);
            this.insertCktNode(this.srcCircuitNode);
            this.srcCircuitNode.addDropInfo(netCircuitDropInfo);
        }
        this.setSrcNodeModel(iNetElement.getNodeModel());
        this.insertCktNode(this.srcCircuitNode);
        this.srcCircuitNode.addDropInfo(netCircuitDropInfo);
    }

    @Override
    protected synchronized void dispose() {
        super.dispose();
        if (this.splitter != null) {
            this.splitter.dispose();
        }
    }

    @Override
    public TrkAttribOperator getTrkAttribOperator() {
        return this.trkAttribOperator;
    }

    @Override
    public INetCircuitEnd[] fillInternalSpliceLinks(INetElement iNetElement, int n, int n2) {
        INetCircuitEnd[] iNetCircuitEndArray;
        block9: {
            iNetCircuitEndArray = null;
            try {
                int[] nArray = OchTrailHelper.getColocatedOchPorts(iNetElement, n);
                if (nArray != null && nArray.length == 2) {
                    iNetCircuitEndArray = new INetCircuitEnd[]{new OchncCircuitEnd(iNetElement.getNodeModel(), new CircuitEnd(iNetElement.getNodeId(), n, null, false, 0), n2), new OchncCircuitEnd(iNetElement.getNodeModel(), new CircuitEnd(iNetElement.getNodeId(), nArray[0], null, false, 0), n2), new OchncCircuitEnd(iNetElement.getNodeModel(), new CircuitEnd(iNetElement.getNodeId(), nArray[1], null, false, 0), n2)};
                    if (this.dbgOn()) {
                        this.debug("Co-located ports on node: " + iNetElement.getName());
                        for (int i = 0; i < iNetCircuitEndArray.length; ++i) {
                            this.debug("Port idx: " + Integer.toHexString(iNetCircuitEndArray[i].getEntityIndex()));
                        }
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.dbgOn()) {
                    this.debug("Exception getting co-located ports: " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
            catch (FeatureUnsupported featureUnsupported) {
                if (this.dbgOn()) {
                    this.debug("Exception getting co-located ports: " + (Object)((Object)featureUnsupported));
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.dbgOn()) break block9;
                this.debug("Exception getting co-located ports: " + (Object)((Object)noSuchInterface));
            }
        }
        return iNetCircuitEndArray;
    }

    @Override
    public INetCircuitEnd[] fillInternalSpliceLinks(INetElement iNetElement, int n, int n2, boolean bl) {
        INetCircuitEnd[] iNetCircuitEndArray;
        block10: {
            if (!bl) {
                return this.fillInternalSpliceLinks(iNetElement, n, n2);
            }
            iNetCircuitEndArray = null;
            try {
                int[] nArray = OchTrailHelper.getColocatedOchPorts(iNetElement, n, n2);
                if (nArray != null && nArray.length == 2) {
                    iNetCircuitEndArray = new INetCircuitEnd[]{new OchncCircuitEnd(iNetElement.getNodeModel(), new CircuitEnd(iNetElement.getNodeId(), n, null, false, 0), n2), new OchncCircuitEnd(iNetElement.getNodeModel(), new CircuitEnd(iNetElement.getNodeId(), nArray[0], null, false, 0), n2), new OchncCircuitEnd(iNetElement.getNodeModel(), new CircuitEnd(iNetElement.getNodeId(), nArray[1], null, false, 0), n2)};
                    if (this.dbgOn()) {
                        this.debug("Co-located ports on node: " + iNetElement.getName());
                        for (int i = 0; i < iNetCircuitEndArray.length; ++i) {
                            this.debug("Port idx: " + Integer.toHexString(iNetCircuitEndArray[i].getEntityIndex()));
                        }
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.dbgOn()) {
                    this.debug("Exception getting co-located ports: " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
            catch (FeatureUnsupported featureUnsupported) {
                if (this.dbgOn()) {
                    this.debug("Exception getting co-located ports: " + (Object)((Object)featureUnsupported));
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.dbgOn()) break block10;
                this.debug("Exception getting co-located ports: " + (Object)((Object)noSuchInterface));
            }
        }
        return iNetCircuitEndArray;
    }

    @Override
    protected void checkAndUpdateCircuit() {
        this.deleteOchTrailTunnelNetLink();
        super.checkAndUpdateCircuit();
    }

    public void clearInternalSrcSpliceLinkEnds() {
        this.srcInternalSpliceLinkEnds = null;
    }

    public void clearInternalDstSpliceLinkEnds() {
        this.dstInternalSpliceLinkEnds = null;
    }

    @Override
    public List getSrcInternalSpliceLinkEnds() {
        if (this.srcInternalSpliceLinkEnds != null) {
            return Arrays.asList(this.srcInternalSpliceLinkEnds);
        }
        return new LinkedList();
    }

    @Override
    public List getDstInternalSpliceLinkEnds() {
        if (this.dstInternalSpliceLinkEnds != null) {
            return Arrays.asList(this.dstInternalSpliceLinkEnds);
        }
        return new LinkedList();
    }

    public void setSrcInternalSpliceLinkEnds(List list) {
        if (list == null || list.size() != 3) {
            return;
        }
        if (this.dbgOn()) {
            db.println("setSrcInternalSpliceLinkEnds:");
        }
        this.srcInternalSpliceLinkEnds = new INetCircuitEnd[3];
        int n = 0;
        for (NetCircuitEnd netCircuitEnd : list) {
            if (netCircuitEnd == null) {
                if (!this.dbgOn()) continue;
                db.println("setSrcInternalSpliceLinkEnds: null link end");
                continue;
            }
            if (this.dbgOn()) {
                db.println("  " + netCircuitEnd.prettyString());
            }
            this.srcInternalSpliceLinkEnds[n++] = netCircuitEnd;
        }
    }

    public void setDstInternalSpliceLinkEnds(List list) {
        if (list == null || list.size() != 3) {
            return;
        }
        if (this.dbgOn()) {
            db.println("setDstInternalSpliceLinkEnds:");
        }
        this.dstInternalSpliceLinkEnds = new INetCircuitEnd[3];
        int n = 0;
        for (NetCircuitEnd netCircuitEnd : list) {
            if (netCircuitEnd == null) {
                if (!this.dbgOn()) continue;
                db.println("setDstInternalSpliceLinkEnds: null link end");
                continue;
            }
            if (this.dbgOn()) {
                db.println("  " + netCircuitEnd.prettyString());
            }
            this.dstInternalSpliceLinkEnds[n++] = netCircuitEnd;
        }
    }

    protected void deleteOchTrailTunnelNetLink() {
        if (this.OTTLink != null) {
            if (this.dbgOn()) {
                this.debug("Deleting OTT link");
            }
            this.getNetwork().deleteNetLink(this.OTTLink);
            this.OTTLink = null;
        }
        if (this.revOTTLink != null) {
            if (this.dbgOn()) {
                this.debug("Deleting reverse OTT link");
            }
            this.getNetwork().deleteNetLink(this.revOTTLink);
            this.revOTTLink = null;
        }
    }

    @Override
    public INetLink getLotLink() {
        return this.OTTLink;
    }

    @Override
    public INetLink getReverseLotLink() {
        return this.revOTTLink;
    }

    public INetCircuitEnd getEndPointForOchTrail(INetElement iNetElement) {
        List list;
        OchTrailTunnelCircuitEnd ochTrailTunnelCircuitEnd = null;
        if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType() && (list = this.getCircuitNodeFromNE(iNetElement)) != null) {
            for (INetCircuitNode iNetCircuitNode : list) {
                Object object;
                int n;
                block5: {
                    IConnectionModel iConnectionModel;
                    if (iNetCircuitNode instanceof OchncCircuitNode || !(iNetCircuitNode instanceof OchTrailTunnelNode) || !((iConnectionModel = iNetCircuitNode.getConn()) instanceof IOchTrailAditModel)) continue;
                    n = 0;
                    try {
                        if (this.getState() != 2) {
                            object = ((IOchTrailAditModel)iConnectionModel).getPaths();
                            n = object[0].getPortEntityIdx();
                        }
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block5;
                        db.println("exception while retrieving OchTrailAditModel.Paths attributesetting entity index as 0");
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                object = new CircuitEnd(iNetElement.getNodeId(), n, null, null, false, 0);
                ochTrailTunnelCircuitEnd = new OchTrailTunnelCircuitEnd(iNetElement.getNodeModel(), (ICircuitEnd)object);
            }
        }
        return ochTrailTunnelCircuitEnd;
    }

    public boolean isSrcOrDstNetElementForOCHNC(INetElement iNetElement) {
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            OchncCircuitSpan ochncCircuitSpan;
            if (!(this.getCircuitTypeObj().isOchTrailTunnelCircuitType() ? netCircuitNode instanceof OchTrailTunnelNode && (ochncCircuitSpan = (OchncCircuitSpan)netCircuitNode.getOutSpans().get(0)).getLink().getDst().equals(iNetElement) : !netCircuitNode.getDrops().isEmpty() && netCircuitNode.getNetElement().equals(iNetElement))) continue;
            return true;
        }
        return false;
    }

    public INetElement getSrcNetElementForOCHNC() {
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getSrcCircuitNode();
        if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            LinkedList linkedList = netCircuitNode.getOutSpans();
            for (OchncCircuitSpan ochncCircuitSpan : linkedList) {
                if (!ochncCircuitSpan.getLink().isVirtual()) continue;
                return ochncCircuitSpan.getLink().getDst();
            }
        }
        return netCircuitNode.getNetElement();
    }

    public INetElement getDstNetElementForOCHNC() {
        List list;
        NetCircuitNode netCircuitNode;
        List list2;
        INetElement iNetElement = this.getDropNE();
        if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType() && (list2 = this.getCircuitNodeFromNE(iNetElement)).size() == 1 && (netCircuitNode = (NetCircuitNode)list2.get(0)) instanceof OchTrailTunnelNode && (list = netCircuitNode.getAllSpansList()) != null && list.size() > 0) {
            OchncCircuitSpan ochncCircuitSpan = (OchncCircuitSpan)netCircuitNode.getAllSpansList().get(0);
            if (ochncCircuitSpan.getLink().getDst().equals(iNetElement)) {
                return ochncCircuitSpan.getLink().getSrc();
            }
            return ochncCircuitSpan.getLink().getDst();
        }
        return iNetElement;
    }

    private INetCircuitEnd getEndPointForOchNc(INetElement iNetElement) {
        OchncCircuitEnd ochncCircuitEnd = null;
        if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            List list = this.getCircuitNodeFromNE(iNetElement);
            for (INetCircuitNode iNetCircuitNode : list) {
                OchncCircuitSpan ochncCircuitSpan;
                if (iNetCircuitNode.getConnectionType() == 20) {
                    ochncCircuitSpan = this.getInternalSpan(((OchncCircuitNode)iNetCircuitNode).getOutSpans());
                    ochncCircuitEnd = ochncCircuitSpan.getSrcCircuitEnd();
                    continue;
                }
                if (!(iNetCircuitNode instanceof OchTrailTunnelNode)) continue;
                ochncCircuitSpan = (OchncCircuitSpan)((OchTrailTunnelNode)iNetCircuitNode).getOutSpans().get(0);
                ochncCircuitEnd = ochncCircuitSpan.getDstCircuitEnd();
            }
        }
        return ochncCircuitEnd;
    }

    public List<INetCircuitEnd> getSplitterProtectedCircuitEndList() {
        LinkedList<INetCircuitEnd> linkedList = new LinkedList<INetCircuitEnd>();
        if (this.isSplitterProtectedCircuit()) {
            if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                linkedList.add(this.getEndPointForOchNc(this.getSourceNE()));
                linkedList.add(this.getEndPointForOchNc(this.getDropNE()));
            } else if (this.getCircuitTypeObj().isOchncType()) {
                linkedList.add((INetCircuitEnd)this.getSources().get(0));
                linkedList.add((INetCircuitEnd)this.getDrops().get(0));
            }
        }
        return linkedList;
    }

    public INetCircuitEnd getSrcCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        List<OchncCircuitSpan> list;
        if (this.splitter != null && (list = this.splitter.getPathFromCircuitEnd(iNetCircuitEnd)) != null && list.size() > 0) {
            OchncCircuitSpan ochncCircuitSpan = list.get(0);
            return ochncCircuitSpan.getSrcCircuitEnd();
        }
        return iNetCircuitEnd;
    }

    @Override
    protected boolean validateCircuitTopology() {
        if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            if (this.getCktNodeListSize() < 2 || this.getSourcesSize() != 1 || this.getDropsSize() != 1) {
                if (this.dbgOn()) {
                    db.println("Circuit has invalid nodes/drops/sources");
                }
                return false;
            }
            return true;
        }
        boolean bl = super.validateCircuitTopology();
        if (!bl && this.isSplitterProtectedCircuit()) {
            this.removeWorkingAndProtectSpanList();
        }
        return bl;
    }

    @Override
    protected boolean completeCheck() {
        if (super.completeCheck()) {
            if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                this.addOchTrailTunnelNetLink();
            } else if (this.isBidirectional()) {
                INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)this.getSources().get(0);
                NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)this.getDrops().get(0);
                if (iNetCircuitEnd.getNodeId() == netCircuitDropInfo.getNodeId()) {
                    this.swapDropsOrder();
                }
            }
            if (this.isSplitterProtectedCircuit()) {
                this.addWorkingAndProtectSpanList();
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean tl1CircuitCompleteCheck() {
        if (super.tl1CircuitCompleteCheck()) {
            if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                this.setProtType();
                this.addOchTrailTunnelNetLink();
            } else if (this.isBidirectional() && this.getCircuitNodes().size() > 1) {
                this.swapDropsOrder();
            }
            if (this.isSplitterProtectedCircuit()) {
                this.addWorkingAndProtectSpanList();
            }
            return true;
        }
        return false;
    }

    private void swapDropsOrder() {
        if (this.getDrops().size() == 2) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)this.getDrops().get(0);
            if (this.dbgOn()) {
                db.println("swapDropsOrder: Old 1st Drop cktEnd " + Integer.toHexString(netCircuitDropInfo.getEntityIndex()));
            }
            NetCircuitDropInfo netCircuitDropInfo2 = (NetCircuitDropInfo)this.getDrops().get(1);
            if (this.dbgOn()) {
                db.println("swapDropsOrder: Old 2nd Drop cktEnd " + Integer.toHexString(netCircuitDropInfo2.getEntityIndex()));
            }
            LinkedList<NetCircuitDropInfo> linkedList = new LinkedList<NetCircuitDropInfo>();
            linkedList.add(netCircuitDropInfo2);
            linkedList.add(netCircuitDropInfo);
            this.setDrops(linkedList);
            if (this.dbgOn()) {
                db.println("swapDropsOrder: New 1st Drop cktEnd " + Integer.toHexString(((NetCircuitDropInfo)this.getDrops().get(0)).getEntityIndex()));
                db.println("swapDropsOrder: New 2nd Drop cktEnd " + Integer.toHexString(((NetCircuitDropInfo)this.getDrops().get(1)).getEntityIndex()));
            }
        }
    }

    public boolean hasOTTAdits() {
        int n = 0;
        if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            List list = this.getCircuitNodes();
            Iterator iterator = list.iterator();
            NetCircuitNode netCircuitNode = null;
            OchTrailTunnelNode ochTrailTunnelNode = null;
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                if (netCircuitNode instanceof OchTrailTunnelNode) {
                    ochTrailTunnelNode = (OchTrailTunnelNode)netCircuitNode;
                } else {
                    if (!(netCircuitNode instanceof DualConnectionCircuitNode)) continue;
                    ochTrailTunnelNode = (OchTrailTunnelNode)((DualConnectionCircuitNode)netCircuitNode).getFstCircuitNode();
                }
                try {
                    if (ochTrailTunnelNode == null || this.aditToAditSpanExists(ochTrailTunnelNode)) continue;
                    ochTrailTunnelNode.inUse();
                    if (this.dbgOn()) {
                        this.debug("hasOTTAdits: verify ochtrail exist on OM for " + ochTrailTunnelNode.getName());
                    }
                    ++n;
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!this.dbgOn()) continue;
                    this.debug("hasOTTAdits: the OchTrailAdit is no longer accessible.");
                }
            }
        }
        return n != 0;
    }

    protected void addOchTrailTunnelNetLink() {
        block29: {
            LinkModel linkModel;
            Object object2;
            LinkedList<INetElement> linkedList;
            int n;
            int n2;
            int n3;
            INetElement iNetElement;
            INodeModel iNodeModel;
            INetElement iNetElement2;
            INodeModel iNodeModel2;
            block28: {
                if (this.OTTLink != null && this.revOTTLink != null) {
                    return;
                }
                if (this.dbgOn()) {
                    db.println("adding OchTrail tunnel link to network topology");
                }
                NetCircuitNode netCircuitNode = null;
                NetCircuitNode netCircuitNode2 = null;
                if (this.getDropsSize() != 1 || this.getSourcesSize() != 1) {
                    if (this.dbgOn()) {
                        db.println("Warning! number of Tunnel ends != 2");
                    }
                    return;
                }
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.getPrimarySource();
                iNodeModel2 = netCircuitEnd.getNodeModel();
                if (iNodeModel2 == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to get node model of source ckt. end");
                    }
                    return;
                }
                iNetElement2 = this.getNetwork().findNetElem(iNodeModel2);
                if (iNetElement2 == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find srcNE");
                    }
                    return;
                }
                List list = this.getCircuitNodeFromNE(iNetElement2);
                if (list != null) {
                    netCircuitNode = list.size() > 1 ? this.getCircuitNodeFromCktEnd(netCircuitEnd) : (NetCircuitNode)list.get(0);
                }
                if (netCircuitNode == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find source ckt. node");
                    }
                    return;
                }
                NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)this.getCktDrops().get(0);
                netCircuitEnd = netCircuitDropInfo.getNetCktEnd();
                iNodeModel = netCircuitEnd.getNodeModel();
                if (iNodeModel == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to get node model of destn. ckt. end");
                    }
                    return;
                }
                iNetElement = this.getNetwork().findNetElem(iNodeModel);
                if (iNetElement == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find dstNE");
                    }
                    return;
                }
                list = this.getCircuitNodeFromNE(iNetElement);
                if (list != null) {
                    netCircuitNode2 = list.size() > 1 ? this.getCircuitNodeFromCktEnd(netCircuitEnd) : (NetCircuitNode)list.get(0);
                }
                if (netCircuitNode2 == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find destination ckt. node");
                    }
                    return;
                }
                try {
                    n3 = netCircuitNode.getTunnelEntityIndex();
                    n2 = netCircuitNode2.getTunnelEntityIndex();
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    if (this.dbgOn()) {
                        db.println("Sanity check failed while getting endpoint information");
                    }
                    return;
                }
                n = 3;
                if (OchTrailHelper.isProtected(iNodeModel2, n3)) {
                    n = 8;
                }
                linkedList = new LinkedList<INetElement>();
                for (Object object2 : this.getCircuitNodes()) {
                    linkedList.add(((NetCircuitNode)object2).getNetElement());
                    if (!this.dbgOn()) continue;
                    this.debug("Adding a Node to OTTNEs ");
                }
                object2 = new LinkedList();
                for (NetCircuitSpan netCircuitSpan : this.getCircuitSpans()) {
                    ((LinkedList)object2).add(netCircuitSpan.getLink());
                    if (!this.dbgOn()) continue;
                    this.debug("Adding a span to OTTLinks ");
                }
                linkModel = new LinkModel(iNodeModel2, n3, null, iNodeModel, n2, null, 8, -1, -1, true, true, -1, -1, n, "", 0, 0, 1, 1024, 0, 0);
                this.OTTLink = (NetLink)NetLinkFactory.createNetLink(this.getNetwork(), linkModel, iNetElement2, iNetElement, iNetElement2.getTopology(), linkedList, (LinkedList)object2, this);
                try {
                    this.getNetwork().addNetLink(this.OTTLink);
                    NetCircuitSplicer.instance().newNetLink(this.OTTLink);
                }
                catch (ObjDuplicate objDuplicate) {
                    if (!this.dbgOn()) break block28;
                    db.println("duplicate OchTrail tunnel");
                }
            }
            linkModel = new LinkModel(iNodeModel, n2, null, iNodeModel2, n3, null, 8, -1, -1, true, true, -1, -1, n, "", 0, 0, 1, 1024, 0, 0);
            this.revOTTLink = (NetLink)NetLinkFactory.createNetLink(this.getNetwork(), linkModel, iNetElement, iNetElement2, iNetElement.getTopology(), linkedList, (LinkedList)object2, this);
            try {
                this.getNetwork().addNetLink(this.revOTTLink);
                NetCircuitSplicer.instance().newNetLink(this.revOTTLink);
            }
            catch (ObjDuplicate objDuplicate) {
                if (!this.dbgOn()) break block29;
                db.println("duplicate OchTrail tunnel (reverse link)");
            }
        }
    }

    protected boolean setCktDstInternalSpliceEnds(INetElement iNetElement, RoutePrefs routePrefs) {
        boolean bl = false;
        INetCircuitNode iNetCircuitNode = this.get1StCircuitNodeFromNE(iNetElement);
        if (iNetCircuitNode == null) {
            if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                this.dstInternalSpliceLinkEnds = this.fillInternalSpliceLinks(iNetElement, routePrefs.getcktDstEntityIndex(), this.cktCreatInfo.cktOptChannel());
            }
            bl = this.dstInternalSpliceLinkEnds != null;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNetElement(INetElement iNetElement) throws ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, DeletionError, SanityCheckFailed {
        OchncCircuit ochncCircuit = this;
        synchronized (ochncCircuit) {
            this.operator.deleteNetElement(iNetElement);
        }
        this.notifyChanged();
    }

    @Override
    protected void getNodeLevelSourcesAndDrops(List list, List list2) {
        super.getNodeLevelSourcesAndDrops(list, list2);
        if (this.circuitInfoActive()) {
            return;
        }
        if (!this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            return;
        }
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            IEntityModel iEntityModel;
            int n;
            block7: {
                if (!(netCircuitNode instanceof OchTrailTunnelNode) && !(netCircuitNode instanceof DualConnectionCircuitNode)) continue;
                n = ((OchTrailTunnelNode)netCircuitNode).getEntityIndexFromSpans();
                IEntityTableModel iEntityTableModel = netCircuitNode.getNodeModel().getEntityTable();
                iEntityModel = null;
                try {
                    if (iEntityTableModel != null) {
                        iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block7;
                    db.println("getTunnelEntityIndex: Exception " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
            boolean bl = false;
            bl = Feature.provides((INodeModel)netCircuitNode.getNodeModel(), (Feature)Feature.OTU2_XP) && OchTrailHelper.isTrunkPort(netCircuitNode.getNodeModel(), n) && iEntityModel != null && iEntityModel.getModuleModel().getEqType() == 293 && ((IDwdmPortModel)iEntityModel).getRegenPeerLineModel() != null;
            if (bl) continue;
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), netCircuitNode.getNetElement());
            if (list.size() == 0) {
                list.add(netCircuitEnd);
                continue;
            }
            list2.add(netCircuitEnd);
        }
    }

    @Override
    protected synchronized boolean unify(NetCcatCircuit netCcatCircuit) {
        this.srcInternalSpliceLinkEnds = null;
        this.dstInternalSpliceLinkEnds = null;
        return super.unify(netCcatCircuit);
    }

    public void toOchTrailTunnelCircuit(OchTrailHelper.UpgradeOchncInfo upgradeOchncInfo, OchTrailHelper.UpgradeOchncInfo upgradeOchncInfo2) throws CircuitProvError {
        if (this.getCircuitType() == 9) {
            Object object2;
            NetCircuitNode netCircuitNode2;
            if (db.on()) {
                db.println("toOchTrailTunnelCircuit() called for " + this);
            }
            INetElement iNetElement = this.getSourceNE();
            List list = this.getCircuitNodeFromNE(iNetElement);
            OchncCircuitNode ochncCircuitNode = null;
            if (list != null) {
                if (list.size() > 1) {
                    if (this.dbgOn()) {
                        db.println("Error !! MXPN in Ochnc circuit source node. usingfirst ochnc circuit node");
                    }
                    for (NetCircuitNode netCircuitNode2 : list) {
                        if (!netCircuitNode2.isOchncCircuitNode()) continue;
                        ochncCircuitNode = (OchncCircuitNode)netCircuitNode2;
                        break;
                    }
                } else {
                    ochncCircuitNode = (OchncCircuitNode)list.get(0);
                }
            }
            INetElement iNetElement2 = this.getDropNE();
            list = this.getCircuitNodeFromNE(iNetElement2);
            netCircuitNode2 = null;
            if (list != null) {
                if (list.size() > 1) {
                    if (this.dbgOn()) {
                        db.println("Error !! MXPN in Ochnc circuit drop nodeusing first ochnc circuit node");
                    }
                    for (Object object2 : list) {
                        if (!((NetCircuitNode)object2).isOchncCircuitNode()) continue;
                        netCircuitNode2 = (OchncCircuitNode)object2;
                        break;
                    }
                } else {
                    netCircuitNode2 = (OchncCircuitNode)list.get(0);
                }
            }
            if (db.on()) {
                db.println("toOchTrailTunnelCircuit: Change circuit type to OCH_TRAIL_TUNNEL_CIRCUIT");
            }
            this.setCircuitType(15);
            this.setSources(null);
            this.setDrops(null);
            INodeModel iNodeModel = upgradeOchncInfo.getTrunkPort().getNodeModel();
            object2 = Network.instance().findNetElem(iNodeModel);
            OchTrailTunnelNode ochTrailTunnelNode = (OchTrailTunnelNode)NetCircuitNodeFactory.createCircuitNode((INetElement)object2, this);
            ochTrailTunnelNode.setState(2);
            if (db.on()) {
                db.println("toOchTrailTunnelCircuit: Insert circuit source");
            }
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), (INetElement)object2);
            netCircuitEnd.setStage(4);
            ochTrailTunnelNode.insertDrop(netCircuitEnd);
            this.insertSource(netCircuitEnd);
            if (db.on()) {
                db.println("toOchTrailTunnelCircuit: Change circuit src node from " + iNetElement.getName() + " to " + iNodeModel.getName());
            }
            this.setSrcNodeModel(iNodeModel);
            if (db.on()) {
                db.println("toOchTrailTunnelCircuit: Add src circuit node at " + iNodeModel.getName());
            }
            this.insertCktNode(ochTrailTunnelNode);
            if (upgradeOchncInfo.isColocated()) {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: Co-located case on src node " + iNodeModel.getName() + " fill the internal splice link info");
                }
                this.srcInternalSpliceLinkEnds = this.fillInternalSpliceLinks((INetElement)object2, upgradeOchncInfo.getTrunkPort().getEntityIndex(), this.getCircuitOptChannel());
                if (this.srcInternalSpliceLinkEnds == null && db.on()) {
                    db.println("WARNING: toOchTrailTunnelCircuit: failed to add internalSrcSpliceLinks for " + iNodeModel.getName());
                }
            } else {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: Not Co-located case on src node " + iNodeModel.getName() + " add active spans.");
                }
                this.addActiveSpan(ochTrailTunnelNode, ochncCircuitNode, upgradeOchncInfo.getVirtualLink1(), upgradeOchncInfo.getVirtualLink2());
                this.addActiveSpan(ochTrailTunnelNode, ochncCircuitNode, upgradeOchncInfo.getVirtualLink2().getReverseLink(), upgradeOchncInfo.getVirtualLink1().getReverseLink());
            }
            try {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: create OchTraiTunnel conn on src node " + iNodeModel.getName());
                }
                ochTrailTunnelNode.getOperator().createConnection();
            }
            catch (CircuitProvError circuitProvError) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)circuitProvError);
                }
                throw circuitProvError;
            }
            ochTrailTunnelNode.setCreateStage(4);
            if (upgradeOchncInfo.isColocated()) {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: Create the internal spans on node " + iNodeModel.getName());
                }
                this.insertInternalSpans(ochTrailTunnelNode, ochncCircuitNode, this.srcInternalSpliceLinkEnds);
            }
            INodeModel iNodeModel2 = upgradeOchncInfo2.getTrunkPort().getNodeModel();
            INetElement iNetElement3 = Network.instance().findNetElem(iNodeModel2);
            OchTrailTunnelNode ochTrailTunnelNode2 = (OchTrailTunnelNode)NetCircuitNodeFactory.createCircuitNode(iNetElement3, this);
            ochTrailTunnelNode2.setState(2);
            NetCircuitEnd netCircuitEnd2 = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), iNetElement3);
            netCircuitEnd2.setStage(4);
            if (db.on()) {
                db.println("toOchTrailTunnelCircuit: Insert circuit drop");
            }
            NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd2, 2);
            this.insertDrop(netCircuitDropInfo);
            ochTrailTunnelNode2.insertDrop(netCircuitEnd2);
            if (db.on()) {
                db.println("toOchTrailTunnelCircuit: Add dst circuit node at " + iNodeModel2.getName());
            }
            this.insertCktNode(ochTrailTunnelNode2);
            if (upgradeOchncInfo2.isColocated()) {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: Co-located case on dst node " + iNodeModel2.getName() + " fill the internal splice link info");
                }
                this.dstInternalSpliceLinkEnds = this.fillInternalSpliceLinks(iNetElement3, upgradeOchncInfo2.getTrunkPort().getEntityIndex(), this.getCircuitOptChannel());
                if (this.dstInternalSpliceLinkEnds == null && db.on()) {
                    db.println("WARNING: toOchTrailTunnelCircuit: failed to add dst internalSpliceLinks for " + iNodeModel2);
                }
            } else {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: Not Co-located case on dst node " + iNodeModel2.getName() + " add active spans.");
                }
                this.addActiveSpan(ochTrailTunnelNode2, (OchncCircuitNode)netCircuitNode2, upgradeOchncInfo2.getVirtualLink1(), upgradeOchncInfo2.getVirtualLink2());
                this.addActiveSpan(ochTrailTunnelNode2, (OchncCircuitNode)netCircuitNode2, upgradeOchncInfo2.getVirtualLink2().getReverseLink(), upgradeOchncInfo2.getVirtualLink1().getReverseLink());
            }
            try {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: create OchTraiTunnel conn on dst node " + iNodeModel2.getName());
                }
                ochTrailTunnelNode2.getOperator().createConnection();
            }
            catch (CircuitProvError circuitProvError) {
                block53: {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)circuitProvError);
                    }
                    try {
                        ochTrailTunnelNode.deactivate();
                    }
                    catch (DeletionError deletionError) {
                        if (!db.on()) break block53;
                        SDebug.printStackTrace((Throwable)deletionError);
                    }
                }
                throw circuitProvError;
            }
            ochTrailTunnelNode2.setCreateStage(4);
            if (upgradeOchncInfo2.isColocated()) {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: Create the internal spans on node " + iNodeModel2.getName());
                }
                this.insertInternalSpans(ochTrailTunnelNode2, (OchncCircuitNode)netCircuitNode2, this.dstInternalSpliceLinkEnds);
            }
            String string = this.getCircuitName();
            ICircuitId iCircuitId = this.getCircuitId();
            try {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: ChangeCircuitId on node " + iNodeModel.getName());
                }
                this.changeCircuitId(iNetElement.getNodeId(), object2.getNodeId());
                this.renameCircuit(string);
                NetCircuit netCircuit = (NetCircuit)NetCircuitManager.instance().getCircuitFromId(iCircuitId);
                if (netCircuit != null) {
                    if (db.on()) {
                        db.println("toOchTrailTunnelCircuit: cleaning the hanging circuits with old id => " + OchncCircuit.prettyString(iCircuitId));
                    }
                    netCircuit.dispose();
                    netCircuit.finalDispose();
                    netCircuit.notifyDeleted();
                }
            }
            catch (CircuitProvError circuitProvError) {
                block54: {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)circuitProvError);
                    }
                    try {
                        ochTrailTunnelNode.deactivate();
                        ochTrailTunnelNode2.deactivate();
                    }
                    catch (DeletionError deletionError) {
                        if (!db.on()) break block54;
                        SDebug.printStackTrace((Throwable)deletionError);
                    }
                }
                this.setCircuitName(string);
                throw circuitProvError;
            }
        }
        if (db.on()) {
            db.println("toOchTrailTunnelCircuit() done");
        }
    }

    private void insertInternalSpans(OchTrailTunnelNode ochTrailTunnelNode, OchncCircuitNode ochncCircuitNode, INetCircuitEnd[] iNetCircuitEndArray) {
        if (ochTrailTunnelNode != null && ochncCircuitNode != null && iNetCircuitEndArray != null) {
            InternalNetLink internalNetLink = new InternalNetLink(ochTrailTunnelNode.getNetElement(), ochncCircuitNode.getNetElement(), iNetCircuitEndArray[0].getEntityIndex(), iNetCircuitEndArray[1].getEntityIndex(), null, null);
            NetLinkSpan netLinkSpan = new NetLinkSpan(internalNetLink, null, null, null, null);
            NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this, netLinkSpan, ochTrailTunnelNode, ochncCircuitNode);
            if (this.dbgOn()) {
                this.debug("toOchTrailTunnelCircuit() :: Created the internal splicing span: OchTrailTunnelNode->OchncNode");
            }
            netCircuitSpan.setSrcState(4);
            netCircuitSpan.setDstState(4);
            ochTrailTunnelNode.addActiveSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
            ochncCircuitNode.addActiveSpan(netCircuitSpan, eSpanDirection.TERMINATING);
            this.insertCktSpan(netCircuitSpan);
            InternalNetLink internalNetLink2 = new InternalNetLink(ochncCircuitNode.getNetElement(), ochTrailTunnelNode.getNetElement(), iNetCircuitEndArray[2].getEntityIndex(), iNetCircuitEndArray[0].getEntityIndex(), null, null);
            netLinkSpan = new NetLinkSpan(internalNetLink2, null, null, null, null);
            netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this, netLinkSpan, ochncCircuitNode, ochTrailTunnelNode);
            if (this.dbgOn()) {
                this.debug("toOchTrailTunnelCircuit() :: Created the internal splicing span: OchncNode->OchTrailTunnelNode");
            }
            netCircuitSpan.setSrcState(4);
            netCircuitSpan.setDstState(4);
            ochncCircuitNode.addActiveSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
            ochTrailTunnelNode.addActiveSpan(netCircuitSpan, eSpanDirection.TERMINATING);
            this.insertCktSpan(netCircuitSpan);
        }
    }

    private synchronized boolean changeCircuitId(int n, int n2) throws CircuitProvError {
        ICircuitId iCircuitId;
        INodeModel iNodeModel;
        INetElement iNetElement = this.getNetwork().findNetElem(n2);
        INodeModel iNodeModel2 = iNodeModel = iNetElement == null ? null : iNetElement.getNodeModel();
        if (iNodeModel == null) {
            return false;
        }
        if (this.dbgOn()) {
            this.debug("changeCircuitId(" + this.getCircuitName() + ", " + OchncCircuit.prettyString(this.circuitId) + ")");
        }
        CktInfo cktInfo = new CktInfo();
        ICircuitEnd[] iCircuitEndArray = new ICircuitEnd[this.getSourcesSize()];
        Iterator iterator = this.getCktSources().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            iCircuitEndArray[n3++] = netCircuitEnd.getCircuitEnd();
        }
        ICircuitDropInfo[] iCircuitDropInfoArray = new ICircuitDropInfo[this.getDropsSize()];
        iterator = this.getCktDrops().iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            iCircuitDropInfoArray[n4++] = netCircuitDropInfo.getCircuitDropInfo();
        }
        VlanSetManager.instance();
        cktInfo.setVlans(VlanSetManager.vlanModelToVlanInfo(this.getVlans()));
        cktInfo.setSrcInfo(iCircuitEndArray);
        cktInfo.setDropInfo(iCircuitDropInfoArray);
        cktInfo.setMonitor(this.isMonitorCircuit());
        cktInfo.setCircuitSize(this.getCircuitSize());
        cktInfo.setCircuitType(this.getCircuitType());
        cktInfo.setCktOptChannel(this.getCircuitOptChannel());
        cktInfo.setDir(this.getCircuitDir());
        cktInfo.setCircuitName("");
        cktInfo.setSla(this.getSla());
        try {
            this.destroyCircuitInfo();
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
        }
        catch (DeletionError deletionError) {
            throw new CircuitProvError("The old OCHNC circuit cannot be disposed.");
        }
        this.getOperator().createCircuitInfo(iNodeModel, cktInfo);
        try {
            iCircuitId = this.circuitModel.getId();
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (this.dbgOn()) {
                db.println("New CircuitModel disappeared");
            }
            throw new CircuitProvError("The new circuit model cannot be found.");
        }
        this.srcInternalSpliceLinkEnds = null;
        this.dstInternalSpliceLinkEnds = null;
        NetCcatCircuitRepairer netCcatCircuitRepairer = new NetCcatCircuitRepairer(this);
        netCcatCircuitRepairer.changeCircuitId(iCircuitId);
        return true;
    }

    public void addActiveSpan(OchTrailTunnelNode ochTrailTunnelNode, OchncCircuitNode ochncCircuitNode, INetLink iNetLink, INetLink iNetLink2) {
        eSpanDirection eSpanDirection2;
        eSpanDirection eSpanDirection3;
        if (db.on()) {
            db.println("addActiveSpan() adding span: " + iNetLink.prettyString() + ", " + iNetLink2.prettyString());
        }
        NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink, iNetLink2);
        INetLink iNetLink3 = netLinkSpan.getLink();
        if (this.dbgOn()) {
            db.println("addCircuitSpan " + netLinkSpan.prettyString() + " to circuit " + OchncCircuit.prettyString(this.circuitId));
        }
        if (this.getCircuitSpanFromNetLink(iNetLink3) != null) {
            if (this.dbgOn()) {
                db.println("addCircuitSpan: span already in list; ignored");
            }
            return;
        }
        NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this, netLinkSpan, null, null);
        if (iNetLink.getSrc().equals(ochTrailTunnelNode.getNetElement())) {
            eSpanDirection3 = eSpanDirection.ORIGINATING;
            eSpanDirection2 = eSpanDirection.TERMINATING;
            netCircuitSpan.setSrcNCN(ochTrailTunnelNode);
            netCircuitSpan.setDstNCN(ochncCircuitNode);
        } else {
            eSpanDirection3 = eSpanDirection.TERMINATING;
            eSpanDirection2 = eSpanDirection.ORIGINATING;
            netCircuitSpan.setSrcNCN(ochncCircuitNode);
            netCircuitSpan.setDstNCN(ochTrailTunnelNode);
        }
        ochTrailTunnelNode.addActiveSpan(netCircuitSpan, eSpanDirection3);
        this.clearSourcesAndDrops(ochncCircuitNode);
        ochncCircuitNode.addActiveSpan(netCircuitSpan, eSpanDirection2);
        if (this.dbgOn()) {
            db.println("Set circuit span state to ACTIVE");
        }
        netCircuitSpan.setSrcState(4);
        netCircuitSpan.setDstState(4);
    }

    public NetCircuitNode findOchTrailTunnelNode(INetElement iNetElement, IEntityModel iEntityModel, boolean bl) {
        NetCircuitNode netCircuitNode = null;
        List list = this.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            for (NetCircuitNode netCircuitNode2 : list) {
                Object object2;
                if (!netCircuitNode2.isOchTrailTunnelNode()) continue;
                if (bl) {
                    LinkedList linkedList = netCircuitNode2.getInSpans();
                    Iterator iterator = linkedList.iterator();
                    object2 = null;
                    while (iterator.hasNext()) {
                        object2 = (NetCircuitSpan)iterator.next();
                        if (((NetCircuitSpan)object2).getInternalEntityIndex(netCircuitNode2) != iEntityModel.getEntityIndex()) continue;
                        return netCircuitNode2;
                    }
                    linkedList = netCircuitNode2.getOutSpans();
                    for (Object object2 : linkedList) {
                        if (((NetCircuitSpan)object2).getInternalEntityIndex(netCircuitNode2) != iEntityModel.getEntityIndex()) continue;
                        return netCircuitNode2;
                    }
                    continue;
                }
                boolean bl2 = false;
                boolean bl3 = false;
                object2 = netCircuitNode2.getInSpans();
                Iterator iterator = object2.iterator();
                NetCircuitSpan netCircuitSpan = null;
                while (iterator.hasNext()) {
                    netCircuitSpan = (NetCircuitSpan)iterator.next();
                    if (netCircuitSpan.getInternalEntityIndex(netCircuitNode2) != iEntityModel.getEntityIndex()) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    object2 = netCircuitNode2.getOutSpans();
                    iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        netCircuitSpan = (NetCircuitSpan)iterator.next();
                        if (netCircuitSpan.getInternalEntityIndex(netCircuitNode2) != iEntityModel.getEntityIndex()) continue;
                        bl3 = true;
                        break;
                    }
                }
                if (bl2 || bl3) continue;
                return netCircuitNode2;
            }
        }
        return netCircuitNode;
    }

    private void clearSourcesAndDrops(OchncCircuitNode ochncCircuitNode) {
        Object object2;
        List list = ochncCircuitNode.getSources();
        for (Object object2 : list) {
            ochncCircuitNode.removeSource((NetCircuitEnd)object2);
        }
        object2 = ochncCircuitNode.getDrops();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            ochncCircuitNode.removeDrop(netCircuitEnd);
        }
    }

    public boolean isDCNCircuit() {
        boolean bl = false;
        List list = this.getCircuitNodes();
        for (INetCircuitNode iNetCircuitNode : list) {
            if (!(iNetCircuitNode instanceof OchncCircuitNode) || !((OchncCircuitNode)iNetCircuitNode).isDCNNode()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private INetCircuitNode getCircuitNodeFromNEnCE(INetElement iNetElement, OchncCircuitEnd ochncCircuitEnd) {
        List list = this.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            if (list.size() == 1) {
                return (INetCircuitNode)list.get(0);
            }
            if (list.size() > 1) {
                return this.getCircuitNodeFromCktEnd(ochncCircuitEnd);
            }
        }
        return null;
    }

    INetCircuitNode get1StCircuitNodeFromNE(INetElement iNetElement) {
        List list = this.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            if (list.size() > 0) {
                return (INetCircuitNode)list.get(0);
            }
            if (this.dbgOn()) {
                db.println("Error !! MXPN in OchTrailTunnel ");
            }
        }
        return null;
    }

    @Override
    public void update(IObservable iObservable, Object object) {
        super.update(iObservable, object);
        if (iObservable instanceof IInterfaceModel) {
            this.updateWorkingAndProtectSpanList();
        }
    }

    public boolean isSplitterProtectedCircuit() {
        if (this.getState() != 1 && this.getState() != 5) {
            return false;
        }
        int n = 0;
        List list = this.getCircuitNodes();
        for (INetCircuitNode iNetCircuitNode : list) {
            if (!(iNetCircuitNode instanceof OchncCircuitNode) || !((OchncCircuitNode)iNetCircuitNode).isSplitterProtectionNode()) continue;
            if (this.dbgOn()) {
                this.debug("OCHNC Splitter Node: " + iNetCircuitNode);
            }
            ++n;
        }
        return n >= 2;
    }

    public boolean isCktCreateProtected() {
        if (this.cktCreatInfo != null) {
            return this.cktCreatInfo.isProtected();
        }
        return false;
    }

    private void addWorkingAndProtectSpanList() {
        this.splitter = new SplitterInfo();
        this.splitter.init();
    }

    private void updateWorkingAndProtectSpanList() {
        if (this.splitter != null) {
            this.splitter.updateSplitterState(false);
        }
    }

    private void removeWorkingAndProtectSpanList() {
        if (this.splitter != null) {
            this.splitter.dispose();
        }
    }

    @Override
    protected boolean isPartial() {
        if (this.isSplitterProtectedCircuit()) {
            List list = this.getCircuitNodes();
            for (INetCircuitNode iNetCircuitNode : list) {
                if (iNetCircuitNode.getConnectionType() != 20) continue;
                IOchncConnectionModel iOchncConnectionModel = (IOchncConnectionModel)iNetCircuitNode.getConn();
                if (this.dbgOn()) {
                    this.debug("OCHNC Splitter Node: " + iNetCircuitNode);
                }
                if (iOchncConnectionModel == null || !iOchncConnectionModel.isPartial()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    @Override
    protected void debug(String string) {
        db.println(string);
    }

    @Override
    public void prettyPrint(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        NetCircuitManager.suppressPkgDbg();
        sDebug.println("CIRCUIT Name=\"" + this.getCircuitName() + "\"" + "  Id=" + OchncCircuit.prettyString(this.circuitId) + "  State=" + EnumStrings.getString(INetCircuitState.class, (int)this.state) + "  circuitInfo=" + (this.circuitInfoActive() ? "active" : "inactive"));
        sDebug.println("        " + EnumStrings.getString(ICircuitType.class, (int)this.getCircuitType()) + "  " + EnumStrings.getString(ICircuitSize.class, (int)this.getCircuitSize()) + "  " + EnumStrings.getString(ICircuitDirection.class, (int)this.getCircuitDir()));
        sDebug.println("        serviceState=" + this.translateServiceState(this.getServiceState()) + "  adminState=" + this.translateAdminState(this.getAdminState()));
        sDebug.println("        pathProt=" + EnumStrings.getString(IPathProtection.class, (int)this.getDropPathProtection()) + "  protType=" + this.protType.getProtectionTypeString());
        sDebug.println("        DCN circuit=" + (this.isDCNCircuit() ? "Yes" : "No"));
        sDebug.println("");
        sDebug.println("srcNode: " + (this.srcNodeModel == null ? "null" : this.srcNodeModel.getName()));
        sDebug.println("");
        sDebug.println("Source(s) :");
        for (NetCircuitEnd netCircuitEnd : this.getCktSources()) {
            sDebug.println(" " + netCircuitEnd.prettyString() + " " + EnumStrings.getString(INetCircuitCreatStage.class, (int)netCircuitEnd.getStage()));
        }
        sDebug.println("");
        sDebug.println("Drop(s) :");
        for (NetCircuitDropInfo netCircuitDropInfo : this.getCktDrops()) {
            sDebug.println(" " + netCircuitDropInfo.getNetCktEnd().prettyString() + " " + EnumStrings.getString(INetCircuitCreatStage.class, (int)netCircuitDropInfo.getNetCktEnd().getStage()));
        }
        this.printChild(sDebug);
        if (this.splitter != null) {
            sDebug.println(this.splitter.prettyString());
        }
        NetCircuitManager.permitPkgDbg();
    }

    @Override
    public int getCircuitSpanNum() {
        List list = this.getCircuitSpans();
        Iterator iterator = list.iterator();
        int n = list.size();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (!netCircuitSpan.isInternalSpan()) continue;
            --n;
        }
        return n;
    }

    public boolean isColocatedOchTrail() {
        return this.getCircuitTypeObj().isOchTrailTunnelCircuitType() && this.dstInternalSpliceLinkEnds != null;
    }

    private OchncCircuitSpan getInternalSpan(List<OchncCircuitSpan> list) {
        for (OchncCircuitSpan ochncCircuitSpan : list) {
            if (!(ochncCircuitSpan instanceof OchncCircuitSpan) || !ochncCircuitSpan.isInternalSpan()) continue;
            return ochncCircuitSpan;
        }
        for (OchncCircuitSpan ochncCircuitSpan : list) {
            if (!(ochncCircuitSpan instanceof OchncCircuitSpan) || !ochncCircuitSpan.getLink().isVirtual()) continue;
            return ochncCircuitSpan;
        }
        return null;
    }

    @Override
    public List getRegenTrunkEntityModels() {
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            if (!netCircuitNode.isOchTrailTunnelNode()) continue;
            int n = ((OchTrailTunnelNode)netCircuitNode).getEntityIndexFromSpans();
            IEntityModel iEntityModel = null;
            try {
                iEntityModel = netCircuitNode.getEntityModel(n);
                boolean bl = Feature.provides((INodeModel)netCircuitNode.getNodeModel(), (Feature)Feature.OTU2_XP) && OchTrailHelper.isTrunkPort(netCircuitNode.getNodeModel(), n) && iEntityModel != null && iEntityModel.getModuleModel().getEqType() == 293 && ((IDwdmPortModel)iEntityModel).getRegenPeerLineModel() != null;
                if (!bl) continue;
                linkedList.add(iEntityModel);
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Exception in getRegenTrunkEntityModels");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return linkedList;
    }

    public void saveRegenTrunkPortsInfo() {
        if (!this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            return;
        }
        TrkAttribOperator trkAttribOperator = this.getTrkAttribOperator();
        trkAttribOperator.clearRegenTrkPorts();
        List list = this.getRegenTrunkEntityModels();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                trkAttribOperator.addToRegenTrkPorts((IEntityModel)iterator.next());
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Exception in saveRegenTrunkPortsInfo");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public void restoreTrunkPortsInfo() throws Exception {
        this.getTrkAttribOperator().restoreAll();
    }

    @Override
    public void applyTrunkPortsInfo() throws Exception {
        this.getTrkAttribOperator().applyAll();
    }

    public void restoreRegenTrunkPortsInfo() throws Exception {
        this.getTrkAttribOperator().restoreRegenTrunkAttrs();
    }

    public void applyRegenTrunkPortsInfo() throws Exception {
        this.getTrkAttribOperator().applyRegenTrunkAttrs();
    }

    @Override
    public void provision() throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        try {
            if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                this.saveRegenTrunkPortsInfo();
                this.applyTrunkPortsInfo();
            }
            super.provision();
        }
        catch (Exception exception) {
            block6: {
                if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                    try {
                        this.restoreTrunkPortsInfo();
                    }
                    catch (Exception exception2) {
                        if (!db.on()) break block6;
                        db.println("Exception in restoreTrunkPortsInfo");
                        SDebug.printStackTrace((Throwable)exception2);
                    }
                }
            }
            throw new CircuitProvError(exception.getMessage());
        }
    }

    public void provisionProtectOchTrail() throws Exception {
        try {
            if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                this.saveRegenTrunkPortsInfo();
                this.applyRegenTrunkPortsInfo();
            }
            super.provision();
        }
        catch (Exception exception) {
            if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                this.restoreRegenTrunkPortsInfo();
            }
            throw exception;
        }
    }

    public void setTrkAttribOperatorInfo(TrkAttribOperator trkAttribOperator) {
        this.trkAttribOperator.setTrkAttribOperatorInfo(trkAttribOperator);
    }

    @Override
    public String getTrunksInUseMsg() {
        return this.getTrkAttribOperator().getTrunksInUseMsg();
    }

    public String getRegenTrunksInUseMsg() {
        return this.getTrkAttribOperator().getRegenTrunksInUseMsg();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SplitterInfo {
        private List<OchncCircuitSpan> srcWrkPath = new LinkedList<OchncCircuitSpan>();
        private List<OchncCircuitSpan> srcPrtPath = new LinkedList<OchncCircuitSpan>();
        private IPortModel srcSwitchPort;
        private boolean srcIsActive = true;
        private List<OchncCircuitSpan> dstWrkPath = new LinkedList<OchncCircuitSpan>();
        private List<OchncCircuitSpan> dstPrtPath = new LinkedList<OchncCircuitSpan>();
        private IPortModel dstSwitchPort;
        private boolean dstIsActive = true;

        SplitterInfo() {
        }

        private INetCircuitNode addNextSpan(List<OchncCircuitSpan> list, OchncCircuitSpan ochncCircuitSpan, INetElement iNetElement, boolean bl, boolean bl2) {
            if (OchncCircuit.this.dbgOn()) {
                OchncCircuit.this.debug("Add span to path " + (bl ? "SRC" : "DST") + "/" + (bl2 ? "WRK" : "PRT") + ": " + ochncCircuitSpan);
            }
            list.add(ochncCircuitSpan);
            INetElement iNetElement2 = ochncCircuitSpan.getLink().getDst();
            INetCircuitNode iNetCircuitNode = OchncCircuit.this.getCircuitNodeFromNEnCE(iNetElement2, ochncCircuitSpan.getDstCircuitEnd());
            if (iNetCircuitNode instanceof OchncCircuitNode && !OchncCircuit.this.isSrcOrDstNetElementForOCHNC(iNetElement2)) {
                LinkedList linkedList = ((NetCircuitNode)iNetCircuitNode).getOutSpans();
                for (OchncCircuitSpan ochncCircuitSpan2 : linkedList) {
                    if (ochncCircuitSpan2.getLink().getDst().equals(iNetElement)) continue;
                    return this.addNextSpan(list, ochncCircuitSpan2, iNetElement2, bl, bl2);
                }
            }
            return iNetCircuitNode;
        }

        private INetCircuitNode addPath(List<OchncCircuitSpan> list, List<OchncCircuitSpan> list2, INetCircuitNode iNetCircuitNode, boolean bl) {
            INetCircuitNode iNetCircuitNode2 = null;
            try {
                List list3;
                INetElement iNetElement = iNetCircuitNode.getNetElement();
                OchncCircuitEnd ochncCircuitEnd = null;
                if (iNetCircuitNode instanceof OchncCircuitNode) {
                    list3 = iNetCircuitNode.getSources();
                    ochncCircuitEnd = list3.size() > 0 ? (OchncCircuitEnd)list3.get(0) : OchncCircuit.this.getInternalSpan(((OchncCircuitNode)iNetCircuitNode).getOutSpans()).getSrcCircuitEnd();
                } else if (iNetCircuitNode instanceof OchTrailTunnelNode) {
                    ochncCircuitEnd = OchncCircuit.this.getInternalSpan(((OchTrailTunnelNode)iNetCircuitNode).getOutSpans()).getDstCircuitEnd();
                    iNetCircuitNode = OchncCircuit.this.getCircuitNodeFromCktEnd(ochncCircuitEnd);
                    iNetElement = iNetCircuitNode.getNetElement();
                } else {
                    db.println("Unknown node type");
                    return null;
                }
                list3 = OchncHelper.getOutLinePort(ochncCircuitEnd.getOptChannel(), ochncCircuitEnd.getEntityModel());
                IEntityModel iEntityModel = OchncHelper.getProtectedOutLinePort(ochncCircuitEnd.getOptChannel(), ochncCircuitEnd.getEntityModel());
                IPortModel iPortModel = OchncHelper.getSplitterPort(ochncCircuitEnd.getOptChannel(), (IEntityModel)list3);
                if (bl) {
                    this.srcSwitchPort = iPortModel;
                } else {
                    this.dstSwitchPort = iPortModel;
                }
                if (OchncCircuit.this.dbgOn()) {
                    OchncCircuit.this.debug("Add " + (bl ? "SRC" : "DST") + " Path from CE: " + ochncCircuitEnd + " WL=" + Wavelength.getWavelengthStringFromWavelength(ochncCircuitEnd.getOptChannel()));
                }
                LinkedList linkedList = ((NetCircuitNode)iNetCircuitNode).getOutSpans();
                for (OchncCircuitSpan ochncCircuitSpan : linkedList) {
                    if (ochncCircuitSpan.isInternalSpan()) continue;
                    if (ochncCircuitSpan.getEntityModel(iNetElement).equals(list3)) {
                        iNetCircuitNode2 = this.addNextSpan(list, ochncCircuitSpan, iNetElement, bl, true);
                        continue;
                    }
                    if (!ochncCircuitSpan.getEntityModel(iNetElement).equals(iEntityModel)) continue;
                    this.addNextSpan(list2, ochncCircuitSpan, iNetElement, bl, false);
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return iNetCircuitNode2;
        }

        public void init() {
            INetCircuitNode iNetCircuitNode = OchncCircuit.this.getSrcCircuitNode();
            INetCircuitNode iNetCircuitNode2 = this.addPath(this.srcWrkPath, this.srcPrtPath, iNetCircuitNode, true);
            this.addPath(this.dstWrkPath, this.dstPrtPath, iNetCircuitNode2, false);
            if (this.srcSwitchPort != null && this.dstSwitchPort != null) {
                this.updateSplitterState(true);
                this.srcSwitchPort.getInterfaceModel().addObserver((IObserver)OchncCircuit.this);
                this.dstSwitchPort.getInterfaceModel().addObserver((IObserver)OchncCircuit.this);
            }
        }

        public void dispose() {
            block7: {
                block6: {
                    try {
                        if (this.srcSwitchPort != null) {
                            this.srcSwitchPort.getInterfaceModel().deleteObserver((IObserver)OchncCircuit.this);
                        }
                    }
                    catch (Exception exception) {
                        if (!OchncCircuit.this.dbgOn()) break block6;
                        OchncCircuit.this.debug("Exception on srcSwitchPort deleteObserver " + exception);
                    }
                }
                try {
                    if (this.dstSwitchPort != null) {
                        this.dstSwitchPort.getInterfaceModel().deleteObserver((IObserver)OchncCircuit.this);
                    }
                }
                catch (Exception exception) {
                    if (!OchncCircuit.this.dbgOn()) break block7;
                    OchncCircuit.this.debug("Exception on dstSwitchPort deleteObserver " + exception);
                }
            }
        }

        public void updateSplitterState(boolean bl) {
            boolean bl2 = false;
            try {
                boolean bl3 = this.srcSwitchPort.getInterfaceModel().isCurrentlyActive();
                if (OchncCircuit.this.dbgOn()) {
                    OchncCircuit.this.debug("Update SRC Splitter state: new=" + bl3 + " old=" + this.srcIsActive + " from " + this.srcSwitchPort);
                }
                if (bl || bl3 != this.srcIsActive) {
                    for (OchncCircuitSpan ochncCircuitSpan : this.srcWrkPath) {
                        ochncCircuitSpan.setSpanState(bl3 ? 0 : 1);
                    }
                    for (OchncCircuitSpan ochncCircuitSpan : this.srcPrtPath) {
                        ochncCircuitSpan.setSpanState(bl3 ? 1 : 0);
                    }
                    this.srcIsActive = bl3;
                    bl2 = true;
                }
                bl3 = this.dstSwitchPort.getInterfaceModel().isCurrentlyActive();
                if (OchncCircuit.this.dbgOn()) {
                    OchncCircuit.this.debug("Update SDT Splitter state: new=" + bl3 + " old=" + this.dstIsActive + " from " + this.dstSwitchPort);
                }
                if (bl || bl3 != this.dstIsActive) {
                    for (OchncCircuitSpan ochncCircuitSpan : this.dstWrkPath) {
                        ochncCircuitSpan.setSpanState(bl3 ? 0 : 1);
                    }
                    for (OchncCircuitSpan ochncCircuitSpan : this.dstPrtPath) {
                        ochncCircuitSpan.setSpanState(bl3 ? 1 : 0);
                    }
                    this.dstIsActive = bl3;
                    bl2 = true;
                }
                if (!bl && bl2) {
                    OchncCircuit.this.setChanged();
                    OchncCircuit.this.notifyObservers(ModelUpdateType.CHANGED);
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }

        private List<OchncCircuitSpan> getPathFromCircuitEnd(List<OchncCircuitSpan> list, INetCircuitEnd iNetCircuitEnd) {
            OchncCircuitSpan ochncCircuitSpan = list.get(list.size() - 1);
            OchncCircuitEnd ochncCircuitEnd = ochncCircuitSpan.getDstCircuitEnd();
            if (ochncCircuitEnd.equals(iNetCircuitEnd)) {
                return list;
            }
            return null;
        }

        public List<OchncCircuitSpan> getPathFromCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
            List<OchncCircuitSpan> list = this.getPathFromCircuitEnd(this.srcWrkPath, iNetCircuitEnd);
            if (list == null) {
                list = this.getPathFromCircuitEnd(this.dstWrkPath, iNetCircuitEnd);
            }
            if (list == null) {
                list = this.getPathFromCircuitEnd(this.srcPrtPath, iNetCircuitEnd);
            }
            if (list == null) {
                list = this.getPathFromCircuitEnd(this.dstPrtPath, iNetCircuitEnd);
            }
            return list;
        }

        public String prettyString() {
            return "SPLITTER:\n  SRC Switch Port is " + this.srcSwitchPort + "/" + (this.srcIsActive ? "ACT" : "STBY") + "\n      WRK Path is" + this.srcWrkPath + "\n      PRT Path is" + this.srcPrtPath + "\n  DST Switch Port is " + this.dstSwitchPort + "/" + (this.dstIsActive ? "ACT" : "STBY") + "\n      WRK Path is" + this.dstWrkPath + "\n      PRT Path is" + this.dstPrtPath;
        }

        public String toString() {
            return this.prettyString();
        }
    }
}

