/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AdminStateOpt;
import cerent.cms.model.AnsNotRegulated;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.ConnCreateAttrs;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidPortState;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.model.VcatMemberInvalidState;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.model.WrongNetworkType;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.ncp.PathDefsHolder;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.topo.INetElement;
import cerent.util.EID;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OchncCircuitNodeOperator
extends NetCircuitNodeOperator {
    private static final SDebug db = new SDebug("OchncCircuitNodeOperator");

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    public OchncCircuitNodeOperator(OchncCircuitNode ochncCircuitNode) {
        super(ochncCircuitNode);
    }

    protected void createConnection() throws CircuitProvError {
        ICircuitId iCircuitId = this.node.getCircuitId();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        ICircuitType iCircuitType = netCcatCircuit.getCircuitTypeObj();
        if (OchncCircuitNodeOperator.dbgOn()) {
            db.println("createConnection(" + this.getName() + ")" + "; connType=" + EnumStrings.getString(IConnectionType.class, (int)this.node.getConnectionType()) + "; cktId=" + NetCcatCircuit.prettyString(iCircuitId));
        }
        try {
            this.createConnection(iCircuitId);
        }
        catch (CTCUserException cTCUserException) {
            if (OchncCircuitNodeOperator.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            String string = "A connection could not be created on the node " + this.getName() + ".";
            if (cTCUserException instanceof PathInUse) {
                string = string + "\nThe path is already in use.";
            } else if (cTCUserException instanceof InvalidPortState) {
                string = string + "\nAt least one of the involved ports is in the maintenance state.";
            } else if (cTCUserException instanceof AnsNotRegulated) {
                string = string + "\nANS not regulated. Can't create OCHNC DCN";
            } else if (cTCUserException instanceof WrongNetworkType) {
                string = string + "\nNetwork type is \"Not-DWDM\". Can't create OCHNC";
            }
            throw new CircuitProvError(string);
        }
        catch (AdminStateProvisioningError adminStateProvisioningError) {
            if (OchncCircuitNodeOperator.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)adminStateProvisioningError);
            }
            String string = "A connection cannot be created on the node " + this.getName() + ".";
            string = string + "\n" + adminStateProvisioningError.getMessage();
            throw new CircuitProvError(string);
        }
        if (this.getConn() == null) {
            if (OchncCircuitNodeOperator.dbgOn()) {
                db.println("Connection Models returned NULL connection ");
            }
            throw new CircuitProvError(ErrorMsg.getString((EID)NEMC.EID_ERROR_CONNECTION_OBJECT_PARAM_1, (Object)this.getName()) + this.getName());
        }
    }

    protected void createConn(ICircuitId iCircuitId, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n, int n2, ArrayList arrayList4, ArrayList arrayList5) throws PathInUse, InvalidPath, InvalidPortState, CTCUserException {
        this.prettyPrint(arrayList.toArray(new IOchncPathDefModel[0]), "input");
        this.prettyPrint(arrayList2.toArray(new IOchncPathDefModel[0]), "output");
        IOchncPathDefModel[][] iOchncPathDefModelArrayArray = new IOchncPathDefModel[][]{arrayList.toArray(new IOchncPathDefModel[0]), arrayList2.toArray(new IOchncPathDefModel[0])};
        this.createOchncConnOnNE(iCircuitId, iOchncPathDefModelArrayArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createOchncConnOnNE(ICircuitId iCircuitId, IOchncPathDefModel[][] iOchncPathDefModelArray) throws PathInUse, InvalidPath, InvalidPortState, CTCUserException {
        IOchncConnectionModel iOchncConnectionModel = null;
        int n = this.node.getConnectionType();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        boolean bl = ((OchncCircuitNode)this.node).isDCNNode();
        IOchncPathDefModel[] iOchncPathDefModelArray2 = iOchncPathDefModelArray[0];
        IOchncPathDefModel[] iOchncPathDefModelArray3 = iOchncPathDefModelArray[1];
        IOchncPathDefModel[] iOchncPathDefModelArray4 = null;
        AdminStateOpt adminStateOpt = new AdminStateOpt();
        adminStateOpt.setAdminState(this.node.getAdminState());
        ConnCreateAttrs connCreateAttrs = new ConnCreateAttrs();
        connCreateAttrs.setCktName(this.node.getConnName());
        connCreateAttrs.setAdminStateOpt(adminStateOpt);
        IConnectionModels iConnectionModels = this.node.getNodeModel().getConnectionModels();
        if (OchncCircuitNodeOperator.dbgOn()) {
            db.println("createOchncConnOnNE:connType=" + EnumStrings.getString(IConnectionType.class, (int)n));
        }
        Map map = TL1ObjectManager.instance().getTL1Conns();
        synchronized (map) {
            if (n == 0) {
                iOchncPathDefModelArray4 = new IOchncPathDefModel[]{iOchncPathDefModelArray2[0], iOchncPathDefModelArray3[0]};
            } else if (n == 12) {
                iOchncPathDefModelArray4 = new IOchncPathDefModel[]{iOchncPathDefModelArray2[0], iOchncPathDefModelArray2[1], iOchncPathDefModelArray3[0], iOchncPathDefModelArray3[1]};
            } else if (n == 20) {
                iOchncPathDefModelArray4 = new IOchncPathDefModel[]{iOchncPathDefModelArray2[0], iOchncPathDefModelArray2[1], iOchncPathDefModelArray3[0], iOchncPathDefModelArray3[1], iOchncPathDefModelArray2[2], iOchncPathDefModelArray3[2]};
            } else {
                if (OchncCircuitNodeOperator.dbgOn()) {
                    db.println("createOchncConnOnNE Unknown: connection type " + n);
                }
                return;
            }
            iOchncConnectionModel = iConnectionModels.createOchncConnection(iCircuitId, n, iOchncPathDefModelArray4, (IConnCreateAttrs)connCreateAttrs, bl);
            if (iOchncConnectionModel != null) {
                this.node.setConn((IConnectionModel)iOchncConnectionModel);
                if (NetCcatCircuit.isNullCircuitId(iCircuitId)) {
                    this.node.registerNullCircuitConnection(this.node.getNetElement(), iOchncConnectionModel);
                }
            }
        }
    }

    protected void fillInPathDefs(PathDefsHolder pathDefsHolder, boolean bl) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        boolean bl2;
        short s = this.node.getPathWidth();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        INetElement iNetElement = this.node.getNetElement();
        LinkedList linkedList = this.node.getOutSpans();
        LinkedList linkedList2 = this.node.getInSpans();
        List list = this.node.getDrops();
        boolean bl3 = netCcatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() && ((OchncCircuit)netCcatCircuit).isSrcOrDstNetElementForOCHNC(iNetElement);
        boolean bl4 = netCcatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() && ((OchncCircuit)netCcatCircuit).getSrcNetElementForOCHNC().equals(iNetElement);
        boolean bl5 = bl2 = netCcatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() && ((OchncCircuit)netCcatCircuit).getDstNetElementForOCHNC().equals(iNetElement) && !((OchncCircuit)netCcatCircuit).isColocatedOchTrail();
        if (OchncCircuitNodeOperator.dbgOn()) {
            db.println("Node " + this.node.getName() + " ottSrcDst =  " + bl3 + " ottSrc =  " + bl4 + " ottDstNCL = " + bl2);
        }
        for (NetCircuitSpan netCircuitSpan : linkedList2) {
            if (netCircuitSpan.isInternalSpan()) {
                pathDefsHolder.inPathDefs.add(0, netCircuitSpan.getPathDef(this.node, s));
                if (!OchncCircuitNodeOperator.dbgOn()) continue;
                db.println("Node " + this.node.getName() + " Internal inspan moved to pos 0 " + Integer.toHexString(netCircuitSpan.getInternalEntityIndex(this.node)));
                continue;
            }
            if (bl3 && bl2 && pathDefsHolder.inPathDefs.size() == 2) {
                pathDefsHolder.inPathDefs.add(0, netCircuitSpan.getPathDef(iNetElement, s));
                if (!OchncCircuitNodeOperator.dbgOn()) continue;
                db.println("Node " + this.node.getName() + " Inspan moved to pos 0 " + Integer.toHexString(netCircuitSpan.getEntityIndex(iNetElement)));
                continue;
            }
            if (bl3 && bl2 && linkedList2.size() == 2 && pathDefsHolder.inPathDefs.size() == 1) {
                pathDefsHolder.inPathDefs.add(0, netCircuitSpan.getPathDef(iNetElement, s));
                if (!OchncCircuitNodeOperator.dbgOn()) continue;
                db.println("Node " + this.node.getName() + " Inspan moved to pos 0 " + Integer.toHexString(netCircuitSpan.getEntityIndex(iNetElement)));
                continue;
            }
            pathDefsHolder.inPathDefs.add(netCircuitSpan.getPathDef(iNetElement, s));
            if (!OchncCircuitNodeOperator.dbgOn()) continue;
            db.println("Node " + this.node.getName() + "Inspan normal case " + Integer.toHexString(netCircuitSpan.getEntityIndex(iNetElement)));
        }
        for (NetCircuitSpan netCircuitSpan : linkedList) {
            if (netCircuitSpan.isInternalSpan()) {
                if (!OchncCircuitNodeOperator.dbgOn()) continue;
                db.println("Node " + this.node.getName() + "Internal outspan skipped" + Integer.toHexString(netCircuitSpan.getInternalEntityIndex(this.node)));
                continue;
            }
            if (netCcatCircuit.getCircuitTypeObj().isOchncType() && !list.isEmpty() && pathDefsHolder.outPathDefs.size() == 1) {
                pathDefsHolder.outPathDefs.add(0, netCircuitSpan.getPathDef(iNetElement, s));
                if (!OchncCircuitNodeOperator.dbgOn()) continue;
                db.println("Node " + this.node.getName() + " Outspan moved to pos 0 " + Integer.toHexString(netCircuitSpan.getEntityIndex(iNetElement)));
                continue;
            }
            if (bl3 && bl4 && pathDefsHolder.outPathDefs.size() == 2) {
                pathDefsHolder.outPathDefs.add(1, netCircuitSpan.getPathDef(iNetElement, s));
                if (!OchncCircuitNodeOperator.dbgOn()) continue;
                db.println("Node " + this.node.getName() + " Outspan moved to pos 1 " + Integer.toHexString(netCircuitSpan.getEntityIndex(iNetElement)));
                continue;
            }
            if (bl3 && bl2 && pathDefsHolder.outPathDefs.size() == 1) {
                pathDefsHolder.outPathDefs.add(0, netCircuitSpan.getPathDef(iNetElement, s));
                if (!OchncCircuitNodeOperator.dbgOn()) continue;
                db.println("Node " + this.node.getName() + " Outspan moved to pos 0 " + Integer.toHexString(netCircuitSpan.getEntityIndex(iNetElement)));
                continue;
            }
            pathDefsHolder.outPathDefs.add(netCircuitSpan.getPathDef(iNetElement, s));
            if (!OchncCircuitNodeOperator.dbgOn()) continue;
            db.println("Node " + this.node.getName() + " Outspan normal case" + Integer.toHexString(netCircuitSpan.getEntityIndex(iNetElement)));
        }
        for (NetCircuitSpan netCircuitSpan : linkedList) {
            if (!netCircuitSpan.isInternalSpan()) continue;
            if (netCcatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() && pathDefsHolder.outPathDefs.size() > 1) {
                pathDefsHolder.outPathDefs.add(1, netCircuitSpan.getPathDef(this.node, s));
                if (!OchncCircuitNodeOperator.dbgOn()) continue;
                db.println("Node " + this.node.getName() + " Internal outspan moved to pos 1 " + Integer.toHexString(netCircuitSpan.getInternalEntityIndex(this.node)));
                continue;
            }
            pathDefsHolder.outPathDefs.add(netCircuitSpan.getPathDef(this.node, s));
            if (!OchncCircuitNodeOperator.dbgOn()) continue;
            db.println("Node " + this.node.getName() + " Internal outspan normal case " + Integer.toHexString(netCircuitSpan.getInternalEntityIndex(this.node)));
        }
    }

    protected void connLocalDestroy(boolean bl) throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, VcatMemberInvalidState {
        ((IOchncConnectionModel)this.getConn()).localDestroy();
    }

    protected String prettyString(IOchncPathDefModel iOchncPathDefModel) {
        return this.getName() + "::" + Integer.toHexString(iOchncPathDefModel.getPortEntityIdx()) + "::" + iOchncPathDefModel.getOptChannel();
    }

    protected void prettyPrint(IOchncPathDefModel[] iOchncPathDefModelArray, String string) {
        for (int i = 0; i < iOchncPathDefModelArray.length; ++i) {
            if (!OchncCircuitNodeOperator.dbgOn()) continue;
            db.println(string + " OchncPath #" + i + " " + this.prettyString(iOchncPathDefModelArray[i]));
        }
    }
}

