/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.ncp.Connection;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SelectorConnection;
import cerent.util.SDebug;
import java.util.ArrayList;

public class OnewayConnection
extends Connection {
    private static final SDebug db = new SDebug("OnewayConnection");

    public OnewayConnection(String string) {
        super(string);
    }

    public boolean isOneway() {
        return true;
    }

    public boolean addInput(Object object) {
        if (this.inPuts.size() != 0) {
            if (this.dbgOn()) {
                db.println("ERROR! one input already present");
            }
            return false;
        }
        if (!this.checkEndPoint(object)) {
            return false;
        }
        this.inPuts.add(object);
        return true;
    }

    public boolean addOutput(Object object) {
        if (this.outPuts.size() >= 1) {
            if (this.dbgOn()) {
                db.println("ERROR! one output already present");
            }
            return false;
        }
        if (!this.checkEndPoint(object)) {
            return false;
        }
        this.outPuts.add(object);
        return true;
    }

    protected boolean isOpenEndedOnewayBlsrDriSecondaryDrop() {
        if (this.outPuts.size() == 1 && this.outPuts.get(0) instanceof NetCircuitEnd) {
            NetCircuitNode netCircuitNode = this.getNode();
            if (netCircuitNode == null || netCircuitNode.connections.size() != 1) {
                return false;
            }
            return this.isBlsrDriSecondary();
        }
        return false;
    }

    protected boolean isValidOpenEndedOnewayBlsrDriSecondaryDrop() {
        NetCircuitSpan netCircuitSpan;
        NetCircuitNode netCircuitNode = this.getNode();
        NetCircuitSpan netCircuitSpan2 = netCircuitSpan = this.inPuts.size() > 0 && this.inPuts.get(0) instanceof NetCircuitSpan ? (NetCircuitSpan)this.inPuts.get(0) : null;
        if (netCircuitNode == null || netCircuitSpan == null || !this.isOpenEndedOnewayBlsrDriSecondaryDrop()) {
            return false;
        }
        Connection connection = netCircuitNode.circuit.findBlsrDriPrimary(this);
        if (connection == null || !connection.isOpenEndedOnewayBlsrDriPrimaryDrop()) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(netCircuitSpan.getLink().isPca(netCircuitNode.getNetElement()) ? "true" : "defined");
        if (this.dbgOn()) {
            db.println("isValidOpenEndedOnewayBlsrDriSecondaryDrop: starting on the " + this.getName() + " connection on node " + netCircuitNode.getName() + " isSecondaryPath " + stringBuffer + " input span " + netCircuitSpan.prettyString());
        }
        int n = this.validDriHandoffPairCount(null, connection, netCircuitSpan, new StringBuffer(), stringBuffer, new ArrayList(), new ArrayList(), 0);
        if (this.dbgOn()) {
            String string = n == -1 ? "an invalid DRI handoff pair" : n + " valid DRI handoff " + (n == 1 ? "pair" : "pairs");
            db.println("isValidOpenEndedOnewayBlsrDriSecondaryDrop: Found " + string + " feeding the " + this.getName() + " connection on node " + netCircuitNode.getName());
        }
        boolean bl = n == 1;
        netCircuitNode.circuit.driConfigurationError = !bl;
        return bl;
    }

    protected SelectorConnection getUpsrDriSelector() {
        Connection connection;
        NetCircuitNode netCircuitNode = this.getNode();
        if (netCircuitNode != null && (connection = netCircuitNode.findConnectionWithOutput(this.inPuts.get(0))) != null && connection.isSelector() && connection.hasInternalCircuitSpanInput()) {
            return (SelectorConnection)connection;
        }
        return null;
    }

    protected boolean hasValidUpsrDriHandoffInterconnect(Connection connection) {
        SelectorConnection selectorConnection = this.getUpsrDriSelector();
        SelectorConnection selectorConnection2 = connection.getUpsrDriSelector();
        if (selectorConnection == null || selectorConnection2 == null) {
            return false;
        }
        return selectorConnection.hasValidUpsrDriHandoffInterconnect(selectorConnection2);
    }
}

