/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.util.SDebug;

public class RollCreateInfo {
    protected int rollMode;
    protected INetCircuitEnd rollFromCktEnd;
    protected INetCircuitEnd rollToCktEnd;
    protected INetCircuit fromCircuit;
    protected INetCircuit toCircuit;
    protected short circuitRollNumber;
    protected short circuitRollMode;
    private static final SDebug db = new SDebug("RollCreateInfo");

    public RollCreateInfo(INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2, int n, INetCircuit iNetCircuit, INetCircuit iNetCircuit2, short s, short s2) {
        if (!(iNetCircuit.getCircuitTypeObj().isTunnelCircuitType() || iNetCircuit.getCircuitTypeObj().isLAPCircuitType() || iNetCircuit.getCircuitTypeObj().isEthernetCircuitType())) {
            this.rollFromCktEnd = NetCircuitEndFactory.createCircuitEnd(iNetCircuit.getCircuitType(), iNetCircuitEnd);
            this.rollToCktEnd = NetCircuitEndFactory.createCircuitEnd(iNetCircuit.getCircuitType(), iNetCircuitEnd2);
        } else {
            this.rollFromCktEnd = new HoCircuitEnd(iNetCircuitEnd);
            this.rollToCktEnd = new HoCircuitEnd(iNetCircuitEnd2);
        }
        this.rollMode = n;
        this.fromCircuit = iNetCircuit;
        this.toCircuit = iNetCircuit2;
        this.circuitRollNumber = s;
        this.circuitRollMode = s2;
    }

    public INetCircuitEnd getRollFromNetCircuitEnd() {
        return this.rollFromCktEnd;
    }

    public void setRollFromNetCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        this.rollFromCktEnd = iNetCircuitEnd;
    }

    public INetCircuitEnd getRollToNetCircuitEnd() {
        return this.rollToCktEnd;
    }

    public void setRollToNetCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        this.rollToCktEnd = iNetCircuitEnd;
    }

    private IHoPathDefModel getHoPath(INetCircuitEnd iNetCircuitEnd) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        ICircuitSize iCircuitSize = this.fromCircuit.getCircuitSizeObj();
        short s = iCircuitSize.size2widthOfHoCircuit();
        return (IHoPathDefModel)((NetCircuitEnd)iNetCircuitEnd).getPathDef(s);
    }

    private ILoDefModel getLoPath(INetCircuitEnd iNetCircuitEnd) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        ICircuitSize iCircuitSize = this.fromCircuit.getCircuitSizeObj();
        short s = iCircuitSize.size2widthOfLoCircuit();
        return (ILoDefModel)((NetCircuitEnd)iNetCircuitEnd).getPathDef(s);
    }

    public IHoPathDefModel getRollFromHoPath() throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        return this.getHoPath(this.rollFromCktEnd);
    }

    public IHoPathDefModel getRollToHoPath() throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        return this.getHoPath(this.rollToCktEnd);
    }

    public ILoDefModel getRollFromLoPath() throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        return this.getLoPath(this.rollFromCktEnd);
    }

    public ILoDefModel getRollToLoPath() throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        return this.getLoPath(this.rollToCktEnd);
    }

    public int getRollMode() {
        return this.rollMode;
    }

    public void setRollMode(int n) {
        this.rollMode = n;
    }

    public INetCircuit getRollFromCircuit() {
        return this.fromCircuit;
    }

    public void setRollFromCircuit(INetCircuit iNetCircuit) {
        this.fromCircuit = iNetCircuit;
    }

    public INetCircuit getRollToCircuit() {
        return this.toCircuit;
    }

    public void setRollToCircuit(INetCircuit iNetCircuit) {
        this.toCircuit = iNetCircuit;
    }

    public short getCircuitRollNumber() {
        return this.circuitRollNumber;
    }

    public void setCircuitNumber(short s) {
        this.circuitRollNumber = s;
    }

    public short getCircuitRollMode() {
        return this.circuitRollMode;
    }

    public void setCircuitRollMode(short s) {
        this.circuitRollMode = s;
    }
}

