/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.IPathDefModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.SvlanPathDefModel;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SvlanCircuit;
import cerent.cms.ncp.SvlanCircuitNode;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.INetElement;
import cerent.util.SDebug;

public class SvlanCircuitSpan
extends NetCircuitSpan {
    private static final SDebug db = new SDebug("SvlanCircuitSpan");
    private short svlan;

    public SvlanCircuitSpan(NetCcatCircuit netCcatCircuit, NetLinkSpan netLinkSpan, INetCircuitNode iNetCircuitNode, INetCircuitNode iNetCircuitNode2) {
        super(netCcatCircuit, netLinkSpan, iNetCircuitNode, iNetCircuitNode2);
        this.svlan = ((SvlanCircuit)netCcatCircuit).getSvlan();
        if (this.dbgOn()) {
            db.println("SvlanCircuitSpan object instantiated");
        }
    }

    protected short getSvlan() {
        return this.svlan;
    }

    protected void setState(NetCircuitNode netCircuitNode, int n) {
        if (this.getLink().getSrcEntityIndex() == ((SvlanCircuitNode)netCircuitNode).getInternalEntityIdx()) {
            this.setSrcState(n);
        } else {
            this.setDstState(n);
        }
    }

    protected IPathDefModel getPathDef(NetCircuitNode netCircuitNode, short s) throws ObjNotFound {
        INetElement iNetElement = netCircuitNode.getNetElement();
        if (this.dbgOn()) {
            db.println("getPathDef: SVLAN " + this.svlan + " EntIdx " + Integer.toHexString(((SvlanCircuitNode)netCircuitNode).getInternalEntityIdx()));
        }
        SvlanPathDefModel svlanPathDefModel = new SvlanPathDefModel(iNetElement.getNodeModel(), this.svlan, ((SvlanCircuitNode)netCircuitNode).getInternalEntityIdx(), s);
        return svlanPathDefModel;
    }

    protected IPathDefModel getPathDef(INetElement iNetElement, short s) throws ObjNotFound {
        if (this.dbgOn()) {
            db.println("getPathDef: SVLAN " + this.svlan + " EntIdx " + Integer.toHexString(this.getEntityIndex(iNetElement)));
        }
        SvlanPathDefModel svlanPathDefModel = new SvlanPathDefModel(iNetElement.getNodeModel(), this.svlan, this.getEntityIndex(iNetElement), s);
        return svlanPathDefModel;
    }

    protected boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected void debug(String string) {
        db.println(string);
    }
}

