/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.model.CircuitSize;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.route.AbstractLabelSet;
import cerent.cms.route.CircuitPath;
import cerent.cms.route.DriNodePair;
import cerent.cms.route.DriNodes;
import cerent.cms.route.DriPathFilter;
import cerent.cms.route.HoLabelSet;
import cerent.cms.route.IGranularityFilter;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.IPathFilter;
import cerent.cms.route.ISrg;
import cerent.cms.route.LabelSetFactory;
import cerent.cms.route.LabelSrg;
import cerent.cms.route.LoLabelSet;
import cerent.cms.route.LotLabelSet;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.route.TsiConstraint;
import cerent.cms.route.TsiRingConstraint;
import cerent.cms.route.VcatFilter;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.util.ComparisonUtil;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import cerent.util.ILoNum;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public abstract class GranularityFilter
implements IGranularityFilter {
    RoutePrefs prefs;
    VcatFilter vcatFilter;
    IPathFilter pathFilter;

    private boolean isTunnelReachable(SptLink sptLink, boolean bl) {
        INetLink iNetLink = sptLink.getLink();
        this.prefs.getLog().getDebugLog().info("CRN: GranularityFilter: Checking for Tunnel Paths on " + iNetLink.prettyString() + "on SourceSide " + bl);
        if (this.prefs.isLoCircuit()) {
            ILabelSet iLabelSet = null;
            ITdmProtocolType iTdmProtocolType = bl ? iNetLink.getSrc().getNodeModel().getTdmProtocolTypeObj() : iNetLink.getDst().getNodeModel().getTdmProtocolTypeObj();
            ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)this.prefs.getBandwidth());
            int n = this.prefs.getCircuitType();
            int n2 = NetCircuitManager.instance().calcFramingType(n, iCircuitSize.getEnum());
            int n3 = CircuitSize.getLoTunnelSize((int)n2).getEnum();
            int n4 = iTdmProtocolType.getTunnelCircuitType();
            iLabelSet = bl ? iNetLink.getSrcLabelSet(n3, n4) : iNetLink.getDstLabelSet(n3, n4);
            if (iLabelSet != null && iLabelSet.size() != 0) {
                return true;
            }
        }
        return false;
    }

    protected void isUsableGranularityCheck(SptLink sptLink) throws xLinkNotUsable {
        Object object5;
        Object object2;
        Object object3;
        Object object4;
        ILabelSet iLabelSet = null;
        ILabelSet iLabelSet2 = null;
        Network network = Network.instance();
        if (network == null) {
            this.prefs.getLog().getDebugLog().info("Couldn't get network object");
        }
        INetLink iNetLink = sptLink.getLink();
        iNetLink.isUsable(this.prefs, sptLink.getParentLink());
        LinkedList linkedList = this.prefs.getRequiredSpans(iNetLink);
        if (linkedList.size() != 0) {
            for (NetLinkSpan netLinkSpan : linkedList) {
                if (iLabelSet == null) {
                    if (iNetLink.isLOTunnel() || iNetLink.isLAP()) {
                        iLabelSet = new LotLabelSet();
                        iLabelSet2 = new LotLabelSet();
                    } else {
                        iLabelSet = LabelSetFactory.create(netLinkSpan.getSrcLabel());
                        iLabelSet2 = LabelSetFactory.create(netLinkSpan.getDstLabel());
                    }
                }
                iLabelSet.addLabel(netLinkSpan.getSrcLabel());
                iLabelSet2.addLabel(netLinkSpan.getDstLabel());
            }
        } else {
            boolean bl;
            iLabelSet = iNetLink.getSrcLabelSet(this.prefs.getBandwidth(), this.prefs.getCircuitType());
            if (iLabelSet == null) {
                bl = true;
                if (!this.prefs.needOptimalPath() && this.isTunnelReachable(sptLink, true)) {
                    bl = false;
                }
                if (bl) {
                    throw new xLinkNotUsable("GranularityFilter: Null srcLabelSet for link ");
                }
            }
            if ((iLabelSet2 = iNetLink.getDstLabelSet(this.prefs.getBandwidth(), this.prefs.getCircuitType())) == null) {
                bl = true;
                if (!this.prefs.needOptimalPath() && this.isTunnelReachable(sptLink, false)) {
                    bl = false;
                }
                if (bl) {
                    throw new xLinkNotUsable("GranularityFilter: Null dstLabelSet for link ");
                }
            }
        }
        if (!this.prefs.needOptimalPath()) {
            return;
        }
        LinkedList linkedList2 = this.prefs.getActiveMember().getExcludeSpans();
        Iterator iterator = linkedList2.iterator();
        INetLink iNetLink2 = null;
        if (network != null) {
            iNetLink2 = network.findReverseLink(iNetLink);
        }
        while (iterator.hasNext()) {
            object4 = (NetLinkSpan)iterator.next();
            if (((Object)((NetLinkSpan)object4).getLink()).equals(iNetLink)) {
                iLabelSet.removeLabel(((NetLinkSpan)object4).getSrcLabel());
                iLabelSet2.removeLabel(((NetLinkSpan)object4).getDstLabel());
            }
            if (iNetLink2 == null || !((Object)((NetLinkSpan)object4).getLink()).equals(iNetLink2)) continue;
            iLabelSet.removeLabel(((NetLinkSpan)object4).getDstLabel());
            iLabelSet2.removeLabel(((NetLinkSpan)object4).getSrcLabel());
        }
        this.deleteExcludedLabels(iNetLink.getSrc(), iNetLink.getSrcSlotNumber(), iNetLink.getSrcPortNumber(), iLabelSet, this.prefs.getActiveMember().getExcludeSrgs());
        this.deleteExcludedLabels(iNetLink.getDst(), iNetLink.getDstSlotNumber(), iNetLink.getDstPortNumber(), iLabelSet2, this.prefs.getActiveMember().getExcludeSrgs());
        object4 = this.prefs.getParentFilter();
        if (object4 != null && iNetLink.inBLSR()) {
            if (!(object4 instanceof DriPathFilter)) {
                this.prefs.getLog().getDebugLog().info("ERROR -- Parent filter is not DriPAthFilter");
            } else {
                object3 = (DriPathFilter)object4;
                this.prefs.getLog().getDebugLog().info("CHECKING for TsiRingCons on link" + iNetLink.prettyString());
                object2 = ((DriPathFilter)object3).getActiveDriNodes().getTsiRingConstraint(iNetLink.blsrRingName());
                if (object2 != null) {
                    this.prefs.getLog().getDebugLog().info("Got TsiRingConstraint for ring " + ((TsiRingConstraint)object2).getRingName() + "label" + ((TsiRingConstraint)object2).prettyString());
                    if (iLabelSet != null) {
                        iLabelSet.intersect(((TsiRingConstraint)object2).getLabelSet());
                    }
                }
            }
        }
        object3 = this.prefs.getTsiConstraints(iNetLink.getSrc(), iNetLink.inBLSR() ? iNetLink.originatingRingName() : "");
        object2 = this.prefs.getTsiConstraints(iNetLink.getDst(), iNetLink.inBLSR() ? iNetLink.terminatingRingName() : "");
        if (object3.size() != 0) {
            iterator = iLabelSet.getLabelSet().iterator();
            block2: while (iterator.hasNext()) {
                object5 = (ILabel)iterator.next();
                if (iNetLink.isLAP()) {
                    if (object3.containsKey(object5)) continue;
                    for (TsiConstraint tsiConstraint : object3.values()) {
                        if (((IHoLoNum)tsiConstraint.getLabel()).getLoNum() == ((IHoLoNum)object5).getLoNum()) continue;
                        this.prefs.getLog().getDebugLog().info("Removing Label " + object5.prettyString() + " from Src Label set since it doesn't match LAP TSI constraint");
                        iterator.remove();
                        continue block2;
                    }
                    continue;
                }
                if (object3.containsKey(object5)) continue;
                this.prefs.getLog().getDebugLog().info("Removing Label " + object5.prettyString() + " from Src Label set since it doesn't match TSI constraint");
                iterator.remove();
            }
        }
        if (object2.size() != 0) {
            iterator = iLabelSet2.getLabelSet().iterator();
            block4: while (iterator.hasNext()) {
                object5 = (ILabel)iterator.next();
                if (iNetLink.isLAP()) {
                    if (object2.containsKey(object5)) continue;
                    for (TsiConstraint tsiConstraint : object2.values()) {
                        if (((IHoLoNum)tsiConstraint.getLabel()).getLoNum() == ((IHoLoNum)object5).getLoNum()) continue;
                        this.prefs.getLog().getDebugLog().info("Removing Label " + object5.prettyString() + " from Dst Label set since it doesn't match LAP TSI constraint");
                        iterator.remove();
                        continue block4;
                    }
                    continue;
                }
                if (object2.containsKey(object5)) continue;
                this.prefs.getLog().getDebugLog().info("Removing Label " + object5.prettyString() + " from Dst Label set since it doesn't match TSI constraint");
                iterator.remove();
            }
        }
        if (this.prefs.getDriNodePrefs().size() != 0 && iNetLink.inBLSR() && object4 == null) {
            if (network != null) {
                object5 = this.findDriSecondaryLabels(sptLink, network);
                if (object5 == null) {
                    this.prefs.getLog().getDebugLog().info("No secondary labels for link" + iNetLink.prettyString());
                } else {
                    if (iLabelSet != null) {
                        iLabelSet.intersect((ILabelSet)object5);
                    }
                    if (iLabelSet2 != null) {
                        iLabelSet2.intersect((ILabelSet)object5);
                    }
                }
            }
            for (Object object5 : linkedList2) {
                if (!((NetLinkSpan)object5).getLink().blsrRingName().equals(iNetLink.blsrRingName())) continue;
                if (iLabelSet != null) {
                    iLabelSet.removeLabel(((NetLinkSpan)object5).getSrcLabel());
                }
                if (iLabelSet2 == null) continue;
                iLabelSet2.removeLabel(((NetLinkSpan)object5).getDstLabel());
            }
        }
        sptLink.setLabelSets(iLabelSet, iLabelSet2, this.prefs);
    }

    public boolean isUsable(SptLink sptLink) throws xLinkNotUsable {
        this.isUsableGranularityCheck(sptLink);
        return this.vcatFilter.isUsable(sptLink);
    }

    public CircuitPath getCircuitPath() throws NoRoute {
        return this.pathFilter.getCircuitPath();
    }

    public INetElement[] getReachableNodes() {
        return this.pathFilter.getReachableNodes();
    }

    private void deleteExcludedLabels(INetElement iNetElement, int n, int[] nArray, ILabelSet iLabelSet, Set set) {
        for (ISrg iSrg : set) {
            LabelSrg labelSrg;
            if (!(iSrg instanceof LabelSrg) || (labelSrg = (LabelSrg)iSrg).getNe() != iNetElement || labelSrg.getSlot() != n || ComparisonUtil.compare((int[])labelSrg.getPort(), (int[])nArray) != 0) continue;
            this.info("considering excluded label srg " + labelSrg.prettyString());
            ILabel iLabel = labelSrg.getLabel();
            if (!(iLabel instanceof IHoNum) || !(iLabelSet instanceof LoLabelSet) && !(iLabelSet instanceof LotLabelSet)) continue;
            Iterator iterator = iLabelSet.getLabelSet().iterator();
            while (iterator.hasNext()) {
                IHoLoNum iHoLoNum = (IHoLoNum)iterator.next();
                if (!iHoLoNum.getHoNum().equals(iLabel)) continue;
                this.info("removing label " + iHoLoNum.prettyString() + " from label set");
                iterator.remove();
            }
        }
    }

    private IHoNum calcPcaStartingHo(int n, NetLink netLink) {
        int n2 = netLink.getPhysicalSize() / 2 + 1;
        return HoLoFactory.idlSts2HoNum(n, n2);
    }

    private ILabelSet convert2FPcaToBlsrLabelSet(NetLink netLink, ILabelSet iLabelSet, int n) {
        AbstractLabelSet abstractLabelSet;
        boolean bl = true;
        if (iLabelSet == null) {
            return null;
        }
        if (iLabelSet instanceof LoLabelSet) {
            abstractLabelSet = new LoLabelSet();
        } else if (iLabelSet instanceof LotLabelSet) {
            abstractLabelSet = new LotLabelSet();
        } else {
            abstractLabelSet = new HoLabelSet();
            bl = false;
        }
        Iterator iterator = iLabelSet.getLabelSet().iterator();
        while (iterator.hasNext()) {
            ILoNum iLoNum;
            IHoNum iHoNum;
            IHoLoNum iHoLoNum;
            if (bl) {
                iHoLoNum = (IHoLoNum)iterator.next();
                iHoNum = iHoLoNum.getHoNum();
                iLoNum = iHoLoNum.getLoNum();
                IHoNum iHoNum2 = this.calcPcaStartingHo(iHoNum.getFramingType(), netLink);
                IHoNum iHoNum3 = HoLoFactory.removeOffset(iHoNum, iHoNum2);
                IHoLoNum iHoLoNum2 = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
                abstractLabelSet.addLabel((ILabel)iHoLoNum2);
                continue;
            }
            iHoLoNum = (IHoNum)iterator.next();
            iHoNum = this.calcPcaStartingHo(iHoLoNum.getFramingType(), netLink);
            iLoNum = HoLoFactory.removeOffset((IHoNum)iHoLoNum, iHoNum);
            abstractLabelSet.addLabel((ILabel)iLoNum);
        }
        return abstractLabelSet;
    }

    private ILabelSet findDriSecondaryLabels(SptLink sptLink, Network network) {
        INetLink iNetLink = sptLink.getLink();
        INetElement iNetElement = iNetLink.getSrc();
        INetElement iNetElement2 = iNetLink.getDst();
        String string = iNetLink.blsrRingName();
        for (DriNodes driNodes : this.prefs.getDriNodePrefs()) {
            for (DriNodePair driNodePair : driNodes.getNodePairs()) {
                INetElement iNetElement3 = driNodePair.getPrimary();
                INetElement iNetElement4 = driNodePair.getSecondary();
                if (!iNetElement3.equals(iNetElement) && !iNetElement3.equals(iNetElement2) && !iNetElement4.equals(iNetElement)) continue;
                if (iNetElement3.equals(iNetElement)) {
                    String string2;
                    INetLink iNetLink2 = sptLink.getParentLink();
                    String string3 = string2 = iNetLink2 == null ? "" : iNetLink2.blsrRingName();
                    if (iNetLink2 != null && string != null && string2 != null && iNetLink2.inBLSR() && string2.equals(string)) {
                        this.info("========== opposite side routing skipping");
                        continue;
                    }
                }
                if (iNetElement3.equals(iNetElement2) && !driNodes.getFirstDriRing().equals("")) {
                    return this.getDriLabelsOnRing(iNetElement3, iNetElement4, iNetLink, driNodes.getFirstDriRing(), driNodes.isSecPca(), network);
                }
                if (iNetElement3.equals(iNetElement) && !driNodes.getSecondDriRing().equals("")) {
                    return this.getDriLabelsOnRing(iNetElement3, iNetElement4, iNetLink, driNodes.getSecondDriRing(), driNodes.isSecPca(), network);
                }
                if (!iNetElement4.equals(iNetElement) || driNodes.getSecondDriRing().equals("")) continue;
                return this.getDriLabelsOnRing(iNetElement4, iNetElement3, iNetLink, driNodes.getSecondDriRing(), driNodes.isSecPca(), network);
            }
        }
        return null;
    }

    private ILabelSet getDriLabelsOnRing(INetElement iNetElement, INetElement iNetElement2, INetLink iNetLink, String string, boolean bl, Network network) {
        INetElement iNetElement3 = iNetElement;
        INetElement iNetElement4 = null;
        INetElement iNetElement5 = iNetLink.getSrc();
        INetElement iNetElement6 = iNetLink.getDst();
        ILabelSet iLabelSet = null;
        ILabelSet iLabelSet2 = null;
        ILabelSet iLabelSet3 = null;
        this.info("Checking for Dri Secondary Labels:");
        int n = 0;
        while (!iNetElement3.equals(iNetElement2)) {
            if (n++ > 31) {
                this.info("GetDriLabelsOnRing: Exceeding Max iterations " + n);
                return iLabelSet3;
            }
            LinkedList linkedList = (LinkedList)network.findAllNetLinksWithNetElem(iNetElement3);
            for (INetLink iNetLink2 : linkedList) {
                if (!(iNetLink2 instanceof NetLink) || !iNetLink2.inBLSR() || !string.equals(iNetLink2.blsrRingName()) || !iNetLink2.getSrc().equals(iNetElement3) || iNetLink2.getDst().equals(iNetElement4) || iNetLink2.getSrc().equals(iNetElement5) && iNetLink2.getDst().equals(iNetElement6) || iNetLink2.getDst().equals(iNetElement5) && iNetLink2.getSrc().equals(iNetElement6)) continue;
                NetLink netLink = (NetLink)iNetLink2;
                this.info("Considering link -" + netLink.prettyString());
                if (bl) {
                    if (netLink.isWorkingBlsr()) continue;
                    if (netLink.getProtectionType() == 5) {
                        iLabelSet = netLink.getSrcLabelSet(this.prefs.getBandwidth(), this.prefs.getCircuitType());
                        iLabelSet2 = netLink.getDstLabelSet(this.prefs.getBandwidth(), this.prefs.getCircuitType());
                        ILabelSet iLabelSet4 = this.convert2FPcaToBlsrLabelSet(netLink, iLabelSet, this.prefs.getCircuitType());
                        ILabelSet iLabelSet5 = this.convert2FPcaToBlsrLabelSet(netLink, iLabelSet2, this.prefs.getCircuitType());
                        if (iLabelSet4 != null) {
                            iLabelSet4.intersect(iLabelSet5);
                        }
                        if (iLabelSet3 == null) {
                            iLabelSet3 = iLabelSet4;
                        } else {
                            iLabelSet3.intersect(iLabelSet4);
                        }
                        iNetElement4 = iNetElement3;
                        iNetElement3 = netLink.getDst();
                        break;
                    }
                    if (netLink.getProtectionType() != 6) continue;
                    iLabelSet = netLink.getSrcLabelSet(this.prefs.getBandwidth(), this.prefs.getCircuitType());
                    iLabelSet2 = netLink.getDstLabelSet(this.prefs.getBandwidth(), this.prefs.getCircuitType());
                    if (iLabelSet != null) {
                        iLabelSet.intersect(iLabelSet2);
                    }
                    if (iLabelSet3 == null) {
                        iLabelSet3 = iLabelSet;
                    } else {
                        iLabelSet3.intersect(iLabelSet);
                    }
                    iNetElement4 = iNetElement3;
                    iNetElement3 = netLink.getDst();
                    break;
                }
                if (!netLink.isWorkingBlsr()) continue;
                iLabelSet = netLink.getSrcLabelSet(this.prefs.getBandwidth(), this.prefs.getCircuitType());
                iLabelSet2 = netLink.getDstLabelSet(this.prefs.getBandwidth(), this.prefs.getCircuitType());
                if (iLabelSet != null) {
                    iLabelSet.intersect(iLabelSet2);
                }
                if (iLabelSet3 == null) {
                    iLabelSet3 = iLabelSet;
                } else {
                    iLabelSet3.intersect(iLabelSet);
                }
                iNetElement4 = iNetElement3;
                iNetElement3 = netLink.getDst();
                break;
            }
            if (!iNetElement3.equals(iNetElement)) continue;
            this.info("Current Equals Src -- This should never happen!");
            break;
        }
        return iLabelSet3;
    }

    private void info(String string) {
        this.prefs.getLog().getDebugLog().info(string);
    }
}

