/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.route.CircuitPath;
import cerent.cms.route.DropPath;
import cerent.cms.route.IGranularityFilter;
import cerent.cms.route.InvalidCircuitPath;
import cerent.cms.route.MemberPath;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.PathFilter;
import cerent.cms.route.PathSegment;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.LmpDataLinkNetLink;
import cerent.cms.topo.OchncFilterManager;
import cerent.cms.topo.VirtualNetLink;
import java.util.LinkedList;

public class OchncPathFilter
extends PathFilter {
    public OchncPathFilter(RoutePrefs routePrefs, IGranularityFilter iGranularityFilter) {
        super(routePrefs, iGranularityFilter);
    }

    public CircuitPath getCircuitPath() throws NoRoute {
        CircuitPath circuitPath = super.getCircuitPath();
        if (this.prefs.getDirectionality() == 3) {
            Object object;
            Object object22;
            DropPath dropPath = new DropPath(circuitPath);
            this.prefs.getLog().getDebugLog().info(" ===================== ");
            this.prefs.getLog().getDebugLog().info("Retrieving reverse path");
            this.prefs.getLog().getDebugLog().info(" ===================== ");
            LinkedList linkedList = circuitPath.getDropPath().getSpans();
            LinkedList<NetLinkSpan> linkedList2 = new LinkedList<NetLinkSpan>();
            for (Object object22 : linkedList) {
                object = object22.getLink();
                INetLink iNetLink = null;
                iNetLink = OchncFilterManager.findLinkForReversePath((INetLink)object, this.prefs.getLog().getDebugLog());
                if (iNetLink == null) {
                    throw new NoRoute("Cannot find opposite link of " + object.prettyString() + " for reverse path");
                }
                NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink, iNetLink.getReverseLink());
                linkedList2.addFirst(netLinkSpan);
            }
            object22 = new MemberPath(dropPath);
            object = new PathSegment();
            ((PathSegment)object).setPrimary(linkedList2);
            ((MemberPath)object22).addPathSegment((PathSegment)object);
            dropPath.addMemberPath((MemberPath)object22);
            try {
                circuitPath.setReverseDropPath(dropPath);
            }
            catch (InvalidCircuitPath invalidCircuitPath) {
                this.prefs.getLog().getDebugLog().info("Reverse Drop Path already set: " + invalidCircuitPath.getMessage());
                throw new NoRoute(invalidCircuitPath.getMessage(), this.prefs.getLog().getDetailedLog());
            }
        }
        return circuitPath;
    }

    public boolean isUsable(SptLink sptLink) throws xLinkNotUsable {
        INetLink iNetLink = sptLink.getLink();
        if (!this.prefs.isOchncCircuit() && !this.prefs.isOchTrailTunnelCircuit()) {
            throw new xLinkNotUsable("OCHNC path filter can be used only for OCHNC and OCH-Trail circuits");
        }
        if (!(iNetLink.isTemporarySptLink() || iNetLink instanceof DwdmNetLink || iNetLink instanceof VirtualNetLink || this.prefs.isOchTrailTunnelCircuit() || iNetLink instanceof LmpDataLinkNetLink)) {
            throw new xLinkNotUsable("OCHNC/OCH-Trail circuits can be routed only through OTS/PPC Links");
        }
        if (iNetLink.isVirtual()) {
            VirtualNetLink virtualNetLink = (VirtualNetLink)iNetLink;
            try {
                if (this.prefs.isOchncCircuit()) {
                    virtualNetLink.checkIsUsableForOchnc(this.prefs);
                } else {
                    virtualNetLink.checkIsUsableForOchTrail(this.prefs);
                }
            }
            catch (xLinkNotUsable xLinkNotUsable2) {
                throw xLinkNotUsable2;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                throw new xLinkNotUsable("Cannot verify usability: " + abstractCmsNoSuchEntityException.getMessage());
            }
        }
        return super.isUsable(sptLink);
    }
}

