/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.IIpAddr;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOspfAdv;
import cerent.cms.model.IOspfLSA;
import cerent.cms.model.IServerTrailEnd;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.topo.IPartitioner;
import cerent.cms.topo.ManualPartitioner;
import cerent.cms.topo.Network;
import cerent.cms.topo.Topology;
import cerent.cms.topo.TopologyAgent;
import cerent.util.IIPAddressTranslator;
import cerent.util.IPAddressTranslator;
import cerent.util.SDebug;
import cerent.util.proxy.CtcProxyFactory;
import java.net.InetAddress;

public abstract class AbstractNodeIpPartitioner
implements IPartitioner {
    protected static final IIPAddressTranslator trans = IPAddressTranslator.instance();
    private static final SDebug sdb = new SDebug("Partitioner");
    private SDebug db;

    protected static String toActual(String string) {
        return trans.getActualAddressDisplay(string);
    }

    protected static String toActual(IIpAddr iIpAddr) {
        return AbstractNodeIpPartitioner.toActual(Topology.IpAddrString(iIpAddr));
    }

    protected AbstractNodeIpPartitioner(SDebug sDebug) {
        this.db = sDebug == null ? sdb : sDebug;
    }

    protected AbstractNodeIpPartitioner() {
        this.db = sdb;
    }

    protected boolean isMember(IIpAddr iIpAddr, int n) {
        boolean bl;
        block3: {
            if (iIpAddr == null) {
                return true;
            }
            String string = AbstractNodeIpPartitioner.toActual(Topology.IpAddrString(iIpAddr));
            bl = false;
            try {
                bl = this.isMember(string, n);
            }
            catch (RuntimeException runtimeException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)runtimeException);
            }
        }
        return bl;
    }

    protected abstract boolean isMember(String var1, int var2);

    protected abstract String getAllMembers();

    public final boolean isMember(IOspfLSA iOspfLSA, IOspfAdv iOspfAdv, long l, TopologyAgent topologyAgent) {
        int n;
        boolean bl = true;
        IIpAddr iIpAddr = null;
        String string = "null";
        if (iOspfLSA != null) {
            iIpAddr = iOspfLSA.getNodeIp();
            n = iOspfLSA.getNodeId();
            bl = this.isMember(iIpAddr, n);
            string = Topology.IpAddrString(iIpAddr);
            this.processCandidate(AbstractNodeIpPartitioner.toActual(string), n, bl);
        }
        if (bl && iOspfAdv != null) {
            iIpAddr = iOspfAdv.getNodeIp();
            n = iOspfAdv.getNodeId();
            bl = this.isMember(iIpAddr, n);
            this.processCandidate(AbstractNodeIpPartitioner.toActual(Topology.IpAddrString(iIpAddr)), n, bl);
        }
        this.postProcess(iOspfLSA, iOspfAdv, l);
        if (this.db.isFinestEnabled()) {
            String string2 = "LSA for " + string;
            this.db.finest("isMember(" + string2 + ", " + iOspfAdv + ", " + l + ") returned: " + bl);
        }
        return bl;
    }

    public boolean isMember(IServerTrailEnd iServerTrailEnd, INodeModel iNodeModel) {
        boolean bl = true;
        String string = null;
        if (iNodeModel != null) {
            int n = iNodeModel.getNodeId();
            string = AbstractNodeIpPartitioner.toActual(this.getIIpAddr(iNodeModel.getIpConfig()));
            bl = this.isMember(string, n);
            this.processCandidate(string, n, bl);
        }
        String string2 = "???";
        if (iServerTrailEnd != null) {
            string2 = AbstractNodeIpPartitioner.toActual(iServerTrailEnd.getPeerIpAddr());
            int n = -1;
            boolean bl2 = this.isMember(string2, -1);
            bl &= bl2;
            this.processCandidate(string2, n, bl2);
        }
        this.postProcess(iServerTrailEnd, iNodeModel);
        if (this.db.isFinestEnabled()) {
            String string3;
            if (iServerTrailEnd == null) {
                string3 = "null";
            } else {
                String string4;
                int n = (string4 = iServerTrailEnd.getClass().getName()).lastIndexOf(".");
                string3 = string4.substring(n < 0 ? 0 : n + 1);
                string3 = string3 + " to peer: " + string2;
            }
            this.db.finest("isMember(" + string3 + ", " + (iNodeModel == null ? "null" : iNodeModel.getName()) + ") returned: " + bl);
        }
        return bl;
    }

    public boolean isMember(IVirtualLinkModel iVirtualLinkModel, INodeModel iNodeModel) {
        boolean bl = true;
        String string = null;
        if (iNodeModel != null) {
            int n = iNodeModel.getNodeId();
            string = AbstractNodeIpPartitioner.toActual(this.getIIpAddr(iNodeModel.getIpConfig()));
            bl = this.isMember(string, n);
            this.processCandidate(string, n, bl);
        }
        String string2 = "???";
        String string3 = "???";
        if (iVirtualLinkModel != null) {
            string2 = AbstractNodeIpPartitioner.toActual(iVirtualLinkModel.getOrigNode());
            int n = -1;
            boolean bl2 = this.isMember(string2, -1);
            bl &= bl2;
            this.processCandidate(string2, n, bl2);
            string3 = AbstractNodeIpPartitioner.toActual(iVirtualLinkModel.getTermNode());
            n = -1;
            bl2 = this.isMember(string3, -1);
            bl &= bl2;
            this.processCandidate(string3, n, bl2);
        }
        this.postProcess(iVirtualLinkModel, iNodeModel);
        if (this.db.isFinestEnabled()) {
            String string4;
            if (iVirtualLinkModel == null) {
                string4 = "null";
            } else {
                String string5;
                int n = (string5 = iVirtualLinkModel.getClass().getName()).lastIndexOf(".");
                string4 = string5.substring(n < 0 ? 0 : n + 1);
                string4 = string4 + "from orig: " + string2 + " to term: " + string3;
            }
            this.db.finest("isMember(" + string4 + ", " + (iNodeModel == null ? "null" : iNodeModel.getName()) + ") returned: " + bl);
        }
        return bl;
    }

    protected IIpAddr getIIpAddr(IIpConfig iIpConfig) {
        IIpAddr iIpAddr = null;
        if (iIpConfig != null) {
            boolean bl = CtcProxyFactory.isIPv6Network();
            iIpAddr = bl && iIpConfig.getNodeMode() ? iIpConfig.getIpv6Address() : iIpConfig.getIpAddress();
        }
        return iIpAddr;
    }

    public void lastMember(long l, TopologyAgent topologyAgent) {
        if (this.db.on()) {
            String string = topologyAgent == null ? "null" : topologyAgent.getTopoHost().getActualAddressDisplay();
            this.db.println("AbstractIpPartitioner.lastMember(" + l + ", for topo host: " + string + ") enter");
        }
    }

    public void lastMember(INodeModel iNodeModel, IPartitioner.AdjacencyType adjacencyType) {
        if (this.db.on()) {
            this.db.println("AbstractIpPartitioner.lastMember('" + (iNodeModel == null ? "null" : iNodeModel.getName()) + "', " + (Object)((Object)adjacencyType) + ") enter");
        }
    }

    public boolean areNodesInSameTopo(InetAddress inetAddress, InetAddress inetAddress2) {
        return false;
    }

    protected void processCandidate(String string, int n, boolean bl) {
    }

    protected void postProcess(IOspfLSA iOspfLSA, IOspfAdv iOspfAdv, long l) {
    }

    protected void postProcess(IServerTrailEnd iServerTrailEnd, INodeModel iNodeModel) {
    }

    protected void postProcess(IVirtualLinkModel iVirtualLinkModel, INodeModel iNodeModel) {
    }

    static void initBuiltInPartitionerIfConfigured(Network network) {
        ManualPartitioner.initBuiltInPartitionerIfConfigured(network);
    }
}

