/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLinkManager;
import cerent.cms.topo.Network;
import cerent.cms.topo.NonRoutableNetLink;
import cerent.cms.topo.RoutableNetLink;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.LinkedList;

public class CompositeNetLink
extends RoutableNetLink {
    LinkedList nonTermLinkList;
    NonRoutableNetLink srcTermLink;
    NonRoutableNetLink dstTermLink;

    public CompositeNetLink(Network network, ILinkModel iLinkModel, NonRoutableNetLink nonRoutableNetLink, NonRoutableNetLink nonRoutableNetLink2, LinkedList linkedList) {
        super(network, iLinkModel, nonRoutableNetLink.getSrc(), nonRoutableNetLink2.getDst(), false, nonRoutableNetLink.getTopology(), nonRoutableNetLink.getTopoId());
        Object object2;
        if (this.db.on()) {
            this.db.println("Creating new Composite link:");
            this.db.println("    src NL => " + nonRoutableNetLink.prettyString());
            for (Object object2 : linkedList) {
                this.db.println("    intermediate NL => " + object2.prettyString());
            }
            this.db.println("    dst NL => " + nonRoutableNetLink2.prettyString());
        }
        this.srcTermLink = nonRoutableNetLink;
        this.dstTermLink = nonRoutableNetLink2;
        this.nonTermLinkList = new LinkedList(linkedList);
        this.setTopology();
        this.srcTermLink.addObserver(this);
        this.dstTermLink.addObserver(this);
        for (Object object2 : this.nonTermLinkList) {
            object2.addObserver((IObserver)this);
            if (this.linksList.contains(object2)) continue;
            this.linksList.add(object2);
        }
        if (!this.linksList.contains(nonRoutableNetLink)) {
            this.linksList.add(nonRoutableNetLink);
        }
        if (!this.linksList.contains(nonRoutableNetLink2)) {
            this.linksList.add(nonRoutableNetLink2);
        }
        object2 = this.linksList.iterator();
        boolean bl = false;
        while (object2.hasNext()) {
            INetLink iNetLink = (INetLink)object2.next();
            if (iNetLink.state() != 2) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.newState(2);
        } else {
            this.newState(1);
        }
    }

    protected void initializeDebug() {
        this.db = new CompositeNetLinkDebug("NLc" + CompositeNetLink.getDebugName(this.src.getHostName()) + "(" + Integer.toHexString(this.getSrcEntityIndex()) + ")-" + CompositeNetLink.getDebugName(this.dst.getHostName()) + "(" + Integer.toHexString(this.getDstEntityIndex()) + ")");
    }

    public boolean isRoutable() {
        return true;
    }

    public boolean isBlsrCapable() {
        return false;
    }

    public static CompositeNetLink getCompositeLink(INetLink iNetLink) {
        CompositeNetLink compositeNetLink = null;
        boolean bl = false;
        Collection collection = Network.instance().getNetLinks();
        for (INetLink iNetLink2 : collection) {
            if (!(iNetLink2 instanceof CompositeNetLink) || !(compositeNetLink = (CompositeNetLink)iNetLink2).contains(iNetLink)) continue;
            return compositeNetLink;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(INetLink iNetLink) {
        if (this.srcTermLink.equals(iNetLink) || this.dstTermLink.equals(iNetLink)) {
            return true;
        }
        LinkedList linkedList = this.nonTermLinkList;
        synchronized (linkedList) {
            for (INetLink iNetLink2 : this.nonTermLinkList) {
                if (!((Object)iNetLink2).equals(iNetLink)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getLinks() {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        linkedList.add(this.srcTermLink);
        LinkedList linkedList2 = this.nonTermLinkList;
        synchronized (linkedList2) {
            for (INetLink iNetLink : this.nonTermLinkList) {
                linkedList.add(iNetLink);
            }
        }
        linkedList.add(this.dstTermLink);
        return linkedList;
    }

    public void newState(int n) {
        ((LinkModel)this.linkModel).oldState(this.newState());
        if (this.db.on()) {
            this.db.println("newState: state = " + (n == 1 ? "Up" : "Down."));
        }
        if (n != this.oldState()) {
            if (n == 2) {
                if (this.db.on()) {
                    this.db.println("newState: old state => " + (this.oldState() == 1 ? "Up" : "Down") + " new state => " + (n == 1 ? "Up" : "Down"));
                }
                ((LinkModel)this.linkModel).newState(n);
                this.setChanged();
            } else if (this.srcTermLink.state() == 1 && this.dstTermLink.state() == 1) {
                int n2 = 1;
                for (NonRoutableNetLink nonRoutableNetLink : this.nonTermLinkList) {
                    if (nonRoutableNetLink.state() != 2) continue;
                    if (nonRoutableNetLink.getPhysicalLinkType() == 3 && this.nonTermLinkList.size() == 1 && this.srcTermLink.getProtectionType() == 7 && this.dstTermLink.getProtectionType() == 7) {
                        if (this.isProtectedOptLinkUp(nonRoutableNetLink)) break;
                        n2 = 2;
                        break;
                    }
                    n2 = 2;
                    break;
                }
                if (n2 == 1) {
                    if (this.db.on()) {
                        this.db.println("newState: old state => " + (this.oldState() == 1 ? "Up" : "Down") + " new state => " + (n == 1 ? "Up" : "Down"));
                    }
                    ((LinkModel)this.linkModel).newState(n);
                    this.setChanged();
                }
            }
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public int newState() {
        return ((LinkModel)this.linkModel).newState();
    }

    private boolean isProtectedOptLinkUp(NonRoutableNetLink nonRoutableNetLink) {
        boolean bl;
        block11: {
            bl = false;
            if (this.db.on()) {
                this.db.println("working optlink " + nonRoutableNetLink.prettyString() + " is DOWN, looking for its protect one");
            }
            int n = this.srcTermLink.getLinkModel().getYCableProtectPortEntityIndex();
            if (this.db.on()) {
                this.db.println("srcTermLink protected port entity index " + n);
            }
            int n2 = this.dstTermLink.getLinkModel().getYCableProtectPortEntityIndex();
            if (this.db.on()) {
                this.db.println("dstTermLink protected port entity index " + n2);
            }
            try {
                INetElement iNetElement = nonRoutableNetLink.getSrc();
                INodeModel iNodeModel = iNetElement.getNodeModel();
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                IModuleModel iModuleModel = iEntityModel.getModuleModel();
                INetElement iNetElement2 = nonRoutableNetLink.getDst();
                INodeModel iNodeModel2 = iNetElement2.getNodeModel();
                IEntityTableModel iEntityTableModel2 = iNodeModel2.getEntityTable();
                IEntityModel iEntityModel2 = iEntityTableModel2.getEntityModelByIndex(n2);
                IModuleModel iModuleModel2 = iEntityModel2.getModuleModel();
                if (iModuleModel instanceof IDwdmModuleModel && iModuleModel2 instanceof IDwdmModuleModel) {
                    INetLink iNetLink;
                    IDwdmModuleModel iDwdmModuleModel = (IDwdmModuleModel)iModuleModel;
                    int n3 = iDwdmModuleModel.getFirstTrunkEntityIndex();
                    if (this.db.on()) {
                        this.db.println("srcTermLink protected trunk port " + n3);
                    }
                    IDwdmModuleModel iDwdmModuleModel2 = (IDwdmModuleModel)iModuleModel2;
                    int n4 = iDwdmModuleModel2.getFirstTrunkEntityIndex();
                    if (this.db.on()) {
                        this.db.println("dstTermLink protected trunk port " + n4);
                    }
                    if ((iNetLink = Network.instance().findNetLink(iNetElement, n3, null, iNetElement2, n4, null, true, 1)) == null) {
                        iNetLink = Network.instance().findNetLink(iNetElement, n3, null, iNetElement2, n4, null, true, 6);
                    }
                    if (this.db.on() && iNetLink != null) {
                        this.db.println("Protect opt link " + iNetLink.prettyString());
                    }
                    if (iNetLink != null && iNetLink.state() == 1) {
                        bl = true;
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block11;
                this.db.println("Exception" + (Object)((Object)abstractCmsNoSuchEntityException));
            }
        }
        return bl;
    }

    protected void oldState(int n) {
        ((LinkModel)this.linkModel).oldState(n);
    }

    public int oldState() {
        return ((LinkModel)this.linkModel).oldState();
    }

    public int state() {
        return ((LinkModel)this.linkModel).state();
    }

    protected void setChecking(boolean bl) {
    }

    protected boolean inChecking() {
        return true;
    }

    protected void setOspfAreaId(long l) {
    }

    public long getOspfAreaId() {
        return 0L;
    }

    protected void refresh(int n, String string, byte by, int n2, int n3, int n4, int n5) {
    }

    protected void refresh(NonRoutableNetLink nonRoutableNetLink) {
        if (this.db.on()) {
            this.db.println("refresh: processing refresh request for NL " + nonRoutableNetLink.prettyString());
        }
        if (nonRoutableNetLink.equals(this.srcTermLink)) {
            this.setProtectionType(3);
            this.setPhysicalType(this.srcTermLink.getPhysicalType());
        }
        this.setCost();
        this.setTopology();
        if (nonRoutableNetLink.state() == 2 && nonRoutableNetLink.getPhysicalLinkType() == 3 && this.nonTermLinkList.size() == 1 && this.srcTermLink.getProtectionType() == 7 && this.dstTermLink.getProtectionType() == 7) {
            if (!this.isProtectedOptLinkUp(nonRoutableNetLink)) {
                this.newState(nonRoutableNetLink.state());
            }
        } else {
            this.newState(nonRoutableNetLink.state());
        }
    }

    private void setCost() {
        int n = 0;
        n += this.srcTermLink.getCost();
        n += this.dstTermLink.getCost();
        for (NonRoutableNetLink nonRoutableNetLink : this.nonTermLinkList) {
            n += nonRoutableNetLink.getCost();
        }
        this.setCost(n);
    }

    protected void setTopology() {
        this.topoId = this.srcTermLink.getTopoId();
        this.topology = this.srcTermLink.getTopology();
        for (NonRoutableNetLink nonRoutableNetLink : this.getNonTermLinks()) {
            if (nonRoutableNetLink.getTopoId() >= this.topoId) continue;
            this.topoId = nonRoutableNetLink.getTopoId();
            this.topology = nonRoutableNetLink.getTopology();
        }
        if (this.dstTermLink.getTopoId() < this.topoId) {
            this.topoId = this.dstTermLink.getTopoId();
            this.topology = this.dstTermLink.getTopology();
        }
        if (this.db.on()) {
            this.db.println("setTopology: topo = " + this.topology + ", topo id = " + this.topoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getNonTermLinks() {
        LinkedList linkedList;
        LinkedList linkedList2 = this.nonTermLinkList;
        synchronized (linkedList2) {
            linkedList = new LinkedList(this.nonTermLinkList);
        }
        return linkedList;
    }

    public void dispose() {
        super.dispose();
        if (this.net != null) {
            this.net.delete(this);
        }
        if (!this.srcTermLink.isDeleted()) {
            this.srcTermLink.setIsSpliced(false);
            NetLinkManager.instance().newNetLink(this.srcTermLink);
            this.srcTermLink.deleteObserver(this);
        }
        if (!this.dstTermLink.isDeleted()) {
            this.dstTermLink.setIsSpliced(false);
            NetLinkManager.instance().newNetLink(this.dstTermLink);
            this.dstTermLink.deleteObserver(this);
        }
        for (NonRoutableNetLink nonRoutableNetLink : this.nonTermLinkList) {
            if (nonRoutableNetLink.isDeleted()) continue;
            nonRoutableNetLink.setIsSpliced(false);
            NetLinkManager.instance().newNetLink(nonRoutableNetLink);
            nonRoutableNetLink.deleteObserver(this);
        }
        this.nonTermLinkList.clear();
    }

    protected void _update(Object object, Object object2) {
        if (object instanceof NonRoutableNetLink) {
            NonRoutableNetLink nonRoutableNetLink = (NonRoutableNetLink)object;
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED event from NL " + nonRoutableNetLink.toString());
                }
                this.refresh(nonRoutableNetLink);
            } else if (object2 == ModelUpdateType.DELETED) {
                if (this.db.on()) {
                    this.db.println("update: received DELETED event from NL " + nonRoutableNetLink.toString());
                }
                this.dispose();
            }
        } else if (object instanceof INodeModel.AbstractConnectionNotifier) {
            if (this.db.on()) {
                this.db.println("update: received event from AbstractConnectionNotifier");
            }
        } else if (this.db.on()) {
            this.db.println("update: received event from " + object.toString());
        }
    }

    public class CompositeNetLinkDebug
    extends SDebug {
        public CompositeNetLinkDebug(String string) {
            super(string);
        }

        public final void dump() {
            CompositeNetLink.this.db.println("======================================");
            CompositeNetLink.this.db.println("Src NL = " + CompositeNetLink.this.srcTermLink.toString());
            for (INetLink iNetLink : CompositeNetLink.this.nonTermLinkList) {
                CompositeNetLink.this.db.println("intermediate NL => " + iNetLink.toString());
            }
            CompositeNetLink.this.db.println("Dst NL = " + CompositeNetLink.this.dstTermLink.toString());
            CompositeNetLink.this.db.println("State = " + (CompositeNetLink.this.state() == 1 ? "Up" : "Down"));
            CompositeNetLink.this.db.println("Topology ID = " + CompositeNetLink.this.topoId);
            CompositeNetLink.this.db.println("NetLink Type = " + CompositeNetLink.this.getLinkTypeObj());
            CompositeNetLink.this.db.println("Protection Type = " + CompositeNetLink.this.getProtectionTypeObj());
            CompositeNetLink.this.db.println("Physical Type = " + CompositeNetLink.this.getPhysicalTypeObj().getDisplayString(CompositeNetLink.this.isSonetCapable()));
            CompositeNetLink.this.db.println("Src XC Capable = " + CompositeNetLink.this.isXcCapable());
            CompositeNetLink.this.db.println("Dst XC Capable = " + CompositeNetLink.this.isNbrXcCapable());
            CompositeNetLink.this.db.println("Src Slot = " + CompositeNetLink.this.srcSlot);
            CompositeNetLink.this.db.println("Src Port = " + CompositeNetLink.this.srcPort);
            CompositeNetLink.this.db.println("Dst Slot = " + CompositeNetLink.this.dstSlot);
            CompositeNetLink.this.db.println("Dst Port = " + CompositeNetLink.this.dstPort);
            CompositeNetLink.this.db.println("Cost = " + CompositeNetLink.this.linkModel.cost());
        }

        public final void dumpObservers() {
            CompositeNetLink.this.db.println("======================================");
            CompositeNetLink.this.db.println("CompositeNetLink Observers:");
            CompositeNetLink.this.printObservers();
        }
    }
}

