/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILinkType;
import cerent.cms.model.ILmpDataLinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.OchncHelper;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.LambdaLabelSet;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.RoutableNetLink;
import cerent.cms.topo.Topology;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EnumStrings;
import cerent.util.IHoNum;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.Observer;

public class LmpDataLinkNetLink
extends RoutableNetLink {
    private boolean checking;
    private long ospfAreaId;
    private LambdaLabelSet srcLabelSet = new LambdaLabelSet();
    private LambdaLabelSet dstLabelSet = new LambdaLabelSet();
    private ILmpDataLinkModel dataLink;

    public LmpDataLinkNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, int n) {
        super(network, iLinkModel, iNetElement, iNetElement2, false, topology, n);
    }

    public boolean isBlsrCapable() {
        return false;
    }

    public void newState(int n) {
        ((LinkModel)this.linkModel).oldState(this.newState());
        if (n != this.oldState()) {
            if (this.db.on()) {
                this.db.println("newState: state changed from " + (this.oldState() == 1 ? "Up" : "Down") + " to " + (n == 1 ? "Up" : "Down"));
            }
            ((LinkModel)this.linkModel).newState(n);
            if (!this.deleted) {
                this.setChanged();
            } else {
                this.clearChanged();
            }
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    protected void setChecking(boolean bl) {
        this.checking = bl;
    }

    protected boolean inChecking() {
        return this.checking;
    }

    public int state() {
        return this.newState();
    }

    protected void setOspfAreaId(long l) {
        if (this.ospfAreaId != l) {
            this.ospfAreaId = l;
            this.topology.ospfAreaChanged(this);
        }
    }

    public long getOspfAreaId() {
        return this.ospfAreaId;
    }

    protected void initializeDebug() {
        this.db = new LmpNetLinkDebug("NLlmp" + LmpDataLinkNetLink.getDebugName(this.src.getHostName()) + "(" + Integer.toHexString(this.getSrcEntityIndex()) + ")-" + LmpDataLinkNetLink.getDebugName(this.dst.getHostName()) + "(" + Integer.toHexString(this.getDstEntityIndex()) + ")");
    }

    public int newState() {
        return ((LinkModel)this.linkModel).newState();
    }

    public int oldState() {
        return ((LinkModel)this.linkModel).oldState();
    }

    protected void startObservingLmp(ILmpDataLinkModel iLmpDataLinkModel) {
        this.dataLink = iLmpDataLinkModel;
        ((IObservable)iLmpDataLinkModel).addObserver((IObserver)this);
        if (this.db.on()) {
            this.db.println("Start observing Data Link" + iLmpDataLinkModel);
        }
        this.driveLinkStatus();
        int n = iLmpDataLinkModel.getNodeModel().getNodeId();
        INodeModel iNodeModel = this.getSrc().getNodeId() == n ? this.getDst().getNodeModel().getDelegate() : this.getSrc().getNodeModel().getDelegate();
        ((IObservable)iLmpDataLinkModel).addObserver((Observer)iNodeModel);
        this.getSrc().getNodeModel().getConnectionNotifier().addObserver((IObserver)this);
        this.getDst().getNodeModel().getConnectionNotifier().addObserver((IObserver)this);
    }

    private void driveLinkStatus() {
        boolean bl;
        int n;
        block6: {
            n = 0;
            try {
                n = this.dataLink.getIOperationalState();
            }
            catch (Exception exception) {
                this.db.warning("Cannot get Data link state for " + this.dataLink);
                if (!this.db.on()) break block6;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        boolean bl2 = n == 1 || n == 2;
        boolean bl3 = this.getSrc().getNodeModel().getConnectionState();
        boolean bl4 = this.getDst().getNodeModel().getConnectionState();
        boolean bl5 = bl3 && bl2;
        boolean bl6 = bl = bl4 && bl2;
        if (this.db.on()) {
            this.db.println("State of " + this.dataLink + ": " + bl2 + " - SRC: " + bl3 + " DST: " + bl4);
        }
        if (!bl || !bl5) {
            this.newState(2);
        } else {
            this.newState(1);
        }
        if (this.db.on()) {
            this.db.println("Src node " + this.getSrc().getHostName() + ": " + (bl3 ? "UP" : "DOWN") + " - Dst node " + this.getDst().getHostName() + ": " + (bl4 ? "UP" : "DOWN") + " - DL Status: " + (bl2 ? "UP" : "DOWN"));
        }
    }

    public boolean isUsable(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        if (this.db.on()) {
            this.db.println("isUsable called on " + this + " - parent link is " + iNetLink);
        }
        if (routePrefs.getCircuitType() != 15) {
            throw new xLinkNotUsable("LmpDataLink usable only for OCHTrail Circuit");
        }
        if (this.state() != 1) {
            throw new xLinkNotUsable("Link is Not UP");
        }
        if (!this.getDst().getConnectionState()) {
            throw new xLinkNotUsable("DstLink is not in UP state");
        }
        if (!this.getSrc().getConnectionState()) {
            throw new xLinkNotUsable("SrcLink is not in UP state");
        }
        int n = -1;
        try {
            n = this.dataLink.getRemoteCrsPortId();
        }
        catch (Exception exception) {
            throw new xLinkNotUsable("LmpDataLink usable only if src/dst node is a CRS");
        }
        if (n == -1) {
            throw new xLinkNotUsable("LmpDataLink usable only if src/dst node is a CRS");
        }
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = null;
        try {
            iEntityModel = this.getSrc().getNodeModel().getEntityTable().getEntityModelByIndex(this.getSrcEntityIndex());
            iEntityModel2 = this.getDst().getNodeModel().getEntityTable().getEntityModelByIndex(this.getDstEntityIndex());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
        }
        if (iEntityModel == null || iEntityModel2 == null) {
            throw new xLinkNotUsable("Source or Destination link endpoint is invalid.");
        }
        if (this.getSrc().equals(routePrefs.getSrc()) && this.getSrcEntityIndex() == routePrefs.getcktSrcEntityIndex()) {
            if (!(iEntityModel2 instanceof IOpticsPortModel)) {
                throw new xLinkNotUsable("Destination port is not an OCH port");
            }
            if (!((IOpticsPortModel)iEntityModel2).isOchncAddPort()) {
                throw new xLinkNotUsable("Destination port is not RX");
            }
        } else if (this.getSrc().equals(routePrefs.getDst()) && this.getSrcEntityIndex() == routePrefs.getcktDstEntityIndex()) {
            if (!(iEntityModel2 instanceof IOpticsPortModel)) {
                throw new xLinkNotUsable("Destination port is not an OCH port");
            }
            if (!((IOpticsPortModel)iEntityModel2).isOchncAddPort()) {
                throw new xLinkNotUsable("Destination port is not RX");
            }
        } else if (this.getDst().equals(routePrefs.getSrc()) && this.getDstEntityIndex() == routePrefs.getcktSrcEntityIndex()) {
            if (!(iEntityModel instanceof IOpticsPortModel)) {
                throw new xLinkNotUsable("Source port is not an OCH port");
            }
            if (!((IOpticsPortModel)iEntityModel).isOchncDropPort()) {
                throw new xLinkNotUsable("Source port is not TX");
            }
        } else if (this.getDst().equals(routePrefs.getDst()) && this.getDstEntityIndex() == routePrefs.getcktDstEntityIndex()) {
            if (!(iEntityModel instanceof IOpticsPortModel)) {
                throw new xLinkNotUsable("Source port is not an OCH port");
            }
            if (!((IOpticsPortModel)iEntityModel).isOchncDropPort()) {
                throw new xLinkNotUsable("Source port is not TX");
            }
        } else {
            throw new xLinkNotUsable("Neither between OTS ports nor connected to circuit endpoints");
        }
        if (iNetLink != null) {
            this.checkOpticalContinuity(routePrefs, iNetLink);
        }
        if ((this.getSrc().equals(routePrefs.getSrc()) || this.getDst().equals(routePrefs.getSrc())) && n == routePrefs.getcktSrcEntityIndex()) {
            if (this.db.on()) {
                this.db.println(this + " isUsable");
            }
            return true;
        }
        if ((this.getSrc().equals(routePrefs.getDst()) || this.getDst().equals(routePrefs.getDst())) && n == routePrefs.getcktDstEntityIndex()) {
            if (this.db.on()) {
                this.db.println(this + " isUsable");
            }
            return true;
        }
        throw new xLinkNotUsable("LmpDataLink is usable only if it starts or ends from the circuit endpoints");
    }

    private void checkOpticalContinuity(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        int n = routePrefs.getcktOptChannel();
        if (this.db.on()) {
            this.db.println("checkOpticalContinuity(" + this + ", " + iNetLink + ")");
        }
        INetElement iNetElement = null;
        int n2 = 0;
        int n3 = 0;
        if (this.getSrc().getNodeId() == iNetLink.getDst().getNodeId()) {
            iNetElement = this.getSrc();
            n3 = iNetLink.getDstEntityIndex();
            n2 = this.getSrcEntityIndex();
        } else if (this.getDst().getNodeId() == iNetLink.getSrc().getNodeId()) {
            iNetElement = this.getDst();
            n3 = iNetLink.getSrcEntityIndex();
            n2 = this.getDstEntityIndex();
        } else {
            throw new xLinkNotUsable("No common NE with parent link " + iNetLink.toString());
        }
        OchncHelper.checkAreConnectedByOCHNCPath(iNetElement, n3, n2, n);
        if (this.db.on()) {
            this.db.println("OCHNC internal path found");
        }
    }

    protected void _update(Object object, Object object2) {
        if (object instanceof ILmpDataLinkModel) {
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("UPDATE changed event from Data Link " + object);
                }
                this.driveLinkStatus();
            } else if (object2 == ModelUpdateType.DELETED) {
                if (this.db.on) {
                    this.db.println("UPDATE Data Link deleted - Deleting myself");
                }
                this.dispose();
            }
        } else if (object instanceof INodeModel.AbstractConnectionNotifier) {
            if (object2 == ModelUpdateType.CHANGED) {
                this.driveLinkStatus();
            }
        } else {
            super._update(object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        LmpDataLinkNetLink lmpDataLinkNetLink = this;
        synchronized (lmpDataLinkNetLink) {
            if (this.deleted) {
                return;
            }
            this.deleted = true;
        }
        if (this.net != null) {
            this.net.delete(this);
        }
        ((IObservable)this.dataLink).deleteObserver((IObserver)this);
        super.dispose();
    }

    public ILabelSet getSrcLabelSet(int n, int n2) {
        return this.srcLabelSet;
    }

    public ILabelSet getDstLabelSet(int n, int n2) {
        return this.dstLabelSet;
    }

    public boolean isValidSrcHoNumber(IHoNum iHoNum) {
        return true;
    }

    public boolean isValidDstHoNumber(IHoNum iHoNum) {
        return true;
    }

    public int getProtectionType() {
        return 3;
    }

    private IEntityModel getDestinationEntityModel() {
        IEntityModel iEntityModel;
        block4: {
            iEntityModel = null;
            int n = 0;
            INetLink iNetLink = this.getReverseLink();
            if (iNetLink != null) {
                n = iNetLink.getSrcEntityIndex();
                try {
                    IEntityModel iEntityModel2;
                    IEntityTableModel iEntityTableModel;
                    INodeModel iNodeModel;
                    INetElement iNetElement = this.getDst();
                    if (iNetElement != null && (iNodeModel = this.getDst().getNodeModel()) != null && (iEntityTableModel = iNodeModel.getEntityTable()) != null && (iEntityModel2 = iEntityTableModel.getEntityModelByIndex(n)) != null) {
                        iEntityModel = iEntityModel2;
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (this.db == null || !this.db.on()) break block4;
                    this.db.println("Exception getting entitymodel " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
        }
        return iEntityModel;
    }

    public boolean isDstPortRX() {
        IEntityModel iEntityModel = this.getDestinationEntityModel();
        return iEntityModel != null && iEntityModel.getEntityIndex() % 2 == 0;
    }

    public boolean isSrcPortTX() {
        IEntityModel iEntityModel = this.getLinkModel().getEndEntityModel(true);
        return iEntityModel != null && iEntityModel.getEntityIndex() % 2 != 0;
    }

    public int getRealSrcEntityIndex() {
        IPortModel iPortModel = (IPortModel)this.getLinkModel().getEndEntityModel(true);
        IInterfaceModel iInterfaceModel = ((IPortModel)this.getLinkModel().getEndEntityModel(false)).getInterfaceModel();
        int n = 0;
        if (this.getDst().getNodeModel().provides(Feature.PASSIVE_UNITS) && iInterfaceModel instanceof IOpticsChannelModel) {
            try {
                if (((IOpticsChannelModel)iInterfaceModel).isWavelengthSupported()) {
                    n = ((IOpticsChannelModel)iInterfaceModel).getActualWaveLength();
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        int n2 = this.getSrcEntityIndex();
        if (this.getSrc().getNodeModel().provides(Feature.PASSIVE_UNITS) && iPortModel instanceof IOpticsPortModel && (iPortModel.getModuleModel().getEqType() == 295 || iPortModel.getModuleModel().getEqType() == 296 || iPortModel.getModuleModel().getEqType() == 294)) {
            n2 = OchTrailHelper.getColocatedPassiveChannelPort((IEntityModel)iPortModel, n).getEntityIndex();
        }
        return n2;
    }

    public int getRealDstEntityIndex() {
        IPortModel iPortModel = (IPortModel)this.getLinkModel().getEndEntityModel(false);
        IInterfaceModel iInterfaceModel = ((IPortModel)this.getLinkModel().getEndEntityModel(true)).getInterfaceModel();
        int n = 0;
        if (this.getSrc().getNodeModel().provides(Feature.PASSIVE_UNITS) && iInterfaceModel instanceof IOpticsChannelModel) {
            try {
                if (((IOpticsChannelModel)iInterfaceModel).isWavelengthSupported()) {
                    n = ((IOpticsChannelModel)iInterfaceModel).getActualWaveLength();
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        int n2 = this.getDstEntityIndex();
        if (this.getDst().getNodeModel().provides(Feature.PASSIVE_UNITS) && iPortModel instanceof IOpticsPortModel && (iPortModel.getModuleModel().getEqType() == 295 || iPortModel.getModuleModel().getEqType() == 296 || iPortModel.getModuleModel().getEqType() == 294)) {
            n2 = OchTrailHelper.getColocatedPassiveChannelPort((IEntityModel)iPortModel, n).getEntityIndex();
        }
        return n2;
    }

    public class LmpNetLinkDebug
    extends SDebug {
        public LmpNetLinkDebug(String string) {
            super(string);
        }

        public final void dump() {
            LmpDataLinkNetLink.this.db.println("======================================");
            LmpDataLinkNetLink.this.db.println("Src = " + LmpDataLinkNetLink.this.src.getHostName());
            LmpDataLinkNetLink.this.db.println("Dst = " + LmpDataLinkNetLink.this.dst.getHostName());
            LmpDataLinkNetLink.this.db.println("State = " + (LmpDataLinkNetLink.this.newState() == 1 ? "Up" : "Down"));
            LmpDataLinkNetLink.this.db.println("Topology ID = " + LmpDataLinkNetLink.this.topoId);
            LmpDataLinkNetLink.this.db.println("NetLink Type = " + LmpDataLinkNetLink.this.getLinkTypeObj());
            LmpDataLinkNetLink.this.db.println("Protection Type = " + LmpDataLinkNetLink.this.getProtectionTypeObj());
            LmpDataLinkNetLink.this.db.println("Physical Type = " + LmpDataLinkNetLink.this.getPhysicalTypeObj().getDisplayString(LmpDataLinkNetLink.this.isSonetCapable()));
            LmpDataLinkNetLink.this.db.println("Physical Link Type = " + EnumStrings.getString(ILinkType.class, (int)LmpDataLinkNetLink.this.getPhysicalLinkType()));
            LmpDataLinkNetLink.this.db.println("Src Slot = " + LmpDataLinkNetLink.this.srcSlot);
            LmpDataLinkNetLink.this.db.println("Src Port = " + PortHelper.getConcatenatedString((int[])LmpDataLinkNetLink.this.srcPort));
            LmpDataLinkNetLink.this.db.println("Src linkId = " + LmpDataLinkNetLink.this.linkModel.getSrcLinkId());
            LmpDataLinkNetLink.this.db.println("Dst Slot = " + LmpDataLinkNetLink.this.dstSlot);
            LmpDataLinkNetLink.this.db.println("Dst Port = " + PortHelper.getConcatenatedString((int[])LmpDataLinkNetLink.this.dstPort));
            LmpDataLinkNetLink.this.db.println("Dst linkId = " + LmpDataLinkNetLink.this.linkModel.getDstLinkId());
            LmpDataLinkNetLink.this.db.println("Cost = " + LmpDataLinkNetLink.this.linkModel.cost());
            LmpDataLinkNetLink.this.db.println("Link Dir = " + LmpDataLinkNetLink.this.linkModel.getLinkDir());
        }
    }
}

