/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.topo.AbstractNodeIpPartitioner;
import cerent.cms.topo.Network;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;

class ManualPartitioner
extends AbstractNodeIpPartitioner {
    private static final Preferences prefs = Preferences.instance();
    private static final String name = "CTC manual partitioner";
    private static final String CTC_KEY = "ctc";
    private static final String PART_KEY = "partition";
    private String partition = prefs.getProperty("ctc", "partition", null);
    private String[] nodes;
    private boolean enabled;
    private HashSet<String> ips;
    private HashMap<InetAddress, InetAddress> serverProxying;
    private boolean sense = true;
    private boolean areNodesAlwaysInSameTopo = false;
    private static ManualPartitioner builtInInstance = null;
    private static final Debug db = new Debug("ManualPartitioner");
    private static final IpComparator comp = new IpComparator();

    static void initBuiltInPartitionerIfConfigured(Network network) {
        block4: {
            try {
                ManualPartitioner manualPartitioner;
                if (db.on()) {
                    db.println("Checking for manual partitioner environment");
                }
                builtInInstance = manualPartitioner = new ManualPartitioner();
                network.setPartitioner(builtInInstance);
                if (db.on()) {
                    db.println("The CTC built-in partitioner is " + (manualPartitioner.enabled ? "enabled" : "disabled") + " for this process");
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                Debug.printStackTrace((Throwable)exception);
            }
        }
    }

    public ManualPartitioner() {
        super(db);
        if (this.partition != null) {
            String string = "partition-" + this.partition;
            this.nodes = prefs.getPropertyArray(CTC_KEY, string + ".members", new String[0]);
            this.enabled = this.nodes.length != 0;
            this.ips = new HashSet();
            boolean bl = db.isFinestEnabled();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : this.nodes) {
                String[] stringArray;
                for (String string3 : stringArray = string2.split(" ")) {
                    if (bl) {
                        stringBuilder.append(string3);
                        stringBuilder.append(" ");
                    }
                    this.ips.add(string3);
                }
            }
            this.sense = prefs.getBoolean(CTC_KEY, string + ".sense", true);
            this.areNodesAlwaysInSameTopo = prefs.getBoolean(CTC_KEY, string + ".nodesalwaysinsametopo", false);
            if (db.on()) {
                db.println("CTC partition: " + this.partition);
                db.println("# partition members: " + this.ips.size());
                if (bl) {
                    db.finest("  " + stringBuilder);
                }
                db.println("membership sense: " + this.sense);
                db.println("nodes always deemed in same topo: " + this.areNodesAlwaysInSameTopo);
            }
        }
        this.serverProxying = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areNodesInSameTopo(InetAddress inetAddress, InetAddress inetAddress2) {
        boolean bl = false;
        boolean bl2 = false;
        if (!trans.isEnabled()) {
            bl = true;
            bl2 = true;
        } else if (inetAddress == null || inetAddress2 == null) {
            bl = false;
            bl2 = true;
        } else if (inetAddress.equals(inetAddress2)) {
            bl = true;
            bl2 = true;
        } else if (this.areNodesAlwaysInSameTopo) {
            bl = true;
            bl2 = true;
        }
        if (!bl2) {
            InetAddress inetAddress3 = trans.getActualAddress(inetAddress2);
            if (!this.isMember(ManualPartitioner.toActual(inetAddress.getHostAddress()), -1)) {
                bl = false;
                bl2 = true;
            }
            if (!bl2) {
                HashMap<InetAddress, InetAddress> hashMap = this.serverProxying;
                synchronized (hashMap) {
                    if (this.serverProxying.get(inetAddress) == null) {
                        bl = true;
                        bl2 = true;
                        this.serverProxying.put(inetAddress, inetAddress3);
                    }
                }
            }
        }
        if (db.isFinestEnabled() && trans.isEnabled()) {
            db.finest("areNodesInSameTopo(" + inetAddress + ", " + inetAddress2 + ") returned: " + bl);
        }
        return bl;
    }

    protected boolean isMember(String string, int n) {
        boolean bl;
        boolean bl2 = !this.enabled ? true : (bl = !this.sense ^ this.ips.contains(string));
        if (db.on()) {
            db.println("ManualPartitioner.isMember(" + ManualPartitioner.toActual(string) + ", " + n + "): " + bl);
        }
        return bl;
    }

    protected String getAllMembers() {
        TreeSet<String> treeSet = new TreeSet<String>(comp);
        treeSet.addAll(this.ips);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (String string : treeSet) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            bl = true;
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return name;
    }

    public String prettyString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        stringBuilder.append(name);
        if (!this.enabled) {
            stringBuilder.append(" - disabled (all OSPF items permitted as usual)");
        } else {
            stringBuilder.append(" - members for partition '" + this.partition + "': ");
            stringBuilder.append(this.getAllMembers());
        }
        if (!this.sense) {
            stringBuilder.append("; sense is false.");
        }
        if (this.areNodesAlwaysInSameTopo) {
            stringBuilder.append("; nodes always deemed in same topo (for proxy determination purposes)");
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class IpComparator
    implements Comparator<String> {
        protected IpComparator() {
        }

        private static InetAddress getAddr(String string) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return inetAddress;
        }

        private static int usign(byte n) {
            int n2 = n;
            if (n2 < 0) {
                n2 += 256;
            }
            return n2;
        }

        @Override
        public int compare(String string, String string2) {
            InetAddress inetAddress = IpComparator.getAddr(string);
            InetAddress inetAddress2 = IpComparator.getAddr(string2);
            int n = 0;
            if (inetAddress == null) {
                n = inetAddress2 == null ? 0 : -1;
            } else if (inetAddress2 == null) {
                n = 1;
            } else {
                byte[] byArray = inetAddress.getAddress();
                byte[] byArray2 = inetAddress2.getAddress();
                int n2 = byArray == null ? 0 : byArray.length;
                int n3 = byArray2 == null ? 0 : byArray2.length;
                n = n2 - n3;
                for (int i = 0; i < n2 && n == 0; ++i) {
                    n = IpComparator.usign(byArray[i]) - IpComparator.usign(byArray2[i]);
                }
            }
            return n;
        }
    }

    public static class Debug
    extends SDebug {
        public Debug(String string) {
            super(string);
        }

        public final void dumpDiag() {
            if (builtInInstance == null) {
                this.println("Built-in partitioning is off");
            } else {
                this.println(builtInInstance.prettyString(null));
            }
        }
    }
}

