/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILinkType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.route.DummyLabelSet;
import cerent.cms.route.ILabelSet;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.LinkStateMachine;
import cerent.cms.topo.Network;
import cerent.cms.topo.OscLinkStateMachine;
import cerent.cms.topo.RoutableNetLink;
import cerent.cms.topo.Topology;
import cerent.cms.ui.DwdmSide;
import cerent.util.EnumStrings;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.ArrayList;

public class OscNetLink
extends RoutableNetLink {
    private int optLinkDir = -1;
    private long ospfAreaId;
    private String optRingName;
    private boolean isOptAttribSet = false;
    private boolean isLinkValid = false;
    private LinkStateMachine linkStateMc;
    private boolean checking;

    protected OscNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl, Topology topology, int n, boolean bl2) {
        super(network, iLinkModel, iNetElement, iNetElement2, bl, topology, n);
        if (this.db.on()) {
            this.db.println("Creating new OscNetLink");
        }
        this.ospfAreaId = 0L;
        this.deleted = false;
        this.checking = false;
        this.linkStateMc = new OscLinkStateMachine(network, this, this.db);
        if (bl2 && bl) {
            this.linkStateMc.driveSm(5);
        }
        this.startObservingNE();
    }

    protected void setOptAttribs(String string, boolean bl) {
        if (this.db.on()) {
            this.db.println("setOptAttribs: optRingName = " + string);
            this.db.println("setOptAttribs: isoptlinkdirEast = " + bl);
        }
        this.optRingName = string;
        this.isOptAttribSet = true;
        this.optLinkDir = bl ? 1 : 0;
        INetLink iNetLink = Network.instance().findReverseLink(this);
        if (iNetLink != null && iNetLink instanceof OscNetLink && ((OscNetLink)iNetLink).getOptLinkDir() == -1) {
            ((OscNetLink)iNetLink).setOptAttribs(string, !bl);
        }
        if (this.getSrc().getConnectionState() && this.getDst().getConnectionState()) {
            this.notifyNetLinkManager();
        }
    }

    protected void setOptAttribs() {
        if (this.db.on()) {
            this.db.println("setOptAttirbs: w/o opt attrs");
        }
        this.isOptAttribSet = true;
        INetLink iNetLink = Network.instance().findReverseLink(this);
        if (iNetLink != null && iNetLink instanceof OscNetLink && ((OscNetLink)iNetLink).getOptLinkDir() != -1) {
            this.setOptAttribs(((OscNetLink)iNetLink).getOptRingName(), ((OscNetLink)iNetLink).getOptLinkDir() != 1);
        }
        if (this.getSrc().getConnectionState() && this.getDst().getConnectionState()) {
            this.notifyNetLinkManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        OscNetLink oscNetLink = this;
        synchronized (oscNetLink) {
            if (this.deleted) {
                return;
            }
            this.deleted = true;
        }
        if (this.net != null) {
            this.net.delete(this);
        }
        this.stopObservingNE();
        super.dispose();
    }

    public int getOptLinkDir() {
        return this.optLinkDir;
    }

    public String getOptRingName() {
        return this.optRingName;
    }

    public boolean isValid() {
        return this.isLinkValid;
    }

    public String prettyString() {
        return super.prettyString() + " lsmState=" + this.linkStateMc.getCurrentSrcStateAsString() + "," + this.linkStateMc.getCurrentDstStateAsString();
    }

    protected void startObservingNE() {
        if (this.db.on()) {
            this.db.println("Start observing NEs");
        }
        this.getSrc().addObserver(this);
        this.getDst().addObserver(this);
    }

    protected void stopObservingNE() {
        if (this.db.on()) {
            this.db.println("Stop observing NEs");
        }
        this.getSrc().deleteObserver(this);
        this.getDst().deleteObserver(this);
    }

    protected void notifyNetLinkManager() {
        if (this.db.on()) {
            this.db.println("link is valid, notify NLM");
        }
        this.stopObservingNE();
        this.isLinkValid = true;
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    protected void _update(Object object, Object object2) {
        if (this.db.on()) {
            this.db.println("OSCLink update: received an update from:" + object + " arg=" + object2);
        }
        super._update(object, object2);
        if (object instanceof INetElement) {
            INetElement iNetElement = (INetElement)object;
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED event from NE " + iNetElement.getHostName());
                }
                if (this.getSrc().getConnectionState() && this.getDst().getConnectionState() && this.isOptAttribSet) {
                    this.notifyNetLinkManager();
                }
            }
        }
    }

    protected void setTopology(Topology topology, int n) {
        super.setTopology(topology, n);
        if (this.isValid()) {
            if (this.db.on()) {
                this.db.println("Notify DwdmNetLink - setTopology: topo = " + topology + ", topo id = " + n);
            }
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    protected void initializeDebug() {
        this.db = new OscNetLinkDebug("NL_" + OscNetLink.getDebugName(this.src.getHostName()) + "(" + Integer.toHexString(this.getSrcEntityIndex()) + ")-" + OscNetLink.getDebugName(this.dst.getHostName()) + "(" + Integer.toHexString(this.getDstEntityIndex()) + ")");
        if (this.db.on()) {
            this.db.println("OscNetLink: creating new OscNetLink");
        }
    }

    protected void refresh(int n, short s, byte by, int n2, int n3, int n4, int n5) {
        if (this.db.on()) {
            this.db.println("refresh: processing refresh request");
        }
        this.setProtectionType(n);
        this.setCost(n2);
        this.setPhysicalType(n3);
        this.newState(1);
    }

    public int oldState() {
        return ((LinkModel)this.linkModel).oldState();
    }

    public int newState() {
        return ((LinkModel)this.linkModel).newState();
    }

    protected void oldState(int n) {
        ((LinkModel)this.linkModel).oldState(n);
    }

    public void newState(int n) {
        ((LinkModel)this.linkModel).oldState(this.newState());
        if (this.db.on()) {
            this.db.println("newState: state = " + (n == 1 ? "Up" : "Down."));
        }
        if (n != this.oldState()) {
            if (this.db.on()) {
                this.db.println("newState: state changed from " + (this.oldState() == 1 ? "Up" : "Down") + " to " + (n == 1 ? "Up" : "Down"));
            }
            ((LinkModel)this.linkModel).newState(n);
            if (n == 2) {
                this.linkStateMc.driveSm(8);
            } else if (n == 1) {
                this.linkStateMc.driveSm(9);
            }
            if (!this.deleted) {
                this.setChanged();
            } else {
                this.clearChanged();
            }
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public int state() {
        return this.newState();
    }

    protected boolean inChecking() {
        return this.checking;
    }

    protected void setChecking(boolean bl) {
        if (this.db.on()) {
            this.db.println("setChecking: checking = " + bl);
        }
        this.checking = bl;
    }

    public boolean isValidSrcHoNumber(IHoNum iHoNum) {
        return true;
    }

    public boolean isValidDstHoNumber(IHoNum iHoNum) {
        return true;
    }

    protected void setOspfAreaId(long l) {
        if (this.ospfAreaId != l) {
            this.ospfAreaId = l;
            this.topology.ospfAreaChanged(this);
        }
    }

    public long getOspfAreaId() {
        return this.ospfAreaId;
    }

    public boolean isBlsrCapable() {
        return false;
    }

    public ILabelSet getSrcLabelSet(int n, int n2) {
        return new DummyLabelSet();
    }

    public ILabelSet getDstLabelSet(int n, int n2) {
        return new DummyLabelSet();
    }

    int getSrcSide() throws FeatureUnsupported, CannotPerform, AbstractCmsNoSuchElementException {
        return this.getSrc().getNodeModel().getINodeOpticsTopologyModel().getSideForOscPort(this.getSrcEntityIndex());
    }

    int getDstSide() throws FeatureUnsupported, CannotPerform, AbstractCmsNoSuchElementException {
        return this.getDst().getNodeModel().getINodeOpticsTopologyModel().getSideForOscPort(this.getDstEntityIndex());
    }

    int getOtsSrcPort() throws NoSuchEquipment, FeatureUnsupported, CannotPerform, AbstractCmsNoSuchElementException {
        INodeModel iNodeModel = this.getSrc().getNodeModel();
        int n = iNodeModel.provides(Feature.OPTICAL_SIDE) ? iNodeModel.getINodeOpticsTopologyModel().getSideOutputEntityIdx(this.getSrcSide()) : iNodeModel.getNodeOutputEntityIdx(this.getOptLinkDir());
        return n;
    }

    int getOtsProtSrcPort() {
        block5: {
            INodeModel iNodeModel = this.getSrc().getNodeModel();
            if (iNodeModel.provides(Feature.OCHNC_SPLITTER_CIRCUIT)) {
                int n = 0;
                try {
                    n = this.getSrcSide();
                    return iNodeModel.getINodeOpticsTopologyModel().getSideOutputProtectEntityIdx(n);
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    if (this.db.on()) {
                        this.db.println("no side protect found for 0x" + Integer.toHexString(n));
                    }
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block5;
                    this.db.println("No protection, got " + exception.getMessage());
                }
            }
        }
        return 0;
    }

    int getOtsDstPort() throws NoSuchEquipment, FeatureUnsupported, CannotPerform, AbstractCmsNoSuchElementException {
        INodeModel iNodeModel = this.getDst().getNodeModel();
        int n = iNodeModel.provides(Feature.OPTICAL_SIDE) ? iNodeModel.getINodeOpticsTopologyModel().getSideInputEntityIdx(this.getDstSide()) : iNodeModel.getNodeInputEntityIdx(this.getOptLinkDir());
        return n;
    }

    int getOtsProtDstPort() {
        block3: {
            INodeModel iNodeModel = this.getDst().getNodeModel();
            if (iNodeModel.provides(Feature.OCHNC_SPLITTER_CIRCUIT)) {
                try {
                    return iNodeModel.getINodeOpticsTopologyModel().getSideInputProtectEntityIdx(this.getDstSide());
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block3;
                    this.db.println("No protection, got " + exception.getMessage());
                }
            }
        }
        return 0;
    }

    private int getDstOptLinkDir() {
        OscNetLink oscNetLink = (OscNetLink)this.getReverseLink();
        if (oscNetLink != null) {
            return oscNetLink.optLinkDir;
        }
        return -2;
    }

    public class OscNetLinkDebug
    extends SDebug {
        public OscNetLinkDebug(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            AbstractNetLink.dbg.println("==============================================");
            OscNetLink.this.db.println("Src = " + OscNetLink.this.src.getHostName());
            OscNetLink.this.db.println("Dst = " + OscNetLink.this.dst.getHostName());
            OscNetLink.this.db.println("State = " + (OscNetLink.this.newState() == 1 ? "Up" : "Down"));
            OscNetLink.this.db.println("Deleted = " + OscNetLink.this.deleted);
            OscNetLink.this.db.println("Topology ID = " + OscNetLink.this.topoId);
            OscNetLink.this.db.println("NetLink Type = " + OscNetLink.this.getLinkTypeObj());
            OscNetLink.this.db.println("Physical Link Type = " + EnumStrings.getString(ILinkType.class, (int)OscNetLink.this.getPhysicalLinkType()));
            OscNetLink.this.db.println("Src Slot = " + OscNetLink.this.srcSlot);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < OscNetLink.this.srcPort.length; ++i) {
                stringBuffer.append(Integer.toHexString(OscNetLink.this.srcPort[i]) + " ");
            }
            OscNetLink.this.db.println("Src Port = " + stringBuffer.toString());
            if (OscNetLink.this.getSrc().getNodeModel().provides(Feature.OPTICAL_SIDE)) {
                try {
                    OscNetLink.this.db.println("Src Side = " + DwdmSide.getSideFromOffset(OscNetLink.this.getSrcSide()));
                }
                catch (Exception exception) {
                    OscNetLink.this.db.println("Src Side = UNKNOWN (" + exception.getMessage() + ")");
                }
            } else {
                OscNetLink.this.db.println("Src opt link dir = " + DwdmNetLink.cktOptDirString(OscNetLink.this.optLinkDir));
            }
            OscNetLink.this.db.println("Dst Slot = " + OscNetLink.this.dstSlot);
            stringBuffer = new StringBuffer();
            for (int i = 0; i < OscNetLink.this.dstPort.length; ++i) {
                stringBuffer.append(Integer.toHexString(OscNetLink.this.dstPort[i]) + " ");
            }
            OscNetLink.this.db.println("Dst Port = " + stringBuffer.toString());
            if (OscNetLink.this.getDst().getNodeModel().provides(Feature.OPTICAL_SIDE)) {
                try {
                    OscNetLink.this.db.println("Dst Side = " + DwdmSide.getSideFromOffset(OscNetLink.this.getDstSide()));
                }
                catch (Exception exception) {
                    OscNetLink.this.db.println("Dst Side = UNKNOWN (" + exception.getMessage() + ")");
                }
            } else {
                OscNetLink.this.db.println("Dst opt link dir = " + DwdmNetLink.cktOptDirString(OscNetLink.this.getDstOptLinkDir()));
            }
            OscNetLink.this.db.println("Optical RingName = " + OscNetLink.this.optRingName);
            OscNetLink.this.db.println("  Nodes List: ");
            ArrayList arrayList = OscNetLink.this.nodesList;
            synchronized (arrayList) {
                for (Object object : OscNetLink.this.nodesList) {
                    OscNetLink.this.db.println("    " + object.getHostName());
                }
            }
            OscNetLink.this.db.println("  Links List:");
            arrayList = OscNetLink.this.linksList;
            synchronized (arrayList) {
                for (Object object : OscNetLink.this.linksList) {
                    OscNetLink.this.db.println("    " + object.prettyString());
                }
            }
        }

        public final void dumpObservers() {
            OscNetLink.this.db.println("NL observers:");
            OscNetLink.this.printObservers();
        }
    }
}

