/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoPathInfo;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.IPoolModel;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.route.AbstractLabelSet;
import cerent.cms.route.DropPrefs;
import cerent.cms.route.GenericSrg;
import cerent.cms.route.HoLabelSet;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.ISrg;
import cerent.cms.route.LoLabelSet;
import cerent.cms.route.LotLabelSet;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.PortSrg;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.Topology;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import cerent.util.ILoNum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class RoutableNetLink
extends AbstractNetLink {
    protected int lotProtectionType;

    protected RoutableNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl, Topology topology, int n) {
        super(network, iLinkModel, iNetElement, iNetElement2, bl, topology, n);
        if (this.db.on()) {
            this.db.println("Creating new RoutableNetLink");
        }
    }

    protected RoutableNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, int n, boolean bl, LinkedList linkedList, LinkedList linkedList2) {
        super(network, iLinkModel, iNetElement, iNetElement2, topology, n, false, linkedList, linkedList2);
    }

    public RoutableNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl) {
        super(network, iLinkModel, iNetElement, iNetElement2, bl);
    }

    public RoutableNetLink(INetElement iNetElement, INetElement iNetElement2) {
        super(iNetElement, iNetElement2);
    }

    public boolean isLotInMixedProtection() {
        return this.lotProtectionType == 3;
    }

    public boolean inBLSR() {
        return false;
    }

    public boolean isUsable(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        if (this.db.on()) {
            this.db.println("isUsable: Link : " + this.prettyString());
        }
        for (INetLink iNetLink2 : this.getLinksList()) {
            if (iNetLink2.state() != 1) {
                throw new xLinkNotUsable("Link is Not UP");
            }
            DropPrefs dropPrefs = routePrefs.getFwdDropPrefs();
            if (!dropPrefs.isCommonFiber()) {
                if (routePrefs.getIgnoreSRLG()) {
                    this.alterSRLGs(iNetLink2, routePrefs);
                } else {
                    iNetLink2.containsSrg(routePrefs.getExcludeSrgs());
                }
            } else if (!routePrefs.getPreferredLinks().contains(this) && !routePrefs.getPreferredLinks().contains(iNetLink2)) {
                if (routePrefs.getIgnoreSRLG()) {
                    this.alterSRLGs(iNetLink2, routePrefs);
                } else {
                    iNetLink2.containsSrg(routePrefs.getExcludeSrgs());
                }
            }
            if (!iNetLink2.getDst().getConnectionState()) {
                throw new xLinkNotUsable("DstLink is not in UP state");
            }
            if (!iNetLink2.getSrc().getConnectionState()) {
                throw new xLinkNotUsable("SrcLink is not in UP state");
            }
            routePrefs.isUsable(this);
        }
        if (routePrefs.getCircuitType() == 3 || routePrefs.getCircuitType() == 6) {
            return true;
        }
        if (this.isLinkOnADMoaB() && routePrefs.needOptimalPath() && !routePrefs.getPathOnly()) {
            this.checkADMoaBConstraints(routePrefs, iNetLink);
        }
        return true;
    }

    private void alterSRLGs(INetLink iNetLink, RoutePrefs routePrefs) throws xLinkNotUsable {
        if (this.db.on()) {
            this.db.println("in alterSRLGs: modifying srglist to remove srlgs");
        }
        Set set = routePrefs.getExcludeSrgs();
        HashSet<ISrg> hashSet = new HashSet<ISrg>();
        for (ISrg iSrg : set) {
            if (iSrg instanceof GenericSrg) continue;
            hashSet.add(iSrg);
        }
        iNetLink.containsSrg(hashSet);
    }

    public boolean isLinkOnADMoaB() {
        boolean bl = false;
        if (this.getSrc().getNodeModel().provides(Feature.STS_OVER_MSTP_ADM)) {
            IEntityModel iEntityModel = this.getLinkModel().getEndEntityModel(true);
            IModuleModel iModuleModel = iEntityModel.getModuleModel();
            IEntityModel iEntityModel2 = this.getLinkModel().getEndEntityModel(false);
            IModuleModel iModuleModel2 = iEntityModel2.getModuleModel();
            if (iModuleModel != null && iModuleModel instanceof IDwdmModuleModel) {
                bl = ((IDwdmModuleModel)iModuleModel).isADMCard();
            }
            if (!bl && iModuleModel2 != null && iModuleModel2 instanceof IDwdmModuleModel) {
                bl = ((IDwdmModuleModel)iModuleModel2).isADMCard();
            }
        }
        return bl;
    }

    public boolean isLinkFromADMClient() {
        if (this.getSrc().getNodeModel().provides(Feature.STS_OVER_MSTP_ADM)) {
            IEntityModel iEntityModel = this.getLinkModel().getEndEntityModel(true);
            IEntityModel iEntityModel2 = iEntityModel.getParent();
            IModuleModel iModuleModel = null;
            iModuleModel = iEntityModel2.getModuleModel();
            if (iModuleModel instanceof IDwdmModuleModel) {
                if (!((IDwdmModuleModel)iModuleModel).isADMCard()) {
                    return false;
                }
            } else {
                return false;
            }
            List list = iEntityModel2.getChildren();
            if (list != null && list.size() > 0) {
                for (IEntityModel iEntityModel3 : list) {
                    if (iEntityModel3 == null || !(iEntityModel3 instanceof IDwdmPortModel)) continue;
                    return ((IDwdmPortModel)iEntityModel3).isClientPort();
                }
                return true;
            }
        }
        return false;
    }

    public boolean isLinkToADMClient() {
        if (this.getDst().getNodeModel().provides(Feature.STS_OVER_MSTP_ADM)) {
            IEntityModel iEntityModel = this.getLinkModel().getEndEntityModel(false);
            IEntityModel iEntityModel2 = iEntityModel.getParent();
            IModuleModel iModuleModel = null;
            iModuleModel = iEntityModel2.getModuleModel();
            if (iModuleModel instanceof IDwdmModuleModel) {
                if (!((IDwdmModuleModel)iModuleModel).isADMCard()) {
                    return false;
                }
            } else {
                return false;
            }
            List list = iEntityModel2.getChildren();
            if (list != null && list.size() > 0) {
                for (IEntityModel iEntityModel3 : list) {
                    if (iEntityModel3 == null || !(iEntityModel3 instanceof IDwdmPortModel)) continue;
                    return ((IDwdmPortModel)iEntityModel3).isClientPort();
                }
                return true;
            }
        }
        return false;
    }

    protected void checkADMoaBConstraints(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        PortSrg portSrg;
        Set set;
        boolean bl = this.getSrc().getNodeModel().provides(Feature.STS_OVER_MSTP_ADM_ENHANCED);
        boolean bl2 = this.getDst().getNodeModel().provides(Feature.STS_OVER_MSTP_ADM_ENHANCED);
        if (routePrefs.getOrigSource() != null) {
            if (routePrefs.getOrigSource().getNodeId() == routePrefs.getSrc().getNodeId() && routePrefs.getSrc().getNodeId() == this.getSrc().getNodeId()) {
                if (!this.isSameADMobGroup(this.getSrc(), routePrefs.getcktSrcEntityIndex(), this.getSrcEntityIndex())) {
                    if (this.db.on()) {
                        this.db.println("ADM constraints failed (P) - Wrong ADM group: Link Src node: " + this.getSrc().getName() + " Ckt Src node: " + routePrefs.getSrc().getName() + " Link Src idx: " + Integer.toHexString(this.getSrcEntityIndex()) + " Ckt Src idx: " + Integer.toHexString(routePrefs.getcktSrcEntityIndex()));
                    }
                    throw new xLinkNotUsable("Link does not start from the circuit source MSTP ADM group.");
                }
                if (this.isLinkFromADMClient() && !this.isFullyLineProtected() && !bl) {
                    if (this.db.on()) {
                        this.db.println("ADM constraints failed (P) - UPSR from ADM client: Link Src node: " + this.getSrc().getName() + " Ckt Src node: " + routePrefs.getSrc().getName() + " Link Src idx: " + Integer.toHexString(this.getSrcEntityIndex()) + " Ckt Src idx: " + Integer.toHexString(routePrefs.getcktSrcEntityIndex()));
                    }
                    throw new xLinkNotUsable("Link can not support UPSR because starts from a MSTP ADM client port.");
                }
            } else if (routePrefs.getSrc().getNodeId() == this.getSrc().getNodeId()) {
                if (this.isLinkFromADMClient() && !bl) {
                    if (this.db.on()) {
                        this.db.println("ADM constraints failed (P) - UPSR from ADM client: Link Src node: " + this.getSrc().getName() + " Link Src idx: " + Integer.toHexString(this.getSrcEntityIndex()));
                    }
                    throw new xLinkNotUsable("Link can not support UPSR because starts from a MSTP ADM client port.");
                }
                set = routePrefs.getExcludeSrgs();
                for (Object e : set) {
                    if (!(e instanceof PortSrg) || (portSrg = (PortSrg)e).getNe().getNodeId() != this.getSrc().getNodeId() || this.isSameADMobGroup(this.getSrc(), this.getSrcEntityIndex(), portSrg.getEntityIndex())) continue;
                    if (this.db.on()) {
                        this.db.println("ADM constraints failed (P) - Alternate path from wrong ADM group : Link Src node: " + this.getSrc().getName() + " Link Src idx: " + Integer.toHexString(this.getSrcEntityIndex()) + " Primary Path ADM port idx: " + Integer.toHexString(portSrg.getEntityIndex()));
                    }
                    throw new xLinkNotUsable("Link does not start from the same MSTP ADM group of the primary path.");
                }
            }
        } else if (routePrefs.getSrc().getNodeId() == this.getSrc().getNodeId() && !this.isSameADMobGroup(this.getSrc(), routePrefs.getcktSrcEntityIndex(), this.getSrcEntityIndex())) {
            if (this.db.on()) {
                this.db.println("ADM constraints failed - Wrong ADM group: Link Src node: " + this.getSrc().getName() + " Ckt Src node: " + routePrefs.getSrc().getName() + " Link Src idx: " + Integer.toHexString(this.getSrcEntityIndex()) + " Ckt Src idx: " + Integer.toHexString(routePrefs.getcktSrcEntityIndex()));
            }
            throw new xLinkNotUsable("Link does not start from the circuit source MSTP ADM group.");
        }
        if (routePrefs.getDst() != null) {
            if (routePrefs.getOrigDrop() != null) {
                if (routePrefs.getOrigDrop().getNodeId() == routePrefs.getDst().getNodeId() && routePrefs.getDst().getNodeId() == this.getDst().getNodeId()) {
                    if (!this.isSameADMobGroup(this.getDst(), routePrefs.getcktDstEntityIndex(), this.getDstEntityIndex())) {
                        if (this.db.on()) {
                            this.db.println("ADM constraints failed (P) - Wrong ADM group: Link Dst node: " + this.getDst().getName() + " Ckt Dst node: " + routePrefs.getDst().getName() + " Link Dst idx: " + Integer.toHexString(this.getDstEntityIndex()) + " Ckt Dst idx: " + Integer.toHexString(routePrefs.getcktDstEntityIndex()));
                        }
                        throw new xLinkNotUsable("Link does not end on the circuit drop MSTP ADM group.");
                    }
                    if (this.isLinkToADMClient() && !this.isFullyLineProtected() && !bl2) {
                        if (this.db.on()) {
                            this.db.println("ADM constraints failed (P) - UPSR to ADM client: Link Dst node: " + this.getDst().getName() + " Ckt Dst node: " + routePrefs.getDst().getName() + " Link Dst idx: " + Integer.toHexString(this.getDstEntityIndex()) + " Ckt Dst idx: " + Integer.toHexString(routePrefs.getcktDstEntityIndex()));
                        }
                        throw new xLinkNotUsable("Link can not support UPSR because ends on a MSTP ADM client port.");
                    }
                } else if (routePrefs.getSrc().getNodeId() == this.getSrc().getNodeId()) {
                    set = routePrefs.getExcludeSrgs();
                    for (Object e : set) {
                        if (!(e instanceof PortSrg) || (portSrg = (PortSrg)e).getNe().getNodeId() != this.getDst().getNodeId() || this.isSameADMobGroup(this.getDst(), this.getDstEntityIndex(), portSrg.getEntityIndex())) continue;
                        if (this.db.on()) {
                            this.db.println("ADM constraints failed (P) - Alternate path to wrong ADM group : Link Dst node: " + this.getDst().getName() + " Link Dts idx: " + Integer.toHexString(this.getDstEntityIndex()) + " Primary Path ADM port idx: " + Integer.toHexString(portSrg.getEntityIndex()));
                        }
                        throw new xLinkNotUsable("Link does not end on the same MSTP ADM group of the primary path.");
                    }
                }
            } else if (this.getDst().getNodeId() == routePrefs.getDst().getNodeId() && !this.isSameADMobGroup(this.getDst(), routePrefs.getcktDstEntityIndex(), this.getDstEntityIndex())) {
                if (this.db.on()) {
                    this.db.println("ADM constraints failed: Link Dst node: " + this.getDst().getName() + " Ckt Dst node: " + routePrefs.getDst().getName() + " Link Dst idx: " + Integer.toHexString(this.getDstEntityIndex()) + " Ckt Dst idx: " + Integer.toHexString(routePrefs.getcktDstEntityIndex()));
                }
                throw new xLinkNotUsable("Link does not end on the circuit drop MSTP ADM group.");
            }
        }
        if (iNetLink != null && !this.isSameADMobGroup(this.getSrc(), iNetLink.getDstEntityIndex(), this.getSrcEntityIndex())) {
            if (this.db.on()) {
                this.db.println("ADM constraints failed: Link Src node: " + this.getSrc().getName() + " Link Src idx: " + Integer.toHexString(this.getSrcEntityIndex()) + " Parent Link Dst idx: " + Integer.toHexString(iNetLink.getDstEntityIndex()));
            }
            throw new xLinkNotUsable("Link has no optical continuity with the previous one.");
        }
    }

    protected boolean isSameADMobGroup(INetElement iNetElement, int n, int n2) {
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNodeModel.provides(Feature.STS_OVER_MSTP_ADM)) {
            block7: {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                try {
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    IModuleModel iModuleModel = iEntityModel.getModuleModel();
                    if (iModuleModel instanceof IDwdmModuleModel) {
                        IDwdmModuleModel iDwdmModuleModel = (IDwdmModuleModel)iModuleModel;
                        if (iDwdmModuleModel.isADMCard()) {
                            IEntityModel iEntityModel2 = iEntityTableModel.getEntityModelByIndex(n2);
                            IModuleModel iModuleModel2 = iEntityModel2.getModuleModel();
                            if (iModuleModel == iModuleModel2) {
                                return true;
                            }
                            if (iModuleModel2 instanceof IDwdmModuleModel && ((IDwdmModuleModel)iModuleModel2).isADMCard() && iDwdmModuleModel.isSameADMGroup(iModuleModel2)) {
                                return true;
                            }
                        }
                        break block7;
                    }
                    return true;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) break block7;
                    this.db.println("isSameADMobGroup: Exception " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
            return false;
        }
        return true;
    }

    public boolean isRoutable() {
        return true;
    }

    public abstract boolean isBlsrCapable();

    public boolean availBW(RoutePrefs routePrefs) {
        DropPrefs dropPrefs = routePrefs.getFwdDropPrefs();
        if (dropPrefs.getMemberGroupPrefs().size() > 1 && dropPrefs.isCommonFiber()) {
            try {
                routePrefs.isUsable(this);
            }
            catch (xLinkNotUsable xLinkNotUsable2) {
                if (this.db.on()) {
                    this.db.println("availBW: " + xLinkNotUsable2.getString());
                }
                return false;
            }
        } else {
            MemberGroupPrefs memberGroupPrefs = dropPrefs.getFirstMemberGroupPrefs();
            INetLinkSpan[] iNetLinkSpanArray = this.getNAvailSpans(memberGroupPrefs.getMemberBandwidth(), routePrefs.getCircuitType(), memberGroupPrefs.getMemberCount());
            if (iNetLinkSpanArray == null || iNetLinkSpanArray.length < memberGroupPrefs.getMemberCount()) {
                if (this.db.on()) {
                    this.db.println("availBW: Returned false");
                }
                return false;
            }
        }
        return true;
    }

    private ILabelSet recalcLabelSetForLAP(ILabelSet iLabelSet) {
        LotLabelSet lotLabelSet = new LotLabelSet();
        if (iLabelSet == null) {
            return lotLabelSet;
        }
        Iterator iterator = iLabelSet.getLabelSet().iterator();
        if (!this.isLAP()) {
            return iLabelSet;
        }
        IHoNum iHoNum = !this.isSrcExtendable() ? this.getSrcHo() : this.getDstHo();
        while (iterator.hasNext()) {
            IHoLoNum iHoLoNum = (IHoLoNum)iterator.next();
            iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iHoLoNum.getLoNum());
            lotLabelSet.addLabel((ILabel)iHoLoNum);
        }
        if (this.db.on()) {
            this.db.println("recalcLabelSetForLAP: Returning " + lotLabelSet.size() + " Labels");
        }
        return lotLabelSet;
    }

    public ILabelSet getSrcLabelSet(int n, int n2) {
        ILabelSet iLabelSet;
        if (this.db.on()) {
            this.db.println("getSrcLabelSet");
        }
        if (this.isLAP() && !this.isSrcExtendable()) {
            ILabelSet iLabelSet2 = this.getDstLabelSet(n, n2);
            return this.recalcLabelSetForLAP(iLabelSet2);
        }
        if (!this.getSrc().getConnectionState()) {
            return null;
        }
        IPoolModel iPoolModel = this.getSrcPool();
        try {
            iLabelSet = this.getLabelSet(this.getSrc(), iPoolModel, n, n2, true);
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            return null;
        }
        return iLabelSet;
    }

    public ILabelSet getDstLabelSet(int n, int n2) {
        if (this.db.on()) {
            this.db.println("getDstLabelSet");
        }
        if (this.isLAP() && !this.isDstExtendable()) {
            ILabelSet iLabelSet = this.getSrcLabelSet(n, n2);
            return this.recalcLabelSetForLAP(iLabelSet);
        }
        if (!this.getDst().getConnectionState()) {
            return null;
        }
        IPoolModel iPoolModel = this.getDstPool();
        return this.getLabelSet(this.getDst(), iPoolModel, n, n2, false);
    }

    protected ILabelSet getLabelSet(INetElement iNetElement, IPoolModel iPoolModel, int n, int n2, boolean bl) {
        Object object;
        Object object2;
        ILoPathInfo[] iLoPathInfoArray;
        Object object3;
        IHoNum iHoNum;
        Object object4;
        IConnectionModels iConnectionModels;
        AbstractLabelSet abstractLabelSet;
        short s;
        boolean bl2;
        if (iPoolModel == null || iNetElement == null) {
            return null;
        }
        if (!iNetElement.canSupportCircuitSize(n2, n)) {
            if (this.db.on()) {
                this.db.println("NE does not support circuit size");
            }
            return null;
        }
        if (this.db.on()) {
            this.db.println("getLabelSet: Link : " + this.prettyString());
        }
        if (this.db.on()) {
            this.db.println("getLabelSet: Pool entIdx => " + Integer.toHexString(iPoolModel.getEntityIndex()));
        }
        int n3 = NetCircuitManager.instance().calcFramingType(n2, n);
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n2);
        boolean bl3 = bl2 = iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType();
        if (bl2) {
            int n4 = RoutableNetLink.getLoTunnelSize(n3);
            s = CircuitSize.getCircuitSize((int)n4).size2widthOfHoCircuit();
            abstractLabelSet = this.isLOTunnel() || this.isLAP() ? new LotLabelSet() : new LoLabelSet();
        } else {
            s = CircuitSize.getCircuitSize((int)n).size2widthOfHoCircuit();
            abstractLabelSet = new HoLabelSet();
        }
        if (bl2) {
            INodeModel iNodeModel = iNetElement.getNodeModel();
            iConnectionModels = iNodeModel.getConnectionModels();
            object4 = RoutableNetLink.aditsWithCapacity(iConnectionModels.getLoAditsInPool(iPoolModel), CircuitSize.getCircuitSize((int)n));
            for (int i = 0; i < ((ILoAditModel[])object4).length; ++i) {
                iHoNum = RoutableNetLink.physicalHo(object4[i]);
                if (this.isLOTunnel() || this.isLAP()) {
                    if (!bl ? !iHoNum.equals(this.getDstHo()) : !iHoNum.equals(this.getSrcHo())) continue;
                    if (this.db.on()) {
                        this.db.println("getLabelSet: Lot Ho " + iHoNum);
                    }
                } else {
                    object3 = this.net.findLoTunnelNetLink(iNetElement, bl ? this.getDst() : this.getSrc(), bl ? this.getSrcEntityIndex() : this.getDstEntityIndex(), iHoNum);
                    if (object3 != null) continue;
                }
                short s2 = CircuitSize.getCircuitSize((int)n).size2widthOfLoCircuit();
                iLoPathInfoArray = object4[i].getAvailableLos((int)s2);
                object2 = RoutableNetLink.getAllLoNums(iLoPathInfoArray);
                if (this.db.on()) {
                    this.db.println("getLabelSet: Num Los " + object2.size());
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    ILoNum iLoNum = (ILoNum)object.next();
                    IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
                    abstractLabelSet.addLabel((ILabel)iHoLoNum);
                }
            }
        }
        if (this.getLinkType() == 1 || this.getLinkType() == 4 || this.getLinkType() == 3 || this.getLinkType() == 9 || this.getLinkType() == 8) {
            IPathInfo[] iPathInfoArray = iPoolModel.getAvailablePaths(s);
            if (this.db.on()) {
                this.db.println("getLabelSet: obtained available paths for pathSize " + s);
                this.db.println("getLabelSet: paths.length = " + iPathInfoArray.length);
            }
            iConnectionModels = RoutableNetLink.getBaseHo(iPoolModel, n3);
            object4 = RoutableNetLink.getAllHoNums(iPoolModel.getNodeModel(), iPathInfoArray, (IHoNum)iConnectionModels);
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                iHoNum = (IHoNum)iterator.next();
                if (bl2) {
                    object3 = HoLoFactory.getAllLoNums(iHoNum.getFramingType(), n);
                    iLoPathInfoArray = object3.iterator();
                    while (iLoPathInfoArray.hasNext()) {
                        object2 = (ILoNum)iLoPathInfoArray.next();
                        object = HoLoFactory.createHoLoNum(iHoNum, (ILoNum)object2);
                        abstractLabelSet.addLabel((ILabel)object);
                    }
                    continue;
                }
                abstractLabelSet.addLabel((ILabel)iHoNum);
            }
        }
        if (this.db.on()) {
            this.db.println("getLabelSet: Returning " + abstractLabelSet.size() + " Labels");
        }
        return abstractLabelSet;
    }

    public List getAvailableHoNumbers(int n, int n2) {
        ArrayList arrayList = new ArrayList();
        this.getAvailableHoNumbers(arrayList, n, n2);
        return arrayList;
    }

    public void getAvailableHoNumbers(Collection collection, int n, int n2) {
        TreeSet<Object> treeSet = new TreeSet<Object>();
        ILabelSet iLabelSet = this.getSrcLabelSet(n, n2);
        ILabelSet iLabelSet2 = this.getDstLabelSet(n, n2);
        iLabelSet.intersectSelf(iLabelSet2);
        for (ILabel iLabel : iLabelSet.getLabelSet()) {
            if (iLabel instanceof IHoNum) {
                treeSet.add(iLabel);
                continue;
            }
            treeSet.add(((IHoLoNum)iLabel).getHoNum());
        }
        collection.addAll(treeSet);
    }

    protected ILoAditModel[] getSrcLoAdits(ICircuitSize iCircuitSize) {
        return this.getLoAdits(this.getSrc(), this.getSrcEntityIndex(), iCircuitSize);
    }

    protected ILoAditModel[] getSrcLoAdits() {
        return this.getSrcLoAdits(null);
    }

    protected ILoAditModel[] getDstLoAdits(ICircuitSize iCircuitSize) {
        return this.getLoAdits(this.getDst(), this.getDstEntityIndex(), iCircuitSize);
    }

    protected ILoAditModel[] getDstLoAdits() {
        return this.getDstLoAdits(null);
    }

    protected ILoAditModel[] getLoAdits(INetElement iNetElement, int n, ICircuitSize iCircuitSize) {
        INodeModel iNodeModel = iNetElement.getNodeModel();
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        IPoolModel iPoolModel = this.getPool(iNetElement, n);
        ILoAditModel[] iLoAditModelArray = RoutableNetLink.aditsWithCapacity(iConnectionModels.getLoAditsInPool(iPoolModel), iCircuitSize);
        if (iNodeModel.getTdmProtocolTypeObj().isSdh()) {
            ArrayList<ILoAditModel> arrayList = new ArrayList<ILoAditModel>();
            for (int i = 0; i < iLoAditModelArray.length; ++i) {
                ILoAditModel iLoAditModel = iLoAditModelArray[i];
                if (!(PortGrouping.getInstance().isInCreation() ^ !iLoAditModel.isReservedForPortGroup())) continue;
                arrayList.add(iLoAditModel);
            }
            if (arrayList.size() != iLoAditModelArray.length) {
                iLoAditModelArray = arrayList.toArray(new ILoAditModel[0]);
            }
        }
        return iLoAditModelArray;
    }

    public void getAvailableLoNumbers(Collection collection, IHoNum iHoNum, int n) {
        collection.addAll(this.getAvailableLoNumbers(iHoNum, n));
    }

    public List getAvailableLoNumbers(IHoNum iHoNum, int n) {
        return this.getAvailLoNums(iHoNum, false, n);
    }

    public List getAvailLoNums(IHoNum iHoNum, boolean bl, int n) {
        Object object;
        ILoPathInfo[] iLoPathInfoArray;
        ILoPathInfo[] iLoPathInfoArray2;
        short s;
        IHoNum iHoNum2;
        ArrayList arrayList = new ArrayList();
        boolean bl2 = false;
        IHoNum iHoNum3 = iHoNum2 = iHoNum;
        if (this.db.on()) {
            this.db.println("getAvailLoNums: looking at link " + this.prettyString() + "srcExtensible = " + this.isSrcExtendable() + " dstExtensible " + this.isDstExtendable());
        }
        if (this.isLOTunnel() || this.isLAP()) {
            if (bl) {
                if (this.db.on()) {
                    this.db.println("getAvailLoNums: Tunnel is not a valid link");
                }
                return arrayList;
            }
            iHoNum3 = this.getSrcHo();
            iHoNum2 = this.getDstHo();
        }
        if (iHoNum3 == null) {
            return arrayList;
        }
        int n2 = iHoNum3.getFramingType();
        ILoAditModel[] iLoAditModelArray = this.getSrcLoAdits();
        ILoAditModel[] iLoAditModelArray2 = this.getDstLoAdits();
        ILoAditModel iLoAditModel = (ILoAditModel)RoutableNetLink.linearSearch(iLoAditModelArray, iHoNum3, AditComparator.instance());
        ILoAditModel iLoAditModel2 = (ILoAditModel)RoutableNetLink.linearSearch(iLoAditModelArray2, iHoNum2, AditComparator.instance());
        if (this.isLAP()) {
            s = CircuitSize.getCircuitSize((int)n).size2widthOfLoCircuit();
            if (this.isSrcExtendable()) {
                iLoPathInfoArray2 = iLoAditModel.getAvailableLos((int)s);
                arrayList.addAll(RoutableNetLink.getAllLoNums(iLoPathInfoArray2));
            } else if (this.isDstExtendable()) {
                iLoPathInfoArray = iLoAditModel2.getAvailableLos((int)s);
                arrayList.addAll(RoutableNetLink.getAllLoNums(iLoPathInfoArray));
            }
            if (!arrayList.isEmpty()) {
                if (this.db.on()) {
                    this.db.println("getAvailLoNums: " + arrayList.size() + " Lo Numbers are available");
                }
                bl2 = true;
            }
        }
        if (iLoAditModel != null && iLoAditModel2 != null && (object = RoutableNetLink.getCommonLoNums(iLoPathInfoArray2 = iLoAditModel.getAvailableLos((int)(s = CircuitSize.getCircuitSize((int)n).size2widthOfLoCircuit())), iLoPathInfoArray = iLoAditModel2.getAvailableLos((int)s))) != null) {
            arrayList.addAll(object);
            if (this.db.on()) {
                this.db.println("getAvailLoNums: " + object.size() + " Lo Numbers are available");
            }
            bl2 = true;
        }
        if (!bl2) {
            int n3 = CircuitSize.getLoTunnelSize((int)n2).getEnum();
            s = CircuitSize.getCircuitSize((int)n3).size2widthOfHoCircuit();
            iLoPathInfoArray = this.getSrcPool();
            object = this.getDstPool();
            IPathInfo[] iPathInfoArray = iLoPathInfoArray.getAvailablePaths(s);
            IPathInfo[] iPathInfoArray2 = object.getAvailablePaths(s);
            if (this.getLinkType() == 1 || this.getLinkType() == 3 || this.getLinkType() == 9) {
                ILoPathInfo[] iLoPathInfoArray3;
                Set set;
                IPathInfo iPathInfo = (IPathInfo)RoutableNetLink.linearSearch(iPathInfoArray, iHoNum, new PathInfoComparator((IPoolModel)iLoPathInfoArray, n2));
                IPathInfo iPathInfo2 = (IPathInfo)RoutableNetLink.linearSearch(iPathInfoArray2, iHoNum, new PathInfoComparator((IPoolModel)object, n2));
                if (iPathInfo != null && iPathInfo2 != null) {
                    arrayList.addAll(HoLoFactory.getAllLoNums(n2, n));
                }
                if (iLoAditModel != null && iPathInfo2 != null && (set = RoutableNetLink.getAllLoNums(iLoPathInfoArray3 = iLoAditModel.getAvailableLos((int)(s = CircuitSize.getCircuitSize((int)n).size2widthOfLoCircuit())))) != null) {
                    arrayList.addAll(set);
                }
                if (iPathInfo != null && iLoAditModel2 != null && (set = RoutableNetLink.getAllLoNums(iLoPathInfoArray3 = iLoAditModel2.getAvailableLos((int)(s = CircuitSize.getCircuitSize((int)n).size2widthOfLoCircuit())))) != null) {
                    arrayList.addAll(set);
                }
            }
        }
        if (this.db.on()) {
            this.db.println("getAvailLoNums: returning " + arrayList.size() + " Lo Numbers");
        }
        return arrayList;
    }

    private static class PathInfoComparator
    implements Comparator {
        INodeModel node;
        IHoNum baseHo;

        public PathInfoComparator(IPoolModel iPoolModel, int n) {
            this.node = iPoolModel.getNodeModel();
            this.baseHo = AbstractNetLink.getBaseHo(iPoolModel, n);
        }

        public int compare(Object object, Object object2) {
            IHoNum iHoNum = object instanceof IPathInfo ? AbstractNetLink.physicalHo(this.node, this.baseHo, (IPathInfo)object) : (IHoNum)object;
            IHoNum iHoNum2 = object2 instanceof IPathInfo ? AbstractNetLink.physicalHo(this.node, this.baseHo, (IPathInfo)object2) : (IHoNum)object2;
            return AbstractNetLink.holoComp.compare(iHoNum, iHoNum2);
        }

        public boolean equals(Object object) {
            return object instanceof PathInfoComparator;
        }
    }

    private static class AditComparator
    implements Comparator {
        static AditComparator instance_ = new AditComparator();

        private AditComparator() {
        }

        static AditComparator instance() {
            return instance_;
        }

        public int compare(Object object, Object object2) {
            IHoNum iHoNum = object instanceof ILoAditModel ? AbstractNetLink.physicalHo((ILoAditModel)object) : (IHoNum)object;
            IHoNum iHoNum2 = object2 instanceof ILoAditModel ? AbstractNetLink.physicalHo((ILoAditModel)object2) : (IHoNum)object2;
            return AbstractNetLink.holoComp.compare(iHoNum, iHoNum2);
        }

        public boolean equals(Object object) {
            return object instanceof AditComparator;
        }
    }

    protected static interface ILotProtectionType {
        public static final int LOT_PROTECTION_UNDEFINED = 0;
        public static final int LOT_UNPROTECTED = 1;
        public static final int LOT_PROTECTED = 2;
        public static final int LOT_MIXED_PROTECTION = 3;
    }
}

