/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISvlanCircuitModels;
import cerent.cms.model.IXPL2ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SvlanCircuitHelper;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetLink;
import cerent.util.SDebug;

public class SvlanLinksRouteManager {
    private INetLink link;
    private SDebug db;

    public SvlanLinksRouteManager(INetLink iNetLink, SDebug sDebug) {
        this.link = iNetLink;
        this.db = sDebug;
    }

    public static boolean isUsableForSvlanCkt(INetLink iNetLink) {
        boolean bl = false;
        boolean bl2 = false;
        try {
            INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
            INodeModel iNodeModel2 = iNetLink.getDst().getNodeModel();
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(iNetLink.getSrcEntityIndex());
            iEntityTableModel = iNodeModel2.getEntityTable();
            IEntityModel iEntityModel2 = iEntityTableModel.getEntityModelByIndex(iNetLink.getDstEntityIndex());
            if (iEntityModel.getModuleModel() instanceof IXPL2ModuleModel && iEntityModel2.getModuleModel() instanceof IXPL2ModuleModel) {
                bl2 = ((IXPL2ModuleModel)iEntityModel.getModuleModel()).isL2Switch() && ((IXPL2ModuleModel)iEntityModel2.getModuleModel()).isL2Switch();
            }
            bl = !(iEntityModel.getModuleModel().getEqType() != 271 && iEntityModel.getModuleModel().getEqType() != 272 || iEntityModel2.getModuleModel().getEqType() != 272 && iEntityModel2.getModuleModel().getEqType() != 271);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return bl && bl2;
    }

    public boolean isUsable(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        if (this.link.getReverseLink() == iNetLink) {
            throw new xLinkNotUsable("Link already considered in opposite direction.");
        }
        if (!SvlanLinksRouteManager.isUsableForSvlanCkt(this.link)) {
            throw new xLinkNotUsable("Link does not start/end over a GZ card in L2 mode.");
        }
        if (routePrefs.getPreferredLinks().contains(this.link)) {
            return true;
        }
        if (this.link.getSrc().equals(routePrefs.getSrc())) {
            if (!SvlanCircuitHelper.arePortsCoLocatedForL2Ckt(this.link.getSrc(), routePrefs.getcktSrcEntityIndex(), this.link.getSrcEntityIndex(), true)) {
                throw new xLinkNotUsable("Link srcId is " + Integer.toHexString(this.link.getSrcEntityIndex()) + ", but ckt srcId is " + Integer.toHexString(routePrefs.getcktSrcEntityIndex()));
            }
        } else if (!SvlanCircuitHelper.arePortsCoLocatedForL2Ckt(this.link.getSrc(), this.link.getSrcEntityIndex(), iNetLink.getDstEntityIndex(), true)) {
            throw new xLinkNotUsable("Link " + iNetLink + ", not connected with " + this);
        }
        if (this.link.getDst().equals(routePrefs.getDst()) && !SvlanCircuitHelper.arePortsCoLocatedForL2Ckt(this.link.getDst(), routePrefs.getcktDstEntityIndex(), this.link.getDstEntityIndex(), true)) {
            throw new xLinkNotUsable("Link dstId is " + Integer.toHexString(this.link.getDstEntityIndex()) + ", but ckt dstId is " + Integer.toHexString(routePrefs.getcktDstEntityIndex()));
        }
        ISvlanCircuitModels iSvlanCircuitModels = this.link.getSrc().getNodeModel().getSvlanCircuitModels();
        ISvlanCircuitModels iSvlanCircuitModels2 = this.link.getDst().getNodeModel().getSvlanCircuitModels();
        boolean bl = true;
        for (NetLinkSpan netLinkSpan : routePrefs.getRequiredSpans()) {
            if (netLinkSpan.getLink() != this.link && netLinkSpan.getLink().getReverseLink() != this.link) continue;
            bl = false;
            break;
        }
        if (bl) {
            try {
                if (!iSvlanCircuitModels.isSvlanAvailable(this.link.getSrcEntityIndex(), routePrefs.getSvlan(), routePrefs.getPathProt() == 1)) {
                    throw new xLinkNotUsable("SVLAN " + routePrefs.getSvlan() + " already in use on node " + this.link.getSrc().getName() + " port " + Integer.toHexString(this.link.getSrcEntityIndex()));
                }
                if (!iSvlanCircuitModels2.isSvlanAvailable(this.link.getDstEntityIndex(), routePrefs.getSvlan(), routePrefs.getPathProt() == 1)) {
                    throw new xLinkNotUsable("SVLAN " + routePrefs.getSvlan() + " already in use on node " + this.link.getDst().getName() + " port " + Integer.toHexString(this.link.getDstEntityIndex()));
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                throw new xLinkNotUsable("Cannot check availability for SVLAN " + routePrefs.getSvlan() + ": " + wrongInterfaceType.getMessage());
            }
            catch (NoSuchInterface noSuchInterface) {
                throw new xLinkNotUsable("Cannot check availability for SVLAN " + routePrefs.getSvlan() + ": " + noSuchInterface.getMessage());
            }
        }
        return true;
    }
}

