/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.cms.ui.ObserverProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.NoSuchElementException;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class AbstractProvTablePane
extends ObserverProvPane
implements TableModelListener {
    public static final int PROVISIONING_PANE = 0;
    public static final int MAINTENANCE_PANE = 1;
    protected AbstractProvTableModel dataModel;
    protected UScrollPane scrollPane;
    private boolean isProvPane;

    public AbstractProvTablePane(String string, TabbedView tabbedView, AbstractProvTableModel abstractProvTableModel, boolean bl) {
        super(string, tabbedView, abstractProvTableModel);
        this.dataModel = abstractProvTableModel;
        this.isProvPane = bl;
        this.table = new UTable((TableModel)this.dataModel);
        this.scrollPane = new UScrollPane((Component)this.table);
        this.add((Component)this.scrollPane, "Center");
        this.dataModel.addTableModelListener(this);
        this.setDataSourceControl(abstractProvTableModel);
        this.table.setRowHeight(this.table.getRowHeight() * 4 / 3);
        this.setDefaultPrivilegeLevel(bl ? SecurityLevel.PROVISIONING : SecurityLevel.MAINTENANCE);
        this.dataModel.setEnabled(this.isUserAuthorized());
        if (bl) {
            this.addButtonPanel();
        } else {
            this.addHelpPanel();
        }
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
    }

    public boolean isProvisioningPane() {
        return this.isProvPane;
    }

    public boolean hasSubTabs() {
        return true;
    }

    public void dispose() {
        this.dataModel.removeTableModelListener(this);
        this.dataModel = null;
        super.dispose();
    }

    protected void setColumnAttributes(int n, int n2, boolean bl, TableCellRenderer tableCellRenderer) {
        int n3 = this.table.convertColumnIndexToView(n);
        if (n3 != -1) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(n3);
            tableColumn.setPreferredWidth(n2);
            tableColumn.setResizable(bl);
            if (!bl) {
                tableColumn.setMinWidth(n2);
                tableColumn.setMaxWidth(n2);
            }
            if (tableCellRenderer != null) {
                tableColumn.setCellRenderer(tableCellRenderer);
            }
        }
    }

    protected void setColumnCellEditor(int n, String string) {
        Object[] objectArray = null;
        try {
            objectArray = this.getAttributes(string);
        }
        catch (NoSuchElementException noSuchElementException) {
            objectArray = null;
        }
        if (objectArray != null) {
            this.setColumnCellEditor(n, new DefaultCellEditor(AbstractProvTablePane.getComboBoxFor(objectArray)));
        }
    }

    protected abstract Attribute[] getAttributes(String var1);

    protected void setColumnCellEditor(int n, TableCellEditor tableCellEditor) {
        int n2 = this.table.convertColumnIndexToView(n);
        if (n2 != -1) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
            tableColumn.setCellEditor(tableCellEditor);
            tableColumn.sizeWidthToFit();
        }
    }

    protected void setColumnCellEditor(int n, Object[] objectArray) {
        this.setColumnCellEditor(n, new DefaultCellEditor(AbstractProvTablePane.getComboBoxFor(objectArray)));
    }

    protected static JComboBox getComboBoxFor(Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected static DefaultCellEditor getIntegerRangeCellEditor(int n, int n2) {
        int n3 = n2 - n + 1;
        Object[] objectArray = new Integer[n3];
        for (int i = 0; i < n3; ++i) {
            objectArray[i] = new Integer(i + n);
        }
        return new DefaultCellEditor(AbstractProvTablePane.getComboBoxFor(objectArray));
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel != null && this.dataModel.isDirty()) {
            this.setDirty();
        }
        this.cancelTableCellEditing();
    }
}

