/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.ui.event.EventColumnRenderer;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AlarmCounters
extends JPanel
implements Observer,
Runnable {
    private static final String CR_TT = "Critical Alarms";
    private static final String MJ_TT = "Major Alarms";
    private static final String MN_TT = "Minor Alarms";
    private JLabel critical = this.createCounter("Critical Alarms", EventColumnRenderer.getBgColor(4), EventColumnRenderer.getFgColor(4));
    private JLabel major = this.createCounter("Major Alarms", EventColumnRenderer.getBgColor(3), EventColumnRenderer.getFgColor(3));
    private JLabel minor = this.createCounter("Minor Alarms", EventColumnRenderer.getBgColor(2), EventColumnRenderer.getFgColor(2));
    private IAlarmStore alarmStore;

    public AlarmCounters(IAlarmStore iAlarmStore) {
        super(new GridLayout(1, 3, 2, 2));
        this.add(this.critical);
        this.add(this.major);
        this.add(this.minor);
        this.setAlarmStore(iAlarmStore);
        this.run();
    }

    private JLabel createCounter(String string, Color color, Color color2) {
        JLabel jLabel = new JLabel();
        jLabel.setToolTipText(string);
        jLabel.setBackground(color);
        jLabel.setForeground(color2);
        jLabel.setOpaque(true);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setHorizontalAlignment(0);
        jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        return jLabel;
    }

    public void update(Observable observable, Object object) {
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        if (this.alarmStore != null) {
            IAlarmStatus iAlarmStatus = this.alarmStore.getAlarmStatus();
            this.critical.setText(Integer.toString(iAlarmStatus.critical()) + " CR");
            this.major.setText(Integer.toString(iAlarmStatus.major()) + " MJ");
            this.minor.setText(Integer.toString(iAlarmStatus.minor()) + " MN");
        } else {
            this.critical.setText("N/A");
            this.major.setText("N/A");
            this.minor.setText("N/A");
        }
        this.critical.invalidate();
        this.major.invalidate();
        this.minor.revalidate();
    }

    public void setAlarmStore(IAlarmStore iAlarmStore) {
        if (this.alarmStore != null) {
            this.alarmStore.deleteAlarmStatusObserver((Observer)this);
        }
        this.alarmStore = iAlarmStore;
        if (this.alarmStore != null) {
            this.alarmStore.addAlarmStatusObserver((Observer)this);
        }
        SwingUtilities.invokeLater(this);
    }

    public void destroy() {
        this.alarmStore.deleteAlarmStatusObserver((Observer)this);
    }
}

