/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.CmsObservable;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.NetCSHelpConst;
import cerent.util.BusEvent;
import cerent.util.DetailedLog;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.Preferences;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedLogPane;
import cerent.util.gui.WindowHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DetailedLogCollector
extends JFrame
implements ActionListener,
Observer {
    private static final String PROP_NAME = "ctc.detailedlog";
    private static final String PROP_ALERT_LEVEL = "alertlevel";
    private static final Rectangle DEFAULT_BOUNDS = new Rectangle(-1, -1, 642, 300);
    private static final String APPLICATION_ICON = "/images/icons/CTC_icon.gif";
    public static final Icon ICON_SAVE = WindowHelper.getIcon(DetailedLogCollector.class, (String)"/images/icons/save16.gif");
    public static final Icon ICON_DELETE = WindowHelper.getIcon(DetailedLogCollector.class, (String)"/images/icons/delete_alarmlog_16.gif");
    public static final Icon ICON_NEW_ERROR_LOG = WindowHelper.getIcon(DetailedLogCollector.class, (String)"/images/icons/new_alarmlog_19.gif");
    public static final Icon ICON_ERROR_LOG = WindowHelper.getIcon(DetailedLogCollector.class, (String)"/images/icons/alarmlog_16.gif");
    private static DetailedLogCollector _instance;
    private JButton close = new JButton("Close");
    private JButton clear = new JButton("Clear", ICON_DELETE);
    private JButton save = new JButton("Save...", ICON_SAVE);
    private JLabel alertJL = new JLabel("Auto-popup:");
    private static final String[] aLevels;
    private JComboBox alertLevel = new JComboBox<String>(aLevels);
    private static final int ALWAYS = 0;
    private static final int ON_ERROR = 1;
    private static final int NEVER = 2;
    private static int currentAlertLevel;
    private DetailedLogPane dlp;
    private int unreadCount = 0;
    private LocalObservable obs = new LocalObservable();

    protected DetailedLogCollector(String string) {
        super(string);
        Object object;
        Serializable serializable;
        this.dlp = new DetailedLogPane(null, true, true);
        this.dlp.setThreshold(20, 50);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.dlp);
        try {
            serializable = DetailedLogCollector.class.getResource(APPLICATION_ICON);
            object = Toolkit.getDefaultToolkit().getImage((URL)serializable);
            this.setIconImage((Image)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = Box.createHorizontalBox();
        if (this.hasFiltering()) {
            ((Container)serializable).add(this.alertJL);
            ((Container)serializable).add(Box.createHorizontalStrut(5));
            ((Container)serializable).add(this.alertLevel);
            ((Container)serializable).add(Box.createHorizontalStrut(10));
        }
        ((Container)serializable).add(Box.createHorizontalGlue());
        ((Container)serializable).add(this.save);
        ((Container)serializable).add(Box.createHorizontalStrut(10));
        ((Container)serializable).add(this.clear);
        ((Container)serializable).add(Box.createHorizontalStrut(10));
        ((Container)serializable).add(this.close);
        ((Container)serializable).add(Box.createHorizontalStrut(10));
        ((Container)serializable).add(new CSHelpButton(NetCSHelpConst.DetailedLogCollector));
        this.alertLevel.addActionListener(this);
        this.save.addActionListener(this);
        this.close.addActionListener(this);
        this.clear.addActionListener(this);
        this.setDefaultCloseOperation(1);
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ((Container)object).add((Component)serializable);
        this.getContentPane().add((Component)object, "South");
        this.pack();
        WindowHelper.restoreBounds((Component)this, (String)this.getPropName(), (Rectangle)this.getDefaultBounds());
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                CerentDialog.toFront();
            }

            public void windowActivated(WindowEvent windowEvent) {
                if (DetailedLogCollector.this.unreadCount > 0) {
                    DetailedLogCollector.this.unreadCount = 0;
                    DetailedLogCollector.this.obs.notifyObservers();
                }
            }
        });
        this.registerEventBus();
        if (this.hasFiltering()) {
            currentAlertLevel = Preferences.instance().getInt(this.getPropName(), PROP_ALERT_LEVEL, 0);
            this.alertLevel.setSelectedIndex(currentAlertLevel);
        } else {
            currentAlertLevel = 0;
        }
    }

    protected boolean hasFiltering() {
        return true;
    }

    protected String getPropName() {
        return PROP_NAME;
    }

    protected Rectangle getDefaultBounds() {
        return DEFAULT_BOUNDS;
    }

    protected void registerEventBus() {
        EventBus.instance().addObserver((Observer)this, (Object)EventBusServices.BG_STATUS_COLLECTOR);
    }

    protected boolean isRegisteredFor(BusEvent busEvent) {
        return busEvent.getSource() == EventBusServices.BG_STATUS_COLLECTOR;
    }

    public static synchronized DetailedLogCollector instance() {
        if (_instance == null) {
            _instance = new DetailedLogCollector("CTC Alerts");
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.close) {
            this.setVisible(false);
        } else if (object == this.save) {
            this.save();
        } else if (object == this.alertLevel) {
            int n = this.alertLevel.getSelectedIndex();
            if (currentAlertLevel != n) {
                currentAlertLevel = n;
                Preferences.instance().setInt(this.getPropName(), PROP_ALERT_LEVEL, currentAlertLevel);
            }
        } else {
            DetailedLogPane detailedLogPane = this.dlp;
            synchronized (detailedLogPane) {
                this.dlp.clear();
            }
            this.obs.notifyObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable observable, Object object) {
        if (object instanceof BusEvent) {
            BusEvent busEvent = (BusEvent)object;
            if (!this.isRegisteredFor(busEvent)) {
                return;
            }
            if (busEvent.getEvent() instanceof DetailedLog) {
                DetailedLog detailedLog = (DetailedLog)busEvent.getEvent();
                DetailedLogPane detailedLogPane = this.dlp;
                synchronized (detailedLogPane) {
                    int n = this.dlp.removeDetailedLog(detailedLog);
                    if (n >= 0 && n < this.unreadCount) {
                        --this.unreadCount;
                    }
                    this.dlp.addDetailedLog(detailedLog, true);
                }
                if (currentAlertLevel == 0 || currentAlertLevel == 1 && detailedLog.getType() == 3) {
                    this.popup();
                } else if (this.getFocusOwner() == null) {
                    ++this.unreadCount;
                }
                this.obs.notifyObservers();
            }
        }
    }

    public int getUnreadCount() {
        int n = this.dlp.getDlCount();
        if (this.unreadCount > n) {
            this.unreadCount = n;
        }
        return this.unreadCount;
    }

    public int getTotalDlCount() {
        return this.dlp.getDlCount();
    }

    public Icon getWindowIcon() {
        if (this.unreadCount > 0) {
            return ICON_NEW_ERROR_LOG;
        }
        return ICON_ERROR_LOG;
    }

    public void popup() {
        this.setState(0);
        this.setVisible(true);
    }

    public void addObserver(Observer observer) {
        if (observer != null) {
            this.obs.addObserver(observer);
        }
    }

    public void deleteObserver(Observer observer) {
        if (observer != null) {
            this.obs.deleteObserver(observer);
        }
    }

    public void dispose() {
        WindowHelper.persistBounds((Component)this, (String)this.getPropName());
        if (this.hasFiltering()) {
            Preferences.instance().setInt(this.getPropName(), PROP_ALERT_LEVEL, currentAlertLevel);
        }
        super.dispose();
    }

    private void save() {
        int n = this.alertLevel.getSelectedIndex();
        this.alertLevel.setSelectedIndex(2);
        this.dlp.saveToFile("Save CTC Alert Window to File", "Select the file to which the log will be saved.", this.getPropName(), "save", "CTC ALERT WINDOW CONTENT");
        this.alertLevel.setSelectedIndex(n);
    }

    static {
        aLevels = new String[]{"All alerts", "Error alerts only", "Never"};
        currentAlertLevel = 0;
    }

    private class LocalObservable
    extends CmsObservable {
        private LocalObservable() {
        }

        public void notifyObservers() {
            super.setChanged();
            super.notifyObservers();
        }
    }
}

