/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ShellDebugManager;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;

public class DiagMaintPane
extends AbstractPane
implements ActionListener {
    private AbstractViewController avc = null;
    private IModel paneModel;
    protected static final SDebug db = new SDebug((KDebug)db, "DiagMaintPane");
    protected JComboBox nodeSelectionCB;
    protected JComboBox diagCommands;
    protected JComboBox ospfLSDBCB;
    protected JButton ospfDNClearB;
    protected JButton retrieveDiagB;
    protected JButton ospfLSDBB;
    protected JTextArea outputArea;
    protected JTextArea ospfLSDBTA;
    private UScrollPane scrollPaneLSDB;
    private UScrollPane scrollPaneDNodes;
    protected static final int DUMP_NODES_CMD = 0;
    protected static final int DUMP_PROXY_STATUS = 2;
    protected static final String SELECT_NODE = " Select Node: ";
    protected static final String NODE_INFO = "OSPF Node Information";
    protected static final String LSDB = "OSPF Link-State Database";
    protected static final String CLEAR = "Clear";
    protected static final String RETRIEVE = "Retrieve";
    protected static final String CLEAR_TIP = "Clear the text area below";
    protected static final String RETRIEVE_TIP = "Retrieve OSPF Node Information";
    ShellDebugManager sdm;

    public DiagMaintPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        this.paneModel = iModel;
        this.sdm = ShellDebugManager.instance();
        this.sdm.addObserver((Observer)((Object)this));
    }

    private JPanel createDumpNodesPane(INodeModel[] iNodeModelArray) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Diagnostic"));
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(NetCSHelpConst.DiagMaintPane);
        cSHelpButtonPane.addLeft(new JLabel(SELECT_NODE));
        this.nodeSelectionCB = new JComboBox<INodeModel>(iNodeModelArray);
        this.nodeSelectionCB.setRenderer(new NMCRenderer());
        this.nodeSelectionCB.setEditable(false);
        this.nodeSelectionCB.addActionListener(this);
        cSHelpButtonPane.addLeft(this.nodeSelectionCB);
        cSHelpButtonPane.addLeft(new JLabel("Select Diagonostic: "));
        this.diagCommands = new JComboBox();
        this.diagCommands.addItem("OSPF Nodes");
        this.diagCommands.addItem("Proxy Status");
        this.diagCommands.addActionListener(this);
        cSHelpButtonPane.addLeft(this.diagCommands);
        this.retrieveDiagB = new JButton(RETRIEVE);
        this.retrieveDiagB.setEnabled(true);
        this.retrieveDiagB.addActionListener(this);
        this.retrieveDiagB.setToolTipText(RETRIEVE_TIP);
        cSHelpButtonPane.addLeft(this.retrieveDiagB);
        this.ospfDNClearB = new JButton(CLEAR);
        this.ospfDNClearB.setEnabled(true);
        this.ospfDNClearB.addActionListener(this);
        this.ospfDNClearB.setToolTipText(CLEAR_TIP);
        cSHelpButtonPane.addLeft(this.ospfDNClearB);
        jPanel.add((Component)cSHelpButtonPane, "North");
        this.outputArea = new JTextArea();
        this.outputArea.setEditable(false);
        this.outputArea.setMargin(new Insets(5, 5, 5, 0));
        this.scrollPaneDNodes = new UScrollPane((Component)this.outputArea);
        jPanel.add((Component)this.scrollPaneDNodes, "Center");
        return jPanel;
    }

    private JPanel createLSDBPane(INodeModel[] iNodeModelArray) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(LSDB));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel2.add(new JLabel(SELECT_NODE));
        this.ospfLSDBCB = new JComboBox<INodeModel>(iNodeModelArray);
        this.ospfLSDBCB.setRenderer(new NMCRenderer());
        this.ospfLSDBCB.setEditable(false);
        this.ospfLSDBCB.addActionListener(this);
        jPanel2.add(this.ospfLSDBCB);
        this.ospfLSDBB = new JButton(CLEAR);
        this.ospfLSDBB.setEnabled(true);
        this.ospfLSDBB.addActionListener(this);
        jPanel2.add((Component)this.ospfLSDBB, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.ospfLSDBTA = new JTextArea(10, 35);
        this.ospfLSDBTA.setEditable(false);
        this.scrollPaneLSDB = new UScrollPane((Component)this.ospfLSDBTA);
        jPanel3.add((Component)this.scrollPaneLSDB);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add(jPanel3);
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() {
        try {
            this.setCursor(3);
            if (this.nodeSelectionCB == null) {
                this.init();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.setCursor(0);
            throw throwable;
        }
        this.setCursor(0);
    }

    public void leavingPage() {
    }

    protected void init() {
        if (db.on()) {
            db.println("<init>: start");
        }
        INodeModel[] iNodeModelArray = this.sdm.getKnownNodes();
        this.setLayout(new BorderLayout());
        this.add(this.createDumpNodesPane(iNodeModelArray), "Center");
        this.registerWithModel();
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("Got an Update Message from " + observable + " arg: " + object);
        }
        if (observable instanceof ShellDebugManager) {
            this.requestRefresh(observable, this.getRefreshThread());
        }
    }

    private Runnable getRefreshThread() {
        return new Runnable(){

            public void run() {
                DiagMaintPane.this.refresh();
            }
        };
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object var2_2 = null;
        Object object = actionEvent.getSource();
        String string = "";
        if (object == this.retrieveDiagB) {
            INodeModel iNodeModel = (INodeModel)this.nodeSelectionCB.getSelectedItem();
            String string2 = (String)this.diagCommands.getSelectedItem();
            if (string2.equals("OSPF Nodes")) {
                string = this.sdm.shellDebugCommand(iNodeModel, 0);
            } else if (string2.equals("Proxy Status")) {
                string = this.sdm.shellDebugCommand(iNodeModel, 2);
            }
            if (string.length() > 0) {
                this.outputArea.setText(string);
                this.outputArea.revalidate();
            }
        } else if (object == this.ospfDNClearB) {
            this.outputArea.setText(null);
            this.outputArea.revalidate();
        }
    }

    public void destroy() {
        super.destroy();
    }

    public void refresh() {
        ArrayList<INodeModel> arrayList;
        if (db.on()) {
            db.println("refresh: start");
        }
        if (this.nodeSelectionCB != null && !(arrayList = new ArrayList<INodeModel>(Arrays.asList(this.sdm.getKnownNodes()))).isEmpty()) {
            this.nodeSelectionCB.removeAllItems();
            for (INodeModel iNodeModel : arrayList) {
                this.nodeSelectionCB.addItem(iNodeModel);
            }
        }
        if (db.on()) {
            db.println("refresh: finish");
        }
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.DiagMaintPane;
    }

    private class NMCRenderer
    extends JLabel
    implements ListCellRenderer {
        public NMCRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            if (object instanceof INodeModel) {
                string = ((INodeModel)object).getName();
            }
            this.setText(string);
            Color color = new Color(205, 205, 255);
            this.setBackground(bl ? color : Color.white);
            this.setForeground(Color.black);
            return this;
        }
    }
}

