/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.loader.IElementFactory;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.ExplorerPaneModel;
import cerent.cms.model.ExplorerTreeCard;
import cerent.cms.model.ExplorerTreeNode;
import cerent.cms.model.ExplorerTreeShelf;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeType;
import cerent.cms.model.NodeModel;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.model.event.ICardAlarmStore;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.MainPanel;
import cerent.cms.ui.ViewName;
import cerent.util.InetUtil;
import cerent.util.ProxyConfigHelper;
import cerent.util.SDebug;
import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.SckfwdClient;
import com.cisco.crs.model.SlotId;
import com.cisco.ctc.CtcApplication;
import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ExplorerController
implements Observer {
    ExplorerPaneModel model;
    DefaultMutableTreeNode rootnode;
    LinkedList nelist;
    private static SDebug db = new SDebug("ExplorerController");
    public static final String OK_STRING = "OK";
    public static final String MINOR_STRING = "Minor";
    public static final String MAJOR_STRING = "Major";
    public static final String CRITICAL_STRING = "Critical";
    public static final String DISCONNECTED_STRING = "Disconnected";
    public static final String POSITION_XY = "PositionXY";
    public static final String OOS_MT_STRING = "OOS_MT";
    public static final String IS_AINS_STRING = "IS_AINS";
    public static final Color OK_COLOR = Color.green;
    public static final Color MINOR_COLOR = Color.yellow;
    public static final Color MAJOR_COLOR = Color.orange;
    public static final Color CRITICAL_COLOR = Color.red;
    public static final Color DISCONNECTED_COLOR = Color.gray;
    public static final Color OOS_MT_COLOR = Color.cyan;
    public static final Color IS_AINS_COLOR = new Color(205, 205, 255);
    public static final String NETWORK_LOC = "/images/icons/network16.gif";
    public static final String SHELF_LOC = "/images/icons/shelf.gif";
    public static final String OK_LOC = "/images/icons/OK_LOC.gif";
    public static final String MINOR_LOC = "/images/icons/MINOR_LOC.gif";
    public static final String MAJOR_LOC = "/images/icons/MAJOR_LOC.gif";
    public static final String CRITICAL_LOC = "/images/icons/CRITICAL_LOC.gif";
    public static final String DISCONNECTED_LOC = "/images/icons/DISCONNECTED_LOC.gif";
    public static final String OOS_MT_LOC = "/images/icons/OOS_MT_LOC.gif";
    public static final String IS_AINS_LOC = "/images/icons/OOS_MT_LOC.gif";
    public static final String UNKNOWN_LOC = "/images/icons/UNKNOWN_LOC.gif";
    public static final ImageIcon NETWORK_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/network16.gif"));
    public static final ImageIcon SHELF_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/shelf.gif"));
    public static final ImageIcon OK_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/OK_LOC.gif"));
    public static final ImageIcon MINOR_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/MINOR_LOC.gif"));
    public static final ImageIcon MAJOR_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/MAJOR_LOC.gif"));
    public static final ImageIcon CRITICAL_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/CRITICAL_LOC.gif"));
    public static final ImageIcon DISCONNECTED_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/DISCONNECTED_LOC.gif"));
    public static final ImageIcon OOS_MT_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/OOS_MT_LOC.gif"));
    public static final ImageIcon IS_AINS_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/OOS_MT_LOC.gif"));
    public static final ImageIcon UNKNOWN_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/OOS_MT_LOC.gif"));
    public static final String DEFAULT_CARD_LOC = "/images/icons/DEFAULT_CARD_LOC.gif";
    public static final String MINOR_CARD_LOC = "/images/icons/MINOR_CARD_LOC.gif";
    public static final String MAJOR_CARD_LOC = "/images/icons/MAJOR_CARD_LOC.gif";
    public static final String CRITICAL_CARD_LOC = "/images/icons/CRITICAL_CARD_LOC.gif";
    public static final String DELETED_CARD_LOC = "/images/icons/DELETED_CARD_LOC.gif";
    public static final String OOS_MT_CARD_LOC = "/images/icons/OOS_MT_CARD_LOC.gif";
    public static final String IS_AINS_CARD_LOC = "/images/icons/OOS_MT_CARD_LOC.gif";
    public static final String PROVISION_CARD_LOC = "/images/icons/PROVISION_CARD_LOC.gif";
    public static final ImageIcon DEFAULT_CARD_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/DEFAULT_CARD_LOC.gif"));
    public static final ImageIcon MINOR_CARD_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/MINOR_CARD_LOC.gif"));
    public static final ImageIcon MAJOR_CARD_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/MAJOR_CARD_LOC.gif"));
    public static final ImageIcon CRITICAL_CARD_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/CRITICAL_CARD_LOC.gif"));
    public static final ImageIcon DELETED_CARD_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/DELETED_CARD_LOC.gif"));
    public static final ImageIcon OOS_MT_CARD_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/OOS_MT_CARD_LOC.gif"));
    public static final ImageIcon IS_AINS_CARD_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/OOS_MT_CARD_LOC.gif"));
    public static final ImageIcon PROVISION_CARD_ICON = new ImageIcon(ExplorerController.class.getResource("/images/icons/PROVISION_CARD_LOC.gif"));
    public static final int UNKNOWN_CARD = -1;
    public static final int NOT_PRESENT_CARD = 0;
    public static final int MISMATCH_CARD = 1;
    public static final int LOADING_CARD = 2;
    public static final int FAILED_CARD = 3;
    public static final int STANDBY_CARD = 4;
    public static final int ACTIVE_CARD = 5;
    public static final int DELETED_CARD = 6;
    public static final int ERROR_CARD = 7;
    public static final int PROVISIONED_CARD = 8;
    public static final int CRITICAL_CARD = 9;
    public static final int MAJOR_CARD = 10;
    public static final int MINOR_CARD = 11;
    public static final int OOS_MT_CARD = 12;
    protected int state = 5;
    protected Color node_color = Color.cyan;
    private static ExplorerController ec;

    public ExplorerController(ExplorerPaneModel explorerPaneModel) {
        ec = this;
        this.model = explorerPaneModel;
    }

    public static ExplorerController instance() {
        return ec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildTree() {
        block7: {
            db.fine("Build Tree");
            if (((DefaultMutableTreeNode)this.model.getRoot()).getChildCount() > 0) {
                return;
            }
            try {
                Collection collection;
                Network network = Network.instance();
                Network.NetElementCreationNotifier netElementCreationNotifier = network.getNetElementCreationNotifier();
                netElementCreationNotifier.addObserver(this);
                Collection collection2 = collection = network.getAllElements();
                synchronized (collection2) {
                    for (NetElement netElement : collection) {
                        this.addNode(netElement);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)nullPointerException);
                db.println("NullPointerException in build tree");
            }
        }
    }

    public void collapseTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.model.getRoot();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.deleteNode(((ExplorerTreeNode)defaultMutableTreeNode.getChildAt(i)).getNe(), (ExplorerTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
        Network network = Network.instance();
        Network.NetElementCreationNotifier netElementCreationNotifier = network.getNetElementCreationNotifier();
        netElementCreationNotifier.deleteObserver(this);
        defaultMutableTreeNode.removeAllChildren();
        this.model.reload(defaultMutableTreeNode);
    }

    public void deleteCard(IModuleModel iModuleModel, ExplorerTreeCard explorerTreeCard) {
        block5: {
            db.fine("Delete Card");
            iModuleModel.deleteObserver((Observer)explorerTreeCard);
            try {
                if (explorerTreeCard.getParent() != null) {
                    ExplorerTreeCard explorerTreeCard2 = explorerTreeCard;
                    TreePath treePath = new TreePath(this.model.getPathToRoot(explorerTreeCard2));
                    this.model.valueForPathChanged(treePath, explorerTreeCard);
                    this.model.reload(explorerTreeCard.getParent());
                }
            }
            catch (ClassCastException classCastException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)classCastException);
                    db.fine("ClassCastException in deleteCard");
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!db.on()) break block5;
                SDebug.printStackTrace((Throwable)nullPointerException);
                db.println("NullPointerException in deleteCard");
            }
        }
    }

    private int getShelfIndexfromChasis(String string, IEntityModel[] iEntityModelArray) {
        block7: {
            try {
                string = string.substring(5);
                int n = Integer.parseInt(string);
                for (int i = 0; i < iEntityModelArray.length; ++i) {
                    if (iEntityModelArray[i].getShelfId() != n) continue;
                    return i;
                }
            }
            catch (NullPointerException nullPointerException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)nullPointerException);
                    db.println("NullPointerException in getShelfIndexfromChasis");
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)numberFormatException);
                    db.println("NumberFormatException in getShelfIndexfromChasis");
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
                db.println("ArrayIndexOutOfBoundsException in getShelfIndexfromChasis");
            }
        }
        return -1;
    }

    public void addCard(IEntityModel iEntityModel, ExplorerTreeNode explorerTreeNode) {
        block9: {
            db.fine("Add Card");
            try {
                NetElement netElement = explorerTreeNode.getNe();
                List list = iEntityModel.getChildren();
                if (list.size() > 0) {
                    IModuleModel iModuleModel = (IModuleModel)list.get(0);
                    String string = iModuleModel.getEqLabel();
                    int n = iModuleModel.getSlot();
                    int n2 = n - 1;
                    string = n + " - " + string;
                    TreeNode treeNode = null;
                    if (netElement.getNodeModel().isMultishelf()) {
                        int n3 = iModuleModel.getShelfId();
                        n3 = this.getShelfIndexfromNode(n3, explorerTreeNode);
                        treeNode = this.getActualNodeForSlot(explorerTreeNode.getChildAt(n3), n);
                    } else {
                        treeNode = this.getActualNodeForSlot(explorerTreeNode, n);
                    }
                    ExplorerTreeCard explorerTreeCard = (ExplorerTreeCard)treeNode;
                    explorerTreeCard.setName(string);
                    explorerTreeCard.setModel((IEntityModel)iModuleModel);
                    TreePath treePath = new TreePath(this.model.getPathToRoot(treeNode));
                    iModuleModel.addObserver((Observer)explorerTreeCard);
                    this.model.valueForPathChanged(treePath, explorerTreeCard);
                    this.model.reload(explorerTreeCard.getParent());
                }
            }
            catch (NullPointerException nullPointerException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)nullPointerException);
                    db.println("NullPointerException in add card");
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
                    db.println("ArrayIndexOutOfBoundsException in add card");
                }
            }
            catch (ClassCastException classCastException) {
                if (!db.on()) break block9;
                SDebug.printStackTrace((Throwable)classCastException);
                db.println("ClassCastException in add card");
            }
        }
    }

    private TreeNode getActualNodeForSlot(TreeNode treeNode, int n) {
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            ExplorerTreeCard explorerTreeCard = (ExplorerTreeCard)treeNode.getChildAt(i);
            if (explorerTreeCard == null || explorerTreeCard.getEntityModel() == null || !this.checkIsDoubleSlot(explorerTreeCard.getEntityModel().getEqType())) continue;
            --n2;
        }
        return treeNode.getChildAt(n2);
    }

    private int getShelfIndexfromNode(int n, DefaultMutableTreeNode defaultMutableTreeNode) {
        String string = "Shelf" + n;
        int n2 = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            if (!defaultMutableTreeNode.getChildAt(i).toString().equals(string)) continue;
            return i;
        }
        return -1;
    }

    void addNode(NetElement netElement) {
        block3: {
            db.fine("Add Node");
            try {
                this.state = this.getModelState(netElement);
                ExplorerTreeNode explorerTreeNode = new ExplorerTreeNode(netElement, this.state, this.node_color, db);
                netElement.addObserver(explorerTreeNode);
                if (this.state != 5 && this.state != 4) {
                    this.startObservingAlarmStore(netElement, explorerTreeNode);
                }
                this.rootnode = (DefaultMutableTreeNode)this.model.getRoot();
                this.model.insertNodeSorted(this.rootnode, explorerTreeNode);
                this.rootnode.setUserObject("Network Explorer(" + this.rootnode.getChildCount() + " Node(s))");
            }
            catch (NullPointerException nullPointerException) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)nullPointerException);
                db.println("NPE in add node");
            }
        }
    }

    private int getModelState(NetElement netElement) {
        IAlarmStore iAlarmStore;
        INodeModel iNodeModel = netElement.getNodeModel();
        if (iNodeModel == null || !((NodeModel)netElement.getNodeModel()).neTypeKnown()) {
            return 5;
        }
        if (iNodeModel.isInited() && iNodeModel.getConnectionState() && (iAlarmStore = iNodeModel.getElementAlarmStore()) != null) {
            return ExplorerController.getNodeState(iAlarmStore.getAlarmStatus());
        }
        return 4;
    }

    boolean isCardViewAvailable(int n) {
        boolean bl = false;
        switch (n) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 60: 
            case 62: 
            case 85: 
            case 97: 
            case 106: 
            case 143: 
            case 219: 
            case 220: 
            case 253: 
            case 254: {
                bl = true;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 37: 
            case 47: 
            case 57: 
            case 58: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 83: 
            case 86: 
            case 87: 
            case 102: 
            case 103: 
            case 108: 
            case 109: 
            case 113: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 145: 
            case 146: 
            case 157: 
            case 163: 
            case 164: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 196: 
            case 218: 
            case 221: 
            case 229: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 248: 
            case 249: 
            case 251: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 278: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 321: {
                bl = true;
            }
        }
        return bl;
    }

    public static int getNodeState(IAlarmStatus iAlarmStatus) {
        int n = 0;
        if (iAlarmStatus != null) {
            switch (iAlarmStatus.getHighestSeverity()) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                default: {
                    n = 4;
                }
            }
        }
        return n;
    }

    private void startObservingAlarmStore(NetElement netElement, ExplorerTreeNode explorerTreeNode) {
        block3: {
            try {
                IAlarmStore iAlarmStore;
                INodeModel iNodeModel = netElement.getNodeModel();
                if (iNodeModel.isInited() && (iAlarmStore = iNodeModel.getElementAlarmStore()) != null) {
                    iAlarmStore.addAlarmStatusObserver((Observer)explorerTreeNode);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)nullPointerException);
            }
        }
    }

    private void stopObservingAlarmStore(NetElement netElement, ExplorerTreeNode explorerTreeNode) {
        block3: {
            try {
                IAlarmStore iAlarmStore;
                INodeModel iNodeModel = netElement.getNodeModel();
                if (iNodeModel.isInited() && (iAlarmStore = iNodeModel.getElementAlarmStore()) != null) {
                    iAlarmStore.deleteAlarmStatusObserver((Observer)explorerTreeNode);
                    iAlarmStore = null;
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)nullPointerException);
            }
        }
    }

    public ImageIcon stateToIcon(NetElement netElement, int n) {
        try {
            IElementFactory iElementFactory = ElementFactoryFinder.getElementFactory(netElement.getNodeModel());
            Image[] imageArray = iElementFactory.getIconSet(netElement.getNodeModel());
            ImageIcon[] imageIconArray = new ImageIcon[imageArray.length];
            for (int i = 0; i < imageArray.length; ++i) {
                imageIconArray[i] = new ImageIcon(imageArray[i].getScaledInstance(20, 20, 1));
            }
            return imageIconArray[n];
        }
        catch (Exception exception) {
            return DISCONNECTED_ICON;
        }
    }

    public synchronized void changeNodeName(NetElement netElement, ExplorerTreeNode explorerTreeNode) {
        block4: {
            try {
                String string;
                String string2;
                if (netElement.getNodeModel().isInited() && !(string2 = explorerTreeNode.getName()).equals(string = netElement.getName())) {
                    db.fine("Change Node Name");
                    TreePath treePath = new TreePath(this.model.getPathToRoot(explorerTreeNode));
                    explorerTreeNode.setName(netElement.getName());
                    this.model.replaceNodeSorted((DefaultMutableTreeNode)explorerTreeNode.getParent(), explorerTreeNode);
                    if (explorerTreeNode.getChildCount() > 1) {
                        this.collapseNodes(explorerTreeNode);
                        explorerTreeNode.removeAllChildren();
                        this.model.reload(explorerTreeNode);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)nullPointerException);
                db.println("NullPointerException in change node name");
            }
        }
    }

    public synchronized void deleteNode(NetElement netElement, ExplorerTreeNode explorerTreeNode) {
        db.fine("Node is deleted");
        if (this.state != 5 && this.state != 4) {
            this.stopObservingAlarmStore(netElement, explorerTreeNode);
        }
        netElement.deleteObserver(explorerTreeNode);
        this.model.removeNodeFromParent(explorerTreeNode);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.model.getRoot();
        defaultMutableTreeNode.setUserObject("Network Explorer(" + defaultMutableTreeNode.getChildCount() + " Node(s))");
    }

    public synchronized void checkConnection(NetElement netElement, ExplorerTreeNode explorerTreeNode) {
        int n;
        int n2 = explorerTreeNode.getState();
        if (n2 != (n = this.getModelState(netElement))) {
            try {
                TreePath treePath = new TreePath(this.model.getPathToRoot(explorerTreeNode));
                if (n2 == 5 || n2 == 4) {
                    db.fine("Node UP");
                    explorerTreeNode.setState(n);
                    explorerTreeNode.setIcon();
                    this.model.valueForPathChanged(treePath, explorerTreeNode);
                    this.model.reload(explorerTreeNode);
                    this.startObservingAlarmStore(netElement, explorerTreeNode);
                } else if (n == 4) {
                    db.fine("Node Down");
                    explorerTreeNode.setState(n);
                    explorerTreeNode.removeAllChildren();
                    explorerTreeNode.setIcon();
                    this.model.valueForPathChanged(treePath, explorerTreeNode);
                    this.stopObservingAlarmStore(netElement, explorerTreeNode);
                } else {
                    db.fine("Check Connection");
                    explorerTreeNode.setState(n);
                    explorerTreeNode.setIcon();
                    this.model.valueForPathChanged(treePath, explorerTreeNode);
                    this.model.reload(explorerTreeNode);
                }
            }
            catch (NullPointerException nullPointerException) {
                db.println("checkConnection: caught exception");
                SDebug.printStackTrace((Throwable)nullPointerException);
            }
        }
    }

    public void nodeExpanded(TreePath treePath) {
        block15: {
            if (treePath.getPathCount() == 1) {
                db.fine("Root Expanded");
            } else {
                if (treePath.getLastPathComponent() instanceof ExplorerTreeNode) {
                    ExplorerTreeNode explorerTreeNode = (ExplorerTreeNode)treePath.getLastPathComponent();
                    if (!explorerTreeNode.getNe().isInited()) {
                        return;
                    }
                    if (explorerTreeNode.getChildCount() > 1) {
                        return;
                    }
                    try {
                        INodeModel iNodeModel = explorerTreeNode.getNe().getNodeModel();
                        IEntityModel[] iEntityModelArray = iNodeModel.getChassisModels();
                        if (iNodeModel.isMultishelf()) {
                            db.fine("A MS node is expanded");
                            this.populateShelvesForNode(iEntityModelArray, explorerTreeNode);
                            break block15;
                        }
                        db.fine("a non MS node is expanded");
                        IEntityModel iEntityModel = iEntityModelArray[0];
                        this.populateCardsForShelf(iEntityModel, explorerTreeNode);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
                        }
                        break block15;
                    }
                    catch (NullPointerException nullPointerException) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)nullPointerException);
                        }
                        break block15;
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)abstractCmsIOException);
                        }
                        break block15;
                    }
                }
                if (treePath.getLastPathComponent() instanceof ExplorerTreeShelf) {
                    db.fine("a shelf is expanded");
                    ExplorerTreeNode explorerTreeNode = (ExplorerTreeNode)treePath.getParentPath().getLastPathComponent();
                    ExplorerTreeShelf explorerTreeShelf = (ExplorerTreeShelf)treePath.getLastPathComponent();
                    if (explorerTreeShelf.getChildCount() > 1) {
                        return;
                    }
                    INodeModel iNodeModel = explorerTreeNode.getNe().getNodeModel();
                    IEntityModel[] iEntityModelArray = iNodeModel.getChassisModels();
                    String string = explorerTreeShelf.toString();
                    IEntityModel iEntityModel = explorerTreeShelf.entityModel;
                    this.populateCardsForShelf(iEntityModel, explorerTreeShelf);
                }
            }
        }
    }

    public boolean nodeSupportsMultiShelf(INodeModel iNodeModel) {
        return iNodeModel.provides(Feature.MULTISHELF);
    }

    public boolean isCardDeleted(IModuleModel iModuleModel) {
        return iModuleModel.getNodeModel().provides(Feature.NETWORK_EXPLORER) && iModuleModel.getCardState() == 6;
    }

    public void nodeCollapsed(TreePath treePath) {
        if (treePath.getPathCount() == 1) {
            db.fine("Root is collapsed");
        } else if (treePath.getLastPathComponent() instanceof ExplorerTreeNode) {
            db.fine("A Node is collapsed MS/Non MS");
            ExplorerTreeNode explorerTreeNode = (ExplorerTreeNode)treePath.getLastPathComponent();
            INodeModel iNodeModel = explorerTreeNode.getNe().getNodeModel();
            if (iNodeModel != null) {
                if (iNodeModel.isMultishelf()) {
                    this.collapseMSNodes(explorerTreeNode);
                } else {
                    this.collapseNodes(explorerTreeNode);
                }
                explorerTreeNode.removeAllChildren();
                this.model.reload(explorerTreeNode);
            }
        } else if (treePath.getLastPathComponent() instanceof ExplorerTreeShelf) {
            db.fine("A MS Node shelf is collapsed");
            ExplorerTreeNode explorerTreeNode = (ExplorerTreeNode)treePath.getParentPath().getLastPathComponent();
            ExplorerTreeShelf explorerTreeShelf = (ExplorerTreeShelf)treePath.getLastPathComponent();
            String string = explorerTreeShelf.toString();
            INodeModel iNodeModel = explorerTreeNode.getNe().getNodeModel();
            IEntityModel[] iEntityModelArray = iNodeModel.getChassisModels();
            this.collapseShelves(explorerTreeShelf, explorerTreeShelf.entityModel);
            explorerTreeShelf.removeAllChildren();
            this.model.reload(explorerTreeShelf);
        }
    }

    public void nodeDoubleClicked(int n, TreePath treePath) {
        block34: {
            Observer observer;
            Observer observer2;
            ViewName viewName;
            block33: {
                viewName = null;
                if (treePath.getPathCount() == 1) {
                    db.fine("Root is double clicked");
                    viewName = ViewName.ROOT_VIEW;
                } else {
                    int n2;
                    if (treePath.getLastPathComponent() instanceof ExplorerTreeNode) {
                        try {
                            observer2 = (ExplorerTreeNode)treePath.getLastPathComponent();
                            observer = ((ExplorerTreeNode)observer2).getNe().getNodeModel();
                            n2 = observer.getNodeId();
                            if (observer.isMultishelf()) {
                                db.fine("a MS node is double clicked");
                                viewName = new ViewName(new int[]{n2});
                                break block33;
                            }
                            int n3 = 0;
                            viewName = new ViewName(new int[]{n2, n3});
                            db.fine("a non MS node is double clicked" + viewName);
                        }
                        catch (NullPointerException nullPointerException) {
                            if (db.on()) {
                                SDebug.printStackTrace((Throwable)nullPointerException);
                            }
                            break block33;
                        }
                    }
                    if (treePath.getLastPathComponent() instanceof ExplorerTreeCard) {
                        try {
                            IEntityModel iEntityModel;
                            List list;
                            IEntityModel iEntityModel2;
                            List list2;
                            IModuleModel iModuleModel;
                            int n4;
                            Object object;
                            INodeModel iNodeModel;
                            Object object2;
                            observer2 = null;
                            observer = (ExplorerTreeCard)treePath.getLastPathComponent();
                            n2 = 0;
                            int n5 = 0;
                            IEntityModel iEntityModel3 = null;
                            if (treePath.getParentPath().getLastPathComponent() instanceof ExplorerTreeNode) {
                                db.fine("a card of non MS node is double clicked");
                                observer2 = (ExplorerTreeNode)treePath.getParentPath().getLastPathComponent();
                                n2 = 0;
                                n5 = 0;
                            } else if (treePath.getParentPath().getParentPath().getLastPathComponent() instanceof ExplorerTreeNode) {
                                db.fine("a card of MS node is double clicked");
                                observer2 = (ExplorerTreeNode)treePath.getParentPath().getParentPath().getLastPathComponent();
                                ExplorerTreeShelf explorerTreeShelf = (ExplorerTreeShelf)treePath.getParentPath().getLastPathComponent();
                                object2 = treePath.getParentPath().getLastPathComponent().toString();
                                iNodeModel = ((ExplorerTreeNode)observer2).getNe().getNodeModel();
                                IEntityModel[] iEntityModelArray = iNodeModel.getChassisModels();
                                object = ((String)object2).substring(5);
                                n5 = Integer.parseInt((String)object);
                                iEntityModel3 = explorerTreeShelf.entityModel;
                            }
                            int n6 = ((ExplorerTreeCard)observer).getEntityModel().getSlot();
                            object2 = ((ExplorerTreeNode)observer2).getNe().getNodeModel();
                            iNodeModel = object2.getChassisModels();
                            int n7 = object2.getNodeId();
                            if (iEntityModel3 == null) {
                                iEntityModel3 = iNodeModel[n2];
                            }
                            if (!this.isCardViewAvailable(n4 = (iModuleModel = (IModuleModel)(list2 = (iEntityModel2 = (IEntityModel)(list = (iEntityModel = (IEntityModel)(object = iEntityModel3.getChildren()).get(0)).getChildren()).get(n6 - 1)).getChildren()).get(0)).getEqType()) || this.isCardDeleted(iModuleModel)) {
                                return;
                            }
                            viewName = new ViewName(new int[]{n7, n5, n6});
                        }
                        catch (NullPointerException nullPointerException) {
                            if (db.on()) {
                                SDebug.printStackTrace((Throwable)nullPointerException);
                            }
                            break block33;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            if (db.on()) {
                                SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
                            }
                            break block33;
                        }
                        catch (ClassCastException classCastException) {
                            if (db.on()) {
                                SDebug.printStackTrace((Throwable)classCastException);
                            }
                            break block33;
                        }
                    }
                    if (treePath.getParentPath().getLastPathComponent() instanceof ExplorerTreeNode) {
                        db.fine("a MS shelf is double clicked");
                        try {
                            observer2 = (ExplorerTreeNode)treePath.getParentPath().getLastPathComponent();
                            observer = ((ExplorerTreeNode)observer2).getNe().getNodeModel();
                            n2 = observer.getNodeId();
                            int n8 = 0;
                            String string = treePath.getLastPathComponent().toString();
                            string = string.substring(5);
                            n8 = Integer.parseInt(string);
                            viewName = new ViewName(new int[]{n2, n8});
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            if (db.on()) {
                                SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
                            }
                            break block33;
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            if (db.on()) {
                                SDebug.printStackTrace((Throwable)stringIndexOutOfBoundsException);
                            }
                            break block33;
                        }
                        catch (NullPointerException nullPointerException) {
                            if (db.on()) {
                                SDebug.printStackTrace((Throwable)nullPointerException);
                            }
                            break block33;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (db.on()) {
                                SDebug.printStackTrace((Throwable)numberFormatException);
                            }
                            break block33;
                        }
                    }
                    return;
                }
            }
            observer2 = CtcApplication.instance().getMainPanel();
            observer = ((MainPanel)observer2).getNetworkViewController();
            try {
                if (viewName != null) {
                    observer.tryJumpView(viewName);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block34;
                db.println("Exception" + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    void populateCardsForShelf(IEntityModel iEntityModel, DefaultMutableTreeNode defaultMutableTreeNode) {
        block20: {
            try {
                int n;
                String string;
                Object object;
                int n2;
                boolean bl;
                List list = iEntityModel.getChildren();
                List list2 = null;
                boolean bl2 = bl = iEntityModel.getNodeModel().getNeType().indexOf("crs") != -1;
                if (!bl) {
                    IEntityModel iEntityModel2 = null;
                    iEntityModel2 = (IEntityModel)list.get(0);
                    list2 = iEntityModel2.getChildren();
                } else {
                    list2 = list;
                }
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    Object object2;
                    object = new IEntityModel[list2.size()];
                    string = "Empty";
                    object[n2] = (IEntityModel)list2.get(n2);
                    n = 0;
                    if (object[n2] == null) continue;
                    if (defaultMutableTreeNode instanceof ExplorerTreeNode) {
                        object[n2].addObserver((Observer)((ExplorerTreeNode)defaultMutableTreeNode));
                    } else if (defaultMutableTreeNode.getParent() instanceof ExplorerTreeNode) {
                        object[n2].addObserver((Observer)((ExplorerTreeNode)defaultMutableTreeNode.getParent()));
                    }
                    List list3 = object[n2].getChildren();
                    IModuleModel iModuleModel = null;
                    if (list3.size() > 0 && (object2 = list3.get(0)) instanceof IModuleModel && !this.isCardDeleted((IModuleModel)object2)) {
                        iModuleModel = (IModuleModel)object2;
                        string = iModuleModel.getEqLabel();
                        n = this.checkIsDoubleSlot(iModuleModel.getEqType()) ? 1 : 0;
                        if (string.startsWith("TCC")) {
                            string = this.nodeSupportsMultiShelf(iEntityModel.getNodeModel()) ? iEntityModel.getNodeModel().getMfgData(iEntityModel.getShelfId()).get(n2).toString() : iEntityModel.getNodeModel().getMfgData().get(n2).toString();
                            if (string.equalsIgnoreCase("")) {
                                string = iModuleModel.getEqLabel();
                            }
                        } else if (bl && string.equals("UNKNOWN")) continue;
                    }
                    if (!bl) {
                        string = n2 + 1 + " - " + string;
                        if (n != 0) {
                            ++n2;
                        }
                    } else {
                        string = new SlotId(object[n2].getEntityIndex()).toString() + " - " + string;
                    }
                    object2 = null;
                    object2 = new ExplorerTreeCard(string, (IEntityModel)iModuleModel, db);
                    this.model.insertNodeInto((MutableTreeNode)object2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    if (iModuleModel == null) continue;
                    iModuleModel.addObserver(object2);
                }
                n2 = this.model.getChildCount(defaultMutableTreeNode);
                object = null;
                string = null;
                for (n = 0; n < n2; ++n) {
                    object = (ExplorerTreeCard)this.model.getChild(defaultMutableTreeNode, n);
                    string = ((ExplorerTreeCard)object).getEntityModel();
                    if (string == null || !this.checkIsThreeSlot(string.getEqType())) continue;
                    this.model.removeNodeFromParent((MutableTreeNode)this.model.getChild(defaultMutableTreeNode, n - 1));
                    this.model.removeNodeFromParent((MutableTreeNode)this.model.getChild(defaultMutableTreeNode, n + 1));
                }
            }
            catch (NullPointerException nullPointerException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)nullPointerException);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
                }
            }
            catch (ClassCastException classCastException) {
                if (!db.on()) break block20;
                SDebug.printStackTrace((Throwable)classCastException);
            }
        }
    }

    boolean checkIsDoubleSlot(int n) {
        boolean bl = false;
        switch (n) {
            case 91: 
            case 131: 
            case 132: 
            case 191: 
            case 242: 
            case 263: 
            case 266: 
            case 267: 
            case 270: 
            case 272: 
            case 273: 
            case 287: 
            case 300: 
            case 301: 
            case 321: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    boolean checkIsThreeSlot(int n) {
        boolean bl = false;
        switch (n) {
            case 300: 
            case 301: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void addShelf(ExplorerTreeNode explorerTreeNode, IEntityModel iEntityModel, int n) {
        block4: {
            try {
                String string = "Shelf" + n;
                ExplorerTreeShelf explorerTreeShelf = new ExplorerTreeShelf(string, iEntityModel, db);
                INodeModel iNodeModel = explorerTreeNode.getNe().getNodeModel();
                IEntityModel[] iEntityModelArray = iNodeModel.getChassisModels();
                iEntityModel.addObserver((Observer)explorerTreeShelf);
                this.model.insertNodeSorted(explorerTreeNode, explorerTreeShelf);
            }
            catch (NullPointerException nullPointerException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)nullPointerException);
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
    }

    void populateShelvesForNode(IEntityModel[] iEntityModelArray, ExplorerTreeNode explorerTreeNode) {
        block6: {
            try {
                for (int i = 0; i < iEntityModelArray.length; ++i) {
                    int n = iEntityModelArray[i].getShelfId();
                    String string = "Shelf" + n;
                    ExplorerTreeShelf explorerTreeShelf = new ExplorerTreeShelf(string, iEntityModelArray[i], db);
                    iEntityModelArray[i].addObserver((Observer)explorerTreeShelf);
                    INodeModel iNodeModel = explorerTreeNode.getNe().getNodeModel();
                    if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.NETWORK_EXPLORER)) {
                        iNodeModel.getIChassisModelsInstance().addObserver((Observer)explorerTreeNode);
                    }
                    this.model.insertNodeSorted(explorerTreeNode, explorerTreeShelf);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)nullPointerException);
            }
        }
    }

    public void deleteShelf(IEntityModel iEntityModel, ExplorerTreeShelf explorerTreeShelf) {
        block4: {
            try {
                iEntityModel.deleteObserver((Observer)explorerTreeShelf);
                String string = explorerTreeShelf.toString();
                TreeNode treeNode = explorerTreeShelf.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
                ExplorerTreeNode explorerTreeNode = (ExplorerTreeNode)defaultMutableTreeNode.getUserObject();
                INodeModel iNodeModel = explorerTreeNode.getNe().getNodeModel();
                IEntityModel[] iEntityModelArray = iNodeModel.getChassisModels();
                this.collapseShelves(explorerTreeShelf, explorerTreeShelf.entityModel);
            }
            catch (NullPointerException nullPointerException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)nullPointerException);
                }
            }
            catch (ClassCastException classCastException) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)classCastException);
            }
        }
        this.model.removeNodeFromParent(explorerTreeShelf);
    }

    void collapseMSNodes(ExplorerTreeNode explorerTreeNode) {
        block9: {
            try {
                INodeModel iNodeModel = explorerTreeNode.getNe().getNodeModel();
                IEntityModel[] iEntityModelArray = iNodeModel.getChassisModels();
                for (int i = 0; i < iEntityModelArray.length; ++i) {
                    IEntityModel iEntityModel = iEntityModelArray[i];
                    int n = iEntityModel.getShelfId();
                    int n2 = this.getShelfIndexfromNode(n, explorerTreeNode);
                    ExplorerTreeShelf explorerTreeShelf = null;
                    explorerTreeShelf = (ExplorerTreeShelf)explorerTreeNode.getChildAt(n2);
                    iEntityModel.deleteObserver((Observer)explorerTreeShelf);
                    if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.NETWORK_EXPLORER)) {
                        iNodeModel.getIChassisModelsInstance().deleteObserver((Observer)explorerTreeNode);
                    }
                    List list = iEntityModel.getChildren();
                    IEntityModel iEntityModel2 = null;
                    iEntityModel2 = (IEntityModel)list.get(0);
                    List list2 = null;
                    list2 = iEntityModel2.getChildren();
                    int n3 = list2.size();
                    int n4 = explorerTreeShelf.getChildCount();
                    for (int j = 0; j < n4; ++j) {
                        IEntityModel iEntityModel3 = (IEntityModel)list2.get(j);
                        iEntityModel3.deleteObserver((Observer)explorerTreeNode);
                        if (iEntityModel3.getChildren().size() <= 0) continue;
                        ExplorerTreeCard explorerTreeCard = null;
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)explorerTreeShelf.getChildAt(j);
                        explorerTreeCard = (ExplorerTreeCard)defaultMutableTreeNode.getUserObject();
                        IModuleModel iModuleModel = (IModuleModel)iEntityModel3.getChildren().get(0);
                        if (iModuleModel == null) continue;
                        iModuleModel.deleteObserver((Observer)explorerTreeCard);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)nullPointerException);
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!db.on()) break block9;
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
    }

    void collapseNodes(ExplorerTreeNode explorerTreeNode) {
        block7: {
            try {
                INodeModel iNodeModel = explorerTreeNode.getNe().getNodeModel();
                IEntityModel[] iEntityModelArray = iNodeModel.getChassisModels();
                IEntityModel iEntityModel = iEntityModelArray[0];
                List list = iEntityModel.getChildren();
                List list2 = null;
                if (iEntityModel.getNodeModel().getNeType().indexOf("crs") == -1) {
                    IEntityModel iEntityModel2 = (IEntityModel)list.get(0);
                    list2 = iEntityModel2.getChildren();
                } else {
                    list2 = list;
                }
                int n = list2.size();
                for (int i = 0; i < n; ++i) {
                    IEntityModel iEntityModel3 = (IEntityModel)list2.get(i);
                    iEntityModel3.deleteObserver((Observer)explorerTreeNode);
                    if (iEntityModel3.getChildren().size() <= 0) continue;
                    ExplorerTreeCard explorerTreeCard = null;
                    TreeNode treeNode = explorerTreeNode.getChildAt(i);
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
                    explorerTreeCard = (ExplorerTreeCard)defaultMutableTreeNode.getUserObject();
                    IModuleModel iModuleModel = (IModuleModel)iEntityModel3.getChildren().get(0);
                    iModuleModel.deleteObserver((Observer)explorerTreeCard);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)nullPointerException);
            }
        }
    }

    void collapseShelves(DefaultMutableTreeNode defaultMutableTreeNode, IEntityModel iEntityModel) {
        block9: {
            try {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                ExplorerTreeNode explorerTreeNode = (ExplorerTreeNode)defaultMutableTreeNode2.getUserObject();
                INodeModel iNodeModel = explorerTreeNode.getNe().getNodeModel();
                IEntityModel iEntityModel2 = iEntityModel;
                List list = iEntityModel2.getChildren();
                IEntityModel iEntityModel3 = null;
                iEntityModel3 = (IEntityModel)list.get(0);
                List list2 = null;
                list2 = iEntityModel3.getChildren();
                int n = list2.size();
                for (int i = 0; i < n; ++i) {
                    IEntityModel iEntityModel4 = (IEntityModel)list2.get(i);
                    iEntityModel4.deleteObserver((Observer)explorerTreeNode);
                    if (iEntityModel4.getChildren().size() <= 0) continue;
                    IModuleModel iModuleModel = (IModuleModel)iEntityModel4.getChildren().get(0);
                    TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)treeNode;
                    ExplorerTreeCard explorerTreeCard = (ExplorerTreeCard)defaultMutableTreeNode3.getUserObject();
                    iModuleModel.deleteObserver((Observer)explorerTreeCard);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)nullPointerException);
                }
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!db.on()) break block9;
                SDebug.printStackTrace((Throwable)indexOutOfBoundsException);
            }
        }
    }

    void startObservingCardAlarm(IEntityModel iEntityModel, ExplorerTreeCard explorerTreeCard) {
        block3: {
            try {
                INodeModel iNodeModel = iEntityModel.getNodeModel();
                if (iNodeModel.isInited() && iEntityModel instanceof IModuleModel && iEntityModel.getParent() != null) {
                    IAlarmStore iAlarmStore = iNodeModel.getElementAlarmStore();
                    ICardAlarmStore iCardAlarmStore = null;
                    iCardAlarmStore = !this.nodeSupportsMultiShelf(iEntityModel.getNodeModel()) ? iAlarmStore.getCardAlarmStore(iEntityModel.getShelfId(), iEntityModel.getSlot()) : iAlarmStore.getCardAlarmStore(iEntityModel.getSlot());
                    iCardAlarmStore.addAlarmStatusObserver((Observer)explorerTreeCard);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    void stopObservingCardAlarm(IEntityModel iEntityModel, ExplorerTreeCard explorerTreeCard) {
        block4: {
            try {
                INodeModel iNodeModel = iEntityModel.getNodeModel();
                if (iNodeModel.isInited()) {
                    IAlarmStore iAlarmStore = iNodeModel.getElementAlarmStore();
                    ICardAlarmStore iCardAlarmStore = null;
                    iCardAlarmStore = !this.nodeSupportsMultiShelf(iEntityModel.getNodeModel()) ? iAlarmStore.getCardAlarmStore(iEntityModel.getShelfId(), iEntityModel.getSlot()) : iAlarmStore.getCardAlarmStore(iEntityModel.getSlot());
                    if (iCardAlarmStore != null) {
                        iCardAlarmStore.deleteAlarmStatusObserver((Observer)explorerTreeCard);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public synchronized void refreshCard(ExplorerTreeCard explorerTreeCard) {
        TreePath treePath = new TreePath(this.model.getPathToRoot(explorerTreeCard));
        if (explorerTreeCard.getParent() != null) {
            this.model.valueForPathChanged(treePath, explorerTreeCard);
            this.model.reload(explorerTreeCard.getParent());
        }
    }

    public String getProxyStatus(NetElement netElement) {
        return ProxyConfigHelper.proxyToString(ProxyConfigHelper.getProxyConfig(netElement));
    }

    public String getToolTip(NetElement netElement) {
        INodeModel iNodeModel = netElement.getNodeModel();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(iNodeModel.getName() + ":");
        try {
            if (iNodeModel.getNodeType() == 2 || iNodeModel.getNodeType() == 1) {
                stringBuffer.append(INodeType.NODE_OPT_TYPES[iNodeModel.getNodeOpticalType()] + ":");
            }
        }
        catch (Exception exception) {
            db.severe("Caught " + exception + ", please check that INodeType.NODE_OPT_TYPES is up-to-date.");
        }
        if (iNodeModel != null && iNodeModel.isInited() && iNodeModel.getConnectionState()) {
            IAlarmStore iAlarmStore = iNodeModel.getElementAlarmStore();
            IAlarmStatus iAlarmStatus = null;
            if (iAlarmStore != null) {
                iAlarmStatus = iAlarmStore.getAlarmStatus();
                stringBuffer.append("CR: " + iAlarmStatus.critical() + ", MJ: " + iAlarmStatus.major() + ", MN: " + iAlarmStatus.minor());
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public synchronized ImageIcon setCardIcon(IEntityModel iEntityModel, ExplorerTreeCard explorerTreeCard) {
        ImageIcon imageIcon;
        block8: {
            int n;
            block7: {
                n = -1;
                imageIcon = this.getIconOfCard(n);
                try {
                    if (iEntityModel == null || !(iEntityModel instanceof IModuleModel)) {
                        return imageIcon;
                    }
                    if (iEntityModel.getEqType() == 329 && iEntityModel instanceof IModuleModel) {
                        n = 8;
                        imageIcon = this.getIconOfCard(n);
                        return imageIcon;
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block7;
                    db.println("Caught " + exception + " in setCardIcon1");
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            try {
                if (iEntityModel.getNodeModel().isInited()) {
                    IAlarmStore iAlarmStore = iEntityModel.getNodeModel().getElementAlarmStore();
                    ICardAlarmStore iCardAlarmStore = null;
                    iCardAlarmStore = !this.nodeSupportsMultiShelf(iEntityModel.getNodeModel()) ? iAlarmStore.getCardAlarmStore(iEntityModel.getShelfId(), iEntityModel.getSlot()) : iAlarmStore.getCardAlarmStore(iEntityModel.getSlot());
                    IAlarmStatus iAlarmStatus = iCardAlarmStore.getAlarmStatus();
                    explorerTreeCard.tooltip = "CR " + iAlarmStatus.critical() + ", MJ " + iAlarmStatus.major() + ", MN " + iAlarmStatus.minor();
                    imageIcon = this.getCardAlarmIcon(iAlarmStatus, imageIcon, n);
                }
            }
            catch (Exception exception) {
                db.println("Caught " + exception + " in setCardIcon2");
                if (!db.on()) break block8;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return imageIcon;
    }

    public ImageIcon getIconOfCard(int n) {
        ImageIcon imageIcon;
        switch (n) {
            case 4: 
            case 5: {
                imageIcon = DEFAULT_CARD_ICON;
                break;
            }
            case 7: 
            case 9: {
                imageIcon = CRITICAL_CARD_ICON;
                break;
            }
            case 8: {
                imageIcon = PROVISION_CARD_ICON;
                break;
            }
            case 6: {
                imageIcon = DELETED_CARD_ICON;
                break;
            }
            case 10: {
                imageIcon = MAJOR_CARD_ICON;
                break;
            }
            case 11: {
                imageIcon = MINOR_CARD_ICON;
                break;
            }
            case 12: {
                imageIcon = OOS_MT_CARD_ICON;
                break;
            }
            default: {
                imageIcon = PROVISION_CARD_ICON;
            }
        }
        return imageIcon;
    }

    public ImageIcon getCardAlarmIcon(IAlarmStatus iAlarmStatus, ImageIcon imageIcon, int n) {
        ImageIcon imageIcon2 = imageIcon;
        if (iAlarmStatus != null) {
            if (iAlarmStatus.getHighestSeverity() == 0) {
                imageIcon2 = n == 0 || n == 1 ? PROVISION_CARD_ICON : DEFAULT_CARD_ICON;
            } else if (iAlarmStatus.critical() > 0) {
                imageIcon2 = CRITICAL_CARD_ICON;
            } else if (iAlarmStatus.major() > 0) {
                imageIcon2 = MAJOR_CARD_ICON;
            } else if (iAlarmStatus.minor() > 0) {
                imageIcon2 = MINOR_CARD_ICON;
            }
        }
        return imageIcon2;
    }

    public ArrayList getClientsForNE(INodeModel iNodeModel) {
        ArrayList<InetAddress> arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        block5: {
            arrayList3 = null;
            arrayList2 = new ArrayList();
            arrayList = new ArrayList<InetAddress>();
            try {
                String string = iNodeModel.isSecureMode() ? InetUtil.makeDottedString(iNodeModel.getSecureIpConfig().getIpAddress()) : InetUtil.makeDottedString(iNodeModel.getIpConfig().getIpAddress());
                arrayList3 = (ArrayList)CtcProxyFactory.getClients((String)string);
            }
            catch (IOException iOException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)iOException);
                    db.println("Error while fetching clients for the GNE");
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                SDebug.printStackTrace((Throwable)exception);
                db.println("Error while fetching clients for the GNE");
            }
        }
        for (Object e : arrayList3) {
            Object var7_9 = null;
            if (!(e instanceof SckfwdClient) || arrayList.contains(((SckfwdClient)e).getHost())) continue;
            arrayList.add(((SckfwdClient)e).getHost());
            arrayList2.add(e);
        }
        return arrayList2;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof Network.NetElementCreationNotifier) {
            NetElement netElement = (NetElement)object;
            this.addNode(netElement);
        }
    }
}

