/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.ui.Wavelength;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OpticalChannelAttr
implements ActionListener {
    public static final int OCHNC_MODE = 1;
    public static final int OCH_TRAIL_MODE = 2;
    public Attribute[] bandsAttributes = new Attribute[]{new Attribute("C Band", 0), new Attribute("L Band", 1)};
    public Attribute[] oddsAttributes = new Attribute[]{new Attribute("Odd", 0), new Attribute("Even", 1)};
    public Attribute[] channelAttrs = null;
    protected int mode = -1;
    protected JPanel p;
    protected JLabel label;
    protected UComboBox channelsCB;
    protected UComboBox bandsCB;
    protected UComboBox oddityCB;

    public OpticalChannelAttr(int n) {
        this.commonInit();
        this.setMode(n);
    }

    public void setEnabled(boolean bl) {
        this.label.setEnabled(bl);
        this.channelsCB.setEnabled(bl);
        this.bandsCB.setEnabled(bl);
        this.oddityCB.setEnabled(bl);
    }

    public JPanel getUI() {
        return this.p;
    }

    public void setMode(int n) {
        if (n != this.mode && (n == 1 || n == 2)) {
            this.mode = n;
            switch (n) {
                case 1: {
                    break;
                }
                case 2: {
                    this.initOchTrail();
                }
            }
            this.updateChannels();
        }
    }

    public int getChannel() {
        Attribute attribute = (Attribute)this.channelsCB.getSelectedItem();
        if (attribute != null) {
            return attribute.getIntValue();
        }
        return -1;
    }

    public String toString() {
        return "OCHNC Wavelength: " + Wavelength.getWavelengthStringFromWavelength(this.getChannel());
    }

    protected void commonInit() {
        this.p = new JPanel();
        this.p.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.label = new JLabel("OCHNC Wavelength: ");
        this.p.add((Component)this.label, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.channelsCB = new UComboBox((Object[])this.getAttributes(0, 0));
        this.p.add((Component)this.channelsCB, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        this.bandsCB = new UComboBox((Object[])this.bandsAttributes);
        this.p.add((Component)this.bandsCB, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.oddityCB = new UComboBox((Object[])this.oddsAttributes);
        this.p.add((Component)this.oddityCB, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        this.p.add((Component)new JPanel(), gridBagConstraints);
        this.bandsCB.addActionListener((ActionListener)this);
        this.oddityCB.addActionListener((ActionListener)this);
    }

    protected void initOchnc() {
        this.oddityCB.setSelectedIndex(0);
        this.oddityCB.setVisible(false);
    }

    protected void initOchTrail() {
        this.oddityCB.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bandsCB) {
            switch (this.mode) {
                case 1: {
                    this.updateChannels();
                    break;
                }
                case 2: {
                    this.updateChannels();
                }
            }
        } else if (actionEvent.getSource() == this.oddityCB) {
            switch (this.mode) {
                case 1: 
                case 2: {
                    this.updateChannels();
                }
            }
        }
    }

    int getBand() {
        Attribute attribute = (Attribute)this.bandsCB.getSelectedItem();
        return attribute.getIntValue();
    }

    int getOddity() {
        Attribute attribute = (Attribute)this.oddityCB.getSelectedItem();
        return attribute.getIntValue();
    }

    protected Attribute[] getAttributes(int n, int n2) {
        switch (this.mode) {
            case 1: {
                return Wavelength.getWavelengthAttrs(n, n2, false);
            }
            case 2: {
                return Wavelength.getWavelengthAttrs(n, n2, false);
            }
        }
        return Wavelength.getOchncCWavelengthAttrs(40);
    }

    private void updateChannels() {
        Attribute[] attributeArray = this.getAttributes(this.getBand(), this.getOddity());
        if (this.channelAttrs == null || !this.areEquals(this.channelAttrs, attributeArray)) {
            this.channelAttrs = attributeArray;
            Attribute attribute = (Attribute)this.channelsCB.getSelectedItem();
            DefaultComboBoxModel<Attribute> defaultComboBoxModel = new DefaultComboBoxModel<Attribute>(attributeArray);
            this.channelsCB.setModel(defaultComboBoxModel);
            if (defaultComboBoxModel.getIndexOf(attribute) != -1) {
                defaultComboBoxModel.setSelectedItem(attribute);
            }
        }
    }

    private boolean areEquals(Attribute[] attributeArray, Attribute[] attributeArray2) {
        boolean bl = true;
        if (attributeArray.length == attributeArray2.length) {
            for (int i = 0; bl && i < attributeArray.length; ++i) {
                Attribute attribute = attributeArray[i];
                Attribute attribute2 = attributeArray2[i];
                bl = attribute.equals(attribute2);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        Attribute[] attributeArray = Wavelength.getDwdmWavelengthAttrs();
        for (int i = 0; i < attributeArray.length; ++i) {
            System.out.println(attributeArray[i]);
        }
        JFrame jFrame = new JFrame();
        final OpticalChannelAttr opticalChannelAttr = new OpticalChannelAttr(1);
        jFrame.setSize(400, 300);
        jFrame.setDefaultCloseOperation(3);
        final JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"OCHNC", "OCHTRAIL"});
        jFrame.getContentPane().add(jComboBox, "North");
        jFrame.getContentPane().add((Component)opticalChannelAttr.getUI(), "Center");
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jComboBox.getSelectedIndex();
                switch (n) {
                    case 0: {
                        opticalChannelAttr.setMode(1);
                        break;
                    }
                    case 1: {
                        opticalChannelAttr.setMode(2);
                    }
                }
            }
        });
        jFrame.setVisible(true);
    }
}

