/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.PrefsStringArrayPropertyPane;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.AbstractPropertyPane;
import cerent.util.gui.AbstractPropertySheet;
import cerent.util.gui.CerentDialog;
import com.cisco.ctc.CtcApplication;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PrefsNodesPropertyPane
extends AbstractPropertyPane
implements ActionListener {
    public static final String DEF_TOPO_HOSTS = "Topology Hosts";
    private static final String PATH = "ctc.nodes";
    public static final String MEMBERS = ".members";
    private static final String TOPO_HOSTS_PATH = "ctc";
    private static final String TOPO_HOSTS_KEY = "topology.hosts";
    private static final String CUR_LOGIN = " (current login node group)";
    private static Preferences prefs = Preferences.instance();
    private JTabbedPane tp = new JTabbedPane();
    private TreeMap map = new TreeMap();
    private JButton createPB;
    private JButton deletePB;
    private JButton renamePB;
    private static final SDebug db = new SDebug("PrefsNodePropertyPane");

    public PrefsNodesPropertyPane(String string, AbstractPropertySheet abstractPropertySheet) {
        super(string, abstractPropertySheet);
        this.setLayout(new BorderLayout());
        this.add(this.tp);
        this.createPB = new JButton("Create Group");
        this.deletePB = new JButton("Delete Group");
        this.renamePB = new JButton("Rename Group");
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.createPB);
        jPanel.add(this.deletePB);
        jPanel.add(this.renamePB);
        this.createPB.addActionListener(this);
        this.deletePB.addActionListener(this);
        this.renamePB.addActionListener(this);
        this.add((Component)jPanel, "North");
        this.load();
    }

    public void store() {
        prefs.removeAllProperties(PATH, "");
        int n = 0;
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = Integer.toString(n);
            String string2 = (String)iterator.next();
            PrefsStringArrayPropertyPane prefsStringArrayPropertyPane = (PrefsStringArrayPropertyPane)this.map.get(string2);
            int n2 = string2.indexOf(CUR_LOGIN);
            if (n2 > 0) {
                string2 = string2.substring(0, n2);
            }
            prefs.setProperty(PATH, string, string2);
            prefsStringArrayPropertyPane.setDirty(true);
            prefsStringArrayPropertyPane.store(PATH, string + MEMBERS);
            if (string2.equals(DEF_TOPO_HOSTS)) {
                prefsStringArrayPropertyPane.store(TOPO_HOSTS_PATH, TOPO_HOSTS_KEY);
            }
            ++n;
        }
        try {
            prefs.store();
        }
        catch (FileNotFoundException fileNotFoundException) {
            SDebug.printStackTrace((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            SDebug.printStackTrace((Throwable)iOException);
        }
    }

    public void load() {
        String string3;
        this.removePropertyChangeListener(this);
        this.tp.removeAll();
        this.map.clear();
        String string2 = null;
        int n = 0;
        while ((string3 = prefs.getProperty(PATH, string2 = Integer.toString(n), null)) != null) {
            PrefsStringArrayPropertyPane prefsStringArrayPropertyPane = this.createPane(string3);
            prefsStringArrayPropertyPane.load(PATH, string2 + MEMBERS);
            ++n;
        }
        for (String string3 : this.map.keySet()) {
            this.tp.add(string3, (PrefsStringArrayPropertyPane)this.map.get(string3));
        }
        this.notifyAllPropertyEditors(this);
        this.syncPB();
    }

    private void syncPB() {
        boolean bl = this.map.size() > 0;
        this.deletePB.setEnabled(bl);
        this.renamePB.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        Object var3_3 = null;
        if (actionEvent.getSource() == this.createPB) {
            Object object = CerentDialog.inputDialog((Component)this, (String)"Enter New Login Group Name", (String)"Create New Login Group", null, (Object)"");
            if (object != null) {
                String string = this.getUniqueGroup(object.toString());
                PrefsStringArrayPropertyPane prefsStringArrayPropertyPane = this.createPane(string);
                this.removePropertyChangeListener(this);
                this.insertPane(prefsStringArrayPropertyPane);
                this.notifyAllPropertyEditors(this);
                prefsStringArrayPropertyPane.setDirty(true);
            }
        } else if (actionEvent.getSource() == this.deletePB) {
            PrefsStringArrayPropertyPane prefsStringArrayPropertyPane = (PrefsStringArrayPropertyPane)this.tp.getSelectedComponent();
            String string = prefsStringArrayPropertyPane.getName();
            this.map.remove(string);
            prefsStringArrayPropertyPane.setDirty(true);
            this.removePropertyChangeListener(this);
            this.tp.remove(prefsStringArrayPropertyPane);
            this.notifyAllPropertyEditors(this);
        } else if (actionEvent.getSource() == this.renamePB) {
            PrefsStringArrayPropertyPane prefsStringArrayPropertyPane = (PrefsStringArrayPropertyPane)this.tp.getSelectedComponent();
            String string = prefsStringArrayPropertyPane.getName();
            Object object = CerentDialog.inputDialog((Component)this, (String)"Enter New Login Group Name", (String)("Create New Login Group For " + string), null, (Object)string);
            if (object != null) {
                this.map.remove(string);
                this.tp.remove(prefsStringArrayPropertyPane);
                String string2 = this.getUniqueGroup(object.toString());
                this.map.put(string2, prefsStringArrayPropertyPane);
                prefsStringArrayPropertyPane.setName(string2);
                this.insertPane(prefsStringArrayPropertyPane);
                prefsStringArrayPropertyPane.setVisible(true);
                prefsStringArrayPropertyPane.setDirty(true);
            }
        }
        this.syncPB();
    }

    private void insertPane(PrefsStringArrayPropertyPane prefsStringArrayPropertyPane) {
        String string = prefsStringArrayPropertyPane.getName();
        this.map.put(string, prefsStringArrayPropertyPane);
        int n = 0;
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            if (string == iterator.next()) {
                this.tp.insertTab(string, null, prefsStringArrayPropertyPane, null, n);
                this.tp.setSelectedComponent(prefsStringArrayPropertyPane);
                break;
            }
            ++n;
        }
    }

    private PrefsStringArrayPropertyPane createPane(String string) {
        PrefsStringArrayPropertyPane prefsStringArrayPropertyPane = new PrefsStringArrayPropertyPane(string, (AbstractPropertySheet)this.parent, prefs);
        if (string.equals(CtcApplication.instance().getAdditionalNodeGroup())) {
            string = string + CUR_LOGIN;
        }
        prefsStringArrayPropertyPane.setName(string);
        this.map.put(string, prefsStringArrayPropertyPane);
        return prefsStringArrayPropertyPane;
    }

    private String getUniqueGroup(String string) {
        Set set = this.map.keySet();
        String string2 = string;
        int n = 0;
        while (this.map.get(string2) != null) {
            string2 = string + "-" + n;
            ++n;
        }
        return string2;
    }

    public static Set getGroupNames() {
        String string;
        TreeSet<String> treeSet = new TreeSet<String>();
        String string2 = null;
        int n = 0;
        while ((string = prefs.getProperty(PATH, string2 = Integer.toString(n), null)) != null) {
            treeSet.add(string);
            ++n;
        }
        if (treeSet.isEmpty()) {
            try {
                String[] stringArray = prefs.getPropertyArray(TOPO_HOSTS_PATH, TOPO_HOSTS_KEY, null);
                if (stringArray != null) {
                    prefs.setProperty(PATH, "0", DEF_TOPO_HOSTS);
                    prefs.setPropertyArray(PATH, "0.members", stringArray);
                    treeSet.add(DEF_TOPO_HOSTS);
                }
            }
            catch (Exception exception) {
                db.finer("Exception in getGroupNames() " + exception);
            }
        }
        return treeSet;
    }

    public static String[] getGroupMembers(String string) {
        String string2;
        String string3 = null;
        int n = 0;
        while ((string2 = prefs.getProperty(PATH, string3 = Integer.toString(n), null)) != null) {
            if (string2.equals(string)) {
                try {
                    return prefs.getPropertyArray(PATH, string3 + MEMBERS, null);
                }
                catch (Exception exception) {
                    break;
                }
            }
            ++n;
        }
        return new String[0];
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.PrefsNodesPropertyPane;
    }
}

