/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.AbstractPrefsPropertyPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.AbstractPropertySheet;
import cerent.util.gui.BooleanPropertyEditor;
import cerent.util.gui.PasswordPropertyEditor;
import cerent.util.gui.StringPropertyEditor;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PrefsRouterPropertyPane
extends AbstractPrefsPropertyPane {
    private static final SDebug db = new SDebug("PrefsRouterPropertyPane");
    private AbstractPropertySheet parentSheet;
    private StringPropertyEditor userFld = null;
    private JPasswordField passFld = null;
    private PasswordPropertyEditor confirmFld = null;
    private BooleanPropertyEditor skipLmpConfigChb = null;
    private DocumentListener pwdListen = new DocumentListener(){

        public void changedUpdate(DocumentEvent documentEvent) {
            PrefsRouterPropertyPane.this.confirmFld.setValue("");
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            PrefsRouterPropertyPane.this.confirmFld.setValue("");
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            PrefsRouterPropertyPane.this.confirmFld.setValue("");
        }
    };

    public PrefsRouterPropertyPane(String string, AbstractPropertySheet abstractPropertySheet, Preferences preferences) {
        super(string, abstractPropertySheet, preferences);
        this.parentSheet = abstractPropertySheet;
        try {
            this.initialize();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    protected boolean onValidate(Container container) {
        if (((String)this.userFld.getValue()).length() > 0 != this.passFld.getPassword().length > 0) {
            JOptionPane.showMessageDialog(this, "In order to set a different login for routers, both username and password must be specified");
            return false;
        }
        if (!Arrays.equals(this.passFld.getPassword(), this.confirmFld.getFieldText())) {
            JOptionPane.showMessageDialog(this, "The two passwords do not match.");
            this.passFld.setText("");
            this.confirmFld.setValue("");
            return false;
        }
        return true;
    }

    public void store() {
        if (((String)this.userFld.getValue()).length() > 0) {
            this.prefs.setBoolean("ctc.router", "useRouterLogin", true);
            this.confirmFld.setEncryptionKey((String)this.userFld.getValue());
            this.store("ctc.router", "username", this.userFld);
            this.store("ctc.router", "password", this.confirmFld);
        } else {
            this.prefs.removeProperty("ctc.router", "username");
            this.prefs.firePropertyChange("username");
            this.prefs.removeProperty("ctc.router", "password");
            this.prefs.firePropertyChange("password");
            this.prefs.setBoolean("ctc.router", "useRouterLogin", false);
            this.prefs.firePropertyChange("useRouterLogin");
        }
        this.store("ctc.router", "skipLmp", this.skipLmpConfigChb);
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.PrefsRouterPropertyPane;
    }

    public void load() {
        this.load("ctc.router", "skipLmp", this.skipLmpConfigChb);
        this.load("ctc.router", "username", this.userFld);
        if (((String)this.userFld.getValue()).length() > 0) {
            this.confirmFld.setEncryptionKey((String)this.userFld.getValue());
            this.load("ctc.router", "password", this.confirmFld);
            this.passFld.getDocument().removeDocumentListener(this.pwdListen);
            this.passFld.setText(new String(this.confirmFld.getFieldText()));
            this.passFld.getDocument().addDocumentListener(this.pwdListen);
        } else {
            this.passFld.setText("");
            this.confirmFld.setValue("");
        }
    }

    private void initialize() throws Exception {
        this.setLayout(null);
        this.skipLmpConfigChb = new BooleanPropertyEditor("Skip automatic LMP configuration on routers");
        this.skipLmpConfigChb.setLocation(15, 15);
        this.skipLmpConfigChb.setSize(370, 20);
        this.add(this.skipLmpConfigChb);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setSize(370, 100);
        jPanel.setBorder(BorderFactory.createTitledBorder("Router login (leave blank to use default CTC login)"));
        JLabel jLabel = new JLabel("Username:");
        JLabel jLabel2 = new JLabel("Password:");
        JLabel jLabel3 = new JLabel("Confirm password:");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        this.userFld = new StringPropertyEditor("");
        this.passFld = new JPasswordField();
        this.passFld.getDocument().addDocumentListener(this.pwdListen);
        this.confirmFld = new PasswordPropertyEditor("");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.userFld, gridBagConstraints);
        gridBagLayout.setConstraints(this.passFld, gridBagConstraints);
        gridBagLayout.setConstraints(this.confirmFld, gridBagConstraints);
        jPanel.add(jLabel);
        jPanel.add(this.userFld);
        jPanel.add(jLabel2);
        jPanel.add(this.passFld);
        jPanel.add(jLabel3);
        jPanel.add(this.confirmFld);
        jPanel.setLocation(15, 50);
        this.add(jPanel);
        this.load();
        this.notifyAllPropertyEditors(this);
        this.parentSheet.resetApply();
    }
}

