/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IActiveUserInfoModel;
import cerent.cms.model.IModel;
import cerent.cms.model.NetSecurityModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractDataSourceControl;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.SecurityActiveDataSource;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.UserLogoutDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.NEMC;
import cerent.util.ObservableManager;
import cerent.util.gui.TextAreaDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class SecurityActivePane
extends ObserverPane
implements Observer {
    private static final String LOGOUT = "Logout...";
    private static final String RETRIEVE_TIME = "Retrieve Last Activity Time";
    private JButton logoutButton;
    private JButton retrieveB;
    private JLabel retrieveLB;
    private Frame parentFrame;
    private String dlgTitle;
    private String dlgErrMsg;
    private JPanel buttonRow;
    private UScrollPane userSP;
    private NodeModel cmsHost = (NodeModel)NetworkModel.instance().getCmsHostModel();
    private UserInfo _dsc;

    public SecurityActivePane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, tabbedView);
        this._dsc = new UserInfo(iModel);
        this.setDataSourceControl(this._dsc);
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.destroy();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.getTable(), this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.leavingPage();
    }

    private void setTable(JTable jTable) {
        this.table = jTable;
    }

    public void update(Observable observable, Object object) {
        this.requestRefresh(observable, null);
    }

    private void displayStatusMessage(String string, String string2) {
        this.parentFrame = JOptionPane.getFrameForComponent((Component)((Object)this));
        this.dlgTitle = string;
        this.dlgErrMsg = string2;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new TextAreaDialog(SecurityActivePane.this.parentFrame, SecurityActivePane.this.dlgTitle, SecurityActivePane.this.dlgErrMsg, 350, 200);
            }
        });
    }

    private void logoutUser() {
        SecurityActiveDataSource.ActiveUserInfo[] activeUserInfoArray = this._dsc.getSelectedRows();
        if (activeUserInfoArray.length == 0) {
            return;
        }
        for (int i = 0; i < activeUserInfoArray.length; ++i) {
            if (this.cmsHost.getSecurityLevel() == SecurityLevel.SUPERUSER || this.cmsHost.getUserName().equals(activeUserInfoArray[i].getUserName())) continue;
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ONLY_LOGOUT_YOUR_OWN_ACCOUNT);
            return;
        }
        UserLogoutDialog userLogoutDialog = UserLogoutDialog.instance(this, activeUserInfoArray);
        userLogoutDialog.show();
        if (userLogoutDialog.ok()) {
            boolean bl = false;
            if (userLogoutDialog.getLockBeforeLogout()) {
                bl = true;
            }
            this.logoutUserSessions(activeUserInfoArray, bl);
        }
    }

    private void logoutUserSessions(SecurityActiveDataSource.ActiveUserInfo[] activeUserInfoArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        NetSecurityModel netSecurityModel = NetSecurityModel.instance();
        for (int i = 0; i < activeUserInfoArray.length; ++i) {
            SecurityActiveDataSource.ActiveUserInfo activeUserInfo = activeUserInfoArray[i];
            IActiveUserInfoModel iActiveUserInfoModel = activeUserInfo.getModel();
            Map map = netSecurityModel.logout(iActiveUserInfoModel, bl, activeUserInfo.getNodes());
            if (map.size() <= 0) continue;
            if (stringBuffer.length() == 0) {
                stringBuffer.append("Logouts:\n");
            }
            NetSecurityModel.formatFailedMap(stringBuffer, map);
        }
        if (stringBuffer.length() > 0) {
            this.displayStatusMessage("Logout Results", stringBuffer.toString());
        }
    }

    private void manageButtons() {
        this.logoutButton.setEnabled(this.isUserAuthorized() && this._dsc.isRowSelected());
    }

    private class UserInfo
    extends AbstractDataSourceControl {
        private IModel _model;
        private NetSecurityModel _secuModel;
        private ObservableManager _om;
        private SecurityActiveDataSource _ds;
        private SortableRowTableModel _tm;
        private Thread _updater;
        private boolean _needsUpdate;

        UserInfo(IModel iModel) {
            this._model = iModel;
            this._secuModel = null;
            this._om = new ObservableManager(SecurityActivePane.this, true);
            this._ds = null;
            this._tm = null;
            this._updater = null;
            this._needsUpdate = false;
        }

        public SecurityActiveDataSource getDataSource() {
            return this._ds;
        }

        private synchronized boolean needsUpdate() {
            if (this._needsUpdate) {
                if (AbstractPane.db.on()) {
                    AbstractPane.db.println("updater starting update");
                }
                this._needsUpdate = false;
                return true;
            }
            return false;
        }

        private void doUpdate() {
            try {
                this._ds.refreshFromModel(this._tm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public synchronized void refreshFromModel() throws Exception {
            if (AbstractPane.db.on()) {
                AbstractPane.db.println("refreshFromModel()");
            }
            this._needsUpdate = true;
            if (this._updater == null) {
                this._updater = new Thread(new Runnable(){

                    public void run() {
                        SecurityActivePane.this.uiToolkit.setSBText("Loading active users...");
                        while (UserInfo.this.needsUpdate()) {
                            UserInfo.this.doUpdate();
                        }
                        UserInfo.this._updater = null;
                        SecurityActivePane.this.uiToolkit.setSBText("");
                        if (AbstractPane.db.on()) {
                            AbstractPane.db.println("updater done");
                        }
                    }
                });
                if (AbstractPane.db.on()) {
                    AbstractPane.db.println("updater created");
                }
                this._updater.start();
            }
        }

        public void refreshFromModel(int n) throws Exception {
            if (n == -1) {
                this.initUi();
            }
            this.refreshFromModel();
        }

        public void applyToModel() {
        }

        public IObservableManager getObservableManager() {
            return this._om;
        }

        public void disposeDataSource() {
            this._om.removeObservable((Observable)((Object)this._secuModel));
        }

        boolean isRowSelected() {
            return SecurityActivePane.this.getTable().getSelectedRows().length > 0;
        }

        SecurityActiveDataSource.ActiveUserInfo[] getSelectedRows() {
            int[] nArray = SecurityActivePane.this.getTable().getSelectedRows();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < 0 || nArray[i] >= SecurityActivePane.this.table.getRowCount()) continue;
                arrayList.add(this._tm.getValueAt(nArray[i], 0));
            }
            return arrayList.toArray(new SecurityActiveDataSource.ActiveUserInfo[0]);
        }

        boolean nodeDoesNotSupportGetUsers() {
            return this._ds.nodeDoesNotSupportGetUsers();
        }

        UScrollPane initTable() {
            this._secuModel = NetSecurityModel.instance();
            this._om.addObservable((Observable)((Object)this._secuModel));
            this._ds = new SecurityActiveDataSource(this._model);
            this._tm = new SortableRowTableModel((RowDataSource)this._ds, this._ds.getRenderers(), this._ds.getRowObjectClass());
            SecurityActivePane.this.setTable((JTable)new UTable((TableModel)((Object)this._tm)));
            this._tm.initTable(SecurityActivePane.this.getTable());
            ListSelectionModel listSelectionModel = SecurityActivePane.this.getTable().getSelectionModel();
            listSelectionModel.setSelectionMode(2);
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        SecurityActivePane.this.manageButtons();
                    }
                }
            });
            return new UScrollPane((Component)SecurityActivePane.this.getTable());
        }

        void initUi() {
            SecurityActivePane.this.setLayout(new BorderLayout());
            SecurityActivePane.this.buttonRow = AbstractPane.createHorizontalPanel(null);
            SecurityActivePane.this.buttonRow.setLayout(new BorderLayout());
            SecurityActivePane.this.userSP = this.initTable();
            SecurityActivePane.this.logoutButton = new JButton(SecurityActivePane.LOGOUT);
            SecurityActivePane.this.logoutButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SecurityActivePane.this.logoutUser();
                }
            });
            SecurityActivePane.this.retrieveB = new JButton(SecurityActivePane.RETRIEVE_TIME);
            SecurityActivePane.this.retrieveB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    block3: {
                        try {
                            UserInfo.this.refreshFromModel();
                        }
                        catch (Exception exception) {
                            if (!AbstractPane.db.on()) break block3;
                            AbstractPane.db.println("update error: " + exception);
                        }
                    }
                    if (SecurityActivePane.this.retrieveLB != null) {
                        SecurityActivePane.this.retrieveLB.setText("Refreshed: " + AbstractPane.getFormattedDateTime(new Date()));
                    }
                }
            });
            SecurityActivePane.this.manageButtons();
            JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
            SecurityActivePane.this.retrieveLB = new JLabel("Refreshed: " + AbstractPane.getFormattedDateTime(new Date()));
            jPanel.add(SecurityActivePane.this.logoutButton);
            jPanel.add(SecurityActivePane.this.retrieveB);
            jPanel.add(SecurityActivePane.this.retrieveLB);
            jPanel2.add(new CSHelpButton(NetCSHelpConst.SecurityActivePane));
            SecurityActivePane.this.buttonRow.add((Component)jPanel, "Center");
            SecurityActivePane.this.buttonRow.add((Component)jPanel2, "East");
            SecurityActivePane.this.add((Component)SecurityActivePane.this.userSP, "Center");
            SecurityActivePane.this.add(SecurityActivePane.this.buttonRow, "South");
        }
    }
}

