/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Feature;
import cerent.cms.model.IModel;
import cerent.cms.model.ISecurityPolicy;
import cerent.cms.model.NetSecurityModel;
import cerent.cms.model.NodeModel;
import cerent.cms.ui.AbstractDataSourceControl;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.SecurityPolicyDataSource;
import cerent.cms.ui.SecurityPolicyEditDialog;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.gui.TextAreaDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class SecurityPolicyPane
extends ObserverPane
implements Observer {
    private static final String EDIT = "Edit...";
    private JButton changeButton;
    private Frame parentFrame;
    private String dlgTitle;
    private String dlgErrMsg;
    private JPanel buttonRow;
    private UScrollPane policySP;
    private SecurityPolicyControl _dsc;

    public SecurityPolicyPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, tabbedView);
        this._dsc = new SecurityPolicyControl(iModel);
        this.setDataSourceControl(this._dsc);
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.destroy();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.getTable(), this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.leavingPage();
    }

    private void setTable(JTable jTable) {
        this.table = jTable;
    }

    public void update(Observable observable, Object object) {
        this.requestRefresh(observable, null);
    }

    private void displayStatusMessage(String string, String string2) {
        this.parentFrame = JOptionPane.getFrameForComponent((Component)((Object)this));
        this.dlgTitle = string;
        this.dlgErrMsg = string2;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new TextAreaDialog(SecurityPolicyPane.this.parentFrame, SecurityPolicyPane.this.dlgTitle, SecurityPolicyPane.this.dlgErrMsg, 600, 250);
            }
        });
    }

    private void changeSecurityPolicy() {
        Map map;
        String string;
        SecurityPolicyEditDialog securityPolicyEditDialog = SecurityPolicyEditDialog.instance(this, this._dsc.getNodes(), this._dsc.getSelected().getSecurityPolicy(), this.getSelectedNode());
        securityPolicyEditDialog.show();
        if (!securityPolicyEditDialog.ok() || securityPolicyEditDialog.ok() && !securityPolicyEditDialog.isDirty()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        List list = securityPolicyEditDialog.getSelectedList();
        ISecurityPolicy iSecurityPolicy = securityPolicyEditDialog.getSecurityPolicy();
        if ((iSecurityPolicy.getForcePasswordChange() || iSecurityPolicy.getPasswordFlippingPolicyEnabled() || iSecurityPolicy.isPasswordExprPolicyEnabled() || iSecurityPolicy.getDisableInactiveUserPolicyEnabled()) && (string = this.getFeatureNotSupportedNodes(list, Feature.SEC_PASSWD_AGING)).length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append(" - do not support the following operations.\n");
            stringBuffer.append("  - Force Password Change\n");
            stringBuffer.append("  - Minimum Days Before Password Change\n");
            stringBuffer.append("  - Password Aging\n");
            stringBuffer.append("  - Disable Inactive User\n");
            stringBuffer.append("\n");
        }
        if ((string = this.getFeatureNotSupportedNodes(list, Feature.SECURITY_VERSIONING)).length() > 0 && securityPolicyEditDialog.isMinChangedCharsInPwdDirty()) {
            stringBuffer.append(string);
            stringBuffer.append(" - do not support the following operation.\n");
            stringBuffer.append("  - Minimum Password Difference\n");
            stringBuffer.append("\n");
        }
        if ((map = NetSecurityModel.instance().setSecurityPolicy(iSecurityPolicy, list)).size() != 0) {
            stringBuffer.append("Security Policy Change:\n");
            NetSecurityModel.formatFailedMap(stringBuffer, map);
        }
        if (stringBuffer.length() > 0) {
            this.displayStatusMessage("Security Policy Change Results", stringBuffer.toString());
        }
    }

    private NodeModel getSelectedNode() {
        NodeModel nodeModel = null;
        List list = this._dsc.getNodes();
        for (NodeModel nodeModel2 : list) {
            if (nodeModel2.getName() != this._dsc.getSelected().getValueAt(0)) continue;
            nodeModel = nodeModel2;
        }
        return nodeModel;
    }

    private String getFeatureNotSupportedNodes(List list, Feature feature) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (NodeModel nodeModel : list) {
            if (nodeModel.provides(feature)) continue;
            if (bl) {
                stringBuffer.append(nodeModel.getName());
                bl = false;
                continue;
            }
            stringBuffer.append(", ").append(nodeModel.getName());
        }
        return stringBuffer.toString();
    }

    private void manageButtons() {
        this.changeButton.setEnabled(this.isUserAuthorized() && this._dsc.getSelected() != null);
    }

    private class SecurityPolicyControl
    extends AbstractDataSourceControl {
        private IModel _model;
        private NetSecurityModel _secuModel;
        private ObservableManager _om;
        private SecurityPolicyDataSource _ds;
        private SortableRowTableModel _tm;
        private Thread _updater;
        private boolean _needsUpdate;

        SecurityPolicyControl(IModel iModel) {
            this._model = iModel;
            this._secuModel = null;
            this._om = new ObservableManager(SecurityPolicyPane.this, true);
            this._ds = null;
            this._tm = null;
            this._updater = null;
            this._needsUpdate = false;
        }

        private synchronized boolean needsUpdate() {
            if (this._needsUpdate) {
                if (AbstractPane.db.on()) {
                    AbstractPane.db.println("updater starting update");
                }
                this._needsUpdate = false;
                return true;
            }
            return false;
        }

        private void doUpdate() {
            try {
                this._ds.refreshFromModel(this._tm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public synchronized void refreshFromModel() throws Exception {
            if (AbstractPane.db.on()) {
                AbstractPane.db.println("refreshFromModel()");
            }
            this._needsUpdate = true;
            if (this._updater == null) {
                this._updater = new Thread(new Runnable(){

                    public void run() {
                        SecurityPolicyPane.this.uiToolkit.setSBText("Loading policies...");
                        while (SecurityPolicyControl.this.needsUpdate()) {
                            SecurityPolicyControl.this.doUpdate();
                        }
                        SecurityPolicyControl.this._updater = null;
                        SecurityPolicyPane.this.uiToolkit.setSBText("");
                        if (AbstractPane.db.on()) {
                            AbstractPane.db.println("updater done");
                        }
                    }
                });
                if (AbstractPane.db.on()) {
                    AbstractPane.db.println("updater created");
                }
                this._updater.start();
            }
        }

        public void refreshFromModel(int n) throws Exception {
            if (n == -1) {
                this.initUi();
            }
            this.refreshFromModel();
        }

        public void applyToModel() {
        }

        public IObservableManager getObservableManager() {
            return this._om;
        }

        public void disposeDataSource() {
            this._om.removeObservable((Observable)((Object)this._secuModel));
        }

        SecurityPolicyDataSource.PolicyInfo getSelected() {
            JTable jTable = SecurityPolicyPane.this.getTable();
            int n = jTable.getSelectedRow();
            if (n >= 0 && n < jTable.getRowCount()) {
                return (SecurityPolicyDataSource.PolicyInfo)this._tm.getValueAt(n, 0);
            }
            return null;
        }

        List getNodes() {
            return this._ds.getNodes();
        }

        UScrollPane initTable() {
            this._secuModel = NetSecurityModel.instance();
            this._om.addObservable((Observable)((Object)this._secuModel));
            this._ds = new SecurityPolicyDataSource(this._model);
            this._tm = new SortableRowTableModel((RowDataSource)this._ds, this._ds.getRenderers(), this._ds.getRowObjectClass());
            SecurityPolicyPane.this.setTable((JTable)new UTable((TableModel)((Object)this._tm)));
            this._tm.initTable(SecurityPolicyPane.this.getTable());
            ListSelectionModel listSelectionModel = SecurityPolicyPane.this.getTable().getSelectionModel();
            listSelectionModel.setSelectionMode(0);
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        SecurityPolicyPane.this.manageButtons();
                    }
                }
            });
            return new UScrollPane((Component)SecurityPolicyPane.this.getTable());
        }

        void initUi() {
            SecurityPolicyPane.this.setLayout(new BorderLayout());
            SecurityPolicyPane.this.buttonRow = AbstractPane.createHorizontalPanel(null);
            SecurityPolicyPane.this.buttonRow.setLayout(new BorderLayout());
            SecurityPolicyPane.this.policySP = this.initTable();
            SecurityPolicyPane.this.changeButton = new JButton(SecurityPolicyPane.EDIT);
            SecurityPolicyPane.this.changeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SecurityPolicyPane.this.changeSecurityPolicy();
                }
            });
            SecurityPolicyPane.this.manageButtons();
            JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
            jPanel.add(SecurityPolicyPane.this.changeButton);
            jPanel2.add(new CSHelpButton(NetCSHelpConst.SecurityPolicyPane));
            SecurityPolicyPane.this.buttonRow.add((Component)jPanel, "Center");
            SecurityPolicyPane.this.buttonRow.add((Component)jPanel2, "East");
            SecurityPolicyPane.this.add((Component)SecurityPolicyPane.this.policySP, "Center");
            SecurityPolicyPane.this.add(SecurityPolicyPane.this.buttonRow, "South");
        }
    }
}

