/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.topo.Network;
import cerent.cms.topo.ServerTrailPrefs;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.ServerTrailDialog;
import cerent.cms.ui.WizardPane;
import cerent.util.gui.DigitTextField;
import cerent.util.gui.UComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StAttrPane
extends WizardPane {
    private ServerTrailDialog parent;
    private boolean inited = false;
    protected UComboBox typeCB;
    protected UComboBox sizeCB;
    protected UComboBox protectionCB;
    protected DigitTextField numberOfTrailsTF;
    protected JTextField srlgIdTF;

    public StAttrPane(String string, ServerTrailDialog serverTrailDialog) {
        super(string, serverTrailDialog);
        this.parent = serverTrailDialog;
    }

    public void enteringPage() throws Exception {
        if (!this.inited) {
            this.initPane();
            this.inited = true;
        }
    }

    protected void initPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(new JLabel("Type:"));
        this.typeCB = new UComboBox(new DefaultComboBoxModel<ICircuitType>(this.getCircuitTypes()));
        jPanel3.add((Component)this.typeCB);
        this.typeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ICircuitType iCircuitType = (ICircuitType)StAttrPane.this.typeCB.getSelectedItem();
                StAttrPane.this.sizeCB.setModel(new DefaultComboBoxModel<ICircuitSize>(StAttrPane.this.getCircuitSizes(iCircuitType)));
            }
        });
        ICircuitType iCircuitType = (ICircuitType)this.typeCB.getSelectedItem();
        jPanel2.add(new JLabel("Size:"));
        this.sizeCB = new UComboBox(new DefaultComboBoxModel<ICircuitSize>(this.getCircuitSizes(iCircuitType)));
        jPanel3.add((Component)this.sizeCB);
        jPanel2.add(new JLabel("Protection Type:"));
        this.protectionCB = new UComboBox(new DefaultComboBoxModel<Attribute>(this.getProtectionTypes()));
        jPanel3.add((Component)this.protectionCB);
        jPanel2.add(new JLabel("Number of Trails:"));
        this.numberOfTrailsTF = new DigitTextField(4);
        this.numberOfTrailsTF.setText("1");
        jPanel3.add(this.numberOfTrailsTF);
        jPanel2.add(new JLabel("SRLG (optional):"));
        this.srlgIdTF = new JTextField(10);
        jPanel3.add(this.srlgIdTF);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        this.add(jPanel);
    }

    protected String getStatusText() {
        ICircuitType iCircuitType = (ICircuitType)this.typeCB.getSelectedItem();
        ICircuitSize iCircuitSize = (ICircuitSize)this.sizeCB.getSelectedItem();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Type: " + iCircuitType.getProtocolIndepCktTypeStr());
        stringBuffer.append("\nSize: " + iCircuitSize.getCircuitSizeString());
        Attribute attribute = (Attribute)this.protectionCB.getSelectedItem();
        stringBuffer.append("\nProtection Type: " + attribute);
        stringBuffer.append("\nNumber of Trails:  " + this.parent.stPrefs.getNx());
        stringBuffer.append("\nSRLG:  " + this.parent.stPrefs.getSrlg());
        return stringBuffer.toString();
    }

    public void refresh() {
    }

    public void validatePage() throws Exception {
        ICircuitType iCircuitType = (ICircuitType)this.typeCB.getSelectedItem();
        ICircuitSize iCircuitSize = (ICircuitSize)this.sizeCB.getSelectedItem();
        int n = 1;
        int n2 = ((Attribute)this.protectionCB.getSelectedItem()).getIntValue();
        int n3 = Integer.parseInt(this.numberOfTrailsTF.getText());
        String string = this.srlgIdTF.getText();
        if (n3 < 1) {
            throw new Exception("The number of server trails must be a positive integer.");
        }
        this.parent.circuitType = iCircuitType;
        this.parent.circuitSize = iCircuitSize;
        if (this.parent.circuitInfo == null) {
            this.parent.circuitInfo = new CircuitCreatInfo(iCircuitType.getEnum(), iCircuitSize.getEnum(), n);
        } else {
            this.parent.circuitInfo.setType(iCircuitType.getEnum());
            this.parent.circuitInfo.setSize(iCircuitSize.getEnum());
            this.parent.circuitInfo.setDir(n);
        }
        if (this.parent.stPrefs == null) {
            this.parent.stPrefs = new ServerTrailPrefs();
        }
        this.parent.stPrefs.setCircuitType(iCircuitType);
        this.parent.stPrefs.setCircuitSize(iCircuitSize);
        if (iCircuitType.isLoCircuitType()) {
            this.parent.stPrefs.setLoTrail();
        } else {
            this.parent.stPrefs.resetLoTrail();
        }
        this.parent.stPrefs.setProtectionType(n2);
        this.parent.stPrefs.setNx(n3);
        this.parent.stPrefs.setSrlg(string);
    }

    private ICircuitType[] getCircuitTypes() {
        HashSet<ICircuitType> hashSet = new HashSet<ICircuitType>();
        FramingType[] framingTypeArray = Network.instance().getSupportedFramingTypes();
        for (int i = 0; i < framingTypeArray.length; ++i) {
            FramingType framingType = framingTypeArray[i];
            hashSet.add(CircuitType.getCircuitType((int)framingType.getHoCircuitType()));
            hashSet.add(CircuitType.getCircuitType((int)framingType.getLoCircuitType()));
        }
        return hashSet.toArray(new ICircuitType[0]);
    }

    private ICircuitSize[] getCircuitSizes(ICircuitType iCircuitType) {
        FramingType[] framingTypeArray = Network.instance().getSupportedFramingTypes();
        Object[] objectArray = CircuitSize.getCircuitSizes((int)iCircuitType.getEnum(), (FramingType[])framingTypeArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private Attribute[] getProtectionTypes() {
        Attribute[] attributeArray = new Attribute[]{new Attribute("FULLY PROTECTED", new Integer(2)), new Attribute("UNPROTECTED", new Integer(1)), new Attribute("PREEMPTIBLE", new Integer(0))};
        return attributeArray;
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.StAttrPane;
    }
}

