/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.ui.Wavelength;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class WLenSelectorPopup
extends JDialog
implements TreeSelectionListener,
DocumentListener,
ActionListener {
    private JPanel jPanel = null;
    private JPanel northJPane = null;
    private JPanel centerJPane = null;
    private JScrollPane jScrollPane = null;
    private JPanel jPanelFilter = null;
    private JLabel jLabelFilterByValue = null;
    private JTextField jTextFieldLambda = null;
    private Document lambdaDocument = null;
    private JTree jTree = null;
    private JButton jButtonReset = null;
    private JPanel jPanelTreeManager = null;
    private JPanel jPanelOkButton = null;
    private JButton jButtonOK = null;
    private JButton jButtonCancel = null;
    private JPanel jPanelSelectedValue = null;
    private JPanel jPanelBottom = null;
    private JLabel jLabelSelectedValue2 = null;
    private JLabel jLabelSelectedValue = null;
    private DefaultMutableTreeNode rootNode = null;
    public static DefaultWLDialogValue lambdaDialogValue = null;
    private TreeCellRenderer treeCellRenderer = null;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode matchingNode;
    private static final SDebug db = new SDebug("WLenSelectorPopup");

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent();
        Attribute attribute = null;
        String string = "";
        boolean bl = false;
        if (defaultMutableTreeNode != null) {
            Object object = defaultMutableTreeNode.getUserObject();
            if (defaultMutableTreeNode.isLeaf() && object instanceof Attribute) {
                attribute = (Attribute)object;
                string = attribute.toString();
                bl = true;
            }
        }
        lambdaDialogValue.setValue(attribute);
        this.jLabelSelectedValue2.setText(string);
        this.jButtonOK.setEnabled(bl);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (WLenSelectorPopup.db.on) {
            db.println("Something has been changed.");
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (WLenSelectorPopup.db.on) {
            db.println("Something has been inserted.");
        }
        this.jTextFieldLambdaChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (WLenSelectorPopup.db.on) {
            db.println("Something has been removed.");
        }
        this.jTextFieldLambdaChanged();
    }

    public void jTextFieldLambdaChanged() {
        String string = this.jTextFieldLambda.getText();
        if (WLenSelectorPopup.db.on) {
            db.println("New filter value = \"" + string + "\"");
        }
        this.jLabelSelectedValue2.setText("");
        this.fillTree(string, null);
        if (WLenSelectorPopup.db.on) {
            db.println("Tree rebuilt on \"" + string + "\" filter match.");
        }
    }

    public void expandAll() {
        int n;
        if (WLenSelectorPopup.db.on) {
            db.print("Preparing to expand jTree ");
        }
        for (n = 0; n < this.jTree.getRowCount(); ++n) {
            this.jTree.expandRow(n);
            if (!WLenSelectorPopup.db.on) continue;
            db.print(".");
        }
        if (WLenSelectorPopup.db.on) {
            db.println(" done (" + n + " rows).");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.getClass().getName() == "javax.swing.JButton") {
            if ((JButton)object == this.jButtonReset) {
                if (WLenSelectorPopup.db.on) {
                    db.println("Reset button pressed");
                }
                this.jTextFieldLambda.setText("");
            } else if ((JButton)object == this.jButtonOK) {
                if (WLenSelectorPopup.db.on) {
                    db.println("OK button pressed");
                }
                this.valueAndCloseDialog();
            } else if ((JButton)object == this.jButtonCancel) {
                if (WLenSelectorPopup.db.on) {
                    db.println("Cancel button pressed");
                }
                this.closeDialog();
            }
        }
    }

    public WLenSelectorPopup(Frame frame, IWLDialogValue iWLDialogValue) {
        super(frame, "Wavelength Selector", true);
        lambdaDialogValue = (DefaultWLDialogValue)iWLDialogValue;
        this.initialize();
        this.setLocationRelativeTo(frame);
    }

    public void start() {
        this.fillTree(null, lambdaDialogValue.getValue().toString());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                WLenSelectorPopup.this.closeDialog();
            }
        });
    }

    private void initialize() {
        this.jLabelFilterByValue = new JLabel();
        this.jLabelFilterByValue.setText("Filter by Value:");
        this.jTextFieldLambda = new JTextField();
        this.jTextFieldLambda.setText("");
        this.jTextFieldLambda.setPreferredSize(new Dimension(80, 20));
        this.lambdaDocument = this.jTextFieldLambda.getDocument();
        this.lambdaDocument.addDocumentListener(this);
        this.jButtonReset = new JButton();
        this.jButtonReset.setText("Reset");
        this.jButtonReset.setToolTipText("Reload all wlens and collapse all tree nodes");
        this.jButtonReset.addActionListener(this);
        this.jPanelFilter = new JPanel();
        this.jPanelFilter.add((Component)this.jLabelFilterByValue, null);
        this.jPanelFilter.add((Component)this.jTextFieldLambda, null);
        this.jPanelFilter.add((Component)this.jButtonReset, null);
        JLabel jLabel = new JLabel();
        jLabel.setText("");
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        this.jPanelTreeManager = new JPanel();
        this.jPanelTreeManager.setLayout(new BorderLayout());
        this.jPanelTreeManager.add((Component)jPanel, "West");
        this.jButtonCancel = new JButton();
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(this);
        this.jButtonOK = new JButton();
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(this);
        this.jPanelOkButton = new JPanel();
        this.jPanelOkButton.add((Component)this.jButtonOK, null);
        this.jPanelOkButton.add((Component)this.jButtonCancel, null);
        this.jLabelSelectedValue = new JLabel();
        this.jLabelSelectedValue.setText("Selected Value:");
        this.jLabelSelectedValue2 = new JLabel();
        this.jLabelSelectedValue2.setText("");
        this.jLabelSelectedValue2.setPreferredSize(new Dimension(80, 20));
        this.jPanelSelectedValue = new JPanel();
        this.jPanelSelectedValue.add((Component)this.jLabelSelectedValue, null);
        this.jPanelSelectedValue.add((Component)this.jLabelSelectedValue2, null);
        this.jPanelBottom = new JPanel();
        this.jPanelBottom.setLayout(new BorderLayout());
        this.jPanelBottom.add((Component)this.jPanelSelectedValue, "West");
        this.jPanelBottom.add((Component)this.jPanelOkButton, "East");
        this.rootNode = new DefaultMutableTreeNode("Wavelengths");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.jTree = new JTree(this.treeModel);
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.treeCellRenderer = new TreeCellRenderer();
        this.jTree.setCellRenderer(this.treeCellRenderer);
        this.jTree.addTreeSelectionListener(this);
        this.jTree.setShowsRootHandles(true);
        this.jTree.putClientProperty("JTree.lineStyle", "Angled");
        this.setSize(new Dimension(559, 303));
        this.setContentPane(this.getJPanel());
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getnorthJPane(), "North");
            this.jPanel.add((Component)this.getcenterJPane(), "Center");
        }
        return this.jPanel;
    }

    private JPanel getnorthJPane() {
        if (this.northJPane == null) {
            this.northJPane = new JPanel();
            this.northJPane.setLayout(new BorderLayout());
            this.northJPane.add((Component)this.jPanelFilter, "Center");
        }
        return this.northJPane;
    }

    private JPanel getcenterJPane() {
        if (this.centerJPane == null) {
            this.centerJPane = new JPanel();
            this.centerJPane.setLayout(new BorderLayout());
            this.centerJPane.add((Component)this.getJScrollPane(), "Center");
            this.centerJPane.add((Component)this.jPanelTreeManager, "North");
            this.centerJPane.add((Component)this.jPanelBottom, "South");
        }
        return this.centerJPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.jTree);
        }
        return this.jScrollPane;
    }

    public void collapseAll() {
        if (WLenSelectorPopup.db.on) {
            db.print("Preparing to collapse jTree");
        }
        this.jTree.collapseRow(0);
        if (WLenSelectorPopup.db.on) {
            db.println(" . done.");
        }
    }

    private void closeDialog() {
        lambdaDialogValue.setValue(null);
        this.dispose();
    }

    private void valueAndCloseDialog() {
        this.dispose();
    }

    private void fillTree(String string, String string2) {
        this.matchingNode = null;
        this.rootNode = new DefaultMutableTreeNode("Wavelengths");
        if ((string == null || string.length() == 0) && lambdaDialogValue.getPossibleChoices().getFirstTunable()) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(Wavelength.getFirstTunableWLAttr());
            this.rootNode.add(defaultMutableTreeNode);
            if (WLenSelectorPopup.db.on) {
                db.println("First tunable value added.");
            }
            if (string2 != null && string2.equals(Wavelength.getFirstTunableWLAttr().toString())) {
                this.matchingNode = defaultMutableTreeNode;
            }
        }
        int n = 0;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("C Band");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Even");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Odd");
        this.branchCreation(defaultMutableTreeNode2, string, lambdaDialogValue.getPossibleChoices().getCbandEven(), string2);
        if (!defaultMutableTreeNode2.isLeaf()) {
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            n += defaultMutableTreeNode2.getChildCount();
        }
        this.branchCreation(defaultMutableTreeNode3, string, lambdaDialogValue.getPossibleChoices().getCbandOdd(), string2);
        if (!defaultMutableTreeNode3.isLeaf()) {
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            n += defaultMutableTreeNode3.getChildCount();
        }
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("L Band");
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Even");
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("Odd");
        this.branchCreation(defaultMutableTreeNode5, string, lambdaDialogValue.getPossibleChoices().getLbandEven(), string2);
        if (!defaultMutableTreeNode5.isLeaf()) {
            defaultMutableTreeNode4.add(defaultMutableTreeNode5);
            n += defaultMutableTreeNode5.getChildCount();
        }
        this.branchCreation(defaultMutableTreeNode6, string, lambdaDialogValue.getPossibleChoices().getLbandOdd(), string2);
        if (!defaultMutableTreeNode6.isLeaf()) {
            defaultMutableTreeNode4.add(defaultMutableTreeNode6);
            n += defaultMutableTreeNode6.getChildCount();
        }
        if (n == 0) {
            this.treeModel.setRoot(null);
            this.jTree.setVisible(false);
        } else {
            if (!defaultMutableTreeNode.isLeaf()) {
                this.rootNode.add(defaultMutableTreeNode);
            }
            if (!defaultMutableTreeNode4.isLeaf()) {
                this.rootNode.add(defaultMutableTreeNode4);
            }
            this.treeModel.setRoot(this.rootNode);
            if (string == null || string.length() == 0) {
                this.jTree.expandPath(new TreePath(this.rootNode.getPath()));
                this.jTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
                this.jTree.expandPath(new TreePath(defaultMutableTreeNode4.getPath()));
            } else {
                this.expandAll();
            }
            this.jTree.setVisible(true);
            if (this.matchingNode == null && n == 1) {
                this.matchingNode = (DefaultMutableTreeNode)this.rootNode.getChildAt(0).getChildAt(0).getChildAt(0);
            }
            if (this.matchingNode != null) {
                TreePath treePath = new TreePath(this.matchingNode.getPath());
                this.jTree.setSelectionPath(treePath);
                this.jTree.scrollPathToVisible(treePath);
            }
        }
    }

    private void branchCreation(DefaultMutableTreeNode defaultMutableTreeNode, String string, Attribute[] attributeArray, String string2) {
        if (WLenSelectorPopup.db.on) {
            db.println("Branch under \"" + defaultMutableTreeNode.getUserObject() + "\" is being created.");
        }
        if (attributeArray != null && attributeArray.length != 0) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            for (int i = 0; i < attributeArray.length; ++i) {
                Attribute attribute = attributeArray[i];
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(attribute);
                if (string == null) {
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                } else if (defaultMutableTreeNode2.toString().startsWith(string)) {
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                if (string2 == null || !attribute.toString().equals(string2)) continue;
                this.matchingNode = defaultMutableTreeNode2;
            }
        }
    }

    public class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(WLenSelectorPopup.this.jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            this.setBackgroundNonSelectionColor(null);
            if (!(defaultMutableTreeNode.getUserObject() instanceof Attribute)) {
                return this;
            }
            this.setIcon(null);
            Attribute attribute = (Attribute)defaultMutableTreeNode.getUserObject();
            boolean bl5 = false;
            Attribute[] attributeArray = lambdaDialogValue.getPossibleChoices().getTunableWavelength();
            if (attributeArray != null) {
                for (int i = 0; i < attributeArray.length; ++i) {
                    if (attributeArray[i] == null || attribute.getIntValue() != attributeArray[i].getIntValue()) continue;
                    bl5 = true;
                    break;
                }
            }
            if (bl5) {
                this.setText(this.getText() + "**");
                if (!bl) {
                    this.setBackgroundNonSelectionColor(WLenSelectorPopup.this.northJPane.getBackground());
                }
            }
            return this;
        }
    }

    public static class WavelengthSets {
        private Attribute[] cbandEven = null;
        private Attribute[] cbandOdd = null;
        private Attribute[] lbandEven = null;
        private Attribute[] lbandOdd = null;
        private boolean firstTunable = false;
        private Attribute[] tunableWavelength = null;

        public WavelengthSets(Attribute[] attributeArray, Attribute[] attributeArray2, Attribute[] attributeArray3, Attribute[] attributeArray4, boolean bl, Attribute[] attributeArray5) {
            this.cbandEven = attributeArray;
            this.cbandOdd = attributeArray2;
            this.lbandEven = attributeArray3;
            this.lbandOdd = attributeArray4;
            this.firstTunable = bl;
            this.tunableWavelength = attributeArray5;
        }

        public boolean getFirstTunable() {
            return this.firstTunable;
        }

        public Attribute[] getTunableWavelength() {
            return this.tunableWavelength;
        }

        public Attribute[] getCbandEven() {
            return this.cbandEven;
        }

        public Attribute[] getCbandOdd() {
            return this.cbandOdd;
        }

        public Attribute[] getLbandEven() {
            return this.lbandEven;
        }

        public Attribute[] getLbandOdd() {
            return this.lbandOdd;
        }
    }

    public static class DefaultWLDialogValue
    implements IWLDialogValue {
        private Attribute currentValue = null;
        private WavelengthSets possibleChoices = null;

        public void setPossibleChoices(WavelengthSets wavelengthSets) {
            this.possibleChoices = wavelengthSets;
        }

        public WavelengthSets getPossibleChoices() {
            return this.possibleChoices;
        }

        public void setValue(Attribute attribute) {
            this.currentValue = attribute;
        }

        public Attribute getValue() {
            return this.currentValue;
        }
    }

    public static interface IWLDialogValue {
        public Attribute getValue();
    }
}

