/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.ui.WzDialog;
import cerent.util.SDebug;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import java.lang.reflect.InvocationTargetException;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class WzDriver
implements ProgressDialogControl {
    private WzDialog dialog;
    private int driveCount;
    private int driveOffset;
    private int pageCount;
    private int progress;
    private int progressRange;
    private Runnable resetDialog;
    private Runnable nextPage;
    private Runnable finishDialog;
    private Thread executeThread;
    private boolean interrupted = false;
    private Exception storedException = null;
    private static int napTime = 100;
    private static final SDebug db = new WDDebug("WzDriver");

    public WzDriver(WzDialog wzDialog, int n, int n2) {
        this.dialog = wzDialog;
        this.driveCount = n;
        this.driveOffset = n2;
        this.pageCount = this.dialog.getPageCount();
        this.progress = 0;
        this.progressRange = this.driveCount * this.pageCount;
        this.resetDialog = new Runnable(){

            public void run() {
                WzDriver.this.dialog.popEntireStack();
            }
        };
        this.nextPage = new Runnable(){

            public void run() {
                WzDriver.this.dialog.next();
            }
        };
        this.finishDialog = new Runnable(){

            public void run() {
                WzDriver.this.dialog.finish();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeTask(Observer observer) throws Exception {
        block23: {
            block21: {
                block22: {
                    if (WzDriver.db.on) {
                        db.println("replay: about to start: driveCount = " + this.driveCount + ", pageCount = " + this.pageCount);
                    }
                    this.executeThread = Thread.currentThread();
                    long l = -1L;
                    try {
                        try {
                            if (WzDriver.db.on) {
                                l = System.currentTimeMillis();
                                db.println("In start of Apply ");
                            }
                            for (int i = 1; i <= this.driveCount; ++i) {
                                String string = " (" + (i + this.driveOffset) + " of " + (this.driveCount + this.driveOffset) + ")";
                                if (WzDriver.db.on) {
                                    db.println("run: about to reset: driveNum = " + i);
                                }
                                SwingUtilities.invokeAndWait(this.resetDialog);
                                if (this.shouldStop()) {
                                    Object var8_8 = null;
                                    if (!WzDriver.db.on) break block21;
                                    break block22;
                                }
                                for (int j = 1; j < this.pageCount; ++j) {
                                    if (db.on()) {
                                        db.println("*Driver " + j + "/" + this.pageCount + "\t" + this.dialog.getPageName());
                                    }
                                    observer.update(null, this.dialog.getPageName() + string);
                                    if (WzDriver.db.on) {
                                        db.println("run: invoking next on page " + this.dialog.getPageName());
                                    }
                                    SwingUtilities.invokeAndWait(this.nextPage);
                                    if (this.shouldStop()) {
                                        Object var8_9 = null;
                                        if (WzDriver.db.on) {
                                            db.println("run: cleaning up");
                                        }
                                        this.dialog.setDriver(null);
                                        return;
                                    }
                                    observer.update(null, this.incrementProgress());
                                    this.nap();
                                    if (!this.shouldStop()) continue;
                                    Object var8_10 = null;
                                    if (WzDriver.db.on) {
                                        db.println("run: cleaning up");
                                    }
                                    this.dialog.setDriver(null);
                                    return;
                                }
                                observer.update(null, this.dialog.getPageName() + string);
                                if (WzDriver.db.on) {
                                    db.println("run: invoking finish on page " + this.dialog.getPageName());
                                }
                                SwingUtilities.invokeAndWait(this.finishDialog);
                                observer.update(null, this.incrementProgress());
                                this.nap();
                            }
                            if (WzDriver.db.on) {
                                db.println("Total Time " + (System.currentTimeMillis() - l));
                            }
                            break block23;
                        }
                        catch (InterruptedException interruptedException) {
                            if (!WzDriver.db.on) throw interruptedException;
                            db.println("run: caught InterruptedException");
                            throw interruptedException;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            if (!WzDriver.db.on) throw (Exception)invocationTargetException.getTargetException();
                            db.println("run: caught InvocationTargetException");
                            throw (Exception)invocationTargetException.getTargetException();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        if (WzDriver.db.on) {
                            db.println("run: cleaning up");
                        }
                        this.dialog.setDriver(null);
                        throw throwable;
                    }
                }
                db.println("run: cleaning up");
            }
            this.dialog.setDriver(null);
            return;
        }
        Object var8_11 = null;
        if (WzDriver.db.on) {
            db.println("run: cleaning up");
        }
        this.dialog.setDriver(null);
    }

    public String getResultString(Exception exception) {
        throw new DeprecatedMethodCalled("ProgressDialogControl.getResultString(Exception)");
    }

    public synchronized ProgressDialogResult getResult(Exception exception) {
        return this.interrupted ? null : new ProgressDialogResult(this.dialog.getResultString(exception));
    }

    public synchronized void stop(Exception exception) {
        this.storedException = exception;
        this.interrupted = true;
    }

    public synchronized void stop() {
        this.interrupted = true;
    }

    public boolean stopRequired() {
        return this.interrupted;
    }

    public void suspend() {
    }

    public void resume() {
    }

    private synchronized boolean shouldStop() throws Exception {
        boolean bl = false;
        if (this.interrupted) {
            if (WzDriver.db.on) {
                db.println("shouldStop: driver was interrupted");
            }
            bl = true;
            if (this.storedException != null) {
                throw this.storedException;
            }
        }
        return bl;
    }

    private Integer incrementProgress() {
        return new Integer(++this.progress * 100 / this.progressRange);
    }

    private void nap() {
        try {
            if (napTime > 0) {
                Thread.sleep(napTime);
            }
        }
        catch (InterruptedException interruptedException) {
            db.finest("InterruptedException in nap() " + interruptedException);
        }
    }

    public static class WDDebug
    extends SDebug {
        public WDDebug(String string) {
            super(string);
        }

        public void setNapTime(int n) {
            napTime = n;
        }
    }
}

