/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aic;

import cerent.util.InetUtil;
import cerent.util.SDebug;

public class AicMaintVWRowObject {
    private static final String defaultNode = "???";
    private static final byte[] defaultIpAddress = new byte[]{0, 0, 0, 0};
    private final int[] vwMasks;
    public final byte[] ipAddress;
    public final String node;
    public final boolean[] vwStatus;
    private static final SDebug db = new SDebug("AicMaintVWRowObject");

    public AicMaintVWRowObject(String string, int n, int[] nArray, int n2) {
        this.node = string;
        this.vwMasks = nArray;
        this.ipAddress = InetUtil.makeIpAddr(n).getAddr();
        this.vwStatus = new boolean[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.vwStatus[i] = (n2 & nArray[i]) != 0;
        }
    }

    public int ipCompareTo(AicMaintVWRowObject aicMaintVWRowObject) {
        int n = 0;
        try {
            for (int i = 0; i < this.ipAddress.length; ++i) {
                int n2 = this.ipAddress[i] & 0xFF;
                int n3 = aicMaintVWRowObject.ipAddress[i] & 0xFF;
                if (n2 < n3) {
                    n = -1;
                } else {
                    if (n2 <= n3) continue;
                    n = 1;
                }
                break;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            n = 1;
        }
        return n;
    }

    public String getPrintableIpAddress() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < this.ipAddress.length; ++i) {
            String string = Integer.toString(this.ipAddress[i] & 0xFF);
            if (this.ipAddress[i] == 0 && !bl) continue;
            if (i > 0 && bl) {
                stringBuffer.append(".");
            }
            stringBuffer.append(string);
            bl = true;
        }
        return stringBuffer.toString();
    }
}

