/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Feature;
import cerent.cms.model.IBlsrProtectionOp;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.ICardAlarmStore;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.blsr.BlsrMapNode;
import cerent.cms.ui.blsr.BlsrPort;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.network.NetMapNode;
import cerent.util.IObservable;
import cerent.util.SDebug;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapPort;
import java.awt.Color;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class BlsrMapPort
extends MapPort
implements Observer {
    public static final int WEST = 0;
    public static final int WEST_PROTECT = 1;
    public static final int EAST = 2;
    public static final int EAST_PROTECT = 3;
    public static final int NEITHER = -1;
    protected ITdmPortModel tdmPortModel;
    private static final SDebug db = new SDebug("BlsrMapPort");
    private int eastWestSide = -1;

    public BlsrMapPort(DetailedMapNode detailedMapNode, MapLinkConnector mapLinkConnector) {
        super(detailedMapNode, mapLinkConnector);
    }

    public void init(Object object, Object object2) {
        super.init(object, object2);
        this.tdmPortModel = this.getITdmPortModelFromKey(object);
        if (null != this.tdmPortModel) {
            ICardAlarmStore iCardAlarmStore;
            IModuleModel iModuleModel = this.tdmPortModel.getModuleModel();
            if (null != iModuleModel) {
                iCardAlarmStore = this.getCardAlarmStore((IEntityModel)iModuleModel);
                iCardAlarmStore.enablePortAlarmsStatus(iModuleModel);
                iCardAlarmStore.addAlarmStatusObserver((Observer)this);
            }
            if (null != (iCardAlarmStore = this.tdmPortModel.getInterfaceModel())) {
                ModelIndirectObservable.instance().addObserver((IObservable)iCardAlarmStore, this);
            }
            this.setInfoString();
            this.updateColor();
        } else if (BlsrMapPort.db.on) {
            db.println("tdmPortModel is null");
        }
    }

    private Color getEntityModelColor(IEntityModel iEntityModel) {
        Color color = NetMapNode.DISCONNECTED_COLOR;
        if (iEntityModel instanceof IPortModel) {
            try {
                switch (((IPortModel)iEntityModel).getAdminState()) {
                    case 1: {
                        color = NetMapNode.DISCONNECTED_COLOR;
                        break;
                    }
                    case 2: {
                        color = NetMapNode.OOS_MT_COLOR;
                        break;
                    }
                    case 3: {
                        color = NetMapNode.IS_AINS_COLOR;
                        break;
                    }
                    case 0: {
                        color = NetMapNode.OK_COLOR;
                    }
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe(noSuchInterface.toString());
            }
            if (color.equals(NetMapNode.OK_COLOR)) {
                ICardAlarmStore iCardAlarmStore = this.getCardAlarmStore(iEntityModel);
                IPortModel iPortModel = (IPortModel)iEntityModel;
                color = iEntityModel.getNodeModel().provides(Feature.ENTITY_ALARM_STATUS) ? BlsrMapPort.getMapNodeColor(iCardAlarmStore.getEntityAlarmStatus((IEntityModel)iPortModel)) : BlsrMapPort.getMapNodeColor(iCardAlarmStore.getPortAlarmStatus(iPortModel.getEqType(), iPortModel.getPort()));
            }
        }
        return color;
    }

    private ICardAlarmStore getCardAlarmStore(IEntityModel iEntityModel) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        return iNodeModel.getElementAlarmStore().getCardAlarmStore(iEntityModel.getSlot());
    }

    public void dispose() {
        if (this.tdmPortModel != null) {
            ICardAlarmStore iCardAlarmStore;
            IModuleModel iModuleModel = this.tdmPortModel.getModuleModel();
            if (null != iModuleModel) {
                iCardAlarmStore = this.getCardAlarmStore((IEntityModel)iModuleModel);
                iCardAlarmStore.disablePortAlarmsStatus();
                iCardAlarmStore.deleteAlarmStatusObserver((Observer)this);
            }
            if (null != (iCardAlarmStore = this.tdmPortModel.getInterfaceModel())) {
                ModelIndirectObservable.instance().deleteObserver((IObservable)iCardAlarmStore, this);
            }
            this.tdmPortModel = null;
        }
    }

    protected static Color getMapNodeColor(IAlarmStatus iAlarmStatus) {
        Color color = NetMapNode.getMapNodeColor(iAlarmStatus);
        if (NetMapNode.DISCONNECTED_COLOR.equals(color)) {
            color = NetMapNode.CRITICAL_COLOR;
        }
        return color;
    }

    private String asSlashSeparatedString() {
        if (this.eastWestSide == 2) {
            if (BlsrMapPort.db.on) {
                db.println("Adding '/E' to BlsrMapPort");
            }
            return BlsrMapPort.asSlashSeparatedString(this.tdmPortModel, "E");
        }
        if (this.eastWestSide == 3) {
            if (BlsrMapPort.db.on) {
                db.println("Adding '/EP' to BlsrMapPort");
            }
            return BlsrMapPort.asSlashSeparatedString(this.tdmPortModel, "EP");
        }
        if (this.eastWestSide == 0) {
            if (BlsrMapPort.db.on) {
                db.println("Adding '/W' to BlsrMapPort");
            }
            return BlsrMapPort.asSlashSeparatedString(this.tdmPortModel, "W");
        }
        if (this.eastWestSide == 1) {
            if (BlsrMapPort.db.on) {
                db.println("Adding '/WP' to BlsrMapPort");
            }
            return BlsrMapPort.asSlashSeparatedString(this.tdmPortModel, "WP");
        }
        if (BlsrMapPort.db.on) {
            db.println("Not adding either '/E' or '/W' because eastWestSide = " + this.eastWestSide);
        }
        return BlsrMapPort.asSlashSeparatedString(this.tdmPortModel, null);
    }

    public static String asSlashSeparatedString(ITdmPortModel iTdmPortModel, String string) {
        StringBuffer stringBuffer = new StringBuffer(16);
        if (iTdmPortModel != null) {
            stringBuffer.append("s");
            stringBuffer.append(iTdmPortModel.getSlot());
            stringBuffer.append("/");
            stringBuffer.append("p");
            stringBuffer.append(PortHelper.getPortNumString((IPortModel)iTdmPortModel));
            if (string != null) {
                stringBuffer.append("/");
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public String getServiceStateString() {
        if (this.tdmPortModel != null) {
            try {
                if (!Feature.provides((INodeModel)this.tdmPortModel.getNodeModel(), (Feature)Feature.EXTENDED_ESM)) {
                    return NetworkDefaults.circuitAdminStateToString(this.tdmPortModel.getAdminState());
                }
                return NetworkDefaults.getCmsHostTDMTerms().getTermForServiceState(this.tdmPortModel.getServiceStateType());
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe(noSuchInterface.toString());
            }
        }
        return "";
    }

    private void setInfoString() {
        this.setInfoString(this.asSlashSeparatedString());
    }

    public void setInfoString(String string) {
        super.setInfoString(string);
        this.updateLinkText(this.getInfoString());
    }

    public void setEastWest(int n) {
        if (BlsrMapPort.db.on) {
            db.println("BlsrMapPort::setEastWest(eastWest=" + n + ") called.");
        }
        switch (n) {
            case 0: {
                this.eastWestSide = 0;
                break;
            }
            case 1: {
                this.eastWestSide = 1;
                break;
            }
            case 2: {
                this.eastWestSide = 2;
                break;
            }
            case 3: {
                this.eastWestSide = 3;
                break;
            }
            default: {
                this.eastWestSide = -1;
            }
        }
        this.setInfoString();
    }

    public ITdmPortModel getITdmPortModelFromKey(Object object) {
        ITdmPortModel iTdmPortModel = null;
        if (object instanceof ITdmPortModel) {
            iTdmPortModel = (ITdmPortModel)object;
        } else if (object instanceof BlsrPort) {
            iTdmPortModel = ((BlsrPort)object).getTdmPortModel();
        } else if (BlsrMapPort.db.on) {
            db.println("portKey was an instance of an unknown class: " + object);
        }
        return iTdmPortModel;
    }

    public void invalidateRelatedRegion() {
        BlsrMapNode blsrMapNode = (BlsrMapNode)this.parentNode;
        if (blsrMapNode != null) {
            blsrMapNode.invalidate();
        }
    }

    public void updateColor() {
        if (this.tdmPortModel != null) {
            try {
                Color color = this.getColor();
                INodeModel iNodeModel = this.tdmPortModel.getNodeModel();
                IEntityModel iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(this.tdmPortModel.getEntityIndex());
                Color color2 = this.getEntityModelColor(iEntityModel);
                if (BlsrMapPort.db.on) {
                    db.println("new color for EntityModel (em=" + iEntityModel + ")is: " + color2);
                }
                if (!color.equals(color2)) {
                    this.setColor(color2);
                    this.setInfoString();
                    this.invalidateRelatedRegion();
                    db.info("Update on port " + this.getInfoString());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (BlsrMapPort.db.on) {
                    db.info("IllegalArgumentException in BlsrMapPort - not updating state - probably ok.");
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        } else if (BlsrMapPort.db.on) {
            db.println("tdmPortModel is null!" + this);
        }
    }

    public void update(Observable observable, Object object) {
        if (BlsrMapPort.db.on) {
            db.println("update(observable=" + observable + ", Object=" + object + ")");
        }
        if (observable instanceof IInterfaceModel || object instanceof IAlarmStatus) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BlsrMapPort.this.updateColor();
                }
            });
        }
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg.clear();
    }

    public String getToolTipText() {
        BlsrMapNode blsrMapNode;
        BlsrNode blsrNode;
        String string = this.getInfoString();
        String string2 = this.getServiceStateString();
        if (string2.length() > 0) {
            string = string + '(' + string2 + ')';
        }
        if (this.parentNode instanceof BlsrMapNode && (blsrNode = (blsrMapNode = (BlsrMapNode)this.parentNode).getBlsrNode()) != null && this.tdmPortModel != null) {
            if (this.tdmPortModel.equals(blsrNode.getEastPort()) || this.tdmPortModel.equals(blsrNode.getEastProtectPort())) {
                if (blsrNode.getEastProtectionOp().getKOp() != 0) {
                    string = string + ", " + BlsrMapPort.getStringForOp(blsrNode.getEastProtectionOp());
                }
            } else if (this.tdmPortModel.equals(blsrNode.getWestPort()) || this.tdmPortModel.equals(blsrNode.getWestProtectPort())) {
                if (blsrNode.getWestProtectionOp().getKOp() != 0) {
                    string = string + ", " + BlsrMapPort.getStringForOp(blsrNode.getWestProtectionOp());
                }
            } else if (BlsrMapPort.db.on) {
                db.println("ITdmPortModel not found on either side of BlsrNode!");
                db.println("   BlsrNode is: " + blsrNode);
                db.println("   ITdmPortModel is: " + this.tdmPortModel);
            }
        }
        return string;
    }

    private static String getStringForOp(IBlsrProtectionOp iBlsrProtectionOp) {
        String string = "";
        if (null != iBlsrProtectionOp) {
            int n = iBlsrProtectionOp.getKOp();
            switch (n) {
                case 0: {
                    string = "CLEAR";
                    break;
                }
                case 7: {
                    string = "EXERCISE RING";
                    break;
                }
                case 6: {
                    string = "EXERCISE SPAN";
                    break;
                }
                case 3: {
                    string = "FORCE RING";
                    break;
                }
                case 2: {
                    string = "FORCE SPAN";
                    break;
                }
                case 1: {
                    string = "LOCK SPAN";
                    break;
                }
                case 5: {
                    string = "MANUAL RING";
                    break;
                }
                case 4: {
                    string = "MANUAL SPAN";
                }
            }
        }
        return string;
    }
}

