/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.blsr.BlsrUpgradeException;
import cerent.cms.model.blsr.ExistingPCAException;
import cerent.cms.model.blsr.ExistingProtectionSwitchException;
import cerent.cms.model.blsr.LockOutSpanException;
import cerent.cms.model.blsr.PortsNotEnabledException;
import cerent.cms.model.blsr.PortsNotSpecifiedException;
import cerent.cms.model.blsr.PortsSdccTerminatedException;
import cerent.cms.model.blsr.PortsWithOrderwireException;
import cerent.cms.model.blsr.TimingReferenceException;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.WizardDialog;
import cerent.cms.ui.blsr.AbstractBlsrWizardDialog;
import cerent.cms.ui.blsr.RcdProtectPortPane;
import cerent.cms.ui.blsr.RudSpanReversionPane;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.WID;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class RingUpgradeDialog
extends AbstractBlsrWizardDialog {
    private BlsrRingModel blsrRingModel;
    private IRevertiveBehavior spanReversion = new RevertiveBehavior(2, 30);
    public static String TITLE;
    public static final String SPAN_REVERSION_PANE = "Select Span Reversion";
    public static final String PROTECT_PORT_PANE = "Protect Port Selections";
    private static final UiToolkit uiToolkit;
    private static final int VIGN_WIDTH = 200;
    private static final int WIDTH = 750;
    static final int SHORT = 320;
    static final int TALL = 600;
    RudSpanReversionPane rudSpanReversionPane;
    RcdProtectPortPane rcdProtectPortPane;
    private static TDMTerminology tdmTerm;
    private static final SDebug db;
    private boolean insaneMode = false;
    private RingUpgradeDebug ringUpgradeDebug = null;
    Set nodeNames;
    private static String dccTerm;

    public static RingUpgradeDialog instance(JComponent jComponent, BlsrRingModel blsrRingModel) {
        Frame frame = JOptionPane.getFrameForComponent(jComponent);
        if (tdmTerm == null) {
            BlsrNode[] blsrNodeArray = blsrRingModel.getBlsrNodes();
            if (blsrNodeArray.length > 0) {
                tdmTerm = blsrNodeArray[0].getNodeModel().getTDMTerminology();
                BLSR_TERM = tdmTerm.getRingTerms(1);
                dccTerm = tdmTerm.getGeneralTerms(8);
            } else {
                BLSR_TERM = "BLSR";
            }
            TITLE = BLSR_TERM + " Upgrade";
        }
        return new RingUpgradeDialog(frame, blsrRingModel);
    }

    private RingUpgradeDialog(Frame frame, BlsrRingModel blsrRingModel) {
        super(frame, TITLE);
        this.blsrRingModel = blsrRingModel;
        this.reset();
        this.createPanes();
        this.setLocationRelativeTo(frame);
        this.ringUpgradeDebug = new RingUpgradeDebug("ringUpgradeDebug", this);
    }

    private void setBlsrRingModel(BlsrRingModel blsrRingModel) {
        if (RingUpgradeDialog.db.on) {
            db.println("setBlsrRingModel called");
        }
        this.blsrRingModel = blsrRingModel;
        this.spanReversion = blsrRingModel.getBlsrRingInfo().getSpanReversion();
    }

    private void createPanes() {
        if (RingUpgradeDialog.db.on) {
            db.println("createPanes() called");
        }
        this.addStatusPanel(new WizardDialog.StatusPanel("/images/CTC_dialogVignette.gif", new Dimension(200, 320)));
        this.rudSpanReversionPane = new RudSpanReversionPane(SPAN_REVERSION_PANE, this);
        this.addPage(this.rudSpanReversionPane);
        this.rcdProtectPortPane = new RcdProtectPortPane(PROTECT_PORT_PANE, this);
        this.addPage(this.rcdProtectPortPane);
    }

    protected void reset() {
        if (RingUpgradeDialog.db.on) {
            db.println("reset() called");
        }
        this.nodeNames = this.fetchNodeSnapshot();
        this.setHeight(320);
        if (this.getStatusPanel() != null) {
            this.getStatusPanel().reset();
        }
        this.setFinishEnabled(false);
        super.reset();
    }

    private Set fetchNodeSnapshot() {
        HashSet<String> hashSet = new HashSet<String>();
        BlsrNode[] blsrNodeArray = this.blsrRingModel.getBlsrNodes();
        for (int i = 0; i < blsrNodeArray.length; ++i) {
            hashSet.add(blsrNodeArray[i].getNodeModel().getHostName());
        }
        return hashSet;
    }

    void setHeight(int n) {
        this.setSize(new Dimension(750, n));
        this.invalidate();
    }

    protected boolean preApply() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply() throws Exception {
        try {
            boolean bl;
            uiToolkit.setCursor(3);
            if (RingUpgradeDialog.db.on) {
                db.println("apply() called");
            }
            boolean bl2 = false;
            String string = "";
            try {
                StringBuffer stringBuffer;
                this.rcdProtectPortPane.apply();
                if (!this.insaneMode) {
                    if (RingUpgradeDialog.db.on) {
                        db.println("+++ Calling blsrRingModel.sanityCheck()");
                    }
                    this.blsrRingModel.sanityCheckUpgrade();
                    if (RingUpgradeDialog.db.on) {
                        db.println("--- Returned from blsrRingModel.sanityCheck()");
                    }
                } else if (RingUpgradeDialog.db.on) {
                    db.println("skipping call to  blsrRingModel.sanityCheck() - Hey, I am insane!");
                }
                bl2 = true;
                boolean bl3 = bl = this.blsrRingModel.getWorkingExtensionByteMismatchSpans().length != 0 || this.blsrRingModel.getPotentialProtectExtensionByteMismatchSpans().length != 0;
                if (bl) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("There is at least one span which has a(n) " + BLSR_TERM + " extension byte mismatch. \n");
                    stringBuffer.append("The provisioning will continue but you will need to go to the \n");
                    stringBuffer.append(BLSR_TERM + " edit window and correct this problem by right-clicking on the red \n");
                    stringBuffer.append("span to change the extension byte to the same value on both sides of the span \n");
                    stringBuffer.append("before the " + BLSR_TERM + " will switch properly.\n");
                    ErrorMsg.displayWarning((Component)this, (WID)NEMC.WID_EXTENSION_BYTE_MISMATCH_PARAM_1, (Object)stringBuffer.toString());
                }
                if (!((Object)this.nodeNames).equals(this.fetchNodeSnapshot())) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("The number of nodes in the ring being upgraded has changed.\n");
                    stringBuffer.append("It could be because a node went down, an individual " + BLSR_TERM + "\n");
                    stringBuffer.append("was deleted, or that additional nodes in the ring were discovered.\n");
                    stringBuffer.append("Are you sure you want to continue with the upgrade?\n");
                    if (!CerentDialog.yesNoDialog((Component)this, (String)stringBuffer.toString(), (String)(BLSR_TERM + " has changed"))) {
                        bl2 = false;
                    }
                }
            }
            catch (TimingReferenceException timingReferenceException) {
                BlsrNode[] blsrNodeArray = timingReferenceException.getBlsrNodes();
                String string2 = "The following nodes have ports which are currently used as timing references: \n";
                for (int i = 0; i < blsrNodeArray.length; ++i) {
                    string2 = string2 + blsrNodeArray[i] + "\n";
                }
                throw new AnnotatedException(string2, (Exception)timingReferenceException);
            }
            catch (PortsNotSpecifiedException portsNotSpecifiedException) {
                BlsrNode[] blsrNodeArray = portsNotSpecifiedException.getBlsrNodes();
                String string3 = "The following nodes do not have properly specified protect ports: \n";
                for (int i = 0; i < blsrNodeArray.length; ++i) {
                    string3 = string3 + blsrNodeArray[i] + "\n";
                }
                throw new AnnotatedException(string3, (Exception)portsNotSpecifiedException);
            }
            catch (PortsNotEnabledException portsNotEnabledException) {
                BlsrNode[] blsrNodeArray = portsNotEnabledException.getBlsrNodes();
                String string4 = "The following nodes have ports which are not currently In Service: \n";
                for (int i = 0; i < blsrNodeArray.length; ++i) {
                    string4 = string4 + blsrNodeArray[i] + "\n";
                }
                throw new AnnotatedException(string4, (Exception)portsNotEnabledException);
            }
            catch (PortsSdccTerminatedException portsSdccTerminatedException) {
                BlsrNode[] blsrNodeArray = portsSdccTerminatedException.getBlsrNodes();
                String string5 = "The following nodes have protect ports which currently have " + dccTerm + " terminations: \n";
                for (int i = 0; i < blsrNodeArray.length; ++i) {
                    string5 = string5 + blsrNodeArray[i] + "\n";
                }
                throw new AnnotatedException(string5, (Exception)portsSdccTerminatedException);
            }
            catch (PortsWithOrderwireException portsWithOrderwireException) {
                BlsrNode[] blsrNodeArray = portsWithOrderwireException.getBlsrNodes();
                String string6 = "The following nodes have ports which currently have orderwire specified: \n";
                for (int i = 0; i < blsrNodeArray.length; ++i) {
                    string6 = string6 + blsrNodeArray[i] + "\n";
                }
                throw new AnnotatedException(string6, (Exception)portsWithOrderwireException);
            }
            if (bl2) {
                if (RingUpgradeDialog.db.on) {
                    db.println("+++ Calling blsrRingModel.upgradeTo4Fiber()");
                }
                bl = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = true;
                while (bl6) {
                    String string7;
                    try {
                        this.blsrRingModel.upgradeTo4Fiber(this.spanReversion, bl, bl4, bl5);
                        bl6 = false;
                    }
                    catch (LockOutSpanException lockOutSpanException) {
                        string7 = "In order to upgrade the ring, all spans must be locked out.\n";
                        string7 = string7 + "However, there are currently one or more protection operations\n";
                        string7 = string7 + "applied which prevent locking the spans out.\n";
                        string7 = string7 + "Is it OK to clear all existing protection operations and proceed?";
                        if (CerentDialog.yesNoDialog((Component)this, (String)string7, (String)"Unable to lock out spans")) {
                            bl = true;
                            continue;
                        }
                        bl6 = false;
                        this.rcdProtectPortPane.unapply();
                    }
                    catch (ExistingProtectionSwitchException existingProtectionSwitchException) {
                        string7 = "There is a protection switch in the ring right now.\n";
                        string7 = string7 + "Performing an upgrade now might cause loss of traffic.\n";
                        string7 = string7 + "However, if you have recently cleared protection operations\n";
                        string7 = string7 + "this may be an expected condition.\n";
                        string7 = string7 + "Is it OK to ignore existing protection switches and continue?";
                        if (CerentDialog.yesNoDialog((Component)this, (String)string7, (String)"Protection switch exists")) {
                            bl4 = true;
                            continue;
                        }
                        bl6 = false;
                        this.rcdProtectPortPane.unapply();
                    }
                    catch (ExistingPCAException existingPCAException) {
                        string7 = "There is Protection Channel Access (PCA) traffic on \n";
                        string7 = string7 + "at least one span in this ring.  This is also sometimes referred\n";
                        string7 = string7 + "to as \"Extra Traffic\".  Performing an upgrade now will cause these\n";
                        string7 = string7 + "circuits to be disconnected until the upgrade is successful and all nodes\n";
                        string7 = string7 + "in the " + BLSR_TERM + " have been upgraded.  Afterwards, these circuits will have\n";
                        string7 = string7 + "four-fiber " + BLSR_TERM + " protection. \n\n";
                        string7 = string7 + "Is it OK to ignore the existing PCA circuits and continue?";
                        if (CerentDialog.yesNoDialog((Component)this, (String)string7, (String)"Protection Channel Access (PCA) traffic exists")) {
                            bl5 = true;
                            continue;
                        }
                        bl6 = false;
                        this.rcdProtectPortPane.unapply();
                    }
                }
                if (RingUpgradeDialog.db.on) {
                    db.println("upgrade to 4F apparently succeeded.");
                }
            } else {
                this.rcdProtectPortPane.unapply();
                if (RingUpgradeDialog.db.on) {
                    db.println("upgrade to 4F failed sanityCheck.");
                }
            }
            Object var10_34 = null;
        }
        catch (Throwable throwable) {
            Object var10_35 = null;
            uiToolkit.setCursor(0);
            throw throwable;
        }
        uiToolkit.setCursor(0);
    }

    public boolean handleFinishException(Exception exception) {
        if (!(exception instanceof BlsrUpgradeException)) {
            return false;
        }
        boolean bl = false;
        BlsrUpgradeException blsrUpgradeException = (BlsrUpgradeException)exception;
        StringBuffer stringBuffer = new StringBuffer(blsrUpgradeException.toString());
        BlsrNode[] blsrNodeArray = blsrUpgradeException.getReprovisionFailures();
        if (blsrNodeArray.length > 0) {
            stringBuffer.append("\nWARNING: The " + BLSR_TERM + " is in an inconsistent state and\n" + "traffic may be impacted.");
            bl = true;
        }
        ErrorMsg.displayError((Component)this, (EID)NEMC.EID_FAIL_WIZARD_VALIDATION_PARAM_1, (Object)stringBuffer.toString());
        if (bl) {
            this.dispose();
        }
        return true;
    }

    protected void handleCancel() {
        if (RingUpgradeDialog.db.on) {
            db.println("handleCancel() called");
        }
        super.handleCancel();
        this.dispose();
    }

    public void dispose() {
        if (RingUpgradeDialog.db.on) {
            db.println("dispose() called");
        }
        this.rudSpanReversionPane.dispose();
        this.rcdProtectPortPane.dispose();
        super.dispose();
    }

    protected BlsrRingModel getBlsrRingModel() {
        return this.blsrRingModel;
    }

    public void showPage(String string, boolean bl) {
        if (RingUpgradeDialog.db.on) {
            db.println("showPage(pageName=" + string + ", refresh=" + bl + ") called");
        }
        super.showPage(string, bl);
    }

    public void setSpanReversion(IRevertiveBehavior iRevertiveBehavior) {
        if (iRevertiveBehavior != null) {
            this.spanReversion = iRevertiveBehavior;
        }
    }

    public int getSpanReversionPreference() {
        Preferences preferences = Preferences.instance();
        int n = preferences.getInt("ctc.net_blsr_wiz", "spanReversion", 300);
        return n;
    }

    public void putSpanReversionPreference(int n) {
        Preferences preferences = Preferences.instance();
        preferences.setInt("ctc.net_blsr_wiz", "spanReversion", n);
    }

    public void setInsaneMode(boolean bl) {
        this.insaneMode = bl;
    }

    static {
        uiToolkit = UiToolkit.instance();
        db = new SDebug("RingUpgradeDialog");
    }

    public class RingUpgradeDebug
    extends SDebug {
        private RingUpgradeDialog _rud;

        public RingUpgradeDebug(String string, RingUpgradeDialog ringUpgradeDialog2) {
            super(string);
            this._rud = null;
            this._rud = ringUpgradeDialog2;
        }

        public final void goInsane() {
            if (null != this._rud) {
                this._rud.setInsaneMode(true);
            }
        }

        public final void goSane() {
            if (null != this._rud) {
                this._rud.setInsaneMode(false);
            }
        }

        public void dispose() {
            this._rud = null;
            super.dispose();
        }
    }
}

