/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCcdAttrsPane;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import java.awt.Frame;

public abstract class AbstractUpsrCircuitDialog
extends AbstractCircuitDialog {
    public AbstractUpsrCircuitDialog(Frame frame, String string, WzDiagDebug wzDiagDebug, boolean bl) {
        super(frame, string, wzDiagDebug, bl);
    }

    public Attribute getUpsrSfBerLevel() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrSfBerLevel();
        }
        this.db.severe("could not get upsr sf ber level ... returning NULL");
        return null;
    }

    protected void setUpsrSfBerLevel(Attribute attribute) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrSfBerLevel(attribute);
        } else {
            this.db.severe("could not set upsr SF Ber Level.");
        }
    }

    public Attribute getUpsrSdBerLevel() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrSdBerLevel();
        }
        this.db.severe("could not get upsr sd ber level... returning NULL");
        return null;
    }

    protected void setUpsrSdBerLevel(Attribute attribute) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrSdBerLevel(attribute);
        } else {
            this.db.severe("could not set upsr SD Ber Level.");
        }
    }

    public IRevertiveBehavior getUpsrReversion() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrReversion();
        }
        this.db.severe("could not get revertive behavior... returning NULL");
        return null;
    }

    protected void setUpsrReversion(IRevertiveBehavior iRevertiveBehavior) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrReversion(iRevertiveBehavior);
        } else {
            this.db.severe("could not set upsr revertive behavior");
        }
    }

    public boolean getUpsrSwitchOnPdip() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrSwitchOnPdip();
        }
        this.db.severe("could not get UPSR switch... returning false");
        return false;
    }

    protected void setUpsrSwitchOnPdip(boolean bl) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrSwitchOnPdip(bl);
        } else {
            this.db.severe("could not set UPSR switch on Pdip");
        }
    }

    public boolean getUpsrGoReturnRouting() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getUpsrGoReturnRouting();
        }
        this.db.severe("could not get UPSR go-ret routing... returning false");
        return false;
    }

    protected void setUpsrGoReturnRouting(boolean bl) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setUpsrGoReturnRouting(bl);
        } else {
            this.db.severe("could not set UPSR return routing.");
        }
    }

    protected void getUpsrGoReturnRoutingDefault() {
        String string = "NODE.circuits.upsr.ProvisionWorkingGoAndReturnOnPrimaryPath";
        String string2 = "TRUE";
        if (NetworkModel.instance().getCmsHostModel().getTdmProtocolTypeObj().isSdh()) {
            string = string.replaceFirst("upsr", "sncp");
            string2 = "FALSE";
        }
        this.setUpsrGoReturnRouting(this.getDefaultValue(string, string2).equalsIgnoreCase("TRUE"));
        this.db.info("Default go and return routing is " + this.getUpsrGoReturnRouting());
    }

    protected void getUpsrReversionDefaults() {
        RevertiveBehavior revertiveBehavior;
        block3: {
            revertiveBehavior = new RevertiveBehavior(1, 300);
            try {
                revertiveBehavior.setReversionMode(Integer.parseInt(this.getDefaultValue("NODE.circuits.upsr.Revertive", String.valueOf(1))));
                revertiveBehavior.setReversionTime(Integer.parseInt(this.getDefaultValue("NODE.circuits.upsr.ReversionTime", String.valueOf(300))));
            }
            catch (Exception exception) {
                if (!this.db.isSevereEnabled()) break block3;
                this.db.severe("Can't retrieve default revertive behavior: " + exception.getMessage());
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
        if (revertiveBehavior.getReversionTime() == 0) {
            this.db.severe("Overriding reversion time");
            revertiveBehavior.setReversionTime(30);
        }
        this.setUpsrReversion(revertiveBehavior);
        this.db.info("Default reversion is " + revertiveBehavior.getReversionMode() + " " + revertiveBehavior.getReversionTime());
    }

    private Attribute getSfBerAttr(int n, int n2) {
        AttributeMaps attributeMaps = NetworkDefaults.getAttributeMap();
        Attribute attribute = attributeMaps.getAttributeForVal("declareSfBerLevel", n);
        if (attribute == null) {
            n = n2 == 2 ? 4 : 3;
            attribute = attributeMaps.getAttributeForVal("declareSfBerLevel", n);
        }
        this.db.info("getSfBerAttr circuitOrder=" + n2 + " SF value = " + n);
        return attribute;
    }

    private Attribute getSdBerAttr(int n, int n2) {
        AttributeMaps attributeMaps = NetworkDefaults.getAttributeMap();
        Attribute attribute = attributeMaps.getAttributeForVal("declareSdBerLevel", n);
        if (attribute == null) {
            n = n2 == 2 ? 6 : 5;
            attribute = attributeMaps.getAttributeForVal("declareSdBerLevel", n);
        }
        this.db.info("getSdBerAttr circuitOrder=" + n2 + " SD value = " + n);
        return attribute;
    }

    protected void getUpsrSberDefaults() {
        int n;
        int n2;
        int n3;
        block3: {
            n3 = -1;
            n2 = -1;
            String string = "4";
            String string2 = "6";
            n = 2;
            String string3 = "NODE.circuits.upsr.STS_SFBER";
            String string4 = "NODE.circuits.upsr.STS_SDBER";
            ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitType());
            if (iCircuitType.isLoCircuitType()) {
                n = 1;
                string3 = "NODE.circuits.upsr.VT_SFBER";
                string4 = "NODE.circuits.upsr.VT_SDBER";
            }
            try {
                n3 = Integer.parseInt(this.getDefaultValue(string3, string));
                n2 = Integer.parseInt(this.getDefaultValue(string4, string2));
            }
            catch (Exception exception) {
                if (!this.db.isSevereEnabled()) break block3;
                this.db.severe("Can't get default bers:" + exception);
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
        this.setUpsrSfBerLevel(this.getSfBerAttr(n3, n));
        this.setUpsrSdBerLevel(this.getSdBerAttr(n2, n));
        this.db.info("Default bers are " + n3 + " " + n2);
    }

    protected void getUpsrSwitchOnPDIPDefaults() {
        boolean bl = false;
        bl = this.getDefaultValue("NODE.circuits.upsr.SwitchOnPDIP", "FALSE").equalsIgnoreCase("TRUE");
        this.setUpsrSwitchOnPdip(bl);
        this.db.info("Default switchOnPDIP is " + bl);
    }
}

