/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitSize;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ncp.RollValidator;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.NodeCellRenderer;
import cerent.cms.ui.WizardPane;
import cerent.cms.ui.circuits.BulkRollDialog;
import cerent.cms.ui.circuits.RollPortRenderer;
import cerent.cms.ui.circuits.RollSlotRenderer;
import cerent.util.ErrorMsg;
import cerent.util.HoLoFactory;
import cerent.util.NEMC;
import cerent.util.SonetHoNum;
import cerent.util.SonetLoNum;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BulkRollEndpointPane
extends WizardPane
implements ActionListener {
    private JPanel rollPanel;
    private JComboBox rollNodeCB = new JComboBox();
    private JComboBox slotCB = new JComboBox();
    private JComboBox portCB = new JComboBox();
    private JComboBox startingStsCB = new JComboBox();
    private JComboBox startingVtCB = new JComboBox();
    private JComboBox endingStsCB = new JComboBox();
    private JComboBox endingVtCB = new JComboBox();
    private JPanel startingHoPanel = null;
    private JPanel startingLoPanel = null;
    private JPanel startingVc3Panel = null;
    private JPanel startingTug2Panel = null;
    private JPanel startingVc12Panel = null;
    private JPanel endingHoPanel = null;
    private JPanel endingLoPanel = null;
    private JPanel endingVc3Panel = null;
    private JPanel endingTug2Panel = null;
    private JPanel endingVc12Panel = null;
    private JComboBox startingVc4CB = new JComboBox();
    private JComboBox startingVc3CB = new JComboBox();
    private JComboBox startingTug2CB = new JComboBox();
    private JComboBox startingVc12CB = new JComboBox();
    private JComboBox endingVc4CB = new JComboBox();
    private JComboBox endingVc3CB = new JComboBox();
    private JComboBox endingTug2CB = new JComboBox();
    private JComboBox endingVc12CB = new JComboBox();
    private Integer[] tug3Arr;
    private Integer[] tug2Arr;
    private Integer[] vc12Arr;
    private int fromTo;
    private int framingType;
    private INodeModel nodeModel;
    private RollValidator rollValidator = RollValidator.getInstance();
    private BulkRollDialog parent;
    private static final int FROM = 1;
    private static final int TO = 2;
    private static final int NUM_VT_IN_STS = 28;
    private static final int NODE_LEVEL = 1;
    private static final int SLOT_LEVEL = 2;
    private static final int PORT_LEVEL = 3;
    private static final int STS_LEVEL = 4;
    private static final int VT_LEVEL = 5;
    private static final int VC4_LEVEL = 6;
    private static final int VC3_LEVEL = 7;
    private static final int TUG2_LEVEL = 8;
    private static final int VC12_LEVEL = 9;

    public BulkRollEndpointPane(String string, int n, BulkRollDialog bulkRollDialog) {
        super(string, bulkRollDialog);
        this.parent = bulkRollDialog;
        this.fromTo = n;
        String string2 = n == 1 ? "Roll From Points" : "Roll To Points";
        this.rollPanel = BulkRollEndpointPane.createVerticalPanel(string2);
        this.rollPanel.setLayout(new GridLayout(0, 1));
        this.add(this.rollPanel);
        JPanel jPanel = this.createNodePanel(this.rollNodeCB);
        this.rollPanel.add(jPanel);
        JPanel jPanel2 = this.createSlotPanel(this.slotCB);
        this.rollPanel.add(jPanel2);
        JPanel jPanel3 = this.createPortPanel(this.portCB);
        this.rollPanel.add(jPanel3);
        this.initSdhArr();
        this.reset();
    }

    private void initSdhArr() {
        Integer n;
        int n2;
        this.tug3Arr = new Integer[3];
        for (n2 = 0; n2 < 3; ++n2) {
            this.tug3Arr[n2] = n = new Integer(n2 + 1);
        }
        this.tug2Arr = new Integer[7];
        for (n2 = 0; n2 < 7; ++n2) {
            this.tug2Arr[n2] = n = new Integer(n2 + 1);
        }
        this.vc12Arr = new Integer[3];
        for (n2 = 0; n2 < 3; ++n2) {
            this.vc12Arr[n2] = n = new Integer(n2 + 1);
        }
    }

    private JPanel createNodePanel(JComboBox jComboBox) {
        JPanel jPanel = BulkRollEndpointPane.createHorizontalPanel(null);
        jPanel.setLayout(new GridLayout(1, 0));
        jPanel.add(new JLabel("Node: ", 4));
        jPanel.add(jComboBox);
        jComboBox.setRenderer(new NodeCellRenderer());
        this.updateNodes();
        jComboBox.addActionListener(this);
        return jPanel;
    }

    private JPanel createSlotPanel(JComboBox jComboBox) {
        JPanel jPanel = BulkRollEndpointPane.createHorizontalPanel(null);
        jPanel.setLayout(new GridLayout(1, 0));
        jPanel.add(new JLabel("Slot: ", 4));
        jPanel.add(jComboBox);
        jComboBox.setRenderer(new RollSlotRenderer());
        jComboBox.addActionListener(this);
        return jPanel;
    }

    private JPanel createPortPanel(JComboBox jComboBox) {
        JPanel jPanel = BulkRollEndpointPane.createHorizontalPanel(null);
        jPanel.setLayout(new GridLayout(1, 0));
        jPanel.add(new JLabel("Port: ", 4));
        jPanel.add(jComboBox);
        jComboBox.setRenderer(new RollPortRenderer());
        jComboBox.addActionListener(this);
        return jPanel;
    }

    private void createAllPathPanels() {
        if (this.nodeModel == null) {
            return;
        }
        if (this.nodeModel.getTdmProtocolTypeObj().isSonet()) {
            this.framingType = 0;
            this.createPathPanels(this.startingHoPanel, this.startingStsCB, "Starting STS:");
            this.createPathPanels(this.endingHoPanel, this.endingStsCB, "Ending STS:");
            this.createPathPanels(this.startingLoPanel, this.startingVtCB, "Starting VT:");
            this.createPathPanels(this.endingLoPanel, this.endingVtCB, "Ending VT:");
        } else {
            this.createPathPanels(this.startingHoPanel, this.startingVc4CB, "Starting VC4:");
            this.createPathPanels(this.startingVc3Panel, this.startingVc3CB, "Starting VC3:");
            this.createPathPanels(this.startingTug2Panel, this.startingTug2CB, "Starting TUG2:");
            this.createPathPanels(this.startingHoPanel, this.startingVc4CB, "Starting VC12:");
            this.createPathPanels(this.endingHoPanel, this.endingVc4CB, "ending VC4:");
            this.createPathPanels(this.endingVc3Panel, this.endingVc3CB, "ending VC3:");
            this.createPathPanels(this.endingTug2Panel, this.endingTug2CB, "ending TUG2:");
            this.createPathPanels(this.endingVc12Panel, this.endingVc12CB, "ending VC12:");
        }
    }

    private void createPathPanels(JPanel jPanel, JComboBox jComboBox, String string) {
        if (jPanel == null) {
            jPanel = BulkRollEndpointPane.createHorizontalPanel(null);
            jPanel.setLayout(new GridLayout(1, 0));
            jPanel.add(new JLabel(string, 4));
            jPanel.add(jComboBox);
            jComboBox.addActionListener(this);
            this.rollPanel.add(jPanel);
        }
    }

    private void setFramingType(INodeModel iNodeModel) {
    }

    private void clearChildCB(int n) {
        if (n == 2) {
            this.slotCB.setSelectedItem(null);
            this.clearChildCB(3);
        } else if (n == 3) {
            this.portCB.setSelectedItem(null);
            if (this.framingType == 0) {
                this.clearChildCB(4);
            } else if (this.framingType == 1) {
                this.clearChildCB(6);
            } else if (this.framingType == 2) {
                this.clearChildCB(6);
            }
        } else if (n == 4) {
            this.startingStsCB.setSelectedItem(null);
            this.endingStsCB.setSelectedItem(null);
            this.clearChildCB(5);
        } else if (n == 5) {
            this.startingVtCB.setSelectedItem(null);
            this.endingVtCB.setSelectedItem(null);
        } else if (n == 6) {
            this.startingVc4CB.setSelectedItem(null);
            this.endingVc4CB.setSelectedItem(null);
            this.clearChildCB(7);
        } else if (n == 7) {
            this.startingVc3CB.setSelectedItem(null);
            this.endingVc3CB.setSelectedItem(null);
            this.clearChildCB(8);
        } else if (n == 8) {
            this.startingTug2CB.setSelectedItem(null);
            this.endingTug2CB.setSelectedItem(null);
            this.clearChildCB(9);
        } else if (n == 9) {
            this.startingVc12CB.setSelectedItem(null);
            this.endingVc12CB.setSelectedItem(null);
        }
    }

    void setNode(INodeModel iNodeModel) {
        if (iNodeModel == null) {
            return;
        }
        if (iNodeModel.equals(this.nodeModel)) {
            return;
        }
        this.nodeModel = iNodeModel;
        this.parent.setRollNode(this.nodeModel);
        if (iNodeModel != null && !iNodeModel.getConnectionState()) {
            this.clearNode(iNodeModel.getName() + " is disconnected. No endpoints are available.");
        } else {
            try {
                this.setFramingType(iNodeModel);
                this.updateSlots(iNodeModel);
                this.createAllPathPanels();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.clearNode(exception);
            }
        }
    }

    private void updateNodes() {
        LinkedList<INodeModel> linkedList = new LinkedList<INodeModel>();
        if (this.fromTo == 1) {
            INetElement[] iNetElementArray = Network.instance().getElements().toArray(new INetElement[0]);
            for (int i = 0; i < iNetElementArray.length; ++i) {
                INetElement iNetElement = iNetElementArray[i];
                INodeModel iNodeModel = iNetElement.getNodeModel();
                linkedList.add(iNodeModel);
            }
        } else {
            linkedList.add(this.parent.getRollNode());
        }
        this.rollNodeCB.setModel(new DefaultComboBoxModel<Object>(linkedList.toArray()));
        this.rollNodeCB.setSelectedItem(null);
    }

    private void updateSlots(INodeModel iNodeModel) {
        if (iNodeModel == null) {
            return;
        }
        List list = this.rollValidator.getValidRollSlots(iNodeModel);
        this.slotCB.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.slotCB.setSelectedItem(null);
        this.portCB.setSelectedItem(null);
        this.slotCB.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.slotCB.setSelectedItem(null);
    }

    private void updatePorts(IEntityModel iEntityModel) {
        if (iEntityModel == null) {
            return;
        }
        List list = this.rollValidator.getValidRollPorts(iEntityModel);
        this.portCB.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.portCB.setSelectedItem(null);
    }

    protected INodeModel getRollNode() {
        return (INodeModel)this.rollNodeCB.getSelectedItem();
    }

    void reset() {
    }

    private void clearNode(final Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string = "Node Selection Error";
                BulkRollEndpointPane.this.rollNodeCB.setSelectedItem(null);
                ErrorMsg.displayDetailed((Component)((Object)BulkRollEndpointPane.this), NEMC.EID_NODE_SELECTION_ERROR, object.toString());
            }
        });
    }

    private int getHoNum() {
        int n = 0;
        IEntityModel iEntityModel = (IEntityModel)this.portCB.getSelectedItem();
        int n2 = iEntityModel.getEqType();
        if (n2 == 114) {
            n = 1;
        } else if (n2 == 28) {
            n = 3;
        } else if (n2 == 29) {
            n = 12;
        } else if (n2 == 30) {
            n = 48;
        } else if (n2 == 61) {
            n = 192;
        }
        return n;
    }

    private void updateSonetPaths() {
        int n = this.getHoNum();
        SonetHoNum[] sonetHoNumArray = new SonetHoNum[n];
        for (int i = 0; i < n; ++i) {
            SonetHoNum sonetHoNum;
            sonetHoNumArray[i] = sonetHoNum = new SonetHoNum(i + 1);
        }
        this.startingStsCB.setModel(new DefaultComboBoxModel<SonetHoNum>(sonetHoNumArray));
        this.endingStsCB.setModel(new DefaultComboBoxModel<SonetHoNum>(sonetHoNumArray));
        SonetLoNum[] sonetLoNumArray = new SonetLoNum[28];
        for (int i = 0; i < 28; ++i) {
            SonetLoNum sonetLoNum;
            sonetLoNumArray[i] = sonetLoNum = HoLoFactory.createSonetLoNum((ICircuitSize)CircuitSize.SIZE_VT_1_5, i + 1);
        }
        this.startingVtCB.setModel(new DefaultComboBoxModel<SonetLoNum>(sonetLoNumArray));
        this.endingVtCB.setModel(new DefaultComboBoxModel<SonetLoNum>(sonetLoNumArray));
    }

    private void updateSdhAu4Paths() {
        int n = this.getHoNum();
        int n2 = n / 3;
        Integer[] integerArray = new Integer[n2];
        for (int i = 0; i < n2; ++i) {
            Integer n3;
            integerArray[i] = n3 = new Integer(i + 1);
        }
        this.startingVc4CB.setModel(new DefaultComboBoxModel<Integer>(integerArray));
        this.endingVc4CB.setModel(new DefaultComboBoxModel<Integer>(integerArray));
        this.startingVc3CB.setModel(new DefaultComboBoxModel<Integer>(this.tug3Arr));
        this.endingVc3CB.setModel(new DefaultComboBoxModel<Integer>(this.tug3Arr));
        this.startingTug2CB.setModel(new DefaultComboBoxModel<Integer>(this.tug2Arr));
        this.endingTug2CB.setModel(new DefaultComboBoxModel<Integer>(this.tug2Arr));
        this.startingVc12CB.setModel(new DefaultComboBoxModel<Integer>(this.vc12Arr));
        this.endingVc12CB.setModel(new DefaultComboBoxModel<Integer>(this.vc12Arr));
    }

    public void apply() throws Exception {
    }

    public void validatePage() throws Exception {
        if (this.rollNodeCB.getSelectedItem() == null) {
            throw new Exception("Please select a roll node.");
        }
        if (this.portCB.getSelectedItem() == null) {
            throw new Exception("Please select a roll port.");
        }
    }

    public void refresh() {
        this.updateNodes();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.rollNodeCB) {
            this.setNode((INodeModel)this.rollNodeCB.getSelectedItem());
            this.clearChildCB(2);
        } else if (object == this.slotCB) {
            this.updatePorts((IEntityModel)this.slotCB.getSelectedItem());
            this.clearChildCB(3);
        } else if (object == this.portCB) {
            IEntityModel iEntityModel = (IEntityModel)this.portCB.getSelectedItem();
            if (iEntityModel != null) {
                if (this.framingType == 0) {
                    this.updateSonetPaths();
                    this.clearChildCB(4);
                } else {
                    this.updateSdhAu4Paths();
                    this.clearChildCB(6);
                }
            }
        } else if (object == this.startingStsCB || object == this.endingStsCB) {
            this.clearChildCB(5);
        } else if (object == this.startingVc4CB || object == this.endingVc4CB) {
            this.clearChildCB(7);
        } else if (object == this.startingVc3CB || object == this.endingVc3CB) {
            this.clearChildCB(8);
        } else if (object == this.startingTug2CB || object == this.endingTug2CB) {
            this.clearChildCB(9);
        }
    }
}

