/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.INodeModel;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NodeSelector;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AutorangeInfo;
import cerent.cms.ui.circuits.CcdXmPortsSelectionPanel;
import cerent.cms.ui.circuits.UnprotectedToUpsrDialog;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.util.AnnotatedException;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CcdConversionCktPane
extends WzCcdPane {
    public static final String ConvCkt = "Transmux Conversion Circuit";
    private JPanel leftPanel;
    protected NodeSelector nodeCB;
    protected CcdXmPortsSelectionPanel mainPanel;
    private boolean needEndpoints;
    CcdConversionCktPane excludePane;
    INodeModel nodeModel;
    INodeModel lastNodeModel;
    CircuitCreatInfo circuitInfo;
    boolean dropProtection;
    CircuitCreatInfo defaultCircuitInfo = new CircuitCreatInfo(1, 1, 1);
    List availPorts;

    public CcdConversionCktPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string) {
        super(abstractCircuitDialog, wzDiagDebug, string);
    }

    protected void initPane() {
        this.setLayout(new GridLayout(1, 0));
        this.leftPanel = CcdConversionCktPane.createVerticalPanel(null);
        this.add(this.leftPanel);
        this.add(CcdConversionCktPane.createVerticalPanel(null));
        JPanel jPanel = CcdConversionCktPane.createHorizontalPanel(null);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(new JLabel("Node: ", 4));
        this.nodeCB = new NodeSelector();
        jPanel.add((Component)((Object)this.nodeCB));
        this.nodeCB.addActionListener(this);
        this.leftPanel.add(jPanel);
        this.reset();
        this.setDefaultCircuitAttributes(this.getAbstractCktDlg().getDropProtection());
    }

    void reset() {
        this.needEndpoints = false;
        if (this.db.on()) {
            this.db.println("Transmux Conversion Circuit reset: nodeModel = null");
        }
        this.nodeModel = null;
        this.lastNodeModel = null;
        this.availPorts = new ArrayList();
        if (this.mainPanel != null) {
            this.mainPanel.reset();
        }
        this.nodeCB.setEnabled(true);
    }

    void presetNodeSelector(INodeModel iNodeModel) {
        this.nodeCB.setSelectedItem(iNodeModel);
        this.nodeCB.setEnabled(false);
    }

    public INetCircuit getCircuit() {
        return this.getAbstractCktDlg().getCircuit();
    }

    public void setCircuitAttributes(CircuitCreatInfo circuitCreatInfo, boolean bl) {
        this.circuitInfo = circuitCreatInfo;
        this.dropProtection = bl;
    }

    public void setDefaultCircuitAttributes(boolean bl) {
        this.circuitInfo = this.defaultCircuitInfo;
        this.dropProtection = bl;
    }

    public void setLastNode(INodeModel iNodeModel) {
        this.lastNodeModel = iNodeModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        INodeModel iNodeModel;
        Object object = actionEvent.getSource();
        if (object == this.nodeCB && (iNodeModel = (INodeModel)this.nodeCB.getSelectedItem()) != null) {
            this.setNode(iNodeModel);
        }
    }

    protected void setEndpointPanel(INodeModel iNodeModel) {
        if (iNodeModel == null) {
            return;
        }
        if (iNodeModel.getTdmProtocolTypeObj().isSonet()) {
            this.mainPanel = new CcdXmPortsSelectionPanel(ConvCkt, this.getAbstractCktDlg(), this);
            this.leftPanel.add(this.mainPanel);
        }
        this.updateEndpointPanel(this.needEndpoints);
    }

    public void setFinishedEnabled(boolean bl) {
        this.getAbstractCktDlg().setFinishEnabled(bl);
    }

    void setNode(INodeModel iNodeModel) {
        if (iNodeModel == this.nodeModel) {
            if (this.db.on()) {
                this.db.println("Transmux Conversion Circuit setNode: NOP, returning");
            }
            return;
        }
        this.nodeModel = iNodeModel;
        if (this.db.on()) {
            this.db.println("Transmux Conversion Circuit setNode: nodeModel = " + this.nodeModel);
        }
        if (iNodeModel != null && !iNodeModel.getConnectionState()) {
            if (this.db.on()) {
                this.db.println("Transmux Conversion Circuit setNode: " + iNodeModel + " is disconnected");
            }
            this.clearNode(iNodeModel.getName() + " is disconnected. No endpoints are available.");
        } else if (this.needEndpoints) {
            try {
                this.updateAvailPorts(iNodeModel);
                if (this.mainPanel == null && iNodeModel != null) {
                    this.setEndpointPanel(iNodeModel);
                }
                if (this.mainPanel != null) {
                    this.mainPanel.setNode(iNodeModel);
                }
            }
            catch (AnnotatedException annotatedException) {
                this.clearNode((Object)annotatedException);
            }
        }
    }

    private void clearNode(final Object object) {
        if (this.db.on()) {
            this.db.println("Transmux Conversion Circuit clearNode: " + object.toString());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CcdConversionCktPane.this.db.on()) {
                    CcdConversionCktPane.this.db.println("Transmux Conversion Circuit Runnable: clearing node");
                }
                if (CcdConversionCktPane.this.nodeModel != null) {
                    String string = "Node Selection Error";
                    CcdConversionCktPane.this.nodeCB.setSelectedItem(null);
                    ErrorMsg.displayDetailed((Component)CcdConversionCktPane.this, NEMC.EID_NODE_SELECTION_ERROR, object.toString());
                }
            }
        });
    }

    public void excludeEndpoints(CcdConversionCktPane ccdConversionCktPane) {
        this.excludePane = ccdConversionCktPane;
    }

    public CcdXmPortsSelectionPanel getMainPanel() {
        return this.mainPanel;
    }

    public String getEndpointName() {
        return ConvCkt;
    }

    public JComboBox getNodeCB() {
        return this.nodeCB;
    }

    public void validatePage() throws Exception {
        if (this.nodeModel == null) {
            throw new Exception("The" + ConvCkt.toLowerCase() + " node must be selected.");
        }
        this.lastNodeModel = this.nodeModel;
        if (this.needEndpoints) {
            this.mainPanel.validatePage();
        }
        if (this.getCircuit() != null && this.parent != null) {
            INetCircuitEnd[] iNetCircuitEndArray = this.getMainPanel().getXmCircuitEnds();
            if (iNetCircuitEndArray != null) {
                this.getAbstractCktDlg().getCircuit().setXmCircuitEnds(iNetCircuitEndArray);
                AutorangeInfo autorangeInfo = this.getAutorangeInfo();
                if (autorangeInfo != null) {
                    autorangeInfo.vtAndDs3MappedList = this.getMainPanel().getVtAndDs3MappedList();
                    autorangeInfo.mappedNodeModel = this.getMainPanel().getMappedNodeModel();
                    autorangeInfo.ds3Sts = this.getMainPanel().getDs3Sts();
                    if (this.db.on()) {
                        for (int i = 0; i < autorangeInfo.vtAndDs3MappedList.size(); ++i) {
                            this.db.println("mapped VT/DS3 list is #" + i + " is " + autorangeInfo.vtAndDs3MappedList.get(i));
                        }
                        this.db.println("Mapped node model is " + autorangeInfo.mappedNodeModel);
                        this.db.println("Ds3STS Flag is " + autorangeInfo.ds3Sts);
                    }
                }
            }
            if (!this.getAbstractCktDlg().isUrn()) {
                this.getAbstractCktDlg().deleteDestination();
                this.getAbstractCktDlg().addDestination(true);
            }
        }
    }

    protected String getNextPaneName() {
        if (this.getAbstractCktDlg().isUrn()) {
            this.getAbstractCktDlg();
            return "Circuit Constraints For Automatic Routing";
        }
        this.getAbstractCktDlg();
        return "Route Review/Edit";
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCircuit() == null ? "\nFrom: " : "\nTo: ");
        stringBuffer.append(this.nodeModel.getName());
        if (this.needEndpoints) {
            stringBuffer.append("/");
            stringBuffer.append(this.mainPanel.getStatusText());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void revalidateData() {
        this.needEndpoints = true;
        List list = this.availPorts;
        this.updateNodeList();
        if (this.lastNodeModel != null) {
            if (this.db.on()) {
                this.db.println("Transmux Conversion Circuit refresh: lastNodeModel = " + this.lastNodeModel);
            }
            if (((DefaultComboBoxModel)this.nodeCB.getModel()).getIndexOf(this.lastNodeModel) < 0) {
                if (this.db.on()) {
                    this.db.println("The original node is not available any more.");
                }
                this.lastNodeModel = null;
            }
            this.nodeCB.setSelectedItem(this.lastNodeModel);
        } else {
            if (this.db.on()) {
                this.db.println("Transmux Conversion Circuit refresh: nodeModel = " + this.nodeModel);
            }
            this.nodeCB.setSelectedItem(this.nodeModel);
        }
        if (list == this.availPorts) {
            if (this.db.on) {
                this.db.println("Transmux Conversion Circuit refresh: calling updateAvailPorts");
            }
            try {
                this.updateAvailPorts(this.nodeModel);
            }
            catch (AnnotatedException annotatedException) {
                this.clearNode((Object)annotatedException);
            }
        }
        list = null;
        if (this.needEndpoints) {
            this.updateEndpointPanel(this.needEndpoints);
            if (this.mainPanel != null) {
                this.mainPanel.refresh();
            }
        } else if (this.mainPanel != null) {
            this.mainPanel.setVisible(false);
        }
    }

    private void updateEndpointPanel(boolean bl) {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.circuitInfo.type());
        if (bl && this.mainPanel != null) {
            this.mainPanel.setVisible(true);
        }
    }

    public void enteringPane() {
        super.enteringPane();
        if (!this.getAbstractCktDlg().isUrn() && !this.getAbstractCktDlg().isRrbc()) {
            this.setFinishEnabled();
        }
    }

    private void setFinishEnabled() {
        if (this.parent != null) {
            boolean bl = true;
            this.getAbstractCktDlg().setFinishEnabled(bl);
            this.getAbstractCktDlg().setNextEnabled(!bl);
        }
    }

    public void setNodeList(List list) {
        this.nodeCB.removeActionListener(this);
        this.nodeCB.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.nodeCB.addActionListener(this);
        this.nodeCB.setSelectedItem(null);
    }

    private void updateAvailPorts(INodeModel iNodeModel) throws AnnotatedException {
        if (this.db.on()) {
            this.db.println("Transmux Conversion Circuit updateAvailPorts");
        }
        this.availPorts = new ArrayList();
        if (iNodeModel == null) {
            if (this.db.on()) {
                this.db.println("Transmux Conversion Circuit updateAvailPorts: got 0 ports from null nodeModel");
            }
            return;
        }
        try {
            this.availPorts = NetCircuitManager.instance().getAvailSourcePorts(iNodeModel, this.circuitInfo, this.dropProtection);
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while getting the list of available ports from the node " + iNodeModel.getName() + ".", exception);
        }
    }

    public boolean handleBack() {
        this.db.fine("handleBack() is called");
        if (this.getAbstractCktDlg().getCircuit().getState() == 0 || this.getAbstractCktDlg().getCircuit().getState() == 1) {
            INetCircuitEnd[] iNetCircuitEndArray = null;
            this.getAbstractCktDlg().getCircuit().setXmCircuitEnds(iNetCircuitEndArray);
        }
        if (this.getAbstractCktDlg() instanceof UnprotectedToUpsrDialog) {
            ((UnprotectedToUpsrDialog)this.getAbstractCktDlg()).removeAlternatePath();
        }
        return super.handleBack();
    }

    public void close() {
        this.db.fine("close() is called");
        this.nodeCB.hidePopup();
        if (this.mainPanel != null) {
            this.mainPanel.close();
        }
    }

    public void recycle() {
        this.db.fine("recycle() is called");
        this.excludePane = null;
        if (this.mainPanel != null) {
            this.mainPanel.recycle();
            this.mainPanel = null;
        }
        if (this.availPorts != null) {
            this.availPorts.clear();
        }
        this.circuitInfo = null;
        this.nodeModel = null;
        this.lastNodeModel = null;
        this.parent = null;
        if (this.nodeCB != null) {
            this.nodeCB.removeActionListener(this);
            this.nodeCB.removeAll();
            this.nodeCB = null;
        }
        this.removeAll();
    }

    protected void updateNodeList() {
        this.nodeCB.removeActionListener(this);
        this.nodeCB.updateNodeList(this.circuitInfo, this.getCircuit());
        this.nodeCB.addActionListener(this);
        this.nodeCB.setSelectedItem(null);
    }

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Please fill in values for the CcdConversionCktPane.\n");
        return stringBuffer.toString();
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdConversionCktPane;
    }
}

