/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPlimTrkLineModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchTrailAttrsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.IOchCircuit;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.TrkAttribOperator;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdOchAttrsTableModel;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class CcdOchAttrsPane
extends WzCcdPane {
    private JPanel trunkTablePanel;
    private ProtectionAttr protectionAttr;
    private CcdOchAttrsTableModel tableModel;
    private OchTrailAttrsHelper.TrunkInfo trunkInfo;
    private OchTrailAttrsHelper.ProtectionInfo protectionInfo;
    private IEntityModel trkSrcModel;
    private IEntityModel trkDstModel;
    private UTable table;
    boolean disableOTNProvisioning = false;
    private UComboBox otnStatusCB;
    private UComboBox fecCB;
    private UComboBox sdBerCB;
    private UComboBox mappingCB;
    private boolean isOc768 = false;

    public CcdOchAttrsPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdOchAttrsPane;
    }

    public void enteringPane() {
        super.enteringPane();
        TablePropertyMgr.getColumnPrefs((JTable)this.table, "CcdOchAttrsPane");
        if (!this.goingForward) {
            try {
                this.restoreAll();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public boolean handleBack() {
        AbstractCircuitDialog abstractCircuitDialog = this.getAbstractCktDlg();
        if (abstractCircuitDialog.getCircuit().getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            try {
                abstractCircuitDialog.deleteDestination();
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.println("Delete destination failed: " + exception.getMessage());
                }
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_DELETE_DESTINATION_FAILED);
            }
        }
        return super.handleBack();
    }

    public void handleCancel() {
        try {
            this.restoreAll();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void setUpCombo() throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface, WrongInterfaceType {
        IPortModel iPortModel = null;
        if (!this.areTrunkAttrsApplicable(this.trkSrcModel) && !this.areTrunkAttrsApplicable(this.trkDstModel)) {
            iPortModel = (IPortModel)this.trkSrcModel;
            this.disableOTNProvisioning = true;
        } else {
            iPortModel = !this.areTrunkAttrsApplicable(this.trkSrcModel) ? (IPortModel)this.trkSrcModel : (!this.areTrunkAttrsApplicable(this.trkDstModel) ? (IPortModel)this.trkDstModel : (IPortModel)this.trkSrcModel);
        }
        OchTrailAttrsHelper.TrunkInfo trunkInfo = OchTrailAttrsHelper.getTrunkAttrs((IEntityModel)iPortModel);
        this.otnStatusCB.setSelectedItem((Object)(trunkInfo.isG709() ? OchTrailAttrsHelper.OTNStatus.OTN_ENABLE : OchTrailAttrsHelper.OTNStatus.OTN_DISABLE));
        this.sdBerCB.setSelectedItem((Object)OchTrailAttrsHelper.SdBerValues.getSdBerValue(trunkInfo.getSdBer()));
        this.mappingCB.setSelectedItem((Object)OchTrailAttrsHelper.Mapping.getMapping(trunkInfo.getMappingType()));
        IPortModel iPortModel2 = (IPortModel)this.trkDstModel;
        if (iPortModel.getEqType() == 291 && iPortModel2.getEqType() == 291 && (iPortModel.getModuleModel().getEqType() == 292 || iPortModel.getModuleModel().getEqType() == 320 || iPortModel2.getModuleModel().getEqType() == 292 || iPortModel2.getModuleModel().getEqType() == 320)) {
            this.fecCB.setSelectedItem((Object)OchTrailAttrsHelper.FecValues.FEC_ENHANCED);
            this.isOc768 = true;
        } else {
            this.fecCB.setSelectedItem((Object)OchTrailAttrsHelper.FecValues.getFecValue(trunkInfo.getFecMode()));
        }
        if (this.disableOTNProvisioning) {
            this.otnStatusCB.setEnabled(false);
            this.fecCB.setEnabled(false);
            this.sdBerCB.setEnabled(false);
            this.mappingCB.setEnabled(false);
        } else {
            this.otnStatusCB.setEnabled(true);
            this.fecCB.setEnabled(!this.isOc768 && trunkInfo.isG709());
            this.sdBerCB.setEnabled(true);
            this.mappingCB.setEnabled(true);
        }
    }

    private void setUpProtectionPane() throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface, AbstractCmsNoSuchElementException {
        boolean bl = this.isProtected();
        this.protectionAttr.setupProtection(bl);
        if (bl) {
            boolean bl2 = false;
            int n = 300;
            bl2 = this.tableModel.getRevertive(1);
            n = this.tableModel.getReversionTime(1);
            if (!bl2) {
                bl2 = this.tableModel.getRevertive(0);
                n = this.tableModel.getReversionTime(0);
            }
            if (bl2) {
                this.protectionAttr.setRevertiveCheckBoxEnable(bl2);
                this.protectionAttr.setReversionComboTime(n);
            }
        } else {
            this.protectionAttr.setRevertiveCheckBoxEnable(false);
        }
    }

    public void revalidateData() {
        super.revalidateData();
        boolean bl = false;
        Exception exception = null;
        try {
            IEntityModel iEntityModel = this.getAbstractCktDlg().getSource().getEntityModel();
            IEntityModel iEntityModel2 = this.getAbstractCktDlg().getDest().getEntityModel();
            this.trkSrcModel = OchTrailHelper.getTrunkPorts(iEntityModel)[0];
            this.trkDstModel = OchTrailHelper.getTrunkPorts(iEntityModel2)[0];
            boolean bl2 = this.isProtected() && !OchTrailAttrsHelper.isTrunkInUse(this.trkSrcModel) && !OchTrailAttrsHelper.isTrunkInUse(this.trkDstModel);
            this.tableModel.updateModel(new IEntityModel[]{this.trkSrcModel, this.trkDstModel}, bl2);
            this.setUpCombo();
            this.setUpProtectionPane();
        }
        catch (Exception exception2) {
            exception = exception2;
            bl = true;
            SDebug.printStackTrace((Throwable)exception2);
        }
        if (bl) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CANNOT_FIND_TRUNK_MODEL, (Object)exception.toString());
            return;
        }
    }

    public void validatePage() throws Exception {
        INetCircuit iNetCircuit;
        TablePropertyMgr.setColumnPrefs((JTable)this.table, "CcdOchAttrsPane");
        this.setTrunkInfo(new OchTrailAttrsHelper.TrunkInfo(this.otnStatusCB.getSelectedItem().equals((Object)OchTrailAttrsHelper.OTNStatus.OTN_ENABLE), ((OchTrailAttrsHelper.FecValues)((Object)this.fecCB.getSelectedItem())).getValue(), ((OchTrailAttrsHelper.SdBerValues)((Object)this.sdBerCB.getSelectedItem())).getValue(), ((OchTrailAttrsHelper.Mapping)((Object)this.mappingCB.getSelectedItem())).getValue()));
        this.saveTrunkAttrs(this.trkSrcModel, this.trkDstModel);
        if (this.isProtected() && this.areReversionAttrsApplicable(this.trkSrcModel) && this.areReversionAttrsApplicable(this.trkDstModel)) {
            this.setProtectionInfo(new OchTrailAttrsHelper.ProtectionInfo(true, this.protectionAttr.getRevertiveBehavior()));
            this.saveReversionAttrs(this.trkSrcModel, this.trkDstModel);
        }
        if ((iNetCircuit = this.getAbstractCktDlg().getCircuit()).getCircuitTypeObj().isOchTrailTunnelCircuitType() && iNetCircuit.getCircuitSpanNum() == 0) {
            CircuitCreationDialog circuitCreationDialog = (CircuitCreationDialog)this.getAbstractCktDlg();
            circuitCreationDialog.addDestinationToOchTrail();
        }
    }

    protected void handleNextException(Exception exception) {
        try {
            this.restoreAll();
        }
        catch (Exception exception2) {
            SDebug.printStackTrace((Throwable)exception2);
        }
        super.handleNextException(exception);
    }

    private boolean areTrunkAttrsApplicable(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface {
        IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
        if (iInterfaceModel instanceof IPlimTrkLineModel) {
            return true;
        }
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        if (iModuleModel instanceof IDwdmModuleModel && !((IDwdmModuleModel)iModuleModel).supportsOTN()) {
            return false;
        }
        if (OchTrailHelper.isLineCard(iEntityModel)) {
            if (this.db.on()) {
                this.db.println("areTrunkAttrsApplicable - Not Applicable: The Trunk is not a line card; Port: " + iEntityModel);
            }
            return false;
        }
        if (OchTrailAttrsHelper.isTrunkInUse(iEntityModel)) {
            if (this.db.on()) {
                this.db.println("areTrunkAttrsApplicable - Not Applicable: The Trunk port already belongs to another OchTrailTunnelNetLink; Port: " + iEntityModel);
            }
            return false;
        }
        return true;
    }

    private boolean areReversionAttrsApplicable(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface {
        if (iEntityModel == null || !OchTrailHelper.isProtected(iEntityModel)) {
            if (this.db.on()) {
                this.db.println("areReversionAttrsApplicable - Not Applicable: The Trunk is not protected; Port: " + iEntityModel);
            }
            return false;
        }
        return true;
    }

    private void saveTrunkAttrs(IEntityModel iEntityModel, IEntityModel iEntityModel2) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, DetailedConfigError, NoSuchInterface, WrongInterfaceType, ConfigError, ObjNotFound, ProvisionError {
        if (this.trkSrcModel != null && this.trkDstModel != null) {
            TrkAttribOperator trkAttribOperator = ((IOchCircuit)((Object)this.getAbstractCktDlg().getCircuit())).getTrkAttribOperator();
            if (trkAttribOperator != null) {
                trkAttribOperator.saveTrunkAttrs(this.trkSrcModel, this.trkDstModel, this.getTrunkInfo());
            }
        } else {
            throw new ObjNotFound("Unable to find the src and dst Trunk Ports.");
        }
    }

    private void saveReversionAttrs(IEntityModel iEntityModel, IEntityModel iEntityModel2) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, AbstractCmsNoSuchElementException, ObjNotFound {
        if (!this.isProtected()) {
            return;
        }
        if (this.trkSrcModel != null && this.trkDstModel != null) {
            TrkAttribOperator trkAttribOperator = ((OchccCircuit)this.getAbstractCktDlg().getCircuit()).getTrkAttribOperator();
            if (trkAttribOperator != null) {
                trkAttribOperator.saveReversions(this.trkSrcModel, this.trkDstModel, this.getProtectionInfo().getRevertiveBehavior());
            }
        } else {
            throw new ObjNotFound("Unable to find the src and dst Trunk Ports.");
        }
    }

    private void restoreTrunkAttrs() throws Exception {
        TrkAttribOperator trkAttribOperator = ((IOchCircuit)((Object)this.getAbstractCktDlg().getCircuit())).getTrkAttribOperator();
        if (trkAttribOperator != null) {
            trkAttribOperator.clearTrunkAttrs();
        }
    }

    private void restoreReversionAttrs() throws Exception {
        TrkAttribOperator trkAttribOperator;
        if (this.isProtected() && (trkAttribOperator = ((OchccCircuit)this.getAbstractCktDlg().getCircuit()).getTrkAttribOperator()) != null) {
            trkAttribOperator.clearReversions();
        }
    }

    public void restoreAll() throws Exception {
        if (this.trkSrcModel == null || this.trkDstModel == null) {
            throw new ObjNotFound("Unable to find the src and dst Ports.");
        }
        this.restoreTrunkAttrs();
        this.restoreReversionAttrs();
    }

    protected String getNextPaneName() {
        return "OCH Circuit Routing Preferences";
    }

    protected void initPane() {
        Object object;
        Object object2;
        Object object3;
        this.setLayout(new BorderLayout());
        this.trunkTablePanel = CcdOchAttrsPane.createVerticalPanel("Trunk Setting");
        JPanel jPanel = CcdOchAttrsPane.createVerticalPanel("Current Values");
        JPanel jPanel2 = CcdOchAttrsPane.createVerticalPanel("Provisioning Values");
        try {
            object3 = this.getAbstractCktDlg().getSource().getEntityModel();
            object2 = this.getAbstractCktDlg().getDest().getEntityModel();
            this.trkSrcModel = OchTrailHelper.getTrunkPorts(object3)[0];
            this.trkDstModel = OchTrailHelper.getTrunkPorts(object2)[0];
            this.initTable();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        catch (NoSuchEquipment noSuchEquipment) {
            SDebug.printStackTrace((Throwable)noSuchEquipment);
        }
        catch (ObjNotFound objNotFound) {
            SDebug.printStackTrace((Throwable)objNotFound);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        this.table.setPreferredScrollableViewportSize(new Dimension(this.table.getPreferredSize().width, 70));
        object3 = new JScrollPane((Component)this.table);
        jPanel.add((Component)object3);
        object2 = new JLabel("ITU-T G.709 OTN: ");
        IInterfaceModel iInterfaceModel = ((IPortModel)this.trkSrcModel).getInterfaceModel();
        if (iInterfaceModel instanceof IPlimTrkLineModel) {
            object = new OchTrailAttrsHelper.OTNStatus[]{OchTrailAttrsHelper.OTNStatus.OTN_ENABLE};
            this.otnStatusCB = new UComboBox((Object[])object);
        } else {
            this.otnStatusCB = new UComboBox((Object[])OchTrailAttrsHelper.OTNStatus.values());
        }
        this.otnStatusCB.addActionListener((ActionListener)this);
        object = new JLabel("FEC: ");
        this.fecCB = new UComboBox((Object[])OchTrailAttrsHelper.FecValues.values());
        JLabel jLabel = new JLabel("SD BER: ");
        this.sdBerCB = new UComboBox((Object[])OchTrailAttrsHelper.SdBerValues.values());
        JLabel jLabel2 = new JLabel("Mapping: ");
        this.mappingCB = new UComboBox((Object[])OchTrailAttrsHelper.getAvailableMapping(this.tableModel.getMappingDataTypeFirstTrunk(), this.tableModel.getMappingDataTypeSecondTrunk()));
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel3 = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0);
        jPanel3.add((Component)object2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 15);
        jPanel3.add((Component)this.otnStatusCB, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        jPanel3.add((Component)object, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(0, 5, 5, 15);
        jPanel3.add((Component)this.fecCB, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        jPanel3.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.insets = new Insets(0, 5, 5, 15);
        jPanel3.add((Component)this.sdBerCB, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 0, 5, 5);
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 5, 5, 15);
        jPanel3.add((Component)this.mappingCB, gridBagConstraints);
        jPanel2.add(jPanel3);
        this.trunkTablePanel.add(jPanel);
        this.trunkTablePanel.add(jPanel2);
        this.add((Component)this.trunkTablePanel, "Center");
        this.protectionAttr = new ProtectionAttr();
        this.add((Component)this.protectionAttr.getUI(), "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.otnStatusCB) {
            UComboBox uComboBox = (UComboBox)object;
            Object object2 = uComboBox.getSelectedItem();
            if (object2.equals((Object)OchTrailAttrsHelper.OTNStatus.OTN_DISABLE)) {
                this.fecCB.setSelectedItem((Object)OchTrailAttrsHelper.FecValues.FEC_DISABLE);
                this.fecCB.setEnabled(false);
            } else if (!this.isOc768) {
                this.fecCB.setEnabled(true);
            }
        }
    }

    private void initTable() throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface, ObjNotFound {
        this.tableModel = new CcdOchAttrsTableModel(new IEntityModel[]{this.trkSrcModel, this.trkDstModel});
        this.table = new UTable((TableModel)this.tableModel);
        this.table.getColumnModel().getColumn(0).setCellRenderer(this.table.getTableHeader().getDefaultRenderer());
    }

    private CircuitCreatInfo getCircuitInfo() {
        return this.parent == null ? null : this.getAbstractCktDlg().getCircuitInfo();
    }

    private boolean isProtected() {
        return this.getCircuitInfo().isProtected() && (this.trkSrcModel == null || !OchTrailHelper.isProtectedOCHNCService(this.trkSrcModel));
    }

    public OchTrailAttrsHelper.ProtectionInfo getProtectionInfo() {
        return this.protectionInfo;
    }

    public void setProtectionInfo(OchTrailAttrsHelper.ProtectionInfo protectionInfo) {
        this.protectionInfo = protectionInfo;
    }

    public OchTrailAttrsHelper.TrunkInfo getTrunkInfo() {
        return this.trunkInfo;
    }

    public void setTrunkInfo(OchTrailAttrsHelper.TrunkInfo trunkInfo) {
        this.trunkInfo = trunkInfo;
    }

    class ProtectionAttr {
        private boolean isProtected;
        RevertiveBehaviorPanel revertiveBehaviorPanel;
        private JPanel p = new JPanel();

        ProtectionAttr() {
            this.p.setLayout(new BorderLayout());
            this.p.setBorder(BorderFactory.createTitledBorder("Protection"));
            this.revertiveBehaviorPanel = new RevertiveBehaviorPanel(null);
            this.p.add((Component)this.revertiveBehaviorPanel, "Center");
        }

        protected void setupProtection(boolean bl) {
            this.revertiveBehaviorPanel.setRevertiveEnabled(bl);
        }

        public JPanel getUI() {
            return this.p;
        }

        public boolean isProtected() {
            return this.isProtected;
        }

        public boolean isRevertive() {
            IRevertiveBehavior iRevertiveBehavior = this.revertiveBehaviorPanel.getRevertiveBehavior();
            return iRevertiveBehavior.getReversionMode() == 2;
        }

        public void setRevertiveCheckBoxEnable(boolean bl) {
            this.revertiveBehaviorPanel.setRevertive(bl);
        }

        public void setReversionComboTime(int n) {
            this.revertiveBehaviorPanel.setReversionTime(n);
        }

        public int getRevertiveTime() {
            return this.revertiveBehaviorPanel.getReversionTime();
        }

        public IRevertiveBehavior getRevertiveBehavior() {
            return this.revertiveBehaviorPanel.getRevertiveBehavior();
        }
    }
}

