/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.DwdmSideRenderer;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzStatusPanel;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdCircuitDesignPane;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.CircuitDesignMap;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.ICcdRoutePane;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.AnnotatedException;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import cerent.util.gui.GridPanel;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.OrderedListListener;
import cerent.util.gui.OrderedListModel;
import cerent.util.gui.UDialog;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LabelUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CcdOchRoutePane
extends CcdCircuitDesignPane
implements ICcdRoutePane {
    private static final String TOP_BORDER = "Selected Node: ";
    private static final String CONSTRAINTS_TAB = "Constraints";
    private static final String WRK_CONSTRAINTS_TAB = "Constraints (Working)";
    private static final String PROT_CONSTRAINTS_TAB = "Constraints (Protected)";
    private static final String SPANS_TAB = "Spans";
    private static final String INCLUDE = "Include";
    private static final String EXCLUDE = "Exclude";
    private static final String ADVANCED = "Advanced ...";
    private static final String APPLY = "Apply";
    private static final String RESET = "Reset";
    private static final String INCLUDED_BORDER = "Included Nodes: ";
    private static final String EXCLUDED_BORDER = "Excluded Nodes: ";
    private static final String EXCLUDE_LABEL = "Excluded";
    private static final String DIVERSITY_LABEL = "Node diversity";
    private static final int MAX_ROUTING_CONSTRAINTS = 5;
    private MapNode selectedMapNode;
    private INetElement srcNE;
    private INetElement dstNE;
    private boolean isRouted;
    protected RoutePrefs routePrefs;
    private String statusText;
    private JLabel descrLB;
    private JTextField dispTF;
    private JPanel divPanel;
    private JCheckBox diversityCB;
    private OrderedListModelOrganizer wrkNodesModelOrg;
    private OrderedListModelOrganizer prtNodesModelOrg = null;
    private OrderedListModel spansModel;
    private JTabbedPane tabbedPane;
    private static int BOTTOM_PANEL_HEIGTH = 300;
    private INetLink p2pLink;
    private INetCircuit ochTrailCkt;
    private static final String PREF = "ctc.CcdOchRoutePane";
    private static final String DIV_LOC = "dl";

    public CcdOchRoutePane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string, boolean bl) {
        super(abstractCircuitDialog, wzDiagDebug, string, bl);
    }

    @Override
    protected String getStatusText() {
        return this.statusText;
    }

    protected void storeStatusText() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        INetElement[] iNetElementArray = this.wrkNodesModelOrg.getIncludedNodes();
        stringBuffer.append("\nRequired Nodes:");
        if (iNetElementArray.length == 0) {
            stringBuffer.append("\n(None)");
        } else {
            for (int i = 0; i < iNetElementArray.length; ++i) {
                stringBuffer.append("\n" + iNetElementArray[i].getName());
            }
        }
        INetElement[] iNetElementArray2 = this.wrkNodesModelOrg.getExcludedNodes();
        stringBuffer.append("\n \nExcluded Nodes:");
        if (iNetElementArray2.length == 0) {
            stringBuffer.append("\n(None)");
        } else {
            for (n = 0; n < iNetElementArray2.length; ++n) {
                stringBuffer.append("\n" + iNetElementArray2[n].getName());
            }
        }
        stringBuffer.append("\n");
        if (this.prtNodesModelOrg != null) {
            iNetElementArray = this.prtNodesModelOrg.getIncludedNodes();
            stringBuffer.append("\nRequired Nodes (Protect path):");
            if (iNetElementArray.length == 0) {
                stringBuffer.append("\n(None)");
            } else {
                for (n = 0; n < iNetElementArray.length; ++n) {
                    stringBuffer.append("\n" + iNetElementArray[n].getName());
                }
            }
            iNetElementArray2 = this.prtNodesModelOrg.getExcludedNodes();
            stringBuffer.append("\n \nExcluded Nodes (Protect path):");
            if (iNetElementArray2.length == 0) {
                stringBuffer.append("\n(None)");
            } else {
                for (n = 0; n < iNetElementArray2.length; ++n) {
                    stringBuffer.append("\n" + iNetElementArray2[n].getName());
                }
            }
            stringBuffer.append("\n");
        }
        if (this.isProtectPanel()) {
            stringBuffer.append("Node diversity: " + (this.diversityCB.isSelected() ? "yes" : "no") + "\n");
        }
        this.statusText = stringBuffer.toString();
    }

    @Override
    protected JComponent getStatusComponent() {
        Object object;
        INetElement[] iNetElementArray;
        WzStatusPanel wzStatusPanel = new WzStatusPanel(false);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("Required Nodes:");
        JLabel jLabel2 = new JLabel("Excluded Nodes:");
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jLabel2.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add((Component)jLabel, "North");
        INetElement[] iNetElementArray2 = this.wrkNodesModelOrg.getIncludedNodes();
        if (iNetElementArray2.length == 0) {
            jPanel.add((Component)new JLabel("(None)"), "Center");
        } else {
            iNetElementArray = new ArrayList();
            for (int i = 0; i < iNetElementArray2.length; ++i) {
                String[] stringArray = new String[]{String.valueOf(i + 1), iNetElementArray2[i].getName()};
                iNetElementArray.add(stringArray);
            }
            object = CcdOchRoutePane.getGridPanel(iNetElementArray);
            jPanel.add((Component)object, "Center");
        }
        jPanel2.add((Component)jLabel2, "North");
        iNetElementArray = this.wrkNodesModelOrg.getExcludedNodes();
        if (iNetElementArray.length == 0) {
            jPanel2.add((Component)new JLabel("(None)"), "Center");
        } else {
            object = new ArrayList();
            for (int i = 0; i < iNetElementArray.length; ++i) {
                String[] stringArray = new String[]{String.valueOf(i + 1), iNetElementArray[i].getName()};
                ((ArrayList)object).add(stringArray);
            }
            GridPanel gridPanel = CcdOchRoutePane.getGridPanel((List)object);
            jPanel2.add((Component)gridPanel, "Center");
        }
        wzStatusPanel.push(jPanel, null, true);
        wzStatusPanel.push(new JLabel(" "), null, false);
        wzStatusPanel.push(jPanel2, null, true);
        if (this.isProtectPanel()) {
            wzStatusPanel.push(new JLabel(" "), null, false);
            wzStatusPanel.push(new JLabel("Node diversity: " + (this.diversityCB.isSelected() ? "yes" : "no")));
        }
        return wzStatusPanel;
    }

    private void initDescrLabel() {
        if (this.isForOchnc()) {
            this.descrLB.setText("OCHNC Circuit Path");
        } else if (this.isForOchTrail()) {
            this.descrLB.setText("OCH Trail Circuit Path");
        } else if (!this.isProtectPanel()) {
            if (this.isReadOnly()) {
                if (this.isForProtectOchcc()) {
                    this.descrLB.setText("OCHCC Working Path [Read-Only Mode]");
                } else {
                    this.descrLB.setText("OCHCC Path [Read-Only Mode]");
                }
            } else if (this.isForProtectOchcc()) {
                this.descrLB.setText("Routing OCH Trail Circuit for OCHCC Working Path");
            } else {
                this.descrLB.setText("Routing OCH Trail Circuit for OCHCC Path");
            }
        } else if (this.isReadOnly()) {
            this.descrLB.setText("OCHCC Protect Path [Read-Only Mode]");
        } else {
            this.descrLB.setText("Routing OCH Trail Circuit for OCHCC Protect Path");
        }
    }

    protected JPanel getTopPanel() {
        JPanel jPanel = CcdOchRoutePane.createHorizontalPanel(null);
        this.descrLB = new JLabel();
        jPanel.add(this.descrLB);
        return jPanel;
    }

    protected JPanel getBottomPanel() {
        Serializable serializable;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        jPanel.add((Component)this.tabbedPane, "Center");
        JPanel jPanel2 = this.getConstraintsPanel();
        this.tabbedPane.addTab(SPANS_TAB, this.getSpansPanel());
        if (this.isForProtectOchncService()) {
            this.tabbedPane.addTab(WRK_CONSTRAINTS_TAB, jPanel2);
            serializable = this.getProtConstraintsPanel();
            this.tabbedPane.addTab(PROT_CONSTRAINTS_TAB, (Component)serializable);
        } else {
            this.tabbedPane.addTab(CONSTRAINTS_TAB, jPanel2);
        }
        serializable = this.tabbedPane.getPreferredSize();
        ((Dimension)serializable).height = BOTTOM_PANEL_HEIGTH;
        this.tabbedPane.setMinimumSize((Dimension)serializable);
        JPanel jPanel3 = CcdOchRoutePane.createHorizontalPanel(null);
        this.dispTF = new JTextField("");
        this.dispTF.setEditable(false);
        jPanel3.add(this.dispTF);
        jPanel3.setBorder(BorderFactory.createTitledBorder(TOP_BORDER));
        jPanel.add((Component)jPanel3, "North");
        return jPanel;
    }

    private JPanel getConstraintsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getButtonPanel(), "East");
        jPanel.add((Component)this.getNodesPanel(), "Center");
        jPanel.add((Component)this.getDiversityPanel(), "South");
        return jPanel;
    }

    private JPanel getProtConstraintsPanel() {
        this.prtNodesModelOrg = new OrderedListModelOrganizer(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getPrtButtonPanel(), "East");
        jPanel.add((Component)this.getPrtNodesPanel(), "Center");
        return jPanel;
    }

    private JPanel getNodesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.wrkNodesModelOrg.constraintsSp = new JSplitPane(1);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(INCLUDED_BORDER));
        jPanel2.add((Component)new JScrollPane(this.wrkNodesModelOrg.getIncludedList()), "Center");
        this.wrkNodesModelOrg.constraintsSp.setLeftComponent(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(EXCLUDED_BORDER));
        jPanel3.add((Component)new JScrollPane(this.wrkNodesModelOrg.getExcludedList()), "Center");
        this.wrkNodesModelOrg.constraintsSp.setRightComponent(jPanel3);
        jPanel.add((Component)this.wrkNodesModelOrg.constraintsSp, "Center");
        return jPanel;
    }

    private JPanel getPrtNodesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.prtNodesModelOrg.constraintsSp = new JSplitPane(1);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(INCLUDED_BORDER));
        jPanel2.add((Component)new JScrollPane(this.prtNodesModelOrg.getIncludedList()), "Center");
        this.prtNodesModelOrg.constraintsSp.setLeftComponent(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(EXCLUDED_BORDER));
        jPanel3.add((Component)new JScrollPane(this.prtNodesModelOrg.getExcludedList()), "Center");
        this.prtNodesModelOrg.constraintsSp.setRightComponent(jPanel3);
        jPanel.add((Component)this.prtNodesModelOrg.constraintsSp, "Center");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 25, 0, 25, 0, 0, 0, 25, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0E-4};
        this.wrkNodesModelOrg = new OrderedListModelOrganizer(this);
        this.wrkNodesModelOrg.includeButton = new JButton(INCLUDE);
        this.addAndSetButton(jPanel, this.wrkNodesModelOrg.includeButton, null, 0);
        this.wrkNodesModelOrg.excludeButton = new JButton(EXCLUDE);
        this.addAndSetButton(jPanel, this.wrkNodesModelOrg.excludeButton, null, 1);
        this.wrkNodesModelOrg.advancedButton = new JButton(ADVANCED);
        this.addAndSetButton(jPanel, this.wrkNodesModelOrg.advancedButton, null, 2);
        this.upButton = this.wrkNodesModelOrg.getButton("Up");
        this.addAndSetButton(jPanel, this.upButton, null, 4);
        this.downButton = this.wrkNodesModelOrg.getButton("Down");
        this.addAndSetButton(jPanel, this.downButton, null, 5);
        this.removeButton = this.wrkNodesModelOrg.getButton("Remove");
        this.addAndSetButton(jPanel, this.removeButton, null, 6);
        this.wrkNodesModelOrg.applyButton = new JButton(APPLY);
        this.addAndSetButton(jPanel, this.wrkNodesModelOrg.applyButton, "Starts the route evaluation using the current constraints", 8);
        this.wrkNodesModelOrg.resetButton = new JButton(RESET);
        this.addAndSetButton(jPanel, this.wrkNodesModelOrg.resetButton, "Clears all constraints and evaluates the default route", 9);
        return jPanel;
    }

    private JPanel getPrtButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 25, 0, 25, 0, 0, 0, 25, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0E-4};
        this.prtNodesModelOrg.includeButton = new JButton(INCLUDE);
        this.addAndSetButton(jPanel, this.prtNodesModelOrg.includeButton, null, 0);
        this.prtNodesModelOrg.excludeButton = new JButton(EXCLUDE);
        this.addAndSetButton(jPanel, this.prtNodesModelOrg.excludeButton, null, 1);
        this.prtNodesModelOrg.advancedButton = new JButton(ADVANCED);
        this.addAndSetButton(jPanel, this.prtNodesModelOrg.advancedButton, null, 2);
        this.addAndSetButton(jPanel, this.prtNodesModelOrg.getButton("Up"), null, 4);
        this.addAndSetButton(jPanel, this.prtNodesModelOrg.getButton("Down"), null, 5);
        this.addAndSetButton(jPanel, this.prtNodesModelOrg.getButton("Remove"), null, 6);
        this.prtNodesModelOrg.applyButton = new JButton(APPLY);
        this.addAndSetButton(jPanel, this.prtNodesModelOrg.applyButton, "Starts the route evaluation using the current constraints", 8);
        this.prtNodesModelOrg.resetButton = new JButton(RESET);
        this.addAndSetButton(jPanel, this.prtNodesModelOrg.resetButton, "Clears all constraints and evaluates the default route", 9);
        return jPanel;
    }

    private void addAndSetButton(JPanel jPanel, AbstractButton abstractButton, String string, int n) {
        abstractButton.setHorizontalAlignment(0);
        abstractButton.setEnabled(false);
        abstractButton.addActionListener(this);
        if (string != null) {
            abstractButton.setToolTipText(string);
        }
        jPanel.add((Component)abstractButton, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
    }

    private JPanel getDiversityPanel() {
        this.divPanel = CcdOchRoutePane.createHorizontalPanel(null);
        this.diversityCB = new JCheckBox(DIVERSITY_LABEL, false);
        this.diversityCB.setToolTipText("Forces the protect path to exclude all passthrough nodes of the working path");
        this.divPanel.add(this.diversityCB);
        return this.divPanel;
    }

    private JPanel getSpansPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.spansModel = new OrderedListModel(this, true);
        jPanel.add((Component)new JScrollPane(this.spansModel.getJList()), "Center");
        return jPanel;
    }

    @Override
    protected void initPane() {
        this.setLayout(new BorderLayout(1, 1));
        this.add((Component)this.getTopPanel(), "North");
        this.mainSplitPane = new JSplitPane(0);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setBottomComponent(this.getBottomPanel());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.wrkNodesModelOrg.includeButton) {
            this.includeNode(this.wrkNodesModelOrg);
        } else if (object == this.wrkNodesModelOrg.excludeButton) {
            this.excludeNode(this.wrkNodesModelOrg);
        } else if (object == this.wrkNodesModelOrg.advancedButton) {
            this.advancedSetting(this.wrkNodesModelOrg);
        } else if (object == this.wrkNodesModelOrg.applyButton) {
            this.doApply();
        } else if (object == this.wrkNodesModelOrg.resetButton) {
            this.doReset();
        } else if (this.prtNodesModelOrg != null) {
            if (object == this.prtNodesModelOrg.includeButton) {
                this.includeNode(this.prtNodesModelOrg);
            } else if (object == this.prtNodesModelOrg.excludeButton) {
                this.excludeNode(this.prtNodesModelOrg);
            } else if (object == this.prtNodesModelOrg.advancedButton) {
                this.advancedSetting(this.prtNodesModelOrg);
            } else if (object == this.prtNodesModelOrg.applyButton) {
                this.doApply();
            } else if (object == this.prtNodesModelOrg.resetButton) {
                this.doReset();
            }
        }
        this.enableWidgets();
    }

    @Override
    boolean setLink(NetMapLink netMapLink) {
        return false;
    }

    @Override
    boolean setNode(MapNode mapNode) {
        return true;
    }

    @Override
    void unSetLink() {
    }

    @Override
    void getMoreUIs() {
    }

    @Override
    void linkSelected(MapLink mapLink, boolean bl) {
        this.setSelectedNode(null);
    }

    @Override
    void nodeSelected(MapNode mapNode, boolean bl) {
        if (bl) {
            this.setSelectedNode(mapNode);
        } else {
            this.setSelectedNode(null);
        }
    }

    @Override
    void clicked(MapLink mapLink) {
    }

    @Override
    void domainDisplayed(MapNode mapNode) {
    }

    @Override
    protected String getNextPaneName() {
        if (!this.isProtectPanel() && this.isForProtectOchcc() && !OchTrailHelper.isProtectedOCHNCService(this.getSrcTrunkPortModel())) {
            return "OCH Circuit Protect Routing Preferences";
        }
        return null;
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdOchRoutePane;
    }

    @Override
    public void selectionChanged(Object object, Object object2) {
    }

    @Override
    public void orderSwapped(Object object, Object object2) {
        this.setNodeLabel((INetElement)object, this.wrkNodesModelOrg);
        this.setNodeLabel((INetElement)object2, this.wrkNodesModelOrg);
        this.enableWidgets();
    }

    @Override
    public void entryRemoved(Object object) {
        this.setNodeLabel((INetElement)object, this.wrkNodesModelOrg);
        this.refreshLabels();
        this.enableWidgets();
    }

    private void refreshLabels() {
        int n;
        INetElement[] iNetElementArray = this.wrkNodesModelOrg.getIncludedNodes();
        for (int i = 0; i < iNetElementArray.length; ++i) {
            this.setNodeLabel(iNetElementArray[i], this.wrkNodesModelOrg);
        }
        INetElement[] iNetElementArray2 = this.wrkNodesModelOrg.getExcludedNodes();
        for (n = 0; n < iNetElementArray2.length; ++n) {
            this.setNodeLabel(iNetElementArray2[n], this.wrkNodesModelOrg);
        }
        if (this.prtNodesModelOrg != null) {
            iNetElementArray = this.prtNodesModelOrg.getIncludedNodes();
            for (n = 0; n < iNetElementArray.length; ++n) {
                this.setNodeLabel(iNetElementArray[n], this.prtNodesModelOrg);
            }
            iNetElementArray2 = this.prtNodesModelOrg.getExcludedNodes();
            for (n = 0; n < iNetElementArray2.length; ++n) {
                this.setNodeLabel(iNetElementArray2[n], this.prtNodesModelOrg);
            }
        }
    }

    private void setNodeLabel(INetElement iNetElement, OrderedListModelOrganizer orderedListModelOrganizer) {
        MapNode mapNode = this.getMapNode(iNetElement);
        mapNode.setDesc(null);
        if (orderedListModelOrganizer.contains(iNetElement)) {
            mapNode.addDesc(orderedListModelOrganizer.getRankString(iNetElement));
        }
    }

    void setSelectedNode(MapNode mapNode) {
        if (this.db.on()) {
            this.db.finer("--> setSelectedNode " + mapNode);
        }
        if (this.selectedMapNode != null) {
            if (!this.selectedMapNode.isSameNodeAs(mapNode)) {
                this.unSetNode(this.selectedMapNode);
            } else {
                return;
            }
        }
        this.selectedMapNode = mapNode;
        if (this.selectedMapNode == null) {
            this.dispTF.setText("");
        } else {
            INodeModel iNodeModel = (INodeModel)mapNode.getUserObject();
            this.dispTF.setText(iNodeModel.getName());
        }
        if (this.db.on()) {
            this.db.finer("<-- setSelectedNode " + mapNode);
        }
        this.enableWidgets();
    }

    private void unSetNode(MapNode mapNode) {
        if (this.db.on()) {
            this.db.finer("unSetNode(mapNode) " + mapNode);
        }
        this.unSelectVnodes(mapNode);
        if (mapNode != null && mapNode.isSelected()) {
            this.circuitMap.setSelected(mapNode, false);
        }
        this.circuitMap.updateView();
        this.enableWidgets();
    }

    @Override
    public RoutePrefs getRoutePrefs() {
        if (this.isProtectPanel()) {
            return this.getWorkingPathPanel().getRoutePrefs();
        }
        return this.routePrefs;
    }

    @Override
    public void setRoutePrefs(RoutePrefs routePrefs) {
        this.routePrefs = routePrefs;
    }

    @Override
    public boolean isPca() {
        return false;
    }

    @Override
    public void setPca(boolean bl) {
    }

    @Override
    public boolean isPathProt() {
        return false;
    }

    @Override
    public void setPathProt(boolean bl) {
    }

    @Override
    public boolean isRrbc() {
        return false;
    }

    @Override
    public boolean isUrn() {
        return false;
    }

    @Override
    public boolean isAutoRoute() {
        return false;
    }

    @Override
    public void enteringPane() {
        AbstractCircuitDialog abstractCircuitDialog = this.getAbstractCktDlg();
        this.srcNE = abstractCircuitDialog.getSource().getNetElement();
        this.dstNE = abstractCircuitDialog.getDest().getNetElement();
        super.enteringPane();
        this.divPanel.setVisible(this.isProtectPanel());
        this.wrkNodesModelOrg.constraintsSp.setDividerLocation(0.5);
        if (this.prtNodesModelOrg != null) {
            this.prtNodesModelOrg.constraintsSp.setDividerLocation(0.5);
        }
        this.setSelectedNode(null);
        if (!this.goingForward) {
            this.wrkNodesModelOrg.restoreLists();
            if (this.prtNodesModelOrg != null) {
                this.prtNodesModelOrg.restoreLists();
            }
        }
        this.initDescrLabel();
        this.initDiversity();
        this.updateMap();
        this.resetDividerLocation();
    }

    private void saveDividerLocation() {
        Preferences preferences = Preferences.instance();
        preferences.setInt(PREF, DIV_LOC, this.mainSplitPane.getDividerLocation());
    }

    private void resetDividerLocation() {
        Preferences preferences = Preferences.instance();
        int n = preferences.getInt(PREF, DIV_LOC, 110);
        this.mainSplitPane.setDividerLocation(n);
        this.mainSplitPane.setResizeWeight(1.0);
    }

    private void updateMap() {
        boolean bl = this.wrkNodesModelOrg.anyChange();
        if (this.prtNodesModelOrg != null) {
            bl |= this.prtNodesModelOrg.anyChange();
        }
        this.cleanup();
        if (!bl) {
            this.mapIncludedLinks();
        }
        List<INetLink> list = new ArrayList<INetLink>();
        if (this.isRouted) {
            if (this.isForOchcc()) {
                if (this.getP2PLink() != null) {
                    list.add(this.getP2PLink());
                } else {
                    INetCircuit iNetCircuit = this.getOchTrailCircuit();
                    if (iNetCircuit != null) {
                        list = iNetCircuit.getCircuitSpans();
                    }
                }
            } else {
                list = this.getAbstractCktDlg().getCircuit().getCircuitSpans();
            }
        }
        this.mapExistingSpans(list);
        if (bl) {
            this.mapIncludedLinks();
        }
        this.refreshLabels();
    }

    private void mapExistingSpans(List list) {
        int n = list.size();
        if (this.db.isFinestEnabled()) {
            this.db.println("Map " + n + " existing spans.");
        }
        this.spansModel.clearAll();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Object object;
                INetLink iNetLink = null;
                NetCircuitSpan netCircuitSpan = null;
                NetLinkSpan netLinkSpan = null;
                boolean bl = false;
                Object e = list.get(i);
                if (e instanceof INetLink) {
                    iNetLink = (INetLink)e;
                    if (this.db.isFinestEnabled()) {
                        this.db.println("Iteration #" + i);
                        this.db.println("\tgot INetLink: " + iNetLink);
                    }
                    bl = true;
                } else {
                    netCircuitSpan = (NetCircuitSpan)list.get(i);
                    netLinkSpan = (NetLinkSpan)netCircuitSpan.getNetLinkSpan();
                    if (this.db.isFinestEnabled()) {
                        this.db.println("Iteration #" + i);
                        this.db.println("\tgot NetLinkSpan from ckt: " + netLinkSpan);
                    }
                    iNetLink = this.getNetLink(netLinkSpan);
                    if (netLinkSpan.getOmni()) {
                        bl = true;
                    } else if (iNetLink.isVirtual()) {
                        bl = !OchPortsHelper.isOtsPort(iNetLink.getSrc().getNodeModel(), iNetLink.getSrcEntityIndex());
                    }
                }
                MapLink mapLink = this.netToMapLink(iNetLink);
                if (this.db.isFinestEnabled()) {
                    this.db.println("\tnetLink is " + iNetLink);
                    this.db.println("\tassociated mapLink is " + mapLink);
                }
                if (mapLink == null && (iNetLink instanceof OchTrailTunnelNetLink || iNetLink.isLAP())) {
                    this.circuitMap.addLink(iNetLink, null);
                    mapLink = this.netToMapLink(iNetLink);
                }
                if (mapLink == null) {
                    if (!this.db.on()) continue;
                    this.db.println("\tNo MapLink found for " + iNetLink);
                    continue;
                }
                if (bl) {
                    mapLink.setBothArrows();
                } else {
                    mapLink.setTargetArrow();
                    object = (INetLink)mapLink.getUserObject();
                    if (object != iNetLink) {
                        mapLink.reverseArrow();
                    }
                }
                this.circuitMap.setNetMapLinkState("mapExistingSpans()", mapLink, 3);
                object = netLinkSpan == null ? this.getSpanDesc(mapLink, iNetLink) : this.getSpanDesc(mapLink, netLinkSpan);
                this.spansModel.add(iNetLink, (String)object);
            }
        } else {
            this.circuitMap.setSelected(this.getMapNode(this.srcNE), true);
        }
    }

    private void mapIncludedLinks() {
        SidesConstraintsHolder sidesConstraintsHolder;
        INetElement[] iNetElementArray;
        for (INetElement iNetElement : iNetElementArray = this.wrkNodesModelOrg.getIncludedNodes()) {
            if (!this.wrkNodesModelOrg.hasSideConstraint(iNetElement) || (sidesConstraintsHolder = this.wrkNodesModelOrg.getSideConstraint(iNetElement)) == null) continue;
            this.selectLinks(iNetElement, sidesConstraintsHolder);
        }
        if (this.prtNodesModelOrg != null) {
            for (INetElement iNetElement : iNetElementArray = this.prtNodesModelOrg.getIncludedNodes()) {
                if (!this.prtNodesModelOrg.hasSideConstraint(iNetElement) || (sidesConstraintsHolder = this.prtNodesModelOrg.getSideConstraint(iNetElement)) == null) continue;
                this.selectLinks(iNetElement, sidesConstraintsHolder);
            }
        }
    }

    private void selectLinks(INetElement iNetElement, SidesConstraintsHolder sidesConstraintsHolder) {
        List<INetLink> list = this.getLinksBySide(iNetElement, sidesConstraintsHolder);
        for (INetLink iNetLink : list) {
            MapLink mapLink = this.netToMapLink(iNetLink);
            if (mapLink == null) continue;
            this.circuitMap.setNetMapLinkState("selectLinks", mapLink, 0);
        }
    }

    private List<INetLink> getLinksBySide(INetElement iNetElement, SidesConstraintsHolder sidesConstraintsHolder) {
        Network network = Network.instance();
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        for (int i = 1; i <= 2; ++i) {
            ISideModel iSideModel = i == 1 ? sidesConstraintsHolder.getSideIn() : sidesConstraintsHolder.getSideOut();
            linkedList.addAll(network.findAllNetLinksWithNetElemAndSide(iNetElement, iSideModel.getId()));
        }
        return linkedList;
    }

    @Override
    public void validatePage() throws Exception {
        boolean bl = this.wrkNodesModelOrg.anyChange();
        if (this.prtNodesModelOrg != null) {
            bl |= this.prtNodesModelOrg.anyChange();
        }
        if (bl && !CerentDialog.yesNoDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.WID_OCH_CIRCUITS_ROUTING_BACK_NEXT), (String)this.getName())) {
            this.isOkToPostValidate = false;
            return;
        }
        if (this.isForOchcc() && this.isLastPanel()) {
            this.provisionOchTrails();
            this.routeOchcc();
        }
        this.storeStatusText();
    }

    /*
     * Unable to fully structure code
     */
    private void provisionOchTrails() throws Exception {
        var1_1 = this.getAbstractCktDlg();
        var2_2 = var1_1.getCircuit();
        var3_3 = ((OchccCircuit)var2_2).getTrkAttribOperator();
        var4_4 = null;
        if (this.isProtectPanel()) {
            var5_5 = this.getWorkingPathPanel();
            if (var5_5.isOchTrailRouted()) {
                var6_6 = super.getOchTrailCircuit();
                ((OchncCircuit)var6_6).setTrkAttribOperatorInfo(var3_3);
                var6_6.provision();
                var4_4 = ((OchncCircuit)var6_6).getTrunksInUseMsg();
                var1_1.addRelatedCircuit((INetCircuit)var6_6);
            } else if (super.isRoutedThroughPPC()) {
                ((OchccCircuit)var2_2).applyTrunkPortsInfo();
                var4_4 = ((OchccCircuit)var2_2).getTrunksInUseMsg();
            }
        }
        if (this.isOchTrailRouted()) {
            var5_5 = this.getOchTrailCircuit();
            if (var4_4 == null) {
                ((OchncCircuit)var5_5).setTrkAttribOperatorInfo(var3_3);
            }
            if (this.isProtectPanel()) {
                try {
                    ((OchncCircuit)var5_5).provisionProtectOchTrail();
                    var6_6 = ((OchncCircuit)var5_5).getRegenTrunksInUseMsg();
                    if (var6_6 == null) ** GOTO lbl47
                    if (var4_4 == null) {
                        var4_4 = var6_6;
                        var7_8 = this.getWorkingPathPanel();
                        if (var7_8.isRoutedThroughPPC()) {
                            ((OchccCircuit)var2_2).restoreTrunkPortsInfo();
                        }
                        var8_10 = var7_8.getOchTrailCircuit();
                        ((OchncCircuit)var8_10).restoreTrunkPortsInfo();
                    }
                    var4_4 = (String)var4_4 + (String)var6_6;
                }
                catch (Exception var6_7) {
                    var7_9 = this.getWorkingPathPanel();
                    if (var7_9.isRoutedThroughPPC()) {
                        ((OchccCircuit)var2_2).restoreTrunkPortsInfo();
                    } else {
                        var8_11 = var7_9.getOchTrailCircuit();
                        ((OchncCircuit)var8_11).restoreTrunkPortsInfo();
                    }
                    throw var6_7;
                }
            } else {
                var5_5.provision();
                var4_4 = ((OchncCircuit)var5_5).getTrunksInUseMsg();
            }
lbl47:
            // 5 sources

            var1_1.addRelatedCircuit((INetCircuit)var5_5);
        } else if (this.isRoutedThroughPPC() && !this.isProtectPanel()) {
            ((OchccCircuit)var2_2).applyTrunkPortsInfo();
            var4_4 = ((OchccCircuit)var2_2).getTrunksInUseMsg();
        }
        if (var4_4 != null) {
            var5_5 = DetailedDialog.instance((Frame)JOptionPane.getFrameForComponent(this), (String)"Trunk Settings Provisioning");
            var5_5.setText("Trunk settings are not applied on any of the trunk ports.", CerentDialog.INFO_ICON);
            var5_5.append("The following trunk ports are in IS state.\n\n" + (String)var4_4);
            var5_5.setSize(500, var5_5.getHeight());
            var5_5.show();
        }
    }

    private void routeOchcc() throws AnnotatedException {
        AbstractCircuitDialog abstractCircuitDialog = this.getAbstractCktDlg();
        INetCircuit iNetCircuit = abstractCircuitDialog.getCircuit();
        RoutePrefs routePrefs = this.getRoutePrefs();
        try {
            if (abstractCircuitDialog.getSource().getEntityModel() instanceof ITdmPortModel) {
                iNetCircuit.routeNetElement(this.dstNE, routePrefs);
                abstractCircuitDialog.destinationAdded = true;
            } else {
                iNetCircuit.routeDrop(abstractCircuitDialog.getDest(), routePrefs);
                abstractCircuitDialog.destinationAdded = true;
            }
        }
        catch (Exception exception) {
            throw new AnnotatedException("The drops cannot be added or routed.", exception);
        }
        if (this.db.on) {
            this.db.println("routeOchcc: Route succeeded");
        }
    }

    @Override
    public void revalidateData() {
        this.isRouted = false;
        this.setP2pLink(null);
        this.setOchTrailCircuit(null);
        if (this.isForOchcc() && !this.isOchTrailProvisioned()) {
            INetLink iNetLink = this.findPeer2PeerLink();
            if (iNetLink != null) {
                this.setP2pLink(iNetLink);
                if (iNetLink instanceof OchTrailTunnelNetLink) {
                    INetCircuit iNetCircuit = ((NetLink)iNetLink).getLotCircuit();
                    if (iNetCircuit != null) {
                        this.setOchTrailCircuit(iNetCircuit);
                    } else {
                        ErrorMsg.displayError((Component)this, (EID)NEMC.EID_OCH_CIRCUITS_ROUTING_NO_OCH_TRAIL_CKT);
                    }
                }
                this.isRouted = true;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CcdOchRoutePane.this.doRouteCircuit();
                        CcdOchRoutePane.this.enableWidgets();
                    }
                });
            }
        } else {
            this.isRouted = true;
        }
        this.enableWidgets();
    }

    @Override
    public boolean handleBack() {
        int n = this.wrkNodesModelOrg.getSize();
        if (this.prtNodesModelOrg != null) {
            this.prtNodesModelOrg.getSize();
        }
        if (n > 0 && !CerentDialog.yesNoDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.WID_OCH_CIRCUITS_ROUTING_BACK_NEXT), (String)this.getName())) {
            return false;
        }
        if (this.isForOchcc()) {
            if (!this.isOchTrailProvisioned()) {
                try {
                    if (this.ochTrailCkt.isCircuitRefValid()) {
                        if (this.db.on) {
                            this.db.println("handleBack: calling ochTrailCkt.destroyCircuit()");
                        }
                        this.ochTrailCkt.destroyCircuit();
                    }
                }
                catch (Exception exception) {
                    if (this.db.on) {
                        this.db.println("handleBack: ochTrailCkt.destroyCircuit() failed: " + exception.getMessage());
                    }
                }
            }
        } else if (!this.isForOchTrail()) {
            try {
                this.getAbstractCktDlg().deleteDestination();
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.println("Delete destination failed: " + exception.getMessage());
                }
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_DELETE_DESTINATION_FAILED);
            }
        }
        this.setP2pLink(null);
        this.setOchTrailCircuit(null);
        this.wrkNodesModelOrg.clearAll();
        if (this.prtNodesModelOrg != null) {
            this.prtNodesModelOrg.clearAll();
        }
        this.resetConstraints();
        this.resetProtConstraints();
        this.saveDividerLocation();
        return super.handleBack();
    }

    @Override
    public String handleNext() {
        this.saveDividerLocation();
        return super.handleNext();
    }

    @Override
    void handleFinish() {
        this.saveDividerLocation();
        super.handleFinish();
    }

    public void setP2pLink(INetLink iNetLink) {
        this.p2pLink = iNetLink;
    }

    private INetLink getP2PLink() {
        return this.p2pLink;
    }

    private boolean isRoutedThrouPPC() {
        return this.p2pLink != null && this.p2pLink instanceof VirtualNetLink;
    }

    private boolean isRoutedThroughPPC() {
        return this.getOchTrailCircuit() == null;
    }

    public void setOchTrailCircuit(INetCircuit iNetCircuit) {
        this.ochTrailCkt = iNetCircuit;
    }

    private INetCircuit getOchTrailCircuit() {
        return this.ochTrailCkt;
    }

    private void routeCircuit() throws Exception {
        if (this.db.on()) {
            this.db.println("routeCircuit() called");
        }
        CircuitCreationDialog circuitCreationDialog = (CircuitCreationDialog)this.getAbstractCktDlg();
        INetCircuit iNetCircuit = null;
        if (this.isForOchnc()) {
            iNetCircuit = circuitCreationDialog.getCircuit();
            circuitCreationDialog.deleteDestination();
            this.addConstraints(this.getRoutePrefs());
            this.addProtConstraints(this.getRoutePrefs());
            circuitCreationDialog.addDestinationToOchnc();
        } else if (this.isForOchTrail()) {
            iNetCircuit = circuitCreationDialog.getCircuit();
            circuitCreationDialog.deleteDestination();
            this.addConstraints(this.getRoutePrefs());
            this.addProtConstraints(this.getRoutePrefs());
            circuitCreationDialog.addDestinationToOchTrail();
        } else if (this.isForOchcc()) {
            iNetCircuit = this.getOchTrailCircuit();
            if (iNetCircuit != null && iNetCircuit.isCircuitRefValid()) {
                iNetCircuit.destroyCircuit();
                this.setOchTrailCircuit(null);
            }
            iNetCircuit = this.getCircuitToRoute();
            iNetCircuit.routeNetElement(this.dstNE, this.getOchTrailPrefs());
            this.setOchTrailCircuit(iNetCircuit);
        }
        if (this.db.on()) {
            this.db.println("routeCircuit() worked");
        }
    }

    private boolean isProtectPanel() {
        return this.getName().equals("OCH Circuit Protect Routing Preferences");
    }

    private boolean isLastPanel() {
        if (this.isProtectPanel()) {
            return true;
        }
        return !this.isForProtectOchcc() || OchTrailHelper.isProtectedOCHNCService(this.getSrcTrunkPortModel());
    }

    private boolean isReadOnly() {
        if (this.isForOchcc()) {
            if (this.isRoutedThrouPPC()) {
                return true;
            }
            if (this.getOchTrailCircuit() != null) {
                return this.isOchTrailProvisioned();
            }
            return false;
        }
        return false;
    }

    private CcdOchRoutePane getWorkingPathPanel() {
        return (CcdOchRoutePane)this.getAbstractCktDlg().getPaneByName("OCH Circuit Routing Preferences");
    }

    private boolean isForOchnc() {
        return this.getAbstractCktDlg() != null && this.getAbstractCktDlg().getCircuitType() == 9;
    }

    private boolean isForOchTrail() {
        return this.getAbstractCktDlg() != null && this.getAbstractCktDlg().getCircuitType() == 15;
    }

    private boolean isForOchcc() {
        return this.getAbstractCktDlg() != null && this.getAbstractCktDlg().getCircuitType() == 14;
    }

    private boolean isForProtectOchcc() {
        return this.isForOchcc() && this.getAbstractCktDlg().getCircuitInfo() != null && this.getAbstractCktDlg().getCircuitInfo().isProtected();
    }

    private boolean isForProtectOchnc() {
        return this.isForOchnc() && this.getAbstractCktDlg().getCircuitInfo() != null && this.getAbstractCktDlg().getCircuitInfo().isProtected();
    }

    private boolean isForProtectOchncService() {
        return this.isForProtectOchnc() || (this.isForOchTrail() || this.isForOchcc()) && OchTrailHelper.isProtectedOCHNCService(this.getSrcTrunkPortModel());
    }

    private boolean isOchTrailProvisioned() {
        return this.ochTrailCkt != null && this.ochTrailCkt.getState() != 0;
    }

    private boolean isOchTrailRouted() {
        return this.ochTrailCkt != null && this.ochTrailCkt.getState() == 0;
    }

    private INetLink findPeer2PeerLink() {
        int n = this.getSrcTrunkPort();
        int n2 = this.getDstTrunkPort();
        if (this.db.on()) {
            this.db.println("Looking for peer 2 peer from " + this.srcNE.getName() + "/" + Integer.toHexString(n) + " to " + this.dstNE.getName() + "/" + Integer.toHexString(n2));
        }
        INetLink iNetLink = OchTrailHelper.findPeer2PeerLink(this.srcNE, n, this.dstNE, n2);
        if (this.db.on()) {
            this.db.println("Peer 2 peer link is: " + iNetLink);
        }
        return iNetLink;
    }

    private void doRouteCircuit() {
        this.isRouted = false;
        try {
            this.routeCircuit();
            this.wrkNodesModelOrg.saveLists();
            if (this.prtNodesModelOrg != null) {
                this.prtNodesModelOrg.saveLists();
            }
            this.isRouted = true;
        }
        catch (ObjDuplicate objDuplicate) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)objDuplicate);
            }
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_OCH_CIRCUITS_ROUTING_CONSTRAINTS_FAILURE);
        }
        catch (Exception exception) {
            Exception exception2;
            Object object;
            if (this.db.on()) {
                this.db.println("Routing failure: " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
            if (exception instanceof AnnotatedException) {
                object = (AnnotatedException)((Object)exception);
                exception2 = object.getChild();
            }
            if (exception2 instanceof NoRoute) {
                object = (NoRoute)((Object)exception2);
                DetailedLog detailedLog = ((NoRoute)((Object)object)).getDetailedLog();
                if (detailedLog == null) {
                    ErrorMsg.displayError((Component)this, (EID)this.getNoRouteEmcErrorId());
                } else {
                    this.getAbstractCktDlg().cerentDialogDisplayError(detailedLog);
                }
            }
            ErrorMsg.displayError((Component)this, (EID)this.getNoRouteEmcErrorId());
        }
        this.updateMap();
        if (this.isRouted) {
            CerentDialog.infoDialog((Component)this, (String)"Routing evaluation succeeded.", (String)this.getName());
        }
    }

    private INetCircuit getCircuitToRoute() throws SanityCheckFailed {
        if (!this.isForOchcc()) {
            return this.getAbstractCktDlg().getCircuit();
        }
        int n = this.getAbstractCktDlg().getCircuitInfo().adminState();
        n = n == 0 ? 3 : 1;
        RoutePrefs routePrefs = this.getRoutePrefs();
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(15, CircuitSize.SIZE_OCHNC_ENS.getEnum(), 1, false, "", n, false, routePrefs.getcktOptChannel());
        circuitCreatInfo.setSrcTrkPort(this.getSrcTrunkPort());
        if (OchTrailHelper.isProtectedOCHNCService(this.getSrcTrunkPortModel())) {
            circuitCreatInfo.setProtected(true);
        }
        INetCircuit iNetCircuit = NetCircuitFactory.newCircuit(circuitCreatInfo, this.srcNE);
        return iNetCircuit;
    }

    private RoutePrefs getOchTrailPrefs() throws ObjDuplicate {
        RoutePrefs routePrefs = this.getRoutePrefs();
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        routePrefs2.setCircuitSize(CircuitSize.SIZE_OCHNC_ENS.getEnum());
        routePrefs2.setCircuitType(15);
        routePrefs2.setDirectionality(3);
        routePrefs2.setTunnel(true);
        routePrefs2.setcktSrcEntityIndex(this.getSrcTrunkPort());
        routePrefs2.setcktDstEntityIndex(this.getDstTrunkPort());
        if (OchTrailHelper.isProtectedOCHNCService(this.getSrcTrunkPortModel())) {
            routePrefs2.setPathProt(1);
        } else {
            routePrefs2.setPathProt(2);
        }
        if (this.db.on()) {
            this.db.println("OCH-Trail preferences are: " + routePrefs2.prettyString());
        }
        this.addConstraints(routePrefs2);
        this.addProtConstraints(routePrefs2);
        return routePrefs2;
    }

    private int getSrcTrunkPort() {
        return this.getSrcTrunkPortModel().getEntityIndex();
    }

    private IEntityModel getSrcTrunkPortModel() {
        IEntityModel[] iEntityModelArray;
        block5: {
            RoutePrefs routePrefs = this.getRoutePrefs();
            iEntityModelArray = new IEntityModel[]{};
            try {
                IEntityTableModel iEntityTableModel = this.srcNE.getNodeModel().getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(routePrefs.getcktSrcEntityIndex());
                iEntityModelArray = OchTrailHelper.getTrunkPorts(iEntityModel);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.db.on()) {
                    this.db.println("Exception getting trunk ports " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
            catch (NoSuchEquipment noSuchEquipment) {
                if (!this.db.on()) break block5;
                this.db.println("Exception getting trunk ports " + (Object)((Object)noSuchEquipment));
            }
        }
        if (!this.isProtectPanel()) {
            return iEntityModelArray[0];
        }
        return iEntityModelArray[1];
    }

    private int getDstTrunkPort() {
        return this.getDstTrunkPortModel().getEntityIndex();
    }

    private IEntityModel getDstTrunkPortModel() {
        IEntityModel[] iEntityModelArray;
        block5: {
            RoutePrefs routePrefs = this.getRoutePrefs();
            iEntityModelArray = new IEntityModel[]{};
            try {
                iEntityModelArray = OchTrailHelper.getTrunkPorts(this.dstNE.getNodeModel(), routePrefs.getcktDstEntityIndex());
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.db.on()) {
                    this.db.println("Exception getting trunk ports " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
            catch (NoSuchEquipment noSuchEquipment) {
                if (!this.db.on()) break block5;
                this.db.println("Exception getting trunk ports " + (Object)((Object)noSuchEquipment));
            }
        }
        if (!this.isProtectPanel()) {
            return iEntityModelArray[0];
        }
        return iEntityModelArray[1];
    }

    private void enableWidgets() {
        boolean bl;
        boolean bl2 = this.isReadOnly();
        boolean bl3 = this.selectedMapNode != null;
        this.wrkNodesModelOrg.includeButton.setEnabled(!bl2 && bl3);
        this.wrkNodesModelOrg.excludeButton.setEnabled(!bl2 && bl3);
        this.wrkNodesModelOrg.syncButtons();
        boolean bl4 = this.wrkNodesModelOrg.anyChange();
        boolean bl5 = bl = this.wrkNodesModelOrg.getSize() > 0;
        if (this.prtNodesModelOrg != null) {
            this.prtNodesModelOrg.includeButton.setEnabled(!bl2 && bl3);
            this.prtNodesModelOrg.excludeButton.setEnabled(!bl2 && bl3);
            this.prtNodesModelOrg.syncButtons();
            boolean bl6 = this.prtNodesModelOrg.getSize() > 0;
            this.prtNodesModelOrg.applyButton.setEnabled(!bl2 && (!this.isRouted || (bl4 |= this.prtNodesModelOrg.anyChange())));
            this.prtNodesModelOrg.resetButton.setEnabled(!bl2 && (bl |= bl6));
        }
        this.wrkNodesModelOrg.applyButton.setEnabled(!bl2 && (!this.isRouted || bl4));
        this.wrkNodesModelOrg.resetButton.setEnabled(!bl2 && bl);
        this.diversityCB.setEnabled(!bl2 && this.isProtectPanel());
        this.getAbstractCktDlg().setNextEnabled(!this.isLastPanel() && this.isRouted);
        this.getAbstractCktDlg().setFinishEnabled(this.isLastPanel() && this.isRouted);
    }

    private void initDiversity() {
        if (this.isProtectPanel()) {
            this.diversityCB.setVisible(true);
        } else {
            this.diversityCB.setVisible(false);
        }
    }

    private boolean commonChecks(INetElement iNetElement, OrderedListModelOrganizer orderedListModelOrganizer) {
        if (iNetElement.getNodeId() == this.srcNE.getNodeId()) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_OCH_CIRCUITS_ROUTING_SOURCE_NODE);
            return false;
        }
        if (iNetElement.getNodeId() == this.dstNE.getNodeId()) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_OCH_CIRCUITS_ROUTING_DROP_NODE);
            return false;
        }
        if (orderedListModelOrganizer.contains(iNetElement)) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_OCH_CIRCUITS_ROUTING_ALREADY_IN);
            return false;
        }
        return true;
    }

    private void includeNode(OrderedListModelOrganizer orderedListModelOrganizer) {
        INetElement iNetElement = this.getNetElement(this.selectedMapNode);
        if (this.commonChecks(iNetElement, orderedListModelOrganizer)) {
            orderedListModelOrganizer.addIncluded(iNetElement);
            this.setNodeLabel(iNetElement, orderedListModelOrganizer);
        }
    }

    private void excludeNode(OrderedListModelOrganizer orderedListModelOrganizer) {
        INetElement iNetElement = this.getNetElement(this.selectedMapNode);
        if (this.commonChecks(iNetElement, orderedListModelOrganizer)) {
            orderedListModelOrganizer.addExcluded(iNetElement);
            this.setNodeLabel(iNetElement, orderedListModelOrganizer);
        }
    }

    private void advancedSetting(OrderedListModelOrganizer orderedListModelOrganizer) {
        SidesSettingsDialog sidesSettingsDialog = new SidesSettingsDialog(orderedListModelOrganizer);
        sidesSettingsDialog.initAndShow();
    }

    private void addConstraints(RoutePrefs routePrefs) throws ObjDuplicate {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        routePrefs.setReqEntityList(new LinkedList());
        routePrefs.setExcEntityList(new LinkedList());
        routePrefs.setExcludeSrgs(new LinkedHashSet());
        INetElement[] iNetElementArray = this.wrkNodesModelOrg.getIncludedNodes();
        INetElement[] iNetElementArray2 = this.wrkNodesModelOrg.getExcludedNodes();
        if (iNetElementArray.length == 0 && iNetElementArray2.length == 0) {
            return;
        }
        List<INetElement> list = Arrays.asList(iNetElementArray);
        routePrefs.setReqEntityList(list);
        LinkedList<INetElement> linkedList = new LinkedList<INetElement>(Arrays.asList(iNetElementArray2));
        if (this.isProtectPanel() && this.diversityCB.isSelected() && (object4 = super.getOchTrailCircuit()) != null) {
            List list2 = object4.getCircuitSpans();
            for (NetCircuitSpan object5 : list2) {
                object2 = object5.getLink().getSrc();
                object = object5.getLink().getDst();
                if (object2.getNodeId() != this.srcNE.getNodeId() && object2.getNodeId() != this.dstNE.getNodeId() && !linkedList.contains(object2)) {
                    linkedList.add((INetElement)object2);
                }
                if (object.getNodeId() == this.srcNE.getNodeId() || object.getNodeId() == this.dstNE.getNodeId() || linkedList.contains(object)) continue;
                linkedList.add((INetElement)object);
            }
        }
        object3 = Network.instance();
        for (INetElement iNetElement : iNetElementArray) {
            Object object5;
            Object object6;
            Object object7;
            if (!this.wrkNodesModelOrg.hasSideConstraint(iNetElement)) continue;
            object2 = this.wrkNodesModelOrg.getSideConstraint(iNetElement);
            object = this.getLinksBySide(iNetElement, (SidesConstraintsHolder)object2);
            if (this.db.on()) {
                object7 = new StringBuilder("Found links for sides constraints:");
                object6 = object.iterator();
                while (object6.hasNext()) {
                    object5 = (INetLink)object6.next();
                    ((StringBuilder)object7).append("\n").append(object5.prettyString());
                }
                this.db.println(((StringBuilder)object7).toString());
            }
            object7 = ((Network)object3).findAllNetLinksWithNetElem(iNetElement);
            object7.removeAll((Collection<?>)object);
            if (this.db.on()) {
                object6 = new StringBuilder("Excluding links: ");
                object5 = object7.iterator();
                while (object5.hasNext()) {
                    INetLink iNetLink = (INetLink)object5.next();
                    ((StringBuilder)object6).append("\n").append(iNetLink.prettyString());
                }
                this.db.println(((StringBuilder)object6).toString());
            }
            linkedList.addAll((Collection<INetElement>)object7);
        }
        routePrefs.setExcEntityList(linkedList);
    }

    private void addProtConstraints(RoutePrefs routePrefs) throws ObjDuplicate {
        routePrefs.setReqProtEntityList(new LinkedList());
        routePrefs.setExcProtEntityList(new LinkedList());
        if (this.prtNodesModelOrg != null) {
            INetElement[] iNetElementArray = this.prtNodesModelOrg.getIncludedNodes();
            INetElement[] iNetElementArray2 = this.prtNodesModelOrg.getExcludedNodes();
            if (iNetElementArray.length == 0 && iNetElementArray2.length == 0) {
                return;
            }
            List<INetElement> list = Arrays.asList(iNetElementArray);
            routePrefs.setReqProtEntityList(list);
            LinkedList<INetElement> linkedList = new LinkedList<INetElement>(Arrays.asList(iNetElementArray2));
            Network network = Network.instance();
            for (INetElement iNetElement : iNetElementArray) {
                Object object;
                if (!this.prtNodesModelOrg.hasSideConstraint(iNetElement)) continue;
                SidesConstraintsHolder sidesConstraintsHolder = this.prtNodesModelOrg.getSideConstraint(iNetElement);
                List<INetLink> list2 = this.getLinksBySide(iNetElement, sidesConstraintsHolder);
                if (this.db.on()) {
                    object = new StringBuilder("Found links for sides constraints:");
                    for (INetLink iNetLink : list2) {
                        ((StringBuilder)object).append("\n").append(iNetLink.prettyString());
                    }
                    this.db.println(((StringBuilder)object).toString());
                }
                object = network.findAllNetLinksWithNetElem(iNetElement);
                object.removeAll(list2);
                if (this.db.on()) {
                    StringBuilder stringBuilder = new StringBuilder("Excluding links: ");
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        INetLink iNetLink = (INetLink)iterator.next();
                        stringBuilder.append("\n").append(iNetLink.prettyString());
                    }
                    this.db.println(stringBuilder.toString());
                }
                linkedList.addAll((Collection<INetElement>)object);
            }
            routePrefs.setExcProtEntityList(linkedList);
        }
    }

    private void resetConstraints() {
        block5: {
            RoutePrefs routePrefs;
            block4: {
                routePrefs = this.getRoutePrefs();
                try {
                    routePrefs.setReqEntityList(new LinkedList());
                }
                catch (ObjDuplicate objDuplicate) {
                    if (!this.db.on()) break block4;
                    this.db.println("Failed call to setReqEntityList: " + objDuplicate.getMessage());
                }
            }
            try {
                routePrefs.setExcEntityList(new LinkedList());
            }
            catch (ObjDuplicate objDuplicate) {
                if (!this.db.on()) break block5;
                this.db.println("Failed call to setExcEntityList: " + objDuplicate.getMessage());
            }
        }
    }

    private void resetProtConstraints() {
        block5: {
            RoutePrefs routePrefs;
            block4: {
                routePrefs = this.getRoutePrefs();
                try {
                    routePrefs.setReqEntityList(new LinkedList());
                }
                catch (ObjDuplicate objDuplicate) {
                    if (!this.db.on()) break block4;
                    this.db.println("Failed call to setReqEntityList: " + objDuplicate.getMessage());
                }
            }
            try {
                routePrefs.setExcEntityList(new LinkedList());
            }
            catch (ObjDuplicate objDuplicate) {
                if (!this.db.on()) break block5;
                this.db.println("Failed call to setExcEntityList: " + objDuplicate.getMessage());
            }
        }
    }

    private void doApply() {
        boolean bl = true;
        int n = this.wrkNodesModelOrg.getSize();
        if (this.prtNodesModelOrg != null) {
            if (n == 0) {
                bl = CerentDialog.yesNoDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.WID_OCH_CIRCUITS_ROUTING_CONSTRAINTS_PROT_ONLY), (String)this.getName());
            }
            n += this.prtNodesModelOrg.getSize();
        }
        if (bl && n > 5) {
            bl = CerentDialog.yesNoDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.WID_OCH_CIRCUITS_ROUTING_CONSTRAINTS_NUM_PARAM_1, (Object)new Integer(5)), (String)this.getName());
        }
        if (bl) {
            this.doRouteCircuit();
        }
    }

    private void doReset() {
        if (CerentDialog.yesNoDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.WID_OCH_CIRCUITS_ROUTING_RESET), (String)this.getName())) {
            this.wrkNodesModelOrg.clearAll();
            if (this.prtNodesModelOrg != null) {
                this.prtNodesModelOrg.clearAll();
            }
            this.diversityCB.setSelected(false);
            this.doRouteCircuit();
        }
    }

    @Override
    protected void makeCircuitDesignMap() {
        this.circuitMap = new OchCircuitDesignMap(this.getAbstractCktDlg());
    }

    private class OchCircuitDesignMap
    extends CircuitDesignMap {
        OchCircuitDesignMap(AbstractCircuitDialog abstractCircuitDialog) {
            super(abstractCircuitDialog);
        }

        void addDestNodeMarker() {
            if (CcdOchRoutePane.this.isForOchTrail()) {
                AbstractCircuitDialog abstractCircuitDialog = CcdOchRoutePane.this.getAbstractCktDlg();
                this.markNode(CcdOchRoutePane.this.srcNE.getNodeModel(), abstractCircuitDialog.getSource(), "Source");
            } else if (CcdOchRoutePane.this.isForOchcc()) {
                this.markNode(CcdOchRoutePane.this.srcNE.getNodeModel(), CcdOchRoutePane.this.getSrcTrunkPortModel(), "Source");
            } else {
                super.addDestNodeMarker();
            }
        }

        protected void addSourceNodeMarker() {
            if (CcdOchRoutePane.this.isForOchTrail()) {
                AbstractCircuitDialog abstractCircuitDialog = CcdOchRoutePane.this.getAbstractCktDlg();
                this.markNode(CcdOchRoutePane.this.dstNE.getNodeModel(), abstractCircuitDialog.getDest(), "Drop");
            } else if (CcdOchRoutePane.this.isForOchcc()) {
                this.markNode(CcdOchRoutePane.this.dstNE.getNodeModel(), CcdOchRoutePane.this.getDstTrunkPortModel(), "Drop");
            } else {
                super.addSourceNodeMarker();
            }
        }

        private void markNode(INodeModel iNodeModel, INetCircuitEnd iNetCircuitEnd, String string) {
            MapNode mapNode = this.getMapNode(iNodeModel);
            if (mapNode != null) {
                mapNode.addDesc(string);
                mapNode.addDesc(this.getPoint(iNetCircuitEnd));
            }
        }

        private void markNode(INodeModel iNodeModel, IEntityModel iEntityModel, String string) {
            MapNode mapNode = this.getMapNode(iNodeModel);
            if (mapNode != null) {
                mapNode.addDesc(string);
                mapNode.addDesc(CircuitEndCellRenderer.asSlashSeparatedString(iEntityModel, null, null, 0));
            }
        }
    }

    private static class SidesConstraintsHolder {
        private ISideModel sideIn;
        private ISideModel sideOut;

        SidesConstraintsHolder(ISideModel iSideModel, ISideModel iSideModel2) {
            this.sideIn = iSideModel;
            this.sideOut = iSideModel2;
        }

        public ISideModel getSideIn() {
            return this.sideIn;
        }

        public ISideModel getSideOut() {
            return this.sideOut;
        }

        public boolean equals(Object object) {
            if (object instanceof SidesConstraintsHolder) {
                SidesConstraintsHolder sidesConstraintsHolder = (SidesConstraintsHolder)object;
                return sidesConstraintsHolder.sideIn.equals(this.sideIn) && sidesConstraintsHolder.sideOut.equals(this.sideOut);
            }
            return false;
        }
    }

    private class SidesSettingsDialog
    extends UDialog
    implements ActionListener {
        private static final String TITLE = "Advanced Node Settings for ";
        private static final String CAPTION = "If you want to force the circuit route through specific links, select the sides where the circuit must cross this node.";
        private static final String RESET = "No Sides Constraints";
        private DefaultComboBoxModel sidesInModel;
        private DefaultComboBoxModel sidesOutModel;
        private JComboBox sidesInCB;
        private JComboBox sidesOutCB;
        private JCheckBox noSidesCB;
        private JButton okButton;
        private JButton cancelButton;
        private OrderedListModelOrganizer modelOrg;

        SidesSettingsDialog(OrderedListModelOrganizer orderedListModelOrganizer) {
            super((Frame)CcdOchRoutePane.this.getAbstractCktDlg(), TITLE, true);
            this.setSize(300, 240);
            this.modelOrg = orderedListModelOrganizer;
        }

        protected void initContentPane(JPanel jPanel, Object object) {
            jPanel.setLayout(new BorderLayout());
            JTextArea jTextArea = new JTextArea(CAPTION);
            jTextArea.setMargin(new Insets(5, 5, 5, 5));
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setOpaque(false);
            jPanel.add((Component)jTextArea, "North");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEtchedBorder());
            this.noSidesCB = new JCheckBox(RESET);
            jPanel2.add((Component)this.noSidesCB, "North");
            this.noSidesCB.addActionListener(this);
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            jPanel3.add((Component)new JLabel("Side In: "), gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.ipadx = 30;
            this.sidesInModel = new DefaultComboBoxModel();
            this.sidesInCB = new JComboBox(this.sidesInModel);
            this.sidesInCB.setRenderer(new DwdmSideRenderer());
            jPanel3.add((Component)this.sidesInCB, gridBagConstraints);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            jPanel3.add((Component)new JLabel("Side Out: "), gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.ipadx = 30;
            this.sidesOutModel = new DefaultComboBoxModel();
            this.sidesOutCB = new JComboBox(this.sidesOutModel);
            this.sidesOutCB.setRenderer(new DwdmSideRenderer());
            jPanel3.add((Component)this.sidesOutCB, gridBagConstraints);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            jPanel3.add((Component)new JPanel(), gridBagConstraints);
            jPanel2.add((Component)jPanel3, "Center");
            jPanel.add((Component)jPanel2, "Center");
            JPanel jPanel4 = new JPanel(new FlowLayout(2, 5, 5));
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(this);
            jPanel4.add(this.okButton);
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            jPanel4.add(this.cancelButton);
            jPanel.add((Component)jPanel4, "South");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.okButton) {
                this.ok();
            } else if (object == this.cancelButton) {
                this.cancel();
            } else if (object == this.noSidesCB) {
                this.reset();
            }
        }

        void initAndShow() {
            INetElement iNetElement = this.modelOrg.getSelectedIncluded();
            this.setTitle(TITLE + iNetElement.getName());
            ISideModel[] iSideModelArray = iNetElement.getNodeModel().getSideModels().getSides();
            this.sidesInModel.removeAllElements();
            this.sidesOutModel.removeAllElements();
            for (ISideModel iSideModel : iSideModelArray) {
                this.sidesInModel.addElement(iSideModel);
                this.sidesOutModel.addElement(iSideModel);
            }
            SidesConstraintsHolder sidesConstraintsHolder = this.modelOrg.getSideConstraint(iNetElement);
            if (sidesConstraintsHolder != null) {
                this.sidesInCB.setSelectedItem(sidesConstraintsHolder.getSideIn());
                this.sidesOutCB.setSelectedItem(sidesConstraintsHolder.getSideOut());
                this.noSidesCB.setSelected(false);
            } else {
                if (iSideModelArray.length > 0) {
                    this.sidesInCB.setSelectedItem(iSideModelArray[0]);
                    this.sidesOutCB.setSelectedItem(iSideModelArray[0]);
                }
                this.noSidesCB.setSelected(true);
            }
            this.reset();
            this.setVisible(true);
        }

        private void reset() {
            boolean bl = this.noSidesCB.isSelected();
            this.sidesInCB.setEnabled(!bl);
            this.sidesOutCB.setEnabled(!bl);
        }

        private void ok() {
            INetElement iNetElement = this.modelOrg.getSelectedIncluded();
            if (iNetElement != null) {
                Object object = this.sidesInCB.getSelectedItem();
                Object object2 = this.sidesOutCB.getSelectedItem();
                if (this.noSidesCB.isSelected()) {
                    this.modelOrg.clearSideConstraint(iNetElement);
                } else {
                    ISideModel iSideModel = (ISideModel)object;
                    ISideModel iSideModel2 = (ISideModel)object2;
                    if (iSideModel != null && iSideModel2 != null) {
                        this.modelOrg.setSideConstraint(iNetElement, iSideModel, iSideModel2);
                    }
                }
            }
            CcdOchRoutePane.this.updateMap();
            this.dispose();
        }

        private void cancel() {
            this.dispose();
        }
    }

    private class OrderedListModelOrganizer
    implements OrderedListListener,
    ActionListener {
        public JSplitPane constraintsSp;
        public JButton includeButton;
        public JButton excludeButton;
        public JButton advancedButton;
        public JButton applyButton;
        public JButton resetButton;
        private OrderedListModel includedModel;
        private OrderedListModel excludedModel;
        private Map<INetElement, SidesConstraintsHolder> sidesMap = new HashMap<INetElement, SidesConstraintsHolder>();
        private INetElement[] savedIncludedNes;
        private INetElement[] savedExcludedNes;
        private Map<INetElement, SidesConstraintsHolder> savedSidesMap = new HashMap<INetElement, SidesConstraintsHolder>();
        private OrderedListListener listener;

        public OrderedListModelOrganizer(OrderedListListener orderedListListener) {
            this.listener = orderedListListener;
            this.includedModel = new OrderedListModel(this, true);
            this.excludedModel = new OrderedListModel(this, true);
            this.savedIncludedNes = new INetElement[0];
            this.savedExcludedNes = new INetElement[0];
            this.initButton("Up");
            this.initButton("Down");
            this.initButton("Remove");
        }

        void saveLists() {
            this.savedIncludedNes = this.getIncludedNodes();
            this.savedExcludedNes = this.getExcludedNodes();
            this.savedSidesMap = new HashMap<INetElement, SidesConstraintsHolder>(this.sidesMap);
        }

        void restoreLists() {
            int n;
            this.includedModel.clearAll();
            for (n = 0; n < this.savedIncludedNes.length; ++n) {
                this.addIncluded(this.savedIncludedNes[n]);
            }
            this.excludedModel.clearAll();
            for (n = 0; n < this.savedExcludedNes.length; ++n) {
                this.addExcluded(this.savedExcludedNes[n]);
            }
            this.sidesMap.clear();
            for (INetElement iNetElement : this.savedSidesMap.keySet()) {
                SidesConstraintsHolder sidesConstraintsHolder = this.savedSidesMap.get(iNetElement);
                this.setSideConstraint(iNetElement, sidesConstraintsHolder.getSideIn(), sidesConstraintsHolder.getSideOut());
            }
        }

        boolean anyChange() {
            int n;
            INetElement[] iNetElementArray = this.getIncludedNodes();
            INetElement[] iNetElementArray2 = this.getExcludedNodes();
            if (iNetElementArray.length != this.savedIncludedNes.length) {
                return true;
            }
            if (iNetElementArray2.length != this.savedExcludedNes.length) {
                return true;
            }
            if (this.sidesMap.size() != this.savedSidesMap.size()) {
                return true;
            }
            for (n = 0; n < iNetElementArray.length; ++n) {
                if (iNetElementArray[n].getNodeId() == this.savedIncludedNes[n].getNodeId()) continue;
                return true;
            }
            for (n = 0; n < iNetElementArray2.length; ++n) {
                boolean bl = false;
                for (int i = 0; i < this.savedExcludedNes.length; ++i) {
                    if (iNetElementArray2[n].getNodeId() != this.savedExcludedNes[i].getNodeId()) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return true;
            }
            for (INetElement iNetElement : this.sidesMap.keySet()) {
                if (this.savedSidesMap.get(iNetElement) == this.sidesMap.get(iNetElement)) continue;
                return true;
            }
            return false;
        }

        private void initButton(String string) {
            AbstractButton abstractButton = this.getButton(string);
            if (abstractButton != null) {
                ActionListener[] actionListenerArray = abstractButton.getActionListeners();
                for (int i = 0; i < actionListenerArray.length; ++i) {
                    abstractButton.removeActionListener(actionListenerArray[i]);
                }
                abstractButton.addActionListener(this);
            }
        }

        public int getSelectedIndex() {
            return this.getIncludedList().getSelectedIndex() == -1 ? this.getExcludedList().getSelectedIndex() : this.getIncludedList().getSelectedIndex();
        }

        public void syncButtons() {
            INetElement iNetElement = this.getSelectedIncluded();
            this.advancedButton.setEnabled(iNetElement != null && iNetElement.getNodeModel().provides(Feature.OPTICAL_SIDE));
            int n = this.getSelectedIndex();
            this.getButton("Remove").setEnabled(n >= 0);
            this.getButton("Up").setEnabled(n > 0);
            this.getButton("Down").setEnabled(n >= 0 && n < this.getSizeOfSelectedList() - 1);
        }

        JList getIncludedList() {
            return this.includedModel.getJList();
        }

        JList getExcludedList() {
            return this.excludedModel.getJList();
        }

        void addIncluded(INetElement iNetElement) {
            this.includedModel.add(iNetElement, iNetElement.getName());
        }

        INetElement getSelectedIncluded() {
            return (INetElement)this.includedModel.getSelectedEntry();
        }

        void setSideConstraint(INetElement iNetElement, ISideModel iSideModel, ISideModel iSideModel2) {
            SidesConstraintsHolder sidesConstraintsHolder = new SidesConstraintsHolder(iSideModel, iSideModel2);
            this.sidesMap.put(iNetElement, sidesConstraintsHolder);
            this.includedModel.replaceText(iNetElement, iNetElement.getName() + this.getSidesString(sidesConstraintsHolder));
        }

        void clearSideConstraint(INetElement iNetElement) {
            this.sidesMap.remove(iNetElement);
            this.includedModel.replaceText(iNetElement, iNetElement.getName());
        }

        boolean hasSideConstraint(INetElement iNetElement) {
            return this.sidesMap.get(iNetElement) != null;
        }

        SidesConstraintsHolder getSideConstraint(INetElement iNetElement) {
            return this.sidesMap.get(iNetElement);
        }

        INetElement[] getIncludedNodes() {
            return this.includedModel.getContent().toArray(new INetElement[0]);
        }

        void addExcluded(INetElement iNetElement) {
            this.excludedModel.add(iNetElement, iNetElement.getName());
        }

        INetElement[] getExcludedNodes() {
            return this.excludedModel.getContent().toArray(new INetElement[0]);
        }

        void clearAll() {
            this.includedModel.clearAll();
            this.excludedModel.clearAll();
            this.sidesMap.clear();
            this.saveLists();
        }

        String getRankString(INetElement iNetElement) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.includedModel.contains(iNetElement)) {
                int n = this.includedModel.getContent().indexOf(iNetElement) + 1;
                stringBuilder.append("(").append(n).append(")");
            } else if (this.excludedModel.contains(iNetElement)) {
                stringBuilder.append(CcdOchRoutePane.EXCLUDE_LABEL);
            }
            if (this.hasSideConstraint(iNetElement)) {
                stringBuilder.append(this.getSidesString(this.getSideConstraint(iNetElement)));
            }
            return stringBuilder.toString();
        }

        public boolean contains(Object object) {
            return this.includedModel.contains(object) || this.excludedModel.contains(object);
        }

        public int getSize() {
            return this.includedModel.getSize() + this.excludedModel.getSize();
        }

        private int getSizeOfSelectedList() {
            if (this.includedModel.getSelectedEntry() != null) {
                return this.includedModel.getSize();
            }
            if (this.excludedModel.getSelectedEntry() != null) {
                return this.excludedModel.getSize();
            }
            return 0;
        }

        public AbstractButton getButton(String string) {
            return this.includedModel.getButton(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.applyAction(this.includedModel, actionEvent);
            this.applyAction(this.excludedModel, actionEvent);
        }

        public void applyAction(OrderedListModel orderedListModel, ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = orderedListModel.getJList().getSelectedIndex();
            if (n < 0) {
                return;
            }
            if (string == "Up") {
                orderedListModel.swapEntries(n - 1);
            } else if (string == "Down") {
                orderedListModel.swapEntries(n);
            } else if (string == "Remove") {
                orderedListModel.remove(orderedListModel.getSelectedEntry());
            }
            this.syncButtons();
        }

        private String getSidesString(SidesConstraintsHolder sidesConstraintsHolder) {
            return ", sides " + DwdmSide.getSideFromOffset(sidesConstraintsHolder.getSideIn().getId()) + "-" + DwdmSide.getSideFromOffset(sidesConstraintsHolder.getSideOut().getId());
        }

        public void selectionChanged(Object object, Object object2) {
            if (object2 != null && this.includedModel.getSelectedEntry() != null && this.excludedModel.getSelectedEntry() != null) {
                if (this.includedModel.contains(object2)) {
                    this.excludedModel.getJList().clearSelection();
                } else {
                    this.includedModel.getJList().clearSelection();
                }
            }
            this.syncButtons();
            this.listener.selectionChanged(object, object2);
        }

        public void orderSwapped(Object object, Object object2) {
            this.listener.orderSwapped(object, object2);
        }

        public void entryRemoved(Object object) {
            this.listener.entryRemoved(object);
        }
    }
}

