/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ui.CircuitNameException;
import cerent.cms.ui.OpticalChannelAttr;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.circuits.AbstractAdminStatePanel;
import cerent.cms.ui.circuits.AbstractCcdAttrsPane;
import cerent.cms.ui.circuits.CcdOCHNCAttrsPane;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.IAdminStatePanel;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CcdOchTrailAttrsPane
extends CcdOCHNCAttrsPane {
    public static HashMap cktSizesMap = new HashMap();

    public CcdOchTrailAttrsPane(CircuitCreationDialog circuitCreationDialog, WzDiagDebug wzDiagDebug, String string) {
        super(circuitCreationDialog, wzDiagDebug, string);
    }

    protected void addLeftPane() {
        super.addLeftPane();
        this.biDirAttr.setEnabled(false);
        this.singleNodeOchncAttr.getUI().setVisible(false);
        this.circuitSizeAttr.setEnabled(false);
    }

    protected void addRightPane() {
        this.paneGc.gridy = 6;
        this.paneGc.weightx = 1.0;
        this.paneGc.weighty = 1.0;
        this.paneGc.gridheight = 0;
        this.add(Box.createVerticalGlue(), this.paneGc);
        this.paneGc.gridx = 2;
        this.paneGc.gridy = 0;
        this.paneGc.weightx = 1.0;
        this.paneGc.weighty = 1.0;
        this.paneGc.gridwidth = 0;
        this.add(Box.createHorizontalGlue(), this.paneGc);
    }

    protected void addOptDir(JPanel jPanel, GridBagConstraints gridBagConstraints) {
    }

    protected OpticalChannelAttr getOpticalChannelAttr() {
        return new OpticalChannelAttr(2);
    }

    protected AbstractCcdAttrsPane.AdminStateAttr getAdminStateAttr() {
        this.adminStateAttr = new OchTrailAdminStateAttr();
        return this.adminStateAttr;
    }

    protected void parseAdminAttr(ArrayList arrayList) {
        arrayList.add(this.parseAttr(this.adminStateAttr.getStateString()));
    }

    public void revalidateData() {
        super.revalidateData();
        this.biDirAttr.setEnabled(false);
    }

    public void validatePage() throws Exception {
        super.validatePage();
        String string = this.circuitNameAttr.getCircuitNameUnsafe();
        if (!OchTrailHelper.isValidCRSOchTrailCircuitName(string)) {
            String string2 = new String("The specified circuit name does not meet the requirements for creating an OCH trail circuit with CRS nodes.\nDo you want to continue ?");
            if (!CerentDialog.yesNoDialog((Component)this.parent, (String)string2, (String)"Circuit Name Confirmation")) {
                throw new CircuitNameException("Circuit name contains characters invalid for CRS ochtrail");
            }
            this.db.println("circuitName " + string + " not valid for CRS ochtrail circuits, the user choose to continue.");
        }
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.getStatusText());
        return stringBuffer.toString();
    }

    protected boolean isPossibleProtectionCheck() {
        return false;
    }

    static class OchTrailAdminStatePanel
    extends AbstractAdminStatePanel
    implements IAdminStatePanel,
    ActionListener,
    ChangeListener {
        private DefaultComboBoxModel adminStateCBModel;
        protected JLabel adminStateLB;
        protected JCheckBox applyToPortsCB;
        protected UComboBox portStateCB;
        protected Attribute[] adminStateAttrs;
        protected Attribute[] portAdminStateAttrs;

        public OchTrailAdminStatePanel() {
            this(false);
        }

        public OchTrailAdminStatePanel(boolean bl) {
            int n;
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createTitledBorder("State"));
            JPanel jPanel = WzPane.createHorizontalPanel(null);
            jPanel.setAlignmentX(0.0f);
            this.adminStateLB = new JLabel("State: ");
            jPanel.add(this.adminStateLB);
            this.adminStateAttrs = this.getAdminAttrs(bl);
            this.adminStateCB = new UComboBox((Object[])this.adminStateAttrs);
            jPanel.add((Component)this.adminStateCB);
            Attribute attribute = null;
            for (n = 0; n < this.adminStateAttrs.length; ++n) {
                if (this.adminStateAttrs[n].getIntValue() != 3) continue;
                attribute = this.adminStateAttrs[n];
            }
            this.adminStateCB.setSelectedItem(attribute);
            this.adminStateCB.addActionListener((ActionListener)this);
            this.add(jPanel);
            jPanel = WzPane.createHorizontalPanel(null);
            jPanel.setAlignmentX(0.0f);
            this.applyToPortsCB = new JCheckBox(" Apply to trunk ports ");
            this.applyToPortsCB.setSelected(false);
            jPanel.add(this.applyToPortsCB);
            this.applyToPortsCB.addChangeListener(this);
            this.portAdminStateAttrs = this.getPortAdminAttrs();
            this.portStateCB = new UComboBox((Object[])this.portAdminStateAttrs);
            attribute = null;
            for (n = 0; n < this.portAdminStateAttrs.length; ++n) {
                if (this.portAdminStateAttrs[n].getIntValue() != 0) continue;
                attribute = this.portAdminStateAttrs[n];
            }
            this.portStateCB.setSelectedItem((Object)attribute);
            jPanel.add((Component)this.portStateCB);
            this.add(jPanel);
            this.setAdminState(bl ? -2 : 3);
            this.enablePortsCB();
            this.adjustPortsCB();
        }

        Attribute[] getAdminAttrs(boolean bl) {
            Attribute[] attributeArray = NetAdminState.getAdminStateAttrs();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            for (int i = 0; i < attributeArray.length; ++i) {
                int n = attributeArray[i].getIntValue();
                if (n == 4 || n != 3 && n != 1 && (n == 0 || n == 2)) continue;
                arrayList.add(attributeArray[i]);
            }
            if (bl) {
                arrayList.add(NetAdminState.NO_CHANGE_ATTR);
            }
            return arrayList.toArray(new Attribute[0]);
        }

        Attribute[] getPortAdminAttrs() {
            Attribute[] attributeArray = NetAdminState.getAdminStateAttrs();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            for (int i = 0; i < attributeArray.length; ++i) {
                int n = attributeArray[i].getIntValue();
                if (n == 4 || n == 3 || n != 1 && n != 0 && n == 2) continue;
                arrayList.add(attributeArray[i]);
            }
            return arrayList.toArray(new Attribute[0]);
        }

        public int getAdminState() {
            return ((Attribute)this.adminStateCB.getSelectedItem()).getIntValue();
        }

        public void setAdminState(int n) {
            if (this.getAdminState() == n) {
                return;
            }
            for (int i = 0; i < this.adminStateAttrs.length; ++i) {
                if (this.adminStateAttrs[i].getIntValue() != n) continue;
                this.adminStateCB.setSelectedItem((Object)this.adminStateAttrs[i]);
            }
        }

        public void disableAll() {
            this.adminStateCB.setEnabled(false);
            this.adminStateLB.setEnabled(false);
            this.applyToPortsCB.setEnabled(false);
            this.portStateCB.setEnabled(false);
        }

        public void enableAll() {
            this.adminStateCB.setEnabled(true);
            this.adminStateLB.setEnabled(true);
            this.enablePortsCB();
        }

        public JPanel getPanel() {
            return this;
        }

        public boolean getApplyDropPorts() {
            return this.applyToPortsCB.isSelected();
        }

        public void setApplyDropPorts(boolean bl) {
            this.applyToPortsCB.setSelected(bl);
        }

        public void setApplyDropPortsApplicable(boolean bl) {
        }

        public boolean isDropPortsSelected() {
            return this.applyToPortsCB.isSelected();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.adminStateCB) {
                this.enablePortsCB();
                this.adjustPortsCB();
            }
        }

        protected void enablePortsCB() {
            int n = this.getAdminState();
            boolean bl = n != -2;
            this.applyToPortsCB.setEnabled(bl);
        }

        protected void adjustPortsCB() {
            this.portStateCB.setEnabled(this.applyToPortsCB.isEnabled() && this.applyToPortsCB.isSelected());
        }

        public int getPortsState() {
            return ((Attribute)this.portStateCB.getSelectedItem()).getIntValue();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == this.applyToPortsCB) {
                this.adjustPortsCB();
            }
        }

        protected boolean isIS(int n) {
            return super.isIS(n) || n == 3;
        }
    }

    class OchTrailAdminStateAttr
    extends AbstractCcdAttrsPane.AdminStateAttr {
        OchTrailAdminStateAttr() {
            this.adminStatePanel = new OchTrailAdminStatePanel();
        }

        public String getApplyDropString() {
            String string = this.adminStatePanel.getApplyDropPorts() ? "True" : "False";
            return "Apply to drop ports: " + string;
        }

        public String getShortApplyDropString() {
            return this.getApplyDropString();
        }

        public String getPortsStateString() {
            return "Ports state: " + NetAdminState.getAdminStateStringFromAdminState(((OchTrailAdminStatePanel)this.adminStatePanel).getPortsState());
        }
    }
}

