/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.circuits.SanityCheckException;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.DriNodes;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzStatusPanel;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AutorangeInfo;
import cerent.cms.ui.circuits.BlsrDriDialog;
import cerent.cms.ui.circuits.CcdCircuitDesignPane;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.RoutingConstraint;
import cerent.cms.ui.circuits.UnprotectedToUpsrDialog;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridPanel;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.OrderedListListener;
import com.cisco.ctc.util.map.AbstractLink;
import com.cisco.ctc.util.map.AbstractNode;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.Node;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.LabelUI;

public class CcdRouteConstraintPane
extends CcdCircuitDesignPane
implements OrderedListListener,
ListSelectionListener {
    static final String RANK = "0";
    static final String PREF = "ctc.RouteConstraintPane";
    MapNode selectedNode;
    MapLink selectedLink;
    AbstractNetLink selectedNetLink;
    static final String TOP_BORDER = "Selected Node / Link: ";
    static final String RC_LEFT_BORDER = "Required Nodes / Links: ";
    JPanel dispPanel;
    JTextField dispTF;
    protected INodeModel srcNode;
    protected INodeModel dstNode;
    JList exclusionList;
    ArrayList exclusionArrayList;
    DefaultListModel exclusionListModel;
    JPanel exclusionPanel;
    JButton exclusionButton;
    static final String INCLUDE = "Include";
    static final String EXCLUDE = "Exclude";
    static final String EXCLUDE_LABEL = "Excluded";
    static final String EXCLUDE_BORDER = "Excluded Nodes / Links: ";
    String statusText;
    JButton blsrDriButton;
    boolean usesDri = false;
    String BLSRDRI_TITLE = CircuitMapUtil.BLSRDRI_TERM + " Primary and Secondary Node Selection";
    String PREF_BLSRDRI_VALUE = "warnBlsrDriButtonUse";
    String PREF_BLSRDRI_DESCR = "This button is for " + CircuitMapUtil.BLSRDRI_TERM + " assignment only";
    JSplitPane splitPane;
    boolean bIsBlsrDriCkt = false;

    public String getShortName() {
        return "Constraints For Automatic Routing";
    }

    public RoutePrefs getRoutePrefs() {
        return this.getAbstractCktDlg().getRoutePrefs();
    }

    public CcdRouteConstraintPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string, boolean bl) {
        super(abstractCircuitDialog, wzDiagDebug, string, bl);
        this.exclusionArrayList = new ArrayList();
        this.exclusionListModel = new DefaultListModel();
        this.exclusionList = new JList(this.exclusionListModel);
        this.exclusionList.addListSelectionListener(this);
        this.olm.setListRenderer(new MultiLineRenderer());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            if (this.selectedNode != null) {
                this.addNode();
            } else if (this.selectedLink != null) {
                this.addLink();
            }
        } else if (object == this.exclusionButton) {
            if (this.selectedNode != null) {
                this.excludeNode();
            } else if (this.selectedLink != null) {
                this.excludeLink();
            }
        } else if (object == this.removeButton) {
            int n = this.exclusionList.getSelectedIndex();
            if (n >= 0) {
                Object e = this.exclusionArrayList.get(n);
                if (e instanceof INetElement) {
                    MapNode mapNode = this.getMapNode((INetElement)e);
                    this.removeNode(mapNode);
                } else if (e instanceof INetLink) {
                    MapLink mapLink = this.getMapLink((INetLink)e);
                    mapLink.removeArrows();
                    this.circuitMap.setNetMapLinkState("AP:REMOVEBUTTON", mapLink, 2);
                    this.circuitMap.setSelected(mapLink, false);
                }
                this.exclusionArrayList.remove(n);
                this.exclusionListModel.remove(n);
                if (n < this.exclusionArrayList.size()) {
                    this.exclusionList.setSelectedIndex(n);
                } else if (!this.exclusionArrayList.isEmpty()) {
                    this.exclusionList.setSelectedIndex(n - 1);
                } else if (this.exclusionArrayList.isEmpty()) {
                    this.dispTF.setText(" ");
                    this.removeButton.setEnabled(false);
                }
            }
        } else if (object == this.blsrDriButton) {
            this.getBlsrDriNodes();
        }
    }

    protected void openDialog() {
        IgnorableDialog.infoDialog((Component)this.parent, (String)("This button is used to select primary  and secondary\nnodes for one or more " + CircuitMapUtil.BLSRDRI_TERM + "s in this circuit.\n" + "If you intend to create a " + CircuitMapUtil.UPSRDRI_TERM + ", do not use\n" + "this button: use the \"Include\" button " + "instead.\n"), (String)this.BLSRDRI_TITLE, (String)this.PREF_BLSRDRI_VALUE, (String)this.PREF_BLSRDRI_DESCR);
    }

    protected void getBlsrDriNodes() {
        this.openDialog();
        MapNode[] mapNodeArray = this.circuitMap.getMapNodes();
        Vector<MapNode> vector = new Vector<MapNode>(mapNodeArray.length);
        for (int i = 0; i < mapNodeArray.length; ++i) {
            INetElement iNetElement = this.getNetElement(mapNodeArray[i]);
            if (this.exclusionArrayList.contains(iNetElement) || this.olmContainsRoutingConstraint(iNetElement, 2)) continue;
            INodeModel iNodeModel = this.getNodeModel(mapNodeArray[i]);
            if (iNodeModel != null && iNodeModel.provides(Feature.BLSR_UPSR_DRI)) {
                vector.add(mapNodeArray[i]);
                continue;
            }
            if (!this.db.on()) continue;
            this.db.println("Not eligible for BLSR-DRI, either null or does not support feature:\n\t" + mapNodeArray[i] + "\tNodeModel=" + iNodeModel);
        }
        RoutingConstraint routingConstraint = BlsrDriDialog.getRoutingConstraint(vector, true, this.parent);
        this.updateMapView(routingConstraint);
    }

    protected void updateMapView(RoutingConstraint routingConstraint) {
        if (routingConstraint != null) {
            ArrayList arrayList = routingConstraint.getPriElemConstraintList();
            if (arrayList != null && arrayList.size() > 0) {
                Object e = arrayList.get(0);
                if (!this.olmContainsRoutingConstraint(e, 2)) {
                    this.olm.add(routingConstraint, routingConstraint.getLabel());
                    this.refreshOrder();
                } else if (this.db.on()) {
                    this.db.println("olm contains primary; don't add.");
                }
            } else if (this.db.on()) {
                this.db.println("problem with primary list! don't add.");
            }
        }
    }

    private void saveSelectedNode(MapNode mapNode) {
        this.selectedNode = mapNode;
    }

    private void saveSelectedLink(MapLink mapLink) {
        this.selectedLink = mapLink;
    }

    private synchronized RoutingConstraint getRoutingConstraintFromOlm(Object object) {
        return this.getRoutingConstraintFromOlm(object, false);
    }

    protected synchronized RoutingConstraint getRoutingConstraintFromOlm(Object object, boolean bl) {
        ArrayList<Object> arrayList = this.olm.getContent();
        if (object instanceof INetElement) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ArrayList arrayList2;
                RoutingConstraint routingConstraint = (RoutingConstraint)arrayList.get(i);
                if (!(bl ? (arrayList2 = routingConstraint.getPriElemConstraintList()) != null && arrayList2.size() > 0 && arrayList2.get(0) == object : routingConstraint.containsNetElement(object, 0))) continue;
                return routingConstraint;
            }
        } else if (object instanceof INetLink) {
            for (int i = 0; i < arrayList.size(); ++i) {
                RoutingConstraint routingConstraint = (RoutingConstraint)arrayList.get(i);
                if (!routingConstraint.containsNetLink(object)) continue;
                return routingConstraint;
            }
        } else if (this.db.on()) {
            this.db.println(object + " is a bad container object!!!");
        }
        return null;
    }

    protected synchronized boolean olmContainsRoutingConstraint(Object object) {
        return this.olmContainsRoutingConstraint(object, 0);
    }

    protected synchronized boolean olmContainsRoutingConstraint(Object object, int n) {
        ArrayList<Object> arrayList = this.olm.getContent();
        if (object instanceof INetElement) {
            for (int i = 0; i < arrayList.size(); ++i) {
                RoutingConstraint routingConstraint = (RoutingConstraint)arrayList.get(i);
                if (!routingConstraint.containsNetElement(object, n)) continue;
                return true;
            }
        } else if (object instanceof INetLink) {
            for (int i = 0; i < arrayList.size(); ++i) {
                RoutingConstraint routingConstraint = (RoutingConstraint)arrayList.get(i);
                if (!routingConstraint.containsNetLink(object)) continue;
                return true;
            }
        } else if (this.db.on()) {
            this.db.println(object + " is a bad container object!!!");
        }
        return false;
    }

    protected synchronized RoutingConstraint addRoutingConstraintToOlm(Object object, String string) {
        RoutingConstraint routingConstraint = null;
        if (object instanceof INetElement) {
            routingConstraint = new RoutingConstraint(1);
            routingConstraint.addElementConstraint(object);
            routingConstraint.setLabel(string);
            this.olm.add(routingConstraint, string);
        } else if (object instanceof INetLink) {
            routingConstraint = new RoutingConstraint(0);
            routingConstraint.addLinkConstraint(object);
            routingConstraint.setLabel(string);
            MapLink mapLink = this.getMapLink((INetLink)object);
            if (mapLink != null) {
                routingConstraint.arrowType = !mapLink.isSrcArrowEnabled() ? 1 : 2;
            }
            this.olm.add(routingConstraint, string);
        } else if (object instanceof RoutingConstraint) {
            this.olm.add(object, ((RoutingConstraint)object).getLabel());
        } else if (this.db.on()) {
            this.db.println(object + " is a bad add route constraint to olm!");
            this.db.println("doing nothing!");
        }
        return routingConstraint;
    }

    private void addNode() {
        if (this.selectedNode != null) {
            MapNode mapNode = this.selectedNode;
            INodeModel iNodeModel = (INodeModel)mapNode.getUserObject();
            String string = iNodeModel.getName();
            INetElement iNetElement = this.getNetElement(mapNode);
            RoutingConstraint routingConstraint = null;
            boolean bl = this.olmContainsRoutingConstraint(iNetElement, 0);
            boolean bl2 = this.olmContainsRoutingConstraint(iNetElement, 1);
            if (bl) {
                if (this.db.on()) {
                    this.db.println("Don't add; " + string + " already a primary " + "constraint");
                }
            } else if (bl2) {
                if (this.db.on()) {
                    this.db.println("Don't add; " + string + " already a secondary " + "constraint");
                }
            } else {
                routingConstraint = this.addRoutingConstraintToOlm(iNetElement, string);
            }
            this.addButton.setEnabled(false);
            this.exclusionButton.setEnabled(false);
            this.olm.getJList().clearSelection();
            String string2 = this.getRank(iNetElement);
            String string3 = RoutingConstraint.getBlsrDriString(routingConstraint, iNetElement);
            if (string3 != null) {
                string2 = string2 + " " + string3;
            }
            mapNode.addDesc(string2);
            this.circuitMap.setSelected(mapNode, false);
            this.unSelectVnodes(mapNode);
        }
    }

    private void excludeNode() {
        if (this.selectedNode != null) {
            this.excludeNode(this.selectedNode);
        }
    }

    protected void excludeNode(MapNode mapNode) {
        if (!this.exclusionArrayList.contains(this.getNetElement(mapNode))) {
            this.exclusionArrayList.add(this.getNetElement(mapNode));
            INodeModel iNodeModel = (INodeModel)mapNode.getUserObject();
            String string = iNodeModel.getName();
            this.exclusionListModel.addElement(string);
            mapNode.addDesc(EXCLUDE_LABEL);
            this.exclusionList.updateUI();
        }
        this.addButton.setEnabled(false);
        this.exclusionButton.setEnabled(false);
        this.exclusionList.clearSelection();
        this.circuitMap.setSelected(mapNode, false);
        this.unSelectVnodes(mapNode);
    }

    void getMoreUIs() {
        this.bottomPanel.setLayout(new BorderLayout());
        JPanel jPanel = CcdRouteConstraintPane.createHorizontalPanel(null);
        this.bottomPanel.add((Component)jPanel, "North");
        this.exclusionPanel = CcdRouteConstraintPane.createVerticalPanel(null);
        this.splitPane = new JSplitPane(1, false, this.leftPanel, this.exclusionPanel);
        this.bottomPanel.add(this.splitPane);
        this.buttonWrapPanel = CcdRouteConstraintPane.createVerticalPanel(null);
        this.bottomPanel.add((Component)this.buttonWrapPanel, "East");
        this.dispTF = new JTextField();
        this.dispTF.setEditable(false);
        jPanel.add(this.dispTF);
        jPanel.setBorder(BorderFactory.createTitledBorder(TOP_BORDER));
        this.leftPanel.setBorder(BorderFactory.createTitledBorder(RC_LEFT_BORDER));
        double d = this.leftPanel.getPreferredSize().getWidth();
        double d2 = this.leftPanel.getPreferredSize().getHeight();
        this.leftPanel.setPreferredSize(new Dimension((int)d, (int)d2));
        this.exclusionPanel.setBorder(BorderFactory.createTitledBorder(EXCLUDE_BORDER));
        this.exclusionPanel.add(new JScrollPane(this.exclusionList));
        this.rightPanel.remove(this.displayPanel);
        this.buttonWrapPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.buttonWrapPanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(6, 1, 2, 2));
        this.blsrDriButton = new JButton("Add " + CircuitMapUtil.BLSRDRI_TERM + "...");
        this.buttonPanel.add(this.blsrDriButton);
        this.blsrDriButton.setHorizontalAlignment(0);
        this.blsrDriButton.setEnabled(true);
        this.blsrDriButton.setVisible(false);
        this.blsrDriButton.addActionListener(this);
        this.addButton = new JButton(INCLUDE);
        this.buttonPanel.add(this.addButton);
        this.addButton.setHorizontalAlignment(0);
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(this);
        this.exclusionButton = new JButton(EXCLUDE);
        this.buttonPanel.add(this.exclusionButton);
        this.exclusionButton.setHorizontalAlignment(0);
        this.exclusionButton.setEnabled(false);
        this.exclusionButton.addActionListener(this);
        this.upButton = this.olm.getButton("Up");
        this.buttonPanel.add(this.upButton);
        this.upButton.setHorizontalAlignment(0);
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(this);
        this.downButton = this.olm.getButton("Down");
        this.buttonPanel.add(this.downButton);
        this.downButton.setHorizontalAlignment(0);
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(this);
        this.removeButton = this.olm.getButton("Remove");
        this.buttonPanel.add(this.removeButton);
        this.removeButton.setHorizontalAlignment(0);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
    }

    protected String getNextPaneName() {
        if (this.getAbstractCktDlg().isLoCkt()) {
            return CircuitCreationDialog.WZPANE_GET_LO;
        }
        if (!this.getAbstractCktDlg().isAutoRoute() || this.getAbstractCktDlg().isAutoRoute() && this.getAbstractCktDlg().isRrbc()) {
            return "Route Review/Edit";
        }
        return null;
    }

    public boolean handleBack() {
        boolean bl = true;
        if (this.olm.getSize() > 0 || this.getExcList().size() > 0) {
            bl = CerentDialog.yesNoDialog((Component)this, (String)"Route constraints will be lost.\nAre you sure you want to go BACK?", (String)this.getName());
        }
        if (bl) {
            this.recycle();
            return super.handleBack();
        }
        if (!this.getAbstractCktDlg().isRrbc() && !this.getAbstractCktDlg().isLoCkt()) {
            this.getAbstractCktDlg().setFinishEnabled(true);
        }
        return false;
    }

    protected boolean useDRI() {
        return Preferences.instance().getBoolean("ctc.circuit.creation", "dri", false);
    }

    protected void enteringPaneBackwards() {
        this.refreshOrder();
    }

    public void enteringPane() {
        if (!this.goingForward) {
            this.enteringPaneBackwards();
        }
        super.enteringPane();
        this.splitPane.setDividerLocation(0.5);
        if (this.getAbstractCktDlg().isPathProt()) {
            this.leftPanel.setBorder(BorderFactory.createTitledBorder("Required Nodes / Links: (working path only)"));
        } else {
            this.leftPanel.setBorder(BorderFactory.createTitledBorder(RC_LEFT_BORDER));
        }
        this.srcNode = this.getAbstractCktDlg().getSourceNode();
        this.dstNode = this.getAbstractCktDlg().getDestNode();
        boolean bl = this.getAbstractCktDlg().isRrbc() || this.getAbstractCktDlg().isLoCkt();
        this.getAbstractCktDlg().setNextEnabled(bl);
        this.getAbstractCktDlg().setFinishEnabled(!bl);
        this.unSetNode();
        this.unSetLink();
        this.addButton.setEnabled(false);
        this.exclusionButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        if (!this.getAbstractCktDlg().getCircuit().getCircuitTypeObj().isVcatCircuitType()) {
            boolean bl2 = this.useDRI() && (this.getAbstractCktDlg().getCircuit().getCircuitTypeObj().isHoCircuitType() || this.getAbstractCktDlg().getCircuit().getCircuitTypeObj().isHoVcatCircuitType());
            this.blsrDriButton.setVisible(bl2);
        }
        this.bIsBlsrDriCkt = false;
        this.cleanup();
        INetCircuit iNetCircuit = this.getAbstractCktDlg().getCircuit().useLAP();
        if (iNetCircuit != null) {
            this.addLapAsConstraint(iNetCircuit);
        }
        if (!this.getAbstractCktDlg().getCircuit().getXmCircuitEnds().isEmpty()) {
            this.addXmNodeAsConstraint();
        }
        this.mapConstraints();
    }

    protected void mapConstraints() {
        Object object;
        RoutingConstraint routingConstraint;
        int n;
        for (n = 0; n < this.olm.getSize(); ++n) {
            ActionListener actionListener;
            Object object2;
            int n2;
            routingConstraint = (RoutingConstraint)this.olm.getContent().get(n);
            if (routingConstraint.isLinkConstraint()) {
                object = routingConstraint.getLinkConstraintList();
                for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
                    object2 = (INetLink)((ArrayList)object).get(n2);
                    actionListener = this.getMapLink((INetLink)object2);
                    if (object2.isLAP() && actionListener == null) {
                        this.circuitMap.addLink((INetLink)object2, null);
                        actionListener = this.circuitMap.getDirectionalMapLink((INetLink)object2);
                    }
                    if (routingConstraint.arrowType == 1) {
                        ((MapLink)actionListener).setTargetArrow();
                    } else {
                        ((MapLink)actionListener).setSrcArrow();
                    }
                    ((AbstractLink)((Object)actionListener)).addAnnotation(RANK, this.getRank(object2));
                    this.circuitMap.setNetMapLinkState("mapConstraints0()", (MapLink)actionListener, 3);
                }
                continue;
            }
            if (!routingConstraint.isElemConstraint()) continue;
            object = routingConstraint.getPriElemConstraintList();
            for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
                object2 = (INetElement)((ArrayList)object).get(n2);
                actionListener = this.getMapNode((INetElement)object2);
                ((MapNode)actionListener).addDesc(this.getRank(object2));
            }
        }
        for (n = 0; n < this.exclusionArrayList.size(); ++n) {
            ActionListener actionListener;
            routingConstraint = this.exclusionArrayList.get(n);
            if (routingConstraint instanceof INetLink) {
                object = (INetLink)((Object)routingConstraint);
                actionListener = this.getMapLink((INetLink)object);
                if (((String)this.exclusionListModel.elementAt(n)).indexOf(this.circuitMap.getLinkDesc((MapLink)actionListener)) > -1) {
                    ((MapLink)actionListener).setTargetArrow();
                } else {
                    ((MapLink)actionListener).setSrcArrow();
                }
                this.circuitMap.setNetMapLinkState("mapConstraints1()", (MapLink)actionListener, 6);
                continue;
            }
            if (!(routingConstraint instanceof INetElement)) continue;
            object = (INetElement)((Object)routingConstraint);
            actionListener = this.getMapNode((INetElement)object);
            ((MapNode)actionListener).addDesc(EXCLUDE_LABEL);
        }
        this.refreshOrder();
    }

    protected void addLapAsConstraint(INetCircuit iNetCircuit) {
        INetLink iNetLink = null;
        if (iNetCircuit != null) {
            Object object2;
            INetCircuit iNetCircuit2 = this.getAbstractCktDlg().getCircuit();
            boolean bl = false;
            for (Object object2 : iNetCircuit2.getDrops()) {
                try {
                    if (NetCircuitManager.instance().getLAPHo(((NetCircuitDropInfo)object2).getNodeModel(), ((NetCircuitDropInfo)object2).getEntityModel(), ((NetCircuitDropInfo)object2).getHoNum()) == null) continue;
                    iNetLink = iNetCircuit.getReverseLapLink();
                    bl = true;
                    break;
                }
                catch (ObjNotFound objNotFound) {
                    if (!this.db.on()) continue;
                    WzDiagDebug.printStackTrace((Throwable)objNotFound);
                }
            }
            if (!bl) {
                iNetLink = iNetCircuit.getLapLink();
            }
            this.circuitMap.addLink(iNetLink, null);
            MapLink mapLink = this.circuitMap.getDirectionalMapLink(iNetLink);
            if (!this.olmContainsRoutingConstraint(iNetLink)) {
                this.addRoutingConstraintToOlm(iNetLink, this.circuitMap.getLinkDesc(mapLink) + " (" + CircuitMapUtil.LAP_TERM + ")");
            }
            object2 = this.olm.getSelectedEntry();
            this.updateRmUpDownButtons(object2);
        }
    }

    protected void addXmNodeAsConstraint() {
        INetElement iNetElement = ((INetCircuitEnd)this.getAbstractCktDlg().getCircuit().getXmCircuitEnds().get(0)).getNetElement();
        if (iNetElement == this.getAbstractCktDlg().getCircuit().getPrimarySource().getNetElement() || iNetElement == ((INetCircuitEnd)this.getAbstractCktDlg().getCircuit().getDrops().get(0)).getNetElement()) {
            return;
        }
        INodeModel iNodeModel = iNetElement.getNodeModel();
        String string = iNodeModel.getName();
        MapNode mapNode = this.getMapNode(iNetElement);
        if (mapNode == null) {
            return;
        }
        if (!this.olmContainsRoutingConstraint(iNetElement)) {
            this.addRoutingConstraintToOlm(iNetElement, string);
        }
        Object object = this.olm.getSelectedEntry();
        this.updateRmUpDownButtons(object);
    }

    public void selectionChanged(Object object, Object object2) {
        MapLink mapLink;
        Object object3;
        ArrayList arrayList;
        MapNode mapNode = null;
        AbstractNode abstractNode = null;
        RoutingConstraint routingConstraint = (RoutingConstraint)object;
        RoutingConstraint routingConstraint2 = (RoutingConstraint)object2;
        if (this.olm.getJList().isSelectionEmpty()) {
            return;
        }
        if (this.db.on()) {
            this.db.finer("selectionChanged old = " + object);
            this.db.finer("                 new = " + object2);
        }
        if (routingConstraint != null) {
            if (routingConstraint.isElemConstraint()) {
                arrayList = routingConstraint.getPriElemConstraintList();
                if (arrayList.size() > 0) {
                    object3 = (INetElement)arrayList.get(0);
                    mapNode = this.getMapNode((INetElement)object3);
                    if (object == object2) {
                        if (this.db.on()) {
                            this.db.finer("Not unselecting the selection!");
                        }
                    } else {
                        if (this.db.on()) {
                            this.db.println("we will deselect " + mapNode);
                        }
                        this.circuitMap.setSelected(mapNode, false);
                        this.unSelectVnodes(mapNode);
                    }
                } else if (this.db.on()) {
                    this.db.finer("old/Empty pri elem list!");
                }
            } else if (routingConstraint.isLinkConstraint() && (arrayList = routingConstraint.getLinkConstraintList()).size() > 0) {
                object3 = (INetLink)arrayList.get(0);
                mapLink = this.getMapLink((INetLink)object3);
                if (this.db.on()) {
                    this.db.finer("Deselecting link: " + mapLink);
                }
                this.circuitMap.setSelected(mapLink, false);
            }
        }
        if (routingConstraint2 != null && routingConstraint2.isElemConstraint()) {
            arrayList = routingConstraint2.getPriElemConstraintList();
            if (arrayList.size() > 0) {
                object3 = (INetElement)arrayList.get(0);
                abstractNode = this.getMapNode((INetElement)object3);
            } else if (this.db.on()) {
                this.db.finer("new/Empty pri elem list!");
            }
        }
        if (abstractNode != null) {
            boolean bl = abstractNode.isSelected();
            if (!bl) {
                this.circuitMap.setSelected((Node)abstractNode, true);
                this.selectVnodes((MapNode)abstractNode);
                this.updateRmUpDownButtons(object2);
            }
        } else if (routingConstraint2 != null && routingConstraint2.isLinkConstraint() && (arrayList = routingConstraint2.getLinkConstraintList()).size() > 0) {
            object3 = (INetLink)arrayList.get(0);
            mapLink = this.getMapLink((INetLink)object3);
            this.dispTF.setText(this.circuitMap.getLinkDesc(mapLink));
            this.circuitMap.setSelected(mapLink, true);
            this.olm.setSelectedEntry(object2);
            this.updateRmUpDownButtons(object2);
        }
        if (!this.exclusionList.isSelectionEmpty()) {
            this.exclusionList.clearSelection();
        }
        this.addButton.setEnabled(false);
        this.exclusionButton.setEnabled(false);
    }

    private String getRank(Object object) {
        RoutingConstraint routingConstraint = this.getRoutingConstraintFromOlm(object);
        if (object == null || routingConstraint == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.olm.getContent().indexOf(routingConstraint) + 1);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void orderSwapped(Object object, Object object2) {
        if (this.db.on()) {
            this.db.println("swapped = " + object + " / " + object2);
        }
        this.refreshOrder();
    }

    public void entryRemoved(Object object) {
        RoutingConstraint routingConstraint = (RoutingConstraint)object;
        if (routingConstraint.isElemConstraint()) {
            MapNode mapNode;
            INetElement iNetElement;
            int n;
            int n2 = routingConstraint.getConstraintType();
            ArrayList arrayList = routingConstraint.getPriElemConstraintList();
            for (n = 0; n < arrayList.size(); ++n) {
                iNetElement = (INetElement)arrayList.get(n);
                mapNode = this.getMapNode(iNetElement);
                this.removeNode(mapNode);
            }
            if (n2 == 2 || n2 == 3) {
                arrayList = routingConstraint.getSecElemConstraintList();
                for (n = 0; n < arrayList.size(); ++n) {
                    iNetElement = (INetElement)arrayList.get(n);
                    mapNode = this.getMapNode(iNetElement);
                    this.removeNode(mapNode);
                }
            }
        } else if (routingConstraint.isLinkConstraint()) {
            ArrayList arrayList = routingConstraint.getLinkConstraintList();
            for (int i = 0; i < arrayList.size(); ++i) {
                INetLink iNetLink = (INetLink)arrayList.get(i);
                MapLink mapLink = this.getMapLink(iNetLink);
                mapLink.removeArrows();
                mapLink.removeAnnotation(RANK);
                this.circuitMap.setNetMapLinkState("entryRemoved()", mapLink, 2);
                this.circuitMap.setSelected(mapLink, false);
            }
        }
        if (this.olm.getSize() == 0) {
            this.dispTF.setText(" ");
        }
        this.refreshOrder();
    }

    protected void refreshOrder() {
        for (int i = 0; i < this.olm.getSize(); ++i) {
            Object object;
            ArrayList arrayList;
            RoutingConstraint routingConstraint = (RoutingConstraint)this.olm.getContent().get(i);
            int n = routingConstraint.getConstraintType();
            if (routingConstraint.isElemConstraint()) {
                arrayList = routingConstraint.getPriElemConstraintList();
                ArrayList arrayList2 = null;
                if (n == 2 || n == 3) {
                    arrayList2 = routingConstraint.getSecElemConstraintList();
                }
                for (int j = 0; j < arrayList.size(); ++j) {
                    String string;
                    object = (INetElement)arrayList.get(j);
                    MapNode mapNode = this.getMapNode((INetElement)object);
                    INodeModel iNodeModel = (INodeModel)mapNode.getUserObject();
                    mapNode.setDesc(null);
                    if (this.srcNode == iNodeModel) {
                        this.addSrcNodeMarker();
                    } else if (this.dstNode == iNodeModel) {
                        this.addDstNodeMarker();
                    }
                    String string2 = string = this.getRank(object);
                    String string3 = RoutingConstraint.getBlsrDriString(routingConstraint, (INetElement)object);
                    if (string3 != null) {
                        string2 = string2 + " " + string3;
                    }
                    mapNode.addDesc(string2);
                    if (arrayList2 == null) continue;
                    object = (INetElement)arrayList2.get(j);
                    mapNode = this.getMapNode((INetElement)object);
                    iNodeModel = (INodeModel)mapNode.getUserObject();
                    mapNode.setDesc(null);
                    if (this.srcNode == iNodeModel) {
                        this.addSrcNodeMarker();
                    } else if (this.dstNode == iNodeModel) {
                        this.addDstNodeMarker();
                    }
                    string2 = string + " " + RoutingConstraint.getBlsrDriString(routingConstraint, (INetElement)object);
                    mapNode.addDesc(string2);
                }
                continue;
            }
            if (!routingConstraint.isLinkConstraint()) continue;
            arrayList = routingConstraint.getLinkConstraintList();
            for (int j = 0; j < arrayList.size(); ++j) {
                INetLink iNetLink = (INetLink)arrayList.get(j);
                object = this.getMapLink(iNetLink);
                if (object == null) continue;
                ((AbstractLink)((Object)object)).addAnnotation(RANK, this.getRank(iNetLink));
            }
        }
        Object object = this.olm.getSelectedEntry();
        this.updateRmUpDownButtons(object);
        this.circuitMap.updateView();
    }

    private void removeNode(MapNode mapNode) {
        this.circuitMap.setSelected(mapNode, false);
        this.unSelectVnodes(mapNode);
        mapNode.setDesc(null);
        INodeModel iNodeModel = (INodeModel)mapNode.getUserObject();
        if (this.srcNode == iNodeModel) {
            this.addSrcNodeMarker();
        } else if (this.dstNode == iNodeModel) {
            this.addDstNodeMarker();
        }
    }

    public static void dumpDriNodesFromPrefs(MemberPrefs memberPrefs, SDebug sDebug, String string) {
        sDebug.println(string + "  [BEGIN]");
        if (memberPrefs == null) {
            sDebug.println("\tRPF is null!");
        } else {
            sDebug.println("\t Member#: " + memberPrefs.getMemberId());
            List list = memberPrefs.getDriNodePrefs();
            if (list == null || list.size() == 0) {
                sDebug.println("\tNo DRI Node prefs specifed for this circuit!");
            } else {
                sDebug.println("\tDri node list size is " + list.size());
                for (int i = 0; i < list.size(); ++i) {
                    DriNodes driNodes = (DriNodes)list.get(i);
                    sDebug.println("\tBLSR-DRI def #" + i + "\t" + driNodes.prettyString());
                }
            }
            sDebug.println(string + " [END]");
        }
    }

    public static void dumpDriFromPrefs(RoutePrefs routePrefs, SDebug sDebug, String string) {
        sDebug.println(string + "  [BEGIN]");
        LinkedList linkedList = routePrefs.getFwdDropPrefs().getMemberGroupPrefs();
        if (linkedList == null) {
            sDebug.println("\tMGPList is null!");
            return;
        }
        for (MemberGroupPrefs memberGroupPrefs : linkedList) {
            MemberPrefs memberPrefs = memberGroupPrefs.getMemberPrefs();
            sDebug.println(string + "\tMember# : " + memberPrefs.getMemberId());
            if (memberPrefs == null) {
                sDebug.println("\tMRPF is null!");
                continue;
            }
            List list = memberPrefs.getDriNodePrefs();
            if (list == null || list.size() == 0) {
                sDebug.println("\tNo DRI Node prefs specifed for this circuit!");
            } else {
                sDebug.println("\tDri node list size is " + list.size());
                for (int i = 0; i < list.size(); ++i) {
                    DriNodes driNodes = (DriNodes)list.get(i);
                    sDebug.println("\tBLSR-DRI def #" + i + "\t" + driNodes.prettyString());
                }
            }
            sDebug.println(string + " ---------------");
        }
        sDebug.println(string + " [END]");
    }

    protected void storeRoutePrefs() throws Exception {
        this.getAbstractCktDlg().getRoutePrefs().setSrc(Network.instance().getNetElem(this.srcNode.getNodeId()));
        this.getAbstractCktDlg().getRoutePrefs().setDst(Network.instance().getNetElem(this.dstNode.getNodeId()));
        LinkedList linkedList = this.getAbstractCktDlg().getRoutePrefs().getFwdDropPrefs().getMemberGroupPrefs();
        if (linkedList == null) {
            return;
        }
        MemberGroupPrefs memberGroupPrefs = (MemberGroupPrefs)linkedList.get(0);
        MemberPrefs memberPrefs = memberGroupPrefs.getMemberPrefs();
        LinkedList linkedList2 = new LinkedList();
        try {
            this.storeRoutePrefs(1, memberPrefs, this.olm.getContent(), this.exclusionArrayList);
        }
        catch (ObjDuplicate objDuplicate) {
            memberPrefs.setReqEntityList(linkedList2);
            memberPrefs.setExcEntityList(linkedList2);
            if (this.getAbstractCktDlg().isPathProt()) {
                String string = "Ensure that the constraints only apply to the working path of the protected circuit.\n";
                throw new AnnotatedException(string, (Exception)((Object)objDuplicate));
            }
            String string = "A route cannot be found that conforms to the set of constraints. \nPlease verify your constraint list.\n";
            throw new AnnotatedException(string, (Exception)((Object)objDuplicate));
        }
    }

    protected void storeRoutePrefs(int n, MemberPrefs memberPrefs, ArrayList arrayList, ArrayList arrayList2) throws Exception {
        Object object;
        int n2;
        if (this.db.on()) {
            this.db.println("storeRoutePref(): setting preferences for member# :" + n);
        }
        LinkedList linkedList = new LinkedList();
        LinkedList<DriNodes> linkedList2 = new LinkedList<DriNodes>();
        LinkedList linkedList3 = new LinkedList();
        LinkedList linkedList4 = new LinkedList();
        if (arrayList != null) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                Object e;
                int n3;
                ArrayList arrayList3;
                object = (RoutingConstraint)arrayList.get(n2);
                if (((RoutingConstraint)object).getConstraintType() == 2 || ((RoutingConstraint)object).getConstraintType() == 3) {
                    this.bIsBlsrDriCkt = true;
                }
                if (((RoutingConstraint)object).isLinkConstraint()) {
                    arrayList3 = ((RoutingConstraint)object).getLinkConstraintList();
                    for (n3 = 0; n3 < arrayList3.size(); ++n3) {
                        e = arrayList3.get(n3);
                        linkedList.add(e);
                    }
                    continue;
                }
                if (!((RoutingConstraint)object).isElemConstraint()) continue;
                arrayList3 = ((RoutingConstraint)object).getPriElemConstraintList();
                for (n3 = 0; n3 < arrayList3.size(); ++n3) {
                    e = arrayList3.get(n3);
                    linkedList.add(e);
                }
                DriNodes driNodes = this.driNodesFromRoutingConstraint((RoutingConstraint)object);
                if (driNodes == null) continue;
                linkedList2.add(driNodes);
            }
        }
        if (arrayList2 != null) {
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                linkedList3.add(n2, arrayList2.get(n2));
            }
        }
        if (this.db.on()) {
            CcdRouteConstraintPane.dumpDriNodesFromPrefs(memberPrefs, this.db, "storeRoutePrefs(), before Clearing");
        }
        memberPrefs.clearDriNodePrefs();
        for (n2 = 0; n2 < linkedList2.size(); ++n2) {
            object = (DriNodes)linkedList2.get(n2);
            memberPrefs.addDriNodes((DriNodes)object);
        }
        if (this.db.on()) {
            CcdRouteConstraintPane.dumpDriNodesFromPrefs(memberPrefs, this.db, "storeRoutePrefs(), after Clearing + Adding New");
        }
        if (this.db.on()) {
            this.db.println("Set these REQUIRED entities in route prefs:");
            for (n2 = 0; n2 < linkedList.size(); ++n2) {
                this.db.println("#" + n2 + "\t" + RoutingConstraint.tryPrettyString(linkedList.get(n2)));
            }
            this.db.println("Set these EXCLUDED entities in route prefs:");
            for (n2 = 0; n2 < linkedList3.size(); ++n2) {
                this.db.println("#" + n2 + "\t" + RoutingConstraint.tryPrettyString(linkedList3.get(n2)));
            }
        }
        memberPrefs.setReqEntityList(linkedList4);
        memberPrefs.setExcEntityList(linkedList4);
        memberPrefs.setReqEntityList(linkedList);
        memberPrefs.setExcEntityList(linkedList3);
    }

    protected DriNodes driNodesFromRoutingConstraint(RoutingConstraint routingConstraint) {
        return RoutingConstraint.driNodesFromRoutingConstraint(routingConstraint);
    }

    protected void addOrRouteNewCircuit() throws Exception {
        this.getAbstractCktDlg().deleteDestination();
        if (this.db.on()) {
            this.db.println("addOrRouteNewCircuit: deleteDestination() worked");
        }
        if (!this.getAbstractCktDlg().isLoCkt()) {
            this.getAbstractCktDlg().addDestination(true);
            if (this.db.on()) {
                this.db.println("addOrRouteNewCircuit: addDestination(true) worked");
            }
        }
        if (!this.getAbstractCktDlg().isRrbc() && !this.getAbstractCktDlg().isLoCkt()) {
            try {
                this.getAbstractCktDlg().getCircuit().sanityCheckManualRouting();
                if (this.db.on()) {
                    this.db.println("addOrRouteNewCircuit: sanityCheckManualRouting succeded");
                }
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                throw new SanityCheckException("", "nodes or spans are", sanityCheckFailed);
            }
        }
    }

    public void validatePage() throws Exception {
        this.storeRoutePrefs();
        if (this.bIsBlsrDriCkt) {
            this.validateUpsrReversion();
        }
        if (!(this.parent instanceof UnprotectedToUpsrDialog)) {
            this.addOrRouteNewCircuit();
        }
        this.storeStatusText();
    }

    protected void handlePostValidate() {
        super.handlePostValidate();
        AutorangeInfo autorangeInfo = this.getAutorangeInfo();
        if (autorangeInfo != null) {
            autorangeInfo.routePrefs = this.getRoutePrefs();
        }
        this.leavingPane();
    }

    protected void setAllRoutePrefEntLists(RoutePrefs routePrefs, LinkedList linkedList, LinkedList linkedList2) throws ObjDuplicate {
        LinkedList linkedList3 = routePrefs.getFwdDropPrefs().getMemberGroupPrefs();
        if (linkedList3 == null) {
            return;
        }
        for (MemberGroupPrefs memberGroupPrefs : linkedList3) {
            MemberPrefs memberPrefs = memberGroupPrefs.getMemberPrefs();
            memberPrefs.setReqEntityList(linkedList);
            memberPrefs.setExcEntityList(linkedList2);
        }
    }

    public void localCleanup() {
        block8: {
            if (this.olm != null) {
                this.olm.clearAll();
                this.olm.syncButtons();
            }
            if (this.exclusionArrayList != null) {
                this.exclusionArrayList.clear();
            }
            if (this.exclusionListModel != null) {
                this.exclusionListModel.clear();
            }
            if (this.removeButton != null) {
                this.removeButton.setEnabled(false);
            }
            if (this.upButton != null) {
                this.upButton.setEnabled(false);
            }
            if (!this.getAbstractCktDlg().isLoCkt() && this.getAbstractCktDlg().getRoutePrefs() != null) {
                LinkedList linkedList = new LinkedList();
                try {
                    this.setAllRoutePrefEntLists(this.getAbstractCktDlg().getRoutePrefs(), linkedList, linkedList);
                }
                catch (ObjDuplicate objDuplicate) {
                    if (!this.db.on()) break block8;
                    WzDiagDebug.printStackTrace((Throwable)objDuplicate);
                }
            }
        }
    }

    public void recycle() {
        if (this.db.on()) {
            this.db.println("recycle");
        }
        this.localCleanup();
        this.srcNode = null;
        this.dstNode = null;
        this.exclusionArrayList.clear();
        this.selectedLink = null;
        this.selectedNetLink = null;
        this.selectedNode = null;
        this.bIsBlsrDriCkt = false;
        super.recycle();
    }

    void reset() {
        if (this.db.on()) {
            this.db.println("reset");
        }
        if (this.circuitMap != null) {
            this.cleanup();
        }
    }

    private void addLink() {
        Object object;
        Object object2;
        Object object3;
        if (this.selectedNetLink == null || this.selectedLink == null) {
            this.addButton.setEnabled(false);
            this.exclusionButton.setEnabled(false);
            return;
        }
        if (!this.continueNonRevertive(this.selectedNetLink)) {
            this.unSetLink();
            return;
        }
        INetElement iNetElement = this.selectedNetLink.getSrc();
        INetElement iNetElement2 = this.selectedNetLink.getDst();
        for (int i = 0; i < this.olm.getSize(); ++i) {
            object3 = (RoutingConstraint)this.olm.getContent().get(i);
            if (!((RoutingConstraint)object3).isLinkConstraint()) continue;
            object2 = ((RoutingConstraint)object3).getLinkConstraintList();
            for (int j = 0; j < ((ArrayList)object2).size(); ++j) {
                object = (INetLink)((ArrayList)object2).get(j);
                if (object.getSrc() == iNetElement) {
                    if (this.getAbstractCktDlg().isPathProt()) {
                        ErrorMsg.displayError((Component)this, (EID)NEMC.EID_PRIMARY_PATH_CONSTRAINT_ERRORMSG);
                    } else {
                        ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ONE_OUTGOING_CONSTRAINT_ERRORMSG);
                    }
                    this.unSetLink();
                    return;
                }
                if (object.getDst() != iNetElement2) continue;
                if (this.getAbstractCktDlg().isPathProt()) {
                    ErrorMsg.displayError((Component)this, (EID)NEMC.EID_PRIMARY_PATH_CONSTRAINT_ERRORMSG);
                } else {
                    ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ONE_OUTGOING_CONSTRAINT_ERRORMSG);
                }
                this.unSetLink();
                return;
            }
        }
        if (this.selectedNetLink.getSrc().getNodeModel() == this.dstNode) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_LINK_NOT_INCLUDED_DST);
            this.unSetLink();
            return;
        }
        if (this.selectedNetLink.getDst().getNodeModel() == this.srcNode) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_LINK_NOT_INCLUDED_SRC);
            this.unSetLink();
            return;
        }
        String string = this.circuitMap.getLinkDesc(this.selectedLink);
        this.circuitMap.setNetMapLinkState("addLink()", this.selectedLink, 3);
        object3 = this.selectedLink;
        object2 = this.selectedNetLink;
        if (!this.olmContainsRoutingConstraint(this.selectedNetLink)) {
            RoutingConstraint routingConstraint;
            this.addRoutingConstraintToOlm(this.selectedNetLink, string);
            if (this.olm.getSize() >= 2 && (routingConstraint = (RoutingConstraint)this.olm.getContent().get(this.olm.getSize() - 2)).isLinkConstraint()) {
                object = routingConstraint.getLinkConstraintList();
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    INetLink iNetLink = (INetLink)((ArrayList)object).get(i);
                    if (!iNetLink.isLAP() || iNetLink.getDst().getNodeId() != this.getAbstractCktDlg().getDestNode().getNodeId()) continue;
                    this.olm.swapEntries(this.olm.getSize() - 2);
                }
            }
        }
        ((AbstractLink)((Object)object3)).addAnnotation(RANK, this.getRank(object2));
        this.olm.getJList().clearSelection();
        if (object3 != null) {
            this.circuitMap.setSelected((Link)object3, false);
        }
        this.addButton.setEnabled(false);
        this.exclusionButton.setEnabled(false);
    }

    private void excludeLink() {
        if (this.selectedLink != null && this.selectedNetLink != null) {
            this.excludeLink(this.selectedLink);
        }
    }

    protected void excludeLink(MapLink mapLink) {
        this.circuitMap.setNetMapLinkState("excludeLink()", mapLink, 6);
        if (!this.exclusionArrayList.contains(mapLink.getUserObject())) {
            this.exclusionArrayList.add(mapLink.getUserObject());
            String string = this.circuitMap.getLinkDesc(mapLink);
            this.exclusionListModel.addElement(string);
            this.exclusionList.updateUI();
        }
        this.circuitMap.setSelected(mapLink, false);
        this.addButton.setEnabled(false);
        this.exclusionButton.setEnabled(false);
    }

    boolean setLink(NetMapLink netMapLink) {
        boolean bl;
        MapLink mapLink;
        INetLink iNetLink;
        int n;
        block26: {
            if (this.db.on()) {
                this.db.finer("setLink maplink = " + netMapLink);
            }
            if (netMapLink == null) {
                if (this.db.on()) {
                    this.db.finer("unSetLink due to mapLink == null");
                }
                this.unSetLink();
                return true;
            }
            if (this.selectedLink != netMapLink) {
                if (this.db.on()) {
                    this.db.finer("unSetLink due to mapLink != oldMapLink");
                }
                this.unSetLink();
            }
            if ((n = netMapLink.getState()) == 1) {
                return false;
            }
            int n2 = this.getAbstractCktDlg().getCircuitInfo().size();
            int n3 = this.getAbstractCktDlg().getCircuitInfo().type();
            iNetLink = (INetLink)netMapLink.getUserObject();
            mapLink = this.circuitMap.getDirectionalMapLink(iNetLink);
            this.saveSelectedLink(mapLink);
            this.selectedNetLink = (AbstractNetLink)iNetLink;
            bl = false;
            try {
                if (!CircuitType.getCircuitType((int)this.getAbstractCktDlg().getCircuitType()).isVcatCircuitType()) {
                    this.getAbstractCktDlg().getRoutePrefs().setCircuitSize(n2);
                    this.getAbstractCktDlg().getRoutePrefs().setCircuitType(n3);
                }
                bl = iNetLink.availBW(this.getAbstractCktDlg().getRoutePrefs());
            }
            catch (Exception exception) {
                this.db.finer("Exception in setLink(), mapLink=" + netMapLink + " " + exception);
                if (!this.db.on()) break block26;
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
        if (n == 2 && !bl) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_NO_PATHS_AVAILABLE);
            return false;
        }
        if (n == 3) {
            this.exclusionList.clearSelection();
            RoutingConstraint routingConstraint = this.getRoutingConstraintFromOlm(iNetLink);
            if (routingConstraint == null) {
                if (this.db.on()) {
                    this.db.println("rc did not contain " + iNetLink + "; trying " + "reverse link.");
                }
                iNetLink = this.circuitMap.findReverseLink(iNetLink);
                routingConstraint = this.getRoutingConstraintFromOlm(iNetLink);
            }
            this.selectedNetLink = (AbstractNetLink)iNetLink;
            this.olm.setSelectedEntry(routingConstraint);
            this.dispTF.setText(this.circuitMap.getLinkDesc(mapLink));
        } else if (n == 0) {
            mapLink.reverseArrow();
            if (mapLink.isSrcArrowEnabled()) {
                iNetLink = this.circuitMap.findReverseLink(iNetLink);
                this.selectedNetLink = (AbstractNetLink)iNetLink;
            }
            this.dispTF.setText(this.circuitMap.getLinkDesc(mapLink));
            this.olm.getJList().clearSelection();
            this.addButton.setEnabled(true);
            this.exclusionButton.setEnabled(true);
            this.circuitMap.updateView();
        } else if (n == 6) {
            if (!this.exclusionArrayList.contains(iNetLink)) {
                if (this.db.on()) {
                    this.db.println("exclusion array, try reverse of " + iNetLink);
                }
                iNetLink = this.circuitMap.findReverseLink(iNetLink);
            }
            if (this.exclusionArrayList.contains(iNetLink)) {
                this.exclusionList.setSelectedIndex(this.exclusionArrayList.indexOf(iNetLink));
                this.olm.getJList().clearSelection();
                this.exclusionButton.setEnabled(false);
                if (this.isRemoveable(iNetLink)) {
                    this.removeButton.setEnabled(true);
                } else {
                    this.removeButton.setEnabled(false);
                }
            } else if (this.db.on()) {
                this.db.println("exclusion array, reverse failed: " + iNetLink);
            }
            this.dispTF.setText(this.circuitMap.getLinkDesc(mapLink));
        } else {
            this.exclusionList.clearSelection();
            mapLink.setTargetArrow();
            this.circuitMap.setNetMapLinkState("setLink()", mapLink, 0);
            this.dispTF.setText(this.circuitMap.getLinkDesc(mapLink));
            this.olm.getJList().clearSelection();
            this.addButton.setEnabled(true);
            this.exclusionButton.setEnabled(true);
        }
        return true;
    }

    protected void unSetLink() {
        MapLink mapLink;
        if (this.db.on()) {
            this.db.finer("--> unSetLink() " + this.selectedLink);
        }
        if (this.selectedLink != null && (mapLink = this.selectedLink) != null) {
            if (mapLink instanceof NetMapLink) {
                NetMapLink netMapLink = (NetMapLink)mapLink;
                if (netMapLink.getState() == 0) {
                    netMapLink.removeArrows();
                    this.circuitMap.setNetMapLinkState("unSetLink()", netMapLink, 2);
                }
            } else if (this.db.on()) {
                this.db.finest("unSetLink(): mapLink is not a NetMapLink:\n" + mapLink);
            }
        }
        this.saveSelectedLink(null);
        this.selectedNetLink = null;
        this.olm.getJList().clearSelection();
        this.exclusionList.clearSelection();
        this.addButton.setEnabled(false);
        this.exclusionButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.dispTF.setText(" ");
        this.circuitMap.updateView();
        if (this.db.on()) {
            this.db.finer("<-- unSetLink() ");
        }
    }

    private void unSetLink(MapLink mapLink) {
        if (this.db.on()) {
            this.db.finer("--> unSetLink(mapLink)");
        }
        if (mapLink != null) {
            if (mapLink instanceof NetMapLink) {
                NetMapLink netMapLink = (NetMapLink)mapLink;
                if (netMapLink.getState() == 0) {
                    netMapLink.removeArrows();
                    this.circuitMap.setNetMapLinkState("unSetLink(arg)", netMapLink, 2);
                }
            } else if (this.db.on()) {
                this.db.finest("unSetLink(mapLink): mapLink is not a NetMapLink:\n" + mapLink);
            }
        }
        this.saveSelectedLink(null);
        this.selectedNetLink = null;
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.dispTF.setText(" ");
        this.olm.getJList().clearSelection();
        this.exclusionList.clearSelection();
        this.circuitMap.updateView();
        if (this.db.on()) {
            this.db.finer("<-- unSetLink(mapLink)");
        }
    }

    public void linkSelected(MapLink mapLink, boolean bl) {
        if (!bl) {
            if (this.db.on()) {
                this.db.println("Deselecting the maplink: " + mapLink);
            }
            this.deselected(mapLink);
        }
    }

    boolean setNode(MapNode mapNode) {
        if (this.db.on()) {
            this.db.finer("setNode " + mapNode);
        }
        if (mapNode == null) {
            this.unSetNode();
            return true;
        }
        if (mapNode.isVirtual()) {
            mapNode = mapNode.getRealNode();
        }
        INodeModel iNodeModel = (INodeModel)mapNode.getUserObject();
        this.dispTF.setText(iNodeModel.getName());
        this.saveSelectedNode(mapNode);
        boolean bl = false;
        if ((INodeModel)mapNode.getUserObject() == this.srcNode || (INodeModel)mapNode.getUserObject() == this.dstNode || (INodeModel)mapNode.getUserObject() == this.getAbstractCktDlg().getAltDestNode()) {
            this.addButton.setEnabled(false);
            this.exclusionButton.setEnabled(false);
            bl = true;
        }
        if (this.olmContainsRoutingConstraint(this.getNetElement(mapNode), 2)) {
            this.addButton.setEnabled(false);
            this.exclusionButton.setEnabled(false);
            this.exclusionList.clearSelection();
            RoutingConstraint routingConstraint = this.getRoutingConstraintFromOlm(this.getNetElement(mapNode), true);
            this.olm.setSelectedEntry(routingConstraint);
            if (routingConstraint != null) {
                if (this.isRemoveable(this.getNetElement(mapNode))) {
                    this.removeButton.setEnabled(true);
                } else {
                    this.removeButton.setEnabled(false);
                }
            } else {
                this.removeButton.setEnabled(false);
            }
        } else if (!bl) {
            if (this.exclusionArrayList.contains(this.getNetElement(mapNode))) {
                this.addButton.setEnabled(false);
                this.exclusionButton.setEnabled(false);
                this.olm.getJList().clearSelection();
                this.exclusionList.setSelectedIndex(this.exclusionArrayList.indexOf(this.getNetElement(mapNode)));
                if (this.isRemoveable(this.getNetElement(mapNode))) {
                    this.removeButton.setEnabled(true);
                } else {
                    this.removeButton.setEnabled(false);
                }
            } else {
                this.addButton.setEnabled(true);
                this.exclusionButton.setEnabled(true);
                this.olm.getJList().clearSelection();
                this.exclusionList.clearSelection();
            }
        }
        return true;
    }

    private void unSetNode(MapNode mapNode) {
        if (this.db.on()) {
            this.db.finer("Asked to unSetNode " + mapNode);
        }
        if (mapNode != null) {
            if (this.db.on()) {
                this.db.finer("--> unsetNode(node) = " + mapNode);
            }
            this.unSelectVnodes(mapNode);
            if (mapNode.isSelected()) {
                this.circuitMap.setSelected(mapNode, false);
            } else {
                this.db.println("\t unsetNode will not call setSelected(false) because node is already unselected.");
            }
            this.dispTF.setText(" ");
            this.addButton.setEnabled(false);
            this.exclusionButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.circuitMap.updateView();
            if (this.db.on()) {
                this.db.finer("<-- unSetNode(node) = " + mapNode + "\n");
            }
        }
    }

    protected void unSetNode() {
        this.unSetNode(this.selectedNode);
    }

    public void nodeSelected(MapNode mapNode, boolean bl) {
        if (mapNode == null) {
            return;
        }
        if (mapNode.isDomain()) {
            this.circuitMap.setSelected(mapNode, false);
            return;
        }
        if (bl) {
            if (this.selectedLink != null) {
                this.unSetLink(this.selectedLink);
            }
            if (this.selectedNode != null && !this.selectedNode.isSameNodeAs(mapNode)) {
                this.unSetNode(this.selectedNode);
            }
            this.setNode(mapNode);
        } else {
            if (this.db.on()) {
                this.db.finer("nodeSelected0: " + mapNode.getName() + " & SEL=FALSE");
            }
            this.unSetNode(mapNode);
            if (this.db.on()) {
                this.db.finer("nodeSelected1: " + mapNode.getName() + " & SEL=FALSE");
            }
            this.olm.getJList().clearSelection();
            if (this.exclusionList != null) {
                this.exclusionList.clearSelection();
            }
        }
    }

    private void deselected(MapLink mapLink) {
        if (this.db.on()) {
            this.db.finer("calling deselected() on " + mapLink);
        }
        if (this.selectedNetLink != null) {
            this.selectedLink = this.circuitMap.getDirectionalMapLink(this.selectedNetLink);
        }
        if (this.selectedLink != null) {
            MapLink mapLink2 = this.selectedLink;
            if (mapLink2 instanceof NetMapLink && mapLink instanceof NetMapLink) {
                if (mapLink2 == mapLink || mapLink2.getUserObject() == mapLink.getUserObject() && ((NetMapLink)mapLink2).getState() == ((NetMapLink)mapLink).getState()) {
                    this.unselectCurrent();
                    this.setLink(null);
                }
            } else if (this.db.on()) {
                this.db.finest("deselected(): could not continue because link and/or maplink are not NetMapLinks:\nlink: " + mapLink + "\nmapLink: " + mapLink2);
            }
        }
        this.circuitMap.updateView();
    }

    public void clicked(MapLink mapLink) {
        boolean bl;
        if (this.selectedNetLink != null) {
            this.selectedLink = this.circuitMap.getDirectionalMapLink(this.selectedNetLink);
        }
        if (bl = mapLink.isSelected()) {
            if (this.selectedLink != null) {
                MapLink mapLink2 = this.selectedLink;
                if (mapLink != this.selectedLink) {
                    this.saveSelectedLink(null);
                    this.selectedNetLink = null;
                    this.circuitMap.setSelected(mapLink2, false);
                    this.setLink(null);
                }
            } else if (this.selectedNode != null) {
                MapNode mapNode = this.selectedNode;
                this.saveSelectedNode(null);
                this.circuitMap.setSelected(mapNode, false);
                this.unSelectVnodes(mapNode);
                this.setLink(null);
            }
            if (mapLink instanceof NetMapLink) {
                if (!this.setLink((NetMapLink)mapLink)) {
                    this.unselectCurrent();
                }
            } else if (this.db.on()) {
                this.db.finest("clicked(): cannott set a non-NetMapLink:\n" + mapLink);
            }
            this.circuitMap.updateView();
        } else {
            this.deselected(mapLink);
        }
        this.circuitMap.updateView();
    }

    private void unselectCurrent() {
        MapLink mapLink = this.selectedLink;
        if (mapLink != null) {
            this.saveSelectedLink(null);
            this.selectedNetLink = null;
            this.circuitMap.setSelected(mapLink, false);
            if (mapLink instanceof NetMapLink) {
                NetMapLink netMapLink = (NetMapLink)mapLink;
                if (netMapLink.getState() == 0) {
                    netMapLink.removeArrows();
                    this.circuitMap.setNetMapLinkState("unselecteCurrent()", netMapLink, 2);
                }
            } else if (this.db.on()) {
                this.db.finest("unselectCurrent(): selected link is not a NetMapLink:\n" + mapLink);
            }
        }
    }

    public void domainDisplayed(MapNode mapNode) {
        this.unSetNode();
    }

    protected String[] parseConstraintString(int n, String string) {
        String string2;
        String string3 = string;
        if (string.indexOf(40) == 0) {
            int n2 = string.indexOf(41);
            string3 = string.substring(n2 + 1, string.length());
        }
        String string4 = "#" + String.valueOf(n);
        int n3 = string3.lastIndexOf(40);
        if (n3 > 0) {
            string2 = string3.substring(0, n3) + "\n" + string3.substring(n3, string3.length());
            string4 = string4 + "\n";
        } else {
            string2 = string3;
        }
        String[] stringArray = new String[]{string4, string2};
        return stringArray;
    }

    protected JComponent getStatusComponent() {
        Object object;
        String string;
        ArrayList<String[]> arrayList;
        WzStatusPanel wzStatusPanel = new WzStatusPanel(false);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jLabel2.setUI((LabelUI)new MultiLineLabelUI());
        jLabel.setText("Required Nodes/Links:");
        jPanel.add((Component)jLabel, "North");
        if (this.olm.getContent().size() == 0) {
            jPanel.add((Component)new JLabel("(None)"), "Center");
        } else {
            arrayList = new ArrayList<String[]>();
            for (int i = 0; i < this.olm.getContent().size(); ++i) {
                string = this.olm.getElementAt(i).toString();
                object = this.parseConstraintString(i + 1, string);
                arrayList.add((String[])object);
            }
            GridPanel gridPanel = CcdRouteConstraintPane.getGridPanel(arrayList);
            jPanel.add((Component)gridPanel, "Center");
        }
        jLabel2.setText("Excluded Nodes/Links:");
        jPanel2.add((Component)jLabel2, "North");
        if (this.exclusionArrayList.size() == 0) {
            jPanel2.add((Component)new JLabel("(None)"), "Center");
        } else {
            arrayList = new ArrayList();
            for (int i = 0; i < this.exclusionArrayList.size(); ++i) {
                string = this.exclusionArrayList.get(i);
                object = null;
                if (string instanceof INetElement) {
                    object = this.getNodeModel(this.getMapNode((INetElement)((Object)string))).getName();
                } else if (string instanceof INetLink) {
                    object = this.circuitMap.getLinkDesc(this.getMapLink((INetLink)((Object)string)));
                }
                String[] stringArray = this.parseConstraintString(i + 1, (String)object);
                arrayList.add(stringArray);
            }
            GridPanel gridPanel = CcdRouteConstraintPane.getGridPanel(arrayList);
            jPanel2.add((Component)gridPanel, "Center");
        }
        wzStatusPanel.push(jPanel, null, true);
        wzStatusPanel.push(new JLabel(" "), null, false);
        wzStatusPanel.push(jPanel2, null, true);
        return wzStatusPanel;
    }

    protected String getStatusText() {
        return this.statusText;
    }

    protected void storeStatusText() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nRequired Nodes/Links:");
        if (this.olm.getContent().size() == 0) {
            stringBuffer.append("\n(None)");
        } else {
            for (n = 0; n < this.olm.getContent().size(); ++n) {
                stringBuffer.append("\n" + this.olm.getElementAt(n));
            }
        }
        stringBuffer.append("\n \nExcluded Nodes/Links:");
        if (this.exclusionArrayList.size() == 0) {
            stringBuffer.append("\n(None)");
        } else {
            for (n = 0; n < this.exclusionArrayList.size(); ++n) {
                Object e = this.exclusionArrayList.get(n);
                String string = null;
                if (e instanceof INetElement) {
                    string = this.getNodeModel(this.getMapNode((INetElement)e)).getName();
                } else if (e instanceof INetLink) {
                    string = this.circuitMap.getLinkDesc(this.getMapLink((INetLink)e));
                }
                stringBuffer.append("\n  " + string);
            }
        }
        stringBuffer.append("\n");
        this.statusText = stringBuffer.toString();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object var2_2 = null;
        if (!listSelectionEvent.getValueIsAdjusting()) {
            int n = this.exclusionList.getSelectedIndex();
            if (n < 0) {
                this.addButton.setEnabled(false);
                this.exclusionButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                return;
            }
            var2_2 = this.exclusionArrayList.get(n);
            if (var2_2 instanceof INetElement) {
                MapNode mapNode = this.getMapNode((INetElement)var2_2);
                if (this.selectedNode != null && !this.selectedNode.isSameNodeAs(mapNode)) {
                    this.circuitMap.setSelected(this.selectedNode, false);
                    this.unSelectVnodes(this.selectedNode);
                }
                this.circuitMap.setSelected(mapNode, true);
                this.selectVnodes(mapNode);
            } else if (var2_2 instanceof INetLink) {
                if (this.selectedNode != null) {
                    this.circuitMap.setSelected(this.selectedNode, false);
                    this.unSelectVnodes(this.selectedNode);
                }
                MapLink mapLink = this.getMapLink((INetLink)var2_2);
                this.circuitMap.setSelected(mapLink, true);
                this.dispTF.setText(this.circuitMap.getLinkDesc(mapLink));
            }
            if (!this.olm.getJList().isSelectionEmpty()) {
                this.olm.getJList().clearSelection();
            }
            this.addButton.setEnabled(false);
            this.exclusionButton.setEnabled(false);
            if (this.isRemoveable(var2_2)) {
                this.removeButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
    }

    public ArrayList getExcList() {
        return this.exclusionArrayList;
    }

    protected void addSrcNodeMarker() {
        this.circuitMap.addSourceNodeMarker();
    }

    protected void addDstNodeMarker() {
        this.circuitMap.addDestNodeMarker();
    }

    protected boolean isRemoveable(Object object) {
        return true;
    }

    protected void updateRmUpDownButtons(Object object) {
        Object object2;
        Object object3;
        int n;
        Object object4;
        if (object == null) {
            return;
        }
        RoutingConstraint routingConstraint = (RoutingConstraint)object;
        if (routingConstraint.isLinkConstraint()) {
            object4 = routingConstraint.getLinkConstraintList();
            for (n = 0; n < ((ArrayList)object4).size(); ++n) {
                object3 = (INetLink)((ArrayList)object4).get(n);
                if (!object3.isLAP()) continue;
                this.removeButton.setEnabled(false);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        } else if (routingConstraint.isElemConstraint()) {
            object4 = routingConstraint.getPriElemConstraintList();
            for (n = 0; n < ((ArrayList)object4).size(); ++n) {
                object3 = (INetElement)((ArrayList)object4).get(n);
                if (this.getAbstractCktDlg().getCircuit().getXmCircuitEnds().isEmpty() || (object2 = (INetCircuitEnd)this.getAbstractCktDlg().getCircuit().getXmCircuitEnds().get(0)).getNetElement().getNodeId() != object3.getNodeId()) continue;
                this.removeButton.setEnabled(false);
            }
        }
        if (routingConstraint.isLinkConstraint() && ((RoutingConstraint)(object4 = (RoutingConstraint)this.olm.getContent().get(0))).isLinkConstraint()) {
            ArrayList arrayList = ((RoutingConstraint)object4).getLinkConstraintList();
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = (INetLink)arrayList.get(i);
                if (!object2.isLAP() || this.olm.getContent().indexOf(object) != 1) continue;
                this.upButton.setEnabled(false);
            }
        }
        if (this.olm.getSize() >= 2 && ((RoutingConstraint)(object4 = (RoutingConstraint)this.olm.getContent().get(this.olm.getSize() - 1))).isLinkConstraint()) {
            ArrayList arrayList = ((RoutingConstraint)object4).getLinkConstraintList();
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = (INetLink)arrayList.get(i);
                if (!object2.isLAP() || this.olm.getContent().indexOf(object) != this.olm.getSize() - 2) continue;
                this.downButton.setEnabled(false);
            }
        }
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdRouteConstraintPane;
    }

    public void removeListeners() {
        if (this.exclusionList != null) {
            this.exclusionList.removeListSelectionListener(this);
        }
        if (this.blsrDriButton != null) {
            this.blsrDriButton.removeActionListener(this);
        }
        if (this.addButton != null) {
            this.addButton.removeActionListener(this);
        }
        if (this.exclusionButton != null) {
            this.exclusionButton.removeActionListener(this);
        }
        if (this.upButton != null) {
            this.upButton.removeActionListener(this);
        }
        if (this.downButton != null) {
            this.downButton.removeActionListener(this);
        }
        if (this.removeButton != null) {
            this.removeButton.removeActionListener(this);
        }
        super.removeListeners();
    }

    public void dispose() {
        this.srcNode = null;
        this.dstNode = null;
        if (this.exclusionArrayList != null) {
            this.exclusionArrayList.clear();
            this.exclusionArrayList = null;
        }
        this.exclusionList = null;
        this.exclusionListModel = null;
        this.selectedLink = null;
        this.selectedNetLink = null;
        this.selectedNode = null;
        super.dispose();
    }

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Exclusion Array List: " + this.exclusionArrayList + "\n");
        if (this.exclusionArrayList != null) {
            stringBuffer.append("Size= " + this.exclusionArrayList.size() + "\n");
            for (int i = 0; i < this.exclusionArrayList.size(); ++i) {
                stringBuffer.append("\t#" + (i + 1) + ": " + this.exclusionArrayList.get(i) + "\n");
            }
        }
        stringBuffer.append("Uses DRI: " + this.usesDri);
        return stringBuffer.toString();
    }

    class MultiLineRenderer
    extends DefaultListCellRenderer {
        public MultiLineRenderer() {
            this.setUI((LabelUI)new MultiLineLabelUI());
        }
    }
}

