/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.ICircuitType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitDropInfo;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.circuits.CircuitDropCreationDialog;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventMaskUtil;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class CedDropPane
extends AbstractPane
implements ActionListener,
ListSelectionListener {
    public static final String CREATE = "Create...";
    public static final String DELETE = "Delete...";
    private INetCircuit ckt;
    private DefaultListModel dropListModel;
    private JList dropList;
    private JButton createPB;
    private JButton deletePB;
    private boolean needsRefresh = true;
    private TabbedView tabbedView;
    private static final SDebug db = new SDebug("CedDropPane");

    public CedDropPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        if (db.on()) {
            db.println("<init>: start");
        }
        this.tabbedView = tabbedView;
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        NetCircuitModel netCircuitModel = (NetCircuitModel)tabbedView.getUiModel();
        this.ckt = netCircuitModel.getNetCircuit();
        this.ckt.addObserver((Observer)((Object)this));
        this.setLayout(new BorderLayout(5, 5));
        if (this.isEtherRingCircuit()) {
            this.add(this.getRingWorkaroundText(), "Center");
        } else {
            this.dropListModel = new DefaultListModel();
            this.dropList = new JList(this.dropListModel);
            this.dropList.setCellRenderer(new CircuitEndCellRenderer());
            this.dropList.setVisibleRowCount(6);
            this.dropList.addListSelectionListener(this);
            this.add((Component)new UScrollPane((Component)this.dropList), "Center");
            this.add(this.getButtonBar(), "South");
        }
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    public void destroy() {
        if (db.on()) {
            db.println("destroy");
        }
        this.ckt.deleteObserver((Observer)((Object)this));
        super.destroy();
    }

    public void update(Observable observable, Object object) {
        this.requestRefresh(this, null);
    }

    private boolean isEtherRingCircuit() {
        boolean bl = false;
        try {
            ICircuitType iCircuitType = this.ckt.getCircuitTypeObj();
            bl = iCircuitType.isEthernetCircuitType() && CircuitMapUtil.getPortDrops(this.ckt).size() == 0 && this.ckt.getEtherAddDropCircuitNodes().size() == 0;
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            SDebug.printStackTrace((Throwable)incorrectCircuitState);
        }
        return bl;
    }

    private boolean isEthernetCkt() {
        boolean bl = false;
        if (this.ckt != null && this.ckt.isCircuitRefValid()) {
            ICircuitType iCircuitType = this.ckt.getCircuitTypeObj();
            bl = iCircuitType.isEthernetCircuitType();
        }
        return bl;
    }

    private JComponent getRingWorkaroundText() {
        JTextArea jTextArea = new JTextArea("Drops cannot be added to a shared packet ring.\nInstead, create a second Ethernet circuit\non the node where you want to add the drop,\nensure that it carries the same VLANs as this circuit,\nand add a drop to that circuit.");
        jTextArea.setEditable(false);
        return jTextArea;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.deletePB.setEnabled(this.isUserAuthorized() && !this.dropList.getSelectionModel().isSelectionEmpty() && (this.dropList.getModel().getSize() > 1 || this.isEthernetCkt() && this.dropList.getModel().getSize() > 0));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = EventMaskUtil.isCtrlShiftPressed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            if (this.isDestroyed()) {
                SDebug.printStackTrace((Throwable)new Exception("Destroyed"));
                return;
            }
            CircuitDropCreationDialog circuitDropCreationDialog = null;
            circuitDropCreationDialog = new CircuitDropCreationDialog((JComponent)((Object)this), this.ckt, bl);
            circuitDropCreationDialog.showModal();
        } else if (object == this.deletePB) {
            Object[] objectArray = this.dropList.getSelectedValues();
            if (!this.isEthernetCkt() && objectArray.length == this.dropList.getModel().getSize()) {
                CerentDialog.infoDialog((Component)((Object)this), (String)"A circuit must have at least one drop.", (String)"Delete Circuit Drops");
                return;
            }
            if (CerentDialog.yesNoDialog((Component)((Object)this), (String)"Do you really want to delete the selected drops?", (String)"Delete Circuit Drops")) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        this.ckt.deleteDrop((INetCircuitDropInfo)objectArray[i]);
                        this.dropListModel.removeElement(objectArray[i]);
                    }
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ERROR_DELETING_CKT_DROP);
                }
            }
        }
    }

    private JPanel getButtonBar() {
        this.createPB = new JButton(CREATE);
        this.enableComponent(this.createPB);
        this.createPB.addActionListener(this);
        this.deletePB = new JButton(DELETE);
        this.deletePB.addActionListener(this);
        this.deletePB.setEnabled(false);
        JPanel jPanel = CedDropPane.createHorizontalPanel(null);
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add(this.createPB);
        jPanel.add(this.deletePB);
        return jPanel;
    }

    public void leavingPage() throws Exception {
    }

    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("enteringPage");
        }
        if (this.needsRefresh) {
            this.needsRefresh = false;
            this.refresh();
        }
    }

    public void refresh() {
        if (db.on()) {
            db.println("refresh: start");
        }
        if (this.isDestroyed() || this.dropList == null) {
            if (db.on()) {
                db.println("refresh: nothing to do for ether ring");
            }
            return;
        }
        List list = CircuitMapUtil.getPortDrops(this.ckt);
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                return CircuitEndCellRenderer.asCommaSeparatedString((INetCircuitEnd)object, false).compareTo(CircuitEndCellRenderer.asCommaSeparatedString((INetCircuitEnd)object2, false));
            }
        });
        ICircuitType iCircuitType = this.ckt.getCircuitTypeObj();
        this.createPB.setEnabled(this.isUserAuthorized() && (!iCircuitType.isEthernetCircuitType() || list.size() < 2));
        this.dropListModel.setSize(list.size());
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.dropListModel.setElementAt(iterator.next(), n++);
        }
        this.deletePB.setEnabled(this.isUserAuthorized() && !this.dropList.getSelectionModel().isSelectionEmpty() && (this.dropList.getModel().getSize() > 1 || this.isEthernetCkt() && this.dropList.getModel().getSize() > 0));
        if (db.on()) {
            db.println("refresh: finish");
        }
    }
}

