/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.circuits.CircuitFilter;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.CircuitMergeFilter;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCircuitMergeOperator;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.circuits.CircuitMergeDialog;
import cerent.cms.ui.circuits.CircuitsPane;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.matcher.AbstractMatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class CedMergePane
extends CircuitsPane {
    private INetCircuit ckt;
    public static final String MERGE = "Merge...";
    public static final String STRICT_MERGE = "Strict Merge";
    public static final String LOOSE_MERGE = "Loose Merge";
    public static final String FILTER = "Refresh Aligned Circuits";
    private JButton mergePB;
    private JButton filterPB;
    private JLabel filterProcessLabel;
    private List linedupCircuits = Collections.synchronizedList(new ArrayList());
    private boolean linedupFilterOn = false;
    private CircuitMergeFilter mergeFilter;
    private Object mergeProcessLock = new Object();
    private boolean mergeProcessFinished;
    private boolean inFiltering;
    private static final SDebug db = new SDebug("CedMergePane");

    public CedMergePane(TabbedView tabbedView) {
        super("", null, tabbedView);
        if (db.on()) {
            db.println("<init>: start");
        }
        NetCircuitModel netCircuitModel = (NetCircuitModel)tabbedView.getUiModel();
        this.ckt = netCircuitModel.getNetCircuit();
        this.mergeFilter = new CircuitMergeFilter(this.ckt);
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (db.on()) {
            db.println("destroy");
        }
        CedMergePane cedMergePane = this;
        synchronized (cedMergePane) {
            this.ckt = null;
        }
        super.destroy();
    }

    protected JPanel getButtonBar() {
        JPanel jPanel = CedMergePane.createHorizontalPanel(null);
        jPanel.setLayout(new FlowLayout(1));
        this.filterProcessLabel = new JLabel("Finding Aligned Circuits...");
        this.filterProcessLabel.setForeground(Color.red);
        this.filterProcessLabel.setVisible(false);
        jPanel.add(this.filterProcessLabel);
        this.mergePB = this.makeActionButton(MERGE);
        this.mergePB.setEnabled(false);
        jPanel.add(this.mergePB);
        this.filterPB = this.makeActionButton(FILTER);
        this.filterPB.setEnabled(true);
        this.filterPB.setToolTipText("Display only circuits with cross-connects aligned with the current circuit");
        jPanel.add(this.filterPB);
        this.scopeCB = new JComboBox<Object>(new Object[]{"Network"});
        return jPanel;
    }

    protected void syncButtons(boolean bl) {
        if (db.on()) {
            int n = this.table != null ? this.table.getSelectedRowCount() : -1;
            int n2 = this.table != null ? this.table.getRowCount() : -1;
            db.println("syncButtons " + (n != -1 && n2 != -1 ? n + "/" + n2 + " (Sel/Tot)" + (n > n2 ? " !!!" : "") : "table is null"));
        }
        if (this.table != null && this.table.getSelectedRowCount() > 0) {
            this.enableComponent(this.mergePB);
        } else {
            this.mergePB.setEnabled(false);
        }
    }

    public void enteringPage() {
        boolean bl = !this.isInited();
        super.enteringPage();
        if (bl) {
            CircuitFilter circuitFilter = this.getCircuitFilter();
            circuitFilter.setFilterCriteria(null);
            circuitFilter.addMatcher(new MergeMatcher());
            circuitFilter.setMergeFilterActive(true);
        }
        this.filterCircuits();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mergePB) {
            this.mergeCircuits();
        } else if (object == this.filterPB) {
            this.filterCircuits();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeCircuits() {
        INetCircuit[] iNetCircuitArray = this.getSelectedCircuits("Merge In", false);
        if (iNetCircuitArray.length == 0) {
            return;
        }
        ArrayList<INetCircuit> arrayList = new ArrayList<INetCircuit>();
        arrayList.add(this.ckt);
        arrayList.addAll(Arrays.asList(iNetCircuitArray));
        String string = "CTC will merge the selected circuit" + (iNetCircuitArray.length > 1 ? "s" : "") + " into the " + "current circuit." + "\nTraffic will not be affected." + "\n\nIs it OK to continue?";
        String string2 = "Merge Circuits";
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)string2)) {
            return;
        }
        CircuitMergeDialog circuitMergeDialog = null;
        INetCircuit iNetCircuit = (INetCircuit)arrayList.get(0);
        INetCircuit iNetCircuit2 = (INetCircuit)arrayList.get(1);
        NetVcatCircuit netVcatCircuit = null;
        NetVcatCircuit netVcatCircuit2 = null;
        this.mergeProcessFinished = false;
        if (iNetCircuit.isOpenEndedVcatCircuit() && iNetCircuit2.isOpenEndedVcatCircuit()) {
            netVcatCircuit = NetCircuitMergeOperator.getNetVcatCircuit(iNetCircuit);
            netVcatCircuit2 = NetCircuitMergeOperator.getNetVcatCircuit(iNetCircuit2);
            string = "CTC will rename the participating VCAT circuits during the Merge.\nThe Child Vcat circuit will go to PARTIAL state. \n\nIs it OK to continue?";
            if (netVcatCircuit != null && netVcatCircuit2 != null) {
                if (!(netVcatCircuit.getCircuitName().endsWith("_Master") || netVcatCircuit2.getCircuitName().endsWith("Child") || netVcatCircuit.getCircuitName().endsWith("_Child") || netVcatCircuit2.getCircuitName().endsWith("_Master"))) {
                    try {
                        NetCircuitMergeOperator.validate(iNetCircuit);
                    }
                    catch (Exception exception) {
                        CerentDialog.errorDialog((Component)((Object)this), (String)exception.getMessage());
                        return;
                    }
                    if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)string2)) {
                        return;
                    }
                    try {
                        netVcatCircuit.rename(netVcatCircuit.getCircuitName() + "_Master");
                    }
                    catch (CircuitProvError circuitProvError) {
                        circuitProvError.printStackTrace();
                    }
                    try {
                        netVcatCircuit2.rename(netVcatCircuit2.getCircuitName() + "_Child");
                    }
                    catch (CircuitProvError circuitProvError) {
                        circuitProvError.printStackTrace();
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else if (!netVcatCircuit.getCircuitName().endsWith("_Master") || !netVcatCircuit2.getCircuitName().endsWith("_Child")) {
                    if (!netVcatCircuit.getCircuitName().endsWith("_Master")) {
                        CerentDialog.errorDialog((Component)((Object)this), (String)("Please select " + netVcatCircuit2.getCircuitName() + " as the master during merging."));
                    }
                    return;
                }
            }
        }
        circuitMergeDialog = new CircuitMergeDialog((Component)((Object)this), arrayList, 0);
        Object object = this.mergeProcessLock;
        synchronized (object) {
            if (!this.mergeProcessFinished) {
                try {
                    this.mergeProcessLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    SDebug.printStackTrace((Throwable)interruptedException);
                }
            }
        }
        if (!circuitMergeDialog.needLooseMerge()) {
            return;
        }
        string = "The selected circuit" + (iNetCircuitArray.length > 1 ? "s" : "") + " cannot be completely merged into the current circuit." + "\nDisjoint remnants of the selected circuit" + (iNetCircuitArray.length > 1 ? "s" : "") + " might" + " remain after the merge." + "\n\nIs it OK to continue?";
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)(string2 = "Merge Circuits"))) {
            return;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        new CircuitMergeDialog((Component)((Object)this), arrayList, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeProcessFinished() {
        Object object = this.mergeProcessLock;
        synchronized (object) {
            this.mergeProcessFinished = true;
            this.mergeProcessLock.notifyAll();
        }
    }

    private void filterCircuits() {
        if (this.inFiltering) {
            return;
        }
        new FilterThread().start();
    }

    private List findLinedupCircuits() {
        return this.mergeFilter.findLinedupCircuits();
    }

    protected void removeActionListeners() {
        this.mergePB.removeActionListener(this);
    }

    protected void loadCircuitFilterPreferences() {
    }

    class FilterThread
    extends Thread {
        FilterThread() {
        }

        public void run() {
            CedMergePane.this.inFiltering = true;
            CedMergePane.this.filterProcessLabel.setVisible(true);
            CedMergePane.this.mergePB.setEnabled(false);
            CedMergePane.this.filterPB.setEnabled(false);
            List list = CedMergePane.this.findLinedupCircuits();
            if (db.on()) {
                db.println("Find " + list.size() + " lined up circuits");
            }
            if (db.on()) {
                db.println("set linedup filter on");
            }
            CedMergePane.this.linedupFilterOn = true;
            CedMergePane.this.linedupCircuits.clear();
            CedMergePane.this.linedupCircuits.addAll(list);
            if (CedMergePane.this.linedupCircuits.size() != CedMergePane.this.getAllCircuits().size()) {
                CedMergePane.this.filterChanged();
            }
            CedMergePane.this.filterPB.setEnabled(true);
            if (CedMergePane.this.table != null && CedMergePane.this.table.getSelectedRowCount() > 0) {
                CedMergePane.this.enableComponent(CedMergePane.this.mergePB);
            }
            CedMergePane.this.filterProcessLabel.setVisible(false);
            CedMergePane.this.inFiltering = false;
        }
    }

    private class MergeMatcher
    extends AbstractMatcher {
        private MergeMatcher() {
        }

        public boolean doesMatch(Object object) {
            INetCircuit iNetCircuit = (INetCircuit)object;
            if (iNetCircuit == CedMergePane.this.ckt) {
                return false;
            }
            if (!CedMergePane.this.linedupFilterOn) {
                return CedMergePane.this.mergeFilter.isMergeable(iNetCircuit);
            }
            return CedMergePane.this.linedupCircuits.contains(iNetCircuit);
        }

        public Object getCriteria() {
            return null;
        }

        public Object[] getMetadata() {
            return null;
        }
    }
}

