/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.circuits.CcdEndpointsPane;
import cerent.cms.ui.circuits.CcdWizardInfo;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.CircuitEditTabbedView;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventMaskUtil;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.WID;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CedMonitorPane
extends AbstractPane
implements ActionListener,
ListSelectionListener {
    private JList monSrcEndList;
    private JButton createPB;
    private INetCircuit ckt;
    private static final String CREATE = "Create Monitor Circuit...";
    private static final SDebug db = new SDebug("CedMonitorPane");

    public CedMonitorPane(String string, CircuitEditTabbedView circuitEditTabbedView) {
        super(string, circuitEditTabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        JLabel jLabel = new JLabel("Select Monitor Source:");
        this.monSrcEndList = new JList(new DefaultListModel());
        this.monSrcEndList.setCellRenderer(new CircuitEndCellRenderer());
        this.monSrcEndList.setSelectionMode(0);
        this.monSrcEndList.addListSelectionListener(this);
        this.createPB = new JButton(CREATE);
        this.createPB.setEnabled(false);
        this.createPB.addActionListener(this);
        JPanel jPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.add(jLabel, "North");
        this.add((Component)new UScrollPane((Component)this.monSrcEndList), "Center");
        jPanel.add(this.createPB);
        this.add(jPanel, "South");
        NetCircuitModel netCircuitModel = (NetCircuitModel)circuitEditTabbedView.getUiModel();
        this.ckt = netCircuitModel.getNetCircuit();
        this.ckt.addObserver((Observer)((Object)this));
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (db.on()) {
            db.println("destroy");
        }
        CedMonitorPane cedMonitorPane = this;
        synchronized (cedMonitorPane) {
            this.ckt.deleteObserver((Observer)((Object)this));
            this.ckt = null;
        }
        super.destroy();
    }

    private synchronized List getCircuitMonitorSourcePoints() {
        if (this.ckt == null) {
            return new ArrayList();
        }
        List list = this.ckt.getCircuitNodes();
        ArrayList arrayList = new ArrayList(4 * list.size());
        for (INetCircuitNode iNetCircuitNode : list) {
            try {
                arrayList.addAll(iNetCircuitNode.getMonitorSourcePoints());
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                SDebug.printStackTrace((Throwable)sanityCheckFailed);
            }
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return CircuitEndCellRenderer.asCommaSeparatedString((INetCircuitEnd)object, false).compareTo(CircuitEndCellRenderer.asCommaSeparatedString((INetCircuitEnd)object2, false));
            }
        });
        return arrayList;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            boolean bl;
            boolean bl2 = bl = this.isUserAuthorized() && !this.monSrcEndList.getSelectionModel().isSelectionEmpty();
            if (bl) {
                INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)this.monSrcEndList.getSelectedValue();
                INodeModel iNodeModel = Network.instance().getNodeModel(iNetCircuitEnd.getNodeId());
                if (iNodeModel.provides(Feature.NO_MONITORS)) {
                    bl = false;
                }
            }
            this.createPB.setEnabled(bl);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = EventMaskUtil.isCtrlShiftPressed(actionEvent);
        try {
            if (PortGrouping.isPortGroupingCircuit(this.ckt)) {
                ErrorMsg.displayWarning((Component)((Object)this), (WID)NEMC.WID_DISALLOW_CREATING_MONITOR);
                return;
            }
        }
        catch (UnsupportedOperation unsupportedOperation) {
            SDebug.printStackTrace((Throwable)unsupportedOperation);
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNSUPPORTED_OPERATION);
            return;
        }
        catch (ProvisionError provisionError) {
            SDebug.printStackTrace((Throwable)provisionError);
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_PROVISION_ERROR);
            return;
        }
        this.addMonitorCircuit(bl);
    }

    private void addMonitorCircuit(boolean bl) {
        CcdWizardInfo ccdWizardInfo = new CcdWizardInfo();
        ccdWizardInfo.circuitType = this.ckt.getCircuitType();
        CircuitCreationDialog circuitCreationDialog = new CircuitCreationDialog(ccdWizardInfo, JOptionPane.getFrameForComponent((Component)((Object)this)), null, !bl);
        String string = this.ckt.getCircuitName();
        int n = 48;
        String string2 = "_MON";
        if (string.length() > n - string2.length()) {
            string = string.substring(0, n - string2.length());
        }
        circuitCreationDialog.setCircuitName(string + string2);
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(this.ckt.getCircuitType(), this.ckt.getCircuitSize(), 0, true, circuitCreationDialog.getCircuitName(), 2);
        circuitCreationDialog.setCircuitInfo(circuitCreatInfo);
        circuitCreationDialog.setApplyDropPorts(true);
        RoutePrefs routePrefs = new RoutePrefs();
        routePrefs.setPathProt(2);
        routePrefs.setDiversityOption(2);
        circuitCreationDialog.setRoutePrefs(routePrefs);
        if (db.on()) {
            db.println("addMonitorCircuit: refreshing attrs page");
        }
        circuitCreationDialog.revalidateCurrentPane();
        if (db.on()) {
            db.println("addMonitorCircuit: Next from attrs page");
        }
        circuitCreationDialog.forceNext();
        INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)this.monSrcEndList.getSelectedValue();
        if (db.on()) {
            db.println("addMonitorCircuit: setting source node");
        }
        circuitCreationDialog.setSourceNode(iNetCircuitEnd.getNodeModel());
        if (db.on()) {
            db.println("addMonitorCircuit: setting source endpoint");
        }
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)circuitCreationDialog.getPaneByName("Source");
        ccdEndpointsPane.setEndpointPanel(iNetCircuitEnd.getNodeModel());
        ccdEndpointsPane.getMainPanel().setEndpoint(iNetCircuitEnd);
        circuitCreationDialog.revalidateCurrentPane();
        if (db.on()) {
            db.println("addMonitorCircuit: Next from source page");
        }
        circuitCreationDialog.forceNext();
        circuitCreationDialog.showModal();
    }

    public void refresh() {
        if (CedMonitorPane.db.on) {
            db.println("refresh");
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.monSrcEndList.getModel();
        List list = this.getCircuitMonitorSourcePoints();
        defaultListModel.setSize(list.size());
        for (int i = 0; i < list.size(); ++i) {
            defaultListModel.setElementAt(list.get(i), i);
        }
    }

    public void leavingPage() throws Exception {
    }

    public void enteringPage() throws Exception {
    }
}

