/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.SecurityLevel;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.SvlanCircuit;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.circuits.CircuitDropCreationDialog;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.SvlanCircuitColumnRenderer;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventMaskUtil;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class CedSvlanEndPointsPane
extends AbstractPane
implements ActionListener,
ListSelectionListener {
    public static final String CREATE = "Create...";
    public static final String DELETE = "Delete...";
    private SvlanCircuit ckt;
    private DefaultListModel endPointListModel;
    private JList endPointList;
    private JButton createPB;
    private JButton deletePB;
    private boolean needsRefresh = true;
    private TabbedView tabbedView;
    private int minEndPointToDelete;
    private static final SDebug db = new SDebug("CedSvlanEndPointsPane");

    public CedSvlanEndPointsPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        if (db.on()) {
            db.println("<init>: start");
        }
        this.tabbedView = tabbedView;
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        NetCircuitModel netCircuitModel = (NetCircuitModel)tabbedView.getUiModel();
        this.ckt = (SvlanCircuit)netCircuitModel.getNetCircuit();
        this.minEndPointToDelete = this.ckt.isProtectionRingComplete() ? 1 : 2;
        this.ckt.addObserver((Observer)((Object)this));
        this.setLayout(new BorderLayout(5, 5));
        this.endPointListModel = new DefaultListModel();
        this.endPointList = new JList(this.endPointListModel);
        this.endPointList.setCellRenderer(new CircuitEndCellRenderer());
        this.endPointList.setVisibleRowCount(6);
        this.endPointList.addListSelectionListener(this);
        this.add((Component)new UScrollPane((Component)this.endPointList), "Center");
        this.add(this.getButtonBar(), "South");
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    public void destroy() {
        if (db.on()) {
            db.println("destroy");
        }
        this.ckt.deleteObserver((Observer)((Object)this));
        super.destroy();
    }

    public void update(Observable observable, Object object) {
        this.requestRefresh(this, null);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.deletePB.setEnabled(this.isUserAuthorized() && !this.endPointList.getSelectionModel().isSelectionEmpty() && this.endPointList.getModel().getSize() > this.minEndPointToDelete);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = EventMaskUtil.isCtrlShiftPressed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            if (this.isDestroyed()) {
                SDebug.printStackTrace((Throwable)new Exception("Destroyed"));
                return;
            }
            CircuitDropCreationDialog circuitDropCreationDialog = new CircuitDropCreationDialog((JComponent)((Object)this), this.tabbedView, this.ckt, bl);
            circuitDropCreationDialog.showModal();
        } else if (object == this.deletePB) {
            Object[] objectArray = this.endPointList.getSelectedValues();
            if (this.endPointList.getModel().getSize() - objectArray.length < this.minEndPointToDelete) {
                CerentDialog.infoDialog((Component)((Object)this), (String)(this.ckt.isProtectionRingComplete() ? "A SVLAN protected circuit must have at least one end point." : "A SVLAN circuit must have at least two end points."), (String)"Delete Circuit End Point");
                return;
            }
            if (CerentDialog.yesNoDialog((Component)((Object)this), (String)"Do you really want to delete the selected end point/s?", (String)"Delete Circuit End Point")) {
                this.swapSourceWithDrop(objectArray);
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        this.ckt.deleteDrop((INetCircuitEnd)objectArray[i]);
                        this.endPointListModel.removeElement(objectArray[i]);
                    }
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ERROR_DELETING_CKT_SVLAN_EP);
                }
            }
        }
    }

    private void swapSourceWithDrop(Object[] objectArray) {
        int n;
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.ckt.getPrimarySource();
        boolean bl = false;
        for (n = 0; n < objectArray.length; ++n) {
            if (!netCircuitEnd.equals((INetCircuitEnd)objectArray[n])) continue;
            this.ckt.changeSourceToDropOnNode(netCircuitEnd);
            bl = true;
            break;
        }
        if (bl) {
            block1: for (n = 0; n < this.endPointListModel.getSize(); ++n) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (((INetCircuitEnd)objectArray[i]).equals((INetCircuitEnd)this.endPointListModel.getElementAt(n))) continue block1;
                }
                if (!(this.endPointListModel.getElementAt(n) instanceof NetCircuitDropInfo)) continue;
                NetCircuitEnd netCircuitEnd2 = ((NetCircuitDropInfo)this.endPointListModel.getElementAt(n)).getNetCktEnd();
                this.ckt.changeDropToSourceOnNode(netCircuitEnd2);
                break;
            }
            this.ckt.reAlignCircuitSourceAndDrop();
        }
    }

    private JPanel getButtonBar() {
        this.createPB = new JButton(CREATE);
        this.enableComponent(this.createPB);
        this.createPB.addActionListener(this);
        this.deletePB = new JButton(DELETE);
        this.deletePB.addActionListener(this);
        this.deletePB.setEnabled(false);
        JPanel jPanel = CedSvlanEndPointsPane.createHorizontalPanel(null);
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add(this.createPB);
        jPanel.add(this.deletePB);
        return jPanel;
    }

    public void leavingPage() throws Exception {
    }

    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("enteringPage");
        }
        if (this.needsRefresh) {
            this.needsRefresh = false;
            this.refresh();
        }
    }

    public void refresh() {
        if (db.on()) {
            db.println("refresh: start");
        }
        if (this.isDestroyed()) {
            if (db.on()) {
                db.println("refresh: nothing to do");
            }
            return;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.ckt.getSources());
        arrayList.addAll(this.ckt.getDrops());
        this.minEndPointToDelete = this.ckt.isProtectionRingComplete() ? 1 : 2;
        Collections.sort(arrayList, new SvlanCircuitColumnRenderer.NetCircuitEndStringComparator());
        this.createPB.setEnabled(this.isUserAuthorized());
        this.endPointListModel.setSize(arrayList.size());
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.endPointListModel.setElementAt(iterator.next(), n++);
        }
        this.deletePB.setEnabled(this.isUserAuthorized() && !this.endPointList.getSelectionModel().isSelectionEmpty() && this.endPointList.getModel().getSize() > this.minEndPointToDelete);
        if (db.on()) {
            db.println("refresh: finish");
        }
    }
}

