/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.UpsrSelector;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.LoAditModelSimulator;
import cerent.cms.ncp.LoConnModelSimulator;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.util.BlockingModeController;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IgnorableDialog;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;

public class CedUpsrTableModel
extends AbstractProvTableModel
implements BlockingModeController {
    private static final String SF_STRING = "declareSfBerLevel";
    private static final String SD_STRING = "declareSdBerLevel";
    private static final String SWITCH_STRING = "protectionOpApsClear";
    private static final String ERROR_STRING = "<error>";
    private INetCircuit circuit;
    private boolean isHo;
    private IConnectionModel[] models;
    private String[] nodeName;
    private String[] workingPath;
    private String[] protectPath;
    private IRevertiveBehavior[] revertiveBehavior;
    private Boolean[] switchOnPdip;
    private Attribute[] sfBerLevel;
    private Attribute[] sdBerLevel;
    private Attribute[] switchState;
    private Attribute[] lastReadSwitchState;
    private boolean[] isRowEditable;
    static final String ONLY_SELECTOR = "Only Selector";
    static final String FIRST_SELECTOR = "First Selector";
    static final String SECOND_SELECTOR = "Second Selector";
    private String[] upsrIndex;
    private String[] holdoffTimer;
    boolean backHaulCircuit = false;
    private boolean[] modelIsUpsrSelector;
    private boolean[][] cellDirty;
    private boolean[] workingActive;
    private int userSecurityLevel;
    private static final int NEEDS_REFRESH = 1;
    private static final int NEEDS_RESET = 2;
    public static final int NODE_INDEX = 0;
    public static final int WORKING_PATH_INDEX = 1;
    public static final int PROTECT_PATH_INDEX = 2;
    public static final int REVERTIVE_INDEX = 3;
    public static final int SFBER_INDEX = 4;
    public static final int SDBER_INDEX = 5;
    public static final int PDIP_INDEX = 6;
    public static final int SWITCH_INDEX = 7;
    public static final int HOLDOFF_INDEX = 8;
    private static final int[] columnSecurityLevel = new int[]{4, 4, 4, 2, 2, 2, 2, 1, 2};
    static final String CANNOT_VALIDATE_MSG = "Invalid data found in row: ";
    static final String WORKING_PATH = "Working Path";
    static final String PROTECT_PATH = "Protect Path";
    static final String PREF_HOT_VALUE = "warnHot";
    static final String PREF_HOT_DESCR = "Hold-Off Time delays Protection Switch";
    private Component dialogRef = null;
    private static final SDebug db = new SDebug("CedUpsrTableModel");

    public CedUpsrTableModel(NetCircuitModel netCircuitModel, Component component) {
        super(new IModel[0], true, null);
        this.dialogRef = component;
        this.circuit = netCircuitModel.getNetCircuit();
        this.backHaulCircuit = this.circuit instanceof NetVcatCircuit ? NetCircuit.isBackHaulVcatCircuit(this.circuit) : NetCircuit.isMemberOfBackHaulCircuit(this.circuit);
        this.columnNames = new String[]{"Node", WORKING_PATH, PROTECT_PATH, "Revert Time", "SF Ber Level", "SD Ber Level", "PDI-P", "Switch State", "Hold-off Timer (ms)"};
        ICircuitType iCircuitType = this.circuit.getCircuitTypeObj();
        if (!iCircuitType.isLoCircuitType() && !iCircuitType.isLoVcatCircuitType()) {
            this.isHo = true;
        }
        this.userSecurityLevel = this.getSecurityLevel();
        if (db.on()) {
            db.println("userSecurityLevel = " + this.userSecurityLevel);
        }
        this.observableManager.setBlockingModeController((BlockingModeController)this);
    }

    public void disposeDataSource() {
        if (db.on()) {
            db.println("disposeDataSource");
        }
        if (this.circuit != null) {
            this.circuit.deleteObserver(this);
            this.circuit = null;
        }
        super.disposeDataSource();
    }

    public boolean isCellEditable(int n, int n2) {
        IHoPathDefModel[] iHoPathDefModelArray;
        IHoPathDefModel[] iHoPathDefModelArray2;
        boolean bl;
        if (!this.isRowEditable[n] || this.models[n] instanceof LoConnModelSimulator) {
            return false;
        }
        boolean bl2 = bl = this.enabled && this.userSecurityLevel >= columnSecurityLevel[n2];
        if (!bl) {
            return bl;
        }
        if (!(this.modelIsUpsrSelector == null || this.modelIsUpsrSelector[n] || n2 != 4 && n2 != 5 && n2 != 6 && n2 != 8)) {
            bl = false;
        }
        if (this.modelIsUpsrSelector != null && this.modelIsUpsrSelector[n] && this.backHaulCircuit) {
            iHoPathDefModelArray2 = null;
            if (this.models[n] instanceof IHoConnectionModel) {
                iHoPathDefModelArray2 = ((IHoConnectionModel)this.models[n]).getPaths();
            } else if (this.models[n] instanceof ILoConnectionModel) {
                iHoPathDefModelArray2 = ((ILoConnectionModel)this.models[n]).getPaths();
            }
            IConnectionModels iConnectionModels = this.models[n].getNodeModel().getConnectionModels();
            if (this.isHo) {
                iHoPathDefModelArray = iHoPathDefModelArray2;
            } else {
                iHoPathDefModelArray = new IHoPathDefModel[iHoPathDefModelArray2.length];
                for (int i = 0; i < iHoPathDefModelArray2.length; ++i) {
                    ILoDefModel iLoDefModel = (ILoDefModel)iHoPathDefModelArray2[i];
                    ILoAditModel iLoAditModel = iLoDefModel.getLoAdit();
                    iHoPathDefModelArray[i] = iLoAditModel instanceof LoAditModelSimulator ? iLoAditModel.getHo() : iConnectionModels.getHoPathDef(iLoDefModel);
                }
            }
            try {
                if (this.upsrIndex[n].equalsIgnoreCase(FIRST_SELECTOR) || this.upsrIndex[n].equalsIgnoreCase(ONLY_SELECTOR) ? iHoPathDefModelArray[0].getPool().getEntityModel().getModuleModel().getEqType() == 285 && iHoPathDefModelArray[1].getPool().getEntityModel().getModuleModel().getEqType() == 285 : this.upsrIndex[n].equalsIgnoreCase(SECOND_SELECTOR) && iHoPathDefModelArray[2].getPool().getEntityModel().getModuleModel().getEqType() == 285 && iHoPathDefModelArray[3].getPool().getEntityModel().getModuleModel().getEqType() == 285) {
                    return false;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (n2 == 6) {
            boolean bl3;
            if (this.models[n] instanceof IHoConnectionModel) {
                iHoPathDefModelArray2 = (IHoPathDefModel[])this.models[n];
                iHoPathDefModelArray = iHoPathDefModelArray2.getNodeModel();
                boolean bl4 = Feature.provides((INodeModel)iHoPathDefModelArray, (Feature)Feature.SELECTOR_ADDED_ATTRS);
                if (bl4) {
                    bl = iHoPathDefModelArray2.getDriNodeType() == 0;
                }
            } else if (this.models[n] instanceof ILoConnectionModel && (bl3 = Feature.provides((INodeModel)(iHoPathDefModelArray = (iHoPathDefModelArray2 = (ILoConnectionModel)this.models[n]).getNodeModel()), (Feature)Feature.SELECTOR_ADDED_ATTRS))) {
                boolean bl5 = bl = iHoPathDefModelArray2.getDriNodeType() == 0;
            }
        }
        if (this.modelIsUpsrSelector != null && this.modelIsUpsrSelector[n] && (n2 == 4 && this.sfBerLevel[n].getIntValue() == -1 || n2 == 5 && this.sdBerLevel[n].getIntValue() == -1)) {
            bl = false;
        }
        return bl;
    }

    public Class getColumnClass(int n) {
        return n == 3 ? IRevertiveBehavior.class : (n == 6 ? Boolean.class : Object.class);
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.nodeName[n];
            }
            case 1: {
                return this.workingPath[n];
            }
            case 2: {
                return this.protectPath[n];
            }
            case 3: {
                return this.revertiveBehavior[n];
            }
            case 4: {
                return this.sfBerLevel[n];
            }
            case 5: {
                return this.sdBerLevel[n];
            }
            case 6: {
                return this.switchOnPdip[n];
            }
            case 7: {
                return this.switchState[n];
            }
            case 8: {
                return this.holdoffTimer[n];
            }
        }
        if (db.on()) {
            db.println("getValueAt(" + n + "," + n2 + "): bad column");
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            if (db.on()) {
                db.println("setValueAt(" + n + "," + n2 + "): null value");
            }
            return;
        }
        switch (n2) {
            case 3: {
                this.revertiveBehavior[n] = (IRevertiveBehavior)object;
                break;
            }
            case 4: {
                this.sfBerLevel[n] = (Attribute)object;
                break;
            }
            case 5: {
                this.sdBerLevel[n] = (Attribute)object;
                break;
            }
            case 6: {
                this.switchOnPdip[n] = (Boolean)object;
                break;
            }
            case 7: {
                this.switchState[n] = (Attribute)object;
                break;
            }
            case 8: {
                this.holdoffTimer[n] = (String)object;
                break;
            }
            default: {
                if (db.on()) {
                    db.println("setValueAt(" + n + "," + n2 + "): bad column");
                }
                return;
            }
        }
        this.rowDirty[n] = true;
        this.cellDirty[n][n2] = true;
        this.fireTableRowsUpdated(n, n);
    }

    public boolean isWorkingActive(int n) {
        return this.workingActive[n];
    }

    public int getLastReadSwitchState(int n) {
        return this.lastReadSwitchState[n].getIntValue();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel(): numlines=" + this.numLines);
        }
        AttributeMaps attributeMaps = NetworkDefaults.getAttributeMap();
        for (int i = 0; i < this.numLines; ++i) {
            boolean bl;
            block33: {
                bl = false;
                this.isRowEditable[i] = true;
                if (db.on()) {
                    db.println("refreshing line" + i + "/" + (this.numLines - 1));
                }
                IConnectionModel iConnectionModel = this.models[i];
                this.nodeName[i] = iConnectionModel.getNodeModel().getName();
                if (this.upsrIndex[i].equals(FIRST_SELECTOR)) {
                    int n = i;
                    this.nodeName[n] = this.nodeName[n] + " (" + CircuitMapUtil.getSelectorString(iConnectionModel, true, db) + ")";
                } else if (this.upsrIndex[i].equals(SECOND_SELECTOR)) {
                    int n = i;
                    this.nodeName[n] = this.nodeName[n] + " (" + CircuitMapUtil.getSelectorString(iConnectionModel, false, db) + ")";
                }
                try {
                    int n;
                    Attribute attribute;
                    boolean bl2;
                    this.refreshPathInfo(i);
                    if (this.workingPath[i] == ERROR_STRING || this.protectPath[i] == ERROR_STRING) {
                        bl = true;
                        break block33;
                    }
                    if (db.on()) {
                        db.println("WORKING ACTIVE ON " + i + "?" + this.isWorkingActive(i));
                    }
                    INodeModel iNodeModel = this.models[i].getNodeModel();
                    boolean bl3 = Feature.provides((INodeModel)iNodeModel, (Feature)Feature.BLSR_UPSR_DRI);
                    boolean bl4 = Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SELECTOR_ADDED_ATTRS);
                    boolean bl5 = bl2 = this.upsrIndex[i].equals(SECOND_SELECTOR) && this.modelIsUpsrSelector[i];
                    if (bl3 && bl2) {
                        if (db.on()) {
                            db.finer("Using getReverseUpsrReversion on row " + (i + 1));
                        }
                        this.revertiveBehavior[i] = ((UpsrSelector)this.models[i]).getReverseUpsrReversion();
                    } else {
                        this.revertiveBehavior[i] = this.models[i] instanceof ILoConnectionModel ? ((ILoConnectionModel)this.models[i]).getUpsrReversion() : ((IHoConnectionModel)this.models[i]).getUpsrReversion();
                    }
                    this.sfBerLevel[i] = attribute = new Attribute("N/A", -1);
                    this.sdBerLevel[i] = attribute;
                    try {
                        if (this.modelIsUpsrSelector[i]) {
                            UpsrSelector upsrSelector = (UpsrSelector)this.models[i];
                            if (bl4 && bl2) {
                                if (db.on()) {
                                    db.finer("Using getReverse*Ber on row " + (i + 1));
                                }
                                this.sfBerLevel[i] = attributeMaps.getAttributeForVal(SF_STRING, upsrSelector.getReverseUpsrSfBerLevel());
                                this.sdBerLevel[i] = attributeMaps.getAttributeForVal(SD_STRING, upsrSelector.getReverseUpsrSdBerLevel());
                            } else {
                                this.sfBerLevel[i] = attributeMaps.getAttributeForVal(SF_STRING, upsrSelector.getUpsrSfBerLevel());
                                this.sdBerLevel[i] = attributeMaps.getAttributeForVal(SD_STRING, upsrSelector.getUpsrSdBerLevel());
                            }
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        this.sfBerLevel[i] = attribute;
                        this.sdBerLevel[i] = attribute;
                    }
                    if (bl3 && bl2) {
                        if (db.on()) {
                            db.finer("Using getReverseUpsrSwitchOnPdiP on row " + (i + 1));
                        }
                        this.switchOnPdip[i] = new Boolean(((UpsrSelector)this.models[i]).getReverseUpsrSwitchOnPdiP());
                    } else {
                        this.switchOnPdip[i] = this.modelIsUpsrSelector[i] ? new Boolean(((UpsrSelector)this.models[i]).getUpsrSwitchOnPdiP()) : Boolean.FALSE;
                    }
                    if (this.upsrIndex[i].equals(ONLY_SELECTOR) || this.upsrIndex[i].equals(FIRST_SELECTOR)) {
                        if (db.on()) {
                            db.println("refreshFromModel: " + this.upsrIndex[i] + ", calling getProtectionOp()");
                        }
                        n = this.models[i] instanceof ILoConnectionModel ? ((ILoConnectionModel)this.models[i]).getProtectionOp() : ((IHoConnectionModel)this.models[i]).getProtectionOp();
                    } else if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.REV_PROT_OP)) {
                        if (db.on()) {
                            db.println("refreshFromModel: CD selector, calling getReverseProtectionOp()");
                        }
                        n = this.models[i] instanceof ILoConnectionModel ? ((ILoConnectionModel)this.models[i]).getReverseProtectionOp() : ((IHoConnectionModel)this.models[i]).getReverseProtectionOp();
                    } else {
                        if (db.on()) {
                            db.println(iNodeModel.getName() + " refreshFromModel: CD selector, " + "getReverseProtectionOp not " + "supported, calling getProtectionOp()");
                        }
                        n = this.models[i] instanceof ILoConnectionModel ? ((ILoConnectionModel)this.models[i]).getProtectionOp() : ((IHoConnectionModel)this.models[i]).getProtectionOp();
                    }
                    this.switchState[i] = attributeMaps.getAttributeForVal(SWITCH_STRING, n);
                    this.lastReadSwitchState[i] = attributeMaps.getAttributeForVal(SWITCH_STRING, n);
                    this.holdoffTimer[i] = "N/A";
                    if (this.modelIsUpsrSelector[i] && Feature.provides((INodeModel)iNodeModel, (Feature)Feature.HOLDOFF_TIMER)) {
                        this.holdoffTimer[i] = this.upsrIndex[i].equals(ONLY_SELECTOR) || this.upsrIndex[i].equals(FIRST_SELECTOR) ? new Integer(((UpsrSelector)this.models[i]).getHoldoffTime()).toString() : new Integer(((UpsrSelector)this.models[i]).getReverseHoldoffTime()).toString();
                    }
                }
                catch (Exception exception) {
                    db.println("Exception refreshFromModel, iteration #" + (i + 1));
                    SDebug.printStackTrace((Throwable)exception);
                    bl = true;
                }
            }
            if (bl) {
                this.workingPath[i] = ERROR_STRING;
                this.protectPath[i] = ERROR_STRING;
                this.revertiveBehavior[i] = null;
                this.sfBerLevel[i] = null;
                this.sdBerLevel[i] = null;
                this.switchOnPdip[i] = null;
                this.switchState[i] = null;
                this.holdoffTimer[i] = null;
                this.isRowEditable[i] = false;
                if (db.on()) {
                    db.println("make row " + (i + 1) + " not editable!");
                }
            }
            for (int j = 0; j <= 8; ++j) {
                this.cellDirty[i][j] = false;
            }
        }
        super.refreshFromModel();
    }

    private void refreshPathInfo(int n) {
        int n2;
        ILoDefModel[] iLoDefModelArray;
        ILoDefModel[] iLoDefModelArray2;
        if (this.models[n] instanceof ILoConnectionModel) {
            iLoDefModelArray2 = ((ILoConnectionModel)this.models[n]).getPaths();
            iLoDefModelArray = ((ILoConnectionModel)this.models[n]).getActivePaths();
            n2 = ((ILoConnectionModel)this.models[n]).getConnectionType();
        } else {
            iLoDefModelArray2 = ((IHoConnectionModel)this.models[n]).getPaths();
            iLoDefModelArray = ((IHoConnectionModel)this.models[n]).getActivePaths();
            n2 = ((IHoConnectionModel)this.models[n]).getConnectionType();
        }
        if (iLoDefModelArray2 == null || iLoDefModelArray == null) {
            if (db.on()) {
                db.println("refreshPathInfo(" + n + "): paths or activePaths is null");
            }
            this.workingPath[n] = ERROR_STRING;
            this.protectPath[n] = ERROR_STRING;
            this.workingActive[n] = true;
            return;
        }
        int n3 = 0;
        for (int i = 0; i <= n; ++i) {
            if (this.upsrIndex[i].equals(SECOND_SELECTOR)) continue;
            ++n3;
        }
        if (db.on()) {
            db.println("---- I = " + n + ", related to ps " + n3);
        }
        if (db.on()) {
            db.println("refreshPathInfo(" + n + "): paths.length = " + iLoDefModelArray2.length + ", activePaths.length = " + iLoDefModelArray.length);
        }
        IConnectionModels iConnectionModels = this.models[n].getNodeModel().getConnectionModels();
        int n4 = 0;
        int n5 = 1;
        int n6 = 2;
        int n7 = 3;
        if (n2 == 13) {
            n5 = 3;
            n7 = 1;
        } else if (n2 == 15) {
            n5 = 3;
        } else if (n2 == 14) {
            n5 = 3;
        } else if (n2 == 16) {
            n5 = 3;
        }
        this.workingPath[n] = CedUpsrTableModel.getPathString(iConnectionModels, iLoDefModelArray2[n4], this.isHo);
        this.protectPath[n] = CedUpsrTableModel.getPathString(iConnectionModels, iLoDefModelArray2[n5], this.isHo);
        String string = CedUpsrTableModel.getPathString(iConnectionModels, iLoDefModelArray[0], this.isHo);
        if (this.workingPath[n] != null && this.workingPath[n] != ERROR_STRING) {
            this.workingActive[n] = this.workingPath[n].equals(string);
        } else if (this.protectPath[n] != null && this.protectPath[n] != ERROR_STRING) {
            this.workingActive[n] = !this.protectPath[n].equals(string);
        }
        boolean bl = CircuitMapUtil.connectionHasSecondSelector(this.models[n]);
        if (bl && this.upsrIndex[n].equals(SECOND_SELECTOR)) {
            this.workingPath[n] = CedUpsrTableModel.getPathString(iConnectionModels, iLoDefModelArray2[n6], this.isHo);
            this.protectPath[n] = CedUpsrTableModel.getPathString(iConnectionModels, iLoDefModelArray2[n7], this.isHo);
            string = CedUpsrTableModel.getPathString(iConnectionModels, iLoDefModelArray[1], this.isHo);
            if (this.workingPath[n] != null && this.workingPath[n] != ERROR_STRING) {
                this.workingActive[n] = this.workingPath[n].equals(string);
            } else if (this.protectPath[n] != null && this.protectPath[n] != ERROR_STRING) {
                boolean bl2 = this.workingActive[n] = !this.protectPath[n].equals(string);
            }
        }
        if (db.on()) {
            db.println("\t(path is: " + this.workingPath[n] + ")");
            db.println("\t(active path is " + string + " and working is " + (this.workingActive[n] ? "" : "NOT ") + "active)");
        }
        if (db.on()) {
            int n8;
            db.println("PATHINFO " + this.models[n].getNodeModel().getName());
            for (n8 = 0; n8 < iLoDefModelArray2.length; ++n8) {
                db.println(n8 + ". " + CedUpsrTableModel.getPathString(iConnectionModels, iLoDefModelArray2[n8], this.isHo));
            }
            db.println("ACTIVEPATHINFO " + this.models[n].getNodeModel().getName());
            for (n8 = 0; n8 < iLoDefModelArray.length; ++n8) {
                db.println(n8 + ". " + CedUpsrTableModel.getPathString(iConnectionModels, iLoDefModelArray[n8], this.isHo));
            }
        }
    }

    public static String getPathString(IConnectionModels iConnectionModels, Object object, boolean bl) {
        String string = ERROR_STRING;
        Network network = Network.instance();
        try {
            ILoAditModel iLoAditModel;
            ILoNum iLoNum;
            IHoPathDefModel iHoPathDefModel;
            if (bl) {
                iHoPathDefModel = (IHoPathDefModel)object;
                iLoNum = null;
            } else {
                ILoDefModel iLoDefModel = (ILoDefModel)object;
                iLoAditModel = iLoDefModel.getLoAdit();
                iHoPathDefModel = iLoAditModel instanceof LoAditModelSimulator ? iLoAditModel.getHo() : iConnectionModels.getHoPathDef(iLoDefModel);
                if (iHoPathDefModel == null) {
                    return ERROR_STRING;
                }
                iLoNum = iLoDefModel.getLoNum();
            }
            int n = iConnectionModels.getMainEntityIndex(iHoPathDefModel);
            if (n == 0) {
                return ERROR_STRING;
            }
            iLoAditModel = iConnectionModels.getNodeModel();
            INodeModel iNodeModel = null;
            IEntityModel iEntityModel = null;
            if (iLoAditModel != null) {
                iNodeModel = network.getNetElem(iLoAditModel.getNodeId()).getNodeModel();
                iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(n);
            }
            IHoNum iHoNum = HoPathDefModel.physicalHo(iHoPathDefModel);
            NetCircuitEnd netCircuitEnd = new NetCircuitEnd(iNodeModel, iEntityModel, iHoNum, iLoNum, false);
            string = CircuitEndCellRenderer.asSlashSeparatedString(netCircuitEnd);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
        }
        catch (Exception exception) {
            db.println("Exception in getPathString: ");
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    public void refreshFromModel(int n) throws Exception {
        if (db.on()) {
            db.println("refreshFromModel(" + n + ")");
        }
        if (n == -1 || n == 2) {
            this.resetFromNetCircuitImpl();
        }
        this.refreshFromModel();
    }

    private Component getComponentForFrame() {
        return this.dialogRef;
    }

    public boolean validateData() {
        int n;
        String string = "A reversion time of 0.0 is no longer supported.\n";
        String string2 = "Changing a reversion time from 0.0 cannot be undone later.\n";
        String string3 = "\nIs it OK to continue?";
        String string4 = "Traffic might not switch away from this span.  Verify\nthe proper switch of traffic prior to performing potentially\nservice affecting work on this span.\n\nIs it OK to continue?\n";
        int n2 = 0;
        boolean bl = false;
        try {
            String string5;
            boolean bl2 = false;
            for (n = 0; n < this.numLines; ++n) {
                String string6;
                int n3;
                if (!this.rowDirty[n]) continue;
                string5 = this.models[n].getNodeModel();
                boolean bl3 = Feature.provides((INodeModel)string5, (Feature)Feature.BLSR_UPSR_DRI);
                boolean bl4 = this.upsrIndex[n].equals(SECOND_SELECTOR) && this.modelIsUpsrSelector[n];
                String string7 = null;
                if (this.switchState[n] == null) {
                    string7 = "The switch state in row " + (n + 1) + " is null.";
                } else if (this.models[n] == null) {
                    string7 = "The model in row " + (n + 1) + " is null.";
                } else if (this.revertiveBehavior[n] == null) {
                    string7 = "The revertive behavior in row " + (n + 1) + " is null.";
                } else if (this.modelIsUpsrSelector[n] && Feature.provides((INodeModel)string5, (Feature)Feature.HOLDOFF_TIMER)) {
                    n3 = 0;
                    string6 = "The";
                    if (Feature.provides((INodeModel)string5, (Feature)Feature.BLSR_UPSR_DRI) && this.models[n].isBlsrDri()) {
                        n3 = 100;
                        string6 = "Because it is a primary or secondary " + CircuitMapUtil.BLSRDRI_TERM + " selector,\nthe";
                    }
                    boolean bl5 = false;
                    try {
                        int n4 = Integer.valueOf(this.holdoffTimer[n]);
                        if (n4 < 0 || n4 > 10000 || n4 % 100 != 0) {
                            bl5 = true;
                        } else if (this.cellDirty[n][8]) {
                            if (n4 > 0) {
                                String string8 = ErrorMsg.getString((EID)NEMC.WID_CFMN_NONZERO_HOLDOF);
                                if (!bl2) {
                                    IgnorableDialog.warningDialog(null, (String)string8, (String)"Confirm Non-Zero Hold-Off Time", (String)PREF_HOT_VALUE, (String)PREF_HOT_DESCR);
                                    bl2 = true;
                                }
                            } else if (n4 < 100 && n3 == 100) {
                                bl5 = true;
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl5 = true;
                    }
                    if (bl5) {
                        ErrorMsg.displayError(null, NEMC.EID_INVALID_HOLDOFF_TIME_PARAM_4, String.valueOf(n + 1), string6, this.nodeName[n], String.valueOf(n3));
                        return false;
                    }
                }
                if (string7 != null) {
                    ErrorMsg.displayError(null, (EID)NEMC.EID_CANNOT_VALIDATE_DATA_PARAM_1, (Object)(CANNOT_VALIDATE_MSG + (n + 1) + "\n" + string7));
                    return false;
                }
                if (bl4) {
                    n3 = this.models[n] instanceof ILoConnectionModel ? ((ILoConnectionModel)this.models[n]).getReverseProtectionOp() : ((IHoConnectionModel)this.models[n]).getReverseProtectionOp();
                } else {
                    int n5 = n3 = this.models[n] instanceof ILoConnectionModel ? ((ILoConnectionModel)this.models[n]).getProtectionOp() : ((IHoConnectionModel)this.models[n]).getProtectionOp();
                }
                if (this.switchState[n].getIntValue() != n3) {
                    n2 = this.switchState[n].getIntValue();
                    if (db.on()) {
                        db.println("There is a switch occuring on row " + (n + 1) + " from " + n3 + " to " + n2);
                    }
                    bl = true;
                    break;
                }
                if (bl3 && bl4) {
                    string6 = ((UpsrSelector)this.models[n]).getReverseUpsrReversion();
                } else {
                    Object object = string6 = this.models[n] instanceof ILoConnectionModel ? ((ILoConnectionModel)this.models[n]).getUpsrReversion() : ((IHoConnectionModel)this.models[n]).getUpsrReversion();
                }
                if (string6.getReversionTime() != 0 || string6.getReversionMode() != 2 || this.revertiveBehavior[n].getReversionTime() == 0 && this.revertiveBehavior[n].getReversionMode() == 2 || CerentDialog.yesNoDialog((Component)this.getComponentForFrame(), (String)(string + string2 + string3), (String)"Zero Reversion Time Not Supported")) continue;
                return false;
            }
            string5 = null;
            if (n2 == 6 || n2 == 5) {
                string5 = "manual";
            } else if (n2 == 4 || n2 == 3) {
                string5 = "force";
            }
            if (!(n2 != 6 && n2 != 4 || this.isWorkingActive(n))) {
                return CerentDialog.yesNoDialog((Component)this.getComponentForFrame(), (String)("The path targeted for this switch request is already\nactive.  The switch request can be applied, but\ntraffic will not switch at this time.\n\nAre you sure you want to apply the " + string5 + " switch?\n"), (String)"Confirm Selector Switch");
            }
            if ((n2 == 5 || n2 == 3) && this.isWorkingActive(n)) {
                return CerentDialog.yesNoDialog((Component)this.getComponentForFrame(), (String)("The path targeted for this switch request is already\nactive.  The switch request can be applied, but\ntraffic will not switch at this time.\n\nAre you sure you want to apply the " + string5 + " switch?\n"), (String)"Confirm Selector Switch");
            }
            return !bl || !(n2 > 1 ? !CerentDialog.yesNoDialog((Component)this.getComponentForFrame(), (String)string4, (String)"Confirm Selector Switch") : !CerentDialog.yesNoDialog((Component)this.getComponentForFrame(), (String)("The " + CircuitMapUtil.UPSR_TERM + " selector(s) will be switched.\n" + "Is it OK to continue?"), (String)"Confirm Switch Request"));
        }
        catch (Exception exception) {
            ErrorMsg.displayError(null, (EID)NEMC.EID_CANNOT_VALIDATE_DATA_PARAM_1, (Object)(CANNOT_VALIDATE_MSG + (n + 1)));
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            boolean bl;
            if (!this.rowDirty[i]) continue;
            if (db.on()) {
                db.println("applyToModel: commiting row " + (i + 1));
            }
            INodeModel iNodeModel = this.models[i].getNodeModel();
            boolean bl2 = Feature.provides((INodeModel)iNodeModel, (Feature)Feature.BLSR_UPSR_DRI);
            boolean bl3 = Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SELECTOR_ADDED_ATTRS);
            boolean bl4 = bl = this.upsrIndex[i].equals(SECOND_SELECTOR) && this.modelIsUpsrSelector[i];
            if (this.cellDirty[i][3]) {
                if (bl2 && bl) {
                    if (db.on()) {
                        db.finer("Using getReverseUpsrReversion on row " + (i + 1));
                    }
                    ((UpsrSelector)this.models[i]).setReverseUpsrReversion(this.revertiveBehavior[i]);
                } else if (this.models[i] instanceof ILoConnectionModel) {
                    ((ILoConnectionModel)this.models[i]).setUpsrReversion(this.revertiveBehavior[i]);
                } else {
                    ((IHoConnectionModel)this.models[i]).setUpsrReversion(this.revertiveBehavior[i]);
                }
                this.cellDirty[i][3] = false;
            }
            if (this.cellDirty[i][4]) {
                if (bl3 && bl) {
                    ((UpsrSelector)this.models[i]).setReverseUpsrSfBerLevel((short)this.sfBerLevel[i].getIntValue());
                } else if (this.models[i] instanceof ILoConnectionModel) {
                    ((ILoConnectionModel)this.models[i]).setUpsrSfBerLevel((short)this.sfBerLevel[i].getIntValue());
                } else {
                    ((IHoConnectionModel)this.models[i]).setUpsrSfBerLevel((short)this.sfBerLevel[i].getIntValue());
                }
                this.cellDirty[i][4] = false;
            }
            if (this.cellDirty[i][5]) {
                if (bl3 && bl) {
                    ((UpsrSelector)this.models[i]).setReverseUpsrSdBerLevel((short)this.sdBerLevel[i].getIntValue());
                } else if (this.models[i] instanceof ILoConnectionModel) {
                    ((ILoConnectionModel)this.models[i]).setUpsrSdBerLevel((short)this.sdBerLevel[i].getIntValue());
                } else {
                    ((IHoConnectionModel)this.models[i]).setUpsrSdBerLevel((short)this.sdBerLevel[i].getIntValue());
                }
                this.cellDirty[i][5] = false;
            }
            if (this.cellDirty[i][6]) {
                if (bl2 && bl) {
                    if (db.on()) {
                        db.finer("Using setReverseUpsrSwitchOnPdiP on row " + (i + 1));
                    }
                    ((UpsrSelector)this.models[i]).setReverseUpsrSwitchOnPdiP(this.switchOnPdip[i].booleanValue());
                } else if (this.models[i] instanceof ILoConnectionModel) {
                    ((ILoConnectionModel)this.models[i]).setUpsrSwitchOnPdiP(this.switchOnPdip[i].booleanValue());
                } else {
                    ((IHoConnectionModel)this.models[i]).setUpsrSwitchOnPdiP(this.switchOnPdip[i].booleanValue());
                }
                this.cellDirty[i][6] = false;
            }
            if (this.cellDirty[i][8] && this.modelIsUpsrSelector[i]) {
                if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.HOLDOFF_TIMER)) {
                    if (this.upsrIndex[i].equals(ONLY_SELECTOR) || this.upsrIndex[i].equals(FIRST_SELECTOR)) {
                        ((UpsrSelector)this.models[i]).setHoldoffTime(Integer.valueOf(this.holdoffTimer[i]).intValue());
                    } else {
                        ((UpsrSelector)this.models[i]).setReverseHoldoffTime(Integer.valueOf(this.holdoffTimer[i]).intValue());
                    }
                }
                this.cellDirty[i][8] = false;
            }
            if (this.cellDirty[i][7]) {
                try {
                    int n = this.switchState[i].getIntValue();
                    if (this.upsrIndex[i].equals(ONLY_SELECTOR) || this.upsrIndex[i].equals(FIRST_SELECTOR)) {
                        if (this.models[i] instanceof ILoConnectionModel) {
                            ((ILoConnectionModel)this.models[i]).setProtectionOp(n);
                        } else {
                            ((IHoConnectionModel)this.models[i]).setProtectionOp(n);
                        }
                        if (db.on()) {
                            db.println("AB selector, ProtectionOp on table index " + i + " -> " + n);
                        }
                    } else if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.REV_PROT_OP)) {
                        if (db.on()) {
                            db.println("CD selector, ReverseProtectionOp on table index " + i + " -> " + n);
                        }
                        if (this.models[i] instanceof ILoConnectionModel) {
                            ((ILoConnectionModel)this.models[i]).setReverseProtectionOp(n);
                        } else {
                            ((IHoConnectionModel)this.models[i]).setReverseProtectionOp(n);
                        }
                    } else {
                        if (db.on()) {
                            db.println("CD selector, ReverseProtectionOp not supported, performing ProtectionOp on table index " + i + " -> " + n);
                        }
                        if (this.models[i] instanceof ILoConnectionModel) {
                            ((ILoConnectionModel)this.models[i]).setProtectionOp(n);
                        } else {
                            ((IHoConnectionModel)this.models[i]).setProtectionOp(n);
                        }
                    }
                }
                catch (ConnectionInLoopback connectionInLoopback) {
                    String string = ErrorMsg.getString((EID)NEMC.EID_PROTOP_ON_CONN_W_XCLOOPBACK);
                    throw new ConnectionInLoopback(string);
                }
                catch (InvalidProtectionOp invalidProtectionOp) {
                    throw new InvalidProtectionOp("An invalid protection operation occurred.");
                }
                catch (InternalCommError internalCommError) {
                    throw new InternalCommError("A card communication failure occurred.");
                }
                this.cellDirty[i][7] = false;
            }
            this.rowDirty[i] = false;
        }
    }

    private void resetFromNetCircuitImpl() {
        List list;
        if (db.on()) {
            db.println("resetFromNetCircuitImpl");
        }
        if ((list = CedUpsrTableModel.getConnectionModels(this.circuit)) != null) {
            int n;
            int n2 = list.size();
            ArrayList<IConnectionModel> arrayList = new ArrayList<IConnectionModel>();
            int n3 = 0;
            ArrayList<IConnectionModel> arrayList2 = new ArrayList<IConnectionModel>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (n = 0; n < n2; ++n) {
                IConnectionModel iConnectionModel = (IConnectionModel)list.get(n);
                arrayList.add(iConnectionModel);
                if (iConnectionModel != null) {
                    ++n3;
                    arrayList2.add(iConnectionModel);
                    if (CircuitMapUtil.connectionHasSecondSelector(iConnectionModel)) {
                        arrayList3.add(FIRST_SELECTOR);
                        if (CedUpsrTableModel.db.on) {
                            db.println("+1 to newLength (UPSR-UPSR or UPSR_IDRI)");
                        }
                        ++n3;
                        arrayList2.add(iConnectionModel);
                        arrayList3.add(SECOND_SELECTOR);
                        continue;
                    }
                    arrayList3.add(ONLY_SELECTOR);
                    continue;
                }
                db.println(CircuitMapUtil.UPSR_TERM + " Selector is null for connectionModel=" + list + ", index=" + n);
            }
            this.models = new IConnectionModel[n3];
            this.upsrIndex = new String[n3];
            this.modelIsUpsrSelector = new boolean[n3];
            for (n = 0; n < n3; ++n) {
                this.models[n] = (IConnectionModel)arrayList2.get(n);
                this.upsrIndex[n] = (String)arrayList3.get(n);
                this.modelIsUpsrSelector[n] = this.models[n] instanceof UpsrSelector;
            }
            this.nodeName = new String[n3];
            this.workingPath = new String[n3];
            this.protectPath = new String[n3];
            this.revertiveBehavior = new IRevertiveBehavior[n3];
            this.switchOnPdip = new Boolean[n3];
            this.sfBerLevel = new Attribute[n3];
            this.sdBerLevel = new Attribute[n3];
            this.switchState = new Attribute[n3];
            this.lastReadSwitchState = new Attribute[n3];
            this.workingActive = new boolean[n3];
            this.holdoffTimer = new String[n3];
            this.isRowEditable = new boolean[n3];
            this.cellDirty = new boolean[n3][];
            for (n = 0; n < n3; ++n) {
                this.cellDirty[n] = new boolean[9];
            }
            this.setModels(list.toArray(new IModel[0]));
            if (this.circuit instanceof Observable) {
                this.observableManager.addObservable((Observable)((Object)this.circuit));
            }
            this.numLines = n3;
            this.rowDirty = new boolean[this.numLines];
        } else {
            db.println("ConnectionModels is null!");
        }
    }

    private int getSecurityLevel() {
        List list = this.circuit.getCircuitNodes();
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
            return iNetCircuitNode.getNodeModel().getSecurityLevel().value();
        }
        return 1;
    }

    public static List getConnectionModels(INetCircuit iNetCircuit) {
        if (iNetCircuit == null) {
            if (db.on()) {
                db.println("getConnectionModels(): ckt is null!");
            }
            return new ArrayList();
        }
        List list = iNetCircuit.getCircuitNodes();
        ArrayList arrayList = new ArrayList(list.size());
        for (INetCircuitNode iNetCircuitNode : list) {
            if (!iNetCircuitNode.isUpsrSelector()) continue;
            try {
                arrayList.addAll(iNetCircuitNode.getUpsrConns());
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return arrayList;
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("CedUpsrTableModel: update from " + observable + "\t" + observable.getClass().toString() + ", arg= " + object);
        }
        if (object == ModelUpdateType.DELETED) {
            return;
        }
        if (observable instanceof INetCircuit) {
            if (db.on()) {
                db.println("update: circuit changed");
            }
            this.resetFromNetCircuitImpl();
        }
        if (this.circuit != null) {
            try {
                if (db.on()) {
                    db.println("update: calling refreshFromModel()");
                }
                this.refreshFromModel();
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("update: refreshFromModel() threw exception");
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        } else {
            db.println("circuit is null!");
        }
    }

    public int processBlockedEvent(Observable observable, Object object, int n) {
        if (observable.equals(this.circuit)) {
            if (db.on()) {
                db.println("processBlockedEvent: returning NEEDS_RESET");
            }
            return 2;
        }
        if (n == 0) {
            if (db.on()) {
                db.println("processBlockedEvent: returning NEEDS_REFRESH");
            }
            return 1;
        }
        if (db.on()) {
            db.println("processBlockedEvent: returning previous state: " + n);
        }
        return n;
    }

    public class UnableToSwitchException
    extends Exception {
        public UnableToSwitchException(String string) {
            super(string);
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

