/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CircuitDropInfo;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.CktInfo;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.ICircuitDropInfo;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.IXPLLayer2LineModel;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.OchncHelper;
import cerent.cms.model.SvlanCircuitHelper;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitEnd;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SvlanCircuitEnd;
import cerent.cms.ncp.VlanStpSanityCheckFailed;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.circuits.AbstractAdminStatePanel;
import cerent.cms.ui.circuits.AbstractCcdAttrsPane;
import cerent.cms.ui.circuits.AbstractUpsrCircuitDialog;
import cerent.cms.ui.circuits.AdminStatePanel;
import cerent.cms.ui.circuits.AutorangeInfo;
import cerent.cms.ui.circuits.Autoranger;
import cerent.cms.ui.circuits.CcdAttrsPane;
import cerent.cms.ui.circuits.CcdCircuitDesignPane;
import cerent.cms.ui.circuits.CcdConversionCktPane;
import cerent.cms.ui.circuits.CcdEndpointsPane;
import cerent.cms.ui.circuits.CcdLapAttrsPane;
import cerent.cms.ui.circuits.CcdLoPane;
import cerent.cms.ui.circuits.CcdOCHCCAttrsPane;
import cerent.cms.ui.circuits.CcdOCHNCAttrsPane;
import cerent.cms.ui.circuits.CcdOchAttrsPane;
import cerent.cms.ui.circuits.CcdOchRoutePane;
import cerent.cms.ui.circuits.CcdOchTrailAttrsPane;
import cerent.cms.ui.circuits.CcdOvcatEndpoints;
import cerent.cms.ui.circuits.CcdReviewEditPane;
import cerent.cms.ui.circuits.CcdRouteConstraintPane;
import cerent.cms.ui.circuits.CcdRoutePane;
import cerent.cms.ui.circuits.CcdSvlanAttrsPane;
import cerent.cms.ui.circuits.CcdSvlanRoutePane;
import cerent.cms.ui.circuits.CcdVcatAttrsPane;
import cerent.cms.ui.circuits.CcdVcatReviewEditPane;
import cerent.cms.ui.circuits.CcdVcatRouteConstraintPane;
import cerent.cms.ui.circuits.CcdVcatRoutePane;
import cerent.cms.ui.circuits.CcdVlanPane;
import cerent.cms.ui.circuits.CcdVttAttrsPane;
import cerent.cms.ui.circuits.CcdWizardInfo;
import cerent.cms.ui.circuits.CircuitCreationWizard;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.ICcdRoutePane;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.cms.ui.vlan.VlanStpDialog;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.AnnotatedException;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IPoDWDMUtility;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.WID;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.ProgressDialog;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import javax.swing.JOptionPane;
import org.omg.CORBA.BAD_PARAM;

public class CircuitCreationDialog
extends AbstractUpsrCircuitDialog
implements ProgressDialogControl {
    static final int REVERTIVE_TIME_DEFAULT = 300;
    public static final String UNSPECIFIED_NAME = "<auto-assigned>";
    public static final String PREF_AUTOROUTE = "autoRoute";
    private static final String PREF_TYPE = "type";
    private static final String PREF_SIZE = "size";
    private static final String PREF_MAXAUTORANGED_STS = "maxAutoRangedSts";
    private static final String PREF_MAXAUTORANGED_VT_1_5 = "maxAutoRangedVt1_5";
    private static final String PREF_MAXAUTORANGED_VT_2 = "maxAutoRangedVt2";
    private static final String PREF_MAXAUTORANGED_VC_HO = "maxAutoRangedVcHo";
    private static final String PREF_MAXAUTORANGED_VC_LO_VC3 = "maxAutoRangedVcLoVc3";
    private static final String PREF_MAXAUTORANGED_VC_LO_VC12 = "maxAutoRangedVcLoVc12";
    private static final String PREF_MAXAUTORANGED_VC_LO_VC11 = "maxAutoRangedVcLoVc11";
    static final String PREF_APPLY_DROP_PORTS = "applyDropPorts";
    private static final String PREF_BIDIR = "bidirectional";
    private static final String PREF_COUNT = "count";
    private static final String PREF_PATH_PROT = "pathProtection";
    private static final String PREF_DROP_PROT = "dropProtection";
    private static final String PREF_TL1 = "createTL1Like";
    public static final String VLANSTPVIOLATION_MSG = "The circuit VLAN list cannot be mapped to one spanning tree.\nYou can view the VLAN/Spanning Tree table or reassign VLANs";
    private int numDropPortsNotSet = 0;
    private StringBuffer dropPortsNotSet = new StringBuffer();
    private boolean stopDriver = false;
    private AutorangeInfo arInfo = null;

    public CircuitCreationDialog(CcdWizardInfo ccdWizardInfo, Frame frame, IModel iModel, boolean bl) {
        this(null, ccdWizardInfo, frame, bl, iModel);
    }

    public CircuitCreationDialog(CcdWizardInfo ccdWizardInfo, Frame frame, TabbedView tabbedView, IModel iModel, boolean bl) {
        this(null, ccdWizardInfo, frame, bl, iModel);
        this.setTabbedView(tabbedView);
    }

    public CircuitCreationDialog(CircuitCreationWizard circuitCreationWizard, CcdWizardInfo ccdWizardInfo, Frame frame, boolean bl, IModel iModel) {
        super(frame, "Circuit Creation", new WzDiagDebug("CircuitCreationDialog"), bl);
        this.wizard = circuitCreationWizard;
        this.wizardInfo = ccdWizardInfo;
        int n = 900;
        int n2 = 450;
        this.setSize(new Dimension(n, n2));
        this.createPanesAndSetCurrent();
        this.setLocationRelativeTo(frame);
    }

    protected void createPanesAndSetCurrent() {
        int n = CircuitType.UNDEFINED_TYPE;
        Preferences preferences = Preferences.instance();
        try {
            n = preferences.getInt("ctc.circuit.creation", PREF_TYPE, this.getCircuitType());
        }
        catch (BAD_PARAM bAD_PARAM) {
            this.db.severe("CORBA_BAD_PARAM detected while trying to retrieve circuit type info.");
            KDebug.printStackTrace((Throwable)bAD_PARAM);
        }
        if (this.wizardInfo != null) {
            n = this.wizardInfo.circuitType;
        }
        if (this.db.on()) {
            this.db.fine("determined ckt type to " + n);
        }
        if (n == 9) {
            this.wzPaneMap.put("Circuit Attributes", new CcdOCHNCAttrsPane(this, this.makeChildDebug("OCHNCAttrs"), "Circuit Attributes"));
        } else if (n == 14) {
            this.wzPaneMap.put("Circuit Attributes", new CcdOCHCCAttrsPane(this, this.makeChildDebug("OCHCCAttrs"), "Circuit Attributes"));
        } else if (n == 15) {
            this.wzPaneMap.put("Circuit Attributes", new CcdOchTrailAttrsPane(this, this.makeChildDebug("OCHTrailAttrs"), "Circuit Attributes"));
        } else if (n == 16) {
            this.wzPaneMap.put("Circuit Attributes", new CcdSvlanAttrsPane(this, this.makeChildDebug("SVLANAttrs"), "Circuit Attributes"));
        } else if (n == 3 || n == 6) {
            this.wzPaneMap.put("Circuit Attributes", new CcdVttAttrsPane(this, this.makeChildDebug("VttAttrs"), "Circuit Attributes"));
        } else if (n == 7 || n == 8) {
            this.wzPaneMap.put("Circuit Attributes", new CcdLapAttrsPane(this, this.makeChildDebug("LapAttrs"), "Circuit Attributes"));
        } else if (this.isVcatType(n)) {
            this.wzPaneMap.put("Circuit Attributes", new CcdVcatAttrsPane(this, this.makeChildDebug("VcatAttrs"), "Circuit Attributes"));
        } else {
            this.wzPaneMap.put("Circuit Attributes", new CcdAttrsPane(this, this.makeChildDebug("Attrs"), "Circuit Attributes"));
        }
        this.setCircuitType(n);
        if (this.isOchType() || this.isSVLANType()) {
            this.wzPaneMap.put("Source", new CcdEndpointsPane(this, this.makeChildDebug("Source"), "Source", "Source", false, false));
        } else {
            this.wzPaneMap.put("Source", new CcdEndpointsPane(this, this.makeChildDebug("Source"), "Source", "Source"));
        }
        if (this.isOchType() || this.isSVLANType()) {
            this.wzPaneMap.put("Destination", new CcdEndpointsPane(this, this.makeChildDebug("Dest"), "Destination", "Destination", false, false));
        } else {
            this.wzPaneMap.put("Destination", new CcdEndpointsPane(this, this.makeChildDebug("Dest"), "Destination", "Destination"));
        }
        this.wzPaneMap.put("Circuit VLAN Selection", new CcdVlanPane(this, this.makeChildDebug("Vlan"), "Circuit VLAN Selection"));
        if (this.isOchType()) {
            if (this.getCircuitType() == 15 || this.getCircuitType() == 14) {
                this.wzPaneMap.put("OCH Circuit Attributes Preferences", new CcdOchAttrsPane(this, this.makeChildDebug("OchAttrsPrefs"), "OCH Circuit Attributes Preferences"));
            }
            this.wzPaneMap.put("OCH Circuit Routing Preferences", new CcdOchRoutePane(this, this.makeChildDebug("OchRoutePrefs"), "OCH Circuit Routing Preferences", true));
            this.wzPaneMap.put("OCH Circuit Protect Routing Preferences", new CcdOchRoutePane(this, this.makeChildDebug("OchAltRoutePrefs"), "OCH Circuit Protect Routing Preferences", true));
        } else if (this.isSVLANType()) {
            this.wzPaneMap.put("SVLAN Circuit Routing Preview", new CcdSvlanRoutePane(this, this.makeChildDebug("SvlanRoutePrefs"), "SVLAN Circuit Routing Preview", true));
        } else {
            this.wzPaneMap.put("Circuit Routing Preferences", new CcdRoutePane(this, this.makeChildDebug("RoutePrefs"), "Circuit Routing Preferences"));
        }
        this.wzPaneMap.put("Conversion Circuit Constraints For Automatic Routing", new CcdConversionCktPane(this, this.makeChildDebug("XmRoute"), "Conversion Circuit Constraints For Automatic Routing"));
        this.wzPaneMap.put("VCat Circuit Routing Preferences", new CcdVcatRoutePane(this, this.makeChildDebug("VcatRoutePrefs"), "VCat Circuit Routing Preferences"));
        this.wzPaneMap.put(WZPANE_GET_LO, new CcdLoPane(this, this.makeChildDebug("Lo"), WZPANE_GET_LO));
        if (this.isVcatType(n)) {
            this.wzPaneMap.put("Circuit Constraints For Automatic Routing", new CcdVcatRouteConstraintPane(this, this.makeChildDebug("VcatRouteConstr"), "Circuit Constraints For Automatic Routing", true));
            this.wzPaneMap.put("Route Review/Edit", new CcdVcatReviewEditPane(this, this.makeChildDebug("VcatReviewEdit"), "Route Review/Edit", true));
        } else {
            this.wzPaneMap.put("Circuit Constraints For Automatic Routing", new CcdRouteConstraintPane(this, this.makeChildDebug("RouteConstr"), "Circuit Constraints For Automatic Routing", true));
            this.wzPaneMap.put("Route Review/Edit", new CcdReviewEditPane(this, this.makeChildDebug("ReviewEdit"), "Route Review/Edit", true));
        }
        this.wzPaneMap.put("Destinations", new CcdOvcatEndpoints(this, this.makeChildDebug("Destinations"), "Destinations", "Destinations"));
        if (this.db.on()) {
            this.db.fine("Successfully added all WzPanes to map.");
        }
        this.initializeLocalVariables();
        this.readCircuitPrefsAndGetCircuitDefaults();
        if (this.wizardInfo != null) {
            this.setPortGrouping(this.wizardInfo.portGrouping);
            this.autoRange = this.wizardInfo.autoRange;
            if (this.autoRange) {
                this.arInfo = new AutorangeInfo();
                this.arInfo.routePrefs = this.getRoutePrefs();
            }
            this.circuitCount = this.wizardInfo.numCircuits;
        }
        this.setCurrentPane("Circuit Attributes");
    }

    public void setApplyDropPorts(boolean bl) {
        this.applyDropPorts = bl;
    }

    public boolean getPortGrouping() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getPortGrouping();
        }
        this.db.severe("could not get port grouping... returning false");
        return false;
    }

    private void setPortGrouping(boolean bl) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setPortGrouping(bl);
        } else {
            this.db.severe("could not set port grouping.");
        }
    }

    public boolean getDropProtection() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getDropProtection();
        }
        this.db.severe("could not get drop protection... returning false");
        return false;
    }

    public boolean isCircuitTL1Compatible() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.isCircuitTL1Compatible();
        }
        this.db.severe("could not get if ckt is TL1 compat... returning false");
        return false;
    }

    private void setCircuitTL1Compatible(boolean bl) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setCircuitTL1Compatible(bl);
        } else {
            this.db.severe("could not set TL1 Compatibility.");
        }
    }

    public String getCircuitName() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getCircuitName();
        }
        this.db.severe("could not get ckt name... returning UNSPECIFIED_NAME");
        return UNSPECIFIED_NAME;
    }

    public int getCircuitType() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getCircuitType();
        }
        this.db.severe("could not get ckt type... returning UNDEFINED_TYPE");
        return CircuitType.UNDEFINED_TYPE;
    }

    private void setCircuitType(int n) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setCircuitType(n);
        } else {
            this.db.severe("could not set circuit type.");
        }
    }

    public int getCircuitSize() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getCircuitSize();
        }
        this.db.severe("could not get ckt size... returning UNDEFINED_SIZE");
        return CircuitSize.UNDEFINED_SIZE;
    }

    private void setCircuitSize(int n) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setCircuitSize(n);
        } else {
            this.db.severe("could not set circuit size.");
        }
    }

    public int getAdminState() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getAdminState();
        }
        this.db.severe("could not get admin state... returning IS_AINS");
        return 3;
    }

    public int getPortsState() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getPortsState();
        }
        this.db.severe("could not get ports state... returning IS_AINS");
        return 3;
    }

    public int getCircuitState() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getCircuitInfo().adminState();
        }
        this.db.severe("could not get circuit state... returning IS_AINS");
        return 3;
    }

    private void setAdminState(int n) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setAdminState(n);
        } else {
            this.db.severe("could not set admin state");
        }
    }

    public CircuitCreatInfo getCircuitInfo() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            return abstractCcdAttrsPane.getCircuitInfo();
        }
        this.db.severe("could not get circuit info... returning NULL");
        return null;
    }

    public int getVcatTxMembers() {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            if (abstractCcdAttrsPane instanceof CcdVcatAttrsPane) {
                return ((CcdVcatAttrsPane)abstractCcdAttrsPane).getVcatTxMembers();
            }
            this.db.severe("could not get vcat TX - not CcdVcatAttrs... returning 0");
            return 0;
        }
        this.db.severe("could not get vcat TX...  returning 0");
        return 0;
    }

    public void setCircuitName(String string) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setCircuitName(string);
        } else {
            this.db.severe("can't set circuit name " + string);
        }
    }

    public void setCircuitInfo(CircuitCreatInfo circuitCreatInfo) {
        AbstractCcdAttrsPane abstractCcdAttrsPane = this.getAttrsPane();
        if (abstractCcdAttrsPane != null) {
            abstractCcdAttrsPane.setCircuitInfo(circuitCreatInfo);
        } else {
            this.db.severe("can't set circuit info " + circuitCreatInfo);
        }
    }

    public void setSourceNode(INodeModel iNodeModel) {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            ccdEndpointsPane.setLastNode(iNodeModel);
        } else {
            this.db.severe("can't set sourcenode " + iNodeModel);
        }
    }

    public void setDestNode(INodeModel iNodeModel) {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        CcdOvcatEndpoints ccdOvcatEndpoints = (CcdOvcatEndpoints)this.wzPaneMap.get("Destinations");
        if (ccdEndpointsPane != null) {
            ccdEndpointsPane.setLastNode(iNodeModel);
        } else {
            this.db.severe("can't set destnode " + iNodeModel);
        }
        if (ccdOvcatEndpoints != null) {
            ccdOvcatEndpoints.setLastNode(iNodeModel);
        } else {
            this.db.severe("can't set destnode " + iNodeModel);
        }
    }

    public INodeModel getSourceNode() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            return ccdEndpointsPane.getNodeModel();
        }
        this.db.severe("could not get source node.. returning null");
        return null;
    }

    public INodeModel getAltSourceNode() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            return ccdEndpointsPane.getAltNodeModel();
        }
        this.db.severe("could not get alt source node.. returning null");
        return null;
    }

    public INodeModel getDestNode() {
        CcdEndpointsPane ccdEndpointsPane = null;
        ccdEndpointsPane = this.getCircuitInfo().isOVcat() ? (CcdEndpointsPane)this.wzPaneMap.get("Destinations") : (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        if (ccdEndpointsPane != null) {
            if (ccdEndpointsPane.getNodeModel() != null) {
                return ccdEndpointsPane.getNodeModel();
            }
            if (this.getCircuitInfo().type() == 16) {
                return this.getSourceNode();
            }
            this.db.severe("could not get dest node.. returning null");
            return null;
        }
        this.db.severe("could not get dest node.. returning null");
        return null;
    }

    public INodeModel getAltDestNode() {
        CcdEndpointsPane ccdEndpointsPane = null;
        ccdEndpointsPane = this.getCircuitInfo().isOVcat() ? (CcdEndpointsPane)this.wzPaneMap.get("Destinations") : (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        if (ccdEndpointsPane != null) {
            return ccdEndpointsPane.getAltNodeModel();
        }
        this.db.severe("could not get alt dest node.. returning null");
        return null;
    }

    public INetCircuitEnd getSource() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            return ccdEndpointsPane.getMainPanelEndpoint();
        }
        this.db.severe("could not get source... returning null");
        return null;
    }

    public INetCircuitEnd getAltSource() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            if (this.getCircuitInfo().type() == 9) {
                return ccdEndpointsPane.getMainPanelReverseEndpoint();
            }
            return ccdEndpointsPane.getAltPanelEndpoint();
        }
        this.db.severe("could not get alt source... returning null");
        return null;
    }

    public INetCircuitEnd getDest() {
        CcdEndpointsPane ccdEndpointsPane = null;
        ccdEndpointsPane = this.getCircuitInfo().isOVcat() ? (CcdEndpointsPane)this.wzPaneMap.get("Destinations") : (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        if (ccdEndpointsPane != null) {
            return ccdEndpointsPane.getMainPanelEndpoint();
        }
        this.db.severe("could not get dest... returning null");
        return null;
    }

    public INetCircuitEnd getProtDest() {
        CcdEndpointsPane ccdEndpointsPane = null;
        ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        if (ccdEndpointsPane != null) {
            return ccdEndpointsPane.getMainPanelProtEndpoint();
        }
        this.db.severe("could not get dest... returning null");
        return null;
    }

    public INetCircuitEnd getAltDest() {
        CcdEndpointsPane ccdEndpointsPane = this.getCircuitInfo().isOVcat() ? (CcdEndpointsPane)this.wzPaneMap.get("Destinations") : (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        if (ccdEndpointsPane != null) {
            if (this.getCircuitInfo().type() == 9) {
                return ccdEndpointsPane.getMainPanelReverseEndpoint();
            }
            return ccdEndpointsPane.getAltPanelEndpoint();
        }
        this.db.severe("could not get alt dest... returning null");
        return null;
    }

    public INetCircuitEnd getPgEnd() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            return (INetCircuitEnd)ccdEndpointsPane.getEndpoints().get(0);
        }
        this.db.severe("could not get pg end... returning null");
        return null;
    }

    public INetCircuitEnd getDestPgEnd() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        if (ccdEndpointsPane != null) {
            return (INetCircuitEnd)ccdEndpointsPane.getEndpoints().get(0);
        }
        this.db.severe("could not get dest pg end... returning null");
        return null;
    }

    protected WzPane getRoutePane() {
        if (this.isVcatType()) {
            return (WzPane)this.wzPaneMap.get("VCat Circuit Routing Preferences");
        }
        if (this.isOchType()) {
            return (WzPane)this.wzPaneMap.get("OCH Circuit Routing Preferences");
        }
        if (this.isSVLANType()) {
            return (WzPane)this.wzPaneMap.get("SVLAN Circuit Routing Preview");
        }
        return (WzPane)this.wzPaneMap.get("Circuit Routing Preferences");
    }

    public INetCircuitEnd[] getXmCircuitEnds() {
        CcdConversionCktPane ccdConversionCktPane = (CcdConversionCktPane)this.wzPaneMap.get("Conversion Circuit Constraints For Automatic Routing");
        return ccdConversionCktPane.getMainPanel() != null ? ccdConversionCktPane.getMainPanel().getXmCircuitEnds() : null;
    }

    public RoutePrefs getRoutePrefs() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            return ((ICcdRoutePane)((Object)wzPane)).getRoutePrefs();
        }
        this.db.severe("could not get route prefs... returning null");
        return null;
    }

    public void setRoutePrefs(RoutePrefs routePrefs) {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            ((ICcdRoutePane)((Object)wzPane)).setRoutePrefs(routePrefs);
        } else {
            this.db.severe("Could not set route prefs " + routePrefs);
        }
    }

    public boolean isPca() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            return ((ICcdRoutePane)((Object)wzPane)).isPca();
        }
        this.db.severe("could not get pca... returning false");
        return false;
    }

    public void setPca(boolean bl) {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            ((ICcdRoutePane)((Object)wzPane)).setPca(bl);
        } else {
            this.db.severe("could not set PCA!");
        }
    }

    public boolean isPathProt() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            return ((ICcdRoutePane)((Object)wzPane)).isPathProt();
        }
        this.db.severe("could not get path prot... returning false");
        return false;
    }

    public void setPathProt(boolean bl) {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            ((ICcdRoutePane)((Object)wzPane)).setPathProt(bl);
        } else {
            this.db.severe("could not set path prot with " + bl);
        }
    }

    public boolean isRrbc() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            return ((ICcdRoutePane)((Object)wzPane)).isRrbc();
        }
        this.db.severe("could not get isRrbc... returning false");
        return false;
    }

    public boolean isUrn() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            return ((ICcdRoutePane)((Object)wzPane)).isUrn();
        }
        this.db.severe("could not get isUrn... returning false");
        return false;
    }

    public boolean isAutoRoute() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            return ((ICcdRoutePane)((Object)wzPane)).isAutoRoute();
        }
        this.db.severe("could not get autoroute... returning false");
        return false;
    }

    public ArrayList getVcatMemberPrefs() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null && wzPane instanceof CcdVcatRoutePane) {
            return ((CcdVcatRoutePane)wzPane).getVcatMemberPrefs();
        }
        this.db.severe("could not get vcat member prefs... returning null");
        return null;
    }

    public boolean isVcatCommonFiberRouting() {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            if (this.isVcatType()) {
                return ((CcdVcatRoutePane)wzPane).isVcatCommonFiberRouting();
            }
            if (this.db.on()) {
                this.db.println("asked for vcat common fiber routing for non-vcat");
            }
            return false;
        }
        this.db.severe("could not get vcat common fiber routing... returning false");
        return false;
    }

    public void setVcatCommonFiberRouting(boolean bl) {
        WzPane wzPane = this.getRoutePane();
        if (wzPane != null) {
            if (this.isVcatType()) {
                ((CcdVcatRoutePane)wzPane).setVcatCommonFiberRouting(bl);
            } else if (this.db.on()) {
                this.db.println("asked to set vcat common fiber routing for non-vcat");
            }
        } else {
            this.db.severe("could not set vcat common fiber routing!");
        }
    }

    protected void backFromEmptyStack() throws Exception {
        if (this.wizard != null) {
            this.close();
            this.dispose();
            this.wizard.showAgain();
        } else {
            super.backFromEmptyStack();
        }
    }

    protected void localValidation(int n) {
        boolean bl = this.currentWzPane.getName().equals("Source");
        if (bl && n == 0) {
            return;
        }
        if (this.isInvalidCircuitState()) {
            this.terminate();
        }
    }

    private void initializeLocalVariables() {
        this.stopDriver = false;
        this.circuitNumber = 1;
        this.circuitCount = 1;
        this.autoRange = false;
        this.numDropPortsNotSet = 0;
        this.dropPortsNotSet = new StringBuffer("The circuit state has not been applied to at least one drop on the following circuits: \n");
    }

    protected void readCircuitPrefs() {
        ICircuitType iCircuitType;
        this.db.info("reading circuit preferences");
        Preferences preferences = Preferences.instance();
        try {
            this.setCircuitType(preferences.getInt("ctc.circuit.creation", PREF_TYPE, this.getCircuitType()));
        }
        catch (BAD_PARAM bAD_PARAM) {
            this.db.severe("CORBA_BAD_PARAM detected while trying to retrieve circuit type info.");
            KDebug.printStackTrace((Throwable)bAD_PARAM);
        }
        if (this.wizardInfo != null) {
            this.setCircuitType(this.wizardInfo.circuitType);
        }
        if (this.db.isInfoEnabled()) {
            this.db.info("preferred  circuit type is " + this.getCircuitType());
        }
        if ((iCircuitType = CircuitType.getCircuitType((int)this.getCircuitType())).isSVLANType()) {
            this.setCircuitSize(CircuitSize.SIZE_NULL.value());
        } else {
            this.setCircuitSize(CircuitSize.UNDEFINED_SIZE);
            try {
                this.setCircuitSize(preferences.getInt("ctc.circuit.creation", PREF_SIZE, this.getCircuitSize()));
            }
            catch (BAD_PARAM bAD_PARAM) {
                this.db.severe("CORBA_BAD_PARAM detected while trying to retrieve circuit size info.");
                KDebug.printStackTrace((Throwable)bAD_PARAM);
            }
        }
        if (this.db.isInfoEnabled()) {
            this.db.info("preferred  circuit size is " + this.getCircuitSize());
        }
        this.applyDropPorts = iCircuitType.isOchncType() ? false : (this.applyDropPortsPref = preferences.getBoolean("ctc.circuit.creation", PREF_APPLY_DROP_PORTS, false));
        if (this.db.isInfoEnabled()) {
            this.db.info("preferred  apply drop ports is " + this.applyDropPorts);
        }
        this.maxAutoRangedSts = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_STS, 12);
        this.maxAutoRangedVt1_5 = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VT_1_5, 28);
        this.maxAutoRangedVt2 = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VT_2, 21);
        this.maxAutoRangedVcHo = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_HO, 5);
        this.maxAutoRangedVcLoVc3 = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC3, 3);
        this.maxAutoRangedVcLoVc11 = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC11, 84);
        this.maxAutoRangedVcLoVc12 = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC12, 63);
        this.maxAutoRangedVcLoVc11 = preferences.getInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC11, 84);
        this.db.info("done reading circuit preferences");
    }

    private void getLikeTl1Default() {
        String string = "FALSE";
        string = this.getDefaultValue("CTC.circuits.CreateLikeTL1", string);
        this.setCircuitTL1Compatible(string.equalsIgnoreCase("TRUE"));
        this.db.info("Default createLikeTl1 is " + string);
    }

    private void getCircuitStateDefault() {
        int n;
        block5: {
            n = 3;
            ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitType());
            if (!iCircuitType.isOchncType()) {
                try {
                    n = Integer.parseInt(this.getDefaultValue("NODE.circuits.State", String.valueOf(n)));
                }
                catch (Exception exception) {
                    this.db.info("Can't retrieve NODE.circuits.State: " + exception.getMessage());
                    try {
                        n = Integer.parseInt(this.getDefaultValue("CTC.circuits.State", String.valueOf(n)));
                    }
                    catch (Exception exception2) {
                        if (!this.db.isSevereEnabled()) break block5;
                        this.db.severe("Can't retrieve CTC.circuits.State: " + exception2.getMessage());
                        KDebug.printStackTrace((Throwable)exception2);
                    }
                }
            }
        }
        this.setAdminState(n);
        this.db.info("Default circuit state is " + n);
    }

    protected void getCircuitDefaults() {
        this.db.info("getting circuit defaults");
        this.getLikeTl1Default();
        this.getCircuitStateDefault();
        this.getUpsrGoReturnRoutingDefault();
        this.getUpsrReversionDefaults();
        this.getUpsrSberDefaults();
        this.getUpsrSwitchOnPDIPDefaults();
        this.db.info("done getting circuit defaults");
    }

    protected void readCircuitPrefsAndGetCircuitDefaults() {
        this.readCircuitPrefs();
        this.getCircuitDefaults();
    }

    void writeCircuitPrefs() {
        Preferences preferences = Preferences.instance();
        preferences.setInt("ctc.circuit.creation", PREF_TYPE, this.getCircuitInfo().type());
        preferences.setInt("ctc.circuit.creation", PREF_SIZE, this.getCircuitInfo().size());
        preferences.setBoolean("ctc.circuit.creation", PREF_APPLY_DROP_PORTS, this.applyDropPortsPref);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_STS, this.maxAutoRangedSts);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VT_1_5, this.maxAutoRangedVt1_5);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VT_2, this.maxAutoRangedVt2);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_HO, this.maxAutoRangedVcHo);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC3, this.maxAutoRangedVcLoVc3);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC11, this.maxAutoRangedVcLoVc11);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC12, this.maxAutoRangedVcLoVc12);
        preferences.setInt("ctc.circuit.creation", PREF_MAXAUTORANGED_VC_LO_VC11, this.maxAutoRangedVcLoVc11);
        preferences.removeProperty("ctc.circuit.creation", PREF_BIDIR);
        preferences.removeProperty("ctc.circuit.creation", PREF_COUNT);
        preferences.removeProperty("ctc.circuit.creation", PREF_PATH_PROT);
        preferences.removeProperty("ctc.circuit.creation", PREF_DROP_PROT);
        preferences.removeProperty("ctc.circuit.creation", PREF_TL1);
        preferences.removeProperty("ctc.circuit.creation", "upsrGoReturnRouting");
        preferences.removeProperty("ctc.circuit.creation", "revertive");
        preferences.removeProperty("ctc.circuit.creation", "revertTime");
        try {
            preferences.store();
        }
        catch (FileNotFoundException fileNotFoundException) {
            KDebug.printStackTrace((Throwable)fileNotFoundException);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CANT_SAVE_CKT_PREFS_PARAM_1, (Object)"File not found.");
        }
        catch (IOException iOException) {
            KDebug.printStackTrace((Throwable)iOException);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CANT_SAVE_CKT_PREFS_PARAM_1, (Object)"I/O error.");
        }
    }

    String getCircuitModdedName() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getCircuitName();
        boolean bl = string.length() > 0;
        stringBuffer.append(bl ? string : UNSPECIFIED_NAME);
        if (this.circuitCount > 1) {
            if (bl) {
                stringBuffer.append("_");
                stringBuffer.append(CircuitMapUtil.circuitSuffix(this.circuitNumber));
            }
            stringBuffer.append(" (" + this.circuitNumber + " of " + this.circuitCount + ")");
        }
        return stringBuffer.toString();
    }

    protected EID getNoRouteEmcErrorId() {
        return NEMC.EID_CKT_CREATE_ROUTE_ERROR;
    }

    public void createCircuit() throws Exception {
        this.destroyCircuit();
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfo().type());
        boolean bl = false;
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            bl = ccdEndpointsPane.isEtherGroup();
        }
        if (iCircuitType.isOchncType()) {
            INetCircuitEnd iNetCircuitEnd = null;
            if (this.db.on) {
                this.db.println("createCircuit: OCHNC circuit");
            }
            if ((iNetCircuitEnd = this.getOchncEndPoint(this.getCircuitInfo().cktOptChannel(), this.getSource().getNodeModel(), this.getSource().getEntityIndex())) == null) {
                throw new Exception("The selected optical channel is not available.");
            }
            this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), iNetCircuitEnd);
        } else if (iCircuitType.isSVLANType()) {
            INetCircuitEnd iNetCircuitEnd = null;
            if (this.db.on) {
                this.db.println("createCircuit: SVLAN circuit");
            }
            iNetCircuitEnd = this.getSvlanEndPoint(this.getCircuitInfo().svlan(), this.getSource().getNodeModel(), this.getSource().getEntityIndex());
            this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), iNetCircuitEnd);
        } else if (iCircuitType.isOchccCircuitType()) {
            if (this.getSource().getEntityModel() instanceof ITdmPortModel) {
                if (this.db.on) {
                    this.db.println("createCircuit: OchTrail Circuit using ITU-T Line card");
                }
                int n = this.getSourceNode().getNodeId();
                INetElement iNetElement = Network.instance().findNetElem(n);
                this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), iNetElement);
            } else {
                if (this.db.on) {
                    this.db.println("createCircuit: OchTrail Circuit");
                }
                this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), this.getSource());
            }
        } else if (iCircuitType.isOchTrailTunnelCircuitType()) {
            int n = this.getSourceNode().getNodeId();
            INetElement iNetElement = Network.instance().findNetElem(n);
            this.getCircuitInfo().setSrcTrkPort(this.getSource().getEntityIndex());
            this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), iNetElement);
        } else if (iCircuitType.isTunnelCircuitType() || bl) {
            if (this.db.on) {
                this.db.println("createCircuit: VT tunnel or Ethergroup circuit");
            }
            int n = this.getSourceNode().getNodeId();
            INetElement iNetElement = Network.instance().findNetElem(n);
            this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), iNetElement);
        } else if (this.getAltSource() != null) {
            if (this.db.on) {
                this.db.println("createCircuit: V-UPSR (double) source");
            }
            this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), this.getSource(), this.getAltSource());
        } else {
            if (this.db.on) {
                this.db.println("createCircuit: single source");
            }
            this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), this.getSource());
        }
        if (this.ckt == null) {
            throw new Exception("A new circuit could not be created.");
        }
    }

    protected INetCircuitEnd getOchncEndPoint(int n, INodeModel iNodeModel, int n2) {
        OchncCircuitEnd ochncCircuitEnd = null;
        ochncCircuitEnd = new OchncCircuitEnd(n);
        ochncCircuitEnd.setNodeModel(iNodeModel);
        ochncCircuitEnd.setEntityIndex(n2);
        return ochncCircuitEnd;
    }

    protected INetCircuitEnd getSvlanEndPoint(short s, INodeModel iNodeModel, int n) {
        SvlanCircuitEnd svlanCircuitEnd = null;
        svlanCircuitEnd = new SvlanCircuitEnd(s);
        svlanCircuitEnd.setNodeModel(iNodeModel);
        svlanCircuitEnd.setEntityIndex(n);
        return svlanCircuitEnd;
    }

    protected void setQinQInfo() throws CircuitProvError {
        IXPLLayer2LineModel iXPLLayer2LineModel;
        IEntityModel iEntityModel;
        INetCircuitEnd iNetCircuitEnd;
        if (this.db.on) {
            this.db.println("setQinQInfo: additional setting for SVLAN circuit");
        }
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        CcdEndpointsPane ccdEndpointsPane2 = (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        CircuitCreatInfo circuitCreatInfo = this.getCircuitInfo();
        try {
            iNetCircuitEnd = ccdEndpointsPane.getMainPanelEndpoint();
            if (iNetCircuitEnd != null) {
                iEntityModel = iNetCircuitEnd.getEntityModel();
                iXPLLayer2LineModel = SvlanCircuitHelper.getL2Interface(iNetCircuitEnd.getNodeModel(), iEntityModel.getEntityIndex());
                if (iXPLLayer2LineModel != null && !iXPLLayer2LineModel.isNNI()) {
                    if (this.db.on()) {
                        this.db.println("Setting QinQ info on SRC port: " + Integer.toHexString(iEntityModel.getEntityIndex()));
                    }
                    iXPLLayer2LineModel.setQinQInfoFromNet(circuitCreatInfo.getSrcQinQInfo());
                }
            }
        }
        catch (Exception exception) {
            if (this.db.on()) {
                this.db.println("Caught exception during SRC QinQ setting:" + exception);
            }
            throw new CircuitProvError("QinQ setting failure on source circuit port.\n" + exception.getMessage());
        }
        try {
            if (!circuitCreatInfo.isProtected() && (iNetCircuitEnd = ccdEndpointsPane2.getMainPanelEndpoint()) != null) {
                iEntityModel = iNetCircuitEnd.getEntityModel();
                iXPLLayer2LineModel = SvlanCircuitHelper.getL2Interface(iNetCircuitEnd.getNodeModel(), iEntityModel.getEntityIndex());
                if (iXPLLayer2LineModel != null && !iXPLLayer2LineModel.isNNI()) {
                    if (this.db.on()) {
                        this.db.println("Setting QinQ info on DST port: " + Integer.toHexString(iEntityModel.getEntityIndex()));
                    }
                    iXPLLayer2LineModel.setQinQInfoFromNet(circuitCreatInfo.getDstQinQInfo());
                }
            }
        }
        catch (Exception exception) {
            if (this.db.on()) {
                this.db.println("Caught exception during DST QinQ setting:" + exception);
                this.db.println("Undo QinQ settings on SRC");
            }
            this.cleanupQinQSettings();
            throw new CircuitProvError("QinQ setting failure on destination circuit port.\n" + exception.getMessage());
        }
    }

    private void cleanupQinQSettings() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        CcdEndpointsPane ccdEndpointsPane2 = (CcdEndpointsPane)this.wzPaneMap.get("Destination");
        if (this.getCircuitInfo() != null) {
            try {
                if (this.db.on) {
                    this.db.println("cleanupQinQSettings(): calling clean-up on src/dst pane");
                }
                ccdEndpointsPane.cleanUpQinQ(this.getCircuitInfo().svlan());
                ccdEndpointsPane2.cleanUpQinQ(this.getCircuitInfo().svlan());
            }
            catch (Exception exception) {
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void handleCancel() {
        CcdOchAttrsPane ccdOchAttrsPane;
        if (this.db.on) {
            this.db.println("handleCancel: cleaning up");
        }
        if ((this.currentWzPane.getName() == "OCH Circuit Routing Preferences" || this.currentWzPane.getName() == "OCH Circuit Protect Routing Preferences") && (ccdOchAttrsPane = (CcdOchAttrsPane)this.wzPaneMap.get("OCH Circuit Attributes Preferences")) != null) {
            ccdOchAttrsPane.handleCancel();
        }
        if (this.getCircuitType() == 16) {
            if (this.db.on) {
                this.db.println("handleCancel: additional clean-up for SVLAN circuit");
            }
            this.cleanupQinQSettings();
        }
        this.destroyCircuit();
        this.destroyRelatedCircuits();
        this.close();
        AdminStatePanel.showDropPortsFailure(this, this.getAdminState(), this.numDropPortsNotSet, this.dropPortsNotSet);
    }

    private void close() {
        CcdEndpointsPane ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Source");
        if (ccdEndpointsPane != null) {
            ccdEndpointsPane.close();
        }
        if ((ccdEndpointsPane = this.getCircuitInfo() != null && this.getCircuitInfo().isOVcat() ? (CcdEndpointsPane)this.wzPaneMap.get("Destinations") : (CcdEndpointsPane)this.wzPaneMap.get("Destination")) != null) {
            ccdEndpointsPane.close();
        }
    }

    public void destroyCircuit() {
        this.destinationAdded = false;
        if (this.ckt != null) {
            try {
                this.ckt.destroyCircuit();
                this.ckt = null;
                if (this.db.on) {
                    this.db.println("destroyCircuit: ckt.destroy() succeeded");
                }
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                this.ckt = null;
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CIRCUIT_DESTROY_FAILED);
            }
        }
    }

    private void addDestinationIfDropIncremented(Exception exception, int n) {
        this.db.println("Checking for a remant drop, because of this exception:");
        KDebug.printStackTrace((Throwable)exception);
        int n2 = this.ckt.getDrops().size();
        if (this.getCircuitInfo().isOVcat()) {
            n2 = this.calcNumDropsForOpenVcat();
        }
        if (n2 > n) {
            if (this.db.on()) {
                this.db.println("Error in addDestination(), but a remnant drop was added, so mark 'destinationAdded' as true.");
            }
            this.destinationAdded = true;
        }
    }

    private int calcNumDropsForOpenVcat() {
        int n = 0;
        Iterator iterator = ((NetVcatCircuit)this.ckt).getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            n += ((INetCircuit)iterator.next()).getDrops().size();
        }
        return n;
    }

    protected void addDestination(boolean bl) throws Exception {
        if (this.destinationAdded) {
            if (this.db.on) {
                this.db.println("addDestination: destination already added");
            }
            return;
        }
        if (this.ckt == null || this.isInvalidCircuitState()) {
            this.cancel(false);
            throw new Exception("The circuit creation cannot proceed due to changes in\nthe network, which affected the circuit(s) being created.\n\nThe dialog box was closed.  Please try again.");
        }
        int n = this.ckt.getDrops().size();
        if (this.getCircuitInfo().isOVcat()) {
            n = this.calcNumDropsForOpenVcat();
        }
        String string = "???";
        if (this.ckt.getCircuitTypeObj().isLoCircuitType() || this.ckt.getCircuitTypeObj().isHoCircuitType() || this.ckt.getCircuitTypeObj().isVcatCircuitType()) {
            String string2 = "addDestination";
            try {
                if (this.isAutoRoute() && bl) {
                    string = "route";
                    RoutePrefs routePrefs = this.getRoutePrefs();
                    routePrefs.setcktSrcEntityIndex(this.getSource().getEntityIndex());
                    routePrefs.setcktDstEntityIndex(this.getDest().getEntityIndex());
                    if (!this.getCircuitInfo().isOVcat()) {
                        if (this.getAltDest() != null) {
                            this.destDebug(string2, string + "/AltDest");
                            this.ckt.routeDrop(this.getDest(), this.getAltDest(), routePrefs);
                        } else {
                            this.destDebug(string2, string + "/Dest");
                            this.ckt.routeDrop(this.getDest(), routePrefs);
                        }
                    } else if (this.areSecDropsPresent()) {
                        routePrefs.setOvcatDrops(this.getDestList());
                        routePrefs.setOVcatAltDrops(this.getAltDestList());
                        this.ckt.routeDrop(this.getDestList(), this.getAltDestList(), routePrefs);
                    } else {
                        routePrefs.setOvcatDrops(this.getDestList());
                        this.ckt.routeDrop(this.getDestList(), routePrefs);
                    }
                } else {
                    string = "add";
                    this.destDebug(string2, string + "/Dest");
                    if (this.getCircuitInfo().isOVcat()) {
                        RoutePrefs routePrefs = this.getRoutePrefs();
                        routePrefs.setOvcatDrops(this.getDestList());
                        this.ckt.addOpenVcatDrops(this.getDestList(), routePrefs);
                        this.destDebug(string2, string + "/Dest");
                        if (this.areSecDropsPresent()) {
                            routePrefs.setOVcatAltDrops(this.getAltDestList());
                            this.ckt.addOpenVcatDrops(this.getAltDestList(), routePrefs);
                        }
                    } else {
                        this.ckt.addDrop(this.getDest(), this.getRoutePrefs());
                        if (this.getAltDest() != null) {
                            this.destDebug(string2, string + "/AltDest");
                            this.ckt.addDrop(this.getAltDest(), this.getRoutePrefs());
                        }
                    }
                }
                this.destinationAdded = true;
            }
            catch (Exception exception) {
                this.db.println("Circuit adter error is caught....");
                this.ckt.prettyPrint(this.db);
                this.addDestinationIfDropIncremented(exception, n);
                throw new AnnotatedException("An error occurred while trying to  " + string + " the drop.", exception);
            }
            if (this.db.on) {
                this.db.println("addDestination: ckt." + string + "Drop(destEnd, routePrefs) succeeded");
            }
        } else if (this.ckt.getCircuitTypeObj().isEthernetCircuitType() || this.ckt.getCircuitTypeObj().isTunnelCircuitType() || this.ckt.getCircuitTypeObj().isLAPCircuitType()) {
            if (this.getSourceNode() == this.getDestNode()) {
                return;
            }
            int n2 = this.getDestNode().getNodeId();
            INetElement iNetElement = Network.instance().findNetElem(n2);
            if (this.isAutoRoute() && bl) {
                string = "route";
                if (this.getAltDestNode() == null) {
                    this.ckt.routeNetElement(iNetElement, this.getRoutePrefs());
                } else {
                    INetElement iNetElement2 = Network.instance().findNetElem(this.getAltDestNode().getNodeId());
                    if (this.db.on()) {
                        this.db.println("addDestination:  altNe = " + iNetElement2.prettyString());
                    }
                    this.ckt.routeNetElement(iNetElement, iNetElement2, this.getRoutePrefs());
                }
            } else {
                string = "add";
                this.ckt.addNetElement(iNetElement, this.getRoutePrefs());
                if (this.getAltDestNode() != null) {
                    INetElement iNetElement3 = Network.instance().findNetElem(this.getAltDestNode().getNodeId());
                    if (this.db.on()) {
                        this.db.println("addDestination:  altNe = " + iNetElement3.prettyString());
                    }
                    if (iNetElement.getNodeId() != iNetElement3.getNodeId()) {
                        this.ckt.addNetElement(iNetElement3, this.getRoutePrefs());
                    }
                }
            }
            this.destinationAdded = true;
            if (this.db.on) {
                this.db.println("addDestination: ckt." + string + "NetElement(ne) succeeded");
            }
        } else if (this.ckt.getCircuitTypeObj().isOchncType()) {
            if (this.getCircuitInfo().singleNodeOchnc()) {
                this.addDestinationToDCNOchnc();
            } else {
                this.addDestinationToOchnc();
            }
        } else if (this.ckt.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            this.addDestinationToOchTrail();
        } else if (this.ckt.getCircuitTypeObj().isOchccCircuitType()) {
            this.addDestinationToOchcc();
        } else if (this.ckt.getCircuitTypeObj().isSVLANType()) {
            this.addDestinationToSvlan();
        } else {
            throw new Exception("An error occurred while adding the destination.  The circuit type was unexpected.");
        }
    }

    void addDestinationToOchnc() throws Exception {
        int n = this.ckt.getDrops().size();
        int n2 = this.getCircuitInfo().cktOptChannel();
        RoutePrefs routePrefs = this.getRoutePrefs();
        if (!this.ckt.isBidirectional()) {
            try {
                INetCircuitEnd iNetCircuitEnd = this.getOchncEndPoint(n2, this.getDest().getNodeModel(), this.getDest().getEntityIndex());
                int n3 = this.getSourceNode().getNodeId();
                INetElement iNetElement = Network.instance().findNetElem(n3);
                INetCircuitEnd iNetCircuitEnd2 = this.getOchncEndPoint(n2, this.getSource().getNodeModel(), this.getSource().getEntityIndex());
                int n4 = iNetCircuitEnd2.getEntityIndex();
                int n5 = iNetCircuitEnd.getEntityIndex();
                if (routePrefs == null) {
                    routePrefs = RoutePrefs.getOchncRoutePrefs(this.getCircuitInfo().cktOptChannel(), iNetElement, n4, n5);
                    this.setRoutePrefs(routePrefs);
                } else {
                    routePrefs.setcktOptChannel(this.getCircuitInfo().cktOptChannel());
                    routePrefs.setSrc(iNetElement);
                    routePrefs.setcktSrcEntityIndex(n4);
                    routePrefs.setcktDstEntityIndex(n5);
                }
                if (this.getCircuitInfo().singleNodeOchnc()) {
                    this.ckt.addDrop(iNetCircuitEnd, routePrefs);
                } else {
                    this.ckt.routeDrop(iNetCircuitEnd, routePrefs);
                }
                this.destinationAdded = true;
            }
            catch (Exception exception) {
                this.addDestinationIfDropIncremented(exception, n);
                throw new AnnotatedException("The drop could not be added and routed.", exception);
            }
            if (this.db.on) {
                this.db.println("addDestination: OCHNC uni ckt, add and route Drop succeeded");
            }
        } else {
            INetCircuitEnd iNetCircuitEnd;
            INetCircuitEnd iNetCircuitEnd3;
            this.destroyCircuit();
            INetCircuitEnd iNetCircuitEnd4 = this.getOchncEndPoint(n2, this.getSource().getNodeModel(), this.getSource().getEntityIndex());
            if (iNetCircuitEnd4 == null) {
                throw new Exception("The selected optical channel cannot be used as the primary source endpoint.");
            }
            if (this.db.on) {
                this.db.println("Primary SRC endPoint: " + iNetCircuitEnd4.getEntityIndex());
            }
            if ((iNetCircuitEnd3 = this.getOchncEndPoint(n2, this.getAltDest().getNodeModel(), this.getAltDest().getEntityIndex())) == null) {
                throw new Exception("The selected optical channel cannot be used as the secondary source endpoint.");
            }
            if (this.db.on) {
                this.db.println("Secondary SRC endPoint: " + iNetCircuitEnd3.getEntityIndex());
            }
            this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), iNetCircuitEnd4, iNetCircuitEnd3);
            INetCircuitEnd iNetCircuitEnd5 = this.getOchncEndPoint(n2, this.getDest().getNodeModel(), this.getDest().getEntityIndex());
            if (iNetCircuitEnd5 == null) {
                throw new Exception("The selected optical channel cannot be used as the primary destination endpoint.");
            }
            if (this.db.on) {
                this.db.println("Primary DST endPoint: " + iNetCircuitEnd5.getEntityIndex());
            }
            if ((iNetCircuitEnd = this.getOchncEndPoint(n2, this.getAltSource().getNodeModel(), this.getAltSource().getEntityIndex())) == null) {
                throw new Exception("The selected optical channel cannot be used as the secondary destination endpoint.");
            }
            if (this.db.on) {
                this.db.println("Secondary DST endPoint: " + iNetCircuitEnd.getEntityIndex());
            }
            int n6 = this.getSourceNode().getNodeId();
            INetElement iNetElement = Network.instance().findNetElem(n6);
            if (routePrefs == null) {
                routePrefs = RoutePrefs.getOchncRoutePrefs(n2, iNetElement, iNetCircuitEnd4.getEntityIndex(), iNetCircuitEnd5.getEntityIndex(), iNetCircuitEnd3.getEntityIndex(), iNetCircuitEnd.getEntityIndex());
                if (this.getCircuitInfo().isProtected()) {
                    routePrefs.setPathProt(1);
                }
                this.setRoutePrefs(routePrefs);
            } else {
                routePrefs.setcktOptChannel(this.getCircuitInfo().cktOptChannel());
                routePrefs.setSrc(iNetElement);
                routePrefs.setcktSrcEntityIndex(iNetCircuitEnd4.getEntityIndex());
                routePrefs.setcktDstEntityIndex(iNetCircuitEnd5.getEntityIndex());
                routePrefs.setcktSecSrcEntityIndex(iNetCircuitEnd3.getEntityIndex());
                routePrefs.setcktSecDstEntityIndex(iNetCircuitEnd.getEntityIndex());
            }
            try {
                this.ckt.routeDrop(iNetCircuitEnd5, iNetCircuitEnd, routePrefs);
                this.destinationAdded = true;
            }
            catch (Exception exception) {
                this.addDestinationIfDropIncremented(exception, n);
                throw new AnnotatedException("The drops could not be added and routed.", exception);
            }
            if (this.db.on) {
                this.db.println("addDestination: OCHNC bidi ckt, add and route Drops succeeded");
            }
        }
    }

    void addDestinationToSvlan() throws Exception {
        int n = this.ckt.getDrops().size();
        short s = this.getCircuitInfo().svlan();
        RoutePrefs routePrefs = this.getRoutePrefs();
        try {
            INetCircuitEnd iNetCircuitEnd;
            if (this.getCircuitInfo().isProtected()) {
                if (this.db.on) {
                    this.db.println("addDestination: SVLAN Protected ckt. SRC = DST");
                }
                iNetCircuitEnd = this.getSvlanEndPoint(s, this.getSource().getNodeModel(), this.getSource().getEntityIndex());
            } else {
                iNetCircuitEnd = this.getSvlanEndPoint(s, this.getDest().getNodeModel(), this.getDest().getEntityIndex());
            }
            int n2 = this.getSourceNode().getNodeId();
            INetElement iNetElement = Network.instance().findNetElem(n2);
            INetCircuitEnd iNetCircuitEnd2 = this.getSvlanEndPoint(s, this.getSource().getNodeModel(), this.getSource().getEntityIndex());
            int n3 = iNetCircuitEnd2.getEntityIndex();
            int n4 = iNetCircuitEnd.getEntityIndex();
            if (routePrefs == null) {
                routePrefs = new RoutePrefs();
                routePrefs.setSvlan(this.getCircuitInfo().svlan());
                routePrefs.setSrc(iNetElement);
                routePrefs.setDst(this.getDest().getNetElement());
                routePrefs.setcktSrcEntityIndex(n3);
                routePrefs.setcktDstEntityIndex(n4);
                if (this.getCircuitInfo().isProtected()) {
                    routePrefs.setPathProt(1);
                }
                this.setRoutePrefs(routePrefs);
            } else {
                routePrefs.setSvlan(this.getCircuitInfo().svlan());
                routePrefs.setSrc(iNetElement);
                routePrefs.setDst(this.getDest().getNetElement());
                routePrefs.setcktSrcEntityIndex(n3);
                routePrefs.setcktDstEntityIndex(n4);
                if (this.getCircuitInfo().isProtected()) {
                    routePrefs.setPathProt(1);
                }
            }
            this.ckt.routeDrop(iNetCircuitEnd, routePrefs);
            this.destinationAdded = true;
        }
        catch (Exception exception) {
            this.addDestinationIfDropIncremented(exception, n);
            throw new AnnotatedException("The drop could not be added and routed.", exception);
        }
        if (this.db.on) {
            this.db.println("addDestination: SVLAN ckt, add and route Drop succeeded");
        }
    }

    void addDestinationToDCNOchnc() throws Exception {
        INetCircuitEnd iNetCircuitEnd;
        INetCircuitEnd iNetCircuitEnd2;
        int n = this.getCircuitInfo().cktOptChannel();
        RoutePrefs routePrefs = new RoutePrefs();
        this.destroyCircuit();
        INetCircuitEnd iNetCircuitEnd3 = this.getOchncEndPoint(n, this.getSource().getNodeModel(), this.getSource().getEntityIndex());
        if (iNetCircuitEnd3 == null) {
            throw new Exception("The selected optical channel cannot be used as the primary source endpoint.");
        }
        if (this.db.on) {
            this.db.println("Primary SRC endPoint: " + Integer.toHexString(iNetCircuitEnd3.getEntityIndex()));
        }
        if ((iNetCircuitEnd2 = this.getOchncEndPoint(n, this.getDest().getNodeModel(), this.getDest().getEntityIndex())) == null) {
            throw new Exception("The selected optical channel cannot be used as the primary destination endpoint.");
        }
        if (this.db.on) {
            this.db.println("Primary DST endPoint: " + Integer.toHexString(iNetCircuitEnd2.getEntityIndex()));
        }
        INetCircuitEnd iNetCircuitEnd4 = null;
        iNetCircuitEnd4 = this.getOchncEndPoint(n, this.getAltDest().getNodeModel(), this.getAltDest().getEntityIndex());
        if (iNetCircuitEnd4 == null) {
            throw new Exception("The selected optical channel cannot be used as the secondary source endpoint.");
        }
        if (this.db.on) {
            this.db.println("Secondary SRC endPoint: " + Integer.toHexString(iNetCircuitEnd4.getEntityIndex()));
        }
        if ((iNetCircuitEnd = this.getOchncEndPoint(n, this.getAltSource().getNodeModel(), this.getAltSource().getEntityIndex())) == null) {
            throw new Exception("The selected optical channel cannot be used as the secondary destination endpoint.");
        }
        if (this.db.on) {
            this.db.println("Secondary DST endPoint: " + Integer.toHexString(iNetCircuitEnd.getEntityIndex()));
        }
        this.ckt = NetCircuitFactory.newCircuit(this.getCircuitInfo(), iNetCircuitEnd3, iNetCircuitEnd4);
        List list = this.ckt.getCircuitNodes();
        this.ckt.addDrop(iNetCircuitEnd2, routePrefs);
        this.ckt.addDrop(iNetCircuitEnd, routePrefs);
        if (!list.isEmpty()) {
            OchncCircuitNode ochncCircuitNode = (OchncCircuitNode)list.get(0);
            ochncCircuitNode.setIsDCNNode(true);
            if (this.getCircuitInfo().isProtected()) {
                IEntityModel iEntityModel;
                INetCircuitEnd iNetCircuitEnd5;
                if (this.db.on) {
                    this.db.println("Protected circuit required");
                }
                if ((iNetCircuitEnd5 = this.getOchncEndPoint(n, this.getProtDest().getNodeModel(), this.getProtDest().getEntityIndex())) == null) {
                    throw new Exception("The selected optical channel cannot be used as the protected destination endpoint.");
                }
                if (this.db.on) {
                    this.db.println("Protected DST endPoint: " + Integer.toHexString(iNetCircuitEnd5.getEntityIndex()));
                }
                if ((iEntityModel = OchncHelper.getReversePort(n, this.getProtDest().getEntityModel())) == null) {
                    throw new Exception("No reverse port for protected destination endpoint.");
                }
                INetCircuitEnd iNetCircuitEnd6 = this.getOchncEndPoint(n, iEntityModel.getNodeModel(), iEntityModel.getEntityIndex());
                if (iNetCircuitEnd6 == null) {
                    throw new Exception("The selected optical channel cannot be used as the protected source endpoint.");
                }
                if (this.db.on) {
                    this.db.println("Secondary SRC endPoint: " + iNetCircuitEnd6.getEntityIndex());
                }
                this.ckt.addSource(iNetCircuitEnd6);
                this.ckt.addDrop(iNetCircuitEnd5, routePrefs);
            }
            if (this.db.on) {
                this.db.println("Set the Ochnc connection with DCN flag.");
            }
        } else if (this.db.on) {
            this.db.println("WARNING: no nodes in the OchncCircuit.");
        }
        if (this.db.on) {
            this.db.println("addDestination: OCHNC DCN ckt, add Drops succeeded");
        }
    }

    void addDestinationToOchTrail() throws Exception {
        int n = this.ckt.getDrops().size();
        RoutePrefs routePrefs = this.getRoutePrefs();
        if (routePrefs == null) {
            routePrefs = new RoutePrefs();
            this.setRoutePrefs(routePrefs);
        }
        routePrefs.setCircuitType(this.ckt.getCircuitType());
        routePrefs.setSrc(this.getSource().getNetElement());
        routePrefs.setDst(this.getDest().getNetElement());
        routePrefs.setcktOptChannel(this.ckt.getCircuitOptChannel());
        routePrefs.setcktSrcEntityIndex(this.getSource().getEntityIndex());
        routePrefs.setcktDstEntityIndex(this.getDest().getEntityIndex());
        if (OchTrailHelper.isProtectedOCHNCService(this.getSource().getEntityModel())) {
            routePrefs.setPathProt(1);
            this.getCircuitInfo().setProtected(true);
        }
        try {
            int n2 = this.getDestNode().getNodeId();
            INetElement iNetElement = Network.instance().findNetElem(n2);
            this.ckt.routeNetElement(iNetElement, routePrefs);
            this.destinationAdded = true;
        }
        catch (Exception exception) {
            this.addDestinationIfDropIncremented(exception, n);
            throw new AnnotatedException("The drops could not be added and routed.", exception);
        }
        if (this.db.on) {
            this.db.println("addDestination: OchTrail added NetElement succeeded");
        }
    }

    private boolean isProtectedOCHNC() {
        block7: {
            try {
                IEntityModel[] iEntityModelArray = new IEntityModel[]{};
                iEntityModelArray = OchTrailHelper.getTrunkPorts(this.getSource().getEntityModel());
                if (OchTrailHelper.isProtectedOCHNCService(iEntityModelArray[0])) {
                    return true;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.db.on()) {
                    this.db.println("Exception getting trunk ports " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
            catch (NoSuchEquipment noSuchEquipment) {
                if (this.db.on()) {
                    this.db.println("Exception getting trunk ports " + (Object)((Object)noSuchEquipment));
                }
            }
            catch (ObjNotFound objNotFound) {
                if (!this.db.on()) break block7;
                this.db.println("Exception getting trunk ports " + (Object)((Object)objNotFound));
            }
        }
        return false;
    }

    void addDestinationToOchcc() throws Exception {
        RoutePrefs routePrefs = new RoutePrefs();
        routePrefs.setCircuitType(this.ckt.getCircuitType());
        routePrefs.setSrc(this.getSource().getNetElement());
        routePrefs.setDst(this.getDest().getNetElement());
        routePrefs.setcktOptChannel(this.ckt.getCircuitOptChannel());
        routePrefs.setcktSrcEntityIndex(this.getSource().getEntityIndex());
        routePrefs.setcktDstEntityIndex(this.getDest().getEntityIndex());
        if (this.getCircuitInfo().isProtected() && !this.isProtectedOCHNC()) {
            routePrefs.setPathProt(1);
        }
        this.setRoutePrefs(routePrefs);
    }

    protected void deleteDestination() throws Exception {
        if (!this.destinationAdded) {
            if (this.db.on) {
                this.db.println("deleteDestination: no destination added");
            }
            return;
        }
        if (this.ckt == null || this.isInvalidCircuitState()) {
            this.cancel(false);
            throw new Exception("The circuit creation cannot proceed due to changes in\nthe network, which affected the circuit(s) being created.\n\nThe dialog box was closed.  Please try again.");
        }
        if (this.ckt.getCircuitTypeObj().isHoCircuitType() || this.ckt.getCircuitTypeObj().isLoCircuitType() || this.ckt.getCircuitTypeObj().isVcatCircuitType()) {
            String string = "deleteDrop";
            this.destDebug(string, "Drop 1");
            if (this.getCircuitInfo().isOVcat()) {
                this.ckt.deleteOpenVcatDrops(this.getDestList());
                this.destDebug(string, "After deletedrop");
                if (this.areSecDropsPresent()) {
                    this.ckt.deleteOpenVcatDrops(this.getAltDestList());
                }
            } else {
                this.ckt.deleteDrop(this.getDest());
                if (this.getAltDest() != null) {
                    this.destDebug(string, "Drop 2");
                    this.ckt.deleteDrop(this.getAltDest());
                }
            }
        } else if (this.ckt.getCircuitTypeObj().isEthernetCircuitType() || this.ckt.getCircuitTypeObj().isTunnelCircuitType() || this.ckt.getCircuitTypeObj().isLAPCircuitType()) {
            if (this.getSourceNode() == this.getDestNode()) {
                return;
            }
            if (this.db.on) {
                this.db.println("deleteDestination: deleting net element");
            }
            int n = this.getDestNode().getNodeId();
            INetElement iNetElement = Network.instance().findNetElem(n);
            this.ckt.deleteNetElement(iNetElement);
            if (this.getAltDestNode() != null) {
                INetElement iNetElement2 = Network.instance().findNetElem(this.getAltDestNode().getNodeId());
                if (this.db.on()) {
                    this.db.println("deleteDestination:  altNe = " + iNetElement2.prettyString());
                }
                if (iNetElement2.getNodeId() != n) {
                    this.ckt.deleteNetElement(iNetElement2);
                }
            }
        } else if (this.ckt.getCircuitTypeObj().isSVLANType()) {
            INetCircuitEnd iNetCircuitEnd = this.getSvlanEndPoint(this.getCircuitInfo().svlan(), this.getDest().getNodeModel(), this.getDest().getEntityIndex());
            if (this.db.on()) {
                this.db.println("deleteDestination:  deleting SVLAN drop at " + iNetCircuitEnd.getNetElement().getName() + "/" + Integer.toHexString(iNetCircuitEnd.getEntityIndex()));
            }
            this.ckt.deleteDrop(iNetCircuitEnd);
        } else if (this.ckt.getCircuitTypeObj().isOchncType()) {
            List list = this.ckt.getDrops();
            for (NetCircuitDropInfo netCircuitDropInfo : list) {
                if (this.db.on()) {
                    this.db.println("deleteDestination:  deleting OCHNC drop at " + netCircuitDropInfo.getNetElement().getName() + "/" + Integer.toHexString(netCircuitDropInfo.getEntityIndex()));
                }
                this.ckt.deleteDrop(netCircuitDropInfo);
            }
        } else if (this.ckt.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            int n = this.getDestNode().getNodeId();
            INetElement iNetElement = Network.instance().findNetElem(n);
            if (this.db.on) {
                this.db.println("deleteDestination: deleting NE " + iNetElement.getName());
            }
            this.ckt.deleteNetElement(iNetElement);
        } else {
            throw new Exception("deleteDestination: unexpected circuit type");
        }
        this.destinationAdded = false;
    }

    private boolean isInvalidCircuitState() {
        return this.ckt != null && this.ckt.getState() != 0 && this.ckt.getState() != 1;
    }

    private void destDebug(String string, String string2) {
        if (this.db.on()) {
            this.db.println("----- " + string + ", op=" + string2 + " -----");
            if (this.getDest() != null) {
                this.db.println("Dest= " + this.getDest().getNodeModel().getName());
            } else {
                this.db.println("Dest= null");
            }
            if (this.getAltDest() != null) {
                this.db.println("AltDest= " + this.getDest().getNodeModel().getName());
            } else {
                this.db.println("AltDest= null");
            }
            this.db.println("circuit info so far:");
            if (this.ckt != null) {
                this.ckt.prettyPrint(this.db);
            } else {
                this.db.println("null!");
            }
            this.db.println("----- " + string + ", end. -----");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply() throws Exception {
        this.destDebug("apply()", "before apply");
        if (this.isPca() && this.ckt.isNonRevertivePca() && this.circuitNumber == 1 && !CerentDialog.yesNoDialog((Component)this, (String)("This PCA circuit is on a non-revertive " + CircuitMapUtil.BLSR_TERM + "." + "\nThe circuit might be preempted indefinitely.\n\n" + "Is it OK to continue?"), (String)("Non-Revertive " + CircuitMapUtil.BLSR_TERM))) {
            this.stopDriver = true;
            this.destroyCircuit();
            return;
        }
        try {
            ICircuitDropInfo[] iCircuitDropInfoArray;
            Object object;
            int n;
            String string;
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if ((string = this.currentWzPane.getName()).equals("Destination") && this.isVlanCapable()) {
                try {
                    this.ckt.assignVlanSet(new IVlanModel[]{VlanSetManager.instance().defaultVlan()});
                    this.ckt.createWithStpEnabled(true);
                }
                catch (Exception exception) {
                    throw new AnnotatedException("A default VLAN could not be assigned to the circuit.", exception);
                }
            }
            try {
                if (!this.getPortGrouping() && this.ckt != null) {
                    this.ckt.sanityCheck();
                }
                if (this.db.on) {
                    this.db.println("apply: ckt.sanityCheck() succeeded");
                }
            }
            catch (Exception exception) {
                throw new AnnotatedException("The circuit sanity check failed.", exception);
            }
            if (!this.ckt.getCircuitTypeObj().isOchncType() && !this.ckt.getCircuitTypeObj().isOchccCircuitType()) {
                this.ckt.setUpsrSelectorAttributes(this.getUpsrReversion(), (short)this.getUpsrSfBerLevel().getIntValue(), (short)this.getUpsrSdBerLevel().getIntValue(), this.getUpsrSwitchOnPdip());
            }
            try {
                boolean bl = false;
                n = 0;
                if (!this.getPortGrouping() && this.ckt != null) {
                    if (this.db.on) {
                        this.db.println("The circuit before provision:");
                        this.ckt.prettyPrint(this.db);
                    }
                    if (this.isVcatType()) {
                        object = ProgressDialog.start(this, "Circuit Provision", "Circuits are being created.  Please wait...", this, 2000, 10, false, false);
                        iCircuitDropInfoArray = ((ProgressDialog)object).getResultException();
                        if (iCircuitDropInfoArray != null) {
                            throw iCircuitDropInfoArray;
                        }
                    } else {
                        if (this.getRoutePrefs() != null) {
                            if (this.getRoutePrefs().getSrc() != null && this.getRoutePrefs().getSrc().getNodeModel().getNeType().indexOf("crs") > -1) {
                                bl = true;
                            }
                            if (this.getRoutePrefs().getDst() != null && this.getRoutePrefs().getDst().getNodeModel().getNeType().indexOf("crs") > -1) {
                                n = 1;
                            }
                        }
                        if (bl && n != 0 && this.getRoutePrefs().isOchTrailTunnelCircuit()) {
                            object = (CktInfo)((NetCircuit)this.ckt).getCircuitInfo();
                            ((CktInfo)object).setCircuitName(this.getCircuitName());
                            iCircuitDropInfoArray = ((CktInfo)object).getDropInfo();
                            iCircuitDropInfoArray = new ICircuitDropInfo[1];
                            CircuitEnd circuitEnd = new CircuitEnd(this.getRoutePrefs().getDst().getNodeId(), this.getRoutePrefs().getcktDstEntityIndex(), null, null, false, 0);
                            iCircuitDropInfoArray[0] = new CircuitDropInfo(circuitEnd, 0);
                            ((CktInfo)object).setDropInfo(iCircuitDropInfoArray);
                            ICircuitEnd iCircuitEnd = ((CktInfo)object).getSrcPoint();
                            iCircuitEnd.setNodeId(this.getRoutePrefs().getSrc().getNodeId());
                            iCircuitEnd.setPortNum(this.getRoutePrefs().getcktSrcEntityIndex());
                            ((CktInfo)object).setSrcPoint(iCircuitEnd);
                            ((NetCircuit)this.ckt).setCircuitInfo((ICircuitInfo)object);
                        }
                        if (this.ckt.getCircuitTypeObj().isSVLANType()) {
                            this.setQinQInfo();
                        }
                        this.ckt.provision();
                        try {
                            if (bl && n != 0 && this.getRoutePrefs().isOchTrailTunnelCircuit()) {
                                this.updateCRS(this.ckt, this.getRoutePrefs().getSrc().getNodeModel(), this.getRoutePrefs().getcktSrcEntityIndex(), this.getRoutePrefs().getDst().getNodeModel(), this.getRoutePrefs().getcktDstEntityIndex());
                            }
                        }
                        catch (Exception exception) {
                            if (this.db.on) {
                                this.db.println("Unable to update the SRLG for circuit : " + this.ckt.getCircuitName());
                            }
                            ErrorMsg.displayWarning((Component)this, (WID)NEMC.WID_NO_SRLG_SET);
                        }
                        if (this.ckt.getCircuitTypeObj().isOchTrailTunnelCircuitType() && (object = ((OchncCircuit)this.ckt).getTrunksInUseMsg()) != null) {
                            iCircuitDropInfoArray = DetailedDialog.instance((Frame)JOptionPane.getFrameForComponent(this), (String)"Trunk Settings Provisioning");
                            iCircuitDropInfoArray.setText("Trunk settings are not applied on any of the trunk ports.", CerentDialog.INFO_ICON);
                            iCircuitDropInfoArray.append("The following trunk ports are in IS state.\n\n" + (String)object);
                            iCircuitDropInfoArray.setSize(500, iCircuitDropInfoArray.getHeight());
                            iCircuitDropInfoArray.show();
                        }
                    }
                    if (this.db.on) {
                        this.db.println("apply: ckt.provision() succeeded");
                    }
                }
                if (this.ckt != null) {
                    this.destDebug("apply()", "after provision");
                }
            }
            catch (Exception exception) {
                block43: {
                    if (this.db.on && this.ckt != null) {
                        this.db.println("Circuit provision failed, here is the circuit:");
                        this.ckt.prettyPrint(this.db);
                    }
                    if (string.equals("Destination") || string.equals("Destinations")) {
                        try {
                            this.deleteDestination();
                        }
                        catch (Exception exception2) {
                            if (!this.db.on()) break block43;
                            KDebug.printStackTrace((Throwable)exception2);
                        }
                    }
                }
                throw new AnnotatedException("The circuit could not be provisioned.", exception);
            }
            if (NetAdminState.circuitAllowsStateApplicationToDrops(this.ckt) && this.applyDropPorts && !this.getPortGrouping()) {
                ArrayList arrayList = new ArrayList();
                if (!NetCircuitModel.setAdminStateOnDropPorts(this.ckt, this.getPortsState(), arrayList)) {
                    ++this.numDropPortsNotSet;
                    AdminStatePanel.buildDropPortsNotSet(this.ckt, arrayList, this.dropPortsNotSet);
                }
            }
            if (this.ckt.getCircuitTypeObj().isOchccCircuitType() || this.ckt.getCircuitTypeObj().isOchncType()) {
                ArrayList arrayList = new ArrayList();
                n = this.getCircuitState();
                if (!NetCircuitModel.setAdminStateOnRegenTrkPorts(this.ckt, n, arrayList)) {
                    object = ErrorMsg.getString((EID)NEMC.WID_CURR_STATE_OR_TYPE_NOT_ALLOWED_PARAM_1, (Object)NetworkDefaults.circuitAdminStateToString(n));
                    iCircuitDropInfoArray = new StringBuffer("The  circuit state has not been applied to at least one regen port on the following circuit:");
                    AbstractAdminStatePanel.buildDropPortsNotSet(this.ckt, arrayList, (StringBuffer)iCircuitDropInfoArray);
                    IgnorableDialog.detailedDialog((Component)this, (String)object, (String)iCircuitDropInfoArray.toString(), (String)"Apply to Ports Results", (String)"ShowPortStateFail_CREATION", (String)"Circuit Creation Dialog Apply Circuit State to Regen Ports Failure");
                }
            }
            if (this.getPortGrouping()) {
                PortGrouping portGrouping = PortGrouping.getInstance();
                portGrouping.initForCreation(this.getCircuitName(), this.getPgEnd(), this.getDestPgEnd(), this.getRoutePrefs(), this.getUpsrReversion(), (short)this.getUpsrSfBerLevel().getIntValue(), (short)this.getUpsrSdBerLevel().getIntValue(), this.getUpsrSwitchOnPdip(), this.getPortsState(), this.applyDropPorts, this.getUpsrGoReturnRouting());
                this.destroyCircuit();
            } else {
                this.ckt = null;
            }
            this.clearRelatedCircuits();
            Object var9_16 = null;
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
        catch (Throwable throwable) {
            Object var9_17 = null;
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
            throw throwable;
        }
    }

    private void updateCRS(INetCircuit iNetCircuit, INodeModel iNodeModel, int n, INodeModel iNodeModel2, int n2) {
        IPoDWDMUtility iPoDWDMUtility = IPoDWDMUtility.instance();
        List list = iPoDWDMUtility.getConsolidatedSRLG(iNetCircuit, 100);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        if (list.size() == 0) {
            bl3 = false;
        }
        if (bl2 = iPoDWDMUtility.deleteSRLG(iNodeModel, iNetCircuit, n)) {
            if (this.db.on()) {
                this.db.println("Successfully deleted the SRLG on CRS Node: " + iNodeModel.getName());
            }
            if (bl3) {
                bl = iPoDWDMUtility.setSRLG(iNodeModel, iNetCircuit, list, n);
                if (bl) {
                    if (this.db.on()) {
                        this.db.println("Successfully set the SRLG on CRS Node: " + iNodeModel.getName());
                    }
                } else if (this.db.on()) {
                    this.db.println("Unable to set the SRLG on CRS Node: " + iNodeModel.getName());
                }
            }
        } else if (this.db.on()) {
            this.db.println("Unable to delete the SRLG on CRS Node: " + iNodeModel.getName());
        }
        if (bl2 = iPoDWDMUtility.deleteSRLG(iNodeModel2, iNetCircuit, n2)) {
            if (this.db.on()) {
                this.db.println("Successfully deleted the SRLG on CRS Node: " + iNodeModel2.getName());
            }
            if (bl3) {
                bl = iPoDWDMUtility.setSRLG(iNodeModel2, iNetCircuit, list, n2);
                if (bl) {
                    if (this.db.on()) {
                        this.db.println("Successfully set the SRLG on CRS Node: " + iNodeModel2.getName());
                    }
                } else if (this.db.on()) {
                    this.db.println("Unable to set the SRLG on CRS Node: " + iNodeModel2.getName());
                }
            }
        } else if (this.db.on()) {
            this.db.println("Unable to delete the SRLG on CRS Node: " + iNodeModel2.getName());
        }
    }

    private void terminate() {
        ErrorMsg.displayError((Component)this, (EID)NEMC.EID_CHANGES_NET_CKT_ERROR);
        this.cancel(false);
    }

    public void finish() {
        if (this.ckt == null || this.isInvalidCircuitState()) {
            this.terminate();
            return;
        }
        super.finish();
    }

    protected void handleFinish() {
        if (this.currentWzPane != null && this.currentWzPane instanceof WzCcdPane) {
            if (this.db.on()) {
                this.db.fine("WzCcdPane's handleFinish() for " + this.currentWzPane.getName());
            }
            ((WzCcdPane)this.currentWzPane).handleFinish();
        }
        if (this.circuitNumber++ < this.circuitCount && !this.stopDriver) {
            if (this.autoRange) {
                int n = this.circuitCount - this.circuitNumber + 1;
                Autoranger autoranger = new Autoranger(this.arInfo, n, 2);
                if (this.applyDropPorts) {
                    autoranger.setAdminStateOnDrops(true);
                }
                ProgressDialog.start(this, "Autoranged Circuit Progress", "Autoranged Circuit Progress", autoranger, true);
                DetailedLog detailedLog = autoranger.getAutoRangeLog();
                if (detailedLog != null) {
                    int n2 = detailedLog.getChildCount();
                    if (n2 == 0) {
                        CerentDialog.infoDialog((Component)this, (String)("All " + this.circuitCount + " circuits were successfully " + "created."), (String)"Circuit Autorange Complete.");
                    } else {
                        CerentDialog.errorDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.EID_COULD_NOT_AUTORANGE_ALL_CIRCUITS_PARAM_2, (Object)String.valueOf(n2), (Object)String.valueOf(this.circuitCount)), (String)"Circuit Autorange Complete", (DetailedLog)detailedLog, (boolean)false);
                    }
                }
                this.numDropPortsNotSet += autoranger.getAdminStateOnDropsFailures();
                this.dropPortsNotSet.append(autoranger.getAdminStateOnDropsString());
                AdminStatePanel.showDropPortsFailure(this, this.getPortsState(), this.numDropPortsNotSet, this.dropPortsNotSet);
                super.handleFinish();
            } else {
                for (Object k : this.wzPaneMap.keySet()) {
                    WzPane wzPane = (WzPane)this.wzPaneMap.get(k);
                    if (!(wzPane instanceof CcdCircuitDesignPane)) continue;
                    if (this.db.on()) {
                        this.db.info("finished circuit, resetting " + wzPane.getName());
                    }
                    ((CcdCircuitDesignPane)wzPane).recycle();
                }
                this.popEntireStack();
            }
        } else {
            AdminStatePanel.showDropPortsFailure(this, this.getPortsState(), this.numDropPortsNotSet, this.dropPortsNotSet);
            super.handleFinish();
        }
    }

    public boolean handleFinishException(Exception exception) {
        Object[] objectArray;
        if (exception instanceof AnnotatedException) {
            objectArray = (Object[])exception;
            exception = objectArray.getChild();
        }
        if (exception instanceof VlanStpSanityCheckFailed) {
            objectArray = new String[]{"View Table", "Close"};
            int n = CerentDialog.errorDialog((Component)this, (String)VLANSTPVIOLATION_MSG, (String)"VLAN/Spanning Tree Violation", (Object[])objectArray, (Object)objectArray[0]);
            if (n == 0) {
                VlanStpSanityCheckFailed vlanStpSanityCheckFailed = (VlanStpSanityCheckFailed)exception;
                IVlanModel[] iVlanModelArray = this.ckt.getVlans();
                VlanStpDialog vlanStpDialog = new VlanStpDialog((Frame)this, vlanStpSanityCheckFailed.getNodeModel(), iVlanModelArray);
                vlanStpDialog.show();
            }
            return true;
        }
        return super.handleFinishException(exception);
    }

    AutorangeInfo getAutorangeInfo() {
        return this.arInfo;
    }

    public String getResultString(Exception exception) {
        throw new DeprecatedMethodCalled("ProgressDialogControl.getResultString(Exception)");
    }

    public ProgressDialogResult getResult(Exception exception) {
        ProgressDialogResult progressDialogResult = null;
        if (this.isVcatType()) {
            return progressDialogResult;
        }
        progressDialogResult = exception == null ? new ProgressDialogResult("Successfully created " + this.circuitCount + " circuits") : new ProgressDialogResult(2, NEMC.EID_CHANGES_NET_CKT_ERROR, new String[]{exception.getMessage()});
        return progressDialogResult;
    }

    public void executeTask(Observer observer) throws Exception {
        if (this.ckt != null && this.isVcatType()) {
            this.ckt.provision();
            for (INetCircuit iNetCircuit : this.getRelatedCircuitList()) {
                try {
                    iNetCircuit.destroySanityCheck();
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    continue;
                }
                iNetCircuit.destroyCircuit();
                this.removeRelatedCircuit(iNetCircuit);
            }
        }
    }

    public void stop() {
    }

    public void suspend() {
    }

    public void resume() {
    }

    public boolean stopRequired() {
        return false;
    }

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Destination Added: " + this.destinationAdded + "\n");
        stringBuffer.append("Apply Drop Ports: " + this.applyDropPorts + "\n");
        stringBuffer.append("TL1 Like Default: " + this.isCircuitTL1Compatible() + "\n");
        stringBuffer.append("Num Drop Ports Not Set: " + this.numDropPortsNotSet + "\n");
        stringBuffer.append("DropPortsNotSet Info:\n");
        stringBuffer.append(this.dropPortsNotSet.toString() + "\n");
        stringBuffer.append("Stop Driver: " + this.stopDriver + "\n");
        return stringBuffer.toString();
    }

    public boolean isUniqueNodeDrop() {
        INetCircuitEnd[] iNetCircuitEndArray = this.getDestList();
        if (iNetCircuitEndArray.length > 1) {
            int n;
            int n2 = iNetCircuitEndArray[0].getNetElement().getNodeId();
            int n3 = iNetCircuitEndArray[0].getEntityIndex();
            for (n = 1; n < iNetCircuitEndArray.length; ++n) {
                if (n2 == iNetCircuitEndArray[n].getNetElement().getNodeId()) continue;
                return false;
            }
            for (n = 1; n < iNetCircuitEndArray.length; ++n) {
                if (n3 == iNetCircuitEndArray[n].getEntityIndex()) continue;
                return false;
            }
        }
        return !this.areSecDropsPresent();
    }

    public INetCircuitEnd[] getDestList() {
        CcdOvcatEndpoints ccdOvcatEndpoints = (CcdOvcatEndpoints)this.wzPaneMap.get("Destinations");
        return ccdOvcatEndpoints.getDrops();
    }

    public INetCircuitEnd[] getAltDestList() {
        CcdOvcatEndpoints ccdOvcatEndpoints = (CcdOvcatEndpoints)this.wzPaneMap.get("Destinations");
        return ccdOvcatEndpoints.getAltDrops();
    }

    public boolean areSecDropsPresent() {
        CcdOvcatEndpoints ccdOvcatEndpoints = (CcdOvcatEndpoints)this.wzPaneMap.get("Destinations");
        return ccdOvcatEndpoints.areSecDropsPresent();
    }

    public void setAutorangeInfo(AutorangeInfo autorangeInfo) {
        this.arInfo = autorangeInfo;
    }

    public void setAltDestNode(INodeModel iNodeModel) {
        CcdEndpointsPane ccdEndpointsPane = null;
        if (this.getCircuitInfo().isOVcat() && (ccdEndpointsPane = (CcdEndpointsPane)this.wzPaneMap.get("Destinations")) != null) {
            ccdEndpointsPane.setNode(iNodeModel, true);
        }
    }
}

