/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoUpsrAttributes;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.IXPLLayer2LineModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.model.SvlanCircuitHelper;
import cerent.cms.model.circuits.SanityCheckException;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SvlanCircuit;
import cerent.cms.route.RoutePrefs;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AdminStatePanel;
import cerent.cms.ui.circuits.CcdEndpointsPane;
import cerent.cms.ui.circuits.CcdSvlanRoutePane;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.DropCreationPane;
import cerent.cms.ui.circuits.DropReviewEditPane;
import cerent.cms.ui.circuits.DropRouteConstraintPane;
import cerent.cms.ui.circuits.IDropCreationPane;
import cerent.cms.ui.circuits.SvlanDropCreationPane;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.WID;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class CircuitDropCreationDialog
extends AbstractCircuitDialog {
    public static final String TITLE = "Define New Drop";
    public static final String NEW_DROP = "New Drop";
    public static final String GET_ROUTE_CONSTR = "Circuit Route Constraints";
    public static final String GET_SVLAN_ROUTE_PREFS = "SVLAN Circuit Routing Preview";
    public static final String REVIEW_EDIT = "Route Review and Edit";
    protected IDropCreationPane dropCreationPane;
    private DropReviewEditPane revEditPane;
    AdminStatePanel adminStatePanel;
    protected Frame frame;
    private static final int WIDTH = 850;
    private static final int SHORT = 475;
    protected INetCircuitEnd newCircuitEnd;
    protected CircuitCreatInfo circuitInfo;
    protected boolean dropProtection;
    protected boolean portGrouping;
    protected IRevertiveBehavior upsrReversion;
    protected short upsrSdBerLevel;
    protected short upsrSfBerLevel;
    protected boolean upsrSwitchOnPdip;

    INetCircuitEnd getNewCircuitEnd() {
        return this.newCircuitEnd;
    }

    public void setNewCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        this.newCircuitEnd = iNetCircuitEnd;
    }

    public boolean getDropProtection() {
        return this.dropProtection;
    }

    public IRevertiveBehavior getUpsrReversion() {
        return this.upsrReversion;
    }

    public void setUpsrReversion(IRevertiveBehavior iRevertiveBehavior) {
        this.upsrReversion = iRevertiveBehavior;
    }

    public boolean getUpsrSwitchOnPdip() {
        return this.upsrSwitchOnPdip;
    }

    public void setUpsrSwitchOnPdip(boolean bl) {
        this.upsrSwitchOnPdip = bl;
    }

    public INodeModel getLapSrcNode() {
        if (this.db.on()) {
            this.db.println("CircuitDropCreationDialog: empty imp getLapSrcNode()");
        }
        return null;
    }

    public INodeModel getLapDstNode() {
        if (this.db.on()) {
            this.db.println("CircuitDropCreationDialog: empty imp getLapDstNode()");
        }
        return null;
    }

    public void setLapDstNode(INodeModel iNodeModel) {
        if (this.db.on()) {
            this.db.println("CircuitDropCreationDialog: empty imp setLapDstNode()");
        }
    }

    public Attribute getUpsrSfBerLevel() {
        if (this.db.on()) {
            this.db.println("CircuitDropCreationDialog: empty imp getUpsrSfBerLevel()");
        }
        return null;
    }

    public Attribute getUpsrSdBerLevel() {
        if (this.db.on()) {
            this.db.println("CircuitDropCreationDialog: empty imp getUpsrSdBerLevel()");
        }
        return null;
    }

    public CircuitDropCreationDialog(JComponent jComponent, INetCircuit iNetCircuit, boolean bl) {
        super(JOptionPane.getFrameForComponent(jComponent), TITLE, new WzDiagDebug("CircuitDropCreationDialog"), !bl);
        this.frame = JOptionPane.getFrameForComponent(jComponent);
        this.ckt = iNetCircuit;
        this.initUpsrAttributes();
        this.createPanesAndSetCurrent();
        this.setHeight(475);
        this.setLocationRelativeTo(this.frame);
    }

    public CircuitDropCreationDialog(JComponent jComponent, TabbedView tabbedView, INetCircuit iNetCircuit, boolean bl) {
        this(jComponent, iNetCircuit, bl);
        this.setTabbedView(tabbedView);
    }

    protected void createPanesAndSetCurrent() {
        if (this.ckt.getCircuitTypeObj().isSVLANType()) {
            this.dropCreationPane = new SvlanDropCreationPane(this, this.makeChildDebug("DropCreation"), NEW_DROP);
            this.wzPaneMap.put(NEW_DROP, this.dropCreationPane);
            this.wzPaneMap.put(GET_SVLAN_ROUTE_PREFS, new CcdSvlanRoutePane(this, this.makeChildDebug("SvlanRouteConstraints"), GET_SVLAN_ROUTE_PREFS, true));
        } else {
            this.dropCreationPane = new DropCreationPane(this, this.makeChildDebug("DropCreation"), NEW_DROP);
            this.wzPaneMap.put(NEW_DROP, this.dropCreationPane);
            this.wzPaneMap.put(GET_ROUTE_CONSTR, new DropRouteConstraintPane(this, this.makeChildDebug("RouteConstraints"), GET_ROUTE_CONSTR, true));
            this.revEditPane = new DropReviewEditPane(this, this.makeChildDebug("ReviewEdit"), REVIEW_EDIT, false);
            this.wzPaneMap.put(REVIEW_EDIT, this.revEditPane);
        }
        this.circuitInfo = new CircuitCreatInfo(this.ckt.getCircuitType(), this.ckt.getCircuitSize(), this.ckt.getCircuitDir(), false, this.ckt.getCircuitName());
        if (this.ckt.getCircuitTypeObj().isSVLANType()) {
            this.circuitInfo.setSVLAN(((SvlanCircuit)this.ckt).getSvlan());
            this.circuitInfo.setProtected(((SvlanCircuit)this.ckt).isCircuitProtected());
        }
        INodeModel iNodeModel = this.ckt.getSrcNetElement().getNodeModel();
        if (this.ckt.getCircuitTypeObj().isEthernetCircuitType()) {
            int n = iNodeModel.getTdmProtocolTypeObj().getHoCircuitType();
            this.circuitInfo.setType(n);
        }
        this.setCurrentPane(NEW_DROP);
    }

    void presetNodeSelector(INodeModel iNodeModel) {
        if (this.dropCreationPane.getDropPane() != null) {
            this.dropCreationPane.getDropPane().presetNodeSelector(iNodeModel);
        }
    }

    protected void apply() throws Exception {
        boolean bl = this.ckt.isPca();
        try {
            this.ckt.sanityCheck();
            this.db.info("apply: sanityCheck() succeeded");
            this.ckt.setUpsrSelectorAttributes(this.upsrReversion, this.upsrSfBerLevel, this.upsrSdBerLevel, this.upsrSwitchOnPdip);
            if (this.ckt.getCircuitTypeObj().isSVLANType()) {
                this.setSvlanInfo();
            }
            this.ckt.provision();
            this.db.info("apply: provision() succeeded");
        }
        catch (Exception exception) {
            if (this.getPageName() == NEW_DROP) {
                if (this.db.on()) {
                    this.db.println("tossing the destination now.");
                }
                this.deleteDestination();
            }
            if (exception instanceof SanityCheckFailed) {
                throw new SanityCheckException("", "spans are", exception);
            }
            throw new AnnotatedException("The circuit cannot be provisioned.", exception);
        }
        if (this.adminStatePanel != null) {
            this.adminStatePanel.applyToCircuit(this.ckt);
        }
        if (!bl && this.ckt.isPca()) {
            ErrorMsg.displayWarning(null, (WID)NEMC.WID_DROP_MAKES_THE_CKT_PCA);
        }
    }

    protected void setSvlanInfo() throws CircuitProvError {
        if (this.db.on) {
            this.db.println("setSvlanInfo: additional setting for SVLAN circuit");
        }
        SvlanDropCreationPane svlanDropCreationPane = (SvlanDropCreationPane)this.wzPaneMap.get(NEW_DROP);
        CcdEndpointsPane ccdEndpointsPane = svlanDropCreationPane.getDropPane();
        CircuitCreatInfo circuitCreatInfo = this.getCircuitInfo();
        try {
            INetCircuitEnd iNetCircuitEnd = ccdEndpointsPane.getMainPanelEndpoint();
            if (iNetCircuitEnd != null) {
                IEntityModel iEntityModel = iNetCircuitEnd.getEntityModel();
                IXPLLayer2LineModel iXPLLayer2LineModel = SvlanCircuitHelper.getL2Interface(iNetCircuitEnd.getNodeModel(), iEntityModel.getEntityIndex());
                if (iXPLLayer2LineModel != null) {
                    if (iXPLLayer2LineModel.isNNI()) {
                        List list = this.ckt.getCircuitNodes();
                        boolean bl = true;
                        for (Object object : list) {
                            if (((NetCircuitNode)object).getState() != 0) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            Object object;
                            if (this.db.on()) {
                                this.db.println("Setting SVLAN NNI on drop port: " + Integer.toHexString(iEntityModel.getEntityIndex()));
                            }
                            Object object2 = iXPLLayer2LineModel.getVlanListOnNNIPort();
                            object = new short[((Object)object2).length + 1];
                            System.arraycopy(object2, 0, object, 0, ((Object)object2).length);
                            object[((Object)object2).length] = circuitCreatInfo.svlan();
                            iXPLLayer2LineModel.setVlanList(object);
                        }
                    } else {
                        if (this.db.on()) {
                            this.db.println("Setting QinQ info on drop port: " + Integer.toHexString(iEntityModel.getEntityIndex()));
                        }
                        iXPLLayer2LineModel.setQinQInfoFromNet(circuitCreatInfo.getSrcQinQInfo());
                    }
                }
            }
        }
        catch (Exception exception) {
            if (this.db.on()) {
                this.db.println("Caught exception during SVLAN info setting:" + exception);
            }
            throw new CircuitProvError("SVLAN setting failure on drop circuit port.");
        }
    }

    public INodeModel getSourceNode() {
        if (this.ckt == null || this.ckt.getPrimarySource() == null) {
            return null;
        }
        return this.ckt.getPrimarySource().getNodeModel();
    }

    public INodeModel getDestNode() {
        if (this.dropCreationPane == null && this.dropCreationPane.getDropPane() == null) {
            return null;
        }
        return this.dropCreationPane.getDropPane().nodeModel;
    }

    public INetCircuitEnd getDest() {
        return this.dropCreationPane.getDropPane().getMainPanel() != null ? this.dropCreationPane.getDropPane().getMainPanel().endpoint : null;
    }

    protected void handleFinish() {
        if (this.getPageName().equals(NEW_DROP)) {
            this.dropCreationPane.stopObserving();
        }
        super.handleFinish();
    }

    protected void handleCancel() {
        block13: {
            if (this.getPageName().equals(NEW_DROP)) {
                this.dropCreationPane.stopObserving();
            }
            if (this.getPageName().equals(REVIEW_EDIT)) {
                this.revEditPane.recycle();
            }
            try {
                this.deleteDestination();
                if (this.db.on()) {
                    this.db.println("handleCancel: deleted drop");
                }
            }
            catch (ObjNotFound objNotFound) {
                if (this.db.on()) {
                    this.db.println("handleCancel: No drop to delete");
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block13;
                WzDiagDebug.printStackTrace((Throwable)exception);
            }
        }
        if (this.getCircuitType() == 16) {
            if (this.db.on) {
                this.db.println("handleCancel: additional clean-up for SVLAN circuit");
            }
            SvlanDropCreationPane svlanDropCreationPane = (SvlanDropCreationPane)this.wzPaneMap.get(NEW_DROP);
            if (this.getCircuitInfo() != null) {
                try {
                    if (this.db.on) {
                        this.db.println("handleCancel: calling clean-up on src/dst pane");
                    }
                    svlanDropCreationPane.cleanUpQinQ(this.getCircuitInfo().svlan());
                }
                catch (Exception exception) {
                    WzDiagDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        this.destroyRelatedCircuits();
    }

    private void setHeight(int n) {
        this.setSize(new Dimension(850, n));
        this.invalidate();
    }

    private void initUpsrAttributes() {
        this.db.info("ckt.getUpsrAttributes=" + this.ckt.getUpsrAttributes());
        IHoUpsrAttributes iHoUpsrAttributes = this.ckt.getUpsrAttributes();
        if (iHoUpsrAttributes != null) {
            this.upsrReversion = iHoUpsrAttributes.getUpsrReversion();
            this.upsrSfBerLevel = iHoUpsrAttributes.getUpsrSfBerLevel();
            this.upsrSdBerLevel = iHoUpsrAttributes.getUpsrSdBerLevel();
            this.upsrSwitchOnPdip = iHoUpsrAttributes.getUpsrSwitchOnPdiP();
            if (this.db.on()) {
                this.db.println("Obtained upsr attributes from circuit.");
            }
        } else {
            Preferences preferences;
            block9: {
                INodeModel iNodeModel;
                preferences = Preferences.instance();
                int n = preferences.getBoolean("ctc.circuit.creation", "revertive", false) ? 2 : 1;
                int n2 = preferences.getInt("ctc.circuit.creation", "revertTime", 300);
                if (n2 == 0) {
                    n2 = 30;
                }
                this.upsrReversion = new RevertiveBehavior(n, n2);
                int n3 = 2;
                this.upsrSfBerLevel = (short)4;
                this.upsrSdBerLevel = (short)6;
                if (this.ckt.getCircuitTypeObj().isLoCircuitType()) {
                    n3 = 1;
                    this.upsrSfBerLevel = (short)3;
                    this.upsrSdBerLevel = (short)5;
                }
                if ((iNodeModel = NetworkModel.instance().getCmsHostModel()) != null && iNodeModel.isInited()) {
                    try {
                        this.upsrSfBerLevel = iNodeModel.getUpsrSfBerLevel(n3);
                        this.upsrSdBerLevel = iNodeModel.getUpsrSdBerLevel(n3);
                    }
                    catch (Exception exception) {
                        this.db.severe("Could not get default bers:" + exception);
                        this.upsrSfBerLevel = (short)4;
                        this.upsrSdBerLevel = (short)6;
                        if (n3 != 1) break block9;
                        this.upsrSfBerLevel = (short)3;
                        this.upsrSdBerLevel = (short)5;
                    }
                }
            }
            this.upsrSwitchOnPdip = preferences.getBoolean("ctc.circuit.creation", "pdip", false);
            if (this.db.on()) {
                this.db.println("set " + CircuitMapUtil.UPSR_TERM + " selector attributes:");
                this.db.println(" upsrReversion=" + this.upsrReversion.getReversionMode());
                this.db.println(" upsrSfBerLevel=" + this.upsrSfBerLevel);
                this.db.println(" upsrSdBerLevel=" + this.upsrSdBerLevel);
                this.db.println(" upsrSwitchOnPdip=" + this.upsrSwitchOnPdip);
            }
        }
    }

    protected EID getNoRouteEmcErrorId() {
        return NEMC.EID_CKT_ADD_DROP_ROUTE_ERROR;
    }

    public RoutePrefs getRoutePrefs() {
        if (this.dropCreationPane != null) {
            return this.dropCreationPane.getRoutePrefs();
        }
        return null;
    }

    public boolean isRrbc() {
        if (this.dropCreationPane != null) {
            return this.dropCreationPane.isRrbc();
        }
        return false;
    }

    public boolean isUrn() {
        if (this.dropCreationPane != null) {
            return this.dropCreationPane.isUrn();
        }
        return false;
    }

    public boolean isAutoRoute() {
        if (this.dropCreationPane != null) {
            return this.dropCreationPane.isAutoRoute();
        }
        return false;
    }

    public boolean isPca() {
        if (this.dropCreationPane != null) {
            return this.dropCreationPane.isPca();
        }
        return false;
    }

    public void setPca(boolean bl) {
        if (this.dropCreationPane != null) {
            this.dropCreationPane.setPca(bl);
        }
    }

    public int getCircuitType() {
        return this.ckt.getCircuitType();
    }

    public boolean isPathProt() {
        if (this.dropCreationPane != null) {
            return this.dropCreationPane.isPathProt();
        }
        return false;
    }

    public void setPathProt(boolean bl) {
        if (this.dropCreationPane != null) {
            this.dropCreationPane.setPathProt(bl);
        }
    }

    public CircuitCreatInfo getCircuitInfo() {
        return this.circuitInfo;
    }

    public boolean getPortGrouping() {
        return this.portGrouping;
    }

    public ArrayList getVcatMemberPrefs() {
        return null;
    }

    public void setVcatCommonFiberRouting(boolean bl) {
    }

    public boolean isVcatCommonFiberRouting() {
        return false;
    }

    public int getVcatTxMembers() {
        return 0;
    }

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("New Circuit End: " + this.newCircuitEnd + "\n");
        stringBuffer.append("Circuit Create Info: " + this.circuitInfo + "\n");
        stringBuffer.append("Drop Protection: " + this.dropProtection + "\n");
        stringBuffer.append("Port Grouping: " + this.portGrouping + "\n");
        return stringBuffer.toString();
    }

    protected void addDestination(boolean bl) throws Exception {
        if (this.destinationAdded) {
            this.deleteDestination();
            this.destinationAdded = false;
        }
        if (bl) {
            this.getCircuit().routeDrop(this.getNewCircuitEnd(), this.getRoutePrefs());
        } else {
            this.getCircuit().addDrop(this.getNewCircuitEnd(), this.getRoutePrefs());
        }
        this.destinationAdded = true;
    }

    protected void deleteDestination() throws Exception {
        if (this.destinationAdded) {
            this.getCircuit().deleteDrop(this.getNewCircuitEnd());
        }
        this.destinationAdded = false;
    }
}

