/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetServiceState;
import cerent.cms.model.circuits.CircuitFilterCriteria;
import cerent.cms.model.circuits.CircuitFilterCriteriaPreferences;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.circuits.AbstractCircuitFilterPane;
import cerent.cms.ui.circuits.CircuitCreationWizard;
import cerent.cms.ui.circuits.CircuitTypeDisplayer;
import cerent.cms.ui.circuits.CircuitsPane;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.gui.AbstractPropertyDialogSheet;
import cerent.util.gui.CheckableList;
import cerent.util.gui.IntegerPropertyEditor;
import cerent.util.gui.StringChoicePropertyEditor;
import cerent.util.gui.StringPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class CircuitFilterGeneralPane
extends AbstractCircuitFilterPane {
    private StringPropertyEditor nameBox;
    private IntegerPropertyEditor slotBox;
    private IntegerPropertyEditor shelfBox;
    private StringPropertyEditor portBox;
    private StringChoicePropertyEditor typeBox;
    private StringChoicePropertyEditor directionBox;
    private StringChoicePropertyEditor optChNumBox;
    private StringChoicePropertyEditor statusBox;
    private StringChoicePropertyEditor serviceStateBox;
    private StringChoicePropertyEditor protectionTypeBox;
    private CheckableList sizeList;
    private static final int LABEL_PREFERRED_WIDTH = 85;
    private static final int EDITOR_PREFERRED_WIDTH = 178;

    public CircuitFilterGeneralPane(String string, CircuitsPane circuitsPane, AbstractPropertyDialogSheet abstractPropertyDialogSheet, CircuitFilterCriteria circuitFilterCriteria) {
        super(string, abstractPropertyDialogSheet, circuitFilterCriteria, 85, 178);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridLayout(0, 2, 5, 5));
        this.add(this.createLeftPane());
        this.add(this.createRightPane());
        this.load();
        IModel iModel = circuitsPane.getCurrentCircuitScope();
        if (iModel instanceof IModuleModel) {
            this.slotBox.setValue("");
            this.slotBox.setEnabled(false);
        }
        this.notifyAllPropertyEditors(this);
    }

    public JPanel createLeftPane() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 5, 5));
        Dimension dimension = new Dimension(320, 320);
        jPanel.setPreferredSize(dimension);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), null, 1, 2));
        this.nameBox = new StringPropertyEditor("Name:");
        jPanel.add(this.nameBox);
        this.regularizePropertyEditor(this.nameBox);
        this.directionBox = new StringChoicePropertyEditor("Direction:", this.getAllDirectionsList());
        jPanel.add(this.directionBox);
        this.regularizePropertyEditor(this.directionBox);
        this.optChNumBox = new StringChoicePropertyEditor("OCHNC Wlen:", this.getAllOptChannelsList());
        jPanel.add(this.optChNumBox);
        this.regularizePropertyEditor(this.optChNumBox);
        this.statusBox = new StringChoicePropertyEditor("Status:", this.getAllStatusesList());
        jPanel.add(this.statusBox);
        this.regularizePropertyEditor(this.statusBox);
        this.serviceStateBox = new StringChoicePropertyEditor("State:", this.getAllServiceStatesList());
        jPanel.add(this.serviceStateBox);
        this.regularizePropertyEditor(this.serviceStateBox);
        this.protectionTypeBox = new StringChoicePropertyEditor("Protection:", this.getAllProtectionTypesList());
        jPanel.add(this.protectionTypeBox);
        this.regularizePropertyEditor(this.protectionTypeBox);
        this.shelfBox = new IntegerPropertyEditor("Shelf: ");
        jPanel.add(this.shelfBox);
        this.regularizePropertyEditor(this.shelfBox);
        if (!this.anyMSNe()) {
            this.shelfBox.setValue("");
            this.shelfBox.setEnabled(false);
            this.shelfBox.setVisible(false);
        }
        this.slotBox = new IntegerPropertyEditor("Slot: ");
        jPanel.add(this.slotBox);
        this.regularizePropertyEditor(this.slotBox);
        this.portBox = new StringPropertyEditor("Port: ");
        jPanel.add(this.portBox);
        this.regularizePropertyEditor(this.portBox);
        return jPanel;
    }

    public JPanel createRightPane() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 5, 5));
        Dimension dimension = new Dimension(320, 320);
        jPanel.setPreferredSize(dimension);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), null, 1, 2));
        this.typeBox = new StringChoicePropertyEditor("Type:", this.getAllTypesList());
        jPanel.add(this.typeBox);
        this.regularizePropertyEditor(this.typeBox);
        this.typeBox.addPropertyChangeListener(this);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("Size:");
        this.regularizePropertyEditor(jPanel2, jLabel, 211);
        jPanel3.add((Component)jLabel, "North");
        jPanel2.add((Component)jPanel3, "West");
        this.sizeList = new CheckableList();
        this.sizeList.setData(this.getAllCircuitSizes());
        this.sizeList.selectAll();
        this.regularizeCheckableList(this.sizeList, 9);
        jPanel2.add((Component)new JScrollPane(this.sizeList), "Center");
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void restoreDefaults() {
        this.nameBox.setValue("");
        this.directionBox.setValue(new Integer(-1));
        this.optChNumBox.setValue(new Integer(-1));
        this.statusBox.setValue(new Integer(-1));
        this.serviceStateBox.setValue(new Integer(-1));
        this.protectionTypeBox.setValue(new Integer(-1));
        this.shelfBox.setValue("");
        this.slotBox.setValue("");
        this.portBox.setValue("");
        this.typeBox.setValue(new Integer(-1));
        this.populateSizes();
        this.sizeList.selectAll();
        super.restoreDefaults();
    }

    public void load() {
        this.nameBox.setValue(this.filterCriteria.getName());
        this.directionBox.setValue(new Integer(this.filterCriteria.getDirection()));
        this.optChNumBox.setValue(new Integer(this.filterCriteria.getOptChannel()));
        this.statusBox.setValue(new Integer(this.filterCriteria.getStatus()));
        this.serviceStateBox.setValue(new Integer(this.filterCriteria.getServiceState()));
        this.protectionTypeBox.setValue(new Integer(this.filterCriteria.getProtectionType()));
        this.typeBox.setValue(new Integer(this.filterCriteria.getType()));
        this.setShelfNumber(this.filterCriteria.getShelf());
        this.setSlotNumber(this.filterCriteria.getSlot());
        this.setPortNumber(this.filterCriteria.getPort());
        this.populateSizes();
        int[] nArray = this.filterCriteria.getSize();
        if (nArray != null) {
            this.setSelectedSizes(nArray);
        } else {
            this.sizeList.selectAll();
        }
    }

    public void store() {
        this.filterCriteria.setName((String)this.nameBox.getValue());
        this.filterCriteria.setDirection(((Attribute)this.directionBox.getValue()).getIntValue());
        this.filterCriteria.setOptChannel(((Attribute)this.optChNumBox.getValue()).getIntValue());
        this.filterCriteria.setStatus(((Attribute)this.statusBox.getValue()).getIntValue());
        this.filterCriteria.setServiceState(((Attribute)this.serviceStateBox.getValue()).getIntValue());
        this.filterCriteria.setProtectionType(((Attribute)this.protectionTypeBox.getValue()).getIntValue());
        this.filterCriteria.setType(((CircuitTypeDisplayer)this.typeBox.getValue()).getCircuitTypeEnum());
        this.filterCriteria.setShelf(this.getShelfNumber());
        this.filterCriteria.setSlot(this.getSlotNumber());
        this.filterCriteria.setPort(this.getPortNumber());
        int[] nArray = this.getSelectedSizes();
        if (nArray.length < this.sizeList.getModel().getSize()) {
            this.filterCriteria.setSize(this.getSelectedSizes());
        } else {
            this.filterCriteria.setSize(null);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getSource() == this.typeBox) {
            this.populateSizes();
        }
    }

    public void dispose() {
        this.typeBox.removePropertyChangeListener(this);
        this.nameBox = null;
        this.shelfBox = null;
        this.slotBox = null;
        this.portBox = null;
        this.typeBox = null;
        this.directionBox = null;
        this.optChNumBox = null;
        this.statusBox = null;
        this.serviceStateBox = null;
        this.protectionTypeBox = null;
        this.sizeList = null;
        this.removeAll();
    }

    public String getShelfString() {
        return (String)this.shelfBox.getValue();
    }

    public int getShelfNumber() {
        String string = this.getShelfString();
        if (string != null && string.length() > 0) {
            return Integer.parseInt(string);
        }
        return -1;
    }

    protected void setShelfNumber(int n) {
        if (n > 0) {
            this.shelfBox.setValue(new Integer(n).toString());
        }
    }

    public String getSlotString() {
        return (String)this.slotBox.getValue();
    }

    public int getSlotNumber() {
        String string = this.getSlotString();
        if (string != null && string.length() > 0) {
            return Integer.parseInt(string);
        }
        return -1;
    }

    protected void setSlotNumber(int n) {
        if (n > 0) {
            this.slotBox.setValue(new Integer(n).toString());
        }
    }

    public String getPortString() {
        return ((String)this.portBox.getValue()).trim();
    }

    public int[] getPortNumber() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getPortString(), "-");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            Integer.parseInt(string);
            arrayList.add(string);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return CircuitFilterCriteriaPreferences.strArr2intArr(arrayList.toArray(new String[0]));
    }

    protected void setPortNumber(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] >= 0) continue;
                return;
            }
            this.portBox.setValue(PortHelper.getConcatenatedString((int[])nArray, (char)'-'));
        }
    }

    protected int[] getSelectedSizes() {
        List list = this.sizeList.getSelectedObjects();
        int[] nArray = new int[list.size()];
        nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            CircuitSize circuitSize = (CircuitSize)list.get(i);
            nArray[i] = circuitSize.getEnum();
        }
        return nArray;
    }

    protected void setSelectedSizes(int[] nArray) {
        ArrayList<ICircuitSize> arrayList = new ArrayList<ICircuitSize>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(CircuitSize.getCircuitSize((int)nArray[i]));
        }
        this.sizeList.setSelectedObjects(arrayList);
    }

    private void populateSizes() {
        try {
            CircuitTypeDisplayer circuitTypeDisplayer = (CircuitTypeDisplayer)this.typeBox.getValue();
            int n = ((CircuitTypeDisplayer)this.typeBox.getValue()).getCircuitTypeEnum();
            List list = n < 0 ? this.getAllCircuitSizes() : this.getCircuitSizesForType((ICircuitType)circuitTypeDisplayer.getCircuitType());
            this.sizeList.unselectAll();
            this.sizeList.enableSelectedObjects(list);
            this.sizeList.setSelectedObjects(list);
            this.repaint();
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
    }

    protected List getAllTypesList() {
        ArrayList<CircuitTypeDisplayer> arrayList = new ArrayList<CircuitTypeDisplayer>();
        arrayList.add(new CircuitTypeDisplayer("Any"));
        Iterator iterator = CircuitCreationWizard.getNetSupportedCktTypes().iterator();
        while (iterator.hasNext()) {
            arrayList.add(new CircuitTypeDisplayer((CircuitType)iterator.next()));
        }
        return arrayList;
    }

    protected List getAllCircuitSizes() {
        FramingType[] framingTypeArray = Network.instance().getSupportedFramingTypes();
        Object[] objectArray = CircuitSize.getCircuitSizes((FramingType[])framingTypeArray);
        Arrays.sort(objectArray);
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(Arrays.asList(objectArray));
        hashSet.addAll(this.getCircuitSizesForType(9));
        hashSet.addAll(this.getCircuitSizesForType(14));
        hashSet.addAll(this.getCircuitSizesForType(15));
        hashSet.addAll(this.getCircuitSizesForType(15));
        hashSet.remove(CircuitSize.SIZE_NULL);
        return new ArrayList(hashSet);
    }

    protected List getCircuitSizesForType(int n) {
        return this.getCircuitSizesForType(CircuitType.getCircuitType((int)n));
    }

    protected List getCircuitSizesForType(ICircuitType iCircuitType) {
        FramingType[] framingTypeArray = Network.instance().getSupportedFramingTypes();
        ICircuitSize[] iCircuitSizeArray = CircuitSize.getCircuitSizes((int)iCircuitType.getEnum(), (FramingType[])framingTypeArray);
        ArrayList<ICircuitSize> arrayList = new ArrayList<ICircuitSize>(Arrays.asList(iCircuitSizeArray));
        return arrayList;
    }

    private List getAllDirectionsList() {
        List list = NetworkDefaults.getAttributeMap().getAttributeList("circuitDirection");
        list.add(0, new Attribute("Any", -1));
        return list;
    }

    private List getAllOptChannelsList() {
        Attribute[] attributeArray = Wavelength.getDwdmWavelengthAttrs();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        arrayList.addAll(Arrays.asList(attributeArray));
        arrayList.add(0, new Attribute("Any", -1));
        return arrayList;
    }

    private ArrayList getAllStatusesList() {
        TreeMap treeMap = (TreeMap)((TreeMap)NetworkDefaults.getAttributeMap().get("circuitState")).clone();
        treeMap.remove(new Integer(0));
        treeMap.remove(new Integer(2));
        treeMap.remove(new Integer(7));
        Object[] objectArray = treeMap.values().toArray();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(Arrays.asList(objectArray));
        arrayList.add(0, new Attribute("Any", -1));
        return arrayList;
    }

    private ArrayList getAllServiceStatesList() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        arrayList.addAll(Arrays.asList(NetServiceState.getNetCircuitServiceStateAttrs()));
        arrayList.add(0, new Attribute("Any", -1));
        return arrayList;
    }

    private ArrayList getAllProtectionTypesList() {
        TreeMap treeMap = (TreeMap)((TreeMap)NetworkDefaults.getAttributeMap().get("circuitProtectionType")).clone();
        treeMap.remove(new Integer(2));
        treeMap.remove(new Integer(10));
        treeMap.remove(new Integer(15));
        treeMap.remove(new Integer(19));
        Object[] objectArray = treeMap.values().toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((Attribute)object).getKey();
                String string2 = ((Attribute)object2).getKey();
                if (string != null && string2 != null) {
                    return string.compareTo(string2);
                }
                return 0;
            }
        });
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(Arrays.asList(objectArray));
        arrayList.add(0, new Attribute("Any", -1));
        return arrayList;
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.CircuitFilterGeneralPane;
    }

    private boolean anyMSNe() {
        boolean bl = false;
        for (INetElement iNetElement : Network.instance().getAllElements()) {
            INodeModel iNodeModel = iNetElement.getNodeModel();
            if (!Feature.delegateProvides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF) || !iNodeModel.isMultishelf()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean onValidate() {
        EID eID = null;
        try {
            eID = NEMC.EID_INVALID_SLOT_NUMBER;
            this.getSlotNumber();
            eID = NEMC.EID_INVALID_PORT_NUMBER;
            this.getPortNumber();
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMsg.displayError((Component)this, (EID)eID);
            return false;
        }
        return true;
    }
}

