/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.ncp.INetCircuit;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CircuitSearchDialog
extends UDialog
implements ActionListener,
DocumentListener {
    private static final SDebug db = new SDebug("CircuitSearchDialog");
    protected Vector circuitsVector;
    protected JTable table;
    protected JButton findNextButton;
    protected JButton cancelButton;
    protected JCheckBox fullWordButton;
    protected JCheckBox caseSensitiveButton;
    protected JRadioButton upButton;
    protected JRadioButton downButton;
    protected JTextField searchField;
    protected JComponent parent;
    protected INetCircuit selectedCircuit;
    protected boolean caseSensitiveSearch = false;
    protected boolean fullWordSearch = false;
    protected boolean downSearch = true;
    protected UScrollPane scrollPane;
    static Dimension BUTTONSIZE = new Dimension(90, 23);

    public static CircuitSearchDialog instance(JComponent jComponent, JTable jTable, UScrollPane uScrollPane, Vector vector) {
        Frame frame = JOptionPane.getFrameForComponent(jComponent);
        String string = "Circuit Name Search";
        CircuitSearchDialog circuitSearchDialog = new CircuitSearchDialog(frame, string);
        circuitSearchDialog.setSize(480, 140);
        circuitSearchDialog.setTable(jTable);
        circuitSearchDialog.setCircuitsVector(vector);
        circuitSearchDialog.setScrollPane(uScrollPane);
        circuitSearchDialog.parent = jComponent;
        return circuitSearchDialog;
    }

    protected CircuitSearchDialog(Frame frame, String string) {
        super(frame, string, true);
    }

    public void dispose() {
        this.circuitsVector = null;
        this.parent = null;
        this.table = null;
        this.scrollPane = null;
        super.dispose();
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    public void setCircuitsVector(Vector vector) {
        this.circuitsVector = vector;
    }

    protected void setScrollPane(UScrollPane uScrollPane) {
        this.scrollPane = uScrollPane;
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        GridBagPanel gridBagPanel = new GridBagPanel();
        JLabel jLabel = new JLabel("Find What:  ");
        this.findNextButton = new JButton("Find Next");
        this.findNextButton.setMnemonic('f');
        this.cancelButton = new JButton("Cancel");
        this.findNextButton.setPreferredSize(BUTTONSIZE);
        this.cancelButton.setPreferredSize(BUTTONSIZE);
        this.findNextButton.setMinimumSize(BUTTONSIZE);
        this.cancelButton.setMinimumSize(BUTTONSIZE);
        this.searchField = new JTextField(25);
        jLabel.setLabelFor(this.searchField);
        jLabel.setDisplayedMnemonic('n');
        this.findNextButton.setEnabled(false);
        this.fullWordButton = new JCheckBox("Match whole word only");
        this.fullWordButton.setMnemonic('w');
        this.caseSensitiveButton = new JCheckBox("Match case");
        this.caseSensitiveButton.setMnemonic('c');
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jLabel);
        jPanel2.add(this.searchField);
        gridBagPanel.add((Component)new JLabel(), 0, 0);
        gridBagPanel.add((Component)new JLabel(), 0, 1);
        gridBagPanel.add((Component)new JLabel(), 0, 2);
        gridBagPanel.add((Component)jPanel2, 1, 0);
        gridBagPanel.anchorEast();
        gridBagPanel.add(this.findNextButton, 2, 0, 2, 1);
        gridBagPanel.anchorWest();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.upButton = new JRadioButton("Up");
        this.upButton.setMnemonic('u');
        this.downButton = new JRadioButton("Down");
        this.downButton.setMnemonic('d');
        buttonGroup.add(this.upButton);
        buttonGroup.add(this.downButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.setBorder(BorderFactory.createTitledBorder("Direction"));
        jPanel3.add(this.upButton);
        jPanel3.add(this.downButton);
        GridBagPanel gridBagPanel2 = new GridBagPanel();
        gridBagPanel2.anchorWest();
        gridBagPanel2.add((Component)this.fullWordButton, 0, 0);
        gridBagPanel2.add((Component)this.caseSensitiveButton, 0, 1);
        gridBagPanel2.anchorEast();
        gridBagPanel2.add(jPanel3, 1, 0, 2, 2);
        gridBagPanel.anchorWest();
        gridBagPanel.add((Component)gridBagPanel2, 1, 1);
        gridBagPanel.anchorEast();
        gridBagPanel.add(this.cancelButton, 2, 1, 2, 1);
        gridBagPanel.anchorEast();
        gridBagPanel.add((Component)new JLabel(), 3, 0);
        gridBagPanel.add((Component)new JLabel(), 3, 1);
        gridBagPanel.add((Component)new JLabel(), 3, 2);
        jPanel.add(gridBagPanel);
        this.searchField.getDocument().addDocumentListener(this);
        this.searchField.addActionListener(this);
        this.findNextButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.caseSensitiveButton.addActionListener(this);
        this.fullWordButton.addActionListener(this);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.resetSelections();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cancelButton) {
            this.dispose();
        }
        if (object == this.findNextButton) {
            this.findNext();
        }
        if (object == this.fullWordButton) {
            this.fullWordSearch = this.fullWordButton.isSelected();
        }
        if (object == this.caseSensitiveButton) {
            this.caseSensitiveSearch = this.caseSensitiveButton.isSelected();
        }
        if (object == this.upButton) {
            this.downSearch = false;
        }
        if (object == this.downButton) {
            this.downSearch = true;
        }
        if (object == this.searchField && this.searchField.getText().trim().length() > 0) {
            this.findNextButton.doClick();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.findNextButton.setEnabled(documentEvent.getDocument().getLength() > 0);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    protected boolean compare(String string, String string2) {
        if (!this.caseSensitiveSearch) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (this.fullWordSearch) {
            return string.equals(string2);
        }
        return string.indexOf(string2) > -1;
    }

    protected void scrollTableToSelected(int n) {
        if (this.scrollPane == null) {
            db.println("scrollTable to " + n + " but scrollpane== null!");
            return;
        }
        if (this.scrollPane.getViewport() == null) {
            db.println("scrollTable to " + n + " but viewport==null!");
            return;
        }
        if (n < 0) {
            return;
        }
        int n2 = this.table.getRowHeight() * n + this.table.getRowMargin() * (n - 1);
        int n3 = (int)this.scrollPane.getViewport().getExtentSize().getHeight();
        int n4 = (int)this.scrollPane.getViewport().getViewPosition().getY();
        int n5 = n4 + n3;
        if (CircuitSearchDialog.db.on) {
            db.println("Y span is      : " + n2 + "-" + n5);
            db.println("Top ViewPort is: " + n4);
            db.println("Height is      : " + n3);
        }
        if (n2 < n4 || n2 > n5) {
            if (CircuitSearchDialog.db.on) {
                db.println("Changing viewport to " + n2);
                db.println("-+ verify: top viewport is " + (int)this.scrollPane.getViewport().getViewPosition().getY());
            }
            int n6 = (int)this.scrollPane.getViewport().getExtentSize().getWidth();
            this.table.scrollRectToVisible(new Rectangle(0, n2, n6, n3));
        }
    }

    public int findNext() {
        Object object;
        int n = -1;
        int n2 = this.circuitsVector.size();
        boolean bl = false;
        String string = this.searchField.getText();
        if (this.table.getSelectedRow() != -1 && this.selectedCircuit != null && (n = this.circuitsVector.indexOf(this.selectedCircuit)) == -1) {
            this.selectedCircuit = null;
            CerentDialog.infoDialog((Component)((Object)this), (String)"The selected circuit was deleted.\nThe search will be restarted beginning.", (String)"Selected circuit was deleted");
        }
        this.scrollTableToSelected(n);
        if (n2 > 0) {
            if (n == -1) {
                this.table.setRowSelectionInterval(0, 0);
            } else {
                this.table.setRowSelectionInterval(n, n);
            }
        }
        if (this.downSearch) {
            ++n;
            while (n < n2) {
                object = (INetCircuit)this.circuitsVector.elementAt(n);
                String string2 = object.getCircuitName();
                if (this.compare(string2, string)) {
                    bl = true;
                    this.selectedCircuit = object;
                    break;
                }
                ++n;
            }
        } else {
            --n;
            while (n >= 0) {
                object = (INetCircuit)this.circuitsVector.elementAt(n);
                String string3 = object.getCircuitName();
                if (this.compare(string3, string)) {
                    bl = true;
                    this.selectedCircuit = object;
                    break;
                }
                --n;
            }
        }
        if (bl) {
            this.scrollTableToSelected(n);
            this.table.setRowSelectionInterval(n, n);
            return n;
        }
        object = this.fullWordSearch ? "Cannot Find Circuit " : "Cannot Find Circuit Containing ";
        CerentDialog.infoDialog((Component)((Object)this), (String)"Finished Searching Circuits.", (String)((String)object + "\"" + string + "\""));
        this.requestFocus();
        return -1;
    }

    public void setSelectedCircuit(INetCircuit iNetCircuit) {
        this.selectedCircuit = iNetCircuit;
        int n = -1;
        if (this.selectedCircuit != null) {
            INetCircuit iNetCircuit2;
            n = this.circuitsVector.indexOf(this.selectedCircuit);
            int n2 = this.table.getSelectedRow();
            INetCircuit iNetCircuit3 = iNetCircuit2 = n2 >= 0 ? (INetCircuit)this.table.getValueAt(n2, 0) : null;
            if (iNetCircuit2 == null || iNetCircuit2 != this.selectedCircuit) {
                this.table.setRowSelectionInterval(n, n);
            }
        }
        if (n < 0) {
            this.scrollTableToSelected(0);
        } else {
            this.scrollTableToSelected(n);
        }
    }

    public INetCircuit getSelectedCircuit() {
        return this.selectedCircuit;
    }

    protected void resetSelections() {
        this.downButton.doClick();
        this.fullWordButton.setSelected(false);
        this.fullWordSearch = false;
        this.caseSensitiveButton.setSelected(false);
        this.caseSensitiveSearch = false;
    }
}

