/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ui.NetworkProvPane;
import cerent.cms.ui.circuits.CircuitEditTabbedView;
import cerent.cms.ui.ppc.CombosCellRenderer;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.IPoDWDMUtility;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class CoordMaintPortsPane
extends NetworkProvPane {
    private INetCircuit ckt;
    private SortableRowTableModel model;
    private CoordMaintPortsDataSource source;
    private IPoDWDMUtility dwdmUtil;
    private static final String SHELF_STRING = "Shelf ";
    private static final String SLOT_STRING = "Slot ";
    private static final String PORT_STRING = "Port ";
    private static final char SEPARATOR = '/';
    public static final String[] columnNames = new String[]{"Node", "Node IP", "Port"};
    public static final int NODE_NAME = 0;
    public static final int NODE_IP = 1;
    public static final int PORT_IN_MAINT = 2;

    public CoordMaintPortsPane(String string, CircuitEditTabbedView circuitEditTabbedView) {
        super(string, circuitEditTabbedView);
        try {
            NetCircuitModel netCircuitModel = (NetCircuitModel)circuitEditTabbedView.getUiModel();
            this.ckt = netCircuitModel.getNetCircuit();
            this.dwdmUtil = IPoDWDMUtility.instance();
            this.source = new CoordMaintPortsDataSource(this.ckt);
            ColumnRenderer[] columnRendererArray = this.createColumnRenderers();
            this.model = new SortableRowTableModel((RowDataSource)this.source, columnRendererArray, CoordMaintPortsRowObject.class);
            this.table = new UTable((TableModel)((Object)this.model));
            this.model.initTable(this.table);
            this.table.setSelectionMode(0);
            UScrollPane uScrollPane = new UScrollPane((Component)this.table);
            this.add((Component)uScrollPane, "Center");
        }
        catch (Exception exception) {
            ErrorMsg.displayError(null, (EID)NEMC.EID_INITIALIZATION_ERROR);
        }
    }

    public boolean hasSubTabs() {
        return true;
    }

    private ColumnRenderer[] createColumnRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[columnNames.length];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = this.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    private ColumnRenderer createColumnRenderer(int n) {
        SideColumnRenderer sideColumnRenderer = null;
        switch (n) {
            case 0: {
                sideColumnRenderer = new SideColumnRenderer(n, 120, true, 2);
                break;
            }
            case 1: {
                sideColumnRenderer = new SideColumnRenderer(n, 120, true, 2);
                break;
            }
            case 2: {
                sideColumnRenderer = new SideColumnRenderer(n, 300, true, 2);
                break;
            }
        }
        return sideColumnRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (db.on()) {
            db.println("dispose");
        }
        this.model.release();
        this.model = null;
        this.source = null;
        CoordMaintPortsPane coordMaintPortsPane = this;
        synchronized (coordMaintPortsPane) {
            this.ckt = null;
        }
        super.destroy();
    }

    private class CoordMaintPortsRowObject {
        private INodeModel nodeModel;
        private String nodeName;
        private String nodeIp;
        private int shelfId;
        private String slot;
        private String port;

        CoordMaintPortsRowObject(INodeModel iNodeModel, String string, String string2, int n, String string3, String string4) {
            this.nodeModel = iNodeModel;
            this.nodeName = string;
            this.nodeIp = string2;
            this.shelfId = n;
            this.slot = string3;
            this.port = string4;
        }

        public INodeModel getNodeModel() {
            return this.nodeModel;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getNodeIp() {
            return this.nodeIp;
        }

        public int getShelfId() {
            return this.shelfId;
        }

        public String getSlot() {
            return this.slot;
        }

        public String getPort() {
            return this.port;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CoordMaintPortsDataSource
    extends AbstractRowDataSource
    implements IObserver {
        private ArrayList<CoordMaintPortsRowObject> rows = new ArrayList();
        private SDebug sdb = new SDebug("CoordMaintPortsDataSource");
        private INetCircuit ckt;

        public CoordMaintPortsDataSource(INetCircuit iNetCircuit) {
            this.ckt = iNetCircuit;
            this.refresh();
        }

        public void update(IObservable iObservable, Object object) {
            block3: {
                try {
                    if (iObservable instanceof INodeModel) {
                        this.refresh();
                    }
                }
                catch (Exception exception) {
                    if (!this.sdb.on()) break block3;
                    this.sdb.println("update(): exception" + exception);
                }
            }
        }

        public void refresh() {
            if (this.sdb.on()) {
                this.sdb.println("Refreshing the data source.");
            }
            this.deleteAll();
            List list = CoordMaintPortsPane.this.dwdmUtil.filterDuplicateNodes(this.ckt.getCircuitNodes());
            String string = null;
            for (int i = 0; i < list.size(); ++i) {
                try {
                    NetCircuitNode netCircuitNode = (NetCircuitNode)list.get(i);
                    INodeModel iNodeModel = netCircuitNode.getNodeModel();
                    if (!CoordMaintPortsPane.this.dwdmUtil.doesSupportSRLGAndCoMFeature(iNodeModel)) continue;
                    string = iNodeModel.getName();
                    String string2 = InetUtil.makeDottedString(iNodeModel.getIpConfig().getIpAddress());
                    int[] nArray = iNodeModel.getCoordMaintList();
                    iNodeModel.addObserver((IObserver)this);
                    IEntityModel iEntityModel = null;
                    if (nArray == null) continue;
                    for (int j = 0; j < nArray.length; ++j) {
                        iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(nArray[j]);
                        for (IConnectionModel iConnectionModel : iEntityModel.getConnectionsList()) {
                            if (!iConnectionModel.getCircuitId().equals(this.ckt.getCircuitId())) continue;
                            this.rows.add(new CoordMaintPortsRowObject(iNodeModel, string, string2, iEntityModel.getShelfId(), CombosCellRenderer.toString(iEntityModel.getModuleModel()), CombosCellRenderer.toString(iEntityModel, true, false)));
                        }
                    }
                    continue;
                }
                catch (Exception exception) {
                    if (!db.on()) continue;
                    db.println("Error occurred. Skipping Node: " + string);
                    KDebug.printStackTrace((Throwable)exception);
                }
            }
            this.changed();
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Object getObjectAtRow(int n) {
            try {
                return this.rows.get(n);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public Collection<CoordMaintPortsRowObject> getAllObjects() {
            return this.rows;
        }

        public void changed() {
            this.fireDataSourceChanged();
        }

        private void deleteAll() {
            CoordMaintPortsRowObject coordMaintPortsRowObject = null;
            for (int i = 0; i < this.rows.size(); ++i) {
                coordMaintPortsRowObject = this.rows.get(i);
                coordMaintPortsRowObject.getNodeModel().deleteObserver((IObserver)this);
            }
            this.rows.clear();
        }
    }

    private class SideColumnRenderer
    extends AbstractColumnRenderer {
        public SideColumnRenderer(int n, int n2, boolean bl, int n3) {
            super(columnNames[n], n2, bl, n3);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            CoordMaintPortsRowObject coordMaintPortsRowObject = (CoordMaintPortsRowObject)object;
            object = this.getColumnContents(coordMaintPortsRowObject, n2);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            return defaultTableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        private String getColumnContents(CoordMaintPortsRowObject coordMaintPortsRowObject, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = null;
            switch (n) {
                case 0: {
                    string = coordMaintPortsRowObject.getNodeName();
                    stringBuffer.append(string);
                    break;
                }
                case 1: {
                    string = coordMaintPortsRowObject.getNodeIp();
                    stringBuffer.append(string);
                    break;
                }
                case 2: {
                    string = coordMaintPortsRowObject.getPort();
                    stringBuffer.append(CoordMaintPortsPane.SHELF_STRING);
                    stringBuffer.append(coordMaintPortsRowObject.getShelfId());
                    stringBuffer.append('/');
                    String string2 = coordMaintPortsRowObject.getSlot();
                    if (!string2.regionMatches(true, 0, CoordMaintPortsPane.SLOT_STRING, 0, 4)) {
                        stringBuffer.append(CoordMaintPortsPane.SLOT_STRING);
                        stringBuffer.append(string2);
                    } else {
                        stringBuffer.append(string2.replace(string2.substring(0, 5), CoordMaintPortsPane.SLOT_STRING));
                    }
                    stringBuffer.append('/');
                    stringBuffer.append(CoordMaintPortsPane.PORT_STRING);
                    stringBuffer.append(string);
                    break;
                }
            }
            return stringBuffer.toString();
        }

        public int compareColumn(Object object, Object object2, int n) {
            CoordMaintPortsRowObject coordMaintPortsRowObject = (CoordMaintPortsRowObject)object;
            CoordMaintPortsRowObject coordMaintPortsRowObject2 = (CoordMaintPortsRowObject)object2;
            String string = this.getColumnContents(coordMaintPortsRowObject, n);
            String string2 = this.getColumnContents(coordMaintPortsRowObject2, n);
            return string.compareTo(string2);
        }
    }
}

