/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IPathStateInfo;
import cerent.cms.ui.circuits.HoSlicePane;
import cerent.util.HoLoNum;
import cerent.util.IHoLoNum;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class HoLoSlice
extends JToggleButton
implements ActionListener {
    private static final String IMG_BLUE_CHECK = "/images/check_blue.gif";
    private ImageIcon IMG_CHECK = new ImageIcon(this.getClass().getResource("/images/check_blue.gif"));
    private final Border SELECTED_BORDER = BorderFactory.createBevelBorder(1, Color.black, Color.black);
    public static final int STATE_UNAVAILABLE = 0;
    public static final int STATE_AVAILABLE = 1;
    public static final int STATE_USED = 2;
    public static final int STATE_NOT_SELECTABLE = 3;
    public static final int STATE_SELECTED = 4;
    public static final int STATE_CURRENT_SELECTED = 5;
    public static final int TYPE_HO = 1;
    public static final int TYPE_LO = 2;
    public static final Color COLOR_AVAILABLE = Color.white;
    public static final Color COLOR_USED = Color.blue;
    private int state = 1;
    private int type = 1;
    private boolean isSonet = true;
    private HoSlicePane slicePane = null;
    private Border origBorder = null;
    private IHoLoNum holoNum = null;
    private IPathStateInfo pathStateInfo = null;
    private static final SDebug db = new SDebug("HoLoSlice");

    public HoLoSlice(HoSlicePane hoSlicePane, IPathStateInfo iPathStateInfo, int n, boolean bl) {
        this.slicePane = hoSlicePane;
        this.pathStateInfo = iPathStateInfo;
        this.state = iPathStateInfo.getPathState();
        this.type = n;
        this.isSonet = bl;
        this.origBorder = this.getBorder();
        this.init();
        if (db.on()) {
            db.println("HoLoSlice: " + this.toString());
        }
    }

    private void init() {
        this.holoNum = new HoLoNum(this.pathStateInfo.getHoNum(), this.pathStateInfo.getLoNum());
        if (this.type == 1) {
            this.setText(Integer.toString(this.getNumber()));
        } else {
            String string = Integer.toString(this.getNumber());
            int n = this.getGroupNumber();
            if (n >= 0) {
                String string2 = Integer.toString(n);
                this.setText(string2 + "-" + string);
            } else {
                this.setText(string);
            }
        }
        this.setIconTextGap(0);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.setVerticalAlignment(3);
        this.setPreferredSize(new Dimension(32, 34));
        this.setToolTipText();
        this.addActionListener(this);
        this.setColor(this.state);
        this.setEnabled(this.state);
    }

    public int getInternalNumber() {
        int n = this.getNumber();
        if (this.getType() == 2) {
            n = this.pathStateInfo.getLoNum().getIdlFlatNum();
        }
        return n;
    }

    public int getState() {
        return this.state;
    }

    public int getGroupNumber() {
        int n = -1;
        if (this.getType() == 2) {
            n = this.slicePane.getCircuitInfo().size() == 11 ? -1 : (int)this.pathStateInfo.getLoNum().getIdlGroupNum();
        }
        return n;
    }

    public int getNumber() {
        int n = -1;
        n = this.getType() == 1 ? (int)this.pathStateInfo.getHoNum().getHoNum() : (this.slicePane.getCircuitInfo().size() == 11 ? this.getVc3Number() : (int)this.pathStateInfo.getLoNum().getIdlNumInGroup());
        return n;
    }

    public int getVc4Number() {
        return this.getNumber();
    }

    public int getVc3Number() {
        int n = -1;
        if (this.getType() == 2) {
            n = this.pathStateInfo.getLoNum().getVc3OrSts1();
        }
        return n;
    }

    public int getTug3Number() {
        return 1;
    }

    public int getTug2Number() {
        int n = -1;
        if (this.getType() == 2) {
            n = this.pathStateInfo.getLoNum().getTug2OrVtGroupNum();
        }
        return n;
    }

    public int getType() {
        return this.type;
    }

    public boolean isSonet() {
        return this.isSonet;
    }

    public void showIcon(boolean bl) {
        if (bl) {
            this.setIcon(this.IMG_CHECK);
        } else {
            this.setIcon(null);
        }
    }

    public IHoLoNum getHoLoNum() {
        return this.holoNum;
    }

    public void setColor(int n) {
        this.setBackground(this.getColor(n));
    }

    public void processClick() {
        HoLoSlice hoLoSlice = this.slicePane.getSelectedSlice();
        if (hoLoSlice != null && !hoLoSlice.isSameAs(this) && hoLoSlice.getState() != 1) {
            if (db.on()) {
                db.println("Setting state for previous selected slice" + hoLoSlice.toString());
            }
            hoLoSlice.setState(4, false);
        }
        this.setState(this.getInternalState(this), true);
    }

    public void setState(int n, boolean bl) {
        HoLoSlice hoLoSlice;
        this.state = n;
        if (db.on()) {
            db.println("Setting state on " + this.toString());
        }
        if (n == 4 || n == 5) {
            if (this.getType() == 1) {
                if (!this.slicePane.hasLo()) {
                    this.showIcon(true);
                }
                if (n == 5) {
                    this.setSelected(true);
                    this.setBorder(this.SELECTED_BORDER);
                } else {
                    this.setSelected(false);
                    this.setBorder(this.origBorder);
                }
            } else {
                this.showIcon(true);
                this.setSelected(false);
                this.setBorder(this.origBorder);
            }
        } else {
            this.setSelected(false);
            this.setIcon(null);
            this.setBorder(this.origBorder);
        }
        this.slicePane.setSelectedSlice(this, bl);
        if (this.getType() == 2 && (hoLoSlice = this.slicePane.getSelectedHoSlice()) != null) {
            LinkedList linkedList = this.slicePane.getSelectedSliceList(hoLoSlice);
            boolean bl2 = false;
            if (linkedList != null) {
                boolean bl3 = bl2 = !linkedList.isEmpty();
                if (db.on()) {
                    db.println("HO " + hoLoSlice.toString() + " has selected LO");
                }
            }
            hoLoSlice.showIcon(bl2);
        }
    }

    public void setEnabled(int n) {
        switch (n) {
            case 0: 
            case 2: 
            case 3: {
                this.setEnabled(false);
                this.setContentAreaFilled(false);
                this.setOpaque(true);
                if (System.getProperty("os.name").equals("Windows XP")) {
                    Border border = BorderFactory.createLineBorder(Color.black);
                    Border border2 = BorderFactory.createLineBorder(this.slicePane.getBackground());
                    this.setBorder(BorderFactory.createCompoundBorder(border2, border));
                    break;
                }
                this.setBorder(BorderFactory.createLineBorder(Color.black));
                break;
            }
            default: {
                this.setEnabled(true);
            }
        }
    }

    public void setToolTipText() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.slicePane.getCircuitInfo().type();
        if (n == 10) {
            stringBuilder.append("STS: " + this.getNumber());
        } else if (n == 11) {
            if (this.type == 1) {
                stringBuilder.append("STS: " + this.getNumber());
            } else {
                stringBuilder.append("VTG: " + this.getGroupNumber());
                stringBuilder.append(", VT: " + this.getNumber());
            }
        } else if (n == 12) {
            stringBuilder.append("VC4: " + this.getNumber());
        } else if (n == 13) {
            int n2 = this.slicePane.getCircuitInfo().size();
            if (n2 == 11) {
                if (this.type == 1) {
                    stringBuilder.append("VC4: " + this.getNumber());
                } else {
                    stringBuilder.append("VC3: " + this.getNumber());
                }
            } else if (n2 == 10) {
                if (this.type == 1) {
                    stringBuilder.append("VC4: " + this.getNumber());
                } else {
                    stringBuilder.append("TUG3: " + this.getTug3Number());
                    stringBuilder.append(", TUG2: " + this.getTug2Number());
                    stringBuilder.append(", VC12: " + this.getNumber());
                }
            }
        }
        this.setToolTipText(stringBuilder.toString() + ", State: " + HoLoSlice.stateToString(this.getState()));
    }

    public Color getColor(int n) {
        Color color = null;
        switch (n) {
            case 0: 
            case 3: {
                color = COLOR_AVAILABLE.darker().darker();
                break;
            }
            case 2: {
                color = COLOR_USED;
                break;
            }
        }
        return color;
    }

    public int getInternalState(HoLoSlice hoLoSlice) {
        int n = hoLoSlice.getState();
        switch (n) {
            case 1: {
                if (!this.slicePane.hasLo()) {
                    n = 4;
                    break;
                }
                n = 5;
                break;
            }
            case 5: {
                n = 1;
                break;
            }
            case 4: {
                if (!this.slicePane.hasLo()) {
                    n = 1;
                    break;
                }
                n = 5;
                break;
            }
        }
        return n;
    }

    public boolean isFormOfSelected(HoLoSlice hoLoSlice) {
        int n = hoLoSlice.getState();
        return n == 4 || n == 5;
    }

    public static String stateToString(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "Available";
                break;
            }
            case 5: {
                string = "Currently Selected";
                break;
            }
            case 4: {
                string = "Selected";
                break;
            }
            case 0: {
                string = "Unavailable";
                break;
            }
            case 2: {
                string = "Used";
                break;
            }
            case 3: {
                string = "Not Selectable";
                break;
            }
        }
        return string;
    }

    public boolean isSameAs(HoLoSlice hoLoSlice) {
        return this.getNumber() == hoLoSlice.getNumber() && this.getGroupNumber() == hoLoSlice.getGroupNumber() && this.getTug3Number() == hoLoSlice.getTug3Number() && this.getTug2Number() == hoLoSlice.getTug2Number();
    }

    public String toString() {
        return String.valueOf("Grp: " + this.getGroupNumber() + ", Tug3: " + this.getTug3Number() + ", Vtg/Tug2: " + this.getTug2Number() + ", Vc3: " + this.getVc3Number() + ", Num: " + this.getNumber() + ", St: " + HoLoSlice.stateToString(this.getState()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.processClick();
    }
}

