/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractProvPane;
import cerent.cms.ui.LeavePageException;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.circuits.IJTrace;
import cerent.cms.ui.circuits.J1PathTrace;
import cerent.cms.ui.circuits.J2PathTrace;
import cerent.cms.ui.circuits.TrailTraceIdentifier;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.PathTraceUtil;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.WID;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class JnProvPane
extends AbstractProvPane
implements ActionListener,
DocumentListener {
    private static final SDebug db = new SDebug("JnProvPane");
    public static final int NUM_J0 = 0;
    public static final int NUM_J1 = 1;
    public static final int NUM_J2 = 2;
    public static final int NUM_TTI = 3;
    private static final int LENGTH_1 = 1;
    private static final int LENGTH_16 = 15;
    private static final int LENGTH_64 = 62;
    public static final int CONVERT_TO_TEXT = 0;
    public static final int CONVERT_TO_HEX = 1;
    private static final int UNIDIRECTIONAL = 0;
    protected static final String JN_OFF = "Off/None";
    protected static final String JN_AUTO = "Auto";
    protected static final String JN_MANUAL = "Manual";
    private static final String J2_TIM = "This might cause TIM-V to be raised.";
    private static final String J1_TIM = "This might cause TIM-P to be raised, which can result in a loss of\nservice on the circuit.";
    private static final String TTI_DISABLE_FDI_OTN = "Disable FDI on TTIM?";
    private static final String REFRESH = "Refresh";
    protected static final String[] modeChoices = new String[]{"Off/None", "Auto", "Manual"};
    protected static final String[] modeChoicesNoAuto = new String[]{"Off/None", "Manual"};
    protected static final String[] modeChoicesOnlyNone = new String[]{"Off/None"};
    protected static final String PORT_COMMAND = "PORT_COMMAND";
    protected static final String TRACEMODE_COMMAND = "TRACEMODE_SWITCH";
    protected static final String ASCIIMODE = "ASCII Mode";
    protected static final String HEXMODE = " Hex Mode ";
    protected static final String FACTORY_DEFAULT = "FACTORY_DEFAULT";
    protected static final String RECEIVED_C2 = "Received C2: ";
    protected static final String RECEIVED_V5 = "Received LO Signal Label: ";
    protected static final String EXPECTED_C2 = "Expected C2: ";
    protected static final String EXPECTED_V5 = "Expected LO Signal Label: ";
    protected static final String JN_STRINGSIZE = "Path Trace String Size";
    protected static final String JN_STRINGSIZE_16 = "16 byte";
    protected static final String JN_STRINGSIZE_64 = "64 byte";
    protected static final String HEX = "Hex (1 byte)";
    protected static final String ASCII = "ASCII";
    public static final String TRANSMIT_SWITCH = "TRANSMIT_SWITCH";
    public static final String EXPECTED_SWITCH = "EXPECTED_SWITCH";
    public static final String RECEIVED_SWITCH = "RECEIVED_SWITCH";
    public int maxStringLength = 62;
    public static final String SND_RETRIEVE_FAILURE = "<unable to retrieve transmit path trace from card>";
    public static final String EXP_RETRIEVE_FAILURE = "<unable to retrieve expected path trace from card>";
    public static final String REC_RETRIEVE_FAILURE = "<unable to retrieve received path trace from card>";
    public static final String TTI_SND_RETRIEVE_FAILURE = "<unable to retrieve transmit Trail Trace Identifier from card>";
    public static final String TTI_EXP_RETRIEVE_FAILURE = "<unable to retrieve expected Trail Trace Identifier from card>";
    public static final String TTI_REC_RETRIEVE_FAILURE = "<not available for current card state>";
    protected boolean dispTransmitAsString = true;
    protected boolean dispExpectedAsString = true;
    protected boolean dispReceivedAsString = true;
    protected char[] transmitBytes;
    protected char[] expectedBytes;
    protected char[] receivedBytes;
    boolean modeChanged = false;
    boolean disableAis = false;
    boolean disableMismatch = false;
    protected boolean resetToDefaults = false;
    protected boolean remainDirty = false;
    boolean[] isOptical;
    int[] transmitExpectState;
    String[] endpointType;
    INetCircuitEnd[] cktEnds;
    protected int oldState;
    protected int oldMismatchState;
    protected boolean disableMismatchStateChanged = false;
    protected IInterfaceModel[] ifModels;
    protected final boolean circuitLevel;
    protected INetCircuit netCircuit;
    protected INodeModel nodeModel;
    protected String[] portChoices;
    protected int currentSelectedIndex;
    JComboBox portBox;
    JRadioButton jn_16ByteRB;
    JRadioButton jn_64ByteRB;
    JComboBox traceModeBox;
    JCheckBox disableAisBox;
    private JButton refreshPB;
    private JRadioButton expAsciiRB;
    private JRadioButton expHexRB;
    JCheckBox disableMismatchBox;
    JTextArea transmitArea;
    JTextArea expectedArea;
    JTextArea receivedArea;
    JnTextField transmitField;
    JnTextField expectedField;
    JButton transmitButton;
    JButton expectedButton;
    JButton receivedButton;
    JButton factoryDefaultButton;
    JLabel expectedFieldLabel;
    JLabel receivedC2V5Label;
    JLabel expectedC2V5Label;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
    private JLabel refreshTimeLabel;
    Dimension fieldDim = new Dimension(400, 25);
    UScrollPane jsp1;
    UScrollPane jsp2;
    UScrollPane jsp3;
    protected IJTrace jTrace;
    private int jNum;
    private int curPathTraceFormat = -1;
    private static final int[] rates = new int[]{0, 5000, 15000, 30000, 60000, 180000, 300000};
    private static final String[] timerStrs = JnProvPane.getTimeStrings(rates);
    private JComboBox refreshComboBox;
    private JLabel refreshLabel;
    private Object timerLock = new Object();
    private Timer timer;
    private TimerListener timerListener = new TimerListener();
    private static final String autoRefreshPrefPath = "ctc";
    private static final String autoRefreshPrefKey = "Path-trace-auto-refresh-rate";
    private JPanel refreshPanel;
    private int numDelayedRefreshes = 0;
    private static final int DEFAULT_NUMBER_OF_DELAYS = 2;

    public static String[] getTimeStrings(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = nArray[i] / 1000;
            int n2 = n / 60;
            int n3 = n - n2 * 60;
            if (n2 > 0) {
                if (n2 > 1) {
                    stringBuffer.append(n2 + " Minutes");
                } else {
                    stringBuffer.append(n2 + " Minute");
                }
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
            }
            if (n3 > 0) {
                if (n3 > 1) {
                    stringBuffer.append(n3 + " Seconds");
                } else {
                    stringBuffer.append(n3 + " Second");
                }
            }
            if (stringBuffer.length() == 0) {
                stringBuffer.append("None");
            }
            stringArray[i] = stringBuffer.toString();
        }
        return stringArray;
    }

    public JnProvPane(int n, String string, INetCircuit iNetCircuit, IInterfaceModel[] iInterfaceModelArray, boolean[] blArray, int[] nArray, String[] stringArray, boolean bl, TabbedView tabbedView, INetCircuitEnd[] iNetCircuitEndArray) {
        super(string, (IModel)iInterfaceModelArray[0], tabbedView);
        this.refreshTimeLabel = new JLabel();
        this.netCircuit = iNetCircuit;
        this.jNum = n;
        this.setIfModels(iInterfaceModelArray);
        this.cktEnds = iNetCircuitEndArray;
        if (iNetCircuit.getPrimarySource() != null) {
            this.nodeModel = iNetCircuit.getPrimarySource().getNodeModel();
        } else {
            List list = iNetCircuit.getCircuitNodes();
            if (list.size() != 0) {
                this.nodeModel = ((INetCircuitNode)list.get(0)).getNodeModel();
            }
        }
        if (db.on()) {
            db.println("<init>( " + string + ", " + (iInterfaceModelArray != null ? iInterfaceModelArray[0].toString() : "null") + ", " + blArray[0] + ", " + nArray[0] + ", " + stringArray[0] + ", " + bl + ", " + tabbedView + " )");
        }
        this.circuitLevel = bl;
        this.factoryDefaultButton = new JButton("Default");
        this.factoryDefaultButton.addActionListener(this);
        this.factoryDefaultButton.setActionCommand(FACTORY_DEFAULT);
        this.addButton(this.factoryDefaultButton);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        if (n != 0) {
            if (n == 1) {
                this.jTrace = this.createJ1PathTrace(iNetCircuit, bl);
            } else if (n == 2) {
                this.jTrace = new J2PathTrace(iInterfaceModelArray, iNetCircuit, bl);
            } else if (n == 3) {
                this.jTrace = new TrailTraceIdentifier(iInterfaceModelArray, iNetCircuit, bl);
            }
        }
        this.registerForUpdates();
        this.isOptical = blArray;
        this.transmitExpectState = nArray;
        this.endpointType = stringArray;
        this.maxStringLength = n == 3 ? 62 : (this.nodeModel != null && (this.nodeModel.getTdmProtocolTypeObj().isSdh() || this.nodeModel.getTdmProtocolTypeObj().isSonet() && n == 2) ? 15 : 62);
        this.initContentPane();
    }

    protected void setIfModels(IInterfaceModel[] iInterfaceModelArray) {
        this.ifModels = iInterfaceModelArray;
    }

    protected IJTrace createJ1PathTrace(INetCircuit iNetCircuit, boolean bl) {
        return new J1PathTrace(this.ifModels, iNetCircuit, bl);
    }

    public boolean allowTransmit(int n) {
        if (this.jNum == 3) {
            return true;
        }
        return !this.isOptical[n] && (this.transmitExpectState[n] == 3 || this.transmitExpectState[n] == 1);
    }

    public boolean allowTransmit() {
        if (this.circuitLevel) {
            return true;
        }
        return this.allowTransmit(0);
    }

    public boolean allowExpect(int n) {
        return this.isOptical[n] || this.transmitExpectState[n] == 3 || this.transmitExpectState[n] == 2;
    }

    public boolean allowExpect() {
        if (this.circuitLevel) {
            return true;
        }
        return this.allowExpect(0);
    }

    public boolean allowReceived() {
        return !this.circuitLevel && this.allowExpect();
    }

    private boolean isPortOfEqType(int n) {
        if (this.cktEnds != null) {
            for (int i = 0; i < this.cktEnds.length; ++i) {
                try {
                    IEntityModel iEntityModel = this.cktEnds[i].getEntityModel();
                    if (iEntityModel instanceof IPortModel && iEntityModel.getEqType() == n) {
                        return true;
                    }
                    continue;
                }
                catch (ObjNotFound objNotFound) {
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
            }
        }
        return false;
    }

    private boolean is600() {
        return this.cktEnds[0].getNodeModel().getNeType().startsWith("15600");
    }

    protected boolean equipmentUsesAgereUltraMapper() {
        if (this.cktEnds != null) {
            for (int i = 0; i < this.cktEnds.length; ++i) {
                try {
                    if (!PathTraceUtil.allowsNullExpTrace(this.cktEnds[i].getEntityModel())) {
                        return true;
                    }
                    continue;
                }
                catch (ObjNotFound objNotFound) {
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
            }
        }
        return false;
    }

    protected JTextArea createTextArea() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Monospaced", 0, 12));
        jTextArea.setColumns(60);
        jTextArea.setRows(8);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setBackground(Color.lightGray);
        return jTextArea;
    }

    private JRadioButton makeButton(JPanel jPanel, ButtonGroup buttonGroup, String string) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        jPanel.add(jRadioButton);
        this.enableComponent(jRadioButton);
        return jRadioButton;
    }

    protected JComponent createPortPanel() {
        this.portChoices = new String[this.ifModels.length];
        boolean bl = false;
        for (int i = 0; i < this.ifModels.length; ++i) {
            try {
                this.portChoices[i] = PortHelper.getPortNumAndTypeString((IPortModel)this.ifModels[i].getPortModel(), (boolean)false, (boolean)false);
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (db.on()) {
                    db.println("Cannot find port model... trying from cktend");
                }
                try {
                    if (this.cktEnds.length > i) {
                        IEntityModel iEntityModel = this.cktEnds[i].getEntityModel();
                        if (!(iEntityModel instanceof IPortModel)) continue;
                        this.portChoices[i] = PortHelper.getPortNumAndTypeString((IPortModel)((IPortModel)iEntityModel), (boolean)false, (boolean)false);
                        if (!db.on()) continue;
                        db.println("success from cktEnd: port#" + this.portChoices[i]);
                        continue;
                    }
                    if (db.on()) {
                        db.println("failed to get port # from cktend;  index=" + i);
                    }
                    bl = true;
                    continue;
                }
                catch (ObjNotFound objNotFound) {
                    if (db.on()) {
                        db.println("failed to get port # from cktend.OBJ NOT FOUND");
                    }
                    bl = true;
                }
            }
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(new JLabel("Port: "));
        this.portBox = !bl ? new JComboBox<String>(this.portChoices) : new JComboBox();
        jPanel.add(this.portBox);
        this.portBox.setSelectedIndex(0);
        this.currentSelectedIndex = 0;
        return jPanel;
    }

    private Component createTraceModePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        if (this.jNum == 3) {
            jPanel.add(new JLabel("  Received Trace Mode: "));
        } else {
            jPanel.add(new JLabel("Path Trace Mode: "));
        }
        this.traceModeBox = !this.allowExpect() ? new JComboBox<String>(modeChoicesOnlyNone) : (this.circuitLevel || this.jTrace.providesAutoMode(0) ? new JComboBox<String>(modeChoices) : new JComboBox<String>(modeChoicesNoAuto));
        this.traceModeBox.addActionListener(this);
        this.traceModeBox.setActionCommand(TRACEMODE_COMMAND);
        jPanel.add(this.traceModeBox);
        return jPanel;
    }

    private Component createFormatAisC2Panel() {
        JPanel jPanel;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        if (this.supportsFormatChange()) {
            jPanel = new JPanel(new GridLayout(2, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(JN_STRINGSIZE));
            this.jn_16ByteRB = new JRadioButton(JN_STRINGSIZE_16);
            this.jn_64ByteRB = new JRadioButton(JN_STRINGSIZE_64);
            this.jn_16ByteRB.addActionListener(this);
            this.jn_16ByteRB.setActionCommand(JN_STRINGSIZE_16);
            if (this.jNum == 2) {
                this.enableComponent(this.jn_16ByteRB);
                this.jn_64ByteRB.setEnabled(false);
            } else {
                this.jn_64ByteRB.addActionListener(this);
                this.jn_64ByteRB.setActionCommand(JN_STRINGSIZE_64);
            }
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.jn_16ByteRB);
            buttonGroup.add(this.jn_64ByteRB);
            jPanel.add(this.jn_16ByteRB);
            jPanel.add(this.jn_64ByteRB);
            jPanel2.add((Component)jPanel, gridBagConstraints);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        if (this.supportsDisableAis() && (this.jTrace.providesNoAis() || PathTraceUtil.supportsC2Mismatch(this.ifModels[0]))) {
            jPanel = new JPanel(new GridLayout(2, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder("Alarm Action"));
            if (this.jTrace.providesNoAis()) {
                this.disableAisBox = new JCheckBox(this.jTrace.getDisableAisString());
                this.disableAisBox.addActionListener(this);
                this.disableAisBox.setActionCommand(this.jTrace.getDisableAisString());
                jPanel.add(this.disableAisBox);
            }
            if (PathTraceUtil.supportsC2Mismatch(this.ifModels[0])) {
                this.disableMismatchBox = new JCheckBox(this.jTrace.getDisableMismatchString());
                this.disableMismatchBox.addActionListener(this);
                this.disableMismatchBox.setActionCommand(this.jTrace.getDisableMismatchString());
                jPanel.add(this.disableMismatchBox);
            }
            jPanel2.add((Component)jPanel, gridBagConstraints);
        }
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel = new JPanel(new GridLayout(2, 0));
        if (this.jNum == 1) {
            jPanel.setBorder(BorderFactory.createTitledBorder("C2"));
            this.receivedC2V5Label = new JLabel(RECEIVED_C2);
        } else if (this.jNum == 2) {
            jPanel.setBorder(BorderFactory.createTitledBorder("V5"));
            this.receivedC2V5Label = new JLabel("Received " + this.nodeModel.getTDMTerminology().getGeneralTerms(1) + " Signal Label: ");
        }
        jPanel.add(this.receivedC2V5Label);
        if (!this.circuitLevel && PathTraceUtil.supportsC2Mismatch(this.ifModels[0])) {
            if (this.jNum == 1) {
                this.expectedC2V5Label = new JLabel(EXPECTED_C2);
            } else if (this.jNum == 2) {
                this.expectedC2V5Label = new JLabel("Expected " + this.nodeModel.getTDMTerminology().getGeneralTerms(1) + " Signal Label: ");
            }
            if (this.expectedC2V5Label != null) {
                jPanel.add(this.expectedC2V5Label);
            }
        }
        jPanel2.add((Component)jPanel, gridBagConstraints);
        return jPanel2;
    }

    private boolean supportsDisableAis() {
        return !this.isPortOfEqType(63) && !this.isPortOfEqType(105) && !this.isPortOfEqType(144) && !this.isPortOfEqType(231) && (!this.isPortOfEqType(165) || this.is600());
    }

    private Component createTransmitPanel() {
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Transmit"));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        if (!this.circuitLevel) {
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(new JLabel("Current Transmit String:"));
            this.transmitArea = this.createTextArea();
            this.jsp1 = new UScrollPane((Component)this.transmitArea);
            jPanel.add((Component)this.jsp1);
            this.transmitButton = new JButton(HEXMODE);
            this.transmitButton.addActionListener(this);
            this.transmitButton.setActionCommand(TRANSMIT_SWITCH);
            jPanel.add(this.transmitButton);
            jPanel2.add(jPanel);
        }
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel("New Transmit String: "), "West");
        this.transmitField = new JnTextField(this.maxStringLength);
        this.transmitField.setColumns(this.maxStringLength);
        this.transmitField.setSize(this.fieldDim);
        this.transmitField.setMinimumSize(this.fieldDim);
        this.transmitField.getDocument().addDocumentListener(this);
        jPanel.add((Component)this.transmitField, "Center");
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private Component createExpectedPanel() {
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Expected"));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        if (!this.circuitLevel) {
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(new JLabel("Current Expected String:"));
            this.expectedArea = this.createTextArea();
            this.jsp2 = new UScrollPane((Component)this.expectedArea);
            jPanel.add((Component)this.jsp2);
            this.expectedButton = new JButton(HEXMODE);
            this.expectedButton.addActionListener(this);
            this.expectedButton.setActionCommand(EXPECTED_SWITCH);
            jPanel.add(this.expectedButton);
            jPanel2.add(jPanel);
        }
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.expectedFieldLabel = new JLabel("New Expected String: ");
        jPanel.add((Component)this.expectedFieldLabel, "West");
        this.expectedField = this.jNum == 2 ? new JnTextField(this.maxStringLength) : new JnTextField(62);
        if (this.jNum == 3) {
            JPanel jPanel3 = new JPanel(new FlowLayout(0));
            jPanel3.add(new JLabel("Expected String Type:"));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.expAsciiRB = this.makeButton(jPanel3, buttonGroup, ASCII);
            this.expAsciiRB.setActionCommand(ASCII);
            this.expAsciiRB.setSelected(true);
            jPanel3.add(this.expAsciiRB);
            this.expHexRB = this.makeButton(jPanel3, buttonGroup, HEX);
            this.expHexRB.setActionCommand(HEX);
            jPanel3.add(this.expHexRB);
            jPanel2.add(jPanel3);
        }
        if (this.isSTM1EE4Mode()) {
            this.expectedField.setMaxLength(15);
        }
        this.expectedField.setColumns(this.maxStringLength);
        this.expectedField.getDocument().addDocumentListener(this);
        jPanel.add((Component)this.expectedField, "Center");
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private Component createReceivedPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Received"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel("Current Received String:"));
        this.receivedArea = this.createTextArea();
        this.jsp3 = new UScrollPane((Component)this.receivedArea);
        jPanel2.add((Component)this.jsp3);
        this.receivedButton = new JButton(HEXMODE);
        this.receivedButton.addActionListener(this);
        this.receivedButton.setActionCommand(RECEIVED_SWITCH);
        jPanel2.add(this.receivedButton);
        jPanel.add(jPanel2);
        this.refreshPB = new JButton(REFRESH);
        this.refreshPB.addActionListener(this);
        this.refreshPB.setActionCommand(REFRESH);
        this.refreshComboBox = new JComboBox<String>(timerStrs);
        this.refreshComboBox.addItemListener(new RefreshComboBoxListener());
        this.restoreAutoRefreshPref();
        this.refreshPanel = new JPanel();
        this.refreshPanel.setLayout(new FlowLayout(0, 0, 0));
        this.refreshPanel.add(this.refreshPB);
        this.refreshLabel = new JLabel("   Auto-refresh: ");
        this.refreshPanel.add(this.refreshLabel);
        this.refreshPanel.add(this.refreshComboBox);
        this.updateRefreshTime();
        this.refreshPanel.add(this.refreshTimeLabel);
        jPanel.add(this.refreshPanel);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private void updateRefreshTime() {
        String string = "    last refresh at " + dateFormat.format(new Date());
        this.refreshTimeLabel.setText(string);
    }

    public void initContentPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        if (this.jNum == 3) {
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(this.createPortPanel());
            jPanel3.add(this.createTraceModePanel());
            this.disableAisBox = new JCheckBox(TTI_DISABLE_FDI_OTN);
            this.disableAisBox.addActionListener(this);
            this.disableAisBox.setActionCommand(this.jTrace.getDisableAisString());
            jPanel3.add(this.disableAisBox);
            jPanel.add(jPanel3);
        } else {
            jPanel.add(this.createPortPanel());
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 0));
            jPanel4.add(this.createTraceModePanel());
            jPanel4.add(this.createFormatAisC2Panel());
            jPanel2.add(jPanel4);
        }
        if (this.allowTransmit()) {
            jPanel2.add(this.createTransmitPanel());
        }
        if (this.allowExpect()) {
            jPanel2.add(this.createExpectedPanel());
        }
        if (this.allowReceived()) {
            jPanel2.add(this.createReceivedPanel());
        }
        jPanel.add((Component)new UScrollPane((Component)jPanel2));
        this.add(jPanel);
        if (this.portChoices.length > 1 || this.jNum == 3) {
            this.enableComponent(this.portBox);
        } else {
            this.portBox.setEnabled(false);
        }
        this.enableComponent(this.traceModeBox);
        this.enableComponent(this.factoryDefaultButton);
        if (this.disableAisBox != null) {
            this.enableComponent(this.disableAisBox);
        }
        if (this.disableMismatchBox != null) {
            this.enableComponent(this.disableMismatchBox);
        }
        if (this.expectedField != null) {
            this.enableComponent(this.expectedField);
        }
        if (this.transmitField != null) {
            this.enableComponent(this.transmitField);
        }
        this.portBox.addActionListener(this);
        this.portBox.setActionCommand(PORT_COMMAND);
        this.refreshFromModel();
    }

    public void enableComponent(JComponent jComponent) {
        if (!this.circuitLevel && jComponent == this.disableAisBox) {
            if (this.jNum == 3) {
                jComponent.setEnabled(this.isUserAuthorized());
                return;
            }
            if (!this.jTrace.providesNoAis() || this.isOptical[0] || this.isADMGfp() || this.isPortOfEqType(165) && this.is600()) {
                jComponent.setEnabled(false);
                return;
            }
            if (!this.netCircuit.isBidirectional() && this.endpointType[0].equals("S")) {
                if (db.on()) {
                    db.println("Disable the 'disableAis' box since we're a non-optical on source end of a 1-way circuit");
                }
                jComponent.setEnabled(false);
                return;
            }
        }
        super.enableComponent(jComponent);
    }

    protected void nullify(JTextField jTextField) {
        if (jTextField != null) {
            jTextField.setText(new String(this.nullByteArray()));
        }
    }

    protected byte[] nullByteArray() {
        byte[] byArray = new byte[this.maxStringLength];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        return byArray;
    }

    public void updateDisplay(String string, boolean bl) {
        String string2;
        boolean bl2 = false;
        JTextArea jTextArea = null;
        UScrollPane uScrollPane = null;
        JButton jButton = null;
        char[] cArray = null;
        if (string.equals(TRANSMIT_SWITCH)) {
            bl2 = this.dispTransmitAsString;
            jTextArea = this.transmitArea;
            cArray = this.transmitBytes;
            jButton = this.transmitButton;
            uScrollPane = this.jsp1;
            string2 = new String(this.transmitBytes);
            if (string2.equals(SND_RETRIEVE_FAILURE) || string2.equals(TTI_SND_RETRIEVE_FAILURE)) {
                bl2 = true;
                bl = false;
                this.transmitButton.setEnabled(false);
            } else {
                this.enableComponent(this.transmitButton);
            }
        } else if (string.equals(EXPECTED_SWITCH)) {
            bl2 = this.dispExpectedAsString;
            jTextArea = this.expectedArea;
            cArray = this.expectedBytes;
            jButton = this.expectedButton;
            uScrollPane = this.jsp2;
            string2 = new String(this.expectedBytes);
            if (string2.equals(EXP_RETRIEVE_FAILURE) || string2.equals(TTI_EXP_RETRIEVE_FAILURE)) {
                bl2 = true;
                bl = false;
                this.expectedButton.setEnabled(false);
            } else {
                this.enableComponent(this.expectedButton);
            }
        } else if (string.equals(RECEIVED_SWITCH)) {
            bl2 = this.dispReceivedAsString;
            jTextArea = this.receivedArea;
            cArray = this.receivedBytes;
            jButton = this.receivedButton;
            uScrollPane = this.jsp3;
            string2 = new String(this.receivedBytes);
            if (string2.equals(REC_RETRIEVE_FAILURE) || string2.equals(TTI_REC_RETRIEVE_FAILURE)) {
                bl2 = true;
                bl = false;
                this.receivedButton.setEnabled(false);
            } else {
                this.enableComponent(this.receivedButton);
            }
        }
        if (uScrollPane == null) {
            return;
        }
        if (jTextArea != null && cArray != null) {
            string2 = new String(cArray);
            int n = string2.indexOf(0);
            if (n != -1) {
                cArray = string2.substring(0, n).toCharArray();
            }
            if (!bl2 && bl || bl2 && !bl) {
                jTextArea.setText(PathTraceUtil.bytesToString(cArray, 0));
                jButton.setText(HEXMODE);
            } else {
                jTextArea.setText(PathTraceUtil.bytesToString(cArray, 1));
                jButton.setText(ASCIIMODE);
                if (uScrollPane != null) {
                    uScrollPane.getViewport().setViewPosition(new Point(0, 0));
                }
            }
            if (bl) {
                if (string.equals(TRANSMIT_SWITCH)) {
                    this.dispTransmitAsString = !bl2;
                } else if (string.equals(EXPECTED_SWITCH)) {
                    this.dispExpectedAsString = !bl2;
                } else if (string.equals(RECEIVED_SWITCH)) {
                    this.dispReceivedAsString = !bl2;
                }
            }
        }
    }

    protected void setExpected(boolean bl) {
        if (this.expectedFieldLabel != null && this.expectedField != null) {
            if (!bl) {
                this.expectedFieldLabel.setEnabled(false);
                this.expectedField.setEnabled(false);
                this.expectedField.setText(null);
            } else {
                this.enableComponent(this.expectedFieldLabel);
                this.enableComponent(this.expectedField);
            }
        }
    }

    protected void displayPathTraceForSelectedPort() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(PORT_COMMAND)) {
            this.displayPathTraceForSelectedPort();
            return;
        }
        if (string.equals(TRACEMODE_COMMAND)) {
            this.modeChanged = true;
            String string2 = (String)this.traceModeBox.getSelectedItem();
            if (string2.equals(JN_AUTO)) {
                this.setExpected(false);
            } else {
                this.setExpected(true);
            }
            if (this.disableAisBox != null) {
                if (string2.equals(JN_OFF)) {
                    this.disableAisBox.setSelected(false);
                    this.disableAisBox.setEnabled(false);
                } else {
                    if (this.isOptical[0] || this.isADMGfp() || this.is600() && this.isPortOfEqType(165)) {
                        this.disableAisBox.setSelected(true);
                        this.disableAis = this.disableAisBox.isSelected();
                    }
                    this.enableComponent(this.disableAisBox);
                }
            }
        } else if (string.equals(this.jTrace.getDisableAisString()) && this.disableAisBox != null) {
            this.modeChanged = true;
            this.disableAis = this.disableAisBox.isSelected();
        } else if (string.equals(this.jTrace.getDisableMismatchString()) && this.disableMismatchBox != null) {
            this.disableMismatchStateChanged = true;
            this.disableMismatch = this.disableMismatchBox.isSelected();
        } else {
            if (string.equals(TRANSMIT_SWITCH)) {
                this.updateDisplay(TRANSMIT_SWITCH, true);
                return;
            }
            if (string.equals(EXPECTED_SWITCH)) {
                this.updateDisplay(EXPECTED_SWITCH, true);
                return;
            }
            if (string.equals(RECEIVED_SWITCH)) {
                this.updateDisplay(RECEIVED_SWITCH, true);
                return;
            }
            if (string.equals(FACTORY_DEFAULT)) {
                this.nullify(this.transmitField);
                this.nullify(this.expectedField);
                this.traceModeBox.setSelectedItem(JN_OFF);
                if (this.disableAisBox != null) {
                    this.disableAisBox.setSelected(false);
                    this.disableAisBox.setEnabled(false);
                }
                if (this.disableMismatchBox != null) {
                    this.disableMismatchBox.setSelected(false);
                }
                this.resetToDefaults = true;
            } else if (string.equals(JN_STRINGSIZE_16)) {
                if (this.allowTransmit()) {
                    if (this.netCircuit.isMemberOfVcat() && this.isPortOfEqType(144) && this.curPathTraceFormat == 0 && !CerentDialog.yesNoDialog((Component)((Object)this), (String)"Changing the transmit string size of one member will change the  \ntransmit string size of all members of the corresponding VCAT circuit.\n\nIs it OK to continue?", (String)"Change string format")) {
                        this.jn_64ByteRB.setSelected(true);
                        return;
                    }
                    this.transmitField.setMaxLength(15);
                }
                this.maxStringLength = 15;
            } else if (string.equals(JN_STRINGSIZE_64)) {
                if (this.allowTransmit()) {
                    if (this.netCircuit.isMemberOfVcat() && this.isPortOfEqType(144) && this.curPathTraceFormat == 1 && !CerentDialog.yesNoDialog((Component)((Object)this), (String)"Changing the transmit string size of one member will change the  \ntransmit string size of all members of the corresponding VCAT circuit.\n\nIs it OK to continue?", (String)"Change string format")) {
                        this.jn_16ByteRB.setSelected(true);
                        return;
                    }
                    this.transmitField.setMaxLength(62);
                }
                this.maxStringLength = 62;
            } else {
                if (string.equals(REFRESH)) {
                    this.updateDisplay(RECEIVED_SWITCH, false);
                    this.updateRefreshTime();
                    return;
                }
                if (string.equals(HEX) || string.equals(ASCII)) {
                    this.changeExpStringType(string);
                    return;
                }
            }
        }
        this.setDirty();
    }

    private void changeExpStringType(String string) {
        if (string.equals(HEX)) {
            if (this.expectedField != null) {
                this.expectedField.setType(HEX);
                this.expectedField.setMaxLength(2);
                this.maxStringLength = 2;
            }
        } else if (this.expectedField != null) {
            this.expectedField.setType(ASCII);
            this.expectedField.setMaxLength(62);
            this.maxStringLength = 62;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void applyChangesToModel() {
        int n;
        boolean bl;
        String string;
        int n2;
        String string2 = J1_TIM;
        if (this.jNum == 2) {
            string2 = J2_TIM;
        }
        boolean bl2 = true;
        if (this.equipmentUsesAgereUltraMapper() && (n2 = (string = (String)this.traceModeBox.getSelectedItem()).equals(JN_MANUAL)) != 0) {
            bl2 = false;
            bl = this.expectedField.getText().length() <= 0;
            n = 0;
            while (bl && n < this.expectedBytes.length) {
                bl = this.expectedBytes[n++] == '\u0000';
            }
            if (bl) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_PATHTRACE_NULL_EXPECTED_AND_MANUAL_MODE_UNSUPPORTED);
                this.remainDirty = true;
                return;
            }
        }
        if (this.resetToDefaults) {
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("The path trace fields have been reset to their factory defaults.\n" + string2 + "\n\nIs it OK to continue?"), (String)"Reset to Defaults")) {
                this.remainDirty = true;
                return;
            }
            this.resetToDefaults = false;
        }
        if (this.netCircuit.isMemberOfVcat() && this.isPortOfEqType(144)) {
            boolean bl3 = true;
            if (this.transmitField != null && this.transmitField.getText().length() > 0) {
                bl3 = CerentDialog.yesNoDialog((Component)((Object)this), (String)"Changing the transmit string of one member will change the  \ntransmit string of all members of the corresponding VCAT circuit.\nThis might cause a TIM-P to be raised, which can result in a loss of\nservice on the circuit.\n\n Is it OK to continue?", (String)"Apply changes");
            }
            if (!bl3) {
                this.remainDirty = true;
                return;
            }
        }
        int n3 = this.netCircuit.getCircuitDir();
        n2 = this.netCircuit.getDrops().size();
        bl = false;
        if (n3 == 0 && n2 > 1) {
            bl = true;
        }
        for (n = 0; n < this.jTrace.numModels(); ++n) {
            int n4;
            String string3 = (String)this.traceModeBox.getSelectedItem();
            boolean bl4 = false;
            if (this.modeChanged) {
                if (string3.equals(JN_OFF)) {
                    n4 = 0;
                    this.numDelayedRefreshes = 2;
                } else {
                    n4 = string3.equals(JN_AUTO) ? (this.disableAis ? 3 : 1) : (this.disableAis ? 4 : 2);
                }
                if (bl && (n4 != 0 || this.expectedField != null && this.expectedField.getText().length() > 0)) {
                    ErrorMsg.displayWarning((Component)((Object)this), (WID)NEMC.WID_APPLY_TO_ALL_DROPS);
                }
                if (this.circuitLevel && this.jTrace.providesAutoMode(n) || !this.circuitLevel && n4 != this.oldState) {
                    if (db.on()) {
                        db.println("Set state to: " + n4);
                    }
                    try {
                        if (!bl2) {
                            if (this.oldState != 3 && this.oldState != 1) {
                                this.setExpectedTrace(n);
                                bl4 = true;
                            } else if (db.on()) {
                                db.println("Setting mode first since we're still in AUTO mode.");
                            }
                        }
                        this.jTrace.setPathTraceMode(n, n4);
                    }
                    catch (UnsupportedOperation unsupportedOperation) {
                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_PATHTRACE_CHANGE_MODE_UNSUPPORTED);
                    }
                    catch (Exception exception) {
                        if (db.on()) {
                            db.println("EXCEPTION SETTING PATH STATE");
                        }
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                if (db.on()) {
                    db.println("\tSet state to: " + n4);
                }
                this.oldState = n4;
            }
            if (this.disableMismatchStateChanged) {
                n4 = this.disableMismatch ? 0 : 1;
                if (db.on()) {
                    db.println("Set mismatch state to: " + n4);
                }
                try {
                    this.jTrace.setPayloadMode(n, n4);
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("EXCEPTION SETTING PAYLOAD STATE");
                    }
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (this.supportsFormatChange()) {
                try {
                    if (this.jn_64ByteRB.isSelected()) {
                        this.jTrace.setPathTraceFormat(n, 0);
                        this.curPathTraceFormat = 0;
                    } else {
                        this.jTrace.setPathTraceFormat(n, 1);
                        this.curPathTraceFormat = 1;
                    }
                }
                catch (ProvisionError provisionError) {
                    if (provisionError.getEID().getId() == CEMC.EID_NOT_SUPPORTED_ON_PROTECT_ENTITY.getId()) {
                        ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_NOT_SUPPORTED_ON_PROTECT_ENTITY, (Object)((Object)provisionError));
                    } else {
                        ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_FAIL_APPLY_CHANGES, (Exception)((Object)provisionError));
                    }
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("EXCEPTION SETTING PATH TRACE FORMAT");
                    }
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (this.allowTransmit(n) && this.transmitField != null && this.transmitField.getText().length() > 0) {
                boolean bl5;
                if (this.transmitField.getText().length() > this.maxStringLength && (bl5 = CerentDialog.yesNoDialog((Component)((Object)this), (String)("The transmit field is too long. Is it OK to truncate it to: " + this.transmitField.getText().substring(0, this.maxStringLength) + "  ?"), (String)"Truncate String"))) {
                    this.transmitField.setText(this.transmitField.getText().substring(0, this.maxStringLength));
                }
                if (this.transmitField.getText().length() <= this.maxStringLength) {
                    if (db.on()) {
                        db.println("\tSet transmit to: " + this.transmitField.getText());
                    }
                    try {
                        this.jTrace.setSendPathTrace(n, this.transmitField.getText());
                        if (this.circuitLevel) {
                            this.transmitArea.setText(this.transmitField.getText());
                        }
                    }
                    catch (Exception exception) {
                        if (db.on()) {
                            db.println("EXCEPTION SETTING TRANSMIT TEXT");
                        }
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
            if (bl4) continue;
            this.setExpectedTrace(n);
        }
        this.remainDirty = false;
        this.modeChanged = false;
        this.disableMismatchStateChanged = false;
        if (this.transmitField != null) {
            this.transmitField.setText(null);
        }
        if (this.expectedField != null) {
            this.expectedField.setText(null);
        }
    }

    protected void setExpectedTrace(int n) {
        String string = (String)this.traceModeBox.getSelectedItem();
        if (this.allowExpect(n) && !string.equals(JN_AUTO) && this.expectedField != null && this.expectedField.getText().length() > 0) {
            String string2 = this.expectedField.getText();
            if (this.expectedField.getText().length() > 62) {
                boolean bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)("The expected field is too long. Is it OK to truncate it to: " + this.expectedField.getText().substring(0, 62) + "  ?"), (String)"Truncate String");
                if (bl) {
                    this.expectedField.setText(string2.substring(0, 62));
                } else {
                    this.expectedField.setText(string2);
                }
            }
            if (this.expectedField.getText().length() <= 62) {
                if (db.on()) {
                    db.println("\tSet expected to: " + this.expectedField.getText());
                }
                try {
                    this.jTrace.setExpectedPathTrace(n, this.expectedField.getText());
                    if (this.circuitLevel) {
                        this.expectedArea.setText(this.expectedField.getText());
                    }
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_PATHTRACE_NULL_EXPECTED_AND_MANUAL_MODE_UNSUPPORTED);
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("EXCEPTION SETTING EXPECTED TEXT");
                    }
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    public void refreshFromModel() {
        this.modeChanged = false;
        this.disableMismatchStateChanged = false;
        if (this.expectedField != null) {
            this.expectedField.setText(null);
        }
        if (this.transmitField != null) {
            this.transmitField.setText(null);
        }
        if (this.circuitLevel) {
            this.receivedC2V5Label.setText("");
        } else {
            try {
                byte by = this.jTrace.getExpectedPayloadLabel();
                if (this.expectedC2V5Label != null) {
                    if (this.jNum == 1) {
                        this.expectedC2V5Label.setText("Expected C2: 0x" + PathTraceUtil.hexFromByte((char)by));
                    } else if (this.jNum == 2) {
                        this.expectedC2V5Label.setText("Expected " + this.nodeModel.getTDMTerminology().getGeneralTerms(1) + " Signal Label: " + "0x" + PathTraceUtil.hexFromByte((char)by));
                    }
                }
                byte by2 = this.jTrace.getCurrentPayloadLabel();
                if (this.jNum == 1) {
                    this.receivedC2V5Label.setText("Received C2: 0x" + PathTraceUtil.hexFromByte((char)by2));
                } else if (this.jNum == 2) {
                    this.receivedC2V5Label.setText("Received " + this.nodeModel.getTDMTerminology().getGeneralTerms(1) + " Signal Label: " + "0x" + PathTraceUtil.hexFromByte((char)by2));
                }
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("failed to get payload code: " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
            if (this.allowTransmit()) {
                try {
                    this.transmitBytes = this.jTrace.getSendPathTrace();
                    if (db.on()) {
                        db.println("TRANSMITTED BYTES refresh: " + this.transmitBytes);
                    }
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("failed to get transmit path trace: " + exception);
                    }
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.updateDisplay(TRANSMIT_SWITCH, false);
            }
            if (this.allowExpect()) {
                try {
                    this.expectedBytes = this.jTrace.getExpectedPathTrace();
                    if (db.on()) {
                        db.println("EXPECTED BYTES refresh: " + this.expectedBytes);
                    }
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("failed to get expected path trace: " + exception);
                    }
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.updateDisplay(EXPECTED_SWITCH, false);
            }
            if (this.allowReceived()) {
                try {
                    this.receivedBytes = this.jTrace.getReceivedPathTrace();
                    if (db.on()) {
                        db.println("RECEIVED BYTES refresh: " + this.receivedBytes);
                    }
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("failed to get received path trace: " + exception);
                    }
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.updateDisplay(RECEIVED_SWITCH, false);
            }
            try {
                this.oldState = this.jTrace.getPathTraceMode();
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("failed to get path trace mode: " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
            if (this.supportsFormatChange()) {
                try {
                    if (this.jTrace.getPathTraceFormat() == 0) {
                        this.curPathTraceFormat = 0;
                        this.jn_64ByteRB.doClick();
                    } else {
                        this.curPathTraceFormat = 1;
                        this.jn_16ByteRB.doClick();
                    }
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("failed to get Path Trace Format: " + exception);
                    }
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        this.updateRefreshPanelToolTip();
        if (this.oldState == 0) {
            this.traceModeBox.setSelectedItem(JN_OFF);
            this.setExpected(true);
        } else if (this.oldState == 1 || this.oldState == 3) {
            this.traceModeBox.setSelectedItem(JN_AUTO);
            this.setExpected(false);
        } else {
            this.traceModeBox.setSelectedItem(JN_MANUAL);
            this.setExpected(true);
        }
        if (this.disableAisBox != null) {
            if (this.oldState == 3 || this.oldState == 4) {
                this.disableAisBox.setSelected(true);
                this.disableAis = true;
            } else {
                this.disableAisBox.setSelected(false);
                this.disableAis = false;
            }
        } else {
            this.disableAis = false;
        }
        if (this.disableMismatchBox != null) {
            if (this.circuitLevel) {
                this.disableMismatchBox.setSelected(false);
                this.disableMismatchStateChanged = true;
                this.disableMismatch = false;
            } else {
                try {
                    this.oldMismatchState = this.jTrace.getPayloadMode();
                }
                catch (Exception exception) {
                    db.fine("failed to get payload mode: " + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
                if (this.oldMismatchState == 1) {
                    this.disableMismatchBox.setSelected(false);
                    this.disableMismatch = false;
                } else {
                    this.disableMismatchBox.setSelected(true);
                    this.disableMismatch = true;
                }
            }
        }
        this.setDirty(false);
        if (!this.allowExpect() && this.oldState != 0) {
            CerentDialog.infoDialog((Component)((Object)this), (String)"This endpoint is transmit-only for path trace. The mode is being set to OFF/None\nbecause MANUAL and AUTO modes have no effect on transmit-only endpoints.", (String)"Forcing Path Trace Mode to OFF");
            this.traceModeBox.setSelectedItem(JN_OFF);
            this.setDirty(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (db.on()) {
            db.println("called destroy");
        }
        Object object = this.timerLock;
        synchronized (object) {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.timer = null;
        }
        this.saveAutoRefreshPref();
        this.deregisterForUpdates();
        super.destroy();
    }

    protected AbstractLeavePageException createLeavePageException(String string) {
        return new LeavePageException(string);
    }

    private void updateRefreshPanelToolTip() {
        String string = null;
        if (this.refreshPanel != null) {
            if (this.oldState == 0) {
                string = "Auto-refresh is disabled when the path trace mode is \"Off/None.\"";
            } else if (this.refreshComboBox != null && this.refreshComboBox.getSelectedIndex() == 0) {
                string = "Received Field will not auto-refresh when refresh interval is set to \"None.\"";
            }
            this.refreshPanel.setToolTipText(string);
            if (this.refreshComboBox != null) {
                this.refreshComboBox.setEnabled(this.oldState != 0);
            }
            if (this.refreshLabel != null) {
                this.refreshLabel.setEnabled(this.oldState != 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toggleTimer() {
        Object object = this.timerLock;
        synchronized (object) {
            if (!this.circuitLevel) {
                int n = this.refreshComboBox.getSelectedIndex();
                if (db.on()) {
                    db.println(this.getName() + "\tin toggleTimer(), idx=" + n);
                }
                if (n == 0) {
                    if (null != this.timer && this.timer.isRunning()) {
                        if (db.on()) {
                            db.println(this.getName() + " stop auto-ref timer.");
                        }
                        this.timer.stop();
                    }
                    this.timer = null;
                    this.timer = new Timer(rates[3], this.timerListener);
                    if (db.on()) {
                        db.println(this.getName() + " start auto-ref timer, " + "but index is 0");
                    }
                    this.timer.start();
                } else if (n > 0 && n < rates.length) {
                    if (null != this.timer) {
                        if (db.on()) {
                            db.println(this.getName() + " stop auto-ref timer.");
                        }
                        this.timer.stop();
                    }
                    this.timer = null;
                    this.timer = new Timer(rates[n], this.timerListener);
                    if (db.on()) {
                        db.println(this.getName() + " start auto-ref timer at " + "rate of " + rates[n]);
                    }
                    this.timer.start();
                } else {
                    if (db.on()) {
                        db.println(this.getName() + "bad... stop auto-ref timer!");
                    }
                    this.timer.stop();
                }
            }
        }
    }

    private void saveAutoRefreshPref() {
        if (null != this.refreshComboBox) {
            int n = this.refreshComboBox.getSelectedIndex();
            int n2 = rates[n];
            Preferences.instance().setInt(autoRefreshPrefPath, autoRefreshPrefKey, n2);
        }
    }

    private int getIndexForMillis(int n) {
        int n2 = 0;
        for (int i = 0; i < rates.length; ++i) {
            if (rates[i] != n) continue;
            n2 = i;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreAutoRefreshPref() {
        try {
            this.setCursor(3);
            int n = Preferences.instance().getInt(autoRefreshPrefPath, autoRefreshPrefKey, rates[1]);
            if (null != this.refreshComboBox) {
                int n2 = this.getIndexForMillis(n);
                this.refreshComboBox.setSelectedIndex(n2);
                this.toggleTimer();
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setCursor(0);
            throw throwable;
        }
        this.setCursor(0);
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("Got update: " + observable + " ARG: " + object);
        }
        super.update(observable, object);
    }

    public boolean queryRemainDirty() {
        return this.remainDirty;
    }

    private void registerForUpdates() {
        if (!this.circuitLevel) {
            for (int i = 0; i < this.ifModels.length; ++i) {
                this.ifModels[i].addObserver((Observer)((Object)this));
            }
        }
    }

    private void deregisterForUpdates() {
        for (int i = 0; i < this.ifModels.length; ++i) {
            this.ifModels[0].deleteObserver((Observer)((Object)this));
        }
    }

    protected boolean supportsFormatChange() {
        if (this.jNum == 3) {
            return false;
        }
        if ((this.isPortOfEqType(105) || this.isPortOfEqType(165)) && !this.netCircuit.getCircuitTypeObj().isHoCircuitType()) {
            return false;
        }
        if (this.isPortOfEqType(114) && !this.isOptical[0]) {
            return false;
        }
        return this.nodeModel != null && this.nodeModel.getTdmProtocolTypeObj().isSdh() && this.jTrace.providesCommonFeature() && this.allowTransmit();
    }

    private boolean isSTM1EE4Mode() {
        boolean bl = false;
        try {
            IInterfaceModel iInterfaceModel = this.ifModels[0];
            IModuleModel iModuleModel = iInterfaceModel.getPortModel().getModuleModel();
            int n = iModuleModel.getEqType();
            if (n == 113) {
                int n2 = iInterfaceModel.getPortModel().getPayloadType();
                bl = n2 == 15 || n2 == 16;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private boolean isADMGfp() {
        boolean bl = false;
        try {
            IInterfaceModel iInterfaceModel = this.ifModels[0];
            IPortModel iPortModel = iInterfaceModel.getPortModel();
            IModuleModel iModuleModel = iPortModel.getModuleModel();
            if (iModuleModel instanceof IDwdmModuleModel) {
                bl = ((IDwdmModuleModel)iModuleModel).isADMCard() && iPortModel.getEqType() == 186;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private boolean isADM10G() {
        boolean bl = false;
        try {
            IInterfaceModel iInterfaceModel = this.ifModels[0];
            IModuleModel iModuleModel = iInterfaceModel.getPortModel().getModuleModel();
            if (iModuleModel instanceof IDwdmModuleModel) {
                bl = ((IDwdmModuleModel)iModuleModel).isADMCard();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private class RefreshComboBoxListener
    implements ItemListener {
        private RefreshComboBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (1 == itemEvent.getStateChange()) {
                JnProvPane.this.toggleTimer();
                JnProvPane.this.updateRefreshPanelToolTip();
                JnProvPane.this.saveAutoRefreshPref();
            }
        }
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = JnProvPane.this.timerLock;
            synchronized (object) {
                boolean bl;
                block18: {
                    int n;
                    bl = true;
                    if (JnProvPane.this.numDelayedRefreshes > 0) {
                        bl = false;
                        JnProvPane.this.numDelayedRefreshes--;
                        if (db.on()) {
                            db.println(JnProvPane.this.getName() + "delayed refresh : " + JnProvPane.this.numDelayedRefreshes + " refreshes left.");
                        }
                    }
                    if (JnProvPane.this.oldState != 0 && JnProvPane.this.refreshComboBox != null && (n = JnProvPane.this.refreshComboBox.getSelectedIndex()) > 0) {
                        bl = false;
                    }
                    try {
                        if (!bl) {
                            if (db.on()) {
                                db.println(JnProvPane.this.getName() + "\tRefresh ex/rcv strings");
                            }
                            if (JnProvPane.this.allowExpect() && JnProvPane.this.expectedArea != null) {
                                JnProvPane.this.expectedBytes = JnProvPane.this.jTrace.getExpectedPathTrace();
                            }
                            JnProvPane.this.receivedBytes = JnProvPane.this.jTrace.getReceivedPathTrace();
                        }
                        if (db.on()) {
                            db.println(JnProvPane.this.getName() + "\tRefresh C2/V5");
                        }
                        n = JnProvPane.this.jTrace.getCurrentPayloadLabel();
                        if (JnProvPane.this.jNum == 1) {
                            JnProvPane.this.receivedC2V5Label.setText("Received C2: 0x" + PathTraceUtil.hexFromByte((char)n));
                        } else if (JnProvPane.this.jNum == 2) {
                            JnProvPane.this.receivedC2V5Label.setText("Received " + JnProvPane.this.nodeModel.getTDMTerminology().getGeneralTerms(1) + " Signal Label: " + "0x" + PathTraceUtil.hexFromByte((char)n));
                        } else if (JnProvPane.this.jNum == 3) {
                            JnProvPane.this.updateRefreshTime();
                        }
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block18;
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                if (!bl) {
                    JnProvPane.this.updateDisplay(JnProvPane.EXPECTED_SWITCH, false);
                    JnProvPane.this.updateDisplay(JnProvPane.RECEIVED_SWITCH, false);
                }
            }
        }
    }

    private class JnTextField
    extends JTextField {
        private String hexString = "0123456789abcdefABCDEF";
        private final int _ASCII = 0;
        private final int _HEX = 1;
        private int maxStringLength;
        private int fieldType;

        public JnTextField(int n) {
            this.maxStringLength = n;
            this.setColumns(this.maxStringLength);
            Dimension dimension = super.getPreferredSize();
            super.setMinimumSize(dimension);
            super.setMaximumSize(dimension);
        }

        public void setMaxLength(int n) {
            this.maxStringLength = n;
            if (this.getDocument().getLength() > this.maxStringLength) {
                this.setText(this.getText().substring(0, this.maxStringLength));
            }
        }

        public void setType(String string) {
            this.fieldType = string.equals(JnProvPane.HEX) ? 1 : 0;
        }

        protected Document createDefaultModel() {
            return new JnDocument();
        }

        private class JnDocument
        extends PlainDocument {
            private JnDocument() {
            }

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                int n2;
                if (string == null) {
                    return;
                }
                if (JnTextField.this.fieldType == 1 && !this.isValidHexString(string)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                int n3 = this.getLength();
                if (n3 + (n2 = string.length()) > JnTextField.this.maxStringLength) {
                    int n4 = JnTextField.this.maxStringLength - n3;
                    super.insertString(n, string.substring(0, n4), attributeSet);
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    super.insertString(n, string, attributeSet);
                }
            }

            private boolean isValidHexString(String string) {
                boolean bl = true;
                for (int i = 0; bl && i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (JnTextField.this.hexString.indexOf(c) != -1) continue;
                    bl = false;
                }
                return bl;
            }
        }
    }
}

